/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CustomImageHelper;
import oracle.bpm.ui.SVGImage;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.msg.UIMsg;
import oracle.tip.tools.ide.common.ui.imagebrowser.ImageBrowser;
import oracle.tip.tools.ide.common.ui.imagebrowser.ImageDataSource;
import oracle.tip.tools.ide.common.ui.imagebrowser.ImageInfo;

public class NodeCustomizationBrowser {
    private ArrayList<ImageInfo> list = new ArrayList();
    private static NodeCustomizationBrowser instance;

    private NodeCustomizationBrowser() {
        this.loadImages();
    }

    public static String browseForImages(UiComponent parent) {
        return NodeCustomizationBrowser.getInstance().doShow(parent);
    }

    public static NodeCustomizationBrowser getInstance() {
        if (instance == null) {
            instance = new NodeCustomizationBrowser();
        }
        return instance;
    }

    private void loadImages() {
        String[] customImages;
        for (String customImage : customImages = CustomImageHelper.getCustomImageList()) {
            try {
                if (Ui.supportsSVG()) {
                    this.list.add(new CustomSVGImageInfo(CustomImageHelper.getSVGCustomImageUrl((String)customImage), customImage));
                    continue;
                }
                this.list.add(new CustomImageInfo(CustomImageHelper.getCustomImageUrl((String)customImage), customImage));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private String doShow(UiComponent parent) {
        CustomImageInfo imageInfo;
        ImageBrowser browser;
        ImageDataSource dataSource = new ImageDataSource(){

            public List<ImageInfo> getImages() {
                return NodeCustomizationBrowser.this.list;
            }
        };
        JComponent component = parent.asSwing();
        Component root = SwingUtilities.getRoot(component);
        if (root instanceof JDialog) {
            browser = new ImageBrowser((JDialog)root, dataSource){
                private static final long serialVersionUID = 0L;

                protected Dimension getLayoutDimension() {
                    return new Dimension(470, 350);
                }
            };
        } else {
            JFrame frame = null;
            if (root instanceof JFrame) {
                frame = (JFrame)root;
            }
            browser = new ImageBrowser(frame, dataSource){
                private static final long serialVersionUID = 0L;

                protected Dimension getLayoutDimension() {
                    return new Dimension(470, 350);
                }
            };
        }
        String result = browser.display() == 1 ? ((imageInfo = (CustomImageInfo)browser.getSelection()) == null ? null : imageInfo.getImageId()) : null;
        return result;
    }

    private static class CustomSVGImageInfo
    extends CustomImageInfo {
        private Image awtImage;

        public CustomSVGImageInfo(URL url, String imageId) {
            super(url, imageId);
        }

        public Image getImage() {
            return this.loadImage();
        }

        public Image loadImage() {
            if (this.awtImage == null) {
                oracle.bpm.ui.Image image = SVGImage.create((URL)this.getURL());
                image.getScaledToFitInstance(40, 40);
                this.awtImage = image.asAwtImage();
            }
            return this.awtImage == null ? oracle.bpm.ui.Image.create((Msg)UIMsg.ERROR).asAwtImage() : this.awtImage;
        }
    }

    private static class CustomImageInfo
    extends ImageInfo {
        private String imageId;

        public CustomImageInfo(URL url, String imageId) {
            super(url);
            this.imageId = imageId;
        }

        public String getImageId() {
            return this.imageId;
        }
    }
}

