/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.adapter.AdapterService;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.BpaService;
import oracle.bpm.designer.CodeEditorService;
import oracle.bpm.designer.ExpressionBuilderService;
import oracle.bpm.designer.LifeCycleListener;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.TranslationService;
import oracle.bpm.designer.XSLTransformationService;
import oracle.bpm.designer.expression.ExpressionContainer;
import oracle.bpm.designer.flowpanels.DataAssociationsPanelOptions;
import oracle.bpm.designer.search.SearchQuery;
import oracle.bpm.designer.search.SearchService;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.execution.Interceptor;
import oracle.bpm.fusion.core.ProcessNode;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.fusion.studio.FusionCommandInterceptor;
import oracle.bpm.fusion.studio.NodeCustomizationBrowser;
import oracle.bpm.fusion.studio.Product;
import oracle.bpm.fusion.studio.TranslationServiceFactory;
import oracle.bpm.fusion.studio.codeeditor.FusionCodeEditor;
import oracle.bpm.fusion.studio.codeeditor.FusionDocument;
import oracle.bpm.fusion.studio.dataassociation.DataAssociationMapDialog;
import oracle.bpm.fusion.studio.editor.ProcessEditor;
import oracle.bpm.fusion.studio.expressionbuilder.SimpleExpressionBuilderPanel;
import oracle.bpm.fusion.studio.expressionbuilder.TextExpressionBuilderPanel;
import oracle.bpm.fusion.studio.expressionbuilder.XPathExpressionBuilderPanel;
import oracle.bpm.fusion.studio.expressionbuilder.XmlLiteralExpressionBuilderPanel;
import oracle.bpm.fusion.studio.simulation.SimulationView;
import oracle.bpm.fusion.ui.editor.FusionEditor;
import oracle.bpm.lang.Platform;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.DefaultSelectionProvider;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.tip.tools.ide.common.utils.PreviewUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionWorkbench
extends AbstractStudioWorkbench {
    private SelectionProvider editorAreaSelectionProvider;
    private Map<LifeCycleListener, EditorListener> lifeCycleListeners = new HashMap<LifeCycleListener, EditorListener>();
    private static final Predicate<Editor> FUSION_EDITOR_INSTANCE = PredicateUtils.instanceOf(FusionEditor.class);
    private static final Function<Editor, StudioEditor> FUSION_EDITOR_TO_STUDIO_EDITOR = new Function<Editor, StudioEditor>(){

        @Override
        public StudioEditor eval(Editor editor) {
            return ((FusionEditor)editor).getStudioEditor();
        }
    };

    public FusionWorkbench() {
        this.editorAreaSelectionProvider = new DefaultSelectionProvider();
        this.initSelectionListeners();
        System.setProperty("bpm.preview.mode", String.valueOf(this.isInPreviewMode()));
    }

    public void activateEditor(StudioEditor studioEditor) {
        Editor editor = FusionWorkbench.getEditor(studioEditor);
        if (editor != null) {
            editor.activate();
        }
    }

    public void addLifeCycleListener(LifeCycleListener listener) {
        LifeCycleAdapter editorListener = new LifeCycleAdapter(listener);
        this.lifeCycleListeners.put(listener, editorListener);
        FusionWorkbench.getEditorManager().addEditorListener((EditorListener)editorListener);
    }

    public boolean closeAllEditors() {
        EditorManager editorManager = FusionWorkbench.getEditorManager();
        List list = editorManager.getAllEditors();
        editorManager.closeEditors(list);
        return false;
    }

    public void closeEditor(StudioEditor studioEditor) {
        Editor editor = FusionWorkbench.getEditor(studioEditor);
        if (editor != null) {
            FusionWorkbench.getEditorManager().closeEditors(Collections.singletonList(editor));
        }
    }

    public void closeEditorAfterDelete(StudioEditor studioEditor) {
        Editor editor = FusionWorkbench.getEditor(studioEditor);
        if (editor != null) {
            Node node = editor.getContext().getNode();
            node.markDirty(false);
            FusionWorkbench.getEditorManager().closeEditors(Collections.singletonList(editor));
        }
    }

    public Dialog getDataAssociationMapDialog(@NotNull UiWindow parent, @NotNull DataAssociationEnabled dataAssociationEnabled, @NotNull DataAssociationsPanelOptions dataAssociationsPanelOptions) {
        return new DataAssociationMapDialog(parent, dataAssociationEnabled, dataAssociationsPanelOptions);
    }

    public StudioEditor createEditor(Class editorClass, Object input) {
        if (editorClass == null) {
            return null;
        }
        return this.instantiateEditor(editorClass, input, null);
    }

    @Nullable
    public StudioEditor getActiveEditor() {
        EditorManager editorManager = FusionWorkbench.getEditorManager();
        Editor editor = editorManager.getCurrentEditor();
        StudioEditor result = null;
        if (editor instanceof FusionEditor) {
            result = ((FusionEditor)editor).getStudioEditor();
        }
        return result;
    }

    public SelectionProvider getEditorAreaSelectionProvider() {
        return this.editorAreaSelectionProvider;
    }

    public SearchService getSearchService() {
        return new SearchService(){

            public void runQuery(SearchQuery query) {
            }
        };
    }

    @Nullable
    public TranslationService getTranslationService(UiContainer parent, Project project, String resourceBundleName) {
        return TranslationServiceFactory.getInstance().createTranslationService(parent, project, resourceBundleName);
    }

    public ExpressionBuilderService getExpressionBuilderService() {
        return new ExpressionBuilderService(){

            public ExpressionContainer createExpressionBuilder(@NotNull UiContainer parent, @NotNull ExpressionMode mode, @NotNull ExpressionContext context, Expression expression) {
                Object expressionBuilder = null;
                if (mode.equals(ExpressionMode.XPATH)) {
                    expressionBuilder = XPathExpressionBuilderPanel.create(context, expression);
                } else if (mode.equals(ExpressionMode.SIMPLE)) {
                    expressionBuilder = SimpleExpressionBuilderPanel.create(context, expression);
                } else if (mode.equals(ExpressionMode.TEXT)) {
                    expressionBuilder = TextExpressionBuilderPanel.create(parent, context);
                } else if (mode.equals(ExpressionMode.XML_LITERAL)) {
                    expressionBuilder = XmlLiteralExpressionBuilderPanel.create(parent, context);
                }
                return expressionBuilder;
            }
        };
    }

    @Nullable
    public StudioEditor getSelectedEditor() {
        return this.getActiveEditor();
    }

    public boolean isOpen(StudioEditor studioEditor) {
        Editor editor = FusionWorkbench.getEditor(studioEditor);
        return editor != null;
    }

    public void openEditor(StudioEditor studioEditor) {
        if (studioEditor != null) {
            Context otherContext = Context.newIdeContext();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(otherContext, FusionEditor.class);
            EditorManager editorManager = FusionWorkbench.getEditorManager();
            editorManager.openEditor(openEditorOptions);
        } else {
            System.out.println("FusionWorkbench.openEditor() StudioEditor is NULL");
        }
    }

    public StudioEditor openEditorForObject(Object object) {
        StudioEditor result = null;
        Object resource = object instanceof ProjectObject ? ((ProjectObject)object).findResourceObject() : object;
        Node node = this.findNode(resource);
        if (node != null) {
            Editor editor;
            if (node instanceof ProcessNode) {
                EditorManager em = EditorManager.getEditorManager();
                Context context = Context.newIdeContext((Node)node);
                editor = em.openEditorInFrame(ProcessEditor.class, context);
            } else {
                editor = EditorUtil.openDefaultEditorInFrame((URL)node.getURL());
            }
            if (editor instanceof StudioEditor) {
                result = (StudioEditor)editor;
            } else if (editor instanceof FusionEditor) {
                FusionEditor fusionEditor = (FusionEditor)editor;
                result = fusionEditor.getStudioEditor();
            }
        }
        return result;
    }

    public void openEditor(StudioEditor studioEditor, StudioEditor parent, int offset) {
        this.openEditor(studioEditor);
    }

    public void refreshTitle(StudioEditor studioEditor) {
    }

    public void removeLifeCycleListener(LifeCycleListener listener) {
        EditorListener editorListener = this.lifeCycleListeners.get(listener);
        if (editorListener != null) {
            FusionWorkbench.getEditorManager().addEditorListener(editorListener);
            this.lifeCycleListeners.remove(listener);
        }
    }

    public void showView(String viewId) {
    }

    public boolean isBusinessAnalyst() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        return Product.isBPMStudio() && !Boolean.getBoolean("fuego.fcp.full") || extensionRegistry.getRoleManager().getActiveRole().getId().equals("oracle.bpm.role");
    }

    public ProjectRepository createRepository() {
        return new FusionProjectRepository();
    }

    public XSLTransformationService getXSLTransformationService() {
        return null;
    }

    public BpaService getBpaService() {
        return null;
    }

    public void setFocusOnActiveEditor() {
    }

    public CodeEditorService getCodeEditorService() {
        return new CodeEditorService(){

            public CodeEditor getFusionCodeEditor(@NotNull ExpressionContext context, boolean isMultiLine) {
                return new FusionCodeEditor(context, isMultiLine);
            }

            public void setEditorContext(@NotNull CodeEditor codeEditor, @NotNull ExpressionContext context) {
                if (codeEditor instanceof FusionCodeEditor) {
                    FusionCodeEditor fusionCodeEditor = (FusionCodeEditor)codeEditor;
                    FusionDocument fusionDocument = fusionCodeEditor.getEditorDocument();
                    fusionDocument.setContext(context);
                }
            }
        };
    }

    public Interceptor getCommandInterceptor() {
        return new FusionCommandInterceptor();
    }

    public boolean isInPreviewMode() {
        return PreviewUtil.isInPreviewMode();
    }

    public BaseAction createGotoCompositeAction() {
        return null;
    }

    public String browseForImage(UiComponent parent) {
        return NodeCustomizationBrowser.browseForImages(parent);
    }

    public void activateSimulation(String simulationId) {
        DockStation dockStation = DockStation.getDockStation();
        SimulationView view = SimulationView.getInstance();
        dockStation.setDockableVisible((Dockable)view, true);
        dockStation.activateDockable((Dockable)view);
        view.activateSimulation(simulationId);
    }

    public Properties promptRoundTripConnection() {
        return null;
    }

    public StudioEditor createEditor(Class editorClass, Object input, ToolBar toolbar) {
        if (editorClass == null) {
            return null;
        }
        return this.instantiateEditor(editorClass, input, null, toolbar);
    }

    protected Sequence<StudioEditor> getAllEditors() {
        List editors = FusionWorkbench.getEditorManager().getAllEditors();
        return CollectionUtils.select(editors, FUSION_EDITOR_INSTANCE).map(FUSION_EDITOR_TO_STUDIO_EDITOR).select(PredicateUtils.notNull());
    }

    private static EditorManager getEditorManager() {
        return EditorManager.getEditorManager();
    }

    @Nullable
    private static Editor getEditor(StudioEditor studioEditor) {
        List editors = FusionWorkbench.getEditorManager().getAllEditors();
        for (Editor editor : editors) {
            StudioEditor currentEditor = FusionWorkbench.getStudioEditor(editor);
            if (currentEditor == null || !studioEditor.equals(currentEditor)) continue;
            return editor;
        }
        return null;
    }

    @Nullable
    private static StudioEditor getStudioEditor(Editor editor) {
        StudioEditor result = null;
        if (editor instanceof FusionEditor) {
            FusionEditor fcpEditor = (FusionEditor)editor;
            result = fcpEditor.getStudioEditor();
        }
        return result;
    }

    private Node findNode(Object object) {
        AdapterService service = Platform.getAdapterService();
        Node node = service.adaptTo(object, Node.class);
        URL url = service.adaptTo(object, URL.class);
        if (node != null && this.isUnrecognized(node)) {
            if (url == null) {
                url = node.getURL();
            }
            if (url != null) {
                try {
                    Node bpmNode = NodeFactory.findOrCreate((URL)url);
                    if (bpmNode != null && !this.isUnrecognized(bpmNode)) {
                        node = bpmNode;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (node == null) {
            try {
                node = NodeFactory.findOrCreate((URL)url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (node != null && node.getClass().getSimpleName().equals("WSDLArtifactNode")) {
            node = new ProjectObjectNode(url);
        }
        return node;
    }

    private boolean isUnrecognized(Node node) {
        return node.getClass().getSimpleName().equals("UnrecognizedTextNode");
    }

    private void initSelectionListeners() {
        final EditorManager editorManager = FusionWorkbench.getEditorManager();
        editorManager.addEditorListener(new EditorListener(){

            public void editorActivated(Editor editor) {
                this.editorOpened(editor);
            }

            public void editorDeactivated(Editor editor) {
            }

            public void editorClosed(Editor editor) {
                Editor current = editorManager.getCurrentEditor();
                if (current == null) {
                    Selection selection = DefaultSelection.EMPTY;
                    FusionWorkbench.this.getEditorAreaSelectionProvider().setSelection(selection);
                }
            }

            public void editorOpened(Editor editor) {
                Selection selection = DefaultSelection.createSingle((Object)editor.getContext().getNode());
                FusionWorkbench.this.getEditorAreaSelectionProvider().setSelection(selection);
            }
        });
    }

    private final class LifeCycleAdapter
    implements EditorListener {
        private final LifeCycleListener listener;

        private LifeCycleAdapter(LifeCycleListener listener) {
            this.listener = listener;
        }

        public void editorOpened(Editor editor) {
            StudioEditor studioEditor = FusionWorkbench.getStudioEditor(editor);
            if (studioEditor != null) {
                this.listener.editorOpened(studioEditor);
            }
        }

        public void editorClosed(Editor editor) {
            StudioEditor studioEditor = FusionWorkbench.getStudioEditor(editor);
            if (studioEditor != null) {
                this.listener.editorClosed(studioEditor);
            }
        }

        public void editorActivated(Editor editor) {
        }

        public void editorDeactivated(Editor editor) {
        }
    }
}

