/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio;

import java.net.URL;
import oracle.bpm.adapter.AdapterService;
import oracle.bpm.command.Command;
import oracle.bpm.execution.Executable;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.execution.Interceptor;
import oracle.bpm.execution.InterceptorChain;
import oracle.bpm.fusion.core.model.TreeNodeAdapter;
import oracle.bpm.fusion.studio.FusionCommand;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.DefaultProjectObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceFilesContainer;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;

class FusionCommandInterceptor
implements Interceptor {
    FusionCommandInterceptor() {
    }

    @Override
    public Object execute(Executable executable, InterceptorChain chain) throws ExecutionException {
        Command command = (Command)executable;
        CommandProcessor processor = CommandProcessor.getInstance();
        try {
            if (command instanceof FusionCommand.InternalCommand) {
                chain.proceed(command);
            } else {
                Context context = this.resolveContext(command);
                if (context != null) {
                    FusionCommand myCommand = new FusionCommand(chain, command, context);
                    processor.invoke((oracle.ide.controller.Command)myCommand);
                    Exception e = myCommand.getException();
                    if (e != null) {
                        throw e;
                    }
                } else {
                    chain.proceed(executable);
                }
            }
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        return null;
    }

    private Context resolveContext(Command command) {
        Object affectedObject = command.getAffectedObject();
        Context context = null;
        if (affectedObject instanceof ProjectObject) {
            ProjectObject projectObject;
            for (projectObject = (ProjectObject)affectedObject; projectObject != null && !(projectObject instanceof ResourceObject); projectObject = projectObject.getParentObject()) {
            }
            if (projectObject != null) {
                try {
                    URL url;
                    AdapterService service = Platform.getAdapterService();
                    Node node = service.adaptTo(projectObject, Node.class);
                    if (!(node != null || (url = service.adaptTo(projectObject, URL.class)) == null || ResourceFilesContainer.class.isAssignableFrom(projectObject.getClass()) || CatalogModule.class.isAssignableFrom(projectObject.getClass()) || (node = NodeFactory.findOrCreate((URL)url)) instanceof TreeNodeAdapter)) {
                        ((DefaultProjectObject)projectObject).addAdapter((Object)node);
                    }
                    if (node != null && !(node instanceof TreeNodeAdapter)) {
                        context = new Context();
                        context.setNode(node);
                    }
                }
                catch (IllegalAccessException e) {
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
            }
        }
        return context;
    }
}

