/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.execution.InterceptorChain;
import oracle.ide.Context;

class FusionCommand
extends oracle.ide.controller.Command {
    private final InterceptorChain chain;
    private final Command command;
    private Exception exception;
    private boolean executed;

    public FusionCommand(InterceptorChain chain, Command command, Context context) {
        super(0, 0, command.getName());
        this.chain = chain;
        this.command = command;
        this.setContext(context);
    }

    public boolean isGlobal() {
        return false;
    }

    public int doit() throws Exception {
        int result = 0;
        try {
            this.exception = null;
            if (this.executed) {
                ActionRunner.getInstance().run((Command)new RedoCommand());
            } else {
                this.executed = true;
                this.chain.proceed(this.command);
            }
        }
        catch (Exception e) {
            this.exception = e;
            result = 1;
        }
        return result;
    }

    public int undo() throws Exception {
        int result = 0;
        try {
            ActionRunner.getInstance().run((Command)new UndoCommand());
        }
        catch (Exception e) {
            result = 1;
        }
        return result;
    }

    public Exception getException() {
        return this.exception;
    }

    class UndoCommand
    extends InternalCommand {
        UndoCommand() {
        }

        @Override
        public void undo() {
        }

        @Override
        public Object execute() throws ExecutionException {
            try {
                FusionCommand.this.command.undo();
                return null;
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }

    class RedoCommand
    extends InternalCommand {
        RedoCommand() {
        }

        @Override
        public void undo() {
        }

        @Override
        public Object execute() throws ExecutionException {
            try {
                FusionCommand.this.command.execute();
                return null;
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }

    abstract class InternalCommand
    implements Command {
        InternalCommand() {
        }

        @Override
        public String getName() {
            return FusionCommand.this.getName();
        }

        @Override
        public Object getAffectedObject() {
            return FusionCommand.this.command.getAffectedObject();
        }
    }
}

