/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.tools;

import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.fabric.composite.CompositeDN;

public class ProcessInstanceValidationHelper {
    public static void validateErrorState(IProcessInstance processInstance) throws BPMException {
        if (ProcessInstanceValidationHelper.isInErrorState(processInstance)) {
            Object[] objs = new IProcessInstance[]{processInstance};
            throw new BPMException(70221, objs, null);
        }
    }

    public static void validateCompositeState(IProcessInstance processInstance) throws BPMException {
        if (ProcessInstanceValidationHelper.isCompositeNotAvailable(processInstance)) {
            Object[] objs = new IProcessInstance[]{processInstance};
            throw new BPMException(70222, objs, null);
        }
    }

    public static boolean isCompositeNotAvailable(IProcessInstance processInstance) {
        CompositeDN compositeDN = new CompositeDN(processInstance.getSca().getCompositeDN());
        String compositeDNnoLabel = compositeDN.getApplicationName() + '/' + compositeDN.getCompositeName() + '!' + compositeDN.getRevision();
        String state = BPMNServiceEngine.getInstance().getMesh().getComposite(compositeDNnoLabel).getState();
        return "off".equals(state) || "retired".equals(state);
    }

    public static boolean isInErrorState(IProcessInstance instance) {
        return "ERRORED".equals(instance.getSystemAttributes().getState());
    }
}

