/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.t2pmigration.test;

import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.common.impl.CommonUtil;
import oracle.bpel.services.workflow.user.impl.UserMetadataUtil;
import oracle.bpm.services.t2pmigration.data.ObjectFactory;
import oracle.bpm.services.t2pmigration.data.PrincipleListType;
import oracle.bpm.services.t2pmigration.data.UserApplicationData;
import oracle.bpm.services.t2pmigration.impl.Util;
import oracle.bpm.services.t2pmigration.test.T2PMigrationServiceTest;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class UserApplicationDataTest
extends TestCase {
    private static final String WIDGETSTRING = "BAM-WIDGET";
    protected static final String REALM = "jazn.com";
    private static ObjectFactory sT2PMigrationFactory = new ObjectFactory();
    private static final String widgetXML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<widget xmlns=\"http://xmlns.oracle.com/bpm/analytics/widget\">\n  <data>\n    <series id=\"10001\">\n      <dataSource>CubeWorkload</dataSource>\n      <measurement aggregateFunction=\"SUM\" variable=\"quantity\"/>\n      <dimensions>\n        <xSeries>activity</xSeries>\n      </dimensions>\n      <predicate />\n    </series>\n  </data>\n</widget>\n";

    public UserApplicationDataTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new T2PMigrationServiceTest("testBpm2PcbpelUserApplicationData"));
        suite.addTest((Test)new T2PMigrationServiceTest("testPcbpel2BpmUserApplicationData"));
        return suite;
    }

    public static void main(String[] args) {
        System.out.println("UserApplicationDataTest begins...");
        UserApplicationDataTest uadTest = new UserApplicationDataTest("UserApplicationDataTest");
        try {
            uadTest.testBpm2PcbpelUserApplicationData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            uadTest.testPcbpel2BpmUserApplicationData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("UserApplicationDataTest completed.");
    }

    public void testBpm2PcbpelUserApplicationData() throws Exception {
        System.out.println("testBpm2PcbpelUserApplicationData begins...");
        UserApplicationData bpmUAD = sT2PMigrationFactory.createUserApplicationData();
        bpmUAD.setName("testBpm2PcbpelUserApplicationData1");
        bpmUAD.setOwner("weblogic");
        bpmUAD.setIdentityContext(REALM);
        bpmUAD.setApplicationDataType(WIDGETSTRING);
        bpmUAD.setData(widgetXML);
        PrincipleListType grantees = sT2PMigrationFactory.createPrincipleListType();
        bpmUAD.setGrantees(grantees);
        oracle.bpel.services.workflow.user.model.UserApplicationData bpelUAD = Util.convertJaxb2_0ToJaxb1_0(bpmUAD);
        try {
            System.out.println("JAXB 1.0 Element (oracle.bpel.services.workflow.user.model.UserApplicationData) returned:");
            XMLElement appDataElem1_0 = ((JaxbNode)bpelUAD).getDOMNode();
            System.out.println(XMLUtil.toString((Node)appDataElem1_0));
        }
        catch (Exception e) {
            System.out.println("testBpm2PcbpelUserApplicationData failed.");
            e.printStackTrace();
            UserApplicationDataTest.assertNull((Object)e.toString());
        }
        System.out.println("testBpm2PcbpelUserApplicationData completed.");
    }

    public void testPcbpel2BpmUserApplicationData() throws Exception {
        System.out.println("testPcbpel2BpmUserApplicationData begins...");
        oracle.bpel.services.workflow.user.model.UserApplicationData bpelUAD = UserMetadataUtil.getFactory().createUserApplicationData();
        bpelUAD.setName("UserApplicationData1");
        bpelUAD.setOwner("weblogic");
        bpelUAD.setIdentityContext(REALM);
        bpelUAD.setApplicationDataType(WIDGETSTRING);
        bpelUAD.setData(widgetXML);
        oracle.bpel.services.workflow.common.model.PrincipleListType grantees = CommonUtil.getFactory().createPrincipleListType();
        bpelUAD.setGrantees(grantees);
        UserApplicationData bpmUAD = Util.convertJaxb1_0ToJaxb2_0(bpelUAD);
        try {
            System.out.println("JAXB 2.0 Element (oracle.bpm.services.t2pmigration.data.UserApplicationData) returned:");
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)bpmUAD, (OutputStream)System.out);
        }
        catch (Exception e) {
            System.out.println("testPcbpel2BpmUserApplicationData failed.");
            e.printStackTrace();
            UserApplicationDataTest.assertNull((Object)e.toString());
        }
        System.out.println("testPcbpel2BpmUserApplicationData completed.");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }
}

