/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.t2pmigration.test;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import oracle.bpel.services.workflow.test.TestUtil;
import oracle.bpel.services.workflow.test.servertest.ServerTestCase;
import oracle.bpm.services.organization.common.ObjectFactory;
import oracle.bpm.services.t2pmigration.config.EndPointType;
import oracle.bpm.services.t2pmigration.config.FileEndPointType;
import oracle.bpm.services.t2pmigration.config.GrantTypeEnum;
import oracle.bpm.services.t2pmigration.config.ObjectDetailsType;
import oracle.bpm.services.t2pmigration.config.ObjectTypeEnum;
import oracle.bpm.services.t2pmigration.config.OperationTypeEnum;
import oracle.bpm.services.t2pmigration.config.OrganizationType;
import oracle.bpm.services.t2pmigration.config.ServerEndPointType;
import oracle.bpm.services.t2pmigration.config.TestToProductionMigrationConfiguration;
import oracle.bpm.services.t2pmigration.config.UserApplicationDataOptionTypeEnum;
import oracle.bpm.services.t2pmigration.config.UserApplicationDataType;
import oracle.bpm.services.t2pmigration.impl.T2PMigrationService;
import oracle.bpm.services.t2pmigration.impl.Util;

public class T2PMigrationServiceTest
extends TestCase {
    private static oracle.bpm.services.t2pmigration.config.ObjectFactory sT2PMigrationConfigurationFactory = new oracle.bpm.services.t2pmigration.config.ObjectFactory();
    private static ObjectFactory sOrganizationCommonFactory = new ObjectFactory();
    protected static final String REALM = "jazn.com";
    protected static final String httpPortNumber = ServerTestCase.ejbServerUrl;

    public T2PMigrationServiceTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new T2PMigrationServiceTest("testExportOrganization"));
        suite.addTest((Test)new T2PMigrationServiceTest("testImportOrganization1"));
        suite.addTest((Test)new T2PMigrationServiceTest("testImportOrganization2"));
        suite.addTest((Test)new T2PMigrationServiceTest("testImportOrganization3"));
        suite.addTest((Test)new T2PMigrationServiceTest("testExportApplicationDataDashboard"));
        suite.addTest((Test)new T2PMigrationServiceTest("testImportApplicationDataDashboard"));
        suite.addTest((Test)new T2PMigrationServiceTest("testExportApplicationDataPageGrant"));
        suite.addTest((Test)new T2PMigrationServiceTest("testImportApplicationDataPageGrant"));
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)T2PMigrationServiceTest.suite());
    }

    public void testExportOrganization() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = sT2PMigrationConfigurationFactory.createTestToProductionMigrationConfiguration();
        EndPointType sourceEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        sourceEndPointType.setServerEndPoint(this.createServerEndPoint());
        EndPointType targetEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        targetEndPointType.setFileEndPoint(this.createTargetEndPoint("bpm_organization.xml"));
        testToProductionMigrationConfiguration.setSourceEndPoint(sourceEndPointType);
        testToProductionMigrationConfiguration.setTargetEndPoint(targetEndPointType);
        testToProductionMigrationConfiguration.setOperation(OperationTypeEnum.EXPORT);
        testToProductionMigrationConfiguration.getObject().add(ObjectTypeEnum.ORGANIZATION);
        OrganizationType organizationType = sT2PMigrationConfigurationFactory.createOrganizationType();
        ObjectDetailsType objectDetailsType = this.createObjectDetails();
        objectDetailsType.setOrganization(organizationType);
        testToProductionMigrationConfiguration.setObjectDetails(objectDetailsType);
        testToProductionMigrationConfiguration.setSkip(true);
        testToProductionMigrationConfiguration.setOverride(true);
        String outputFilePathName = File.separator + "tmp" + File.separator + "t2p_migration_config.xml";
        Util.exportTestToProductionMigrationConfiguration(testToProductionMigrationConfiguration, outputFilePathName);
        T2PMigrationService t2pMigrationService = new T2PMigrationService();
        t2pMigrationService.migrate(testToProductionMigrationConfiguration);
    }

    public void testImportOrganization1() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = sT2PMigrationConfigurationFactory.createTestToProductionMigrationConfiguration();
        EndPointType sourceEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        sourceEndPointType.setFileEndPoint(this.createTargetEndPoint("bpm_organization.xml"));
        EndPointType targetEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        targetEndPointType.setServerEndPoint(this.createServerEndPoint());
        testToProductionMigrationConfiguration.setSourceEndPoint(sourceEndPointType);
        testToProductionMigrationConfiguration.setTargetEndPoint(targetEndPointType);
        testToProductionMigrationConfiguration.setOperation(OperationTypeEnum.IMPORT);
        testToProductionMigrationConfiguration.getObject().add(ObjectTypeEnum.ORGANIZATION);
        OrganizationType organizationType = sT2PMigrationConfigurationFactory.createOrganizationType();
        ObjectDetailsType objectDetailsType = this.createObjectDetails();
        objectDetailsType.setOrganization(organizationType);
        testToProductionMigrationConfiguration.setObjectDetails(objectDetailsType);
        testToProductionMigrationConfiguration.setSkip(true);
        testToProductionMigrationConfiguration.setOverride(true);
        T2PMigrationService t2pMigrationService = new T2PMigrationService();
        t2pMigrationService.migrate(testToProductionMigrationConfiguration);
    }

    public void testImportOrganization2() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = sT2PMigrationConfigurationFactory.createTestToProductionMigrationConfiguration();
        EndPointType sourceEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        sourceEndPointType.setFileEndPoint(this.createTargetEndPoint("bpm_organization.xml"));
        EndPointType targetEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        targetEndPointType.setServerEndPoint(this.createServerEndPoint());
        testToProductionMigrationConfiguration.setSourceEndPoint(sourceEndPointType);
        testToProductionMigrationConfiguration.setTargetEndPoint(targetEndPointType);
        testToProductionMigrationConfiguration.setOperation(OperationTypeEnum.IMPORT);
        testToProductionMigrationConfiguration.getObject().add(ObjectTypeEnum.ORGANIZATION);
        OrganizationType organizationType = sT2PMigrationConfigurationFactory.createOrganizationType();
        organizationType.setUpdateExistingObjects(false);
        ObjectDetailsType objectDetailsType = this.createObjectDetails();
        objectDetailsType.setOrganization(organizationType);
        testToProductionMigrationConfiguration.setObjectDetails(objectDetailsType);
        testToProductionMigrationConfiguration.setSkip(true);
        testToProductionMigrationConfiguration.setOverride(true);
        T2PMigrationService t2pMigrationService = new T2PMigrationService();
        t2pMigrationService.migrate(testToProductionMigrationConfiguration);
    }

    public void testImportOrganization3() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = sT2PMigrationConfigurationFactory.createTestToProductionMigrationConfiguration();
        EndPointType sourceEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        sourceEndPointType.setFileEndPoint(this.createTargetEndPoint("bpm_organization.xml"));
        EndPointType targetEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        targetEndPointType.setServerEndPoint(this.createServerEndPoint());
        testToProductionMigrationConfiguration.setSourceEndPoint(sourceEndPointType);
        testToProductionMigrationConfiguration.setTargetEndPoint(targetEndPointType);
        testToProductionMigrationConfiguration.setOperation(OperationTypeEnum.IMPORT);
        testToProductionMigrationConfiguration.getObject().add(ObjectTypeEnum.ORGANIZATION);
        OrganizationType organizationType = sT2PMigrationConfigurationFactory.createOrganizationType();
        organizationType.setUpdateExistingObjects(true);
        ObjectDetailsType objectDetailsType = this.createObjectDetails();
        objectDetailsType.setOrganization(organizationType);
        testToProductionMigrationConfiguration.setObjectDetails(objectDetailsType);
        testToProductionMigrationConfiguration.setSkip(true);
        testToProductionMigrationConfiguration.setOverride(true);
        T2PMigrationService t2pMigrationService = new T2PMigrationService();
        t2pMigrationService.migrate(testToProductionMigrationConfiguration);
    }

    public void testExportApplicationDataDashboard() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        this.testExportApplicationData(false, false);
    }

    public void testExportApplicationDataPageGrant() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        this.testExportApplicationData(true, true);
    }

    public void testImportApplicationDataDashboard() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        this.testImportApplicationData(false, false);
    }

    public void testImportApplicationDataPageGrant() throws Exception {
        System.out.println("\n this.getName(): " + this.getName());
        this.testImportApplicationData(true, true);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void testExportApplicationData(boolean exportPage, boolean exportGrant) throws Exception {
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = sT2PMigrationConfigurationFactory.createTestToProductionMigrationConfiguration();
        EndPointType sourceEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        sourceEndPointType.setServerEndPoint(this.createServerEndPoint());
        EndPointType targetEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        targetEndPointType.setFileEndPoint(this.createTargetEndPoint("bpm_applicationData.xml"));
        testToProductionMigrationConfiguration.setSourceEndPoint(sourceEndPointType);
        testToProductionMigrationConfiguration.setTargetEndPoint(targetEndPointType);
        testToProductionMigrationConfiguration.setOperation(OperationTypeEnum.EXPORT);
        testToProductionMigrationConfiguration.getObject().add(ObjectTypeEnum.DASHBOARD);
        UserApplicationDataType userApplDataType = sT2PMigrationConfigurationFactory.createUserApplicationDataType();
        userApplDataType.setOwnerId("weblogic");
        if (exportPage) {
            userApplDataType.setOption(UserApplicationDataOptionTypeEnum.PAGE);
        } else {
            userApplDataType.setOption(UserApplicationDataOptionTypeEnum.DASHBOARD);
        }
        if (exportGrant) {
            userApplDataType.setGrant(GrantTypeEnum.WITHGRANT);
        } else {
            userApplDataType.setGrant(GrantTypeEnum.WITHOUTGRANT);
        }
        ObjectDetailsType objectDetailsType = this.createObjectDetails();
        objectDetailsType.setUserApplicationData(userApplDataType);
        testToProductionMigrationConfiguration.setObjectDetails(objectDetailsType);
        testToProductionMigrationConfiguration.setSkip(true);
        testToProductionMigrationConfiguration.setOverride(false);
        String outputFilePathName = File.separator + "tmp" + File.separator + "t2p_dashboard_migration_config.xml";
        Util.exportTestToProductionMigrationConfiguration(testToProductionMigrationConfiguration, outputFilePathName);
        T2PMigrationService t2pMigrationService = new T2PMigrationService();
        t2pMigrationService.migrate(testToProductionMigrationConfiguration);
    }

    private void testImportApplicationData(boolean exportPage, boolean exportGrant) throws Exception {
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = sT2PMigrationConfigurationFactory.createTestToProductionMigrationConfiguration();
        EndPointType sourceEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        sourceEndPointType.setFileEndPoint(this.createTargetEndPoint("bpm_applicationData.xml"));
        EndPointType targetEndPointType = sT2PMigrationConfigurationFactory.createEndPointType();
        targetEndPointType.setServerEndPoint(this.createServerEndPoint());
        testToProductionMigrationConfiguration.setSourceEndPoint(sourceEndPointType);
        testToProductionMigrationConfiguration.setTargetEndPoint(targetEndPointType);
        testToProductionMigrationConfiguration.setOperation(OperationTypeEnum.IMPORT);
        testToProductionMigrationConfiguration.getObject().add(ObjectTypeEnum.DASHBOARD);
        UserApplicationDataType userApplDataType = sT2PMigrationConfigurationFactory.createUserApplicationDataType();
        if (exportPage) {
            userApplDataType.setOption(UserApplicationDataOptionTypeEnum.PAGE);
        } else {
            userApplDataType.setOption(UserApplicationDataOptionTypeEnum.DASHBOARD);
        }
        if (exportGrant) {
            userApplDataType.setGrant(GrantTypeEnum.WITHGRANT);
        } else {
            userApplDataType.setGrant(GrantTypeEnum.WITHOUTGRANT);
        }
        ObjectDetailsType objectDetailsType = this.createObjectDetails();
        objectDetailsType.setUserApplicationData(userApplDataType);
        testToProductionMigrationConfiguration.setObjectDetails(objectDetailsType);
        testToProductionMigrationConfiguration.setSkip(true);
        testToProductionMigrationConfiguration.setOverride(false);
        T2PMigrationService t2pMigrationService = new T2PMigrationService();
        t2pMigrationService.migrate(testToProductionMigrationConfiguration);
    }

    private ObjectDetailsType createObjectDetails() {
        ObjectDetailsType objectDetailsType = sT2PMigrationConfigurationFactory.createObjectDetailsType();
        objectDetailsType.setLogin("weblogic");
        objectDetailsType.setPassword("weblogic1");
        objectDetailsType.setIdentityContext(REALM);
        return objectDetailsType;
    }

    private ServerEndPointType createServerEndPoint() {
        ServerEndPointType serverEndPointType = sT2PMigrationConfigurationFactory.createServerEndPointType();
        serverEndPointType.setServerURL(TestUtil.getWFEJBURL());
        serverEndPointType.setAdminUserLogin(TestUtil.getEJBUser());
        serverEndPointType.setAdminUserPassword(TestUtil.getEJBCred());
        serverEndPointType.setRealm(REALM);
        return serverEndPointType;
    }

    private FileEndPointType createTargetEndPoint(String fileName) {
        FileEndPointType fileEndPointType = sT2PMigrationConfigurationFactory.createFileEndPointType();
        fileEndPointType.setMigrationFile(File.separator + "tmp" + File.separator + fileName);
        return fileEndPointType;
    }
}

