/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.t2pmigration.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.Jaxb20ContextFactory;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.user.impl.UserMetadataUtil;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.model.Organization;
import oracle.bpm.services.t2pmigration.config.EndPointType;
import oracle.bpm.services.t2pmigration.config.FileEndPointType;
import oracle.bpm.services.t2pmigration.config.ObjectDetailsType;
import oracle.bpm.services.t2pmigration.config.ObjectTypeEnum;
import oracle.bpm.services.t2pmigration.config.OperationTypeEnum;
import oracle.bpm.services.t2pmigration.config.ServerEndPointType;
import oracle.bpm.services.t2pmigration.config.TestToProductionMigrationConfiguration;
import oracle.bpm.services.t2pmigration.data.BpmUserConfigurableData;
import oracle.bpm.services.t2pmigration.data.ObjectFactory;
import oracle.bpm.services.t2pmigration.data.ParticipantTypeEnum;
import oracle.bpm.services.t2pmigration.data.PrincipleRefType;
import oracle.bpm.services.t2pmigration.data.UserApplicationData;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Util {
    private static final String PAGENAME = "WAM";
    private static final int EXISTERROR = -1;
    private static final int NOTEXIST = 0;
    private static final int EXIST = 1;
    private static final int DUPLICATE = 2;
    private static String defaultKey = "1367821351652715";
    private static final String RESET_PASSWORD = null;
    private static final String MASKED_PASSWORD = "**MASKED PASSWORD**";

    public static BPMServiceClientFactory getBPMServiceClientFactory(String serverURL, String adminUserLogin, String adminUserPassword) {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        if (serverURL != null && serverURL.length() > 0) {
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, serverURL);
        }
        if (adminUserLogin != null && adminUserLogin.length() > 0) {
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_PRINCIPAL, adminUserLogin);
        }
        if (adminUserPassword != null && adminUserPassword.length() > 0) {
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_CREDENTIALS, adminUserPassword);
        }
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        BPMServiceClientFactory bpmServiceClientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
        return bpmServiceClientFactory;
    }

    public static IBPMServiceClient getServiceClientConnection(BPMServiceClientFactory bpmServiceClientFactory) {
        if (bpmServiceClientFactory == null) {
            System.out.println(" getServiceClientConnection() - BPM service client factory is null.");
            return null;
        }
        return bpmServiceClientFactory.getBPMServiceClient();
    }

    public static IBPMContext getContext(BPMServiceClientFactory bpmServiceClientFactory, String user, String password, String realm) throws Exception {
        if (bpmServiceClientFactory == null) {
            System.out.println(" getContext() - BPM service client factory is null.");
            return null;
        }
        if (bpmServiceClientFactory.getBPMUserAuthenticationService() == null) {
            System.out.println(" getContext() - BPM User Authentication Service is null.");
            return null;
        }
        return bpmServiceClientFactory.getBPMUserAuthenticationService().authenticate(user, password.toCharArray(), realm);
    }

    public static void destroyContext(BPMServiceClientFactory bpmServiceClientFactory, IBPMContext bpmContext) throws Exception {
        if (bpmServiceClientFactory == null) {
            System.out.println(" destroyContext() - BPM service client factory is null.");
            return;
        }
        if (bpmContext == null) {
            System.out.println(" destroyContext() - BPM context is null.");
            return;
        }
        if (bpmServiceClientFactory.getBPMUserAuthenticationService() == null) {
            System.out.println(" destroyContext() - BPM User Authentication Service is null.");
            return;
        }
        bpmServiceClientFactory.getBPMUserAuthenticationService().destroyBPMContext(bpmContext);
    }

    public static IBPMUserAuthenticationService getBPMUserAuthenticationService(BPMServiceClientFactory bpmServiceClientFactory) {
        if (bpmServiceClientFactory == null) {
            System.out.println(" getBPMUserAuthenticationService() - BPM service client factory is null.");
            return null;
        }
        return bpmServiceClientFactory.getBPMUserAuthenticationService();
    }

    public static IBPMOrganizationService getOrganizationService(IBPMServiceClient serviceClient) {
        IBPMOrganizationService organizationService = null;
        if (serviceClient != null) {
            organizationService = serviceClient.getBPMOrganizationService();
        }
        return organizationService;
    }

    public static void exportTestToProductionMigrationConfiguration(TestToProductionMigrationConfiguration testToProductionMigrationConfiguration, String outputFilePathName) throws Exception {
        if (testToProductionMigrationConfiguration == null) {
            throw new Exception(" testToProductionMigrationConfiguration is null");
        }
        if (outputFilePathName == null || outputFilePathName.length() <= 0) {
            throw new Exception(" outputFilePathName is null or empty");
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{oracle.bpm.services.t2pmigration.config.ObjectFactory.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileOutputStream outputFile = new FileOutputStream(new File(outputFilePathName));
        m.marshal((Object)testToProductionMigrationConfiguration, (OutputStream)outputFile);
    }

    public static void exportBpmUserConfigurableData(BpmUserConfigurableData bpmUserConfigurableData, String filePathName) throws Exception {
        if (bpmUserConfigurableData == null) {
            throw new Exception(" bpmUserConfigurableData is null");
        }
        if (filePathName == null || filePathName.length() <= 0) {
            throw new Exception(" filePathName is null or empty");
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        FileOutputStream outputFile = new FileOutputStream(new File(filePathName));
        m.marshal((Object)bpmUserConfigurableData, (OutputStream)outputFile);
    }

    public static BpmUserConfigurableData importBpmUserConfigurableData(String filePathName) throws Exception {
        if (filePathName == null || filePathName.length() <= 0) {
            throw new Exception(" filePathName is null or empty");
        }
        BpmUserConfigurableData bpmUserConfigurableData = null;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller um = context.createUnmarshaller();
        bpmUserConfigurableData = (BpmUserConfigurableData)um.unmarshal((InputStream)new FileInputStream(filePathName));
        return bpmUserConfigurableData;
    }

    public static TestToProductionMigrationConfiguration parseTestToProductionMigrationConfigurationFile(String filePathName, boolean promptPassword) throws Exception {
        if (filePathName == null || filePathName.trim().isEmpty()) {
            throw new Exception(" filePathName is null or empty.");
        }
        TestToProductionMigrationConfiguration migrateConfig = null;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{oracle.bpm.services.t2pmigration.config.ObjectFactory.class});
        Unmarshaller um = context.createUnmarshaller();
        migrateConfig = (TestToProductionMigrationConfiguration)um.unmarshal((InputStream)new FileInputStream(filePathName));
        if (migrateConfig == null) {
            throw new Exception(" testToProductionMigrationConfiguration is null.");
        }
        if (promptPassword) {
            System.out.println(" Password prompt feature disabled.");
        }
        if (Util.isEncrypted(migrateConfig)) {
            Util.decrypt(migrateConfig);
        }
        return migrateConfig;
    }

    public static void displayTestToProductionMigrationConfiguration(TestToProductionMigrationConfiguration testToProductionMigrationConfiguration) {
        System.out.println(" displayTestToProductionMigrationConfiguration()");
        if (testToProductionMigrationConfiguration == null) {
            System.out.println(" testToProductionMigrationConfiguration is null");
        } else {
            EndPointType source = testToProductionMigrationConfiguration.getSourceEndPoint();
            Util.displayEndPointType(source);
            EndPointType target = testToProductionMigrationConfiguration.getTargetEndPoint();
            Util.displayEndPointType(target);
            OperationTypeEnum operationType = testToProductionMigrationConfiguration.getOperation();
            System.out.println("\n operationType.toString(): " + operationType.toString());
            List objectTypeList = testToProductionMigrationConfiguration.getObject();
            Util.displayObjectTypeList(objectTypeList);
            ObjectDetailsType objectDetailsType = testToProductionMigrationConfiguration.getObjectDetails();
            Util.displayObjectDetailsType(objectDetailsType);
            System.out.println("\n testToProductionMigrationConfiguration.isSkip(): " + testToProductionMigrationConfiguration.isSkip());
            System.out.println(" testToProductionMigrationConfiguration.isOverride(): " + testToProductionMigrationConfiguration.isOverride());
            System.out.println("");
        }
    }

    public static void displayEndPointType(EndPointType endPointType) {
        System.out.println(" displayEndPointType()");
        if (endPointType == null) {
            System.out.println(" endPointType is null");
        } else {
            FileEndPointType fileEndPointType;
            ServerEndPointType serverEndPointType = endPointType.getServerEndPoint();
            if (serverEndPointType != null) {
                Util.displayServerEndPointType(serverEndPointType);
            }
            if ((fileEndPointType = endPointType.getFileEndPoint()) != null) {
                Util.displayFileEndPointType(fileEndPointType);
            }
        }
        System.out.println("");
    }

    public static void displayServerEndPointType(ServerEndPointType serverEndPointType) {
        System.out.println(" displayServerEndPointType()");
        if (serverEndPointType == null) {
            System.out.println(" serverEndPointType is null");
        } else {
            System.out.println(" serverEndPointType.getServerURL(): " + serverEndPointType.getServerURL());
            System.out.println(" serverEndPointType.getAdminUserLogin(): " + serverEndPointType.getAdminUserLogin());
            if (serverEndPointType.getAdminUserPassword() != null && !serverEndPointType.getAdminUserPassword().trim().isEmpty()) {
                System.out.println(" serverEndPointType.getAdminUserPassword(): **MASKED PASSWORD**");
            }
            if (serverEndPointType.getEncryptedAdminUserPassword() != null && !serverEndPointType.getEncryptedAdminUserPassword().trim().isEmpty()) {
                System.out.println(" serverEndPointType.getEncryptedAdminUserPassword(): **MASKED PASSWORD**");
            }
            System.out.println(" serverEndPointType.getRealm(): " + serverEndPointType.getRealm());
        }
    }

    public static void displayFileEndPointType(FileEndPointType fileEndPointType) {
        System.out.println(" displayFileEndPointType()");
        if (fileEndPointType == null) {
            System.out.println(" fileEndPointType is null");
        } else {
            System.out.println("\n fileEndPointType.getMigrationFile(): " + fileEndPointType.getMigrationFile());
        }
    }

    public static void displayObjectTypeList(List<ObjectTypeEnum> objectTypeList) {
        System.out.println(" displayObjectTypeList()");
        if (objectTypeList == null) {
            System.out.println(" objectTypeList is null");
        } else if (objectTypeList.isEmpty()) {
            System.out.println(" objectTypeList is empty");
        } else {
            System.out.println(" objectTypeList.size(): " + objectTypeList.size());
            for (int i = 0; i < objectTypeList.size(); ++i) {
                ObjectTypeEnum objectType = objectTypeList.get(i);
                System.out.println(" (" + i + ") objectType: " + objectType);
            }
        }
    }

    public static void displayObjectDetailsType(ObjectDetailsType objectDetailsType) {
        System.out.println(" displayObjectDetailsType()");
        if (objectDetailsType == null) {
            System.out.println(" objectDetailsType is null");
        } else {
            System.out.println(" objectDetailsType.getLogin(): " + objectDetailsType.getLogin());
            System.out.println(" objectDetailsType.getIdentityContext(): " + objectDetailsType.getIdentityContext());
            if (objectDetailsType.getPassword() != null && !objectDetailsType.getPassword().trim().isEmpty()) {
                System.out.println(" objectDetailsType.getPassword(): **MASKED PASSWORD**");
            }
            if (objectDetailsType.getEncryptedPassword() != null && !objectDetailsType.getEncryptedPassword().trim().isEmpty()) {
                System.out.println(" objectDetailsType.getEncryptedPassword(): **MASKED PASSWORD**");
            }
            if (objectDetailsType.getBPMContext() != null && objectDetailsType.getBPMContext().getCredential() != null) {
                System.out.println(" objectDetailsType.getBPMContext().getCredential().getLogin(): " + objectDetailsType.getBPMContext().getCredential().getLogin());
                System.out.println(" objectDetailsType.getBPMContext().getCredential().getIdentityContext(): " + objectDetailsType.getBPMContext().getCredential().getIdentityContext());
                if (objectDetailsType.getBPMContext().getCredential().getPassword() != null && !objectDetailsType.getBPMContext().getCredential().getPassword().trim().isEmpty()) {
                    System.out.println(" objectDetailsType.getBPMContext().getCredential().getPassword(): **MASKED PASSWORD**");
                }
            }
            if (objectDetailsType.getApplicationRole() != null) {
                System.out.println(" objectDetailsType.getApplicationRole().getApplicationRoleName(): " + objectDetailsType.getApplicationRole().getApplicationRoleName());
            }
            if (objectDetailsType.getCalendarRule() != null) {
                System.out.println(" objectDetailsType.getCalendarRule().getName(): " + objectDetailsType.getCalendarRule().getName());
            }
            if (objectDetailsType.getHolidayRule() != null) {
                System.out.println(" objectDetailsType.getHolidayRule().getName(): " + objectDetailsType.getHolidayRule().getName());
            }
            if (objectDetailsType.getLogicalPeopleGroup() != null) {
                System.out.println(" objectDetailsType.getLogicalPeopleGroup().getName(): " + objectDetailsType.getLogicalPeopleGroup().getName());
            }
            if (objectDetailsType.getOrganization() != null) {
                System.out.println(" objectDetailsType.getOrganization().getName(): " + objectDetailsType.getOrganization().getName());
                if (objectDetailsType.getOrganization().isSetUpdateExistingObjects()) {
                    System.out.println(" objectDetailsType.getOrganization().isUpdateExistingObjects(): " + objectDetailsType.getOrganization().isUpdateExistingObjects());
                }
            }
            if (objectDetailsType.getOrganizationalUnit() != null) {
                System.out.println(" objectDetailsType.getOrganizationalUnit().getOrganizationalUnitName(): " + objectDetailsType.getOrganizationalUnit().getOrganizationalUnitName());
            }
            if (objectDetailsType.getParticipantProperty() != null) {
                System.out.println(" objectDetailsType.getParticipantProperty().getName(): " + objectDetailsType.getParticipantProperty().getName());
            }
            if (objectDetailsType.getUserApplicationData() != null) {
                if (objectDetailsType.getUserApplicationData().isSetOwnerId()) {
                    System.out.println(" objectDetailsType.getUserApplicationData().getOwnerId(): " + objectDetailsType.getUserApplicationData().getOwnerId());
                }
                if (objectDetailsType.getUserApplicationData().isSetOption()) {
                    System.out.println(" objectDetailsType.getUserApplicationData().getOption(): " + objectDetailsType.getUserApplicationData().getOption().value());
                }
                if (objectDetailsType.getUserApplicationData().isSetGrant()) {
                    System.out.println(" objectDetailsType.getUserApplicationData().getGrant(): " + objectDetailsType.getUserApplicationData().getGrant().value());
                }
                if (objectDetailsType.getUserApplicationData().isSetGrantees()) {
                    System.out.println(" objectDetailsType.getUserApplicationData().getGrantees().getParticipant() size [" + objectDetailsType.getUserApplicationData().getGrantees().getParticipant().size() + "]");
                    for (oracle.bpm.services.t2pmigration.config.PrincipleRefType thisGrantee : objectDetailsType.getUserApplicationData().getGrantees().getParticipant()) {
                        System.out.println("  -> Grantee name [" + thisGrantee.getName() + "], realm [" + thisGrantee.getRealm() + "], type [" + thisGrantee.getType() + "]");
                    }
                }
            }
        }
        System.out.println("");
    }

    public static oracle.bpel.services.workflow.user.model.UserApplicationData convertJaxb2_0ToJaxb1_0(UserApplicationData appData2_0) throws Exception {
        Document doc = Util.marshallJaxb2_0(appData2_0);
        Element appDataElem = doc.getDocumentElement();
        oracle.bpel.services.workflow.user.model.UserApplicationData appData1_0 = (oracle.bpel.services.workflow.user.model.UserApplicationData)UserMetadataUtil.getInstance().unmarshal((Node)appDataElem);
        return appData1_0;
    }

    public static UserApplicationData convertJaxb1_0ToJaxb2_0(oracle.bpel.services.workflow.user.model.UserApplicationData appData1_0) throws Exception {
        XMLElement appDataElem = ((JaxbNode)appData1_0).getDOMNode();
        return Util.unmarshallJaxb2_0((Element)appDataElem);
    }

    public static Document marshallJaxb2_0(UserApplicationData appData2_0) throws Exception {
        JAXBContext jc = Jaxb20ContextFactory.getJAXBContext(ObjectFactory.class);
        DocumentBuilderFactory dbf = XMLUtil.getDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.marshal((Object)appData2_0, (Node)doc);
        return doc;
    }

    public static UserApplicationData unmarshallJaxb2_0(Element appDataElement) throws Exception {
        JAXBContext jc = Jaxb20ContextFactory.getJAXBContext(ObjectFactory.class);
        Unmarshaller um = jc.createUnmarshaller();
        return (UserApplicationData)um.unmarshal((Node)appDataElement);
    }

    public static int userApplicationDataWidgetExist(UserApplicationDataType uad, List<UserApplicationDataType> uadtList) {
        if (uad == null) {
            return -1;
        }
        if (uad.getId() == null && (uad.getApplicationDataType() == null || uad.getIdentityContext() == null || uad.getName() == null || uad.getOwner() == null)) {
            return -1;
        }
        if (uadtList == null || uadtList.isEmpty()) {
            return -1;
        }
        for (UserApplicationDataType uadt : uadtList) {
            if (uad.getId().equals(uadt.getId())) {
                System.out.println(" -> Application data with ID [" + uad.getId() + "], name [" + uad.getName() + "], owner [" + uad.getOwner() + "], and type [" + uad.getApplicationDataType() + "] already exists...");
                return 1;
            }
            if (uad.getApplicationDataType() == null || uadt.getApplicationDataType() == null || uad.getIdentityContext() == null || uadt.getIdentityContext() == null || uad.getName() == null || uadt.getName() == null || uad.getOwner() == null || uadt.getOwner() == null || !uad.getApplicationDataType().equals(uadt.getApplicationDataType()) || !uad.getIdentityContext().equals(uadt.getIdentityContext()) || !uad.getName().equals(uadt.getName())) continue;
            System.out.println(" -> Application data with name [" + uad.getName() + "], source owner [" + uad.getOwner() + "], target owner [" + uadt.getOwner() + "], and type [" + uad.getApplicationDataType() + "] is a duplicate...");
            System.out.println(" Original ID: " + uadt.getId());
            System.out.println(" New ID: " + uad.getId());
            return 2;
        }
        return 0;
    }

    public static String userApplicationDataPageExist(List<UserApplicationDataType> uadtList) {
        if (uadtList == null || uadtList.isEmpty()) {
            return null;
        }
        for (UserApplicationDataType uadt : uadtList) {
            if (!PAGENAME.equals(uadt.getName())) continue;
            return uadt.getId();
        }
        return null;
    }

    public static String getUserApplicationDataIDByName(UserApplicationDataType uad, List<UserApplicationDataType> uadtList) {
        if (uadtList == null || uadtList.isEmpty() || uad == null) {
            return null;
        }
        for (UserApplicationDataType uadt : uadtList) {
            if (uad.getApplicationDataType() == null || uadt.getApplicationDataType() == null || uad.getIdentityContext() == null || uadt.getIdentityContext() == null || uad.getName() == null || uadt.getName() == null || uad.getOwner() == null || uadt.getOwner() == null || !uad.getApplicationDataType().equals(uadt.getApplicationDataType()) || !uad.getIdentityContext().equals(uadt.getIdentityContext()) || !uad.getName().equals(uadt.getName()) || !uad.getOwner().equals(uadt.getOwner())) continue;
            return uadt.getId();
        }
        return null;
    }

    public static List<oracle.bpel.services.workflow.common.model.PrincipleRefType> convertBpmGranteeToBpelGrantee(List<PrincipleRefType> bpmGranteesList) throws Exception {
        ArrayList<oracle.bpel.services.workflow.common.model.PrincipleRefType> grantees = new ArrayList<oracle.bpel.services.workflow.common.model.PrincipleRefType>();
        for (PrincipleRefType thisGrantee : bpmGranteesList) {
            oracle.bpel.services.workflow.common.model.PrincipleRefType bpelPrt = Util.convertPrincipleRefTypeJaxb2_0ToJaxb1_0(thisGrantee);
            grantees.add(bpelPrt);
        }
        return grantees;
    }

    public static List<oracle.bpel.services.workflow.common.model.PrincipleRefType> convertT2PGranteeToBpelGrantee(List<oracle.bpm.services.t2pmigration.config.PrincipleRefType> bpmGranteesList) throws Exception {
        ArrayList<oracle.bpel.services.workflow.common.model.PrincipleRefType> grantees = new ArrayList<oracle.bpel.services.workflow.common.model.PrincipleRefType>();
        for (oracle.bpm.services.t2pmigration.config.PrincipleRefType thisGrantee : bpmGranteesList) {
            oracle.bpel.services.workflow.common.model.PrincipleRefType bpelPrt = Util.convertT2PPrincipleRefTypeJaxb2_0ToJaxb1_0(thisGrantee);
            grantees.add(bpelPrt);
        }
        return grantees;
    }

    public static PrincipleRefType convertPrincipleRefTypeJaxb1_0ToJaxb2_0(oracle.bpel.services.workflow.common.model.PrincipleRefType refType1) throws Exception {
        if (refType1 == null) {
            return null;
        }
        PrincipleRefType refType2 = new ObjectFactory().createPrincipleRefType();
        refType2.setName(refType1.getName());
        refType2.setRealm(refType1.getRealm());
        refType2.setType(ParticipantTypeEnum.fromValue((String)refType1.getType()));
        return refType2;
    }

    public static oracle.bpel.services.workflow.common.model.PrincipleRefType convertPrincipleRefTypeJaxb2_0ToJaxb1_0(PrincipleRefType refType2) throws Exception {
        if (refType2 == null) {
            return null;
        }
        oracle.bpel.services.workflow.common.model.PrincipleRefType refType1 = new oracle.bpel.services.workflow.common.model.ObjectFactory().createPrincipleRefType();
        refType1.setName(refType2.getName());
        refType1.setRealm(refType2.getRealm());
        ParticipantTypeEnum ptEnum = refType2.getType();
        if (ptEnum != null) {
            refType1.setType(ptEnum.value());
        }
        return refType1;
    }

    public static oracle.bpel.services.workflow.common.model.PrincipleRefType convertT2PPrincipleRefTypeJaxb2_0ToJaxb1_0(oracle.bpm.services.t2pmigration.config.PrincipleRefType refType2) throws Exception {
        if (refType2 == null) {
            return null;
        }
        oracle.bpel.services.workflow.common.model.PrincipleRefType refType1 = new oracle.bpel.services.workflow.common.model.ObjectFactory().createPrincipleRefType();
        refType1.setName(refType2.getName());
        refType1.setRealm(refType2.getRealm());
        oracle.bpm.services.t2pmigration.config.ParticipantTypeEnum ptEnum = refType2.getType();
        if (ptEnum != null) {
            refType1.setType(ptEnum.value());
        }
        return refType1;
    }

    public static boolean isUpdateExistingObjects(ObjectDetailsType objectDetailsType) {
        boolean updateExistingObjectsFlag = false;
        if (objectDetailsType != null && objectDetailsType.getOrganization() != null && objectDetailsType.getOrganization().isSetUpdateExistingObjects()) {
            updateExistingObjectsFlag = objectDetailsType.getOrganization().isUpdateExistingObjects();
        }
        System.out.println(" updateExistingObjectsFlag: " + updateExistingObjectsFlag);
        return updateExistingObjectsFlag;
    }

    public static void updateOrganizationWithUpdateExistingObjectsFlag(Organization organization, boolean updateExistingObjectsFlag) {
        if (organization != null && updateExistingObjectsFlag) {
            organization.setUpdateExistingObjects(Boolean.TRUE);
        }
    }

    protected static String passwordPrompt(String username) throws Exception {
        String pwdString = "";
        System.out.println(" passwordPrompt feature currently disabled.");
        return pwdString;
    }

    protected static void encrypt(String fileName, TestToProductionMigrationConfiguration migrateConfig) throws Exception {
        TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{oracle.bpm.services.t2pmigration.config.ObjectFactory.class});
            if (migrateConfig == null) {
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                testToProductionMigrationConfiguration = (TestToProductionMigrationConfiguration)unmarshaller.unmarshal((InputStream)new FileInputStream(fileName));
            } else {
                testToProductionMigrationConfiguration = migrateConfig;
            }
            File file1 = new File(fileName);
            if (!file1.canWrite()) {
                System.out.println("File " + fileName + " is read-only.");
                return;
            }
            Marshaller marshaller = jaxbContext.createMarshaller();
            testToProductionMigrationConfiguration = Util.encrypt(testToProductionMigrationConfiguration);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)testToProductionMigrationConfiguration, file1);
        }
        catch (Exception e) {
            throw new Exception("39516AES", e);
        }
    }

    private static boolean isPasswordEncrypted(ServerEndPointType serverEndPoint) throws Exception {
        boolean isPwdEncrypted = false;
        if (serverEndPoint != null) {
            if (!serverEndPoint.isSetEncryptedAdminUserPassword() && !serverEndPoint.isSetAdminUserPassword()) {
                System.out.println(" Missing required field - Administrator User Password.");
                throw new Exception("Missing required field - Administrator User Password.");
            }
            if (serverEndPoint.isSetEncryptedAdminUserPassword() && serverEndPoint.isSetAdminUserPassword()) {
                System.out.println(" Both encrypted and non encrypted password were set, resetting encrypt password.");
                isPwdEncrypted = false;
            } else if (serverEndPoint.isSetEncryptedAdminUserPassword() && serverEndPoint.getEncryptedAdminUserPassword() != null && !serverEndPoint.getEncryptedAdminUserPassword().isEmpty()) {
                isPwdEncrypted = true;
            }
        }
        System.out.println(" isPasswordEncrypted (ServerEndPointType): " + isPwdEncrypted);
        return isPwdEncrypted;
    }

    private static boolean isPasswordEncrypted(ObjectDetailsType objectDetails) throws Exception {
        boolean isPwdEncrypted = false;
        if (objectDetails != null) {
            if (!objectDetails.isSetEncryptedPassword() && !objectDetails.isSetPassword()) {
                System.out.println(" Missing required field - User Password.");
                throw new Exception("Missing required field - User Password.");
            }
            if (objectDetails.isSetEncryptedPassword() && objectDetails.isSetPassword()) {
                System.out.println(" Both encrypted and non encrypted password were set, resetting encrypt password.");
                isPwdEncrypted = false;
            } else if (objectDetails.isSetEncryptedPassword() && objectDetails.getEncryptedPassword() != null && !objectDetails.getEncryptedPassword().isEmpty()) {
                isPwdEncrypted = true;
            }
        }
        System.out.println(" isPasswordEncrypted (ObjectDetailsType): " + isPwdEncrypted);
        return isPwdEncrypted;
    }

    private static void encryptDecrypt(String fileName, TestToProductionMigrationConfiguration migrateConfig) throws Exception {
        if (Util.isEncrypted(migrateConfig)) {
            Util.decrypt(migrateConfig);
        } else {
            Util.encrypt(fileName, migrateConfig);
        }
    }

    private static String decrypt(String value) throws Exception {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        String key = null;
        key = System.getProperty("oracle.bpm.services.client.key") != null ? System.getProperty("oracle.bpm.services.client.key") : defaultKey;
        Cipher cipher = null;
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), "AES");
        try {
            cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKey);
            BASE64Decoder decoder = new BASE64Decoder();
            return new String(cipher.doFinal(decoder.decodeBuffer(value)));
        }
        catch (Exception e) {
            throw new Exception("39517AES");
        }
    }

    private static ServerEndPointType encryptServerEndPoint(ServerEndPointType serverEndPoint) throws Exception {
        if (serverEndPoint != null) {
            String encryptedPwd;
            String pwd = serverEndPoint.isSetAdminUserPassword() ? serverEndPoint.getAdminUserPassword() : null;
            String string = encryptedPwd = serverEndPoint.isSetEncryptedAdminUserPassword() ? serverEndPoint.getEncryptedAdminUserPassword() : null;
            if (encryptedPwd == null && (encryptedPwd = Util.encryptPassword(pwd)) != null) {
                serverEndPoint.setEncryptedAdminUserPassword(encryptedPwd);
                serverEndPoint.setAdminUserPassword(RESET_PASSWORD);
                System.out.println(" encryptServerEndPoint - Succeed.");
            }
        }
        return serverEndPoint;
    }

    private static ObjectDetailsType encryptObjectDetails(ObjectDetailsType objectDetails) throws Exception {
        if (objectDetails != null && objectDetails.isSetPassword()) {
            String encryptedPwd;
            String pwd = objectDetails.isSetPassword() ? objectDetails.getPassword() : null;
            String string = encryptedPwd = objectDetails.isSetEncryptedPassword() ? objectDetails.getEncryptedPassword() : null;
            if (encryptedPwd == null && (encryptedPwd = Util.encryptPassword(pwd)) != null) {
                objectDetails.setEncryptedPassword(encryptedPwd);
                objectDetails.setPassword(RESET_PASSWORD);
                System.out.println(" encryptObjectDetails - Succeed.");
            }
        }
        return objectDetails;
    }

    private static TestToProductionMigrationConfiguration encrypt(TestToProductionMigrationConfiguration migrateConfig) throws Exception {
        if (migrateConfig == null) {
            return migrateConfig;
        }
        OperationTypeEnum operationType = migrateConfig.getOperation();
        ServerEndPointType serverEndPoint = null;
        ObjectDetailsType objectDetails = migrateConfig.getObjectDetails();
        EndPointType endPoint = null;
        if (operationType == OperationTypeEnum.EXPORT) {
            endPoint = migrateConfig.getSourceEndPoint();
            serverEndPoint = endPoint.getServerEndPoint();
            serverEndPoint = Util.encryptServerEndPoint(serverEndPoint);
            endPoint.setServerEndPoint(serverEndPoint);
            migrateConfig.setSourceEndPoint(endPoint);
        } else if (operationType == OperationTypeEnum.IMPORT) {
            endPoint = migrateConfig.getTargetEndPoint();
            serverEndPoint = endPoint.getServerEndPoint();
            serverEndPoint = Util.encryptServerEndPoint(serverEndPoint);
            endPoint.setServerEndPoint(serverEndPoint);
            migrateConfig.setTargetEndPoint(endPoint);
        }
        objectDetails = Util.encryptObjectDetails(objectDetails);
        migrateConfig.setObjectDetails(objectDetails);
        return migrateConfig;
    }

    private static String encryptPassword(String value) throws Exception {
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        String key = null;
        key = System.getProperty("oracle.bpm.services.client.key") != null ? System.getProperty("oracle.bpm.services.client.key") : defaultKey;
        Cipher cipher = null;
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), "AES");
        cipher = Cipher.getInstance("AES");
        cipher.init(1, secretKey);
        BASE64Encoder encoder = new BASE64Encoder();
        byte[] cipherText = cipher.doFinal(value.getBytes());
        String encodedPassword = encoder.encode(cipherText);
        return encodedPassword;
    }

    private static ServerEndPointType decryptServerEndPoint(ServerEndPointType serverEndPoint) throws Exception {
        if (serverEndPoint != null) {
            String decryptedPwd;
            String encryptedPwd;
            String string = encryptedPwd = serverEndPoint.isSetEncryptedAdminUserPassword() ? serverEndPoint.getEncryptedAdminUserPassword() : null;
            if (encryptedPwd != null && (decryptedPwd = Util.decrypt(encryptedPwd)) != null) {
                serverEndPoint.setAdminUserPassword(decryptedPwd);
                serverEndPoint.setEncryptedAdminUserPassword(RESET_PASSWORD);
                System.out.println(" decryptServerEndPoint - Succeed.");
            }
        }
        return serverEndPoint;
    }

    private static ObjectDetailsType decryptObjectDetails(ObjectDetailsType objectDetails) throws Exception {
        if (objectDetails != null) {
            String decryptedPwd;
            String encryptedPwd;
            String string = encryptedPwd = objectDetails.isSetEncryptedPassword() ? objectDetails.getEncryptedPassword() : null;
            if (encryptedPwd != null && (decryptedPwd = Util.decrypt(encryptedPwd)) != null) {
                objectDetails.setPassword(decryptedPwd);
                objectDetails.setEncryptedPassword(RESET_PASSWORD);
                System.out.println(" decryptObjectDetails - Succeed.");
            }
        }
        return objectDetails;
    }

    private static void decrypt(TestToProductionMigrationConfiguration migrateConfig) throws Exception {
        System.out.println(" Decrypt begins.");
        if (migrateConfig == null) {
            throw new Exception(" testToProductionMigrationConfiguration is null");
        }
        if (!Util.isEncrypted(migrateConfig)) {
            System.out.println(" decrypt - TestToProductionMigrationConfiguration is not encrypted.");
            return;
        }
        OperationTypeEnum operationType = migrateConfig.getOperation();
        ServerEndPointType serverEndPoint = null;
        ObjectDetailsType objectDetails = migrateConfig.getObjectDetails();
        EndPointType endPoint = null;
        if (operationType == OperationTypeEnum.EXPORT) {
            endPoint = migrateConfig.getSourceEndPoint();
            if (endPoint != null) {
                serverEndPoint = endPoint.getServerEndPoint();
                serverEndPoint = Util.decryptServerEndPoint(serverEndPoint);
                endPoint.setServerEndPoint(serverEndPoint);
                migrateConfig.setSourceEndPoint(endPoint);
            }
        } else if (operationType == OperationTypeEnum.IMPORT && (endPoint = migrateConfig.getTargetEndPoint()) != null) {
            serverEndPoint = endPoint.getServerEndPoint();
            serverEndPoint = Util.decryptServerEndPoint(serverEndPoint);
            endPoint.setServerEndPoint(serverEndPoint);
            migrateConfig.setTargetEndPoint(endPoint);
        }
        objectDetails = Util.decryptObjectDetails(objectDetails);
        migrateConfig.setObjectDetails(objectDetails);
        System.out.println(" Decrypt completed.");
    }

    private static boolean isEncrypted(TestToProductionMigrationConfiguration migrateConfig) throws Exception {
        boolean isEncrypted = false;
        boolean isEndPointEncrypted = false;
        boolean isObjectDetailsEncrypted = false;
        if (migrateConfig == null) {
            System.out.println(" isEncrypted - migrateConfig is null, set to false.");
            return isEncrypted;
        }
        OperationTypeEnum operationType = migrateConfig.getOperation();
        ObjectDetailsType objectDetails = migrateConfig.getObjectDetails();
        EndPointType endPoint = null;
        if (operationType == OperationTypeEnum.EXPORT) {
            endPoint = migrateConfig.getSourceEndPoint();
            if (endPoint != null) {
                isEndPointEncrypted = Util.isPasswordEncrypted(endPoint.getServerEndPoint());
            }
        } else if (operationType == OperationTypeEnum.IMPORT && (endPoint = migrateConfig.getTargetEndPoint()) != null) {
            isEndPointEncrypted = Util.isPasswordEncrypted(endPoint.getServerEndPoint());
        }
        isObjectDetailsEncrypted = Util.isPasswordEncrypted(objectDetails);
        if (isEndPointEncrypted || isObjectDetailsEncrypted) {
            isEncrypted = true;
        }
        System.out.println(" isEncrypted: " + isEncrypted);
        return isEncrypted;
    }

    private static EndPointType setPassword(EndPointType endPoint, String password, String encPassword) throws Exception {
        if (endPoint == null) {
            System.out.println(" setPassword - end point is null.");
            return endPoint;
        }
        if (endPoint.isSetServerEndPoint()) {
            ServerEndPointType serverEndPoint = endPoint.getServerEndPoint();
            serverEndPoint.setAdminUserPassword(password);
            serverEndPoint.setEncryptedAdminUserPassword(encPassword);
        }
        return endPoint;
    }

    private static ObjectDetailsType setPassword(ObjectDetailsType objectDetails, String password, String encPassword) throws Exception {
        if (objectDetails == null) {
            System.out.println(" setPassword - object details is null.");
            return objectDetails;
        }
        objectDetails.setPassword(password);
        objectDetails.setEncryptedPassword(encPassword);
        return objectDetails;
    }

    static class EraserThread
    implements Runnable {
        private boolean stop;

        public EraserThread(String prompt) {
            System.out.print(prompt);
        }

        @Override
        public void run() {
            this.stop = true;
            while (this.stop) {
                System.out.print("\b*");
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }

        public void stopMasking() {
            this.stop = false;
        }
    }
}

