/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.t2pmigration.impl;

import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.client.WorkflowServiceClientException;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.model.Organization;
import oracle.bpm.services.t2pmigration.IT2PMigrationService;
import oracle.bpm.services.t2pmigration.config.EndPointType;
import oracle.bpm.services.t2pmigration.config.GrantTypeEnum;
import oracle.bpm.services.t2pmigration.config.ObjectDetailsType;
import oracle.bpm.services.t2pmigration.config.ObjectTypeEnum;
import oracle.bpm.services.t2pmigration.config.OperationTypeEnum;
import oracle.bpm.services.t2pmigration.config.TestToProductionMigrationConfiguration;
import oracle.bpm.services.t2pmigration.config.UserApplicationDataOptionTypeEnum;
import oracle.bpm.services.t2pmigration.data.BpmUserConfigurableData;
import oracle.bpm.services.t2pmigration.data.ObjectFactory;
import oracle.bpm.services.t2pmigration.data.UserApplicationData;
import oracle.bpm.services.t2pmigration.impl.Util;
import oracle.toplink.exceptions.TransactionException;

public class T2PMigrationService
implements IT2PMigrationService {
    protected TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = null;
    private ObjectDetailsType objectDetailsType = null;
    private List<ObjectTypeEnum> objectTypeList = null;
    private OperationTypeEnum operationType = null;
    private boolean overrideFlag = false;
    private boolean skipFlag = false;
    private EndPointType source = null;
    private EndPointType target = null;
    private static final String WIDGETSTRING = "BAM-WIDGET";
    private static final String PARTPROPSSTRING = "PART_PROPS";
    private static final String PAGENAME = "WAM";
    private static final String PAGEGRANTSTRING = "bea.albpm.workspace.layout";
    private static final int EXISTERROR = -1;
    private static final int NOTEXIST = 0;
    private static final int EXIST = 1;
    private static final int DUPLICATE = 2;
    private static ObjectFactory sT2PMigrationFactory;

    public void setTestToProductionMigrationConfiguration(TestToProductionMigrationConfiguration testToProductionMigrationConfiguration) {
        if (testToProductionMigrationConfiguration != null) {
            this.testToProductionMigrationConfiguration = testToProductionMigrationConfiguration;
            this.source = testToProductionMigrationConfiguration.getSourceEndPoint();
            this.target = testToProductionMigrationConfiguration.getTargetEndPoint();
            this.operationType = testToProductionMigrationConfiguration.getOperation();
            this.objectTypeList = testToProductionMigrationConfiguration.getObject();
            this.objectDetailsType = testToProductionMigrationConfiguration.getObjectDetails();
            this.skipFlag = testToProductionMigrationConfiguration.isSkip();
            this.overrideFlag = testToProductionMigrationConfiguration.isOverride();
        }
    }

    public void migrate(TestToProductionMigrationConfiguration testToProductionMigrationConfiguration) throws Exception {
        Util.displayTestToProductionMigrationConfiguration(testToProductionMigrationConfiguration);
        this.setTestToProductionMigrationConfiguration(testToProductionMigrationConfiguration);
        if (this.operationType == OperationTypeEnum.EXPORT) {
            System.out.println("\n ===>>> migrate()::EXPORT");
            this.exportHandler(this.source, this.target, this.objectDetailsType, this.objectTypeList);
        } else if (this.operationType == OperationTypeEnum.IMPORT) {
            System.out.println("\n ===>>> migrate()::IMPORT");
            this.importHandler(this.source, this.target, this.objectDetailsType, this.skipFlag, this.overrideFlag, this.objectTypeList);
        } else if (this.operationType == OperationTypeEnum.IN_MEMORY_TRANSFER) {
            System.out.println("\n ===>>> migrate()::IN_MEMORY_TRANSFER");
        } else {
            System.out.println("\n ===>>> Unsupported use case: File-to-File");
        }
    }

    private void updateApplicationData(UserApplicationDataType bpelUAD, IBPMServiceClient serviceClient, IBPMContext ctx, int uadtExistStatus, String origID) {
        block9: {
            if (uadtExistStatus == 1) {
                try {
                    System.out.println("Updating application data with ID [" + bpelUAD.getId() + "], name [" + bpelUAD.getName() + "], owner [" + bpelUAD.getOwner() + "], and type [" + bpelUAD.getApplicationDataType() + "] ...");
                    bpelUAD = serviceClient.getUserMetadataService().updateUserApplicationData((IWorkflowContext)ctx, bpelUAD);
                    System.out.println(" -> Import (overriding) application data with ID [" + bpelUAD.getId() + "] and name [" + bpelUAD.getName() + "] completed ...");
                }
                catch (WorkflowException e) {
                    if (e.getErrorCode() == 30747) {
                        System.out.println(" -> Skiping ...");
                        break block9;
                    }
                    System.out.println(" -> Exception occurs during import - {" + e.getLocalizedMessage() + "}");
                }
            } else if (uadtExistStatus == 2) {
                try {
                    System.out.println("Updating application data with name [" + bpelUAD.getName() + "], owner [" + bpelUAD.getOwner() + "], and type [" + bpelUAD.getApplicationDataType() + "] ...");
                    System.out.println("Duplicate application data with different ID detected : new [" + bpelUAD.getId() + "] original [" + origID + "], deleting original application data before recreating...");
                    serviceClient.getUserMetadataService().deleteUserApplicationData((IWorkflowContext)ctx, origID);
                    bpelUAD = serviceClient.getUserMetadataService().createUserApplicationData((IWorkflowContext)ctx, bpelUAD);
                    System.out.println(" -> Import (overriding) application data with ID [" + bpelUAD.getId() + "] and name [" + bpelUAD.getName() + "] completed ...");
                }
                catch (WorkflowException e) {
                    if (e.getErrorCode() == 30747) {
                        e.printStackTrace();
                        System.out.println(" -> Skiping ...");
                    }
                    System.out.println(" -> Exception occurs during import - {" + e.getLocalizedMessage() + "}");
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void exportHandler(EndPointType source, EndPointType target, ObjectDetailsType objectDetailsType, List<ObjectTypeEnum> objectTypeList) throws Exception {
        block27: {
            block25: {
                block26: {
                    block28: {
                        block23: {
                            block24: {
                                block21: {
                                    block22: {
                                        bpmUserConfigurableData = T2PMigrationService.sT2PMigrationFactory.createBpmUserConfigurableData();
                                        this.validateExportParameters(source, target, objectDetailsType, objectTypeList);
                                        bpmServiceClientFactory = null;
                                        ctx = null;
                                        if (source.getServerEndPoint().getAdminUserPassword() == null || source.getServerEndPoint().getAdminUserPassword().isEmpty()) {
                                            System.out.println(" source.getServerEndPoint().getAdminUserPassword() is invalid.");
                                        }
                                        if (source.getServerEndPoint().getEncryptedAdminUserPassword() == null || source.getServerEndPoint().getEncryptedAdminUserPassword().isEmpty()) {
                                            System.out.println(" source.getServerEndPoint().getEncryptedAdminUserPassword() is invalid.");
                                        }
                                        if ((bpmServiceClientFactory = Util.getBPMServiceClientFactory(source.getServerEndPoint().getServerURL(), source.getServerEndPoint().getAdminUserLogin(), source.getServerEndPoint().getAdminUserPassword())) != null) break block21;
                                        System.out.println(" Error in EXPORT: BPM service client factory is null, exiting...");
                                        if (bpmServiceClientFactory == null) {
                                            System.out.println(" BpmServiceClientFactory is null, skipping destroyContext.");
                                        }
                                        if (ctx != null) break block22;
                                        System.out.println(" Context is null, skipping destroyContext.");
                                    }
                                    Util.destroyContext(bpmServiceClientFactory, ctx);
                                    return;
                                }
                                serviceClient = Util.getServiceClientConnection(bpmServiceClientFactory);
                                if (serviceClient != null) break block23;
                                System.out.println(" Error in EXPORT: BPM service client is null, exiting...");
                                if (bpmServiceClientFactory == null) {
                                    System.out.println(" BpmServiceClientFactory is null, skipping destroyContext.");
                                }
                                if (ctx != null) break block24;
                                System.out.println(" Context is null, skipping destroyContext.");
                            }
                            Util.destroyContext(bpmServiceClientFactory, ctx);
                            return;
                        }
                        if (objectTypeList != null) break block28;
                        System.out.println(" Object type list is null during EXPORT!");
                        ** GOTO lbl69
                    }
                    if (objectDetailsType.getPassword() == null || objectDetailsType.getPassword().isEmpty()) {
                        System.out.println(" objectDetailsType.getPassword() is invalid.");
                    }
                    if (objectDetailsType.getEncryptedPassword() == null || objectDetailsType.getEncryptedPassword().isEmpty()) {
                        System.out.println(" objectDetailsType.getEncryptedPassword() is invalid.");
                    }
                    if ((ctx = Util.getContext(bpmServiceClientFactory, objectDetailsType.getLogin(), objectDetailsType.getPassword(), objectDetailsType.getIdentityContext())) != null) break block25;
                    System.out.println(" Error in EXPORT: BPM context is null, exiting...");
                    if (bpmServiceClientFactory == null) {
                        System.out.println(" BpmServiceClientFactory is null, skipping destroyContext.");
                    }
                    if (ctx != null) break block26;
                    System.out.println(" Context is null, skipping destroyContext.");
                }
                Util.destroyContext(bpmServiceClientFactory, ctx);
                return;
            }
            try {
                for (i = 0; i < objectTypeList.size(); ++i) {
                    if (ObjectTypeEnum.ORGANIZATION == objectTypeList.get(i)) {
                        organizationService = Util.getOrganizationService(serviceClient);
                        organization = organizationService.exportOrganization(ctx);
                        if (organization == null) continue;
                        bpmUserConfigurableData.getOrganization().add(organization);
                        continue;
                    }
                    if (ObjectTypeEnum.DASHBOARD != objectTypeList.get(i)) continue;
                    bpmUserConfigurableData = this.exportUserApplicationData(bpmUserConfigurableData, serviceClient, ctx);
                }
lbl69:
                // 2 sources

                Util.exportBpmUserConfigurableData(bpmUserConfigurableData, target.getFileEndPoint().getMigrationFile());
                System.out.println(" Completed EXPORT.");
                if (bpmServiceClientFactory == null) {
                    System.out.println(" BpmServiceClientFactory is null, skipping destroyContext.");
                }
                if (ctx != null) break block27;
                System.out.println(" Context is null, skipping destroyContext.");
            }
            catch (Exception e) {
                try {
                    System.out.println(" Error in EXPORT - " + e.getLocalizedMessage());
                    throw e;
                }
                catch (Throwable var12_13) {
                    if (bpmServiceClientFactory == null) {
                        System.out.println(" BpmServiceClientFactory is null, skipping destroyContext.");
                    } else if (ctx == null) {
                        System.out.println(" Context is null, skipping destroyContext.");
                    } else {
                        Util.destroyContext(bpmServiceClientFactory, ctx);
                    }
                    throw var12_13;
                }
            }
        }
        Util.destroyContext(bpmServiceClientFactory, ctx);
    }

    private void importHandler(EndPointType source, EndPointType target, ObjectDetailsType objectDetailsType, boolean skipFlag, boolean overrideFlag, List<ObjectTypeEnum> objectTypeList) throws Exception {
        block35: {
            block34: {
                IBPMContext ctx;
                BPMServiceClientFactory bpmServiceClientFactory;
                block33: {
                    IBPMOrganizationService organizationService;
                    IBPMServiceClient serviceClient;
                    boolean validateUsers;
                    block31: {
                        block32: {
                            block29: {
                                block30: {
                                    block27: {
                                        block28: {
                                            this.validateImportParameters(source, target, objectDetailsType, objectTypeList);
                                            if (source == null || source.getFileEndPoint() == null || source.getFileEndPoint().getMigrationFile() == null || target.getServerEndPoint() == null || target.getServerEndPoint().getServerURL() == null || target.getServerEndPoint().getAdminUserLogin() == null || target.getServerEndPoint().getAdminUserPassword() == null) break block34;
                                            validateUsers = !skipFlag;
                                            System.out.println(" validateUsers: " + validateUsers);
                                            bpmServiceClientFactory = null;
                                            ctx = null;
                                            if (target.getServerEndPoint().getAdminUserPassword() == null || target.getServerEndPoint().getAdminUserPassword().isEmpty()) {
                                                System.out.println(" target.getServerEndPoint().getAdminUserPassword() is invalid.");
                                            }
                                            if (target.getServerEndPoint().getEncryptedAdminUserPassword() == null || target.getServerEndPoint().getEncryptedAdminUserPassword().isEmpty()) {
                                                System.out.println(" target.getServerEndPoint().getEncryptedAdminUserPassword() is invalid.");
                                            }
                                            if ((bpmServiceClientFactory = Util.getBPMServiceClientFactory(target.getServerEndPoint().getServerURL(), target.getServerEndPoint().getAdminUserLogin(), target.getServerEndPoint().getAdminUserPassword())) != null) break block27;
                                            System.out.println(" Error in IMPORT: BPM service client factory is null, exiting...");
                                            if (bpmServiceClientFactory == null) {
                                                System.out.println(" BpmServiceClientFactory is null, skipping destroyContext.");
                                            }
                                            if (ctx != null) break block28;
                                            System.out.println(" Context is null, skipping destroyContext.");
                                        }
                                        Util.destroyContext(bpmServiceClientFactory, ctx);
                                        return;
                                    }
                                    serviceClient = Util.getServiceClientConnection(bpmServiceClientFactory);
                                    if (serviceClient != null) break block29;
                                    System.out.println(" Error in IMPORT: BPM service client is null, exiting...");
                                    if (bpmServiceClientFactory == null) {
                                        System.out.println(" BpmServiceClientFactory is null, skipping destroyContext.");
                                    }
                                    if (ctx != null) break block30;
                                    System.out.println(" Context is null, skipping destroyContext.");
                                }
                                Util.destroyContext(bpmServiceClientFactory, ctx);
                                return;
                            }
                            organizationService = Util.getOrganizationService(serviceClient);
                            if (objectDetailsType.getPassword() == null || objectDetailsType.getPassword().isEmpty()) {
                                System.out.println(" objectDetailsType.getPassword() is invalid.");
                            }
                            if (objectDetailsType.getEncryptedPassword() == null || objectDetailsType.getEncryptedPassword().isEmpty()) {
                                System.out.println(" objectDetailsType.getEncryptedPassword() is invalid.");
                            }
                            if ((ctx = Util.getContext(bpmServiceClientFactory, objectDetailsType.getLogin(), objectDetailsType.getPassword(), objectDetailsType.getIdentityContext())) != null) break block31;
                            System.out.println(" Error in IMPORT: BPM context is null, exiting...");
                            if (bpmServiceClientFactory == null) {
                                System.out.println(" BpmServiceClientFactory is null, skipping destroyContext.");
                            }
                            if (ctx != null) break block32;
                            System.out.println(" Context is null, skipping destroyContext.");
                        }
                        Util.destroyContext(bpmServiceClientFactory, ctx);
                        return;
                    }
                    try {
                        BpmUserConfigurableData importBpmUserConfigurableData = Util.importBpmUserConfigurableData(source.getFileEndPoint().getMigrationFile());
                        System.out.println(" Got the BpmUserConfigurableData by parsing the import file ...");
                        if (objectTypeList == null) {
                            System.out.println(" No object type available during IMPORT!");
                        } else {
                            for (int i = 0; i < objectTypeList.size(); ++i) {
                                if (ObjectTypeEnum.ORGANIZATION == objectTypeList.get(i)) {
                                    List organizationList = importBpmUserConfigurableData.getOrganization();
                                    System.out.println(" organizationList.size(): " + organizationList.size());
                                    boolean updateExistingObjectsFlag = Util.isUpdateExistingObjects(objectDetailsType);
                                    if (organizationList != null && organizationList.size() > 0) {
                                        for (int j = 0; j < organizationList.size(); ++j) {
                                            Organization organization = (Organization)organizationList.get(j);
                                            Util.updateOrganizationWithUpdateExistingObjectsFlag(organization, updateExistingObjectsFlag);
                                            System.out.println(" Importing organization unit " + j + " ...");
                                            organizationService.importOrganization(ctx, organization, validateUsers);
                                            System.out.println(" Import of organization unit completed ...");
                                        }
                                        continue;
                                    }
                                    System.out.println(" organizationList is null or empty");
                                    continue;
                                }
                                if (ObjectTypeEnum.DASHBOARD != objectTypeList.get(i)) continue;
                                List bpmUADTypeList = importBpmUserConfigurableData.getUserApplicationData();
                                if (bpmUADTypeList == null) {
                                    System.out.println("UserApplicationData List is null");
                                } else {
                                    System.out.println("UserApplicationData List size is [" + bpmUADTypeList.size() + "]");
                                }
                                this.importUserApplicationData(serviceClient, ctx, objectDetailsType, skipFlag, overrideFlag, bpmUADTypeList);
                            }
                        }
                        System.out.println(" Completed IMPORT.");
                        if (bpmServiceClientFactory == null) {
                            System.out.println(" BpmServiceClientFactory is null, skipping destroyContext.");
                        }
                        if (ctx != null) break block33;
                        System.out.println(" Context is null, skipping destroyContext.");
                    }
                    catch (Exception e) {
                        try {
                            System.out.println(" Error in IMPORT - " + e.getLocalizedMessage());
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (bpmServiceClientFactory == null) {
                                System.out.println(" BpmServiceClientFactory is null, skipping destroyContext.");
                            } else if (ctx == null) {
                                System.out.println(" Context is null, skipping destroyContext.");
                            } else {
                                Util.destroyContext(bpmServiceClientFactory, ctx);
                            }
                            throw throwable;
                        }
                    }
                }
                Util.destroyContext(bpmServiceClientFactory, ctx);
                break block35;
            }
            Exception e = new Exception(" Error in IMPORT: One or more required parameter(s) is(are) missing from configuration file.");
            throw e;
        }
    }

    private BpmUserConfigurableData exportUserApplicationData(BpmUserConfigurableData bpmUserConfigurableData, IBPMServiceClient serviceClient, IBPMContext ctx) throws Exception {
        List<UserApplicationDataType> queriedBpelApplicationDataList = null;
        String owner = this.objectDetailsType.getLogin();
        if (this.objectDetailsType != null && this.objectDetailsType.getUserApplicationData() != null && this.objectDetailsType.getUserApplicationData().isSetOwnerId()) {
            owner = this.objectDetailsType.getUserApplicationData().getOwnerId();
        }
        boolean exportPages = true;
        if (this.objectDetailsType != null && this.objectDetailsType.getUserApplicationData() != null && this.objectDetailsType.getUserApplicationData().isSetOption() && UserApplicationDataOptionTypeEnum.DASHBOARD == this.objectDetailsType.getUserApplicationData().getOption()) {
            exportPages = false;
        }
        boolean grantPermission = true;
        if (this.objectDetailsType != null && this.objectDetailsType.getUserApplicationData() != null && this.objectDetailsType.getUserApplicationData().isSetGrant() && GrantTypeEnum.WITHOUTGRANT == this.objectDetailsType.getUserApplicationData().getGrant()) {
            System.out.println(" Setting permission grant to false...");
            grantPermission = false;
        }
        boolean customlayout = false;
        if (this.objectDetailsType != null && this.objectDetailsType.getUserApplicationData() != null && this.objectDetailsType.getUserApplicationData().isSetOption() && UserApplicationDataOptionTypeEnum.CUSTOMLAYOUT == this.objectDetailsType.getUserApplicationData().getOption()) {
            System.out.println(" Exporting grant page(s) and dashboard(s)...");
            exportPages = true;
            grantPermission = true;
            customlayout = true;
        }
        queriedBpelApplicationDataList = this.listUserApplicationData(serviceClient, ctx, WIDGETSTRING, owner);
        if (exportPages && !customlayout) {
            if (queriedBpelApplicationDataList != null && queriedBpelApplicationDataList.size() > 0) {
                System.out.println("User application data list is not empty, adding PARTPROPSSTRING...");
                queriedBpelApplicationDataList.addAll(this.listUserApplicationData(serviceClient, ctx, PARTPROPSSTRING, owner));
            } else {
                System.out.println("User application data list is empty, creating PARTPROPSSTRING...");
                queriedBpelApplicationDataList = this.listUserApplicationData(serviceClient, ctx, PARTPROPSSTRING, owner);
            }
        }
        if (grantPermission) {
            if (queriedBpelApplicationDataList != null && queriedBpelApplicationDataList.size() > 0) {
                System.out.println("User application data list is not empty, adding PAGEGRANTSTRING...");
                queriedBpelApplicationDataList.addAll(this.listUserApplicationData(serviceClient, ctx, PAGEGRANTSTRING, owner));
            } else {
                System.out.println("User application data list is empty, creating PAGEGRANTSTRING...");
                queriedBpelApplicationDataList = this.listUserApplicationData(serviceClient, ctx, PAGEGRANTSTRING, owner);
            }
        }
        if (queriedBpelApplicationDataList != null && queriedBpelApplicationDataList.size() > 0) {
            int ctrUAD = 0;
            for (UserApplicationDataType bpelUAD : queriedBpelApplicationDataList) {
                if (bpelUAD != null) {
                    UserApplicationData bpmUdt = null;
                    if (grantPermission) {
                        List grantees = bpelUAD.getGrantees().getParticipant();
                        ArrayList<oracle.bpm.services.t2pmigration.data.PrincipleRefType> bpmGrantees1 = new ArrayList<oracle.bpm.services.t2pmigration.data.PrincipleRefType>();
                        for (PrincipleRefType thisGrantee : grantees) {
                            oracle.bpm.services.t2pmigration.data.PrincipleRefType bpmPrt = Util.convertPrincipleRefTypeJaxb1_0ToJaxb2_0(thisGrantee);
                            bpmGrantees1.add(bpmPrt);
                        }
                        bpmUdt = Util.convertJaxb1_0ToJaxb2_0((oracle.bpel.services.workflow.user.model.UserApplicationData)bpelUAD);
                        bpmUdt.getGrantees().getParticipant().addAll(bpmGrantees1);
                    } else {
                        bpelUAD.setGrantees(null);
                        bpmUdt = Util.convertJaxb1_0ToJaxb2_0((oracle.bpel.services.workflow.user.model.UserApplicationData)bpelUAD);
                    }
                    bpmUserConfigurableData.getUserApplicationData().add(bpmUdt);
                    ++ctrUAD;
                    continue;
                }
                System.out.println(" Skip exporting null application data.");
            }
            System.out.println(" Exporting " + ctrUAD + " application data(s) ...");
        } else {
            System.out.println(" Queried Application Data List is null");
        }
        return bpmUserConfigurableData;
    }

    private void importUserApplicationData(IBPMServiceClient serviceClient, IBPMContext ctx, ObjectDetailsType objectDetailsType, boolean skipFlag, boolean overrideFlag, List<UserApplicationData> bpmUADTypeList) throws WorkflowException {
        if (bpmUADTypeList != null && bpmUADTypeList.size() > 0) {
            oracle.bpel.services.workflow.user.model.UserApplicationData bpelUAD = null;
            String owner = objectDetailsType.getLogin();
            if (objectDetailsType != null && objectDetailsType.getUserApplicationData() != null && objectDetailsType.getUserApplicationData().isSetOwnerId()) {
                owner = objectDetailsType.getUserApplicationData().getOwnerId();
            }
            boolean exportPages = true;
            if (objectDetailsType != null && objectDetailsType.getUserApplicationData() != null && objectDetailsType.getUserApplicationData().isSetOption() && UserApplicationDataOptionTypeEnum.DASHBOARD == objectDetailsType.getUserApplicationData().getOption()) {
                exportPages = false;
            }
            boolean grantPermission = true;
            if (objectDetailsType != null && objectDetailsType.getUserApplicationData() != null && objectDetailsType.getUserApplicationData().isSetGrant() && GrantTypeEnum.WITHOUTGRANT == objectDetailsType.getUserApplicationData().getGrant()) {
                System.out.println(" Setting grant to false...");
                grantPermission = false;
            } else {
                System.out.println(" Setting grant to true...");
            }
            boolean customlayout = false;
            if (objectDetailsType != null && objectDetailsType.getUserApplicationData() != null && objectDetailsType.getUserApplicationData().isSetOption() && UserApplicationDataOptionTypeEnum.CUSTOMLAYOUT == objectDetailsType.getUserApplicationData().getOption()) {
                System.out.println(" Importing grant page(s) and dashboard(s)...");
                exportPages = true;
                grantPermission = true;
                customlayout = true;
            }
            List<UserApplicationDataType> uadtPageList = null;
            if (exportPages && !customlayout) {
                System.out.println(" Searching for existing workspace pages...");
                uadtPageList = this.listUserApplicationData(serviceClient, ctx, PARTPROPSSTRING, owner);
            }
            System.out.println(" Searching for existing dashboard widgets...");
            List<UserApplicationDataType> uadtWidgetList = this.listUserApplicationData(serviceClient, ctx, WIDGETSTRING, owner);
            List<UserApplicationDataType> uadtGrantList = null;
            if (grantPermission) {
                System.out.println(" Searching for existing grants...");
                uadtGrantList = this.listUserApplicationData(serviceClient, ctx, PAGEGRANTSTRING, owner);
            }
            for (UserApplicationData bpmUADType : bpmUADTypeList) {
                if (bpmUADType != null) {
                    if (!exportPages && PAGEGRANTSTRING.equals(bpmUADType.getApplicationDataType())) {
                        System.out.println("\n Skip page import for ID [" + bpmUADType.getId() + "], name [" + bpmUADType.getName() + "], type [" + bpmUADType.getApplicationDataType() + "] ...");
                        continue;
                    }
                    if (!grantPermission && PAGEGRANTSTRING.equals(bpmUADType.getApplicationDataType())) {
                        System.out.println("\n Skip grant import for ID [" + bpmUADType.getId() + "], name [" + bpmUADType.getName() + "], type [" + bpmUADType.getApplicationDataType() + "] ...");
                        continue;
                    }
                    if (customlayout && PARTPROPSSTRING.equals(bpmUADType.getApplicationDataType())) {
                        System.out.println("\n Skip local page(s) import for ID [" + bpmUADType.getId() + "], name [" + bpmUADType.getName() + "], type [" + bpmUADType.getApplicationDataType() + "] ...");
                        continue;
                    }
                    System.out.println("\n Importing application data with ID [" + bpmUADType.getId() + "], name [" + bpmUADType.getName() + "], type [" + bpmUADType.getApplicationDataType() + "] ...");
                    if (!bpmUADType.getOwner().equals(owner)) {
                        System.out.println(" -> Setting owner from [" + bpmUADType.getOwner() + "] to [" + owner + "]");
                        bpmUADType.setOwner(owner);
                        bpmUADType.setCreatedBy(owner);
                        bpmUADType.setUpdatedBy(owner);
                    }
                    List bpmGranteesList = bpmUADType.getGrantees() == null ? null : bpmUADType.getGrantees().getParticipant();
                    try {
                        bpelUAD = Util.convertJaxb2_0ToJaxb1_0(bpmUADType);
                        if (grantPermission) {
                            if (bpmGranteesList != null && bpmGranteesList.size() > 0) {
                                System.out.println(" Adding " + bpmGranteesList.size() + " grantee(s) from import migrate file.");
                                bpelUAD.getGrantees().getParticipant().addAll(Util.convertBpmGranteeToBpelGrantee(bpmGranteesList));
                            }
                            if (objectDetailsType.getUserApplicationData().isSetGrantees()) {
                                System.out.println(" Adding " + objectDetailsType.getUserApplicationData().getGrantees().getParticipant().size() + " grantee(s) from import configuration file.");
                                bpelUAD.getGrantees().getParticipant().addAll(Util.convertT2PGranteeToBpelGrantee(objectDetailsType.getUserApplicationData().getGrantees().getParticipant()));
                            }
                        }
                        int uadtExistStatus = 0;
                        String origID = null;
                        if (PARTPROPSSTRING.equals(bpelUAD.getApplicationDataType())) {
                            String newID = Util.userApplicationDataPageExist(uadtPageList);
                            if (newID != null) {
                                System.out.println(" Updating page ID from [" + bpelUAD.getId() + "] to [" + newID + "]");
                                bpelUAD.setId(newID);
                                uadtExistStatus = 1;
                            }
                        } else if (WIDGETSTRING.equals(bpelUAD.getApplicationDataType())) {
                            uadtExistStatus = Util.userApplicationDataWidgetExist((UserApplicationDataType)bpelUAD, uadtWidgetList);
                            if (uadtExistStatus == 2) {
                                origID = Util.getUserApplicationDataIDByName((UserApplicationDataType)bpelUAD, uadtWidgetList);
                            }
                        } else if (PAGEGRANTSTRING.equals(bpelUAD.getApplicationDataType())) {
                            uadtExistStatus = Util.userApplicationDataWidgetExist((UserApplicationDataType)bpelUAD, uadtGrantList);
                            if (uadtExistStatus == 2) {
                                origID = Util.getUserApplicationDataIDByName((UserApplicationDataType)bpelUAD, uadtGrantList);
                            }
                        } else {
                            System.out.println("Unsupported ApplicationDataType [" + bpelUAD.getApplicationDataType() + "] detected.");
                        }
                        if (uadtExistStatus == 2) {
                            if (overrideFlag || !skipFlag) {
                                this.updateApplicationData((UserApplicationDataType)bpelUAD, serviceClient, ctx, uadtExistStatus, origID);
                                continue;
                            }
                            System.out.println(" -> Skipping duplicate application data.");
                            continue;
                        }
                        if (uadtExistStatus == 1) {
                            if (overrideFlag || !skipFlag) {
                                this.updateApplicationData((UserApplicationDataType)bpelUAD, serviceClient, ctx, uadtExistStatus, origID);
                                continue;
                            }
                            System.out.println(" -> Skipping already exist application data.");
                            continue;
                        }
                        bpelUAD = serviceClient.getUserMetadataService().createUserApplicationData((IWorkflowContext)ctx, (UserApplicationDataType)bpelUAD);
                        System.out.println(" -> Import of application data with ID [" + bpelUAD.getId() + "] and name [" + bpelUAD.getName() + "] completed ...");
                    }
                    catch (WorkflowServiceClientException wsce) {
                        System.out.println(" -> Error on Application data with ID [" + bpmUADType.getId() + "] with name [" + bpmUADType.getName() + "], type [" + bpmUADType.getApplicationDataType() + "], context [" + bpmUADType.getIdentityContext() + "], owner [" + bpmUADType.getOwner() + "] - WorkflowServiceClientException {" + wsce.getLocalizedMessage() + "}");
                    }
                    catch (TransactionException te) {
                        System.out.println(" -> Error on Application data with ID [" + bpmUADType.getId() + "] with name [" + bpmUADType.getName() + "], type [" + bpmUADType.getApplicationDataType() + "], context [" + bpmUADType.getIdentityContext() + "], owner [" + bpmUADType.getOwner() + "] - TransactionException {" + te.getLocalizedMessage() + "}");
                    }
                    catch (SQLIntegrityConstraintViolationException sqle) {
                        System.out.println(" -> Error on Application data with ID [" + bpmUADType.getId() + "] with name [" + bpmUADType.getName() + "], type [" + bpmUADType.getApplicationDataType() + "], context [" + bpmUADType.getIdentityContext() + "], owner [" + bpmUADType.getOwner() + "] - SQLIntegrityConstraintViolationException {" + sqle.getLocalizedMessage() + "}");
                    }
                    catch (Exception e) {
                        System.out.println(" -> Unexpected error on Application data with ID [" + bpmUADType.getId() + "] with name [" + bpmUADType.getName() + "], type [" + bpmUADType.getApplicationDataType() + "], context [" + bpmUADType.getIdentityContext() + "], owner [" + bpmUADType.getOwner() + "] - {" + e.getLocalizedMessage() + "}");
                    }
                    continue;
                }
                System.out.println(" Skip importing null application data.");
            }
        } else {
            System.out.println(" Skip importing null application data list.");
        }
    }

    private void validateExportParameters(EndPointType source, EndPointType target, ObjectDetailsType objectDetailsType, List<ObjectTypeEnum> objectTypeList) throws Exception {
        ArrayList<String> missingParamList = new ArrayList<String>();
        if (source == null) {
            missingParamList.add("source");
        } else {
            if (source.getServerEndPoint().getServerURL() == null || source.getServerEndPoint().getServerURL().trim().isEmpty()) {
                missingParamList.add("source.getServerEndPoint().getServerURL()");
            }
            if (source.getServerEndPoint().getAdminUserLogin() == null || source.getServerEndPoint().getAdminUserLogin().trim().isEmpty()) {
                missingParamList.add("source.getServerEndPoint().getAdminUserLogin()");
            }
            if ((source.getServerEndPoint().getAdminUserPassword() == null || source.getServerEndPoint().getAdminUserPassword().trim().isEmpty()) && (source.getServerEndPoint().getEncryptedAdminUserPassword() == null || source.getServerEndPoint().getEncryptedAdminUserPassword().trim().isEmpty())) {
                missingParamList.add("source.getServerEndPoint().getAdminUserPassword() / source.getServerEndPoint().getEncryptedAdminUserPassword()");
            }
        }
        if (target == null) {
            missingParamList.add("target");
        } else {
            if (target.getFileEndPoint() == null) {
                missingParamList.add("target.getFileEndPoint()");
            }
            if (target.getFileEndPoint().getMigrationFile() == null || target.getFileEndPoint().getMigrationFile().trim().isEmpty()) {
                missingParamList.add("target.getFileEndPoint().getMigrationFile()");
            }
        }
        if (objectTypeList != null) {
            if (objectDetailsType == null) {
                missingParamList.add("objectDetailsType");
            } else if ((objectDetailsType.getPassword() == null || objectDetailsType.getPassword().trim().isEmpty()) && (objectDetailsType.getEncryptedPassword() == null || objectDetailsType.getEncryptedPassword().trim().isEmpty())) {
                missingParamList.add("objectDetailsType.getPassword() / objectDetailsType.getEncryptedPassword()");
            }
        }
        if (!missingParamList.isEmpty()) {
            String missingParamStr = "[ ";
            for (String missingParam : missingParamList) {
                missingParamStr = missingParamStr + "'" + missingParam + "' ";
            }
            missingParamStr = missingParamStr + "]";
            Exception e = new Exception(" Error in EXPORT: Required parameter(s) missing from configuration file. - " + missingParamStr);
            throw e;
        }
    }

    private void validateImportParameters(EndPointType source, EndPointType target, ObjectDetailsType objectDetailsType, List<ObjectTypeEnum> objectTypeList) throws Exception {
        ArrayList<String> missingParamList = new ArrayList<String>();
        if (source == null) {
            missingParamList.add("source");
        } else {
            if (source.getFileEndPoint() == null) {
                missingParamList.add("source.getFileEndPoint()");
            }
            if (source.getFileEndPoint().getMigrationFile() == null || source.getFileEndPoint().getMigrationFile().trim().isEmpty()) {
                missingParamList.add("source.getFileEndPoint().getMigrationFile()");
            }
        }
        if (target == null) {
            missingParamList.add("target");
        } else {
            if (target.getServerEndPoint().getServerURL() == null || target.getServerEndPoint().getServerURL().trim().isEmpty()) {
                missingParamList.add("target.getServerEndPoint().getServerURL()");
            }
            if (target.getServerEndPoint().getAdminUserLogin() == null || target.getServerEndPoint().getAdminUserLogin().trim().isEmpty()) {
                missingParamList.add("target.getServerEndPoint().getAdminUserLogin()");
            }
            if ((target.getServerEndPoint().getAdminUserPassword() == null || target.getServerEndPoint().getAdminUserPassword().trim().isEmpty()) && (target.getServerEndPoint().getEncryptedAdminUserPassword() == null || target.getServerEndPoint().getEncryptedAdminUserPassword().trim().isEmpty())) {
                missingParamList.add("target.getServerEndPoint().getAdminUserPassword() / target.getServerEndPoint().getEncryptedAdminUserPassword()");
            }
        }
        if (objectTypeList != null) {
            if (objectDetailsType == null) {
                missingParamList.add("objectDetailsType");
            } else if ((objectDetailsType.getPassword() == null || objectDetailsType.getPassword().trim().isEmpty()) && (objectDetailsType.getEncryptedPassword() == null || objectDetailsType.getEncryptedPassword().trim().isEmpty())) {
                missingParamList.add("objectDetailsType.getPassword() / objectDetailsType.getEncryptedPassword()");
            }
        }
        if (!missingParamList.isEmpty()) {
            String missingParamStr = "[ ";
            for (String missingParam : missingParamList) {
                missingParamStr = missingParamStr + "'" + missingParam + "' ";
            }
            missingParamStr = missingParamStr + "]";
            Exception e = new Exception(" Error in IMPORT: Required parameter(s) missing from configuration file. - " + missingParamStr);
            throw e;
        }
    }

    private List<UserApplicationDataType> listUserApplicationData(IBPMServiceClient serviceClient, IBPMContext ctx, String option, String owner) throws WorkflowException {
        List uadList = null;
        if (serviceClient == null) {
            System.out.println(" IBPMServiceClient is null.");
        }
        if (ctx == null) {
            System.out.println(" IBPMContext is null.");
        }
        if (option == null) {
            System.out.println(" option is null.");
        }
        if (owner == null) {
            System.out.println(" owner is null.");
        }
        try {
            uadList = serviceClient.getUserMetadataService().listUserApplicationData((IWorkflowContext)ctx, option, owner);
            if (uadList == null) {
                System.out.println(" listUserApplicationData - uadList is null.");
            } else {
                System.out.println(" listUserApplicationData - uadList size is [" + uadList.size() + "].");
            }
        }
        catch (WorkflowException e) {
            System.out.println(" Exception occurs at list listUserApplicationData : Option [" + option + "], Owner [" + owner + "].");
            e.printStackTrace();
            throw e;
        }
        return uadList;
    }

    static {
        System.setProperty("javax.xml.datatype.DatatypeFactory", "com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl");
        sT2PMigrationFactory = new ObjectFactory();
    }
}

