/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.t2pmigration.impl;

import oracle.bpm.services.t2pmigration.config.TestToProductionMigrationConfiguration;
import oracle.bpm.services.t2pmigration.impl.T2PMigrationService;
import oracle.bpm.services.t2pmigration.impl.Util;

public class BPMT2PMigrator {
    public static void main(String[] args) throws Exception {
        String beaHome = null;
        String bpmHome = null;
        String bpmT2PMigrationConfigFileName = null;
        boolean promptPassword = false;
        try {
            if (args == null) {
                System.out.println("\n args is null");
                System.out.println("\n Error encountered during migration.");
                Exception e = new Exception("args is null.  Please furnish the command line parameters correctly");
                throw e;
            }
            for (int i = 0; i < args.length; ++i) {
                System.out.println(" args[" + i + "]: " + args[i]);
            }
            beaHome = args[0];
            System.out.println(" beaHome: " + beaHome);
            bpmHome = args[1];
            System.out.println(" bpmHome: " + bpmHome);
            bpmT2PMigrationConfigFileName = args[2];
            System.out.println(" bpmT2PMigrationConfigFileName: " + bpmT2PMigrationConfigFileName);
            if (args.length == 4) {
                promptPassword = "true".equalsIgnoreCase(args[3]);
            }
            TestToProductionMigrationConfiguration testToProductionMigrationConfiguration = Util.parseTestToProductionMigrationConfigurationFile(bpmT2PMigrationConfigFileName, promptPassword);
            Util.displayTestToProductionMigrationConfiguration(testToProductionMigrationConfiguration);
            System.out.println(" Perform BPM migration from Test to Production");
            T2PMigrationService t2pMigrationService = new T2PMigrationService();
            t2pMigrationService.migrate(testToProductionMigrationConfiguration);
            Util.encrypt(bpmT2PMigrationConfigFileName, testToProductionMigrationConfiguration);
            System.out.println(" Completed BPM migration from Test to Production");
        }
        catch (Exception e) {
            System.out.println("\n Error encountered during migration.");
            throw e;
        }
    }
}

