/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.resource;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bpel.services.workflow.resource.i18NUtil;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class BPMi18NUtil {
    private static final String log_className = BPMi18NUtil.class.getName();
    public static final String BPM_LABEL_RESOURCE_BUNDLE = "oracle.bpm.services.resource.i18n.BPMLabels";
    public static final String PREFIX_EXT_USER_PROP = "EXT_USER_PROP.";

    public static String getLabel(String key, Locale locale) {
        String label = null;
        ResourceBundle customBundle = i18NUtil.getCustomResourceBundle((String)BPM_LABEL_RESOURCE_BUNDLE, (Locale)locale);
        if (customBundle != null) {
            try {
                label = customBundle.getString(key);
            }
            catch (MissingResourceException mre) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)log_className, (String)"getLabel", (String)("\n The key: " + key + " is not found in custom bundle." + " Looking for it in system bundle."));
            }
        }
        if (label == null) {
            label = i18NUtil.getSystemResourceBundle((String)BPM_LABEL_RESOURCE_BUNDLE, (Locale)locale).getString(key);
        }
        return label;
    }

    public static String getExtendedUserPropertiesLabel(String labelName, Locale locale) {
        return BPMi18NUtil.getLabelAddPrefix(labelName, PREFIX_EXT_USER_PROP, locale);
    }

    public static String getMessageFromCustomResourceBundle(Locale locale, String key) {
        String displayValue = null;
        if (locale != null && key != null) {
            ResourceBundle resourceBundle = i18NUtil.getCustomResourceBundle((String)BPM_LABEL_RESOURCE_BUNDLE, (Locale)locale);
            if (resourceBundle != null) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\n Looking for the key: " + key + " in the Custom Resource bundle ..."));
                }
                try {
                    displayValue = resourceBundle.getString(key);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (displayValue == null) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\n The key: " + key + " is not found in Custom Resource bundle"));
                }
            } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\n displayValue: " + displayValue));
            }
        }
        return displayValue;
    }

    public static String getMessageFromSystemResourceBundle(Locale locale, String key) {
        String displayValue = null;
        if (locale != null && key != null) {
            ResourceBundle resourceBundle = i18NUtil.getSystemResourceBundle((String)BPM_LABEL_RESOURCE_BUNDLE, (Locale)locale);
            if (resourceBundle != null) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\n Looking for the key: " + key + " in the System Resource bundle ..."));
                }
                try {
                    displayValue = resourceBundle.getString(key);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (displayValue == null) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\n The key: " + key + " is not found in System Resource bundle"));
                }
            } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)("\n displayValue: " + displayValue));
            }
        }
        return displayValue;
    }

    private static String getLabelAddPrefix(String key, String prefix, Locale locale) {
        String fullKey = prefix + key.replaceAll(" ", "");
        String label = BPMi18NUtil.getMessageFromCustomResourceBundle(locale, fullKey);
        if (label == null) {
            label = BPMi18NUtil.getMessageFromSystemResourceBundle(locale, fullKey);
        }
        if (label == null) {
            label = key;
        }
        return label;
    }
}

