/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processsimulation.impl;

import commonj.work.WorkManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.naming.InitialContext;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.analytics.simulation.SimulationService;
import oracle.bpm.collections.Tuple;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processsimulation.DistributionCriteria;
import oracle.bpm.services.processsimulation.IProcessSimulationService;
import oracle.bpm.services.processsimulation.model.ProcessSimulationModel;
import oracle.bpm.services.processsimulation.model.impl.ProcessSimulationModelImpl;
import org.jetbrains.annotations.NotNull;

public class ProcessSimulationService
implements IProcessSimulationService {
    private IProcessMetadataService processMetadataService;
    private SimulationService simulationService;
    private IUserMetadataService userMetadataService;
    private IVerificationService verificationService;
    private WorkManager workManager;
    private static final String SIMULATION_WORK_MANAGER_LOCAL_JNDI = "wm/SimulationWorkManager";
    private static final String SIMULATION_WORK_MANAGER_LOCAL_LOOKUP = "java:comp/env/wm/SimulationWorkManager";

    public String generateSimulationModel(@NotNull IBPMContext context, @NotNull String name, @NotNull String componentDN, @NotNull Calendar fromDate, @NotNull Calendar toDate, @NotNull DistributionCriteria distributionCriteria) throws BPMException {
        this.validateContext(context);
        Tuple<Calendar, Calendar> fixedDates = this.fixDates(fromDate, toDate, context.getTimeZone());
        ComponentDNModel componentDNModel = ComponentDNModel.parseComponentDN((String)componentDN);
        ProcessMetadataSummary processMetadataSummary = this.getProcessMetadataService().getProcessMetadataSummary(context, componentDNModel.getCompositeDN().getDNString(), componentDNModel.getComponentName());
        if (processMetadataSummary == null) {
            throw new BPMException(72402, (Object[])new String[]{componentDN}, (Throwable)new Exception("Invalid Component DN"));
        }
        try {
            return this.getSimulationService().buildSimulationModel(context, name, componentDN, (Calendar)fixedDates.getFirst(), (Calendar)fixedDates.getSecond(), distributionCriteria);
        }
        catch (Exception initCause) {
            throw new BPMException(72403, (Object[])new String[0], (Throwable)initCause);
        }
    }

    public Number generateProcessSimulationModel(@NotNull IBPMContext context, @NotNull String name, @NotNull String componentDN, @NotNull Calendar fromDate, @NotNull Calendar toDate, @NotNull DistributionCriteria distributionCriteria) throws BPMException {
        try {
            Work work = new Work(context, name, componentDN, fromDate, toDate, distributionCriteria);
            this.getWorkManager().schedule((commonj.work.Work)work);
            return this.getSimulationService().estimateBuildSimulationModel(componentDN, fromDate, toDate);
        }
        catch (Exception initCause) {
            throw new BPMException(72403, (Object[])new String[0], (Throwable)initCause);
        }
    }

    public ProcessSimulationModel getProcessSimulationModel(@NotNull IBPMContext context, @NotNull String model) throws BPMException {
        BPMException exception = null;
        this.validateContext(context);
        UserApplicationDataType userApplicationDataType = null;
        try {
            userApplicationDataType = this.getUserMetadataService().getUserApplicationData((IWorkflowContext)context, model);
        }
        catch (WorkflowException initCause) {
            exception = new BPMException((Exception)((Object)initCause));
        }
        if (userApplicationDataType != null) {
            return ProcessSimulationModelImpl.create((UserApplicationDataType)userApplicationDataType);
        }
        for (ProcessSimulationModel modelView : this.listUserProcessSimulationModel(context, null)) {
            if (!modelView.getName().equalsIgnoreCase(model)) continue;
            return modelView;
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    public void updateProcessSimulationModel(@NotNull IBPMContext context, @NotNull ProcessSimulationModel model) throws BPMException {
        this.validateContext(context);
        ProcessSimulationModelImpl modelViewImpl = model instanceof ProcessSimulationModelImpl ? (ProcessSimulationModelImpl)model : ProcessSimulationModelImpl.create((ProcessSimulationModel)model);
        try {
            this.getUserMetadataService().updateUserApplicationData((IWorkflowContext)context, modelViewImpl.getUserApplicationDataType());
        }
        catch (WorkflowException initCause) {
            throw new BPMException((Exception)((Object)initCause));
        }
    }

    public void removeProcessSimulationModel(@NotNull IBPMContext context, @NotNull String modelId) throws BPMException {
        this.validateContext(context);
        try {
            this.getUserMetadataService().deleteUserApplicationData((IWorkflowContext)context, modelId);
        }
        catch (WorkflowException initCause) {
            throw new BPMException((Exception)((Object)initCause));
        }
    }

    public List<ProcessSimulationModel> listUserProcessSimulationModel(@NotNull IBPMContext context, String user) throws BPMException {
        List userApplicationDataTypeList;
        this.validateContext(context);
        try {
            userApplicationDataTypeList = this.getUserMetadataService().listUserApplicationData((IWorkflowContext)context, "SIMULATION_MODEL", user);
        }
        catch (WorkflowException initCause) {
            throw new BPMException((Exception)((Object)initCause));
        }
        ArrayList<ProcessSimulationModel> result = new ArrayList<ProcessSimulationModel>();
        if (userApplicationDataTypeList != null) {
            for (UserApplicationDataType userApplicationDataType : userApplicationDataTypeList) {
                result.add((ProcessSimulationModel)ProcessSimulationModelImpl.create((UserApplicationDataType)userApplicationDataType));
            }
        }
        return result;
    }

    public List<ProcessSimulationModel> listGrantedProcessSimulationModel(@NotNull IBPMContext context, PrincipleRefType grantee) throws BPMException {
        List userApplicationDataTypeList;
        this.validateContext(context);
        try {
            userApplicationDataTypeList = this.getUserMetadataService().listGrantedUserApplicationData((IWorkflowContext)context, "SIMULATION_MODEL", grantee, false);
        }
        catch (WorkflowException initCause) {
            throw new BPMException((Exception)((Object)initCause));
        }
        ArrayList<ProcessSimulationModel> result = new ArrayList<ProcessSimulationModel>();
        if (userApplicationDataTypeList != null) {
            for (UserApplicationDataType userApplicationDataType : userApplicationDataTypeList) {
                result.add((ProcessSimulationModel)ProcessSimulationModelImpl.create((UserApplicationDataType)userApplicationDataType));
            }
        }
        return result;
    }

    public IProcessMetadataService getProcessMetadataService() {
        return this.processMetadataService;
    }

    public void setProcessMetadataService(IProcessMetadataService processMetadataService) {
        this.processMetadataService = processMetadataService;
    }

    public IUserMetadataService getUserMetadataService() {
        return this.userMetadataService;
    }

    public void setUserMetadataService(@NotNull IUserMetadataService userMetadataService) {
        this.userMetadataService = userMetadataService;
    }

    public IVerificationService getVerificationService() {
        return this.verificationService;
    }

    public void setVerificationService(@NotNull IVerificationService verificationService) {
        this.verificationService = verificationService;
    }

    public SimulationService getSimulationService() {
        return this.simulationService;
    }

    public void setSimulationService(@NotNull SimulationService simulationService) {
        this.simulationService = simulationService;
    }

    private WorkManager getWorkManager() throws Exception {
        if (this.workManager == null) {
            InitialContext initialContext = new InitialContext();
            this.workManager = (WorkManager)initialContext.lookup(SIMULATION_WORK_MANAGER_LOCAL_LOOKUP);
        }
        return this.workManager;
    }

    private void validateContext(@NotNull IBPMContext context) throws BPMException {
        try {
            this.getVerificationService().validateContext((IWorkflowContext)context);
        }
        catch (WorkflowException initCause) {
            throw new BPMException((Exception)((Object)initCause));
        }
    }

    private void createOrUpdate(IBPMContext bpmContext, ProcessSimulationModelImpl newModel) throws BPMException {
        try {
            List applicationDataList = this.getUserMetadataService().listUserApplicationData((IWorkflowContext)bpmContext, "SIMULATION_MODEL", null);
            ProcessSimulationModelImpl oldModel = null;
            for (UserApplicationDataType applicationData : applicationDataList) {
                if (!applicationData.getName().equals(newModel.getName())) continue;
                oldModel = ProcessSimulationModelImpl.create((UserApplicationDataType)applicationData);
                break;
            }
            if (oldModel != null) {
                oldModel.setProcess(newModel.getProcess());
                oldModel.setFrom(newModel.getFrom());
                oldModel.setTo(newModel.getTo());
                oldModel.setDistributionCriteria(newModel.getDistributionCriteria());
                oldModel.setModel(newModel.getModel());
                this.getUserMetadataService().updateUserApplicationData((IWorkflowContext)bpmContext, oldModel.getUserApplicationDataType());
            } else {
                this.getUserMetadataService().createUserApplicationData((IWorkflowContext)bpmContext, newModel.getUserApplicationDataType());
            }
        }
        catch (Exception exception) {
            throw new BPMException(exception);
        }
    }

    private Tuple<Calendar, Calendar> fixDates(@NotNull Calendar from, @NotNull Calendar to, TimeZone timeZone) throws BPMException {
        TimeZone _timeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        Calendar today = Calendar.getInstance();
        today.setTimeZone(_timeZone);
        today.setTimeInMillis(System.currentTimeMillis());
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        if (from.after(to) || from.after(today)) {
            throw new BPMException(72401);
        }
        Calendar localFromDate = Calendar.getInstance();
        localFromDate.setTimeZone(_timeZone);
        localFromDate.setTimeInMillis(from.getTimeInMillis());
        localFromDate.set(11, 0);
        localFromDate.set(12, 0);
        localFromDate.set(13, 0);
        localFromDate.set(14, 0);
        Calendar localToDate = Calendar.getInstance();
        localToDate.setTimeZone(_timeZone);
        localToDate.setTimeInMillis(to.getTimeInMillis());
        localToDate.set(11, 23);
        localToDate.set(12, 59);
        localToDate.set(13, 59);
        localToDate.set(14, 999);
        if (localToDate.after(today)) {
            localToDate.set(1, today.get(1));
            localToDate.set(2, today.get(2));
            localToDate.set(5, today.get(5));
            localToDate.set(11, today.get(11));
            localToDate.set(12, 0);
            localToDate.set(13, 0);
            localToDate.set(14, 0);
        }
        return Tuple.create((Object)localFromDate, (Object)localToDate);
    }

    private class Work
    implements commonj.work.Work {
        private String componentDN;
        private IBPMContext context;
        private DistributionCriteria distributionCriteria;
        private Calendar fromDate;
        private String name;
        private Calendar toDate;

        public Work(@NotNull IBPMContext context, @NotNull String name, @NotNull String componentDN, @NotNull Calendar fromDate, @NotNull Calendar toDate, DistributionCriteria distributionCriteria) {
            this.context = context;
            this.name = name;
            this.componentDN = componentDN;
            this.fromDate = fromDate;
            this.toDate = toDate;
            this.distributionCriteria = distributionCriteria;
        }

        public void release() {
        }

        public boolean isDaemon() {
            return false;
        }

        public void run() {
            try {
                Tuple fixedDates = ProcessSimulationService.this.fixDates(this.fromDate, this.toDate, this.context.getTimeZone());
                String model = ProcessSimulationService.this.generateSimulationModel(this.context, this.name, this.componentDN, (Calendar)fixedDates.getFirst(), (Calendar)fixedDates.getSecond(), this.distributionCriteria);
                ProcessSimulationModelImpl processSimulationModel = ProcessSimulationModelImpl.create((String)this.name, (String)this.componentDN, (Calendar)((Calendar)fixedDates.getFirst()), (Calendar)((Calendar)fixedDates.getSecond()), (DistributionCriteria)this.distributionCriteria);
                processSimulationModel.setModel(model);
                ProcessSimulationService.this.createOrUpdate(this.context, processSimulationModel);
            }
            catch (Exception initCause) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_SIMULATION_SERVICE, (Severity)Severity.WARNING, (Throwable)initCause);
            }
        }
    }
}

