/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processmetadata.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import oracle.bpm.services.processmetadata.ObjectFactory;
import oracle.bpm.services.processmetadata.ProjectMetadataSummary;
import oracle.bpm.services.processmetadata.StatusEnum;
import oracle.bpm.services.processmetadata.Tag;
import oracle.bpm.services.processmetadata.TagListType;
import oracle.bpm.services.processmetadata.impl.QueryArgument;
import oracle.bpm.services.processmetadata.impl.QueryArgumentConstants;
import oracle.bpm.services.processmetadata.impl.Util;

public class UtilTest
extends TestCase {
    private static ObjectFactory sProcessMetadataFactory = new ObjectFactory();

    public void testConstructTagListType1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        String columnTags = null;
        TagListType tagListType = Util.constructTagListType(columnTags);
        UtilTest.assertNotNull((Object)tagListType);
        List tagList = tagListType.getTag();
        UtilTest.assertNotNull((Object)tagList);
        UtilTest.assertTrue((boolean)tagList.isEmpty());
    }

    public void testConstructTagListType2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        String columnTags = "";
        TagListType tagListType = Util.constructTagListType(columnTags);
        UtilTest.assertNotNull((Object)tagListType);
        List tagList = tagListType.getTag();
        UtilTest.assertNotNull((Object)tagList);
        UtilTest.assertTrue((boolean)tagList.isEmpty());
    }

    public void testConstructTagListType3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        String columnTags = "tag1";
        TagListType tagListType = Util.constructTagListType(columnTags);
        UtilTest.assertNotNull((Object)tagListType);
        List tagList = tagListType.getTag();
        UtilTest.assertNotNull((Object)tagList);
        UtilTest.assertEquals((int)1, (int)tagList.size());
        Tag tag = (Tag)tagList.get(0);
        UtilTest.assertNotNull((Object)tag);
        UtilTest.assertNotNull((Object)tag.getName());
        UtilTest.assertEquals((String)"tag1", (String)tag.getName());
    }

    public void testConstructTagListType4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        String columnTags = "tag1:tag2";
        TagListType tagListType = Util.constructTagListType(columnTags);
        UtilTest.assertNotNull((Object)tagListType);
        List tagList = tagListType.getTag();
        UtilTest.assertNotNull((Object)tagList);
        UtilTest.assertEquals((int)1, (int)tagList.size());
        Tag tag = (Tag)tagList.get(0);
        UtilTest.assertNotNull((Object)tag);
        UtilTest.assertNotNull((Object)tag.getName());
        UtilTest.assertEquals((String)"tag1:tag2", (String)tag.getName());
    }

    public void testConstructTagListType5() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        String columnTags = "tag1;tag2;tag3";
        TagListType tagListType = Util.constructTagListType(columnTags);
        UtilTest.assertNotNull((Object)tagListType);
        List tagList = tagListType.getTag();
        UtilTest.assertNotNull((Object)tagList);
        UtilTest.assertEquals((int)3, (int)tagList.size());
        Tag tag1 = (Tag)tagList.get(0);
        UtilTest.assertNotNull((Object)tag1);
        UtilTest.assertNotNull((Object)tag1.getName());
        UtilTest.assertEquals((String)"tag1", (String)tag1.getName());
        Tag tag2 = (Tag)tagList.get(1);
        UtilTest.assertNotNull((Object)tag2);
        UtilTest.assertNotNull((Object)tag2.getName());
        UtilTest.assertEquals((String)"tag2", (String)tag2.getName());
        Tag tag3 = (Tag)tagList.get(2);
        UtilTest.assertNotNull((Object)tag3);
        UtilTest.assertNotNull((Object)tag3.getName());
        UtilTest.assertEquals((String)"tag3", (String)tag3.getName());
    }

    public void testGetValueFromResultSetObject1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        QueryArgument argument = null;
        Object resultSetValue = null;
        Object resultObj = Util.getValueFromResultSetObject(argument, resultSetValue);
        UtilTest.assertNull((Object)resultObj);
    }

    public void testGetValueFromResultSetObject2() {
        String stringValue;
        System.out.println("\n ===>>> Test name: " + this.getName());
        QueryArgument argument = null;
        String resultSetValue = null;
        resultSetValue = stringValue = "string_value";
        Object resultObj = Util.getValueFromResultSetObject(argument, resultSetValue);
        UtilTest.assertNull((Object)resultObj);
    }

    public void testGetValueFromResultSetObject3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        QueryArgument argument = null;
        Object resultSetValue = null;
        argument = QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT;
        Object resultObj = Util.getValueFromResultSetObject(argument, resultSetValue);
        UtilTest.assertNull((Object)resultObj);
    }

    public void testGetValueFromResultSetObject4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        String resultSetValue = "String_value";
        Object resultObj = Util.getValueFromResultSetObject(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT, resultSetValue);
        UtilTest.assertNotNull((Object)resultObj);
        UtilTest.assertNotNull(resultObj.getClass());
        UtilTest.assertNotNull((Object)resultObj.toString());
        String className = resultObj.getClass().getName();
        UtilTest.assertNotNull((Object)className);
        if (className.equals("java.lang.String")) {
            String stringValue = (String)resultObj;
            UtilTest.assertEquals((String)resultSetValue, (String)stringValue);
        }
    }

    public void testGetValueFromResultSetObject5() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Long resultSetValue = new Long(1L);
        Object resultObj = Util.getValueFromResultSetObject(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT, resultSetValue);
        UtilTest.assertNotNull((Object)resultObj);
        UtilTest.assertNotNull(resultObj.getClass());
        UtilTest.assertNotNull((Object)resultObj.toString());
        String className = resultObj.getClass().getName();
        UtilTest.assertNotNull((Object)className);
        if (className.equals("java.lang.Long")) {
            Long longValue = (Long)resultObj;
            UtilTest.assertEquals((long)resultSetValue, (long)longValue);
        }
    }

    public void testGetValueFromResultSetObject6() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Object resultSetValue = new Object();
        Object resultObj = Util.getValueFromResultSetObject(QueryArgumentConstants.BPM_CUBE_PROCESS_CREATIONDATE_ARGUMENT, resultSetValue);
        UtilTest.assertNotNull((Object)resultObj);
        UtilTest.assertNotNull(resultObj.getClass());
        UtilTest.assertNotNull((Object)resultObj.toString());
        String className = resultObj.getClass().getName();
        UtilTest.assertNotNull((Object)className);
        if (className.equals("java.lang.Object")) {
            Object objectValue = resultObj;
            UtilTest.assertNotNull((Object)objectValue);
        }
    }

    public void testGetValueFromResultSetObject7() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        QueryArgument dummyColumn = new QueryArgument.Builder("dummyDbTableName", "dummyDbColumnName", "java.lang.Integer", "dummyEntityObjectName").build();
        Integer resultSetValue = new Integer(2);
        Object resultObj = Util.getValueFromResultSetObject(dummyColumn, resultSetValue);
        UtilTest.assertNotNull((Object)resultObj);
        UtilTest.assertNotNull(resultObj.getClass());
        UtilTest.assertNotNull((Object)resultObj.toString());
        String className = resultObj.getClass().getName();
        UtilTest.assertNotNull((Object)className);
        if (className.equals("java.lang.String")) {
            String stringValue = (String)resultObj;
            UtilTest.assertNotNull((Object)stringValue);
        } else if (className.equals("java.lang.Long")) {
            Long longValue = (Long)resultObj;
            UtilTest.assertNotNull((Object)longValue);
        } else if (className.equals("java.lang.Object")) {
            Object objectValue = resultObj;
            UtilTest.assertNotNull((Object)objectValue);
        } else {
            Object objectValue = resultObj;
            UtilTest.assertNotNull((Object)objectValue);
        }
    }

    public void testValidate1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = null;
        objectArray = new Object[]{};
        try {
            Util.validate(argumentList, objectArray);
            UtilTest.fail((String)"Code path should not reach here");
        }
        catch (Exception e) {
            UtilTest.assertTrue((boolean)true);
        }
    }

    public void testValidate2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = null;
        argumentList = new LinkedList<QueryArgument>();
        try {
            Util.validate(argumentList, objectArray);
            UtilTest.fail((String)"Code path should not reach here");
        }
        catch (Exception e) {
            UtilTest.assertTrue((boolean)true);
        }
    }

    public void testValidate3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = null;
        argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        try {
            Util.validate(argumentList, objectArray);
            UtilTest.fail((String)"Code path should not reach here");
        }
        catch (Exception e) {
            UtilTest.assertTrue((boolean)true);
        }
    }

    public void testValidate4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = null;
        argumentList = new LinkedList<QueryArgument>();
        objectArray = new Object[]{new Object()};
        try {
            Util.validate(argumentList, objectArray);
            UtilTest.fail((String)"Code path should not reach here");
        }
        catch (Exception e) {
            UtilTest.assertTrue((boolean)true);
        }
    }

    public void testValidate5() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = null;
        argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        objectArray = new Object[]{"process_A"};
        try {
            Util.validate(argumentList, objectArray);
            UtilTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            UtilTest.fail((String)"Code path should not reach here");
        }
    }

    public void testCompareArgumentMaps1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Map<String, QueryArgument> map1 = null;
        Map<String, QueryArgument> map2 = null;
        boolean same = Util.compareArgumentMaps(map1, map2);
        UtilTest.assertTrue((boolean)same);
    }

    public void testCompareArgumentMaps2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Map<String, QueryArgument> map1 = null;
        Hashtable<String, QueryArgument> map2 = new Hashtable<String, QueryArgument>();
        boolean same = Util.compareArgumentMaps(map1, map2);
        UtilTest.assertFalse((boolean)same);
    }

    public void testCompareArgumentMaps3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Hashtable<String, QueryArgument> map1 = new Hashtable<String, QueryArgument>();
        Map<String, QueryArgument> map2 = null;
        boolean same = Util.compareArgumentMaps(map1, map2);
        UtilTest.assertFalse((boolean)same);
    }

    public void testCompareArgumentMaps4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Hashtable<String, QueryArgument> map1 = new Hashtable<String, QueryArgument>();
        Hashtable<String, QueryArgument> map2 = new Hashtable<String, QueryArgument>();
        boolean same = Util.compareArgumentMaps(map1, map2);
        UtilTest.assertTrue((boolean)same);
    }

    public void testCompareArgumentMaps5() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Hashtable<String, QueryArgument> map1 = new Hashtable<String, QueryArgument>();
        map1.put(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT.getDBColumnName(), QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        Hashtable<String, QueryArgument> map2 = new Hashtable<String, QueryArgument>();
        boolean same = Util.compareArgumentMaps(map1, map2);
        UtilTest.assertFalse((boolean)same);
    }

    public void testCompareArgumentMaps6() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Hashtable<String, QueryArgument> map1 = new Hashtable<String, QueryArgument>();
        map1.put(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT.getDBColumnName(), QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        Hashtable<String, QueryArgument> map2 = new Hashtable<String, QueryArgument>();
        map2.put(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT.getDBColumnName(), QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        boolean same = Util.compareArgumentMaps(map1, map2);
        UtilTest.assertFalse((boolean)same);
    }

    public void testCompareArgumentMaps7() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Hashtable<String, QueryArgument> map1 = new Hashtable<String, QueryArgument>();
        map1.put(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT.getDBColumnName(), QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        Hashtable<String, QueryArgument> map2 = new Hashtable<String, QueryArgument>();
        map2.put(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT.getDBColumnName(), QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        boolean same = Util.compareArgumentMaps(map1, map2);
        UtilTest.assertFalse((boolean)same);
    }

    public void testCompareArgumentMaps8() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Hashtable<String, QueryArgument> map1 = new Hashtable<String, QueryArgument>();
        map1.put(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT.getDBColumnName(), QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        Hashtable<String, QueryArgument> map2 = new Hashtable<String, QueryArgument>();
        map2.put(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT.getDBColumnName(), QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        boolean same = Util.compareArgumentMaps(map1, map2);
        UtilTest.assertTrue((boolean)same);
    }

    public void testCompareArgumentMaps9() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Hashtable<String, QueryArgument> map1 = new Hashtable<String, QueryArgument>();
        map1.put(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT.getDBColumnName(), QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        map1.put(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT.getDBColumnName(), QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Hashtable<String, QueryArgument> map2 = new Hashtable<String, QueryArgument>();
        map2.put(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT.getDBColumnName(), QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        map2.put(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT.getDBColumnName(), QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        boolean same = Util.compareArgumentMaps(map1, map2);
        UtilTest.assertTrue((boolean)same);
    }

    public void testConvertArgumentListToMap1() throws Exception {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        try {
            Map<String, QueryArgument> map = Util.convertArgumentListToMap(argumentList);
            UtilTest.assertNotNull(map);
            UtilTest.assertTrue((boolean)map.isEmpty());
        }
        catch (Exception e) {
            UtilTest.fail((String)"Code path should not reach here");
        }
    }

    public void testConvertArgumentListToMap2() throws Exception {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        try {
            Map<String, QueryArgument> map = Util.convertArgumentListToMap(argumentList);
            UtilTest.assertNotNull(map);
            UtilTest.assertTrue((boolean)map.isEmpty());
        }
        catch (Exception e) {
            UtilTest.fail((String)"Code path should not reach here");
        }
    }

    public void testConvertArgumentListToMap3() throws Exception {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        try {
            Map<String, QueryArgument> map = Util.convertArgumentListToMap(argumentList);
            UtilTest.fail((String)"Code path should not reach here");
        }
        catch (Exception e) {
            UtilTest.assertTrue((boolean)true);
        }
    }

    public void testConvertArgumentListToMap4() throws Exception {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT);
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        try {
            Map<String, QueryArgument> map = Util.convertArgumentListToMap(argumentList);
            UtilTest.fail((String)"Code path should not reach here");
        }
        catch (Exception e) {
            UtilTest.assertTrue((boolean)true);
        }
    }

    public void testConvertArgumentListToMap5() throws Exception {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT);
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        LinkedList<QueryArgument> expectedArgumentList = new LinkedList<QueryArgument>();
        expectedArgumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        expectedArgumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        expectedArgumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEDN_ARGUMENT);
        try {
            Map<String, QueryArgument> map = Util.convertArgumentListToMap(argumentList);
            UtilTest.assertNotNull(map);
            Map<String, QueryArgument> expectedMap = Util.convertArgumentListToMap(expectedArgumentList);
            UtilTest.assertNotNull(expectedMap);
            boolean same = Util.compareArgumentMaps(map, expectedMap);
            UtilTest.assertFalse((boolean)same);
        }
        catch (Exception e) {
            UtilTest.fail((String)"Code path should not reach here");
        }
    }

    public void testConvertArgumentListToMap6() throws Exception {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT);
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        LinkedList<QueryArgument> expectedArgumentList = new LinkedList<QueryArgument>();
        expectedArgumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        expectedArgumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        expectedArgumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT);
        try {
            Map<String, QueryArgument> map = Util.convertArgumentListToMap(argumentList);
            UtilTest.assertNotNull(map);
            Map<String, QueryArgument> expectedMap = Util.convertArgumentListToMap(expectedArgumentList);
            UtilTest.assertNotNull(expectedMap);
            boolean same = Util.compareArgumentMaps(map, expectedMap);
            UtilTest.assertTrue((boolean)same);
        }
        catch (Exception e) {
            UtilTest.fail((String)"Code path should not reach here");
        }
    }

    public void testGetArgumentIndexInQuery1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT;
        int expected = -1;
        int position = Util.getArgumentIndexInQuery(argumentList, argument);
        UtilTest.assertEquals((int)expected, (int)position);
    }

    public void testGetArgumentIndexInQuery2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT;
        int expected = -1;
        int position = Util.getArgumentIndexInQuery(argumentList, argument);
        UtilTest.assertEquals((int)expected, (int)position);
    }

    public void testGetArgumentIndexInQuery3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        QueryArgument argument = null;
        int expected = -1;
        int position = Util.getArgumentIndexInQuery(argumentList, argument);
        UtilTest.assertEquals((int)expected, (int)position);
    }

    public void testGetArgumentIndexInQuery4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT;
        int expected = -1;
        int position = Util.getArgumentIndexInQuery(argumentList, argument);
        UtilTest.assertEquals((int)expected, (int)position);
    }

    public void testGetArgumentIndexInQuery5() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT;
        int expected = 0;
        int position = Util.getArgumentIndexInQuery(argumentList, argument);
        UtilTest.assertEquals((int)expected, (int)position);
    }

    public void testGetArgumentIndexInQuery6() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_DOMAINNAME_ARGUMENT);
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT);
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT;
        int expected = 3;
        int position = Util.getArgumentIndexInQuery(argumentList, argument);
        UtilTest.assertEquals((int)expected, (int)position);
    }

    public void testGetParameterValueFromResultSet1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = null;
        QueryArgument argument = null;
        Object result = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        UtilTest.assertNull((Object)result);
    }

    public void testGetParameterValueFromResultSet2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = null;
        QueryArgument argument = null;
        argumentList = new LinkedList<QueryArgument>();
        Object result = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        UtilTest.assertNull((Object)result);
    }

    public void testGetParameterValueFromResultSet3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = null;
        QueryArgument argument = null;
        argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object result = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        UtilTest.assertNull((Object)result);
    }

    public void testGetParameterValueFromResultSet4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = new Object[]{};
        QueryArgument argument = null;
        argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object result = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        UtilTest.assertNull((Object)result);
    }

    public void testGetParameterValueFromResultSet5() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = new Object[]{new Long(1L)};
        QueryArgument argument = null;
        argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object result = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        UtilTest.assertNull((Object)result);
    }

    public void testGetParameterValueFromResultSet6() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = new Object[]{new Long(1L)};
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT;
        argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        Object result = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        UtilTest.assertNull((Object)result);
    }

    public void testGetParameterValueFromResultSet7() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = null;
        Object[] objectArray = new Object[]{new Long(1L)};
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT;
        argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object result = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        UtilTest.assertNotNull((Object)result);
    }

    public void testGetProcessId1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        Object[] objectArray = new Object[]{new Long(1L)};
        Long result = Util.getProcessId(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetProcessId2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{new Long(1L)};
        int expected = 1;
        Long result = Util.getProcessId(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((long)expected, (long)result);
    }

    public void testGetProcessName1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"process_A"};
        String result = Util.getProcessName(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetProcessName2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        Object[] objectArray = new Object[]{"process_A"};
        String expected = "process_A";
        String result = Util.getProcessName(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetDomainName1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"domain_A"};
        String result = Util.getDomainName(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetDomainName2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_DOMAINNAME_ARGUMENT);
        Object[] objectArray = new Object[]{"domain_A"};
        String expected = "domain_A";
        String result = Util.getDomainName(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetCompositeName1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"InitiableTaskProject"};
        String result = Util.getCompositeName(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetCompositeName2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT);
        Object[] objectArray = new Object[]{"InitiableTaskProject"};
        String expected = "InitiableTaskProject";
        String result = Util.getCompositeName(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetCompositeRevision1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"1.0"};
        String result = Util.getCompositeRevision(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetCompositeRevision2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEREVISION_ARGUMENT);
        Object[] objectArray = new Object[]{"1.0"};
        String expected = "1.0";
        String result = Util.getCompositeRevision(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetSCALabel1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        String scaLabel = "soa_c5d73288-83f5-4194-a66a-e208c1ab5647";
        Object[] objectArray = new Object[]{scaLabel};
        String result = Util.getSCALabel(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetSCALabel2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITELABEL_ARGUMENT);
        String scaLabel = "soa_c5d73288-83f5-4194-a66a-e208c1ab5647";
        Object[] objectArray = new Object[]{scaLabel};
        String expected = scaLabel;
        String result = Util.getSCALabel(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetCompositeDN1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        String compositeDN = "default/HWFM4IntegratedTestProject!1.0*soa_c5d73288-83f5-4194-a66a-e208c1ab5647";
        Object[] objectArray = new Object[]{compositeDN};
        String result = Util.getCompositeDN(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetCompositeDN2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEDN_ARGUMENT);
        String compositeDN = "default/HWFM4IntegratedTestProject!1.0*soa_c5d73288-83f5-4194-a66a-e208c1ab5647";
        Object[] objectArray = new Object[]{compositeDN};
        String expected = compositeDN;
        String result = Util.getCompositeDN(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetLabel1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"HWFM4IntegratedTestProcess"};
        String result = Util.getLabel(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetLabel2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_LABEL_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getLabel(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetLabel3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_LABEL_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getLabel(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetLabel4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_LABEL_ARGUMENT);
        Object[] objectArray = new Object[]{"HWFM4IntegratedTestProcess"};
        String expected = "HWFM4IntegratedTestProcess";
        String result = Util.getLabel(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testProcessType1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"BPMN"};
        String result = Util.getProcessType(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testProcessType2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSTYPE_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getProcessType(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testProcessType3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSTYPE_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getProcessType(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testProcessType4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSTYPE_ARGUMENT);
        Object[] objectArray = new Object[]{"BPMN"};
        String expected = "BPMN";
        String result = Util.getProcessType(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetTargetNamespace1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"namespace_1"};
        String result = Util.getTargetNamespace(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetTargetNamespace2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TARGETNAMESPACE_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getTargetNamespace(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetTargetNamespace3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TARGETNAMESPACE_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getTargetNamespace(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetTargetNamespace4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TARGETNAMESPACE_ARGUMENT);
        Object[] objectArray = new Object[]{"namespace_1"};
        String expected = "namespace_1";
        String result = Util.getTargetNamespace(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetStatus1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{new Long(1L)};
        Long result = Util.getStatus(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetStatus2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_STATUS_ARGUMENT);
        Object[] objectArray = new Object[]{};
        Long result = Util.getStatus(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetStatus3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_STATUS_ARGUMENT);
        Object[] objectArray = new Object[]{new Long(0L)};
        int expected = 0;
        Long result = Util.getStatus(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((long)expected, (long)result);
    }

    public void testGetStatus4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_STATUS_ARGUMENT);
        Object[] objectArray = new Object[]{new Long(-1L)};
        int expected = -1;
        Long result = Util.getStatus(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((long)expected, (long)result);
    }

    public void testGetCreationDate1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{new Object()};
        Object result = Util.getCreationDate(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetCreationDate2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CREATIONDATE_ARGUMENT);
        Object[] objectArray = new Object[]{};
        Object result = Util.getCreationDate(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetCreationDate3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CREATIONDATE_ARGUMENT);
        Object expected = new Object();
        Object[] objectArray = new Object[]{expected};
        Object result = Util.getCreationDate(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((Object)expected, (Object)result);
    }

    public void testGetUndeployDate1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{new Object()};
        Object result = Util.getUndeployDate(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetUndeployDate2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_UNDEPLOYDATE_ARGUMENT);
        Object[] objectArray = new Object[]{};
        Object result = Util.getUndeployDate(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetUndeployDate3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_UNDEPLOYDATE_ARGUMENT);
        Object expected = new Object();
        Object[] objectArray = new Object[]{expected};
        Object result = Util.getUndeployDate(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((Object)expected, (Object)result);
    }

    public void testGetOrganizationalUnitId1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"California"};
        String result = Util.getOrganizationalUnitId(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetOrganizationalUnitId2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_ORGANIZATIONALUNITID_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getOrganizationalUnitId(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetOrganizationalUnitId3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_ORGANIZATIONALUNITID_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getOrganizationalUnitId(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetOrganizationalUnitId4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_ORGANIZATIONALUNITID_ARGUMENT);
        Object[] objectArray = new Object[]{"California"};
        String expected = "California";
        String result = Util.getOrganizationalUnitId(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetHasGlobalCreationTasks1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"Y"};
        String result = Util.getHasGlobalCreationTasks(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetHasGlobalCreationTasks2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_HASGLOBALCREATIONTASKS_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getHasGlobalCreationTasks(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetHasGlobalCreationTasks3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_HASGLOBALCREATIONTASKS_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getHasGlobalCreationTasks(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetHasGlobalCreationTasks4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_HASGLOBALCREATIONTASKS_ARGUMENT);
        Object[] objectArray = new Object[]{"Y"};
        String expected = "Y";
        String result = Util.getHasGlobalCreationTasks(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetSubType1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"subType"};
        String result = Util.getSubType(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetSubType2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_SUBTYPE_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getSubType(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetSubType3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_SUBTYPE_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getSubType(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetSubType4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_SUBTYPE_ARGUMENT);
        Object[] objectArray = new Object[]{"subType"};
        String expected = "subType";
        String result = Util.getSubType(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetMigrationStatus1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"LATEST"};
        String result = Util.getMigrationStatus(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetMigrationStatus2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_MIGRATIONSTATUS_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getMigrationStatus(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetMigrationStatus3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_MIGRATIONSTATUS_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getMigrationStatus(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetMigrationStatus4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_MIGRATIONSTATUS_ARGUMENT);
        Object[] objectArray = new Object[]{"LATEST"};
        String expected = "LATEST";
        String result = Util.getMigrationStatus(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetActivityName1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"a3"};
        String result = Util.getActivityName(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetActivityName2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ACTIVITYNAME_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getActivityName(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetActivityName3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ACTIVITYNAME_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getActivityName(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetActivityName4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ACTIVITYNAME_ARGUMENT);
        Object[] objectArray = new Object[]{"a3"};
        String expected = "a3";
        String result = Util.getActivityName(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetActivityLabel1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"InitiationTask"};
        String result = Util.getActivityLabel(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetActivityLabel2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ACTIVITYLABEL_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getActivityLabel(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetActivityLabel3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ACTIVITYLABEL_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getActivityLabel(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetActivityLabel4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ACTIVITYLABEL_ARGUMENT);
        Object[] objectArray = new Object[]{"InitiationTask"};
        String expected = "InitiationTask";
        String result = Util.getActivityLabel(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetTaskRole1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        Object[] objectArray = new Object[]{"ProcessBrokerProject.ProcessOwner"};
        String result = Util.getTaskRole(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetTaskRole2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ROLE_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getTaskRole(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetTaskRole3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ROLE_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getTaskRole(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetTaskRole4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ROLE_ARGUMENT);
        Object[] objectArray = new Object[]{"ProcessBrokerProject.ProcessOwner"};
        String expected = "ProcessBrokerProject.ProcessOwner";
        String result = Util.getTaskRole(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetTaskDefinitionId1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        String taskDefinitionId = "default/InitiableTaskProject!1.0*soa_5c88937c-1c2f-492f-b06d-c664c7a49357/Humantask1";
        Object[] objectArray = new Object[]{taskDefinitionId};
        String result = Util.getTaskDefinitionId(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetTaskDefinitionId2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_SYSTEMSTRING01_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getTaskDefinitionId(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetTaskDefinitionId3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_SYSTEMSTRING01_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getTaskDefinitionId(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetTaskDefinitionId4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_SYSTEMSTRING01_ARGUMENT);
        String taskDefinitionId = "default/InitiableTaskProject!1.0*soa_5c88937c-1c2f-492f-b06d-c664c7a49357/Humantask1";
        Object[] objectArray = new Object[]{taskDefinitionId};
        String expected = taskDefinitionId;
        String result = Util.getTaskDefinitionId(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetRole1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        String role = "InitiableTaskProject.Developer";
        Object[] objectArray = new Object[]{role};
        String result = Util.getRole(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetRole2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_ROLE_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getRole(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetRole3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_ROLE_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getRole(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetRole4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_ROLE_ARGUMENT);
        String role = "InitiableTaskProject.Developer";
        Object[] objectArray = new Object[]{role};
        String expected = role;
        String result = Util.getRole(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetApplicationLinkDisplayName1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        String applicationLinkDisplayName = "InitiableTaskProcess";
        Object[] objectArray = new Object[]{applicationLinkDisplayName};
        String result = Util.getApplicationLinkDisplayName(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetApplicationLinkDisplayName2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_APPLICATIONLINKDISPLAYNAME_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getApplicationLinkDisplayName(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetApplicationLinkDisplayName3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_APPLICATIONLINKDISPLAYNAME_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getApplicationLinkDisplayName(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetApplicationLinkDisplayName4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_APPLICATIONLINKDISPLAYNAME_ARGUMENT);
        String applicationLinkDisplayName = "InitiableTaskProcess";
        Object[] objectArray = new Object[]{applicationLinkDisplayName};
        String expected = applicationLinkDisplayName;
        String result = Util.getApplicationLinkDisplayName(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetCategory1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        String category = "category_1";
        Object[] objectArray = new Object[]{category};
        String result = Util.getCategory(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetCategory2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CATEGORY_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getCategory(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetCategory3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CATEGORY_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getCategory(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetCategory4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CATEGORY_ARGUMENT);
        String category = "category_1";
        Object[] objectArray = new Object[]{category};
        String expected = category;
        String result = Util.getCategory(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetTags1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        String tag = "Tag_1";
        Object[] objectArray = new Object[]{tag};
        String result = Util.getTags(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetTags2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TAGS_ARGUMENT);
        Object[] objectArray = new Object[]{};
        String result = Util.getTags(argumentList, objectArray);
        UtilTest.assertNull((Object)result);
    }

    public void testGetTags3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TAGS_ARGUMENT);
        Object[] objectArray = new Object[]{""};
        String expected = "";
        String result = Util.getTags(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testGetTags4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TAGS_ARGUMENT);
        String tag = "Tag_1";
        Object[] objectArray = new Object[]{tag};
        String expected = tag;
        String result = Util.getTags(argumentList, objectArray);
        UtilTest.assertNotNull((Object)result);
        UtilTest.assertEquals((String)expected, (String)result);
    }

    public void testConstructProcessQueryString1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        boolean isBPMAdminUser = false;
        String compositeDN = null;
        String keyword = null;
        String sortAttribute = null;
        String sortOrder = null;
        ArrayList<String> organizationalUnitIdList = new ArrayList<String>();
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        keyword = "Initiable";
        String queryString = Util.constructProcessQueryString(isBPMAdminUser, compositeDN, keyword, sortAttribute, sortOrder, organizationalUnitIdList, argumentList);
        System.out.println("\n queryString: " + queryString);
        System.out.println("\n argumentList: " + argumentList);
        System.out.println("\n argumentList.size(): " + argumentList.size());
        UtilTest.assertNotNull(argumentList);
        LinkedList<QueryArgument> expectedArgumentList = QueryArgumentConstants.getAllQueryArgumentsList();
        UtilTest.assertNotNull(expectedArgumentList);
        try {
            Map<String, QueryArgument> map = Util.convertArgumentListToMap(argumentList);
            UtilTest.assertNotNull(map);
            Map<String, QueryArgument> expectedMap = Util.convertArgumentListToMap(expectedArgumentList);
            UtilTest.assertNotNull(expectedMap);
            boolean same = Util.compareArgumentMaps(map, expectedMap);
            UtilTest.assertTrue((boolean)same);
        }
        catch (Exception e) {
            UtilTest.fail((String)"Code path should not reach here");
        }
    }

    public void testConstructProcessQueryString2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        boolean isBPMAdminUser = false;
        String compositeDN = null;
        String projectName = null;
        ArrayList<String> organizationalUnitIdList = new ArrayList<String>();
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        String queryString = Util.constructProjectQueryString(isBPMAdminUser, compositeDN, projectName, organizationalUnitIdList, argumentList);
        System.out.println("\n queryString: " + queryString);
        System.out.println("\n argumentList: " + argumentList);
        System.out.println("\n argumentList.size(): " + argumentList.size());
        UtilTest.assertNotNull(argumentList);
        LinkedList<QueryArgument> expectedArgumentList = QueryArgumentConstants.getAllQueryArgumentsList();
        UtilTest.assertNotNull(expectedArgumentList);
        try {
            Map<String, QueryArgument> map = Util.convertArgumentListToMap(argumentList);
            UtilTest.assertNotNull(map);
            Map<String, QueryArgument> expectedMap = Util.convertArgumentListToMap(expectedArgumentList);
            UtilTest.assertNotNull(expectedMap);
            boolean same = Util.compareArgumentMaps(map, expectedMap);
            UtilTest.assertTrue((boolean)same);
        }
        catch (Exception e) {
            UtilTest.fail((String)"Code path should not reach here");
        }
    }

    public void testConstructProcessQueryString3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        boolean isBPMAdminUser = false;
        String compositeDN = null;
        String processName = null;
        ArrayList<String> organizationalUnitIdList = new ArrayList<String>();
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        String queryString = Util.constructProcessQueryString(isBPMAdminUser, compositeDN, processName, organizationalUnitIdList, argumentList);
        System.out.println("\n queryString: " + queryString);
        System.out.println("\n argumentList: " + argumentList);
        System.out.println("\n argumentList.size(): " + argumentList.size());
        UtilTest.assertNotNull(argumentList);
        LinkedList<QueryArgument> expectedArgumentList = QueryArgumentConstants.getAllQueryArgumentsList();
        UtilTest.assertNotNull(expectedArgumentList);
        try {
            Map<String, QueryArgument> map = Util.convertArgumentListToMap(argumentList);
            UtilTest.assertNotNull(map);
            Map<String, QueryArgument> expectedMap = Util.convertArgumentListToMap(expectedArgumentList);
            UtilTest.assertNotNull(expectedMap);
            boolean same = Util.compareArgumentMaps(map, expectedMap);
            UtilTest.assertTrue((boolean)same);
        }
        catch (Exception e) {
            UtilTest.fail((String)"Code path should not reach here");
        }
    }

    public void testConstructProcessQueryString4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        boolean isBPMAdminUser = false;
        ArrayList<String> applicationRolesList = new ArrayList<String>();
        ArrayList<String> organizationalUnitIdList = new ArrayList<String>();
        LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
        String queryString = Util.constructProcessQueryString(isBPMAdminUser, applicationRolesList, organizationalUnitIdList, argumentList);
        System.out.println("\n queryString: " + queryString);
        System.out.println("\n argumentList: " + argumentList);
        System.out.println("\n argumentList.size(): " + argumentList.size());
        UtilTest.assertNotNull(argumentList);
        LinkedList<QueryArgument> expectedArgumentList = QueryArgumentConstants.getQueryArgumentsList_UserTask();
        System.out.println("\n expectedArgumentList: " + expectedArgumentList);
        System.out.println("\n expectedArgumentList.size(): " + expectedArgumentList.size());
        UtilTest.assertNotNull(expectedArgumentList);
        try {
            Map<String, QueryArgument> map = Util.convertArgumentListToMap(argumentList);
            UtilTest.assertNotNull(map);
            Map<String, QueryArgument> expectedMap = Util.convertArgumentListToMap(expectedArgumentList);
            UtilTest.assertNotNull(expectedMap);
            boolean same = Util.compareArgumentMaps(map, expectedMap);
            UtilTest.assertTrue((boolean)same);
        }
        catch (Exception e) {
            UtilTest.fail((String)"Code path should not reach here");
        }
    }

    public void testIsRolePresent1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        List<String> applicationRoleNamesList = null;
        String roleName = null;
        boolean result = false;
        result = Util.isRolePresent(applicationRoleNamesList, roleName);
        UtilTest.assertFalse((boolean)result);
    }

    public void testIsRolePresent2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        List<String> applicationRoleNamesList = null;
        String roleName = "blah";
        boolean result = false;
        result = Util.isRolePresent(applicationRoleNamesList, roleName);
        UtilTest.assertFalse((boolean)result);
    }

    public void testIsRolePresent3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        ArrayList<String> applicationRoleNamesList = new ArrayList<String>();
        String roleName = null;
        boolean result = false;
        result = Util.isRolePresent(applicationRoleNamesList, roleName);
        UtilTest.assertFalse((boolean)result);
    }

    public void testIsRolePresent4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        ArrayList<String> applicationRoleNamesList = new ArrayList<String>();
        String roleName = "";
        boolean result = false;
        result = Util.isRolePresent(applicationRoleNamesList, roleName);
        UtilTest.assertFalse((boolean)result);
    }

    public void testIsRolePresent5() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        ArrayList<String> applicationRoleNamesList = new ArrayList<String>();
        String roleName = "";
        boolean result = false;
        applicationRoleNamesList.add("Role_A");
        result = Util.isRolePresent(applicationRoleNamesList, roleName);
        UtilTest.assertFalse((boolean)result);
    }

    public void testIsRolePresent6() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        ArrayList<String> applicationRoleNamesList = new ArrayList<String>();
        String roleName = "";
        boolean result = false;
        applicationRoleNamesList.add("");
        result = Util.isRolePresent(applicationRoleNamesList, roleName);
        UtilTest.assertTrue((boolean)result);
    }

    public void testIsRolePresent7() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        ArrayList<String> applicationRoleNamesList = new ArrayList<String>();
        String roleName = "blah";
        boolean result = false;
        applicationRoleNamesList.add("Role_A");
        result = Util.isRolePresent(applicationRoleNamesList, roleName);
        UtilTest.assertFalse((boolean)result);
    }

    public void testIsRolePresent8() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        ArrayList<String> applicationRoleNamesList = new ArrayList<String>();
        String roleName = "Role_blah";
        boolean result = false;
        applicationRoleNamesList.add("Role_A");
        applicationRoleNamesList.add("Role_blah");
        result = Util.isRolePresent(applicationRoleNamesList, roleName);
        UtilTest.assertTrue((boolean)result);
    }

    public void testGetProjectMetadataSummaryList1() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Map<String, ProjectMetadataSummary> projectMetadataSummaryMap = null;
        List<ProjectMetadataSummary> projectMetadataSummaryList = null;
        projectMetadataSummaryList = Util.getProjectMetadataSummaryList(projectMetadataSummaryMap);
        UtilTest.assertNotNull(projectMetadataSummaryList);
        UtilTest.assertEquals((int)0, (int)projectMetadataSummaryList.size());
    }

    public void testGetProjectMetadataSummaryList2() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Map<String, ProjectMetadataSummary> projectMetadataSummaryMap = null;
        List<ProjectMetadataSummary> projectMetadataSummaryList = null;
        projectMetadataSummaryMap = Collections.synchronizedMap(new LinkedHashMap());
        projectMetadataSummaryList = Util.getProjectMetadataSummaryList(projectMetadataSummaryMap);
        UtilTest.assertNotNull(projectMetadataSummaryList);
        UtilTest.assertEquals((int)0, (int)projectMetadataSummaryList.size());
    }

    public void testGetProjectMetadataSummaryList3() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Map<String, ProjectMetadataSummary> projectMetadataSummaryMap = null;
        List<ProjectMetadataSummary> projectMetadataSummaryList = null;
        projectMetadataSummaryMap = Collections.synchronizedMap(new LinkedHashMap());
        ProjectMetadataSummary projectMetadataSummary = sProcessMetadataFactory.createProjectMetadataSummary();
        projectMetadataSummary.setProjectName("compositeName_A");
        projectMetadataSummary.setCompositeDN("compositeDN_A");
        projectMetadataSummary.setCompositeVersion("1.0");
        projectMetadataSummary.setStatus(StatusEnum.ACTIVE);
        projectMetadataSummaryMap.put(projectMetadataSummary.getCompositeDN(), projectMetadataSummary);
        projectMetadataSummaryList = Util.getProjectMetadataSummaryList(projectMetadataSummaryMap);
        UtilTest.assertNotNull(projectMetadataSummaryList);
        UtilTest.assertEquals((int)1, (int)projectMetadataSummaryList.size());
        ProjectMetadataSummary p1 = projectMetadataSummaryList.get(0);
        UtilTest.assertNotNull((Object)p1);
        UtilTest.assertNotNull((Object)p1.getCompositeDN());
        UtilTest.assertEquals((String)"compositeDN_A", (String)p1.getCompositeDN());
    }

    public void testGetProjectMetadataSummaryList4() {
        System.out.println("\n ===>>> Test name: " + this.getName());
        Map<String, ProjectMetadataSummary> projectMetadataSummaryMap = null;
        List<ProjectMetadataSummary> projectMetadataSummaryList = null;
        projectMetadataSummaryMap = Collections.synchronizedMap(new LinkedHashMap());
        ProjectMetadataSummary projectMetadataSummary1 = sProcessMetadataFactory.createProjectMetadataSummary();
        projectMetadataSummary1.setProjectName("compositeName_A");
        projectMetadataSummary1.setCompositeDN("compositeDN_A");
        projectMetadataSummary1.setCompositeVersion("1.0");
        projectMetadataSummary1.setStatus(StatusEnum.ACTIVE);
        projectMetadataSummaryMap.put(projectMetadataSummary1.getCompositeDN(), projectMetadataSummary1);
        ProjectMetadataSummary projectMetadataSummary2 = sProcessMetadataFactory.createProjectMetadataSummary();
        projectMetadataSummary2.setProjectName("compositeName_B");
        projectMetadataSummary2.setCompositeDN("compositeDN_B");
        projectMetadataSummary2.setCompositeVersion("1.0");
        projectMetadataSummary2.setStatus(StatusEnum.ACTIVE);
        projectMetadataSummaryMap.put(projectMetadataSummary2.getCompositeDN(), projectMetadataSummary2);
        projectMetadataSummaryList = Util.getProjectMetadataSummaryList(projectMetadataSummaryMap);
        UtilTest.assertNotNull(projectMetadataSummaryList);
        UtilTest.assertEquals((int)2, (int)projectMetadataSummaryList.size());
        ProjectMetadataSummary p1 = projectMetadataSummaryList.get(0);
        UtilTest.assertNotNull((Object)p1);
        UtilTest.assertNotNull((Object)p1.getCompositeDN());
        UtilTest.assertEquals((String)"compositeDN_A", (String)p1.getCompositeDN());
        ProjectMetadataSummary p2 = projectMetadataSummaryList.get(1);
        UtilTest.assertNotNull((Object)p2);
        UtilTest.assertNotNull((Object)p2.getCompositeDN());
        UtilTest.assertEquals((String)"compositeDN_B", (String)p2.getCompositeDN());
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

