/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processmetadata.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.metadata.taskmetadata.model.TaskMetadata;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.analytics.common.AnalyticsFeatures;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.processmetadata.ObjectFactory;
import oracle.bpm.services.processmetadata.ProcessMetadataServiceException;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processmetadata.ProcessMetadataSummaryListType;
import oracle.bpm.services.processmetadata.ProjectMetadataSummary;
import oracle.bpm.services.processmetadata.StatusEnum;
import oracle.bpm.services.processmetadata.Tag;
import oracle.bpm.services.processmetadata.TagListType;
import oracle.bpm.services.processmetadata.TaskDisplayInfoType;
import oracle.bpm.services.processmetadata.impl.ProcessMetadataService;
import oracle.bpm.services.processmetadata.impl.QueryArgument;
import oracle.bpm.services.processmetadata.impl.QueryArgumentConstants;

public class Util {
    private static final String CLASS_NAME_LONG = "java.lang.Long";
    private static final String CLASS_NAME_STRING = "java.lang.String";
    private static final String CLASS_NAME_OBJECT = "java.lang.Object";
    public static final String TAG_DELIMITER = ";";
    private static final String CLASS_NAME = "Util";
    private static ObjectFactory sProcessMetadataFactory = new ObjectFactory();

    public static TagListType constructTagListType(String columnTags) {
        String[] tagArray;
        TagListType tagListType = sProcessMetadataFactory.createTagListType();
        if (columnTags != null && !columnTags.equals("") && (tagArray = columnTags.trim().split(TAG_DELIMITER)) != null && tagArray.length > 0) {
            for (int i = 0; i < tagArray.length; ++i) {
                if (tagArray[i] == null) continue;
                Tag tag = sProcessMetadataFactory.createTag();
                tag.setName(tagArray[i]);
                tagListType.getTag().add(tag);
            }
        }
        return tagListType;
    }

    public static int getArgumentIndexInQuery(LinkedList<QueryArgument> linkedList, QueryArgument argument) {
        int index = -1;
        if (linkedList == null) {
            return -1;
        }
        if (linkedList.isEmpty()) {
            return -1;
        }
        if (argument == null) {
            return -1;
        }
        for (int i = 0; i < linkedList.size(); ++i) {
            QueryArgument argumentParameter = linkedList.get(i);
            if (argumentParameter == null || !argumentParameter.equals(argument)) continue;
            index = i;
        }
        return index;
    }

    public static Object getValueFromResultSetObject(QueryArgument argument, Object resultSetValue) {
        Object result = null;
        if (argument == null || argument.getDataType() == null) {
            return null;
        }
        if (resultSetValue == null) {
            return null;
        }
        if (argument.getDataType().equals(CLASS_NAME_LONG)) {
            Long longResult = (Long)resultSetValue;
            result = longResult;
        } else if (argument.getDataType().equals(CLASS_NAME_STRING)) {
            String stringResult = (String)resultSetValue;
            result = stringResult;
        } else {
            Object objectResult;
            result = argument.getDataType().equals(CLASS_NAME_OBJECT) ? (objectResult = resultSetValue) : (objectResult = resultSetValue);
        }
        return result;
    }

    public static void validate(LinkedList<QueryArgument> argumentList, Object[] objectArray) throws Exception {
        if (argumentList == null && objectArray != null) {
            throw new Exception("Invalid combination as argumentList is null and objectArray is not null");
        }
        if (argumentList != null && objectArray == null) {
            throw new Exception("Invalid combination as argumentList is not null and objectArray is null");
        }
        if (argumentList.size() != objectArray.length) {
            throw new Exception("Unequal number in argumentList and objectArray");
        }
    }

    public static Long getProcessId(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        Long result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (Long)resultObject;
        }
        return result;
    }

    public static String getProcessName(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getDomainName(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_DOMAINNAME_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getCompositeName(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getCompositeRevision(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEREVISION_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getSCALabel(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITELABEL_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getCompositeDN(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEDN_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getLabel(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_LABEL_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getProcessType(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSTYPE_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getTargetNamespace(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_TARGETNAMESPACE_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static Long getStatus(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        Long result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_STATUS_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (Long)resultObject;
        }
        return result;
    }

    public static Object getCreationDate(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        Object result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_CREATIONDATE_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = resultObject;
        }
        return result;
    }

    public static Object getUndeployDate(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        Object result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_UNDEPLOYDATE_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = resultObject;
        }
        return result;
    }

    public static String getOrganizationalUnitId(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_ORGANIZATIONALUNITID_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getHasGlobalCreationTasks(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_HASGLOBALCREATIONTASKS_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getSubType(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_SUBTYPE_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getMigrationStatus(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_MIGRATIONSTATUS_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getActivityName(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ACTIVITYNAME_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getActivityLabel(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ACTIVITYLABEL_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getTaskRole(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ROLE_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getTaskDefinitionId(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_SYSTEMSTRING01_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getRole(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_ROLE_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getApplicationLinkDisplayName(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_APPLICATIONLINKDISPLAYNAME_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getCategory(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_CATEGORY_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static String getTags(LinkedList<QueryArgument> argumentList, Object[] objectArray) {
        String result = null;
        QueryArgument argument = QueryArgumentConstants.BPM_CUBE_PROCESS_TAGS_ARGUMENT;
        Object resultObject = Util.getParameterValueFromResultSet(argumentList, objectArray, argument);
        if (resultObject != null && resultObject.getClass() != null && resultObject.getClass().getName() != null && resultObject.getClass().getName().equals(argument.getDataType())) {
            result = (String)resultObject;
        }
        return result;
    }

    public static Object getParameterValueFromResultSet(LinkedList<QueryArgument> argumentList, Object[] objectArray, QueryArgument argument) {
        int position;
        Object resultObject = null;
        if (argumentList != null && !argumentList.isEmpty() && objectArray != null && objectArray.length > 0 && argument != null && (position = Util.getArgumentIndexInQuery(argumentList, argument)) > -1) {
            QueryArgument c = argumentList.get(position);
            Object o = objectArray[position];
            resultObject = Util.getValueFromResultSetObject(c, o);
        }
        return resultObject;
    }

    public static Map<String, QueryArgument> convertArgumentListToMap(LinkedList<QueryArgument> argumentList) throws Exception {
        Hashtable<String, QueryArgument> map = new Hashtable<String, QueryArgument>();
        if (argumentList != null && !argumentList.isEmpty()) {
            for (QueryArgument key : argumentList) {
                if (key == null) continue;
                QueryArgument value = (QueryArgument)map.get(key.getDBColumnName());
                if (value == null) {
                    map.put(key.getDBColumnName(), key);
                    continue;
                }
                throw new Exception("The list contains duplicate entries for: " + key);
            }
        }
        return map;
    }

    public static boolean compareArgumentMaps(Map<String, QueryArgument> map1, Map<String, QueryArgument> map2) {
        String METHOD_NAME = "compareArgumentMaps";
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null && map2 != null) {
            return false;
        }
        if (map1 != null && map2 == null) {
            return false;
        }
        if (map1.isEmpty() && map2.isEmpty()) {
            return true;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        Set<String> keySet = map1.keySet();
        for (String key : keySet) {
            QueryArgument value1 = map1.get(key);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"compareArgumentMaps", (String)("\n key: " + key + "\t value1: " + value1));
            }
            QueryArgument value2 = map2.get(key);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"compareArgumentMaps", (String)("\n key: " + key + "\t value2: " + value2));
            }
            if (value1.equals(value2)) continue;
            return false;
        }
        return true;
    }

    public static String constructProcessQueryString(boolean isBPMAdminUser, String compositeDN, String keyword, String sortAttribute, String sortOrder, List<String> organizationalUnitIdList, LinkedList<QueryArgument> argumentList) {
        String METHOD_NAME = "constructProcessQueryString";
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ");
        buf.append("DISTINCT ");
        buf.append("p.processId");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        buf.append(", p.processName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        buf.append(", p.domainName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_DOMAINNAME_ARGUMENT);
        buf.append(", p.compositeName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT);
        buf.append(", p.compositeRevision");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEREVISION_ARGUMENT);
        buf.append(", p.compositeLabel");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITELABEL_ARGUMENT);
        buf.append(", p.compositeDN");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEDN_ARGUMENT);
        buf.append(", p.label");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_LABEL_ARGUMENT);
        buf.append(", p.targetNamespace");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TARGETNAMESPACE_ARGUMENT);
        buf.append(", p.status");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_STATUS_ARGUMENT);
        buf.append(", p.creationDate");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CREATIONDATE_ARGUMENT);
        buf.append(", p.undeployDate");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_UNDEPLOYDATE_ARGUMENT);
        buf.append(", p.organizationalUnitId");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_ORGANIZATIONALUNITID_ARGUMENT);
        buf.append(", p.hasGlobalCreationTasks");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_HASGLOBALCREATIONTASKS_ARGUMENT);
        buf.append(", p.subType");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_SUBTYPE_ARGUMENT);
        buf.append(", p.migrationStatus");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_MIGRATIONSTATUS_ARGUMENT);
        Boolean applicationPanelEnhancementEnabled = AnalyticsFeatures.getInstance().isApplicationPanelEnhancementEnabled();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"constructProcessQueryString", (String)("\n applicationPanelEnhancementEnabled: " + applicationPanelEnhancementEnabled));
        }
        if (applicationPanelEnhancementEnabled.booleanValue()) {
            buf.append(", p.applicationLinkDisplayName");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_APPLICATIONLINKDISPLAYNAME_ARGUMENT);
            buf.append(", p.category");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CATEGORY_ARGUMENT);
            buf.append(", p.tags ");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TAGS_ARGUMENT);
        } else {
            buf.append(" ");
        }
        buf.append("FROM ");
        buf.append("CubeProcess p ");
        buf.append("WHERE ");
        buf.append("( ");
        buf.append("( ");
        buf.append("p.processType ");
        buf.append("= ");
        buf.append("'BPMN' ");
        buf.append(") ");
        if (compositeDN != null && compositeDN.length() > 0 || keyword != null && keyword.length() > 0) {
            buf.append("AND ");
            buf.append("( ");
            if (compositeDN != null && compositeDN.length() > 0) {
                buf.append("( ");
                buf.append("p.compositeDN ");
                buf.append("= ");
                buf.append("'");
                buf.append(compositeDN);
                buf.append("' ");
                buf.append(") ");
                if (keyword != null && keyword.length() > 0) {
                    buf.append("AND ");
                }
            }
            if (keyword != null && keyword.length() > 0) {
                buf.append("( ");
                buf.append("p.processName ");
                buf.append("LIKE ");
                buf.append("'%");
                buf.append(keyword);
                buf.append("%' ");
                buf.append("OR ");
                buf.append("p.compositeName ");
                buf.append("LIKE ");
                buf.append("'%");
                buf.append(keyword);
                buf.append("%' ");
                buf.append("OR ");
                buf.append("p.label ");
                buf.append("LIKE ");
                buf.append("'%");
                buf.append(keyword);
                buf.append("%' ");
                buf.append("OR ");
                buf.append("p.organizationalUnitId ");
                buf.append("LIKE ");
                buf.append("'%");
                buf.append(keyword);
                buf.append("%' ");
                if (applicationPanelEnhancementEnabled.booleanValue()) {
                    buf.append("OR ");
                    buf.append("p.applicationLinkDisplayName ");
                    buf.append("LIKE ");
                    buf.append("'%");
                    buf.append(keyword);
                    buf.append("%' ");
                    buf.append("OR ");
                    buf.append("p.category ");
                    buf.append("LIKE ");
                    buf.append("'%");
                    buf.append(keyword);
                    buf.append("%' ");
                    buf.append("OR ");
                    buf.append("p.tags ");
                    buf.append("LIKE ");
                    buf.append("'%");
                    buf.append(keyword);
                    buf.append("%' ");
                }
                buf.append(") ");
            }
            buf.append(") ");
        }
        if (!isBPMAdminUser) {
            buf.append("AND ");
            buf.append("( ");
            buf.append("( ");
            buf.append("p.organizationalUnitId ");
            buf.append("IS ");
            buf.append("NULL ");
            buf.append(") ");
            if (organizationalUnitIdList != null && !organizationalUnitIdList.isEmpty()) {
                buf.append("OR ");
                buf.append("( ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IS NOT NULL ");
                buf.append(") ");
                buf.append("AND ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IN ( ");
                for (int i = 0; i < organizationalUnitIdList.size(); ++i) {
                    String organizationalUnitId = organizationalUnitIdList.get(i);
                    if (organizationalUnitId == null) continue;
                    buf.append("'");
                    buf.append(organizationalUnitId);
                    buf.append("'");
                    if (i >= organizationalUnitIdList.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(") ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        buf.append(") ");
        buf.append("ORDER BY ");
        if (sortAttribute != null && sortAttribute.length() > 0) {
            if (sortAttribute.equalsIgnoreCase("processName")) {
                buf.append("p.processName");
            } else if (sortAttribute.equalsIgnoreCase("compositeName")) {
                buf.append("p.compositeName");
            } else if (sortAttribute.equalsIgnoreCase("label")) {
                buf.append("p.label");
            } else if (sortAttribute.equalsIgnoreCase("organizationalUnitId")) {
                buf.append("p.organizationalUnitId");
            } else if (applicationPanelEnhancementEnabled.booleanValue() && sortAttribute.equalsIgnoreCase("applicationLinkDisplayName")) {
                buf.append("p.applicationLinkDisplayName");
            } else if (applicationPanelEnhancementEnabled.booleanValue() && sortAttribute.equalsIgnoreCase("category")) {
                buf.append("p.category");
            } else if (applicationPanelEnhancementEnabled.booleanValue() && sortAttribute.equalsIgnoreCase("tags")) {
                buf.append("p.tags");
            } else {
                buf.append("p.processName");
            }
        } else {
            buf.append("p.processName");
        }
        buf.append(" ");
        if (sortOrder != null && sortOrder.length() > 0 && sortOrder.equalsIgnoreCase("DESC")) {
            buf.append("DESC ");
        }
        Util.logQueryString(buf.toString());
        return buf.toString();
    }

    public static String constructProjectQueryString(boolean isBPMAdminUser, String compositeDN, String projectName, List<String> organizationalUnitIdList, LinkedList<QueryArgument> argumentList) {
        String METHOD_NAME = "constructProjectQueryString";
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ");
        buf.append("DISTINCT ");
        buf.append("p.processId");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        buf.append(", p.processName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        buf.append(", p.domainName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_DOMAINNAME_ARGUMENT);
        buf.append(", p.compositeName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT);
        buf.append(", p.compositeRevision");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEREVISION_ARGUMENT);
        buf.append(", p.compositeLabel");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITELABEL_ARGUMENT);
        buf.append(", p.compositeDN");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEDN_ARGUMENT);
        buf.append(", p.label");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_LABEL_ARGUMENT);
        buf.append(", p.targetNamespace");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TARGETNAMESPACE_ARGUMENT);
        buf.append(", p.status");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_STATUS_ARGUMENT);
        buf.append(", p.creationDate");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CREATIONDATE_ARGUMENT);
        buf.append(", p.undeployDate");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_UNDEPLOYDATE_ARGUMENT);
        buf.append(", p.organizationalUnitId");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_ORGANIZATIONALUNITID_ARGUMENT);
        buf.append(", p.hasGlobalCreationTasks");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_HASGLOBALCREATIONTASKS_ARGUMENT);
        buf.append(", p.subType");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_SUBTYPE_ARGUMENT);
        buf.append(", p.migrationStatus");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_MIGRATIONSTATUS_ARGUMENT);
        Boolean applicationPanelEnhancementEnabled = AnalyticsFeatures.getInstance().isApplicationPanelEnhancementEnabled();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"constructProjectQueryString", (String)("\n applicationPanelEnhancementEnabled: " + applicationPanelEnhancementEnabled));
        }
        if (applicationPanelEnhancementEnabled.booleanValue()) {
            buf.append(", p.applicationLinkDisplayName");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_APPLICATIONLINKDISPLAYNAME_ARGUMENT);
            buf.append(", p.category");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CATEGORY_ARGUMENT);
            buf.append(", p.tags ");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TAGS_ARGUMENT);
        } else {
            buf.append(" ");
        }
        buf.append("FROM ");
        buf.append("CubeProcess p ");
        buf.append("WHERE ");
        buf.append("( ");
        buf.append("( ");
        buf.append("p.processType ");
        buf.append("= ");
        buf.append("'BPMN' ");
        buf.append(") ");
        if (compositeDN != null && compositeDN.length() > 0 || projectName != null && projectName.length() > 0) {
            buf.append("AND ");
            buf.append("( ");
            if (compositeDN != null && compositeDN.length() > 0) {
                buf.append("( ");
                buf.append("p.compositeDN ");
                buf.append("= ");
                buf.append("'");
                buf.append(compositeDN);
                buf.append("' ");
                buf.append(") ");
                if (projectName != null && projectName.length() > 0) {
                    buf.append("AND ");
                }
            }
            if (projectName != null && projectName.length() > 0) {
                buf.append("( ");
                buf.append("p.compositeName ");
                buf.append("= ");
                buf.append("'");
                buf.append(projectName);
                buf.append("' ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        if (!isBPMAdminUser) {
            buf.append("AND ");
            buf.append("( ");
            buf.append("( ");
            buf.append("p.organizationalUnitId ");
            buf.append("IS ");
            buf.append("NULL ");
            buf.append(") ");
            if (organizationalUnitIdList != null && !organizationalUnitIdList.isEmpty()) {
                buf.append("OR ");
                buf.append("( ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IS NOT NULL ");
                buf.append(") ");
                buf.append("AND ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IN ( ");
                for (int i = 0; i < organizationalUnitIdList.size(); ++i) {
                    String organizationalUnitId = organizationalUnitIdList.get(i);
                    if (organizationalUnitId == null) continue;
                    buf.append("'");
                    buf.append(organizationalUnitId);
                    buf.append("'");
                    if (i >= organizationalUnitIdList.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(") ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        buf.append(") ");
        Util.logQueryString(buf.toString());
        return buf.toString();
    }

    public static String constructProcessQueryString(boolean isBPMAdminUser, String compositeDN, String processName, List<String> organizationalUnitIdList, LinkedList<QueryArgument> argumentList) {
        String METHOD_NAME = "constructProcessQueryString";
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ");
        buf.append("DISTINCT ");
        buf.append("p.processId");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        buf.append(", p.processName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        buf.append(", p.domainName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_DOMAINNAME_ARGUMENT);
        buf.append(", p.compositeName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT);
        buf.append(", p.compositeRevision");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEREVISION_ARGUMENT);
        buf.append(", p.compositeLabel");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITELABEL_ARGUMENT);
        buf.append(", p.compositeDN");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEDN_ARGUMENT);
        buf.append(", p.label");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_LABEL_ARGUMENT);
        buf.append(", p.targetNamespace");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TARGETNAMESPACE_ARGUMENT);
        buf.append(", p.status");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_STATUS_ARGUMENT);
        buf.append(", p.creationDate");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CREATIONDATE_ARGUMENT);
        buf.append(", p.undeployDate");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_UNDEPLOYDATE_ARGUMENT);
        buf.append(", p.organizationalUnitId");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_ORGANIZATIONALUNITID_ARGUMENT);
        buf.append(", p.hasGlobalCreationTasks");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_HASGLOBALCREATIONTASKS_ARGUMENT);
        buf.append(", p.subType");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_SUBTYPE_ARGUMENT);
        buf.append(", p.migrationStatus");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_MIGRATIONSTATUS_ARGUMENT);
        Boolean applicationPanelEnhancementEnabled = AnalyticsFeatures.getInstance().isApplicationPanelEnhancementEnabled();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"constructProcessQueryString", (String)("\n applicationPanelEnhancementEnabled: " + applicationPanelEnhancementEnabled));
        }
        if (applicationPanelEnhancementEnabled.booleanValue()) {
            buf.append(", p.applicationLinkDisplayName");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_APPLICATIONLINKDISPLAYNAME_ARGUMENT);
            buf.append(", p.category");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CATEGORY_ARGUMENT);
            buf.append(", p.tags ");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TAGS_ARGUMENT);
        } else {
            buf.append(" ");
        }
        buf.append("FROM ");
        buf.append("CubeProcess p ");
        buf.append("WHERE ");
        buf.append("( ");
        buf.append("( ");
        buf.append("p.processType ");
        buf.append("= ");
        buf.append("'BPMN' ");
        buf.append(") ");
        if (compositeDN != null && compositeDN.length() > 0 || processName != null && processName.length() > 0) {
            buf.append("AND ");
            buf.append("( ");
            if (compositeDN != null && compositeDN.length() > 0) {
                buf.append("( ");
                buf.append("p.compositeDN ");
                buf.append("= ");
                buf.append("'");
                buf.append(compositeDN);
                buf.append("' ");
                buf.append(") ");
                if (processName != null && processName.length() > 0) {
                    buf.append("AND ");
                }
            }
            if (processName != null && processName.length() > 0) {
                buf.append("( ");
                buf.append("p.processName ");
                buf.append("= ");
                buf.append("'");
                buf.append(processName);
                buf.append("' ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        if (!isBPMAdminUser) {
            buf.append("AND ");
            buf.append("( ");
            buf.append("( ");
            buf.append("p.organizationalUnitId ");
            buf.append("IS ");
            buf.append("NULL ");
            buf.append(") ");
            if (organizationalUnitIdList != null && !organizationalUnitIdList.isEmpty()) {
                buf.append("OR ");
                buf.append("( ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IS NOT NULL ");
                buf.append(") ");
                buf.append("AND ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IN ( ");
                for (int i = 0; i < organizationalUnitIdList.size(); ++i) {
                    String organizationalUnitId = organizationalUnitIdList.get(i);
                    if (organizationalUnitId == null) continue;
                    buf.append("'");
                    buf.append(organizationalUnitId);
                    buf.append("'");
                    if (i >= organizationalUnitIdList.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(") ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        buf.append(") ");
        Util.logQueryString(buf.toString());
        return buf.toString();
    }

    public static String constructProcessQueryString(boolean isBPMAdminUser, List<String> applicationRoles, List<String> organizationalUnitIdList, LinkedList<QueryArgument> argumentList) {
        String METHOD_NAME = "constructProcessQueryString";
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ");
        buf.append("DISTINCT ");
        buf.append("p.processId");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSID_ARGUMENT);
        buf.append(", p.processName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_PROCESSNAME_ARGUMENT);
        buf.append(", p.domainName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_DOMAINNAME_ARGUMENT);
        buf.append(", p.compositeName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITENAME_ARGUMENT);
        buf.append(", p.compositeRevision");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEREVISION_ARGUMENT);
        buf.append(", p.compositeLabel");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITELABEL_ARGUMENT);
        buf.append(", p.compositeDN");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_COMPOSITEDN_ARGUMENT);
        buf.append(", p.label");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_LABEL_ARGUMENT);
        buf.append(", p.targetNamespace");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TARGETNAMESPACE_ARGUMENT);
        buf.append(", p.creationDate");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CREATIONDATE_ARGUMENT);
        buf.append(", p.undeployDate");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_UNDEPLOYDATE_ARGUMENT);
        buf.append(", p.organizationalUnitId");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_ORGANIZATIONALUNITID_ARGUMENT);
        buf.append(", p.subType");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_SUBTYPE_ARGUMENT);
        buf.append(", t.activityName");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ACTIVITYNAME_ARGUMENT);
        buf.append(", t.activityLabel");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ACTIVITYLABEL_ARGUMENT);
        buf.append(", t.role");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_ROLE_ARGUMENT);
        buf.append(", t.systemString01");
        argumentList.add(QueryArgumentConstants.BPM_CUBE_GLOBALCREATETASK_SYSTEMSTRING01_ARGUMENT);
        Boolean applicationPanelEnhancementEnabled = AnalyticsFeatures.getInstance().isApplicationPanelEnhancementEnabled();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"constructProcessQueryString", (String)("\n applicationPanelEnhancementEnabled: " + applicationPanelEnhancementEnabled));
        }
        if (applicationPanelEnhancementEnabled.booleanValue()) {
            buf.append(", p.applicationLinkDisplayName");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_APPLICATIONLINKDISPLAYNAME_ARGUMENT);
            buf.append(", p.category");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_CATEGORY_ARGUMENT);
            buf.append(", p.tags ");
            argumentList.add(QueryArgumentConstants.BPM_CUBE_PROCESS_TAGS_ARGUMENT);
        } else {
            buf.append(" ");
        }
        buf.append("FROM ");
        buf.append("CubeProcess p, ");
        buf.append("CubeGlobalCreateTask t, ");
        buf.append("CubeRole r ");
        buf.append("WHERE ");
        buf.append("p.processType ");
        buf.append("= ");
        buf.append("'BPMN' ");
        buf.append("AND ");
        buf.append("p.hasGlobalCreationTasks ");
        buf.append("= ");
        buf.append("'Y' ");
        buf.append("AND ");
        buf.append("p.status ");
        buf.append("= ");
        buf.append("1 ");
        buf.append("AND ");
        buf.append("p.migrationStatus ");
        buf.append("= ");
        buf.append("'LATEST' ");
        buf.append("AND ");
        buf.append("p ");
        buf.append("= ");
        buf.append("t.cubeProcess ");
        buf.append("AND ");
        buf.append("p ");
        buf.append("= ");
        buf.append("r.cubeProcess ");
        if (!isBPMAdminUser) {
            int i;
            if (applicationRoles != null && !applicationRoles.isEmpty()) {
                String applicationRole;
                buf.append("AND ");
                buf.append(" ( ");
                buf.append(" ( ");
                buf.append("t.role ");
                buf.append("IN ( ");
                for (i = 0; i < applicationRoles.size(); ++i) {
                    applicationRole = applicationRoles.get(i);
                    if (applicationRole == null) continue;
                    buf.append("'");
                    buf.append(applicationRole);
                    buf.append("'");
                    if (i >= applicationRoles.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(" ) ");
                buf.append("OR ");
                buf.append(" ( ");
                buf.append("r.applicationRoleName ");
                buf.append("IN ( ");
                for (i = 0; i < applicationRoles.size(); ++i) {
                    applicationRole = applicationRoles.get(i);
                    if (applicationRole == null) continue;
                    buf.append("'");
                    buf.append(applicationRole);
                    buf.append("'");
                    if (i >= applicationRoles.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(" ) ");
                buf.append(" ) ");
            }
            buf.append("AND ");
            buf.append("( ");
            buf.append("( ");
            buf.append("p.organizationalUnitId ");
            buf.append("IS ");
            buf.append("NULL ");
            buf.append(") ");
            if (organizationalUnitIdList != null && !organizationalUnitIdList.isEmpty()) {
                buf.append("OR ");
                buf.append("( ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IS NOT NULL ");
                buf.append(") ");
                buf.append("AND ");
                buf.append("( ");
                buf.append("p.organizationalUnitId ");
                buf.append("IN ( ");
                for (i = 0; i < organizationalUnitIdList.size(); ++i) {
                    String organizationalUnitId = organizationalUnitIdList.get(i);
                    if (organizationalUnitId == null) continue;
                    buf.append("'");
                    buf.append(organizationalUnitId);
                    buf.append("'");
                    if (i >= organizationalUnitIdList.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(" ) ");
                buf.append(") ");
                buf.append(") ");
            }
            buf.append(") ");
        }
        Util.logQueryString(buf.toString());
        return buf.toString();
    }

    public static List<ProjectMetadataSummary> convertToProjectMetadataSummaryList(LinkedList<QueryArgument> argumentList, List list) {
        return Util.convertToProjectMetadataSummaryList(argumentList, list, ProcessMetadataService.ProcessFilter.DEPLOYED_ONLY);
    }

    public static List<ProcessMetadataSummary> convertToProcessMetadataSummaryList(LinkedList<QueryArgument> argumentList, List list) {
        return Util.convertToProcessMetadataSummaryList(argumentList, list, ProcessMetadataService.ProcessFilter.DEPLOYED_ONLY);
    }

    public static List<ProjectMetadataSummary> convertToProjectMetadataSummaryList(LinkedList<QueryArgument> argumentList, List list, ProcessMetadataService.ProcessFilter filter) {
        String METHOD_NAME = "convertToProjectMetadataSummaryList";
        Map<String, ProjectMetadataSummary> projectMetadataSummaryMap = Collections.synchronizedMap(new LinkedHashMap());
        if (list != null && !list.isEmpty()) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"convertToProjectMetadataSummaryList", (String)("\n list.size(): " + list.size()));
            }
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = (Object[])list.get(i);
                if (objectArray == null || objectArray.length <= 0) continue;
                Long processId = Util.getProcessId(argumentList, objectArray);
                String processName = Util.getProcessName(argumentList, objectArray);
                String domainName = Util.getDomainName(argumentList, objectArray);
                String compositeName = Util.getCompositeName(argumentList, objectArray);
                String compositeRevision = Util.getCompositeRevision(argumentList, objectArray);
                String scaLabel = Util.getSCALabel(argumentList, objectArray);
                String compositeDN = Util.getCompositeDN(argumentList, objectArray);
                String label = Util.getLabel(argumentList, objectArray);
                String targetNamespace = Util.getTargetNamespace(argumentList, objectArray);
                Long status = Util.getStatus(argumentList, objectArray);
                Object creationDate = Util.getCreationDate(argumentList, objectArray);
                Object undeployDate = Util.getUndeployDate(argumentList, objectArray);
                String organizationalUnitId = Util.getOrganizationalUnitId(argumentList, objectArray);
                String hasGlobalCreationTasks = Util.getHasGlobalCreationTasks(argumentList, objectArray);
                String subType = Util.getSubType(argumentList, objectArray);
                String migrationStatus = Util.getMigrationStatus(argumentList, objectArray);
                String applicationLinkDisplayName = Util.getApplicationLinkDisplayName(argumentList, objectArray);
                String category = Util.getCategory(argumentList, objectArray);
                String tags = Util.getTags(argumentList, objectArray);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"convertToProjectMetadataSummaryList", (String)("\n processId: " + processId + "\n processName: " + processName + "\n domainName: " + domainName + "\n compositeName: " + compositeName + "\n compositeRevision: " + compositeRevision + "\n scaLabel: " + scaLabel + "\n compositeDN: " + compositeDN + "\n label: " + label + "\n targetNamespace: " + targetNamespace + "\n status: " + status + "\n creationDate: " + creationDate + "\n undeployDate: " + undeployDate + "\n organizationalUnitId: " + organizationalUnitId + "\n hasGlobalCreationTasks: " + hasGlobalCreationTasks + "\n subType: " + subType + "\n migrationStatus: " + migrationStatus + "\n applicationLinkDisplayName: " + applicationLinkDisplayName + "\n category: " + category + "\n tags: " + tags));
                }
                if ((!ProcessMetadataService.ProcessFilter.DEPLOYED_AND_MIGRATED.equals((Object)filter) || !"MIGRATED".equals(migrationStatus) && !Util.isProcessDeployed(compositeDN)) && (!ProcessMetadataService.ProcessFilter.DEPLOYED_ONLY.equals((Object)filter) || !Util.isProcessDeployed(compositeDN)) && !ProcessMetadataService.ProcessFilter.ALL.equals((Object)filter)) continue;
                ProcessMetadataSummary processMetadataSummary = sProcessMetadataFactory.createProcessMetadataSummary();
                if (processId != null) {
                    processMetadataSummary.setProcessId(String.valueOf(processId));
                }
                processMetadataSummary.setProjectName(compositeName);
                processMetadataSummary.setProcessName(processName);
                processMetadataSummary.setDomainName(domainName);
                processMetadataSummary.setCompositeName(compositeName);
                processMetadataSummary.setRevision(compositeRevision);
                processMetadataSummary.setLabel(scaLabel);
                processMetadataSummary.setCompositeDN(compositeDN);
                processMetadataSummary.setTargetNamespace(targetNamespace);
                processMetadataSummary.setProcessLabel(label);
                if (status != null) {
                    if (migrationStatus != null && "MIGRATED".equals(migrationStatus) && status != -1L) {
                        processMetadataSummary.setStatus(StatusEnum.MIGRATED);
                    } else if (status == 1L) {
                        processMetadataSummary.setStatus(StatusEnum.ACTIVE);
                    } else if (status == 0L) {
                        processMetadataSummary.setStatus(StatusEnum.RETIRED);
                    } else if (status == -1L) {
                        processMetadataSummary.setStatus(StatusEnum.DELETED);
                    } else if (status == 2L) {
                        processMetadataSummary.setStatus(StatusEnum.SUSPENDED);
                    }
                }
                processMetadataSummary.setOrganizationalUnitId(organizationalUnitId);
                if (hasGlobalCreationTasks != null && hasGlobalCreationTasks.equalsIgnoreCase("Y")) {
                    processMetadataSummary.setHasGlobalCreationTasks(Boolean.TRUE);
                } else {
                    processMetadataSummary.setHasGlobalCreationTasks(Boolean.FALSE);
                }
                processMetadataSummary.setSubType(subType);
                boolean isDefaultRevision = BPMNServiceEngine.getInstance().isDefaultRevision(compositeDN);
                if (isDefaultRevision) {
                    processMetadataSummary.setIsDefaultRevision(Boolean.TRUE);
                } else {
                    processMetadataSummary.setIsDefaultRevision(Boolean.FALSE);
                }
                processMetadataSummary.setApplicationLinkDisplayName(applicationLinkDisplayName);
                processMetadataSummary.setCategory(category);
                TagListType tagListType = Util.constructTagListType(tags);
                processMetadataSummary.setTagList(tagListType);
                ProjectMetadataSummary projectMetadata = projectMetadataSummaryMap.get(processMetadataSummary.getCompositeDN());
                if (projectMetadata == null) {
                    ProjectMetadataSummary projectMetadataSummary = sProcessMetadataFactory.createProjectMetadataSummary();
                    projectMetadataSummary.setProjectName(processMetadataSummary.getCompositeName());
                    projectMetadataSummary.setCompositeDN(processMetadataSummary.getCompositeDN());
                    projectMetadataSummary.setCompositeVersion(processMetadataSummary.getRevision());
                    projectMetadataSummary.setStatus(processMetadataSummary.getStatus());
                    ProcessMetadataSummaryListType processMetadataSummaryListType = projectMetadataSummary.getProcessMetadataSummaryList();
                    if (processMetadataSummaryListType == null) {
                        processMetadataSummaryListType = sProcessMetadataFactory.createProcessMetadataSummaryListType();
                        List processList = processMetadataSummaryListType.getProcessMetadataSummary();
                        if (processList != null) {
                            processList.add(processMetadataSummary);
                        }
                        projectMetadataSummary.setProcessMetadataSummaryList(processMetadataSummaryListType);
                    } else if (processMetadataSummaryListType.getProcessMetadataSummary() != null) {
                        processMetadataSummaryListType.getProcessMetadataSummary().add(processMetadataSummary);
                    }
                    projectMetadataSummaryMap.put(projectMetadataSummary.getCompositeDN(), projectMetadataSummary);
                    continue;
                }
                ProcessMetadataSummaryListType processMetadataSummaryListType = projectMetadata.getProcessMetadataSummaryList();
                if (processMetadataSummaryListType == null) {
                    processMetadataSummaryListType = sProcessMetadataFactory.createProcessMetadataSummaryListType();
                    List processList = processMetadataSummaryListType.getProcessMetadataSummary();
                    if (processList != null) {
                        processList.add(processMetadataSummary);
                    }
                    projectMetadata.setProcessMetadataSummaryList(processMetadataSummaryListType);
                    continue;
                }
                if (processMetadataSummaryListType.getProcessMetadataSummary() == null) continue;
                processMetadataSummaryListType.getProcessMetadataSummary().add(processMetadataSummary);
            }
        } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"convertToProjectMetadataSummaryList", (String)"\n list is null or empty");
        }
        return Util.getProjectMetadataSummaryList(projectMetadataSummaryMap);
    }

    public static List<ProcessMetadataSummary> convertToProcessMetadataSummaryList(LinkedList<QueryArgument> argumentList, List list, ProcessMetadataService.ProcessFilter filter) {
        String METHOD_NAME = "convertToProjectMetadataSummaryList";
        ArrayList<ProcessMetadataSummary> processMetadataSummaryList = new ArrayList<ProcessMetadataSummary>();
        if (list != null && !list.isEmpty()) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"convertToProjectMetadataSummaryList", (String)("\n list.size(): " + list.size()));
            }
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = (Object[])list.get(i);
                if (objectArray == null || objectArray.length <= 0) continue;
                Long processId = Util.getProcessId(argumentList, objectArray);
                String processName = Util.getProcessName(argumentList, objectArray);
                String domainName = Util.getDomainName(argumentList, objectArray);
                String compositeName = Util.getCompositeName(argumentList, objectArray);
                String compositeRevision = Util.getCompositeRevision(argumentList, objectArray);
                String scaLabel = Util.getSCALabel(argumentList, objectArray);
                String compositeDN = Util.getCompositeDN(argumentList, objectArray);
                String label = Util.getLabel(argumentList, objectArray);
                String targetNamespace = Util.getTargetNamespace(argumentList, objectArray);
                Long status = Util.getStatus(argumentList, objectArray);
                Object creationDate = Util.getCreationDate(argumentList, objectArray);
                Object undeployDate = Util.getUndeployDate(argumentList, objectArray);
                String organizationalUnitId = Util.getOrganizationalUnitId(argumentList, objectArray);
                String hasGlobalCreationTasks = Util.getHasGlobalCreationTasks(argumentList, objectArray);
                String subType = Util.getSubType(argumentList, objectArray);
                String migrationStatus = Util.getMigrationStatus(argumentList, objectArray);
                String applicationLinkDisplayName = Util.getApplicationLinkDisplayName(argumentList, objectArray);
                String category = Util.getCategory(argumentList, objectArray);
                String tags = Util.getTags(argumentList, objectArray);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"convertToProjectMetadataSummaryList", (String)("\n processId: " + processId + "\n processName: " + processName + "\n domainName: " + domainName + "\n compositeName: " + compositeName + "\n compositeRevision: " + compositeRevision + "\n scaLabel: " + scaLabel + "\n compositeDN: " + compositeDN + "\n label: " + label + "\n targetNamespace: " + targetNamespace + "\n status: " + status + "\n creationDate: " + creationDate + "\n undeployDate: " + undeployDate + "\n organizationalUnitId: " + organizationalUnitId + "\n hasGlobalCreationTasks: " + hasGlobalCreationTasks + "\n subType: " + subType + "\n migrationStatus: " + migrationStatus + "\n applicationLinkDisplayName: " + applicationLinkDisplayName + "\n category: " + category + "\n tags: " + tags));
                }
                if ((!ProcessMetadataService.ProcessFilter.DEPLOYED_AND_MIGRATED.equals((Object)filter) || !"MIGRATED".equals(migrationStatus) && !Util.isProcessDeployed(compositeDN)) && (!ProcessMetadataService.ProcessFilter.DEPLOYED_ONLY.equals((Object)filter) || !Util.isProcessDeployed(compositeDN)) && !ProcessMetadataService.ProcessFilter.ALL.equals((Object)filter)) continue;
                ProcessMetadataSummary processMetadataSummary = sProcessMetadataFactory.createProcessMetadataSummary();
                if (processId != null) {
                    processMetadataSummary.setProcessId(String.valueOf(processId));
                }
                processMetadataSummary.setProjectName(compositeName);
                processMetadataSummary.setProcessName(processName);
                processMetadataSummary.setDomainName(domainName);
                processMetadataSummary.setCompositeName(compositeName);
                processMetadataSummary.setRevision(compositeRevision);
                processMetadataSummary.setLabel(scaLabel);
                processMetadataSummary.setCompositeDN(compositeDN);
                processMetadataSummary.setTargetNamespace(targetNamespace);
                processMetadataSummary.setProcessLabel(label);
                if (status != null) {
                    if (migrationStatus != null && "MIGRATED".equals(migrationStatus) && status != -1L) {
                        processMetadataSummary.setStatus(StatusEnum.MIGRATED);
                    } else if (status == 1L) {
                        processMetadataSummary.setStatus(StatusEnum.ACTIVE);
                    } else if (status == 0L) {
                        processMetadataSummary.setStatus(StatusEnum.RETIRED);
                    } else if (status == -1L) {
                        processMetadataSummary.setStatus(StatusEnum.DELETED);
                    } else if (status == 2L) {
                        processMetadataSummary.setStatus(StatusEnum.SUSPENDED);
                    }
                }
                processMetadataSummary.setOrganizationalUnitId(organizationalUnitId);
                if (hasGlobalCreationTasks != null && hasGlobalCreationTasks.equalsIgnoreCase("Y")) {
                    processMetadataSummary.setHasGlobalCreationTasks(Boolean.TRUE);
                } else {
                    processMetadataSummary.setHasGlobalCreationTasks(Boolean.FALSE);
                }
                processMetadataSummary.setSubType(subType);
                boolean isDefaultRevision = BPMNServiceEngine.getInstance().isDefaultRevision(compositeDN);
                if (isDefaultRevision) {
                    processMetadataSummary.setIsDefaultRevision(Boolean.TRUE);
                } else {
                    processMetadataSummary.setIsDefaultRevision(Boolean.FALSE);
                }
                processMetadataSummary.setApplicationLinkDisplayName(applicationLinkDisplayName);
                processMetadataSummary.setCategory(category);
                TagListType tagListType = Util.constructTagListType(tags);
                processMetadataSummary.setTagList(tagListType);
                processMetadataSummaryList.add(processMetadataSummary);
            }
        } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"convertToProjectMetadataSummaryList", (String)"\n list is null or empty");
        }
        return processMetadataSummaryList;
    }

    public static List<ProcessMetadataSummary> convertToInitiatableProcessMetadataSummaryList(LinkedList<QueryArgument> argumentList, List list, List<String> applicationRoles, IRuntimeConfigService remoteRuntimeConfigServiceBean, IBPMContext context) throws ProcessMetadataServiceException {
        String METHOD_NAME = "convertToInitiatableProcessMetadataSummaryList";
        ArrayList<ProcessMetadataSummary> processMetadataSummaryList = new ArrayList<ProcessMetadataSummary>();
        if (list != null && !list.isEmpty()) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"convertToInitiatableProcessMetadataSummaryList", (String)("\n list.size(): " + list.size()));
            }
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = (Object[])list.get(i);
                if (objectArray == null || objectArray.length <= 0) continue;
                Long processId = Util.getProcessId(argumentList, objectArray);
                String processName = Util.getProcessName(argumentList, objectArray);
                String domainName = Util.getDomainName(argumentList, objectArray);
                String compositeName = Util.getCompositeName(argumentList, objectArray);
                String compositeRevision = Util.getCompositeRevision(argumentList, objectArray);
                String scaLabel = Util.getSCALabel(argumentList, objectArray);
                String compositeDN = Util.getCompositeDN(argumentList, objectArray);
                String label = Util.getLabel(argumentList, objectArray);
                String targetNamespace = Util.getTargetNamespace(argumentList, objectArray);
                Object creationDate = Util.getCreationDate(argumentList, objectArray);
                Object undeployDate = Util.getUndeployDate(argumentList, objectArray);
                String organizationalUnitId = Util.getOrganizationalUnitId(argumentList, objectArray);
                String subType = Util.getSubType(argumentList, objectArray);
                String activityName = Util.getActivityName(argumentList, objectArray);
                String activityLabel = Util.getActivityLabel(argumentList, objectArray);
                String taskRole = Util.getTaskRole(argumentList, objectArray);
                String systemString01 = Util.getTaskDefinitionId(argumentList, objectArray);
                String applicationLinkDisplayName = Util.getApplicationLinkDisplayName(argumentList, objectArray);
                String category = Util.getCategory(argumentList, objectArray);
                String tags = Util.getTags(argumentList, objectArray);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"convertToInitiatableProcessMetadataSummaryList", (String)("\n processId: " + processId + "\n processName: " + processName + "\n domainName: " + domainName + "\n compositeName: " + compositeName + "\n compositeRevision: " + compositeRevision + "\n scaLabel: " + scaLabel + "\n compositeDN: " + compositeDN + "\n label: " + label + "\n targetNamespace: " + targetNamespace + "\n creationDate: " + creationDate + "\n undeployDate: " + undeployDate + "\n organizationalUnitId: " + organizationalUnitId + "\n subType: " + subType + "\n activityName: " + activityName + "\n activityLabel: " + activityLabel + "\n taskRole: " + taskRole + "\n systemString01: " + systemString01 + "\n applicationLinkDisplayName: " + applicationLinkDisplayName + "\n category: " + category + "\n tags: " + tags));
                }
                if (!Util.isProcessDeployed(compositeDN)) continue;
                ProcessMetadataSummary processMetadataSummary = sProcessMetadataFactory.createProcessMetadataSummary();
                if (processId != null) {
                    processMetadataSummary.setProcessId(String.valueOf(processId));
                }
                processMetadataSummary.setProjectName(compositeName);
                processMetadataSummary.setProcessName(processName);
                processMetadataSummary.setDomainName(domainName);
                processMetadataSummary.setCompositeName(compositeName);
                processMetadataSummary.setRevision(compositeRevision);
                processMetadataSummary.setLabel(scaLabel);
                processMetadataSummary.setCompositeDN(compositeDN);
                processMetadataSummary.setTargetNamespace(targetNamespace);
                processMetadataSummary.setStatus(StatusEnum.ACTIVE);
                processMetadataSummary.setOrganizationalUnitId(organizationalUnitId);
                processMetadataSummary.setHasGlobalCreationTasks(Boolean.valueOf(true));
                processMetadataSummary.setSubType(subType);
                processMetadataSummary.setProcessLabel(label);
                boolean isDefaultRevision = BPMNServiceEngine.getInstance().isDefaultRevision(compositeDN);
                if (isDefaultRevision) {
                    processMetadataSummary.setIsDefaultRevision(Boolean.TRUE);
                } else {
                    processMetadataSummary.setIsDefaultRevision(Boolean.FALSE);
                }
                processMetadataSummary.setGlobalCreationTaskActivityName(activityName);
                processMetadataSummary.setGlobalCreationTaskActivityLabel(activityLabel);
                if (Util.isRolePresent(applicationRoles, taskRole)) {
                    try {
                        List taskDisplayInfoTypeList = remoteRuntimeConfigServiceBean.getTaskDisplayInfoByTaskDefinitionId((IWorkflowContext)context, systemString01, null);
                        TaskDisplayInfoType humanTaskDisplayInfo = Util.getTaskDisplayInfo(taskDisplayInfoTypeList);
                        if (humanTaskDisplayInfo != null) {
                            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"convertToInitiatableProcessMetadataSummaryList", (String)"\n Update Human Task display information");
                            }
                            processMetadataSummary.setTaskDisplayInfo(humanTaskDisplayInfo);
                            processMetadataSummary.setHasSwimlaneRole(Boolean.valueOf(true));
                        }
                        processMetadataSummary.setHasSwimlaneRole(Boolean.valueOf(false));
                    }
                    catch (Exception e) {
                        throw new ProcessMetadataServiceException(Severity.ERRORS, 70808, (Object[])new String[0], (Throwable)e);
                    }
                } else {
                    processMetadataSummary.setHasSwimlaneRole(null);
                }
                processMetadataSummary.setApplicationLinkDisplayName(applicationLinkDisplayName);
                processMetadataSummary.setCategory(category);
                TagListType tagListType = Util.constructTagListType(tags);
                processMetadataSummary.setTagList(tagListType);
                if (systemString01 != null) {
                    String taskApplicationLinkDisplayName = Util.getTaskApplicationLinkDisplayName(systemString01);
                    if (applicationLinkDisplayName != null) {
                        processMetadataSummary.setTaskApplicationLinkDisplayName(taskApplicationLinkDisplayName);
                    }
                }
                processMetadataSummaryList.add(processMetadataSummary);
            }
        } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"convertToInitiatableProcessMetadataSummaryList", (String)"\n list is null or empty");
        }
        return processMetadataSummaryList;
    }

    public static TaskDisplayInfoType getTaskDisplayInfo(List taskDisplayInfoTypeList) {
        oracle.bpel.services.workflow.runtimeconfig.model.TaskDisplayInfoType taskDisplayInfoType;
        Object obj;
        String METHOD_NAME = "getTaskDisplayInfo";
        TaskDisplayInfoType humanTaskDisplayInfoType = null;
        if (taskDisplayInfoTypeList == null || taskDisplayInfoTypeList.isEmpty()) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getTaskDisplayInfo", (String)"\n taskDisplayInfoTypeList is null or empty");
            }
            return null;
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getTaskDisplayInfo", (String)("\n taskDisplayInfoTypeList.size(): " + taskDisplayInfoTypeList.size()));
        }
        if ((obj = taskDisplayInfoTypeList.get(0)) instanceof oracle.bpel.services.workflow.runtimeconfig.model.TaskDisplayInfoType && (taskDisplayInfoType = (oracle.bpel.services.workflow.runtimeconfig.model.TaskDisplayInfoType)obj) != null) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getTaskDisplayInfo", (String)("\n taskDisplayInfoType.getApplicationName(): " + taskDisplayInfoType.getApplicationName() + "\n taskDisplayInfoType.getUri(): " + taskDisplayInfoType.getUri() + "\n taskDisplayInfoType.getHostname(): " + taskDisplayInfoType.getHostname() + "\n taskDisplayInfoType.getHttpPort(): " + taskDisplayInfoType.getHttpPort() + "\n taskDisplayInfoType.getHttpsPort(): " + taskDisplayInfoType.getHttpsPort()));
            }
            humanTaskDisplayInfoType = sProcessMetadataFactory.createTaskDisplayInfoType();
            humanTaskDisplayInfoType.setApplicationName(taskDisplayInfoType.getApplicationName());
            humanTaskDisplayInfoType.setUri(taskDisplayInfoType.getUri());
            humanTaskDisplayInfoType.setHostname(taskDisplayInfoType.getHostname());
            humanTaskDisplayInfoType.setHttpPort(taskDisplayInfoType.getHttpPort());
            humanTaskDisplayInfoType.setHttpsPort(taskDisplayInfoType.getHttpsPort());
        }
        return humanTaskDisplayInfoType;
    }

    public static boolean isRolePresent(List<String> applicationRoleNamesList, String roleName) {
        String METHOD_NAME = "isRolePresent";
        boolean flag = false;
        if (applicationRoleNamesList != null && !applicationRoleNamesList.isEmpty() && roleName != null && applicationRoleNamesList.contains(roleName)) {
            flag = true;
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"isRolePresent", (String)("\n flag: " + flag));
        }
        return flag;
    }

    public static List<ProjectMetadataSummary> getProjectMetadataSummaryList(Map<String, ProjectMetadataSummary> projectMetadataSummaryMap) {
        Set<String> keySet;
        ArrayList<ProjectMetadataSummary> projectMetadataSummaryList = new ArrayList<ProjectMetadataSummary>();
        if (projectMetadataSummaryMap != null && !projectMetadataSummaryMap.isEmpty() && (keySet = projectMetadataSummaryMap.keySet()) != null) {
            for (String compositeDN : keySet) {
                projectMetadataSummaryList.add(projectMetadataSummaryMap.get(compositeDN));
            }
        }
        return projectMetadataSummaryList;
    }

    private static String getTaskApplicationLinkDisplayName(String taskDefinitionId) {
        String METHOD_NAME = "getTaskApplicationLinkDisplayName";
        String taskApplicationLinkDisplayName = null;
        if (taskDefinitionId != null) {
            try {
                TaskMetadata taskMetadata = WorkflowUtil.getTaskMetadataById((String)taskDefinitionId);
                taskApplicationLinkDisplayName = taskMetadata.getDisplayName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getTaskApplicationLinkDisplayName", (String)("\n taskApplicationLinkDisplayName: " + taskApplicationLinkDisplayName));
        }
        return taskApplicationLinkDisplayName;
    }

    private static boolean isProcessDeployed(String compositeDN) {
        return BPMNServiceEngine.getInstance().isDeployed(compositeDN);
    }

    private static void logQueryString(String queryString) {
        String METHOD_NAME = "logQueryString";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"logQueryString", (String)("\n queryString: " + queryString));
        }
    }
}

