/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processmetadata.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.metadata.ITaskMetadataService;
import oracle.bpel.services.workflow.metadata.config.model.PayloadType;
import oracle.bpel.services.workflow.metadata.config.model.WorkflowConfigurationType;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.analytics.cube.persistence.PersistenceQueryService;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.processmodel.IProcessModelService;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ObjectFactory;
import oracle.bpm.services.processmetadata.ProcessMetadataServiceException;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processmetadata.ProjectMetadataSummary;
import oracle.bpm.services.processmetadata.TaskDisplayInfoType;
import oracle.bpm.services.processmetadata.impl.QueryArgument;
import oracle.bpm.services.processmetadata.impl.Util;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMAuthorizationService;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMUser;

public class ProcessMetadataService
implements IProcessMetadataService {
    private IBPMUserAuthenticationService bpmUserAuthenticationService = null;
    private Context context = null;
    private PersistenceQueryService pqs = null;
    private IProcessModelService processModelService = null;
    private IRuntimeConfigService remoteRuntimeConfigServiceBean = null;
    private ITaskMetadataService remoteTaskMetadataServiceBean = null;
    private IVerificationService verificationService = null;
    private static final String CLASSNAME = "ProcessMetadataService";
    private static ObjectFactory sProcessMetadataFactory = new ObjectFactory();
    private static final String ROLE_BPM_PROCESS_ADMIN = "BPMProcessAdmin";

    public IVerificationService getVerificationService() {
        return this.verificationService;
    }

    public void setVerificationService(IVerificationService newVerificationService) {
        this.verificationService = newVerificationService;
    }

    public IBPMUserAuthenticationService getBpmUserAuthenticationService() {
        return this.bpmUserAuthenticationService;
    }

    public void setBpmUserAuthenticationService(IBPMUserAuthenticationService newBPMUserAuthenticationService) {
        this.bpmUserAuthenticationService = newBPMUserAuthenticationService;
    }

    public IProcessModelService getProcessModelService() {
        return this.processModelService;
    }

    public void setProcessModelService(IProcessModelService newProcessModelService) {
        this.processModelService = newProcessModelService;
    }

    public List<ProjectMetadataSummary> listProjectMetadataSummary(IBPMContext context, String keyword, String sortAttribute, String sortOrder) throws ProcessMetadataServiceException {
        return this.listProjectMetadataSummary(context, null, keyword, sortAttribute, sortOrder);
    }

    public List<ProjectMetadataSummary> listProjectMetadataSummary(IBPMContext context, String compositeDN, String keyword, String sortAttribute, String sortOrder) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProjectMetadataSummary", (String)("\n context: " + context + "\n compositeDN: " + compositeDN + "\n keyword: " + keyword + "\n sortAttribute: " + sortAttribute + "\n sortOrder: " + sortOrder));
        }
        List<ProjectMetadataSummary> projectMetadataSummaryList = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        String user = context.getUser();
        String identityContext = context.getIdentityContext();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProjectMetadataSummary", (String)("\n user: " + user + "\n identityContext: " + identityContext));
        }
        bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
        organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
        try {
            LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
            jpqlString = Util.constructProcessQueryString(bpmAdminUserFlag, compositeDN, keyword, sortAttribute, sortOrder, organizationalUnitIdList, argumentList);
            List dataSetObjectList = this.select(jpqlString);
            projectMetadataSummaryList = Util.convertToProjectMetadataSummaryList(argumentList, dataSetObjectList);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70800, (Object[])new String[0], (Throwable)e);
        }
        return projectMetadataSummaryList;
    }

    public ProjectMetadataSummary getProjectMetadataSummary(IBPMContext context, String compositeDN, String projectName) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProjectMetadataSummary", (String)("\n context: " + context + "\n compositeDN: " + compositeDN + "\n projectName: " + projectName));
        }
        ProjectMetadataSummary projectMetadataSummary = null;
        List<ProjectMetadataSummary> projectMetadataSummaryList = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        if (!(compositeDN != null && compositeDN.length() > 0 || projectName != null && projectName.length() > 0)) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProjectMetadataSummary", (String)"\n compositeDN and projectName are null or empty.");
            }
            return null;
        }
        String user = context.getUser();
        String identityContext = context.getIdentityContext();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProjectMetadataSummary", (String)("\n user: " + user + "\n identityContext: " + identityContext));
        }
        bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
        organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
        try {
            LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
            jpqlString = Util.constructProjectQueryString(bpmAdminUserFlag, compositeDN, projectName, organizationalUnitIdList, argumentList);
            List dataSetObjectList = this.select(jpqlString);
            projectMetadataSummaryList = Util.convertToProjectMetadataSummaryList(argumentList, dataSetObjectList);
            if (projectMetadataSummaryList != null && !projectMetadataSummaryList.isEmpty()) {
                if (projectMetadataSummaryList.size() > 1) {
                    Object[] objs = new Object[]{compositeDN, projectName};
                    throw new ProcessMetadataServiceException(70809, objs);
                }
                projectMetadataSummary = projectMetadataSummaryList.get(0);
            }
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70801, (Object[])new String[0], (Throwable)e);
        }
        return projectMetadataSummary;
    }

    public List<ProcessMetadataSummary> listProcessMetadataSummary(IBPMContext context, String keyword, String sortAttribute, String sortOrder) throws ProcessMetadataServiceException {
        return this.listProcessMetadataSummary(context, null, keyword, sortAttribute, sortOrder);
    }

    public List<ProcessMetadataSummary> listProcessMetadataSummary(IBPMContext context, String compositeDN, String keyword, String sortAttribute, String sortOrder) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProcessMetadataSummary", (String)("\n context: " + context + "\n compositeDN: " + compositeDN + "\n keyword: " + keyword + "\n sortAttribute: " + sortAttribute + "\n sortOrder: " + sortOrder));
        }
        List<ProcessMetadataSummary> processMetadataSummaryList = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        String user = context.getUser();
        String identityContext = context.getIdentityContext();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProcessMetadataSummary", (String)("\n user: " + user + "\n identityContext: " + identityContext));
        }
        bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
        organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
        try {
            LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
            jpqlString = Util.constructProcessQueryString(bpmAdminUserFlag, compositeDN, keyword, sortAttribute, sortOrder, organizationalUnitIdList, argumentList);
            List dataSetObjectList = this.select(jpqlString);
            processMetadataSummaryList = Util.convertToProcessMetadataSummaryList(argumentList, dataSetObjectList);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70802, (Object[])new String[0], (Throwable)e);
        }
        return processMetadataSummaryList;
    }

    public ProcessMetadataSummary getProcessMetadataSummary(IBPMContext context, String compositeDN, String processName) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProcessMetadataSummary", (String)("\n context: " + context + "\n compositeDN: " + compositeDN + "\n processName: " + processName));
        }
        ProcessMetadataSummary processMetadataSummary = null;
        List<ProcessMetadataSummary> processMetadataSummaryList = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        if (!(compositeDN != null && compositeDN.length() > 0 || processName != null && processName.length() > 0)) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProcessMetadataSummary", (String)"\n compositeDN and processName are null or empty.");
            }
            return null;
        }
        String user = context.getUser();
        String identityContext = context.getIdentityContext();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProcessMetadataSummary", (String)("\n user: " + user + "\n identityContext: " + identityContext));
        }
        bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
        organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
        try {
            LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
            jpqlString = Util.constructProcessQueryString(bpmAdminUserFlag, compositeDN, processName, organizationalUnitIdList, argumentList);
            List dataSetObjectList = this.select(jpqlString);
            processMetadataSummaryList = Util.convertToProcessMetadataSummaryList(argumentList, dataSetObjectList, ProcessFilter.ALL);
            if (processMetadataSummaryList != null && !processMetadataSummaryList.isEmpty()) {
                if (processMetadataSummaryList.size() > 1) {
                    Object[] objs = new Object[]{compositeDN, processName};
                    throw new ProcessMetadataServiceException(70810, objs);
                }
                processMetadataSummary = processMetadataSummaryList.get(0);
            }
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70803, (Object[])new String[0], (Throwable)e);
        }
        return processMetadataSummary;
    }

    public List<ProcessMetadataSummary> getInitiatableProcesses(IBPMContext context) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getInitiatableProcesses", (String)("\n context: " + context));
        }
        List<ProcessMetadataSummary> processMetadataSummaryList = null;
        List<String> applicationRoles = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        try {
            String user = context.getUser();
            String identityContext = context.getIdentityContext();
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getInitiatableProcesses", (String)("\n user: " + user + "\n identityContext: " + identityContext));
            }
            bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
            applicationRoles = this.getApplicationRolesForUser(context);
            if (!bpmAdminUserFlag && applicationRoles.isEmpty()) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getInitiatableProcesses", (String)("\n " + user + " is not an admin.  There are no roles for him."));
                }
                return new ArrayList<ProcessMetadataSummary>();
            }
            organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
            LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
            jpqlString = Util.constructProcessQueryString(bpmAdminUserFlag, applicationRoles, organizationalUnitIdList, argumentList);
            List dataSetObjectList = this.select(jpqlString);
            processMetadataSummaryList = Util.convertToInitiatableProcessMetadataSummaryList(argumentList, dataSetObjectList, applicationRoles, this.remoteRuntimeConfigServiceBean, context);
            for (int i = 0; i < processMetadataSummaryList.size(); ++i) {
                boolean hasUri;
                ProcessMetadataSummary applicationProcess = processMetadataSummaryList.get(i);
                boolean bl = hasUri = applicationProcess.isSetTaskDisplayInfo() && applicationProcess.getTaskDisplayInfo().isSetUri() && !applicationProcess.getTaskDisplayInfo().getUri().isEmpty();
                if (!hasUri) {
                    TaskDefinition taskDef;
                    WorkflowConfigurationType workflowConfig;
                    PayloadType payload;
                    List list;
                    Object[] objArray = (Object[])dataSetObjectList.get(i);
                    String taskDefinitionId = Util.getTaskDefinitionId(argumentList, objArray);
                    if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getInitiatableProcesses", (String)("\n taskDefinitionId: " + taskDefinitionId));
                    }
                    if (taskDefinitionId != null && (list = (payload = (workflowConfig = (taskDef = this.remoteTaskMetadataServiceBean.getTaskDefinitionById((IWorkflowContext)context, taskDefinitionId)).getWorkflowConfiguration()).getPayload()).getMessageAttribute()) != null && list.size() == 0) {
                        TaskDisplayInfoType humanTaskDisplayInfoType = sProcessMetadataFactory.createTaskDisplayInfoType();
                        humanTaskDisplayInfoType.setUri("INTERNAL_URI");
                        applicationProcess.setTaskDisplayInfo(humanTaskDisplayInfoType);
                        if (applicationProcess.isSetHasSwimlaneRole() && !applicationProcess.isHasSwimlaneRole().booleanValue()) {
                            applicationProcess.setHasSwimlaneRole(Boolean.valueOf(true));
                        }
                    }
                }
                if (applicationProcess.isSetHasSwimlaneRole()) continue;
                applicationProcess.setHasSwimlaneRole(Boolean.valueOf(false));
            }
        }
        catch (BPMIdentityException e) {
            throw new ProcessMetadataServiceException(70805, (Object[])new String[0]);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70805, (Object[])new String[0], (Throwable)e);
        }
        return processMetadataSummaryList;
    }

    public Map<String, String> getProcessRoles(IBPMContext context, String compositeDN) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getProcessRoles", (String)("\n context: " + context + "\n compositeDN: " + compositeDN));
        }
        if (compositeDN == null) {
            throw new IllegalArgumentException("null compositeDN");
        }
        this.validateContext(context);
        return DeploymentDescriptorUtil.getProcessRoles((String)compositeDN);
    }

    public String getOrganizationalUnit(IBPMContext context, String compositeDN) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getOrganizationalUnit", (String)("\n context: " + context + "\n compositeDN: " + compositeDN));
        }
        if (compositeDN == null) {
            throw new IllegalArgumentException("null compositeDN");
        }
        this.validateContext(context);
        return DeploymentDescriptorUtil.getOrganizationalUnit((String)compositeDN);
    }

    public List<ProjectMetadataSummary> listProjectMetadataSummary(IBPMContext context, String keyword, String sortAttribute, String sortOrder, boolean includeMigratedProjects) throws ProcessMetadataServiceException {
        return this.listProjectMetadataSummary(context, null, keyword, sortAttribute, sortOrder, includeMigratedProjects);
    }

    public List<ProjectMetadataSummary> listProjectMetadataSummary(IBPMContext context, String compositeDN, String keyword, String sortAttribute, String sortOrder, boolean includeMigratedProjects) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProjectMetadataSummary", (String)("\n context: " + context + "\n compositeDN: " + compositeDN + "\n keyword: " + keyword + "\n sortAttribute: " + sortAttribute + "\n sortOrder: " + sortOrder + "\n includeMigratedProjects: " + includeMigratedProjects));
        }
        if (!includeMigratedProjects) {
            return this.listProjectMetadataSummary(context, compositeDN, keyword, sortAttribute, sortOrder);
        }
        List<ProjectMetadataSummary> projectMetadataSummaryList = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        String user = context.getUser();
        String identityContext = context.getIdentityContext();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProjectMetadataSummary", (String)("\n user: " + user + "\n identityContext: " + identityContext));
        }
        bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
        organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
        try {
            LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
            jpqlString = Util.constructProcessQueryString(bpmAdminUserFlag, compositeDN, keyword, sortAttribute, sortOrder, organizationalUnitIdList, argumentList);
            List dataSetObjectList = this.select(jpqlString);
            projectMetadataSummaryList = Util.convertToProjectMetadataSummaryList(argumentList, dataSetObjectList, ProcessFilter.DEPLOYED_AND_MIGRATED);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70811, (Object[])new String[0], (Throwable)e);
        }
        return projectMetadataSummaryList;
    }

    public List<ProcessMetadataSummary> listProcessMetadataSummary(IBPMContext context, String keyword, String sortAttribute, String sortOrder, boolean includeMigratedProcesses) throws ProcessMetadataServiceException {
        return this.listProcessMetadataSummary(context, null, keyword, sortAttribute, sortOrder, includeMigratedProcesses);
    }

    public List<ProcessMetadataSummary> listProcessMetadataSummary(IBPMContext context, String compositeDN, String keyword, String sortAttribute, String sortOrder, boolean includeMigratedProcesses) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProcessMetadataSummary", (String)("\n context: " + context + "\n compositeDN: " + compositeDN + "\n keyword: " + keyword + "\n sortAttribute: " + sortAttribute + "\n sortOrder: " + sortOrder + "\n includeMigratedProcesses: " + includeMigratedProcesses));
        }
        if (!includeMigratedProcesses) {
            return this.listProcessMetadataSummary(context, compositeDN, keyword, sortAttribute, sortOrder);
        }
        List<ProcessMetadataSummary> processMetadataSummaryList = null;
        List<String> organizationalUnitIdList = null;
        boolean bpmAdminUserFlag = false;
        String jpqlString = null;
        this.validateContext(context);
        String user = context.getUser();
        String identityContext = context.getIdentityContext();
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"listProcessMetadataSummary", (String)("\n user: " + user + "\n identityContext: " + identityContext));
        }
        bpmAdminUserFlag = this.isBPMProcessAdmin((IWorkflowContext)context);
        organizationalUnitIdList = this.getOrganizationalUnitsForUser(context);
        try {
            LinkedList<QueryArgument> argumentList = new LinkedList<QueryArgument>();
            jpqlString = Util.constructProcessQueryString(bpmAdminUserFlag, compositeDN, keyword, sortAttribute, sortOrder, organizationalUnitIdList, argumentList);
            List dataSetObjectList = this.select(jpqlString);
            processMetadataSummaryList = Util.convertToProcessMetadataSummaryList(argumentList, dataSetObjectList, ProcessFilter.DEPLOYED_AND_MIGRATED);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70812, (Object[])new String[0], (Throwable)e);
        }
        return processMetadataSummaryList;
    }

    private void initBeanReferences() throws Exception {
        if (this.context == null) {
            this.context = new InitialContext();
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"initBeanReferences", (String)("\n context: " + this.context));
            }
        }
        if (this.pqs == null) {
            this.pqs = (PersistenceQueryService)this.context.lookup("BPMAnalytics#oracle.bpm.analytics.cube.persistence.PersistenceQueryService");
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"initBeanReferences", (String)("\n pqs: " + this.pqs));
            }
        }
        IWorkflowServiceClient workflowClient = null;
        if (this.remoteRuntimeConfigServiceBean == null || this.remoteTaskMetadataServiceBean == null) {
            workflowClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"REMOTE");
        }
        if (this.remoteRuntimeConfigServiceBean == null) {
            this.remoteRuntimeConfigServiceBean = workflowClient.getRuntimeConfigService();
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"initBeanReferences", (String)("\n remoteRuntimeConfigServiceBean: " + this.remoteRuntimeConfigServiceBean));
            }
        }
        if (this.remoteTaskMetadataServiceBean == null) {
            this.remoteTaskMetadataServiceBean = workflowClient.getTaskMetadataService();
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"initBeanReferences", (String)("\n remoteTaskMetadataServiceBean: " + this.remoteTaskMetadataServiceBean));
            }
        }
    }

    private List select(String jpqlString) throws Exception {
        this.initBeanReferences();
        if (jpqlString == null || jpqlString.length() <= 0) {
            return null;
        }
        return this.pqs.select(jpqlString);
    }

    private void validateContext(IBPMContext context) throws ProcessMetadataServiceException {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        try {
            VerificationService verificationSvc = new VerificationService();
            verificationSvc.validateContext((IWorkflowContext)context);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 71051, (Object[])new String[0], (Throwable)e);
        }
    }

    private BPMUser lookupUser(IWorkflowContext ctx) throws ProcessMetadataServiceException {
        try {
            return VerificationService.lookupUser((IWorkflowContext)ctx);
        }
        catch (WorkflowException e) {
            throw new ProcessMetadataServiceException(70804, (Object[])new String[0]);
        }
    }

    private BPMAuthorizationService getAuthorizationService(String identityContext) {
        BPMAuthorizationService authorizationService = ServiceFactory.getAuthorizationServiceInstance();
        if (identityContext != null) {
            authorizationService = ServiceFactory.getAuthorizationServiceInstance((String)identityContext);
        }
        return authorizationService;
    }

    private boolean isBPMProcessAdmin(IWorkflowContext ctx) throws ProcessMetadataServiceException {
        boolean bpmAdminUserFlag = false;
        if (ctx.getIsAdmin()) {
            bpmAdminUserFlag = true;
        } else {
            BPMAuthorizationService authSvc = this.getAuthorizationService(ctx.getIdentityContext());
            try {
                BPMUser bpmUser = this.lookupUser(ctx);
                bpmAdminUserFlag = bpmUser.isInAppRole(ROLE_BPM_PROCESS_ADMIN, ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value());
            }
            catch (BPMIdentityException e) {
                throw new ProcessMetadataServiceException(70804, (Object[])new String[0]);
            }
        }
        if (bpmAdminUserFlag) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"isBPMProcessAdmin", (String)("\n " + ctx.getUser() + " is an admin"));
            }
        } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"isBPMProcessAdmin", (String)("\n " + ctx.getUser() + " is not an admin"));
        }
        return bpmAdminUserFlag;
    }

    private List<String> getApplicationRolesForUser(IBPMContext context) throws ProcessMetadataServiceException {
        List appRolesList = null;
        ArrayList<String> applicationRoles = new ArrayList<String>();
        try {
            BPMUser userObj = this.lookupUser((IWorkflowContext)context);
            appRolesList = userObj.getAppRoles(false, ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value());
        }
        catch (BPMIdentityException e) {
            throw new ProcessMetadataServiceException(70805, (Object[])new String[0]);
        }
        if (appRolesList != null && !appRolesList.isEmpty()) {
            for (int i = 0; i < appRolesList.size(); ++i) {
                Object obj = appRolesList.get(i);
                if (obj instanceof BPMAppRole) {
                    BPMAppRole bpmAppRole = (BPMAppRole)obj;
                    if (bpmAppRole == null) continue;
                    applicationRoles.add(bpmAppRole.getName());
                    continue;
                }
                if (!BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) continue;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getApplicationRolesForUser", (String)"\n obj is not an instance of BPMAppRole");
            }
        }
        if (applicationRoles.isEmpty()) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getApplicationRolesForUser", (String)("\n There are no roles for " + context.getUser()));
            }
        } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getApplicationRolesForUser", (String)("\n Number of roles " + context.getUser() + " has: " + applicationRoles.size() + "\n Applications roles: " + applicationRoles));
        }
        return applicationRoles;
    }

    private List<String> getOrganizationalUnitsForUser(IBPMContext context) throws ProcessMetadataServiceException {
        List organizationalUnitIdList = null;
        try {
            organizationalUnitIdList = VerificationService.getOrganizationalUnits((IBPMContext)context);
        }
        catch (Exception e) {
            throw new ProcessMetadataServiceException(Severity.ERRORS, 70802, (Object[])new String[0], (Throwable)e);
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_METADATA_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getOrganizationalUnitsForUser", (String)("\n organizationalUnitIdList: " + organizationalUnitIdList));
        }
        return organizationalUnitIdList;
    }

    public static enum ProcessFilter {
        DEPLOYED_ONLY,
        DEPLOYED_AND_MIGRATED,
        ALL;

    }
}

