/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpm.lang.Interval;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.resources.BPMServicesResource;
import oracle.bpm.services.processdashboard.IDashboardConstants;
import oracle.bpm.services.processdashboard.model.ComponentType;
import oracle.bpm.services.processdashboard.model.WidgetView;
import oracle.bpm.services.processdashboard.model.impl.ConditionValueUtil;
import oracle.bpm.services.processdashboard.model.impl.ModelTypeFactory;
import oracle.bpm.services.processdashboard.model.impl.WidgetViewImpl;
import oracle.bpm.services.processdashboard.model.jaxb.AggregateFunctionTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.ConditionType;
import oracle.bpm.services.processdashboard.model.jaxb.DataSourceTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.DataType;
import oracle.bpm.services.processdashboard.model.jaxb.DimensionType;
import oracle.bpm.services.processdashboard.model.jaxb.DimensionsType;
import oracle.bpm.services.processdashboard.model.jaxb.JoinOperatorTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.MeasurementType;
import oracle.bpm.services.processdashboard.model.jaxb.ObjectFactory;
import oracle.bpm.services.processdashboard.model.jaxb.OperatorTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.PredicateType;
import oracle.bpm.services.processdashboard.model.jaxb.SeriesType;
import oracle.bpm.services.processdashboard.model.jaxb.TitleType;
import oracle.bpm.services.processdashboard.model.jaxb.ValueTypeEnum;
import oracle.bpm.services.processdashboard.model.jaxb.VisualizationType;
import oracle.bpm.services.processdashboard.model.jaxb.WidgetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardWidgets {
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static WidgetView workloadPerProcessView;
    private static WidgetView workloadPerParticipantView;
    private static WidgetView performancePerProcessView;
    private static WidgetView performancePerProcessByParticipantView;
    private static WidgetView workloadHistoricalComparisonView;
    private static WidgetView workloadHistoricalComparisonLastDayView;
    private static WidgetView workloadHistoricalComparisonLastWeekView;
    private static WidgetView workloadHistoricalComparisonLastMonthView;
    private static WidgetView performanceHistoricalComparisonView;
    private static WidgetView performanceHistoricalComparisonInHoursView;
    private static WidgetView performanceHistoricalComparisonInMinutesView;
    private static WidgetType workloadPerProcess;
    private static WidgetType workloadPerProcessByParticipant;
    private static WidgetType performancePerProcess;
    private static WidgetType performancePerProcessByParticipant;
    private static WidgetType workloadHistoricalComparison;
    private static WidgetType workloadHistoricalComparisonLastDay;
    private static WidgetType workloadHistoricalComparisonLastWeek;
    private static WidgetType workloadHistoricalComparisonLastMonth;
    private static WidgetType performanceHistoricalComparison;
    private static WidgetType performanceHistoricalComparisonInHours;
    private static WidgetType performanceHistoricalComparisonInMinutes;

    public static boolean isStandardId(String id) {
        return id != null && (id.equalsIgnoreCase("SWpPro-20090902103700") || id.equalsIgnoreCase("SWpPar-20091229115500") || id.equalsIgnoreCase("SPpPro-20090902103700") || id.equalsIgnoreCase("SPpPar-20091229115500") || id.equalsIgnoreCase("SWhPer-20120118172300") || id.equalsIgnoreCase("SWhPerLd-20120118172300") || id.equalsIgnoreCase("SWhPerLw-20120118172300") || id.equalsIgnoreCase("SWhPerLm-20120118172300") || id.equalsIgnoreCase("SPhPer-20120118172300") || id.equalsIgnoreCase("SPhPerH-20120118172300") || id.equalsIgnoreCase("SPhPerMin-20120118172300"));
    }

    public static List<WidgetView> getAll(IBPMContext bpmContext) throws BPMException {
        return StandardWidgets.getAll();
    }

    public static List<WidgetView> getAllPublic(IBPMContext context) throws BPMException {
        return StandardWidgets.getAllPublic();
    }

    public static List<WidgetView> getAllPublic() throws BPMException {
        ArrayList<WidgetView> widgets = new ArrayList<WidgetView>();
        widgets.add(StandardWidgets.getWorkloadPerProcessWidgetView());
        widgets.add(StandardWidgets.getPerformancePerProcessWidgetView());
        widgets.add(StandardWidgets.getWorkloadPerParticipantWidgetView());
        widgets.add(StandardWidgets.getPerformancePerParticipantWidgetView());
        return widgets;
    }

    public static List<WidgetView> getAll() throws BPMException {
        List<WidgetView> widgets = StandardWidgets.getAllPublic();
        widgets.add(StandardWidgets.getWorkloadHistoricalComparisonWidgetView());
        widgets.add(StandardWidgets.getWorkloadHistoricalComparisonLastDayWidgetView());
        widgets.add(StandardWidgets.getWorkloadHistoricalComparisonLastWeekWidgetView());
        widgets.add(StandardWidgets.getWorkloadHistoricalComparisonLastMonthWidgetView());
        widgets.add(StandardWidgets.getPerformanceHistoricalComparisonWidgetView());
        widgets.add(StandardWidgets.getPerformanceHistoricalComparisonInHoursWidgetView());
        widgets.add(StandardWidgets.getPerformanceHistoricalComparisonInMinutesWidgetView());
        return widgets;
    }

    public static WidgetView get(@NotNull String widgetId) throws BPMException {
        if (StandardWidgets.isStandardId(widgetId)) {
            for (WidgetView widgetView : StandardWidgets.getAll()) {
                if (!widgetId.equalsIgnoreCase(widgetView.getId())) continue;
                return widgetView;
            }
        }
        return null;
    }

    public static WidgetView getWorkloadPerProcessWidgetView() throws BPMException {
        if (workloadPerProcessView == null) {
            workloadPerProcessView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SWpPro-20090902103700", "Workload per Process", workloadPerProcess));
        }
        return workloadPerProcessView;
    }

    public static WidgetView getWorkloadPerParticipantWidgetView() throws BPMException {
        if (workloadPerParticipantView == null) {
            workloadPerParticipantView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SWpPar-20091229115500", "Workload per Participant", workloadPerProcessByParticipant));
        }
        return workloadPerParticipantView;
    }

    public static WidgetView getPerformancePerProcessWidgetView() throws BPMException {
        if (performancePerProcessView == null) {
            performancePerProcessView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SPpPro-20090902103700", "Performance per Process", performancePerProcess));
        }
        return performancePerProcessView;
    }

    public static WidgetView getPerformancePerParticipantWidgetView() throws BPMException {
        if (performancePerProcessByParticipantView == null) {
            performancePerProcessByParticipantView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SPpPar-20091229115500", "Performance per Participant", performancePerProcessByParticipant));
        }
        return performancePerProcessByParticipantView;
    }

    public static WidgetView getWorkloadHistoricalComparisonWidgetView() throws BPMException {
        if (workloadHistoricalComparisonView == null) {
            workloadHistoricalComparisonView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SWhPer-20120118172300", "Historical Workload Comparison", workloadHistoricalComparison));
        }
        return workloadHistoricalComparisonView;
    }

    public static WidgetView getWorkloadHistoricalComparisonLastMonthWidgetView() throws BPMException {
        if (workloadHistoricalComparisonLastMonthView == null) {
            workloadHistoricalComparisonLastMonthView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SWhPerLm-20120118172300", "Historical Workload Comparison (Last Month)", workloadHistoricalComparisonLastMonth));
        }
        return workloadHistoricalComparisonLastMonthView;
    }

    public static WidgetView getWorkloadHistoricalComparisonLastWeekWidgetView() throws BPMException {
        if (workloadHistoricalComparisonLastWeekView == null) {
            workloadHistoricalComparisonLastWeekView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SWhPerLw-20120118172300", "Historical Workload Comparison (Last Week)", workloadHistoricalComparisonLastWeek));
        }
        return workloadHistoricalComparisonLastWeekView;
    }

    public static WidgetView getWorkloadHistoricalComparisonLastDayWidgetView() throws BPMException {
        if (workloadHistoricalComparisonLastDayView == null) {
            workloadHistoricalComparisonLastDayView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SWhPerLd-20120118172300", "Historical Workload Comparison (Last Day)", workloadHistoricalComparisonLastDay));
        }
        return workloadHistoricalComparisonLastDayView;
    }

    public static WidgetView getPerformanceHistoricalComparisonWidgetView() throws BPMException {
        if (performanceHistoricalComparisonView == null) {
            performanceHistoricalComparisonView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SPhPer-20120118172300", "Historical Performance Comparison (In Days)", performanceHistoricalComparison));
        }
        return performanceHistoricalComparisonView;
    }

    public static WidgetView getPerformanceHistoricalComparisonInHoursWidgetView() throws BPMException {
        if (performanceHistoricalComparisonInHoursView == null) {
            performanceHistoricalComparisonInHoursView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SPhPerH-20120118172300", "Historical Performance Comparison (In Hours)", performanceHistoricalComparisonInHours));
        }
        return performanceHistoricalComparisonInHoursView;
    }

    public static WidgetView getPerformanceHistoricalComparisonInMinutesWidgetView() throws BPMException {
        if (performanceHistoricalComparisonInMinutesView == null) {
            performanceHistoricalComparisonInMinutesView = WidgetViewImpl.create((UserApplicationDataType)StandardWidgets.getUserApplicationDataType("SPhPerMin-20120118172300", "Historical Performance Comparison (In Minutes)", performanceHistoricalComparisonInMinutes));
        }
        return performanceHistoricalComparisonInMinutesView;
    }

    public static WidgetType getWorkloadPerProcessWidget() {
        VisualizationType visualization = objectFactory.createVisualizationType();
        ArrayList<TitleType> titles = new ArrayList<TitleType>();
        DataType data = objectFactory.createDataType();
        SeriesType series = objectFactory.createSeriesType();
        MeasurementType measurement = objectFactory.createMeasurementType();
        DimensionsType dimensions = objectFactory.createDimensionsType();
        DimensionType xSeries = objectFactory.createDimensionType();
        for (Locale locale : Locale.getAvailableLocales()) {
            String resource = BPMServicesResource.getResource((String)"WORKLOAD_PER_PROCESS", (Locale)locale);
            if (resource == null || resource.isEmpty()) continue;
            TitleType title = objectFactory.createTitleType();
            title.setLang(locale.getLanguage());
            title.setCountry(locale.getCountry());
            title.setValue(resource);
            titles.add(title);
        }
        visualization.setType(ComponentType.BAR_HORIZ_CLUST.name());
        visualization.getTitles().addAll(titles);
        visualization.getOtherAttributes().put(new QName("y1Title"), "Quantity");
        measurement.setVariable("quantityOfInstances");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.SUM);
        measurement.setValueType(ValueTypeEnum.VALUE);
        xSeries.setValue("process");
        dimensions.setXSeries(xSeries);
        series.setDataSource(DataSourceTypeEnum.CUBE_WORKLOAD);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        series.setPredicate(StandardWidgets.getActivityTypePredicate());
        data.getSeries().add(series);
        WidgetType widgetType = objectFactory.createWidgetType();
        widgetType.setName("Workload per Process");
        widgetType.setVisualization(visualization);
        widgetType.setData(data);
        return widgetType;
    }

    public static WidgetType getWorkloadHistoricalComparisonWidget() {
        return StandardWidgets.getWorkloadHistoricalComparisonWidget("WORKLOAD_HISTORICAL_COMPARISON", null);
    }

    public static WidgetType getWorkloadHistoricalComparisonWidgetLastDay() {
        return StandardWidgets.getWorkloadHistoricalComparisonWidget("WORKLOAD_HISTORICAL_COMPARISON_LAST_DAY", StandardWidgets.getPredicateForInterval(new Interval().addDays(1)));
    }

    public static WidgetType getWorkloadHistoricalComparisonWidgetLastWeek() {
        return StandardWidgets.getWorkloadHistoricalComparisonWidget("WORKLOAD_HISTORICAL_COMPARISON_LAST_WEEK", StandardWidgets.getPredicateForInterval(new Interval().addDays(7)));
    }

    public static WidgetType getWorkloadHistoricalComparisonWidgetLastMonth() {
        return StandardWidgets.getWorkloadHistoricalComparisonWidget("WORKLOAD_HISTORICAL_COMPARISON_LAST_MONTH", StandardWidgets.getPredicateForInterval(new Interval().addMonths(1)));
    }

    public static WidgetType getWorkloadPerParticipantWidget() {
        VisualizationType visualization = objectFactory.createVisualizationType();
        ArrayList<TitleType> titles = new ArrayList<TitleType>();
        DataType data = objectFactory.createDataType();
        SeriesType series = objectFactory.createSeriesType();
        MeasurementType measurement = objectFactory.createMeasurementType();
        DimensionsType dimensions = objectFactory.createDimensionsType();
        DimensionType xSeries = objectFactory.createDimensionType();
        for (Locale locale : Locale.getAvailableLocales()) {
            String resource = BPMServicesResource.getResource((String)"WORKLOAD_PER_PARTICIPANT", (Locale)locale);
            if (resource == null || resource.isEmpty()) continue;
            TitleType title = objectFactory.createTitleType();
            title.setLang(locale.getLanguage());
            title.setCountry(locale.getCountry());
            title.setValue(resource);
            titles.add(title);
        }
        visualization.setType(ComponentType.BAR_HORIZ_CLUST.name());
        visualization.getTitles().addAll(titles);
        visualization.getOtherAttributes().put(new QName("y1Title"), "Quantity");
        measurement.setVariable("quantityOfInstances");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.SUM);
        measurement.setValueType(ValueTypeEnum.VALUE);
        xSeries.setValue("participant");
        dimensions.setXSeries(xSeries);
        series.setDataSource(DataSourceTypeEnum.CUBE_WORKLOAD);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        data.getSeries().add(series);
        WidgetType widgetType = objectFactory.createWidgetType();
        widgetType.setName("Workload per Participant");
        widgetType.setVisualization(visualization);
        widgetType.setData(data);
        return widgetType;
    }

    public static WidgetType getPerformancePerProcess() {
        VisualizationType visualization = objectFactory.createVisualizationType();
        ArrayList<TitleType> titles = new ArrayList<TitleType>();
        DataType data = objectFactory.createDataType();
        SeriesType series = objectFactory.createSeriesType();
        MeasurementType measurement = objectFactory.createMeasurementType();
        DimensionsType dimensions = objectFactory.createDimensionsType();
        DimensionType xSeries = objectFactory.createDimensionType();
        for (Locale locale : Locale.getAvailableLocales()) {
            String resource = BPMServicesResource.getResource((String)"PERFORMANCE_PER_PROCESS", (Locale)locale);
            if (resource == null || resource.isEmpty()) continue;
            TitleType title = objectFactory.createTitleType();
            title.setLang(locale.getLanguage());
            title.setCountry(locale.getCountry());
            title.setValue(resource);
            titles.add(title);
        }
        visualization.setType(ComponentType.BAR_HORIZ_CLUST.name());
        visualization.getTitles().addAll(titles);
        measurement.setVariable("taskTime");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.AVG);
        measurement.setValueType(ValueTypeEnum.MINUTES);
        xSeries.setValue("process");
        dimensions.setXSeries(xSeries);
        series.setDataSource(DataSourceTypeEnum.CUBE_PROCESS_PERFORMANCE);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        data.getSeries().add(series);
        WidgetType widgetType = objectFactory.createWidgetType();
        widgetType.setName("Performance per Process");
        widgetType.setVisualization(visualization);
        widgetType.setData(data);
        return widgetType;
    }

    public static WidgetType getPerformancePerParticipant() {
        VisualizationType visualization = objectFactory.createVisualizationType();
        ArrayList<TitleType> titles = new ArrayList<TitleType>();
        DataType data = objectFactory.createDataType();
        SeriesType series = objectFactory.createSeriesType();
        MeasurementType measurement = objectFactory.createMeasurementType();
        DimensionsType dimensions = objectFactory.createDimensionsType();
        DimensionType xSeries = objectFactory.createDimensionType();
        for (Locale locale : Locale.getAvailableLocales()) {
            String resource = BPMServicesResource.getResource((String)"PERFORMANCE_PER_PARTICIPANT", (Locale)locale);
            if (resource == null || resource.isEmpty()) continue;
            TitleType title = objectFactory.createTitleType();
            title.setLang(locale.getLanguage());
            title.setCountry(locale.getCountry());
            title.setValue(resource);
            titles.add(title);
        }
        visualization.setType(ComponentType.BAR_HORIZ_CLUST.name());
        visualization.getTitles().addAll(titles);
        measurement.setVariable("taskTime");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.AVG);
        measurement.setValueType(ValueTypeEnum.MINUTES);
        xSeries.setValue("participant");
        dimensions.setXSeries(xSeries);
        series.setDataSource(DataSourceTypeEnum.CUBE_TASK_PERFORMANCE);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        data.getSeries().add(series);
        WidgetType widgetType = objectFactory.createWidgetType();
        widgetType.setName("Performance per Participant");
        widgetType.setVisualization(visualization);
        widgetType.setData(data);
        return widgetType;
    }

    public static WidgetType getPerformanceHistoricalComparisonWidget() {
        return StandardWidgets.getPerformanceHistoricalComparisonWidget("PERFORMANCE_HISTORICAL_COMPARISON", ValueTypeEnum.DAYS);
    }

    public static WidgetType getPerformanceHistoricalComparisonInHoursWidget() {
        return StandardWidgets.getPerformanceHistoricalComparisonWidget("PERFORMANCE_HISTORICAL_COMPARISON_IN_HOURS", ValueTypeEnum.HOURS);
    }

    public static WidgetType getPerformanceHistoricalComparisonInMinutesWidget() {
        return StandardWidgets.getPerformanceHistoricalComparisonWidget("PERFORMANCE_HISTORICAL_COMPARISON_IN_MINUTES", ValueTypeEnum.MINUTES);
    }

    private static WidgetType getWorkloadHistoricalComparisonWidget(@NotNull String resourceTitle, @Nullable PredicateType predicate) {
        VisualizationType visualization = objectFactory.createVisualizationType();
        ArrayList<TitleType> titles = new ArrayList<TitleType>();
        DataType data = objectFactory.createDataType();
        SeriesType series = objectFactory.createSeriesType();
        MeasurementType measurement = objectFactory.createMeasurementType();
        DimensionsType dimensions = objectFactory.createDimensionsType();
        DimensionType xSeries = objectFactory.createDimensionType();
        for (Locale locale : Locale.getAvailableLocales()) {
            String resource = BPMServicesResource.getResource((String)resourceTitle, (Locale)locale);
            if (resource == null || resource.isEmpty()) continue;
            TitleType title = objectFactory.createTitleType();
            title.setLang(locale.getLanguage());
            title.setCountry(locale.getCountry());
            title.setValue(resource);
            titles.add(title);
        }
        visualization.setType(ComponentType.BAR_HORIZ_CLUST.name());
        visualization.getTitles().addAll(titles);
        visualization.getOtherAttributes().put(new QName("y1Title"), "Quantity");
        measurement.setVariable("quantity");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.SUM);
        measurement.setValueType(ValueTypeEnum.VALUE);
        xSeries.setValue("process");
        dimensions.setXSeries(xSeries);
        series.setDataSource(DataSourceTypeEnum.CUBE_WORKLOAD);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        data.getSeries().add(series);
        series = objectFactory.createSeriesType();
        measurement = objectFactory.createMeasurementType();
        measurement.setVariable("quantityOfInstances");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.COUNT);
        measurement.setValueType(ValueTypeEnum.VALUE);
        series.setDataSource(DataSourceTypeEnum.CUBE_PROCESS_PERFORMANCE);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        if (predicate != null) {
            series.setPredicate(predicate);
        }
        data.getSeries().add(series);
        WidgetType widgetType = objectFactory.createWidgetType();
        widgetType.setName("Workload Historical Comparison");
        widgetType.setVisualization(visualization);
        widgetType.setData(data);
        return widgetType;
    }

    private static PredicateType getPredicateForInterval(@NotNull Interval interval) {
        PredicateType predicate = objectFactory.createPredicateType();
        ConditionType condition = objectFactory.createConditionType();
        condition.setVariable("completionDate");
        condition.setOperator(OperatorTypeEnum.EQUALS);
        condition.setValue(ConditionValueUtil.getStringValue((Object)interval));
        condition.setUseRange(false);
        predicate.getConditions().add(condition);
        return predicate;
    }

    private static PredicateType getActivityTypePredicate() {
        PredicateType predicate = objectFactory.createPredicateType();
        predicate.setJoinOperator(JoinOperatorTypeEnum.OR);
        for (BpmnType bpmnType : IDashboardConstants.STANDARD_WIDGET_ACTIVITY_TYPES) {
            ConditionType condition = objectFactory.createConditionType();
            condition.setVariable("activityType");
            condition.setOperator(OperatorTypeEnum.EQUALS);
            condition.setValue(bpmnType.name());
            condition.setUseRange(false);
            predicate.getConditions().add(condition);
            condition = objectFactory.createConditionType();
            condition.setVariable("activityType");
            condition.setOperator(OperatorTypeEnum.EQUALS);
            condition.setValue(bpmnType.getString());
            condition.setUseRange(false);
            predicate.getConditions().add(condition);
        }
        return predicate;
    }

    private static UserApplicationDataType getUserApplicationDataType(@NotNull String id, @NotNull String name, @NotNull WidgetType widget) throws BPMException {
        UserApplicationDataType userApplicationDataType = ModelTypeFactory.getUserModelFactory().createUserApplicationDataType();
        userApplicationDataType.setId(id);
        userApplicationDataType.setName(name);
        userApplicationDataType.setApplicationDataType("BAM-WIDGET");
        userApplicationDataType.setData(ModelTypeFactory.getXMLFromWidget((WidgetType)widget));
        return userApplicationDataType;
    }

    private static WidgetType getPerformanceHistoricalComparisonWidget(@NotNull String resourceTitle, ValueTypeEnum type) {
        VisualizationType visualization = objectFactory.createVisualizationType();
        ArrayList<TitleType> titles = new ArrayList<TitleType>();
        DataType data = objectFactory.createDataType();
        SeriesType series = objectFactory.createSeriesType();
        MeasurementType measurement = objectFactory.createMeasurementType();
        DimensionsType dimensions = objectFactory.createDimensionsType();
        DimensionType xSeries = objectFactory.createDimensionType();
        for (Locale locale : Locale.getAvailableLocales()) {
            String resource = BPMServicesResource.getResource((String)resourceTitle, (Locale)locale);
            if (resource == null || resource.isEmpty()) continue;
            TitleType title = objectFactory.createTitleType();
            title.setLang(locale.getLanguage());
            title.setCountry(locale.getCountry());
            title.setValue(resource);
            titles.add(title);
        }
        visualization.setType(ComponentType.BAR_HORIZ_CLUST.name());
        visualization.getTitles().addAll(titles);
        visualization.getOtherAttributes().put(new QName("y1Title"), "Average Time");
        measurement.setVariable("avgTimeProcess");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.AVG);
        measurement.setValueType(type);
        xSeries.setValue("process");
        dimensions.setXSeries(xSeries);
        series.setDataSource(DataSourceTypeEnum.CUBE_WORKLOAD);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        data.getSeries().add(series);
        series = objectFactory.createSeriesType();
        measurement = objectFactory.createMeasurementType();
        measurement.setVariable("taskTime");
        measurement.setAggregateFunction(AggregateFunctionTypeEnum.AVG);
        measurement.setValueType(type);
        series.setDataSource(DataSourceTypeEnum.CUBE_PROCESS_PERFORMANCE);
        series.setMeasurement(measurement);
        series.setDimensions(dimensions);
        series.setStandard(true);
        data.getSeries().add(series);
        WidgetType widgetType = objectFactory.createWidgetType();
        widgetType.setName("Performance Historical Comparison");
        widgetType.setVisualization(visualization);
        widgetType.setData(data);
        return widgetType;
    }

    static {
        workloadPerProcess = StandardWidgets.getWorkloadPerProcessWidget();
        workloadPerProcessByParticipant = StandardWidgets.getWorkloadPerParticipantWidget();
        performancePerProcess = StandardWidgets.getPerformancePerProcess();
        performancePerProcessByParticipant = StandardWidgets.getPerformancePerParticipant();
        workloadHistoricalComparison = StandardWidgets.getWorkloadHistoricalComparisonWidget();
        workloadHistoricalComparisonLastDay = StandardWidgets.getWorkloadHistoricalComparisonWidgetLastDay();
        workloadHistoricalComparisonLastWeek = StandardWidgets.getWorkloadHistoricalComparisonWidgetLastWeek();
        workloadHistoricalComparisonLastMonth = StandardWidgets.getWorkloadHistoricalComparisonWidgetLastMonth();
        performanceHistoricalComparison = StandardWidgets.getPerformanceHistoricalComparisonWidget();
        performanceHistoricalComparisonInHours = StandardWidgets.getPerformanceHistoricalComparisonInHoursWidget();
        performanceHistoricalComparisonInMinutes = StandardWidgets.getPerformanceHistoricalComparisonInMinutesWidget();
    }
}

