/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.common.model.ComponentDNModelUtils;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.processdashboard.model.Condition;
import oracle.bpm.services.processdashboard.model.DataSource;
import oracle.bpm.services.processdashboard.model.JoinOperator;
import oracle.bpm.services.processdashboard.model.Measurement;
import oracle.bpm.services.processdashboard.model.Operator;
import oracle.bpm.services.processdashboard.model.Predicate;
import oracle.bpm.services.processdashboard.model.Series;
import oracle.bpm.services.processdashboard.model.ValueType;
import oracle.bpm.services.processdashboard.model.Widget;
import oracle.bpm.services.processdashboard.model.impl.ConditionImpl;
import oracle.bpm.services.processdashboard.model.impl.PredicateImpl;
import oracle.bpm.services.processdashboard.model.impl.SeriesImpl;
import oracle.bpm.services.processdashboard.model.impl.WidgetImpl;
import oracle.bpm.services.processdashboard.model.impl.WidgetViewImpl;
import oracle.bpm.services.processdashboard.model.jaxb.ConditionType;
import oracle.bpm.services.processdashboard.model.jaxb.DimensionsType;
import oracle.bpm.services.processdashboard.model.jaxb.DrillDownType;
import oracle.bpm.services.processdashboard.model.jaxb.MeasurementType;
import oracle.bpm.services.processdashboard.model.jaxb.ObjectFactory;
import oracle.bpm.services.processdashboard.model.jaxb.PredicateType;
import oracle.bpm.services.processdashboard.model.jaxb.SeriesType;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processmetadata.StatusEnum;
import org.jetbrains.annotations.NotNull;

public class ProcessDashboardUtils {
    private static final ObjectFactory widgetFactory = new ObjectFactory();
    private static final String PARTICIPANT_APPLICATION_ROLE = ",application_role";
    private static final String PARTICIPANT_USER = ",user";
    private static final String DEFAULT_APPLICATION = ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value();

    public static WidgetViewImpl validateWidgetView(IBPMContext bpmContext, IProcessMetadataService service, WidgetViewImpl widgetView) throws BPMException {
        return ProcessDashboardUtils.validateWidgetView(widgetView, ProcessDashboardUtils.getProcesses(bpmContext, service));
    }

    public static WidgetViewImpl validateWidgetView(@NotNull WidgetViewImpl widgetView, @NotNull Set<ComponentDNModel> processes) throws BPMException {
        WidgetImpl widget;
        if (widgetView != null && widgetView.hasWidget() && (widget = ProcessDashboardUtils.validateWidget((WidgetImpl)widgetView.getWidget(), processes)) != null) {
            widgetView.setWidget((Widget)widget);
            return widgetView;
        }
        return null;
    }

    public static Widget fixWidget(@NotNull IBPMContext bpmContext, @NotNull IProcessMetadataService service, @NotNull Widget widget) throws BPMException {
        return ProcessDashboardUtils.fixWidget(bpmContext, ProcessDashboardUtils.getProcesses(bpmContext, service), widget);
    }

    public static Widget fixWidget(@NotNull IBPMContext bpmContext, @NotNull Set<ComponentDNModel> processes, @NotNull Widget widget) throws BPMException {
        Widget _widget = widget;
        if (_widget != null && _widget.getData() != null && widget.getData().hasSeries()) {
            _widget = ProcessDashboardUtils.fixMeasurement(widget);
            _widget = ProcessDashboardUtils.fixSeriesProcess(_widget, processes);
            if (!bpmContext.getIsAdmin() && (_widget = ProcessDashboardUtils.addProcessConditions(_widget, processes)) != null) {
                _widget = ProcessDashboardUtils.addParticipantConditions(bpmContext, _widget);
            }
        }
        return _widget;
    }

    public static Set<ComponentDNModel> getProcesses(@NotNull IBPMContext bpmContext, @NotNull IProcessMetadataService service) throws BPMException {
        TreeSet<ComponentDNModel> activeProcesses = new TreeSet<ComponentDNModel>();
        List processes = service.listProcessMetadataSummary(bpmContext, null, null, null, true);
        for (ProcessMetadataSummary process : processes) {
            if (process.getStatus() != null && process.getStatus() == StatusEnum.DELETED) continue;
            ComponentDNModel componentDN = ComponentDNModel.buildComponentDN((String)process.getDomainName(), (String)process.getCompositeName(), (String)process.getRevision(), (String)process.getLabel(), (String)process.getProcessName());
            activeProcesses.add(componentDN);
        }
        return activeProcesses;
    }

    private static Widget fixSeriesProcess(@NotNull Widget widget, @NotNull Set<ComponentDNModel> processes) {
        List seriesList = widget.getData().getSeries();
        for (Series series : seriesList) {
            if (!series.hasProcess()) continue;
            widget.getData().removeSeries(series);
            ComponentDNModel componentDN = ComponentDNModel.parseConsolidatedComponentDN((String)series.getProcess());
            for (ComponentDNModel componentDNModel : ComponentDNModelUtils.getAllVersions((ComponentDNModel)componentDN, processes)) {
                Series _series = ProcessDashboardUtils.cloneSeries(series);
                _series.setProcess(componentDNModel.getDNString());
                widget.getData().addSeries(_series);
            }
        }
        return widget;
    }

    private static WidgetImpl validateWidget(@NotNull WidgetImpl widget, @NotNull Set<ComponentDNModel> processes) throws BPMException {
        if (widget != null && widget.getData() != null && widget.getData().hasSeries()) {
            ArrayList<Series> validSeries = new ArrayList<Series>();
            for (Series series : widget.getData().getSeries()) {
                if (series.hasProcess() && series.getProcess() != null) {
                    ComponentDNModel seriesProcess = ComponentDNModel.parseConsolidatedComponentDN((String)series.getProcess());
                    ComponentDNModel validProcess = ComponentDNModelUtils.getCurrentProcessLabel((ComponentDNModel)seriesProcess, processes);
                    if (validProcess == null) {
                        validProcess = ComponentDNModelUtils.getAnyVersion((ComponentDNModel)seriesProcess, processes);
                    }
                    if (validProcess == null) continue;
                    series.setProcess(validProcess.getDNString());
                    validSeries.add(series);
                    continue;
                }
                validSeries.add(series);
            }
            if (!validSeries.isEmpty()) {
                widget.getData().clear();
                for (Series _series : validSeries) {
                    widget.getData().addSeries(_series);
                }
                return widget;
            }
        }
        return null;
    }

    private static Widget fixMeasurement(@NotNull Widget widget) throws BPMException {
        if (widget != null && widget.getData() != null && widget.getData().hasSeries()) {
            for (Series series : widget.getData().getSeries()) {
                Measurement measurement;
                String variable;
                boolean fixValueType;
                if (!series.hasMeasurement() || !(fixValueType = (variable = (measurement = series.getMeasurement()).getVariable()) != null && ("avgTimeProcess".equalsIgnoreCase(variable) || "avgTimeTask".equalsIgnoreCase(variable) || "medianTimeProcess".equalsIgnoreCase(variable) || "medianTimeTask".equalsIgnoreCase(variable) || "taskTime".equalsIgnoreCase(variable)))) continue;
                switch (measurement.getValueType()) {
                    case AUTOMATIC_HANDLE_DATE: 
                    case VALUE: {
                        measurement.setValueType(ValueType.MINUTES);
                    }
                }
            }
        }
        return widget;
    }

    private static Widget addProcessConditions(@NotNull Widget widget, @NotNull Set<ComponentDNModel> processes) throws BPMException {
        if (widget != null && widget.getData() != null && widget.getData().hasSeries()) {
            PredicateImpl processPredicate = PredicateImpl.create();
            processPredicate.setJoinOperator(JoinOperator.OR);
            for (ComponentDNModel processDN : processes) {
                ConditionImpl condition = ConditionImpl.create();
                condition.setVariable("process");
                condition.setOperator(Operator.EQUALS);
                condition.setValue((Object)processDN.getDNString());
                processPredicate.addCondition((Condition)condition);
            }
            for (Series series : widget.getData().getSeries()) {
                if (series.hasProcess()) continue;
                PredicateImpl predicate = PredicateImpl.create();
                if (series.hasPredicate()) {
                    predicate.setLeftCondition(series.getPredicate());
                    predicate.setJoinOperator(JoinOperator.AND);
                    predicate.setRightCondition((Predicate)processPredicate);
                } else {
                    predicate = processPredicate;
                }
                series.setPredicate((Predicate)predicate);
            }
        }
        return widget;
    }

    private static Widget addParticipantConditions(@NotNull IBPMContext bpmContext, @NotNull Widget widget) throws BPMException {
        if (widget.getData() != null && widget.getData().hasSeries()) {
            PredicateImpl participantPredicate = PredicateImpl.create();
            participantPredicate.setJoinOperator(JoinOperator.OR);
            ConditionImpl condition = ConditionImpl.create();
            condition.setVariable("participant");
            condition.setOperator(Operator.EQUALS);
            condition.setValue((Object)(bpmContext.getUser() + PARTICIPANT_USER));
            participantPredicate.addCondition((Condition)condition);
            try {
                Map rolesByApp = VerificationService.getAppRoleNamesMap((IWorkflowContext)bpmContext);
                if (rolesByApp != null) {
                    for (Map.Entry appRoles : rolesByApp.entrySet()) {
                        if (appRoles.getKey() != null && !((String)appRoles.getKey()).isEmpty() && (appRoles.getKey() == null || !((String)appRoles.getKey()).equalsIgnoreCase(DEFAULT_APPLICATION))) continue;
                        for (String role : (Set)appRoles.getValue()) {
                            if (ProcessDashboardUtils.isDashboardViewer(role)) {
                                return widget;
                            }
                            condition = ConditionImpl.create();
                            condition.setVariable("participant");
                            condition.setOperator(Operator.EQUALS);
                            condition.setValue((Object)(role + PARTICIPANT_APPLICATION_ROLE));
                            participantPredicate.addCondition((Condition)condition);
                            int indexOf = role.indexOf(".");
                            if (indexOf <= 0) continue;
                            String project = role.substring(0, indexOf);
                            String roleName = role.substring(indexOf + 1);
                            if (roleName == null || !roleName.equalsIgnoreCase("ProcessOwner")) continue;
                            condition = ConditionImpl.create();
                            condition.setVariable("project");
                            condition.setOperator(Operator.EQUALS);
                            condition.setValue((Object)project);
                            participantPredicate.addCondition((Condition)condition);
                        }
                    }
                }
            }
            catch (WorkflowException initCause) {
                throw new BPMException((Exception)((Object)initCause));
            }
            for (Series series : widget.getData().getSeries()) {
                if (series.getDataSource() == DataSource.CUBE_PROCESS_PERFORMANCE) continue;
                PredicateImpl predicate = PredicateImpl.create();
                if (series.hasPredicate()) {
                    predicate.setLeftCondition(series.getPredicate());
                    predicate.setJoinOperator(JoinOperator.AND);
                    predicate.setRightCondition((Predicate)participantPredicate);
                } else {
                    predicate = participantPredicate;
                }
                series.setPredicate((Predicate)predicate);
            }
        }
        return widget;
    }

    private static Series cloneSeries(@NotNull Series series) {
        SeriesType seriesType = ((SeriesImpl)series).getSeriesType();
        SeriesType _seriesType = widgetFactory.createSeriesType();
        if (seriesType.isSetTitles()) {
            _seriesType.getTitles().addAll(seriesType.getTitles());
        }
        if (seriesType.isSetDataSource()) {
            _seriesType.setDataSource(seriesType.getDataSource());
        }
        if (seriesType.isSetProcess()) {
            _seriesType.setProcess(seriesType.getProcess());
        }
        if (seriesType.isSetStandard()) {
            _seriesType.setStandard(seriesType.isStandard());
        }
        if (seriesType.isSetMeasurement()) {
            MeasurementType _measurement = widgetFactory.createMeasurementType();
            _measurement.setVariable(seriesType.getMeasurement().getVariable());
            _measurement.setAggregateFunction(seriesType.getMeasurement().getAggregateFunction());
            _measurement.setValueType(seriesType.getMeasurement().getValueType());
            _seriesType.setMeasurement(_measurement);
        }
        if (seriesType.isSetDimensions()) {
            DimensionsType _dimensionsType = widgetFactory.createDimensionsType();
            if (seriesType.getDimensions().isSetXSeries()) {
                _dimensionsType.setXSeries(seriesType.getDimensions().getXSeries());
            }
            if (seriesType.getDimensions().isSetXGroup()) {
                _dimensionsType.setXGroup(seriesType.getDimensions().getXGroup());
            }
            _seriesType.setDimensions(_dimensionsType);
        }
        if (seriesType.isSetPredicate()) {
            _seriesType.setPredicate(ProcessDashboardUtils.clonePredicate(seriesType.getPredicate()));
        }
        if (seriesType.isSetDrilldown()) {
            for (DrillDownType drillDownType : seriesType.getDrilldown()) {
                DrillDownType _drillDownType = widgetFactory.createDrillDownType();
                _drillDownType.setDimension(drillDownType.getDimension());
                _drillDownType.setOrder(drillDownType.getOrder());
                _seriesType.getDrilldown().add(_drillDownType);
            }
        }
        return SeriesImpl.create((SeriesType)_seriesType);
    }

    private static PredicateType clonePredicate(@NotNull PredicateType predicate) {
        PredicateType _predicate = widgetFactory.createPredicateType();
        if (predicate.isSetConditions()) {
            for (ConditionType condition : predicate.getConditions()) {
                ConditionType _condition = widgetFactory.createConditionType();
                _condition.setVariable(condition.getVariable());
                _condition.setOperator(condition.getOperator());
                _condition.setValue(condition.getValue());
                if (condition.isSetUseRange()) {
                    _condition.setUseRange(condition.isUseRange());
                }
                _predicate.getConditions().add(_condition);
            }
        }
        if (predicate.isSetLeftCondition()) {
            _predicate.setLeftCondition(ProcessDashboardUtils.clonePredicate(predicate.getLeftCondition()));
        }
        if (predicate.isSetJoinOperator()) {
            _predicate.setJoinOperator(predicate.getJoinOperator());
        }
        if (predicate.isSetRightCondition()) {
            _predicate.setRightCondition(ProcessDashboardUtils.clonePredicate(predicate.getRightCondition()));
        }
        return _predicate;
    }

    private static boolean isDashboardViewer(String roleName) {
        return "BPMDashboardViewer".equals(roleName);
    }
}

