/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.processdashboard.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.query.model.ClauseType;
import oracle.bpel.services.workflow.query.model.ColumnType;
import oracle.bpel.services.workflow.query.model.ObjectFactory;
import oracle.bpel.services.workflow.query.model.PredicateType;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.processdashboard.model.Condition;
import oracle.bpm.services.processdashboard.model.Data;
import oracle.bpm.services.processdashboard.model.JoinOperator;
import oracle.bpm.services.processdashboard.model.ModelFactory;
import oracle.bpm.services.processdashboard.model.Operator;
import oracle.bpm.services.processdashboard.model.Predicate;
import oracle.bpm.services.processdashboard.model.Series;
import oracle.bpm.services.processdashboard.model.Widget;
import org.jetbrains.annotations.NotNull;

public class PredicateDrillDownBuilder {
    private static Map<String, Column> instanceVarMapper = new TreeMap<String, Column>(String.CASE_INSENSITIVE_ORDER);

    public static oracle.bpel.services.workflow.repos.Predicate buildPredicateDrillDown(@NotNull Widget widget, @NotNull String dimension, @NotNull String value, @NotNull Map<String, Map<String, String>> processVariableMappings) throws BPMException {
        try {
            oracle.bpel.services.workflow.repos.Predicate mainPredicate;
            if ("activity".equalsIgnoreCase(dimension)) {
                Condition condition = ModelFactory.createCondition();
                condition.setVariable("activity");
                condition.setOperator(Operator.EQUALS);
                condition.setValue((Object)value);
                mainPredicate = PredicateDrillDownBuilder.getActivityPredicate(condition);
            } else {
                Column dimensionColumn = PredicateDrillDownBuilder.getDimensionColumn(processVariableMappings, dimension);
                mainPredicate = new oracle.bpel.services.workflow.repos.Predicate(dimensionColumn, 0, (Object)value);
            }
            Data data = widget.getData();
            if (data.hasSeries() && data.getSeries().size() > 0) {
                for (Series series : data.getSeries()) {
                    Map<String, String> variableMapping = new TreeMap<String, String>();
                    if (series.hasProcess()) {
                        oracle.bpel.services.workflow.repos.Predicate processPredicate = new oracle.bpel.services.workflow.repos.Predicate(IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN, 0, (Object)series.getProcess());
                        mainPredicate = PredicateDrillDownBuilder.constructPredicate(mainPredicate, 7, processPredicate);
                        variableMapping = processVariableMappings.get(series.getProcess());
                    }
                    if (series.hasPredicate() && series.getPredicate() != null) {
                        oracle.bpel.services.workflow.repos.Predicate seriesPredicate = PredicateDrillDownBuilder.getPredicate(series.getPredicate(), variableMapping);
                        mainPredicate = PredicateDrillDownBuilder.constructPredicate(mainPredicate, 7, seriesPredicate);
                    }
                    mainPredicate = PredicateDrillDownBuilder.constructPredicate(mainPredicate, 7, PredicateDrillDownBuilder.getStatePredicate(series));
                }
            }
            return mainPredicate;
        }
        catch (WorkflowException cause) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_DASHBOARD_SERVICE, (Severity)Severity.WARNING, (Throwable)cause);
            throw new BPMException(71403, (Object[])new String[]{cause.getLocalizedMessage()}, (Throwable)cause);
        }
    }

    public static oracle.bpel.services.workflow.repos.Predicate buildPredicateDrillDown(@NotNull List<String> componentInstances) throws BPMException {
        try {
            oracle.bpel.services.workflow.repos.Predicate componentInstancePredicate = null;
            for (String componentInstance : componentInstances) {
                if (componentInstancePredicate == null) {
                    componentInstancePredicate = new oracle.bpel.services.workflow.repos.Predicate(IColumnConstants.PROCESS_INSTANCEID_COLUMN, 0, (Object)componentInstance);
                    continue;
                }
                componentInstancePredicate.addClause(8, IColumnConstants.PROCESS_INSTANCEID_COLUMN, 0, (Object)componentInstance);
            }
            if (componentInstancePredicate == null) {
                componentInstancePredicate = new oracle.bpel.services.workflow.repos.Predicate(IColumnConstants.PROCESS_INSTANCEID_COLUMN, 21, (Object)"");
            }
            oracle.bpel.services.workflow.repos.Predicate statePredicate = new oracle.bpel.services.workflow.repos.Predicate(IColumnConstants.PROCESS_STATE_COLUMN, 0, (Object)"OPEN");
            statePredicate.addClause(8, IColumnConstants.PROCESS_STATE_COLUMN, 0, (Object)"COMPLETED");
            statePredicate.addClause(8, IColumnConstants.PROCESS_STATE_COLUMN, 0, (Object)"ABORTED");
            statePredicate.addClause(8, IColumnConstants.PROCESS_STATE_COLUMN, 0, (Object)"CANCELED");
            return new oracle.bpel.services.workflow.repos.Predicate(statePredicate, 7, componentInstancePredicate);
        }
        catch (WorkflowException cause) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_DASHBOARD_SERVICE, (Severity)Severity.WARNING, (Throwable)cause);
            throw new BPMException(71403, (Object[])new String[]{cause.getLocalizedMessage()}, (Throwable)cause);
        }
    }

    private static oracle.bpel.services.workflow.repos.Predicate getStatePredicate(Series series) throws WorkflowException {
        oracle.bpel.services.workflow.repos.Predicate statePredicate;
        switch (series.getDataSource()) {
            case CUBE_PROCESS_PERFORMANCE: 
            case CUBE_TASK_PERFORMANCE: {
                statePredicate = new oracle.bpel.services.workflow.repos.Predicate(IColumnConstants.PROCESS_STATE_COLUMN, 0, (Object)"COMPLETED");
                statePredicate.addClause(8, IColumnConstants.PROCESS_STATE_COLUMN, 0, (Object)"ABORTED");
                statePredicate.addClause(8, IColumnConstants.PROCESS_STATE_COLUMN, 0, (Object)"CANCELED");
                break;
            }
            default: {
                statePredicate = new oracle.bpel.services.workflow.repos.Predicate(IColumnConstants.PROCESS_STATE_COLUMN, 0, (Object)"OPEN");
            }
        }
        return statePredicate;
    }

    private static oracle.bpel.services.workflow.repos.Predicate getPredicate(Predicate seriesPredicate, Map<String, String> variableMapping) throws BPMException {
        try {
            PredicateType predicate;
            int joinOperator = PredicateDrillDownBuilder.getJoinOperator(seriesPredicate.getJoinOperator());
            String joinOperatorStr = oracle.bpel.services.workflow.repos.Predicate.getLogicalOperator((int)joinOperator);
            ObjectFactory objectFactory = new ObjectFactory();
            PredicateType leftPredicate = null;
            if (seriesPredicate.hasConditions()) {
                leftPredicate = objectFactory.createPredicateType();
                leftPredicate.setLogicalOperator(oracle.bpel.services.workflow.repos.Predicate.getLogicalOperator((int)joinOperator));
                ArrayList<PredicateType> intervalConditions = new ArrayList<PredicateType>();
                ArrayList<oracle.bpel.services.workflow.repos.Predicate> activityConditions = new ArrayList<oracle.bpel.services.workflow.repos.Predicate>();
                for (Condition condition : seriesPredicate.getConditions()) {
                    ClauseType clause;
                    Column column = PredicateDrillDownBuilder.getColumn(variableMapping, condition.getVariable());
                    ColumnType columnType = objectFactory.createColumnType();
                    columnType.setColumnName(column.getName());
                    columnType.setTableName(column.getTableName());
                    int operator = PredicateDrillDownBuilder.getOperator(condition.getOperator());
                    if (condition.getValue() == null) {
                        clause = objectFactory.createClauseType();
                        clause.setColumn(columnType);
                        if (operator == 0 || operator == 21) {
                            clause.setOperator(oracle.bpel.services.workflow.repos.Predicate.getOperator((int)21));
                        } else {
                            clause.setOperator(oracle.bpel.services.workflow.repos.Predicate.getOperator((int)22));
                        }
                        leftPredicate.getClause().add(clause);
                        continue;
                    }
                    if (condition.getValue() instanceof Interval) {
                        oracle.bpel.services.workflow.repos.Predicate intervalPredicate = PredicateDrillDownBuilder.getQueryIntervalPredicate(column, operator, (Interval)condition.getValue());
                        intervalConditions.add(intervalPredicate.getPredicateType());
                        continue;
                    }
                    if ("activity".equalsIgnoreCase(condition.getVariable())) {
                        oracle.bpel.services.workflow.repos.Predicate activityConditionPredicate = PredicateDrillDownBuilder.getActivityPredicate(condition);
                        if (activityConditionPredicate == null) continue;
                        activityConditions.add(activityConditionPredicate);
                        continue;
                    }
                    clause = objectFactory.createClauseType();
                    clause.setColumn(columnType);
                    clause.setOperator(oracle.bpel.services.workflow.repos.Predicate.getOperator((int)operator));
                    clause.setValue(condition.getValue().toString());
                    leftPredicate.getClause().add(clause);
                }
                if (!intervalConditions.isEmpty()) {
                    leftPredicate = PredicateDrillDownBuilder.buildIntervalsPredicate(leftPredicate, joinOperatorStr, intervalConditions);
                }
                if (!activityConditions.isEmpty()) {
                    leftPredicate = PredicateDrillDownBuilder.buildActivitiesPredicate(leftPredicate, joinOperatorStr, activityConditions);
                }
            }
            PredicateType rightPredicate = null;
            if (seriesPredicate.hasLeftCondition()) {
                oracle.bpel.services.workflow.repos.Predicate seriesLeftPredicate = PredicateDrillDownBuilder.getPredicate(seriesPredicate.getLeftCondition(), variableMapping);
                rightPredicate = seriesLeftPredicate.getPredicateType();
            }
            if (seriesPredicate.hasRightCondition()) {
                oracle.bpel.services.workflow.repos.Predicate seriesRightPredicate = PredicateDrillDownBuilder.getPredicate(seriesPredicate.getRightCondition(), variableMapping);
                if (rightPredicate == null) {
                    rightPredicate = seriesRightPredicate.getPredicateType();
                } else {
                    PredicateType newRightPredicateType = objectFactory.createPredicateType();
                    newRightPredicateType.setLhs(rightPredicate);
                    newRightPredicateType.setRhs(seriesRightPredicate.getPredicateType());
                    newRightPredicateType.setLogicalOperator(oracle.bpel.services.workflow.repos.Predicate.getLogicalOperator((int)joinOperator));
                    rightPredicate = newRightPredicateType;
                }
            }
            if (leftPredicate != null && rightPredicate == null) {
                predicate = leftPredicate;
            } else if (leftPredicate == null && rightPredicate != null) {
                predicate = rightPredicate;
            } else {
                predicate = objectFactory.createPredicateType();
                predicate.setLogicalOperator(oracle.bpel.services.workflow.repos.Predicate.getLogicalOperator((int)joinOperator));
                predicate.setLhs(leftPredicate);
                predicate.setRhs(rightPredicate);
            }
            return new oracle.bpel.services.workflow.repos.Predicate(predicate);
        }
        catch (WorkflowException cause) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_DASHBOARD_SERVICE, (Severity)Severity.WARNING, (Throwable)cause);
            throw new BPMException(71403, (Object[])new String[]{cause.getLocalizedMessage()}, (Throwable)cause);
        }
    }

    private static PredicateType buildIntervalsPredicate(PredicateType leftPredicate, String joinOperator, List<PredicateType> intervalConditions) {
        ObjectFactory objectFactory = new ObjectFactory();
        PredicateType intervalPredicate = null;
        for (PredicateType predicate : intervalConditions) {
            if (intervalPredicate == null) {
                intervalPredicate = predicate;
                continue;
            }
            PredicateType newIntervalPredicate = objectFactory.createPredicateType();
            newIntervalPredicate.setLogicalOperator(joinOperator);
            newIntervalPredicate.setLhs(intervalPredicate);
            newIntervalPredicate.setRhs(predicate);
            intervalPredicate = newIntervalPredicate;
        }
        if (intervalPredicate != null) {
            PredicateType newLeftPredicate = objectFactory.createPredicateType();
            newLeftPredicate.setLogicalOperator(joinOperator);
            newLeftPredicate.setLhs(leftPredicate);
            newLeftPredicate.setRhs(intervalPredicate);
            return newLeftPredicate;
        }
        return leftPredicate;
    }

    private static PredicateType buildActivitiesPredicate(PredicateType leftPredicate, String joinOperator, List<oracle.bpel.services.workflow.repos.Predicate> activityConditions) {
        ObjectFactory objectFactory = new ObjectFactory();
        PredicateType activitiesPredicate = null;
        for (oracle.bpel.services.workflow.repos.Predicate conditionPredicate : activityConditions) {
            if (activitiesPredicate == null) {
                activitiesPredicate = conditionPredicate.getPredicateType();
                continue;
            }
            PredicateType newProcessPredicate = objectFactory.createPredicateType();
            newProcessPredicate.setLogicalOperator(joinOperator);
            newProcessPredicate.setLhs(activitiesPredicate);
            newProcessPredicate.setRhs(conditionPredicate.getPredicateType());
            activitiesPredicate = newProcessPredicate;
        }
        if (activitiesPredicate != null) {
            PredicateType newLeftPredicate = objectFactory.createPredicateType();
            newLeftPredicate.setLogicalOperator(joinOperator);
            newLeftPredicate.setLhs(leftPredicate);
            newLeftPredicate.setRhs(activitiesPredicate);
            return newLeftPredicate;
        }
        return leftPredicate;
    }

    private static oracle.bpel.services.workflow.repos.Predicate getActivityPredicate(Condition condition) throws BPMException {
        String value = condition.getValue() == null ? null : condition.getValue().toString();
        oracle.bpel.services.workflow.repos.Predicate predicate = null;
        if (value != null) {
            int indexOf = value.lastIndexOf("/");
            String activity = indexOf > 0 ? value.substring(indexOf + 1) : value;
            String process = indexOf > 0 ? value.substring(0, indexOf) : null;
            int operator = PredicateDrillDownBuilder.getOperator(condition.getOperator());
            try {
                predicate = new oracle.bpel.services.workflow.repos.Predicate(IColumnConstants.PROCESS_ACTIVITYID_COLUMN, operator, (Object)activity);
                if (process != null) {
                    predicate.addClause(7, IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN, 0, (Object)process);
                }
            }
            catch (WorkflowException cause) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_DASHBOARD_SERVICE, (Severity)Severity.WARNING, (Throwable)cause);
                throw new BPMException((Exception)((Object)cause));
            }
        }
        return predicate;
    }

    private static Column getDimensionColumn(Map<String, Map<String, String>> processVariableMappings, String dimension) throws BPMException {
        Column column = null;
        if (dimension != null && (column = instanceVarMapper.get(dimension)) == null) {
            for (Map<String, String> variableMappings : processVariableMappings.values()) {
                String flexField = variableMappings.get(dimension);
                if (flexField != null) {
                    column = instanceVarMapper.get(flexField);
                }
                if (column == null) continue;
                break;
            }
        }
        if (column != null) {
            return column;
        }
        throw new BPMException(71403, (Object[])new String[]{"Variable '" + dimension + "' not exist."}, null);
    }

    private static Column getColumn(Map<String, String> variableMappings, String variable) throws BPMException {
        String columnName;
        Column column = instanceVarMapper.get(variable);
        if (column == null && variableMappings != null && (columnName = variableMappings.get(variable)) != null) {
            column = instanceVarMapper.get(columnName);
        }
        if (column != null) {
            return column;
        }
        throw new BPMException(71403, (Object[])new String[]{"Variable '" + variable + "' not exist."}, null);
    }

    private static int getOperator(Operator operator) {
        if (operator == null) {
            return 0;
        }
        switch (operator) {
            case AFTER: {
                return 2;
            }
            case BEFORE: {
                return 4;
            }
            case BEGIN_WITH: {
                return 14;
            }
            case CONTAINS: {
                return 12;
            }
            case END_WITH: {
                return 16;
            }
            case EQUALS: {
                return 0;
            }
            case GRATER_OR_EQUALS: {
                return 3;
            }
            case GRATER_THAN: {
                return 2;
            }
            case IN: {
                return 9;
            }
            case LESS_OR_EQUALS: {
                return 5;
            }
            case LESS_THAN: {
                return 4;
            }
            case NOT_BEGIN_WITH: {
                return 15;
            }
            case NOT_CONTAINS: {
                return 13;
            }
            case NOT_END_WITH: {
                return 17;
            }
            case NOT_EQUALS: {
                return 1;
            }
        }
        return 0;
    }

    private static int getJoinOperator(JoinOperator joinOperator) {
        if (joinOperator == null) {
            return 7;
        }
        switch (joinOperator) {
            case OR: {
                return 8;
            }
        }
        return 7;
    }

    private static oracle.bpel.services.workflow.repos.Predicate getQueryIntervalPredicate(@NotNull Column column, int comparison, @NotNull Interval interval) throws BPMException {
        Time now = Time.now();
        Date from = now.sub(interval).dateValue();
        Date to = now.add(interval).dateValue();
        try {
            switch (comparison) {
                case 4: {
                    return new oracle.bpel.services.workflow.repos.Predicate(column, 4, (Object)from);
                }
                case 2: {
                    return new oracle.bpel.services.workflow.repos.Predicate(column, 2, (Object)to);
                }
                case 5: {
                    return new oracle.bpel.services.workflow.repos.Predicate(column, 5, (Object)to);
                }
                case 3: {
                    return new oracle.bpel.services.workflow.repos.Predicate(column, 3, (Object)to);
                }
                case 1: {
                    return new oracle.bpel.services.workflow.repos.Predicate(new oracle.bpel.services.workflow.repos.Predicate(column, 4, (Object)from), 8, new oracle.bpel.services.workflow.repos.Predicate(column, 2, (Object)to));
                }
            }
            return new oracle.bpel.services.workflow.repos.Predicate(new oracle.bpel.services.workflow.repos.Predicate(column, 3, (Object)from), 7, new oracle.bpel.services.workflow.repos.Predicate(column, 5, (Object)to));
        }
        catch (WorkflowException initCause) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_PROCESS_DASHBOARD_SERVICE, (Severity)Severity.WARNING, (Throwable)initCause);
            throw new BPMException((Exception)((Object)initCause));
        }
    }

    private static oracle.bpel.services.workflow.repos.Predicate constructPredicate(oracle.bpel.services.workflow.repos.Predicate leftPredicate, int joinOperator, oracle.bpel.services.workflow.repos.Predicate rightPredicate) throws WorkflowException {
        if (leftPredicate == null) {
            return rightPredicate;
        }
        if (rightPredicate == null) {
            return leftPredicate;
        }
        return new oracle.bpel.services.workflow.repos.Predicate(leftPredicate, joinOperator, rightPredicate);
    }

    static {
        instanceVarMapper.put("project", IColumnConstants.PROCESS_COMPOSITENAME_COLUMN);
        instanceVarMapper.put("revision", IColumnConstants.PROCESS_COMPOSITEVERSION_COLUMN);
        instanceVarMapper.put("process", IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN);
        instanceVarMapper.put("activity", IColumnConstants.PROCESS_ACTIVITYID_COLUMN);
        instanceVarMapper.put("role", IColumnConstants.PROCESS_ASSIGNEES_COLUMN);
        instanceVarMapper.put("participant", IColumnConstants.PROCESS_ASSIGNEES_COLUMN);
        instanceVarMapper.put("activityType", IColumnConstants.PROCESS_ACTIVITYTYPE_COLUMN);
        instanceVarMapper.put("textAttribute1", IColumnConstants.PROCESS_TEXTATTRIBUTE1_COLUMN);
        instanceVarMapper.put("textAttribute2", IColumnConstants.PROCESS_TEXTATTRIBUTE2_COLUMN);
        instanceVarMapper.put("textAttribute3", IColumnConstants.PROCESS_TEXTATTRIBUTE3_COLUMN);
        instanceVarMapper.put("textAttribute4", IColumnConstants.PROCESS_TEXTATTRIBUTE4_COLUMN);
        instanceVarMapper.put("textAttribute5", IColumnConstants.PROCESS_TEXTATTRIBUTE5_COLUMN);
        instanceVarMapper.put("textAttribute6", IColumnConstants.PROCESS_TEXTATTRIBUTE6_COLUMN);
        instanceVarMapper.put("textAttribute7", IColumnConstants.PROCESS_TEXTATTRIBUTE7_COLUMN);
        instanceVarMapper.put("textAttribute8", IColumnConstants.PROCESS_TEXTATTRIBUTE8_COLUMN);
        instanceVarMapper.put("textAttribute9", IColumnConstants.PROCESS_TEXTATTRIBUTE1_COLUMN);
        instanceVarMapper.put("textAttribute10", IColumnConstants.PROCESS_TEXTATTRIBUTE10_COLUMN);
        instanceVarMapper.put("textAttribute11", IColumnConstants.PROCESS_TEXTATTRIBUTE11_COLUMN);
        instanceVarMapper.put("textAttribute12", IColumnConstants.PROCESS_TEXTATTRIBUTE12_COLUMN);
        instanceVarMapper.put("textAttribute13", IColumnConstants.PROCESS_TEXTATTRIBUTE13_COLUMN);
        instanceVarMapper.put("textAttribute14", IColumnConstants.PROCESS_TEXTATTRIBUTE14_COLUMN);
        instanceVarMapper.put("textAttribute15", IColumnConstants.PROCESS_TEXTATTRIBUTE15_COLUMN);
        instanceVarMapper.put("textAttribute16", IColumnConstants.PROCESS_TEXTATTRIBUTE16_COLUMN);
        instanceVarMapper.put("textAttribute17", IColumnConstants.PROCESS_TEXTATTRIBUTE17_COLUMN);
        instanceVarMapper.put("textAttribute18", IColumnConstants.PROCESS_TEXTATTRIBUTE18_COLUMN);
        instanceVarMapper.put("textAttribute19", IColumnConstants.PROCESS_TEXTATTRIBUTE19_COLUMN);
        instanceVarMapper.put("textAttribute20", IColumnConstants.PROCESS_TEXTATTRIBUTE20_COLUMN);
        instanceVarMapper.put("protectedTextAttribute1", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE1_COLUMN);
        instanceVarMapper.put("protectedTextAttribute2", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE2_COLUMN);
        instanceVarMapper.put("protectedTextAttribute3", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE3_COLUMN);
        instanceVarMapper.put("protectedTextAttribute4", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE4_COLUMN);
        instanceVarMapper.put("protectedTextAttribute5", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE5_COLUMN);
        instanceVarMapper.put("protectedTextAttribute6", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE6_COLUMN);
        instanceVarMapper.put("protectedTextAttribute7", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE7_COLUMN);
        instanceVarMapper.put("protectedTextAttribute8", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE8_COLUMN);
        instanceVarMapper.put("protectedTextAttribute9", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE9_COLUMN);
        instanceVarMapper.put("protectedTextAttribute10", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE10_COLUMN);
        instanceVarMapper.put("protectedTextAttribute11", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE11_COLUMN);
        instanceVarMapper.put("protectedTextAttribute12", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE12_COLUMN);
        instanceVarMapper.put("protectedTextAttribute13", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE13_COLUMN);
        instanceVarMapper.put("protectedTextAttribute14", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE14_COLUMN);
        instanceVarMapper.put("protectedTextAttribute15", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE15_COLUMN);
        instanceVarMapper.put("protectedTextAttribute16", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE16_COLUMN);
        instanceVarMapper.put("protectedTextAttribute17", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE17_COLUMN);
        instanceVarMapper.put("protectedTextAttribute18", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE18_COLUMN);
        instanceVarMapper.put("protectedTextAttribute19", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE19_COLUMN);
        instanceVarMapper.put("protectedTextAttribute20", IColumnConstants.PROCESS_PROTECTEDTEXTATTRIBUTE20_COLUMN);
        instanceVarMapper.put("numberAttribute1", IColumnConstants.PROCESS_NUMBERATTRIBUTE1_COLUMN);
        instanceVarMapper.put("numberAttribute2", IColumnConstants.PROCESS_NUMBERATTRIBUTE2_COLUMN);
        instanceVarMapper.put("numberAttribute3", IColumnConstants.PROCESS_NUMBERATTRIBUTE3_COLUMN);
        instanceVarMapper.put("numberAttribute4", IColumnConstants.PROCESS_NUMBERATTRIBUTE4_COLUMN);
        instanceVarMapper.put("numberAttribute5", IColumnConstants.PROCESS_NUMBERATTRIBUTE5_COLUMN);
        instanceVarMapper.put("numberAttribute6", IColumnConstants.PROCESS_NUMBERATTRIBUTE6_COLUMN);
        instanceVarMapper.put("numberAttribute7", IColumnConstants.PROCESS_NUMBERATTRIBUTE7_COLUMN);
        instanceVarMapper.put("numberAttribute8", IColumnConstants.PROCESS_NUMBERATTRIBUTE8_COLUMN);
        instanceVarMapper.put("numberAttribute9", IColumnConstants.PROCESS_NUMBERATTRIBUTE9_COLUMN);
        instanceVarMapper.put("numberAttribute10", IColumnConstants.PROCESS_NUMBERATTRIBUTE10_COLUMN);
        instanceVarMapper.put("protectedNumberAttribute1", IColumnConstants.PROCESS_PROTECTEDNUMBERATTRIBUTE1_COLUMN);
        instanceVarMapper.put("protectedNumberAttribute2", IColumnConstants.PROCESS_PROTECTEDNUMBERATTRIBUTE2_COLUMN);
        instanceVarMapper.put("protectedNumberAttribute3", IColumnConstants.PROCESS_PROTECTEDNUMBERATTRIBUTE3_COLUMN);
        instanceVarMapper.put("protectedNumberAttribute4", IColumnConstants.PROCESS_PROTECTEDNUMBERATTRIBUTE4_COLUMN);
        instanceVarMapper.put("protectedNumberAttribute5", IColumnConstants.PROCESS_PROTECTEDNUMBERATTRIBUTE5_COLUMN);
        instanceVarMapper.put("protectedNumberAttribute6", IColumnConstants.PROCESS_PROTECTEDNUMBERATTRIBUTE6_COLUMN);
        instanceVarMapper.put("protectedNumberAttribute7", IColumnConstants.PROCESS_PROTECTEDNUMBERATTRIBUTE7_COLUMN);
        instanceVarMapper.put("protectedNumberAttribute8", IColumnConstants.PROCESS_PROTECTEDNUMBERATTRIBUTE8_COLUMN);
        instanceVarMapper.put("protectedNumberAttribute9", IColumnConstants.PROCESS_PROTECTEDNUMBERATTRIBUTE9_COLUMN);
        instanceVarMapper.put("protectedNumberAttribute10", IColumnConstants.PROCESS_PROTECTEDNUMBERATTRIBUTE10_COLUMN);
        instanceVarMapper.put("dateAttribute1", IColumnConstants.PROCESS_DATEATTRIBUTE1_COLUMN);
        instanceVarMapper.put("dateAttribute2", IColumnConstants.PROCESS_DATEATTRIBUTE2_COLUMN);
        instanceVarMapper.put("dateAttribute3", IColumnConstants.PROCESS_DATEATTRIBUTE3_COLUMN);
        instanceVarMapper.put("dateAttribute4", IColumnConstants.PROCESS_DATEATTRIBUTE4_COLUMN);
        instanceVarMapper.put("dateAttribute5", IColumnConstants.PROCESS_DATEATTRIBUTE5_COLUMN);
        instanceVarMapper.put("dateAttribute6", IColumnConstants.PROCESS_DATEATTRIBUTE6_COLUMN);
        instanceVarMapper.put("dateAttribute7", IColumnConstants.PROCESS_DATEATTRIBUTE7_COLUMN);
        instanceVarMapper.put("dateAttribute8", IColumnConstants.PROCESS_DATEATTRIBUTE8_COLUMN);
        instanceVarMapper.put("dateAttribute9", IColumnConstants.PROCESS_DATEATTRIBUTE9_COLUMN);
        instanceVarMapper.put("dateAttribute10", IColumnConstants.PROCESS_DATEATTRIBUTE10_COLUMN);
        instanceVarMapper.put("protectedDateAttribute1", IColumnConstants.PROCESS_PROTECTEDDATEATTRIBUTE1_COLUMN);
        instanceVarMapper.put("protectedDateAttribute2", IColumnConstants.PROCESS_PROTECTEDDATEATTRIBUTE2_COLUMN);
        instanceVarMapper.put("protectedDateAttribute3", IColumnConstants.PROCESS_PROTECTEDDATEATTRIBUTE3_COLUMN);
        instanceVarMapper.put("protectedDateAttribute4", IColumnConstants.PROCESS_PROTECTEDDATEATTRIBUTE4_COLUMN);
        instanceVarMapper.put("protectedDateAttribute5", IColumnConstants.PROCESS_PROTECTEDDATEATTRIBUTE5_COLUMN);
        instanceVarMapper.put("protectedDateAttribute6", IColumnConstants.PROCESS_PROTECTEDDATEATTRIBUTE6_COLUMN);
        instanceVarMapper.put("protectedDateAttribute7", IColumnConstants.PROCESS_PROTECTEDDATEATTRIBUTE7_COLUMN);
        instanceVarMapper.put("protectedDateAttribute8", IColumnConstants.PROCESS_PROTECTEDDATEATTRIBUTE8_COLUMN);
        instanceVarMapper.put("protectedDateAttribute9", IColumnConstants.PROCESS_PROTECTEDDATEATTRIBUTE9_COLUMN);
        instanceVarMapper.put("protectedDateAttribute10", IColumnConstants.PROCESS_PROTECTEDDATEATTRIBUTE10_COLUMN);
    }
}

