/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.pml.impl;

import java.net.URL;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.mds.MdsInstanceInitializer;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.exception.PmlSecurityExceptionFactory;
import oracle.bpm.pml.security.model.BasicSecuredProject;
import oracle.bpm.pml.security.model.PmlPrincipal;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.model.SecuredProject;
import oracle.bpm.pml.security.msg.PmlSecurityMsg;
import oracle.bpm.pml.security.service.PmlSecurityCoreService;
import oracle.bpm.pml.security.service.PmlSecurityService;
import oracle.bpm.pml.security.util.SecurityServiceFactory;
import oracle.bpm.pml.security.util.SecurityServiceHelper;
import oracle.bpm.pml.service.util.SecurityRoleMigration;
import oracle.bpm.pml.service.util.lookup.LookupServiceFactory;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.pml.ISecurityService;
import oracle.mds.core.MDSInstance;
import oracle.mds.exception.MDSException;
import oracle.tip.pc.services.common.Logger;
import oracle.tip.pc.services.identity.BPMIdentityService;
import org.jetbrains.annotations.NotNull;

public class SecurityService
implements ISecurityService {
    private IRuntimeConfigService runtimeConfigService;
    private SecurityServiceHelper serviceHelper;
    private IVerificationService verificationService;

    public void setRuntimeConfigService(IRuntimeConfigService runtimeConfigService) {
        this.runtimeConfigService = runtimeConfigService;
    }

    public IRuntimeConfigService getRuntimeConfigService() {
        return this.runtimeConfigService;
    }

    public IVerificationService getVerificationService() {
        return this.verificationService;
    }

    public void setVerificationService(IVerificationService verificationService) {
        this.verificationService = verificationService;
    }

    public void checkMigration(@NotNull IBPMContext bpmContext) throws PmlSecurityException {
        try {
            String serverURL = this.runtimeConfigService.getInternalServerURL();
            BPMIdentityService bpmIdentityService = LookupServiceFactory.getLookupService().lookupLocalIdentityService(serverURL);
            SecurityRoleMigration.migrate((MDSInstance)this.getMdsInstance(), (PmlSecurityCoreService)this.getServiceHelper(), (BPMIdentityService)bpmIdentityService);
        }
        catch (MetadataException e) {
            throw new PmlSecurityException(PmlSecurityMsg.MIGRATION_ERROR, (Throwable)e);
        }
        catch (WorkflowException e) {
            throw new PmlSecurityException(PmlSecurityMsg.MIGRATION_ERROR, (Throwable)e);
        }
    }

    public String getUserName(@NotNull IBPMContext bpmContext) throws PmlSecurityException {
        return this.getSecurityService(bpmContext).getUserName();
    }

    public PmlPrincipal getPrincipal(@NotNull IBPMContext bpmContext) throws PmlSecurityException {
        return this.getSecurityService(bpmContext).getPrincipal();
    }

    public void publishProject(@NotNull IBPMContext bpmContext, @NotNull String projectId) throws PmlSecurityException {
        this.getSecurityService(bpmContext).publishProject(projectId);
    }

    public void publishProject(@NotNull IBPMContext bpmContext, @NotNull String projectId, @NotNull ProjectRole role) throws PmlSecurityException {
        this.getSecurityService(bpmContext).publishProject(projectId, role);
    }

    public void deleteProject(@NotNull IBPMContext bpmContext, @NotNull String projectId) throws PmlSecurityException {
        this.getSecurityService(bpmContext).deleteProject(projectId);
    }

    public Map<String, SecuredProject> getSecuredProjects(@NotNull IBPMContext bpmContext) throws PmlSecurityException {
        return this.getSecurityService(bpmContext).getSecuredProjects();
    }

    public Map<String, BasicSecuredProject> getProjects(@NotNull IBPMContext bpmContext) throws PmlSecurityException {
        return this.getSecurityService(bpmContext).getProjects();
    }

    public void assertPrivilege(@NotNull IBPMContext bpmContext, @NotNull String projectId, @NotNull ProjectRole requiredRole) throws PmlSecurityException {
        this.getSecurityService(bpmContext).assertPrivilege(projectId, requiredRole);
    }

    public String getApplicationName(@NotNull IBPMContext context) throws PmlSecurityException {
        return this.getSecurityService(context).getApplicationName();
    }

    public PmlPrincipal getPmlPrincipal(@NotNull IBPMContext context, @NotNull String userName) throws PmlSecurityException {
        return this.getSecurityService(context).getPmlPrincipal(userName);
    }

    public void grantProjectRole(@NotNull IBPMContext context, @NotNull ProjectRole role, @NotNull String projectName, @NotNull Set<PmlPrincipal> principals) throws PmlSecurityException {
        this.getSecurityService(context).grantProjectRole(role, projectName, principals);
    }

    public void removeProject(@NotNull IBPMContext context, @NotNull String projectName) throws PmlSecurityException {
        this.getSecurityService(context).removeProject(projectName);
    }

    public void revokeProject(@NotNull IBPMContext context, @NotNull String projectName) throws PmlSecurityException {
        this.getSecurityService(context).revokeProject(projectName);
    }

    public void revokeProjectRoles(@NotNull IBPMContext context, @NotNull EnumSet<ProjectRole> projectRoles, @NotNull String projectName) throws PmlSecurityException {
        this.getSecurityService(context).revokeProjectRoles(projectRoles, projectName);
    }

    public Map<String, SecuredProject> getProjectsFor(@NotNull IBPMContext context, @NotNull PmlPrincipal principal) throws PmlSecurityException {
        return this.getSecurityService(context).getProjectsFor(principal);
    }

    public boolean isShared(@NotNull IBPMContext context, @NotNull String projectId) throws PmlSecurityException {
        return this.getSecurityService(context).isShared(projectId);
    }

    public void assertPrivilege(@NotNull IBPMContext context, @NotNull PmlPrincipal principal, @NotNull String projectId, @NotNull ProjectRole requiredRole) throws PmlSecurityException {
        this.getSecurityService(context).assertPrivilege(principal, projectId, requiredRole);
    }

    public ProjectRole getRoleFor(@NotNull IBPMContext context, @NotNull String project, @NotNull PmlPrincipal principal) throws PmlSecurityException {
        return this.getSecurityService(context).getRoleFor(project, principal);
    }

    public Map<ProjectRole, Set<String>> getProjectGrants(@NotNull IBPMContext context, @NotNull String project) throws PmlSecurityException {
        return this.getSecurityService(context).getProjectGrants(project);
    }

    public boolean isFirstAccess(@NotNull IBPMContext context) throws PmlSecurityException {
        return this.getSecurityService(context).isFirstAccess();
    }

    private void validateContext(@NotNull IBPMContext bpmContext) throws PmlSecurityException {
        try {
            this.getVerificationService().validateContext((IWorkflowContext)bpmContext);
        }
        catch (WorkflowException e) {
            throw PmlSecurityExceptionFactory.createSecurityException((Exception)((Object)e));
        }
    }

    private PmlSecurityService getSecurityService(@NotNull IBPMContext bpmContext) throws PmlSecurityException {
        this.validateContext(bpmContext);
        Logger.debugLog((String)("\nContext-user:" + bpmContext.getUser()));
        Logger.debugLog((String)("Context-token:" + bpmContext.getToken()));
        PmlSecurityService pmlSecurityService = SecurityServiceFactory.createPmlSecurityService((SecurityServiceHelper)this.getServiceHelper(), (String)bpmContext.getUser());
        Logger.debugLog((String)("PmlSecurityService-user:" + pmlSecurityService.getUserName()));
        Logger.debugLog((String)("PmlSecurityService-instance:" + pmlSecurityService.hashCode()));
        return pmlSecurityService;
    }

    private SecurityServiceHelper getServiceHelper() throws PmlSecurityException {
        if (this.serviceHelper == null) {
            try {
                String serverURL = this.runtimeConfigService.getInternalServerURL();
                this.serviceHelper = SecurityServiceFactory.createSecurityHelper((String)serverURL, (String)ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP.value());
                Logger.debugLog((String)("SecurityServiceHelper-notcached-instance:" + this.serviceHelper.hashCode()));
            }
            catch (WorkflowException e) {
                throw PmlSecurityExceptionFactory.createServiceCreationException((WorkflowException)e);
            }
        } else {
            Logger.debugLog((String)("SecurityServiceHelper-cached-instance:" + this.serviceHelper.hashCode()));
        }
        return this.serviceHelper;
    }

    private MDSInstance getMdsInstance() throws PmlSecurityException {
        MDSInstance mdsInstance;
        ClassLoader loader = this.getClass().getClassLoader();
        URL mdsConfig = loader.getResource("/oracle/bpm/services/pml/impl/mds-config_wls.xml");
        try {
            mdsInstance = MdsInstanceInitializer.getMDSInstance((String)MdsInstanceInitializer.OBPM_MDS, (URL)mdsConfig);
        }
        catch (MDSException e) {
            throw new PmlSecurityException(PmlSecurityMsg.MIGRATION_ERROR, (Throwable)e);
        }
        return mdsInstance;
    }
}

