/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.pml.impl;

import com.collaxa.cube.engine.data.PersistenceLogger;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.was.WebSphere_7_Platform;
import org.eclipse.persistence.platform.server.wls.WebLogic_10_Platform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;

public class PmlSessionCustomizer
implements SessionCustomizer {
    public void customize(Session session) {
        try {
            DatabaseSession dbSession = (DatabaseSession)session;
            ServerPlatformSupport jrfServerPlatform = ServerPlatformSupportFactory.getInstance();
            if (jrfServerPlatform != null) {
                WebLogic_10_Platform serverPlatform = null;
                if (jrfServerPlatform.isWebLogic()) {
                    serverPlatform = new WebLogic_10_Platform(dbSession);
                    PersistenceLogger.LOG.info("ServerPlatform is Weblogic");
                } else if (jrfServerPlatform.isWebSphere()) {
                    serverPlatform = new WebSphere_7_Platform(dbSession);
                    PersistenceLogger.LOG.info("ServerPlatform is Websphere");
                }
                dbSession.setServerPlatform((ServerPlatform)serverPlatform);
            }
        }
        catch (PortabilityLayerException ple) {
            PersistenceLogger.LOG.warn((Object)"BpelSessionCustomizer", (Throwable)ple);
        }
    }
}

