/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.pml.impl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.bpm.log.Log;
import oracle.bpm.pml.security.exception.PmlSecurityException;
import oracle.bpm.pml.security.exception.PmlSecurityExceptionFactory;
import oracle.bpm.pml.security.model.PmlPrincipal;
import oracle.bpm.pml.security.model.ProjectAction;
import oracle.bpm.pml.security.model.ProjectRole;
import oracle.bpm.pml.security.util.OpssCoreHelper;
import oracle.security.jps.JpsException;
import oracle.security.jps.ResourcePermission;
import oracle.security.jps.search.SearchQuery;
import oracle.security.jps.service.policystore.ApplicationPolicy;
import oracle.security.jps.service.policystore.PolicyObjectAlreadyExistsException;
import oracle.security.jps.service.policystore.PolicyObjectNotFoundException;
import oracle.security.jps.service.policystore.PolicyStore;
import oracle.security.jps.service.policystore.PolicyStoreException;
import oracle.security.jps.service.policystore.entitymanager.GrantManager;
import oracle.security.jps.service.policystore.entitymanager.PermissionSetManager;
import oracle.security.jps.service.policystore.entitymanager.ResourceManager;
import oracle.security.jps.service.policystore.entitymanager.ResourceTypeManager;
import oracle.security.jps.service.policystore.info.GrantEntry;
import oracle.security.jps.service.policystore.info.InfoFactory;
import oracle.security.jps.service.policystore.info.PermissionSetEntry;
import oracle.security.jps.service.policystore.info.PrincipalEntry;
import oracle.security.jps.service.policystore.info.resource.ResourceActionsEntry;
import oracle.security.jps.service.policystore.info.resource.ResourceEntry;
import oracle.security.jps.service.policystore.info.resource.ResourceTypeEntry;
import oracle.security.jps.service.policystore.search.ComparatorType;
import oracle.security.jps.service.policystore.search.GrantSearchQuery;
import oracle.security.jps.service.policystore.search.ResourceSearchQuery;
import org.jetbrains.annotations.NotNull;

public class OpssCoreHelperImpl
implements OpssCoreHelper {
    private ApplicationPolicy applicationPolicy;
    private boolean firstAccess;
    private ResourceTypeEntry resourceTypeEntry;
    private static final String BPM_RESOURCE_TYPE = "BpmProjectResourceType";

    public OpssCoreHelperImpl(final @NotNull PolicyStore policyStore, final @NotNull String applicationName) throws PmlSecurityException {
        try {
            this.applicationPolicy = AccessController.doPrivileged(new PrivilegedExceptionAction<ApplicationPolicy>(){

                @Override
                public ApplicationPolicy run() throws PolicyStoreException {
                    return policyStore.getApplicationPolicy(applicationName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            PolicyStoreException exception = (PolicyStoreException)e.getException();
            Log.logSevere((Throwable)exception);
            if (exception instanceof PolicyObjectNotFoundException) {
                throw PmlSecurityExceptionFactory.createObjectNotFoundException((String)applicationName, (PolicyStoreException)exception);
            }
            throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
        }
        this.init();
    }

    public void createResource(final @NotNull String resourceName) throws PmlSecurityException {
        block2: {
            final ResourceManager rManager = (ResourceManager)this.applicationPolicy.getEntityManager(ResourceManager.class);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public ResourceEntry run() throws PolicyStoreException {
                        rManager.createResource(resourceName, resourceName, "", OpssCoreHelperImpl.this.resourceTypeEntry, null);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                PolicyStoreException exception = (PolicyStoreException)e.getException();
                if (exception instanceof PolicyObjectAlreadyExistsException) break block2;
                throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
            }
        }
    }

    public void removeResource(final @NotNull String resourceName) throws PmlSecurityException {
        final ResourceManager rManager = (ResourceManager)this.applicationPolicy.getEntityManager(ResourceManager.class);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws PolicyStoreException {
                    rManager.deleteResource(OpssCoreHelperImpl.BPM_RESOURCE_TYPE, resourceName, false);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            PolicyStoreException exception = (PolicyStoreException)e.getException();
            Log.logSevere((Throwable)exception);
            if (exception instanceof PolicyObjectNotFoundException) {
                throw PmlSecurityExceptionFactory.createObjectNotFoundException((String)resourceName, (PolicyStoreException)exception);
            }
            throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
        }
    }

    public boolean existsResource(final @NotNull String resourceName) throws PmlSecurityException {
        ResourceEntry result;
        final ResourceManager rManager = (ResourceManager)this.applicationPolicy.getEntityManager(ResourceManager.class);
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<ResourceEntry>(){

                @Override
                public ResourceEntry run() throws PolicyStoreException {
                    return rManager.getResource(OpssCoreHelperImpl.BPM_RESOURCE_TYPE, resourceName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            PolicyStoreException exception = (PolicyStoreException)e.getException();
            if (exception instanceof PolicyObjectNotFoundException) {
                result = null;
            }
            throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
        }
        return result != null;
    }

    public Set<String> getAllResources() throws PmlSecurityException {
        List<ResourceEntry> resources;
        final ResourceManager rManager = (ResourceManager)this.applicationPolicy.getEntityManager(ResourceManager.class);
        try {
            resources = AccessController.doPrivileged(new PrivilegedExceptionAction<List<ResourceEntry>>(){

                @Override
                public List<ResourceEntry> run() throws PolicyStoreException {
                    return rManager.getResources(OpssCoreHelperImpl.BPM_RESOURCE_TYPE, new ResourceSearchQuery(ResourceSearchQuery.SEARCH_PROPERTY.ALL, false, ComparatorType.EQUALITY, null, SearchQuery.MATCHER.ANY));
                }
            });
        }
        catch (PrivilegedActionException e) {
            PolicyStoreException exception = (PolicyStoreException)e.getException();
            throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
        }
        HashSet<String> result = new HashSet<String>();
        for (ResourceEntry resource : resources) {
            result.add(resource.getName());
        }
        return result;
    }

    public void createPermissionSet(final @NotNull String permissionSetName, @NotNull Set<String> allowedActions, @NotNull String resourceName) throws PmlSecurityException {
        block4: {
            LinkedList<ResourceActionsEntry> resourceActions;
            try {
                ResourceActionsEntry actionsEntry = InfoFactory.newResourceActionsEntry((String)BPM_RESOURCE_TYPE, (String)resourceName, allowedActions, (String)this.applicationPolicy.getName());
                resourceActions = new LinkedList<ResourceActionsEntry>();
                resourceActions.add(actionsEntry);
            }
            catch (JpsException e) {
                throw PmlSecurityExceptionFactory.createSecurityException((JpsException)e);
            }
            final PermissionSetManager psManager = (PermissionSetManager)this.applicationPolicy.getEntityManager(PermissionSetManager.class);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public PermissionSetEntry run() throws PolicyStoreException {
                        psManager.createPermissionSet(permissionSetName, permissionSetName, "", resourceActions);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                PolicyStoreException exception = (PolicyStoreException)e.getException();
                if (exception instanceof PolicyObjectAlreadyExistsException) break block4;
                throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
            }
        }
    }

    public void grantResource(final @NotNull String permissionSetName, @NotNull Set<String> allowedActions, @NotNull String resourceName, final @NotNull Set<PrincipalEntry> principals) throws PmlSecurityException {
        block6: {
            if (!principals.isEmpty()) {
                boolean permissionFound;
                final GrantManager grantManager = (GrantManager)this.applicationPolicy.getEntityManager(GrantManager.class);
                final PermissionSetManager psManager = (PermissionSetManager)this.applicationPolicy.getEntityManager(PermissionSetManager.class);
                try {
                    permissionFound = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                        @Override
                        public Boolean run() throws PolicyStoreException {
                            try {
                                psManager.getPermissionSet(permissionSetName);
                                return true;
                            }
                            catch (PolicyObjectNotFoundException e) {
                                return false;
                            }
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    PolicyStoreException exception = (PolicyStoreException)e.getException();
                    throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
                }
                if (!permissionFound) {
                    this.createPermissionSet(permissionSetName, allowedActions, resourceName);
                }
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws PolicyStoreException {
                            grantManager.grant(principals, null, permissionSetName);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    PolicyStoreException exception = (PolicyStoreException)e.getException();
                    if (exception instanceof PolicyObjectAlreadyExistsException) break block6;
                    throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
                }
            }
        }
    }

    public Iterable<GrantEntry> getGrants(@NotNull String resourceId, @NotNull EnumSet<ProjectRole> roles) throws PmlSecurityException {
        try {
            final LinkedList<PermissionSetEntry> permissions = new LinkedList<PermissionSetEntry>();
            for (ProjectRole role : roles) {
                permissions.add(this.newPermissionSet(role, resourceId));
            }
            final GrantManager grantManager = (GrantManager)this.applicationPolicy.getEntityManager(GrantManager.class);
            final ArrayList<GrantEntry> grantEntryList = new ArrayList<GrantEntry>();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public ResourceEntry run() throws PolicyStoreException {
                    List grantsForPermissionSets = grantManager.getGrantsForPermissionSets(permissions, false);
                    grantEntryList.addAll(grantsForPermissionSets);
                    return null;
                }
            });
            return grantEntryList;
        }
        catch (PrivilegedActionException e) {
            PolicyStoreException exception = (PolicyStoreException)e.getException();
            throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
        }
    }

    public void revokePermissionSets(@NotNull String resourceId, @NotNull EnumSet<ProjectRole> roles) throws PmlSecurityException {
        final GrantManager gManager = (GrantManager)this.applicationPolicy.getEntityManager(GrantManager.class);
        final HashSet<String> permissionsToDelete = new HashSet<String>();
        Iterable<GrantEntry> grants = this.getGrants(resourceId, roles);
        for (GrantEntry grant : grants) {
            for (ProjectRole role : roles) {
                final String permissionSetName = role.getProjectPrefix(resourceId);
                List permissionEntries = grant.getPermissionEntries(permissionSetName);
                if (permissionEntries.isEmpty()) continue;
                final LinkedHashSet principalEntries = new LinkedHashSet(grant.getGranteeEntry().getPrincipalEntries());
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws PolicyStoreException {
                            gManager.revoke(principalEntries, null, permissionSetName);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    PolicyStoreException exception = (PolicyStoreException)e.getException();
                    throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
                }
                permissionsToDelete.add(permissionSetName);
            }
        }
        final PermissionSetManager psManager = (PermissionSetManager)this.applicationPolicy.getEntityManager(PermissionSetManager.class);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws PolicyStoreException {
                    for (String permissionName : permissionsToDelete) {
                        psManager.deletePermissionSet(permissionName, false);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            PolicyStoreException exception = (PolicyStoreException)e.getException();
            throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
        }
    }

    public Iterable<GrantEntry> getGrantsForPrincipal(@NotNull PmlPrincipal principal) throws PmlSecurityException {
        final LinkedList<GrantSearchQuery> searchQuery = new LinkedList<GrantSearchQuery>();
        GrantSearchQuery principalQuery = new GrantSearchQuery(GrantSearchQuery.SEARCH_PROPERTY.PRINCIPAL_NAME, false, ComparatorType.EQUALITY, principal.getName(), SearchQuery.MATCHER.EXACT);
        searchQuery.add(principalQuery);
        principalQuery = new GrantSearchQuery(GrantSearchQuery.SEARCH_PROPERTY.PRINCIPAL_NAME, false, ComparatorType.EQUALITY, PmlPrincipal.getPublicPrincipal((String)this.applicationPolicy.getName()).getName(), SearchQuery.MATCHER.EXACT);
        searchQuery.add(principalQuery);
        for (String group : principal.getGroups()) {
            principalQuery = new GrantSearchQuery(GrantSearchQuery.SEARCH_PROPERTY.PRINCIPAL_NAME, false, ComparatorType.EQUALITY, group, SearchQuery.MATCHER.EXACT);
            searchQuery.add(principalQuery);
        }
        final GrantManager grantManager = (GrantManager)this.applicationPolicy.getEntityManager(GrantManager.class);
        try {
            final ArrayList<GrantEntry> grantEntryList = new ArrayList<GrantEntry>();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public ResourceEntry run() throws PolicyStoreException {
                    List grants = grantManager.getGrants(new GrantSearchQuery(searchQuery, false, true));
                    grantEntryList.addAll(grants);
                    return null;
                }
            });
            return grantEntryList;
        }
        catch (PrivilegedActionException e) {
            PolicyStoreException exception = (PolicyStoreException)e.getException();
            throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
        }
    }

    public boolean isFirstAccess() {
        return this.firstAccess;
    }

    private void init() throws PmlSecurityException {
        if (this.resourceTypeEntry == null) {
            final ResourceTypeManager rtManager = (ResourceTypeManager)this.applicationPolicy.getEntityManager(ResourceTypeManager.class);
            try {
                this.resourceTypeEntry = AccessController.doPrivileged(new PrivilegedExceptionAction<ResourceTypeEntry>(){

                    @Override
                    public ResourceTypeEntry run() throws PolicyStoreException {
                        ResourceTypeEntry result;
                        try {
                            result = rtManager.getResourceType(OpssCoreHelperImpl.BPM_RESOURCE_TYPE);
                        }
                        catch (PolicyObjectNotFoundException e) {
                            OpssCoreHelperImpl.this.firstAccess = true;
                            result = rtManager.createResourceType(OpssCoreHelperImpl.BPM_RESOURCE_TYPE, OpssCoreHelperImpl.BPM_RESOURCE_TYPE, "", ProjectAction.toStringList(EnumSet.allOf(ProjectAction.class)), null, ",", ResourcePermission.class.getCanonicalName());
                        }
                        return result;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                PolicyStoreException exception = (PolicyStoreException)e.getException();
                throw PmlSecurityExceptionFactory.createSecurityException((PolicyStoreException)exception);
            }
        }
    }

    private PermissionSetEntry newPermissionSet(@NotNull ProjectRole role, @NotNull String project) {
        PermissionSetEntry result;
        try {
            ResourceActionsEntry actionsEntry = InfoFactory.newResourceActionsEntry((String)BPM_RESOURCE_TYPE, (String)project, (Set)ProjectAction.toStringSet((EnumSet)role.getAllowedActions()), (String)this.applicationPolicy.getName());
            HashSet<ResourceActionsEntry> resourceActions = new HashSet<ResourceActionsEntry>();
            resourceActions.add(actionsEntry);
            String permissionSetName = role.getProjectPrefix(project);
            result = InfoFactory.newPermissionSet((String)permissionSetName, (String)permissionSetName, (String)"", resourceActions);
        }
        catch (JpsException e) {
            result = null;
        }
        return result;
    }
}

