/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.permissions.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.query.impl.QueryUtil;
import oracle.bpel.services.workflow.repos.IPersistencyService;
import oracle.bpel.services.workflow.repos.PersistencyDriver;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.task.model.ActionType;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.ITaskActionPermission;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.TaskActionPermission;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpel.services.workflow.verification.impl.WorkflowContext;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.instancemanagement.model.IIdentityType;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.IProcessSystemAttributes;
import oracle.bpm.services.instancemanagement.model.impl.ProcessInstance;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.permissions.IPermissionsService;
import oracle.bpm.services.permissions.PermissionsConfigXMLFilesHolder;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMAuthorizationService;
import oracle.tip.pc.services.identity.BPMUser;
import org.w3c.dom.Element;

public class PermissionsService
implements IPermissionsService {
    private IVerificationService verificationService;
    private static PermissionsConfigXMLFilesHolder permissionsConfigFilesHolder = null;
    private static final String PROCESS_INSTANCE_STAKE_HOLDER = "INSTANCESTAKEHOLDER";

    public static boolean isProcessOwner(IBPMContext ctx, String compositeName) throws BPMException {
        boolean returnVal = false;
        try {
            BPMAuthorizationService identityService = ServiceFactory.getAuthorizationServiceInstance((String)ctx.getIdentityContext());
            String processOwnerAppRole = compositeName + "." + "ProcessOwner";
            String appContext = ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value();
            BPMUser userObj = VerificationService.lookupUser((IWorkflowContext)ctx);
            if (userObj.isInAppRole(processOwnerAppRole, appContext)) {
                returnVal = true;
            }
        }
        catch (Exception e) {
            throw new BPMException(70404, null, (Throwable)e);
        }
        return returnVal;
    }

    public static boolean isAdmin(IBPMContext context) throws BPMException {
        boolean returnVal = false;
        try {
            returnVal = VerificationService.isWFAdmin((IWorkflowContext)context);
        }
        catch (Exception e) {
            throw new BPMException(70404, null, (Throwable)e);
        }
        return returnVal;
    }

    public ITaskActionPermission canUserPerformProcessAction(IBPMContext ctx, IProcessInstance process, String action) throws BPMException {
        boolean actionPermitted = false;
        String deniedReason = null;
        List<String> actionList = this.getPermissibleProcessActions(ctx, process);
        if (actionList.contains(action)) {
            actionPermitted = true;
        }
        if (!actionPermitted) {
            deniedReason = (String)((WorkflowContext)ctx).getInternalInfo("responseInfo");
            ((WorkflowContext)ctx).setInternalInfo("responseInfo", null);
        }
        TaskActionPermission tp = new TaskActionPermission(actionPermitted, deniedReason);
        return tp;
    }

    public List<String> getPermissibleProcessActions(IBPMContext ctx, IProcessInstance process) throws BPMException {
        try {
            ArrayList<String> returnList = new ArrayList<String>();
            if (Boolean.getBoolean("soa.archiving.only")) {
                returnList.add("VIEW");
                returnList.add("VIEW_AUDIT_INFO");
                return returnList;
            }
            Task taskObj = ((ProcessInstance)process).getTask();
            List roles = this.getVerificationService().getRolesPlayedByUser((IWorkflowContext)ctx, taskObj);
            this.checkAndAddStakeHolderRole(ctx, taskObj, roles);
            this.checkAndAddProcessAssignee(ctx, process, roles);
            Set<String> roleBasedActions = this.getRoleBasedActions(roles);
            Set<String> stateBasedActions = this.getStateBasedActions(process.getSystemAttributes().getState());
            roleBasedActions.retainAll(stateBasedActions);
            returnList.addAll(roleBasedActions);
            return returnList;
        }
        catch (Exception e) {
            throw new BPMException(70404, null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermissibleProcessActions(IBPMContext ctx, IProcessInstance process) throws BPMException {
        try {
            IBPMContext iBPMContext = ctx;
            synchronized (iBPMContext) {
                List<String> actions = this.getPermissibleProcessActions(ctx, process);
                Task task = ((ProcessInstance)process).getTask();
                List systemActions = task.getSystemAttributes().getSystemActions();
                for (int i = 0; i < actions.size(); ++i) {
                    String tempAction = actions.get(i);
                    ActionType actionType = QueryUtil.getTaskObjectFactory().createActionType();
                    actionType.setAction(tempAction);
                    systemActions.add(actionType);
                }
            }
        }
        catch (BPMException bpmEx) {
            throw bpmEx;
        }
        catch (Exception e) {
            throw new BPMException(70404, null, (Throwable)e);
        }
    }

    public IVerificationService getVerificationService() {
        if (this.verificationService == null) {
            this.verificationService = new VerificationService();
        }
        return this.verificationService;
    }

    public void setVerificationService(IVerificationService newVerificationService) {
        this.verificationService = newVerificationService;
    }

    private static PermissionsConfigXMLFilesHolder getPermissionsConfigXMLFilesHolder() {
        if (permissionsConfigFilesHolder == null) {
            permissionsConfigFilesHolder = new PermissionsConfigXMLFilesHolder();
        }
        return permissionsConfigFilesHolder;
    }

    private List<String> getAppRoles(IBPMContext ctx) throws Exception {
        BPMUser user = VerificationService.lookupUser((IWorkflowContext)ctx);
        List roles = user.getAppRoles(false, ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value());
        ArrayList<String> roleNames = new ArrayList<String>(roles.size());
        for (BPMAppRole role : roles) {
            roleNames.add(role.getName());
        }
        return roleNames;
    }

    private void checkAndAddProcessAssignee(IBPMContext ctx, IProcessInstance process, List<String> roles) throws Exception {
        String user = ctx.getUser();
        IProcessSystemAttributes sysAttrs = process.getSystemAttributes();
        List assignees = sysAttrs.getAssignees();
        List<String> roleNames = null;
        for (int i = 0; i < assignees.size(); ++i) {
            IIdentityType assignee = (IIdentityType)assignees.get(i);
            String assigneeName = assignee.getId();
            if (user.equals(assigneeName)) {
                roles.add("ASSIGNEES");
                break;
            }
            if (roleNames == null) {
                roleNames = this.getAppRoles(ctx);
            }
            if (!roleNames.contains(assignee.getId())) continue;
            roles.add("ASSIGNEES");
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndAddStakeHolderRole(IBPMContext ctx, Task task, List<String> roles) throws Exception {
        block9: {
            IPersistencyService service = null;
            try {
                service = PersistencyDriver.getInstance();
                String instanceId = task.getProcessInfo().getInstanceId();
                Predicate predicate = new Predicate(IColumnConstants.PROCESSHISTORY_INSTANCEID_COLUMN, 0, (Object)instanceId);
                List updatedAssigneeHistory = service.getProcessInstanceStakeHolders((IWorkflowContext)ctx, predicate);
                boolean isStakeHolder = false;
                if (updatedAssigneeHistory == null || updatedAssigneeHistory.size() <= 0) break block9;
                String user = ctx.getUser();
                String identityContext = ctx.getIdentityContext();
                for (int i = 0; i < updatedAssigneeHistory.size(); ++i) {
                    Task t = (Task)updatedAssigneeHistory.get(i);
                    String stakeHolderName = null;
                    IdentityType updatedByType = t.getSystemAttributes().getUpdatedBy();
                    stakeHolderName = updatedByType != null ? updatedByType.getId() : t.getCreator();
                    if (stakeHolderName == null || !stakeHolderName.equals(user)) continue;
                    roles.add(PROCESS_INSTANCE_STAKE_HOLDER);
                    break;
                }
            }
            finally {
                try {
                    if (service != null) {
                        service.close();
                    }
                }
                catch (Exception exc) {}
            }
        }
    }

    private Set<String> getRoleBasedActions(List<String> roles) throws WorkflowException {
        Element root = PermissionsConfigXMLFilesHolder.getRoleBasedActionsDocumentRootElement();
        HashSet<String> returnSet = new HashSet<String>();
        for (String role : roles) {
            PermissionsService.getPermissionsConfigXMLFilesHolder();
            PermissionsConfigXMLFilesHolder.populateSet((Element)root, (String)role, null, returnSet);
        }
        return returnSet;
    }

    private Set<String> getStateBasedActions(String state) throws WorkflowException {
        Element root = PermissionsConfigXMLFilesHolder.getStateBasedActionsDocumentRootElement();
        HashSet<String> returnSet = new HashSet<String>();
        PermissionsService.getPermissionsConfigXMLFilesHolder();
        PermissionsConfigXMLFilesHolder.populateSet((Element)root, (String)state, null, returnSet);
        return returnSet;
    }
}

