/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.task.ITaskService;
import oracle.bpel.services.workflow.test.TestUtil;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.test.AbstractEndToEndOrganizationServiceTest;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.tip.pc.services.identity.BPMIdentityService;

public class RemoteEndToEndOrganizationServiceTest
extends AbstractEndToEndOrganizationServiceTest {
    public RemoteEndToEndOrganizationServiceTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RemoteEndToEndOrganizationServiceTest.class);
        return suite;
    }

    public BPMServiceClientFactory getBPMServiceClientFactory() {
        BPMServiceClientFactory bpmServiceClientFactory = BPMServiceClientFactory.getInstance(this.getProps(), null, null);
        return bpmServiceClientFactory;
    }

    public IBPMServiceClient getBPMServiceClient() {
        return this.getBPMServiceClientFactory().getBPMServiceClient();
    }

    public IWorkflowServiceClient getWorkflowServiceClient() {
        IWorkflowServiceClient client = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"REMOTE", this.getProps(), null);
        return client;
    }

    @Override
    public IBPMOrganizationService getBPMOrganizationService() {
        return this.getBPMServiceClient().getBPMOrganizationService();
    }

    @Override
    public IBPMUserAuthenticationService getBPMUserAuthenticationService() {
        return this.getBPMServiceClientFactory().getBPMUserAuthenticationService();
    }

    @Override
    public BPMIdentityService getBPMIdentityService() {
        return WorkflowServiceClientFactory.getSOAPIdentityServiceClient((String)"jazn.com", this.getProps(), null);
    }

    @Override
    public ITaskService getTaskService() {
        return this.getWorkflowServiceClient().getTaskService();
    }

    @Override
    public ITaskQueryService getTaskQueryService() {
        return this.getWorkflowServiceClient().getTaskQueryService();
    }

    @Override
    public IProcessMetadataService getProcessMetadataService() {
        return this.getBPMServiceClient().getProcessMetadataService();
    }

    private Map<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> getProps() {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.MODE, "dynamic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, TestUtil.getWFEJBURL());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_PRINCIPAL, TestUtil.getEJBUser());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_CREDENTIALS, TestUtil.getEJBCred());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.SOAP_END_POINT_ROOT, TestUtil.getWFWSSOAPEndPointRoot());
        return properties;
    }
}

