/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.task.impl.Duration;
import oracle.bpel.services.workflow.test.TestUtil;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.BPMOrganizationUtil;
import oracle.bpm.services.organization.impl.calendar.CalendarMgr;
import oracle.bpm.services.organization.impl.calendar.CalendarUtil;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.HolidayPatternEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayType;
import oracle.bpm.services.organization.model.MonthsEnum;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.WeekDaysEnum;
import oracle.bpm.services.organization.model.WorkPeriodType;
import oracle.bpm.services.organization.model.WorkdayListType;
import oracle.bpm.services.organization.model.WorkdayType;

public class CalendarMgrTest
extends TestCase {
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static Unmarshaller unMarshaller;
    private static CalendarMgr mCalMgr;
    private static final String DIR = "oracle/bpm/services/organization/test/data/";
    private static DatatypeFactory datatypeFactory;

    public CalendarMgrTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return TestUtil.getTestSuite(CalendarMgrTest.class);
    }

    public static void main(String[] str) {
        TestRunner.run((Test)CalendarMgrTest.suite());
    }

    public void testIsWorkingDay() throws Exception {
        CalendarMgrTest.print("---- testIsWorkingDay ----");
        Calendar dt = Calendar.getInstance();
        dt.set(2009, 2, 1);
        CalendarMgrTest.assertFalse((boolean)mCalMgr.isWorkDay(dt));
        dt.set(2009, 2, 4);
        CalendarMgrTest.assertTrue((boolean)mCalMgr.isWorkDay(dt));
        dt.set(2009, 2, 7);
        CalendarMgrTest.assertFalse((boolean)mCalMgr.isWorkDay(dt));
    }

    public void testIsHoliday() throws Exception {
        CalendarMgrTest.print("---- testIsHoliday ----");
        Calendar dt = Calendar.getInstance();
        dt.set(2009, 2, 7);
        CalendarMgrTest.assertFalse((boolean)mCalMgr.isHoliday(dt));
        dt.set(2009, 0, 1);
        CalendarMgrTest.assertTrue((boolean)mCalMgr.isHoliday(dt));
        dt.set(2020, 0, 1);
        CalendarMgrTest.assertTrue((boolean)mCalMgr.isHoliday(dt));
        dt.set(2009, 10, 3);
        CalendarMgrTest.assertTrue((boolean)mCalMgr.isHoliday(dt));
        dt.set(2020, 10, 3);
        CalendarMgrTest.assertFalse((boolean)mCalMgr.isHoliday(dt));
        dt.set(2009, 0, 19);
        CalendarMgrTest.assertTrue((boolean)mCalMgr.isHoliday(dt));
        dt.set(2010, 0, 19);
        CalendarMgrTest.assertFalse((boolean)mCalMgr.isHoliday(dt));
        dt.set(2009, 11, 24);
        CalendarMgrTest.assertTrue((boolean)mCalMgr.isHoliday(dt));
    }

    public void testWorkingDayDuration() throws Exception {
        CalendarMgrTest.print("---- testWorkingDayDuration ----");
        Calendar dt = Calendar.getInstance();
        dt.set(2009, 2, 6);
        long duration = mCalMgr.getWorkingDayDurationInMillis(dt);
        CalendarMgrTest.print("Duration expected : 32400000 ; actual : " + duration);
        CalendarMgrTest.assertTrue((duration == 32400000L ? 1 : 0) != 0);
    }

    public void testSameDayDuration() throws Exception {
        CalendarMgrTest.print("---- testSameDayDuration ----");
        Calendar fromDate = Calendar.getInstance(TimeZone.getTimeZone("PST"));
        Calendar toDate = Calendar.getInstance(TimeZone.getTimeZone("PST"));
        fromDate.set(2009, 2, 9, 8, 0, 0);
        toDate.set(2009, 2, 9, 17, 0, 0);
        long duration = mCalMgr.getCalendarDuration(fromDate, toDate);
        CalendarMgrTest.print("Duration expected : 32400000 ; actual : " + duration);
        CalendarMgrTest.assertTrue((CalendarMgrTest.compareUpToSec(duration, 32400000L) == 0 ? 1 : 0) != 0);
    }

    public void testWeekDayDuration() throws Exception {
        CalendarMgrTest.print("---- testWeekDayDuration ----");
        Calendar fromDate = Calendar.getInstance(TimeZone.getTimeZone("PST"));
        Calendar toDate = Calendar.getInstance(TimeZone.getTimeZone("PST"));
        long duration = 0L;
        fromDate.set(2009, 2, 9, 8, 0, 0);
        toDate.set(2009, 2, 13, 17, 0, 0);
        duration = mCalMgr.getCalendarDuration(fromDate, toDate);
        CalendarMgrTest.print("Duration expected : 162000000 ; actual : " + duration);
        CalendarMgrTest.assertTrue((CalendarMgrTest.compareUpToSec(duration, 162000000L) == 0 ? 1 : 0) != 0);
        fromDate.set(2009, 2, 9, 17, 0, 0);
        toDate.set(2009, 2, 13, 8, 0, 0);
        duration = mCalMgr.getCalendarDuration(fromDate, toDate);
        CalendarMgrTest.print("Duration expected : 97200000 ; actual : " + duration);
        CalendarMgrTest.assertTrue((CalendarMgrTest.compareUpToSec(duration, 97200000L) == 0 ? 1 : 0) != 0);
        fromDate.set(2009, 2, 9, 10, 30, 0);
        toDate.set(2009, 2, 13, 10, 30, 0);
        duration = mCalMgr.getCalendarDuration(fromDate, toDate);
        CalendarMgrTest.print("Duration expected : 129600000 ; actual : " + duration);
        CalendarMgrTest.assertTrue((CalendarMgrTest.compareUpToSec(duration, 129600000L) == 0 ? 1 : 0) != 0);
    }

    public void testWeekEndDuration() throws Exception {
        CalendarMgrTest.print("---- testWeekEndDuration ----");
        Calendar fromDate = Calendar.getInstance(TimeZone.getTimeZone("PST"));
        Calendar toDate = Calendar.getInstance(TimeZone.getTimeZone("PST"));
        long duration = 0L;
        fromDate.set(2009, 2, 6, 8, 0, 0);
        toDate.set(2009, 2, 13, 17, 0, 0);
        duration = mCalMgr.getCalendarDuration(fromDate, toDate);
        CalendarMgrTest.print("Duration expected : 194400000 ; actual : " + duration);
        CalendarMgrTest.assertTrue((CalendarMgrTest.compareUpToSec(duration, 194400000L) == 0 ? 1 : 0) != 0);
    }

    public void testHolidayDuration() throws Exception {
        CalendarMgrTest.print("---- testHolidayDuration ----");
        Calendar fromDate = Calendar.getInstance(TimeZone.getTimeZone("PST"));
        Calendar toDate = Calendar.getInstance(TimeZone.getTimeZone("PST"));
        long duration = 0L;
        fromDate.set(2009, 10, 23, 8, 0, 0);
        toDate.set(2009, 10, 27, 17, 0, 0);
        duration = mCalMgr.getCalendarDuration(fromDate, toDate);
        CalendarMgrTest.print("Duration expected : 129600000 ; actual : " + duration);
        CalendarMgrTest.assertTrue((CalendarMgrTest.compareUpToSec(duration, 129600000L) == 0 ? 1 : 0) != 0);
    }

    public void testHolidayDurationAndWeekend() throws Exception {
        CalendarMgrTest.print("---- testHolidayDurationAndWeekend ----");
        Calendar fromDate = Calendar.getInstance(TimeZone.getTimeZone("PST"));
        Calendar toDate = Calendar.getInstance(TimeZone.getTimeZone("PST"));
        long duration = 0L;
        fromDate.set(2009, 10, 23, 8, 0, 0);
        toDate.set(2009, 10, 30, 17, 0, 0);
        duration = mCalMgr.getCalendarDuration(fromDate, toDate);
        CalendarMgrTest.print("Duration expected : 162000000 ; actual : " + duration);
        CalendarMgrTest.assertTrue((CalendarMgrTest.compareUpToSec(duration, 162000000L) == 0 ? 1 : 0) != 0);
    }

    public void testAddDurationClosestWeekDayHoliday() throws Exception {
        CalendarMgrTest.print("---- testAddDurationClosestWeekDayHoliday ----");
        CalendarRule calRul = objectFactory.createCalendarRule();
        calRul.setName("TEST_CALENDAR");
        calRul.setId(Util.getGuid());
        calRul.setTimeZone("Asia/Calcutta");
        TimeZone tz = TimeZone.getTimeZone("Asia/Calcutta");
        WorkdayListType workList = objectFactory.createWorkdayListType();
        List wList = workList.getWorkday();
        wList.add(this.getWeekDay("Monday"));
        calRul.setWorkdayList(workList);
        calRul.setHolidayRuleName("TEST_HOLIDAY");
        String holidayRuleId = Util.getGuid();
        calRul.setHolidayRuleId(holidayRuleId);
        HolidayRule holRul = objectFactory.createHolidayRule();
        holRul.setName("TEST_HOLIDAY");
        holRul.setId(holidayRuleId);
        List holidayList = holRul.getHolidays();
        HolidayType holiday = objectFactory.createHolidayType();
        holiday.setName("Closest weekday holiday");
        holiday.setHolidayPattern(HolidayPatternEnum.CLOSEST_WEEK_DAY);
        Calendar cal = Calendar.getInstance(tz);
        cal.set(2009, 11, 20, 0, 0, 0);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList.add(holiday);
        CalendarMgr calMgr = null;
        Calendar fromDate = null;
        long duration = 0L;
        Calendar toDate = null;
        calMgr = new CalendarMgr(calRul, holRul);
        fromDate = Calendar.getInstance(tz);
        fromDate.set(2009, 11, 18, 0, 0, 0);
        fromDate.set(14, 0);
        duration = 172800000L;
        Duration tDur = new Duration(duration);
        toDate = calMgr.addCalendarDuration(fromDate, tDur.getJavaxXMLDatatypeDuration());
        System.out.println(toDate);
        CalendarMgrTest.assertTrue((toDate.get(2) == 0 && toDate.get(5) == 11 && toDate.get(1) == 2010 ? 1 : 0) != 0);
    }

    public void testAddDurationNthWeekDayHoliday() throws Exception {
        CalendarMgrTest.print("---- testAddDurationNthWeekDayHoliday ----");
        TimeZone tz = TimeZone.getTimeZone("Asia/Calcutta");
        CalendarRule calRul = objectFactory.createCalendarRule();
        calRul.setName("TEST_CALENDAR");
        calRul.setId(Util.getGuid());
        calRul.setTimeZone("Asia/Calcutta");
        WorkdayListType workList = objectFactory.createWorkdayListType();
        List wList = workList.getWorkday();
        wList.add(this.getWeekDay("Monday"));
        calRul.setWorkdayList(workList);
        calRul.setHolidayRuleName("TEST_HOLIDAY");
        String holidayRuleId = Util.getGuid();
        calRul.setHolidayRuleId(holidayRuleId);
        HolidayRule holRul = objectFactory.createHolidayRule();
        holRul.setName("TEST_HOLIDAY");
        holRul.setId(holidayRuleId);
        List holidayList = holRul.getHolidays();
        HolidayType holiday = objectFactory.createHolidayType();
        holiday.setName("Closest weekday holiday");
        holiday.setHolidayPattern(HolidayPatternEnum.CLOSEST_WEEK_DAY);
        Calendar cal = Calendar.getInstance(tz);
        cal.set(2009, 11, 20, 0, 0, 0);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList.add(holiday);
        CalendarMgr calMgr = null;
        Calendar fromDate = null;
        long duration = 0L;
        Calendar toDate = null;
        holRul = objectFactory.createHolidayRule();
        holRul.setName("TEST_HOLIDAY");
        holRul.setId(holidayRuleId);
        holidayList = holRul.getHolidays();
        holiday = objectFactory.createHolidayType();
        holiday.setName("Nth Week weekday holiday");
        holiday.setHolidayPattern(HolidayPatternEnum.NTH_WEEK_DAY_OF_MONTH);
        holiday.setNth(BigInteger.valueOf(-1L));
        holiday.setWeekDay(WeekDaysEnum.MONDAY);
        holiday.setMonth(MonthsEnum.DECEMBER);
        holidayList.add(holiday);
        calMgr = new CalendarMgr(calRul, holRul);
        fromDate = Calendar.getInstance(tz);
        fromDate.set(2009, 11, 18, 0, 0, 0);
        fromDate.set(14, 0);
        duration = 172800000L;
        Duration tDur = new Duration(duration);
        toDate = calMgr.addCalendarDuration(fromDate, tDur.getJavaxXMLDatatypeDuration());
        System.out.println(toDate);
        CalendarMgrTest.assertTrue((toDate.get(2) == 0 && toDate.get(5) == 11 && toDate.get(1) == 2010 ? 1 : 0) != 0);
    }

    public void testAddDurationShortWorkingDay() throws Exception {
        CalendarMgrTest.print("---- testAddDurationShortWorkingDay ----");
        CalendarRule calRul = objectFactory.createCalendarRule();
        calRul.setName("TEST_CALENDAR");
        calRul.setId(Util.getGuid());
        calRul.setTimeZone("Asia/Calcutta");
        TimeZone tz = TimeZone.getTimeZone("Asia/Calcutta");
        WorkdayListType workList = objectFactory.createWorkdayListType();
        List wList = workList.getWorkday();
        wList.add(this.getWeekDay("Monday"));
        calRul.setWorkdayList(workList);
        calRul.setHolidayRuleName("TEST_HOLIDAY");
        String holidayRuleId = Util.getGuid();
        calRul.setHolidayRuleId(holidayRuleId);
        HolidayRule holRul = objectFactory.createHolidayRule();
        holRul.setName("TEST_HOLIDAY");
        holRul.setId(holidayRuleId);
        List holidayList = holRul.getHolidays();
        HolidayType holiday = objectFactory.createHolidayType();
        holiday.setName("Closest weekday holiday");
        holiday.setHolidayPattern(HolidayPatternEnum.CLOSEST_WEEK_DAY);
        Calendar cal = Calendar.getInstance(tz);
        cal.set(2009, 11, 20, 0, 0, 0);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList.add(holiday);
        CalendarMgr calMgr = null;
        Calendar fromDate = null;
        long duration = 0L;
        Calendar toDate = null;
        holRul = objectFactory.createHolidayRule();
        holRul.setName("TEST_HOLIDAY");
        holRul.setId(holidayRuleId);
        holidayList = holRul.getHolidays();
        calMgr = new CalendarMgr(calRul, holRul);
        fromDate = Calendar.getInstance(tz);
        fromDate.set(2009, 11, 18, 0, 0, 0);
        fromDate.set(14, 0);
        duration = 102600000L;
        Duration tDur = new Duration(duration);
        toDate = calMgr.addCalendarDuration(fromDate, tDur.getJavaxXMLDatatypeDuration());
        System.out.println(toDate);
        CalendarMgrTest.assertTrue((toDate.get(2) == 0 && toDate.get(5) == 11 && toDate.get(1) == 2010 ? 1 : 0) != 0);
    }

    public void testAddDurationLongDuration() throws Exception {
        CalendarMgrTest.print("---- testAddDurationLongDuration ----");
        CalendarRule calRul = objectFactory.createCalendarRule();
        calRul.setName("TEST_CALENDAR");
        calRul.setId(Util.getGuid());
        calRul.setTimeZone("Asia/Calcutta");
        TimeZone tz = TimeZone.getTimeZone("Asia/Calcutta");
        WorkdayListType workList = objectFactory.createWorkdayListType();
        List wList = workList.getWorkday();
        wList.add(this.getWeekDay("Monday"));
        calRul.setWorkdayList(workList);
        calRul.setHolidayRuleName("TEST_HOLIDAY");
        String holidayRuleId = Util.getGuid();
        calRul.setHolidayRuleId(holidayRuleId);
        HolidayRule holRul = objectFactory.createHolidayRule();
        holRul.setName("TEST_HOLIDAY");
        holRul.setId(holidayRuleId);
        List holidayList = holRul.getHolidays();
        HolidayType holiday = objectFactory.createHolidayType();
        holiday.setName("Closest weekday holiday");
        holiday.setHolidayPattern(HolidayPatternEnum.CLOSEST_WEEK_DAY);
        Calendar cal = Calendar.getInstance(tz);
        cal.set(2009, 11, 20, 0, 0, 0);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList.add(holiday);
        CalendarMgr calMgr = null;
        Calendar fromDate = null;
        Calendar toDate = null;
        holRul = objectFactory.createHolidayRule();
        holRul.setName("TEST_HOLIDAY");
        holRul.setId(holidayRuleId);
        holidayList = holRul.getHolidays();
        calMgr = new CalendarMgr(calRul, holRul);
        fromDate = Calendar.getInstance(tz);
        fromDate.set(2009, 11, 18, 0, 0, 0);
        fromDate.set(14, 0);
        String durationStr = "P1Y1M1DT2H30M0S";
        Duration tDur = new Duration(durationStr);
        toDate = calMgr.addCalendarDuration(fromDate, tDur.getJavaxXMLDatatypeDuration());
        System.out.println(toDate);
        CalendarMgrTest.assertTrue((toDate.get(2) == 1 && toDate.get(5) == 7 && toDate.get(1) == 2011 ? 1 : 0) != 0);
    }

    public void testAddDurationWithHoliday() throws Exception {
        CalendarMgrTest.print("---- testAddDurationWithHoliday ----");
        CalendarRule calRul = objectFactory.createCalendarRule();
        calRul.setName("TEST_CALENDAR");
        calRul.setId(Util.getGuid());
        calRul.setTimeZone("America/Los_Angeles");
        TimeZone tz = TimeZone.getTimeZone("America/Los_Angeles");
        WorkdayListType workList = objectFactory.createWorkdayListType();
        List wList = workList.getWorkday();
        wList.add(this.getFullWeekDay("Monday", tz));
        wList.add(this.getFullWeekDay("Tuesday", tz));
        wList.add(this.getFullWeekDay("Wednesday", tz));
        wList.add(this.getFullWeekDay("Thursday", tz));
        wList.add(this.getFullWeekDay("Friday", tz));
        calRul.setWorkdayList(workList);
        CalendarMgr calMgr = null;
        Calendar fromDate = null;
        Calendar toDate = null;
        String holidayRuleId = Util.getGuid();
        HolidayRule holRul = objectFactory.createHolidayRule();
        holRul.setName("TEST_HOLIDAY");
        holRul.setId(holidayRuleId);
        List holidayList = holRul.getHolidays();
        HolidayType holiday = objectFactory.createHolidayType();
        holiday.setName("Next to Valentine Day Holiday");
        holiday.setHolidayPattern(HolidayPatternEnum.SAME_DAY_EVERY_YEAR);
        Calendar cal = Calendar.getInstance(tz);
        cal.set(2010, 1, 15, 0, 0, 0);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList.add(holiday);
        calMgr = new CalendarMgr(calRul, holRul);
        fromDate = Calendar.getInstance(tz);
        fromDate.set(2010, 1, 10, 11, 0, 0);
        fromDate.set(14, 0);
        String durationStr = "P5D";
        Duration tDur = new Duration(durationStr);
        toDate = calMgr.addCalendarDuration(fromDate, tDur.getJavaxXMLDatatypeDuration());
        System.out.println(toDate);
        CalendarMgrTest.assertTrue((toDate.get(2) == 1 && toDate.get(5) == 18 && toDate.get(1) == 2010 && toDate.get(11) == 11 && toDate.get(12) == 0 ? 1 : 0) != 0);
    }

    public void testAddDurationWithTime() throws Exception {
        CalendarMgrTest.print("---- testAddDurationWithTime ----");
        CalendarRule calRul = objectFactory.createCalendarRule();
        calRul.setName("TEST_CALENDAR");
        calRul.setId(Util.getGuid());
        calRul.setTimeZone("America/Los_Angeles");
        TimeZone tz = TimeZone.getTimeZone("America/Los_Angeles");
        WorkdayListType workList = objectFactory.createWorkdayListType();
        List wList = workList.getWorkday();
        wList.add(this.getFullWeekDay("Monday", tz));
        wList.add(this.getFullWeekDay("Tuesday", tz));
        wList.add(this.getFullWeekDay("Wednesday", tz));
        wList.add(this.getFullWeekDay("Thursday", tz));
        wList.add(this.getFullWeekDay("Friday", tz));
        calRul.setWorkdayList(workList);
        CalendarMgr calMgr = null;
        Calendar fromDate = null;
        Calendar toDate = null;
        HolidayRule holRul = null;
        calMgr = new CalendarMgr(calRul, holRul);
        fromDate = Calendar.getInstance(tz);
        fromDate.set(2010, 1, 3, 22, 32, 47);
        fromDate.set(14, 0);
        String durationStr = "P1DT2H";
        Duration tDur = new Duration(durationStr);
        toDate = calMgr.addCalendarDuration(fromDate, tDur.getJavaxXMLDatatypeDuration());
        System.out.println(toDate);
        CalendarMgrTest.assertTrue((toDate.get(2) == 1 && toDate.get(5) == 5 && toDate.get(1) == 2010 && toDate.get(11) == 11 && toDate.get(12) == 0 ? 1 : 0) != 0);
    }

    public void testAddDurationWith0Time() throws Exception {
        CalendarMgrTest.print("---- testAddDurationWith0Time ----");
        CalendarRule calRul = objectFactory.createCalendarRule();
        calRul.setName("TEST_CALENDAR");
        calRul.setId(Util.getGuid());
        calRul.setTimeZone("America/Los_Angeles");
        TimeZone tz = TimeZone.getTimeZone("America/Los_Angeles");
        WorkdayListType workList = objectFactory.createWorkdayListType();
        List wList = workList.getWorkday();
        wList.add(this.getFullWeekDay("Monday", tz));
        wList.add(this.getFullWeekDay("Tuesday", tz));
        wList.add(this.getFullWeekDay("Wednesday", tz));
        wList.add(this.getFullWeekDay("Thursday", tz));
        wList.add(this.getFullWeekDay("Friday", tz));
        calRul.setWorkdayList(workList);
        CalendarMgr calMgr = null;
        Calendar fromDate = null;
        Calendar toDate = null;
        HolidayRule holRul = null;
        calMgr = new CalendarMgr(calRul, holRul);
        fromDate = Calendar.getInstance(tz);
        fromDate.set(2010, 1, 7, 22, 4, 0);
        fromDate.set(14, 0);
        String durationStr = "P2D";
        Duration tDur = new Duration(durationStr);
        toDate = calMgr.addCalendarDuration(fromDate, tDur.getJavaxXMLDatatypeDuration());
        System.out.println(toDate);
        CalendarMgrTest.assertTrue((toDate.get(2) == 1 && toDate.get(5) == 10 && toDate.get(1) == 2010 && toDate.get(11) == 9 && toDate.get(12) == 0 ? 1 : 0) != 0);
    }

    public void testTimeZoneMapping() {
        String[] ids = TimeZone.getAvailableIDs();
        for (int i = 0; i < ids.length; ++i) {
            TimeZone tz = TimeZone.getTimeZone(ids[i]);
            String longTzName = CalendarUtil.getLongTimeZoneName(ids[i]);
            CalendarMgrTest.assertTrue((longTzName != null && !"".equals(longTzName) ? 1 : 0) != 0);
            TimeZone ltz = TimeZone.getTimeZone(longTzName);
            CalendarMgrTest.assertTrue((tz.getRawOffset() == ltz.getRawOffset() ? 1 : 0) != 0);
            CalendarMgrTest.assertTrue((tz.getDSTSavings() == ltz.getDSTSavings() ? 1 : 0) != 0);
            CalendarMgrTest.assertTrue((tz.useDaylightTime() == ltz.useDaylightTime() ? 1 : 0) != 0);
            CalendarMgrTest.assertTrue((boolean)tz.hasSameRules(ltz));
        }
    }

    public void testAddDurationSameDay() throws Exception {
    }

    public void testAddDurationWeekend() throws Exception {
        CalendarMgrTest.print("---- testAddDurationWeekend ----");
    }

    public void testSubtractDurationSameDay() throws Exception {
        CalendarMgrTest.print("---- testSubtractDurationSameDay ----");
    }

    public void testSubtractDurationWeekday() throws Exception {
        CalendarMgrTest.print("---- testSubtractDurationWeekday ----");
    }

    public void testSubtractDurationWeekend() throws Exception {
        CalendarMgrTest.print("---- testSubtractDurationWeekend ----");
    }

    public void testSubtractDurationHoliday() throws Exception {
        CalendarMgrTest.print("---- testSubtractDurationHoliday ----");
    }

    public void testSubtractDurationHolidayAndWeekend() throws Exception {
        CalendarMgrTest.print("---- testSubtractDurationHolidayAndWeekend ----");
    }

    public void testNextDurationFromAssignedDate() throws Exception {
        CalendarMgrTest.print("---- testNextDurationFromAssignedDate ----");
    }

    public void testNextDurationFromRelativeDate() throws Exception {
        CalendarMgrTest.print("---- testNextDurationFromRelativeDate ----");
    }

    private static CalendarRule getCalendarRule(String fileName) throws Exception {
        InputStream is = null;
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader classLoader = currentThread.getContextClassLoader();
            is = classLoader.getResourceAsStream(fileName);
            CalendarRule calendarRule = (CalendarRule)unMarshaller.unmarshal(is);
            return calendarRule;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private static HolidayRule getHolidayRule(String fileName) throws Exception {
        InputStream is = null;
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader classLoader = currentThread.getContextClassLoader();
            is = classLoader.getResourceAsStream(fileName);
            HolidayRule holidayRule = (HolidayRule)unMarshaller.unmarshal(is);
            return holidayRule;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private static int compareUpToSec(long duration1, long duration2) {
        long diff = duration1 - duration2;
        if (diff < 0L) {
            diff = -diff;
        }
        if (diff < 1000L) {
            return 0;
        }
        return (int)(duration1 - duration2);
    }

    private static void print(String msg) {
        System.out.println(msg);
    }

    private WorkdayType getFullWeekDay(String weekday, TimeZone tz) {
        Calendar cal1 = Calendar.getInstance(tz);
        cal1.set(0, 0, 0, 9, 0, 0);
        Calendar cal1end = Calendar.getInstance(tz);
        cal1end.set(0, 0, 0, 13, 0, 0);
        Calendar cal2 = Calendar.getInstance(tz);
        cal2.set(0, 0, 0, 14, 0, 0);
        Calendar cal2end = Calendar.getInstance(tz);
        cal2end.set(0, 0, 0, 18, 0, 0);
        return this.getCustomWeekday(weekday, cal1, cal1end, cal2, cal2end);
    }

    private WorkdayType getWeekDay(String weekday) {
        TimeZone tz = TimeZone.getTimeZone("Asia/Calcutta");
        Calendar cal = Calendar.getInstance(tz);
        cal.set(0, 0, 0, 10, 0, 0);
        Calendar calend = Calendar.getInstance(tz);
        calend.set(0, 0, 0, 12, 0, 0);
        return this.getCustomWeekday(weekday, cal, calend, null, null);
    }

    private WorkdayType getCustomWeekday(String weekday, Calendar cal1, Calendar cal1end, Calendar cal2, Calendar cal2end) {
        WorkdayType wDay = objectFactory.createWorkdayType();
        wDay.setWeekDay(WeekDaysEnum.fromValue((String)weekday));
        List wPrdList = wDay.getWorkPeriod();
        WorkPeriodType wPrd = null;
        if (cal1 != null && cal1end != null) {
            wPrd = objectFactory.createWorkPeriodType();
            wPrd.setStartTime(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal1));
            wPrd.setEndTime(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal1end));
            wPrdList.add(wPrd);
        }
        if (cal2 != null && cal2end != null) {
            wPrd = objectFactory.createWorkPeriodType();
            wPrd.setStartTime(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal2));
            wPrd.setEndTime(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal2end));
            wPrdList.add(wPrd);
        }
        return wDay;
    }

    static {
        mCalMgr = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"oracle.bpm.services.organization.model");
            unMarshaller = jaxbContext.createUnmarshaller();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            CalendarRule cal = CalendarMgrTest.getCalendarRule("oracle/bpm/services/organization/test/data/SimpleCalendar.xml");
            CalendarMgrTest.print(BPMOrganizationUtil.getJaxbObjectXMLAsString(cal));
            HolidayRule hol = CalendarMgrTest.getHolidayRule("oracle/bpm/services/organization/test/data/SimpleHolidays.xml");
            CalendarMgrTest.print(BPMOrganizationUtil.getJaxbObjectXMLAsString(hol));
            mCalMgr = new CalendarMgr(cal, hol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        datatypeFactory = null;
        try {
            Class<?> dataTypeFactoryClass = Class.forName("com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl");
            Constructor<?> constructor = dataTypeFactoryClass.getConstructor(new Class[0]);
            datatypeFactory = (DatatypeFactory)constructor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
    }
}

