/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.metadata.ITaskMetadataService;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.task.ITaskService;
import oracle.bpel.services.workflow.test.TestUtil;
import oracle.bpm.services.organization.test.AbstractBPMOrganizationTaskServiceTest;

public class BPMOrganizationTaskServiceRemoteTest
extends AbstractBPMOrganizationTaskServiceTest {
    public BPMOrganizationTaskServiceRemoteTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new BPMOrganizationTaskServiceRemoteTest("testGetPermittedAssigneesAPI"));
        suite.addTest((Test)new BPMOrganizationTaskServiceRemoteTest("testReassignTaskToPotentialAssignee"));
        suite.addTest((Test)new BPMOrganizationTaskServiceRemoteTest("testEscalateTaskToEscalationPath"));
        suite.addTest((Test)new BPMOrganizationTaskServiceRemoteTest("testEscalateTaskToMultipleEscalationPaths"));
        suite.addTest((Test)new BPMOrganizationTaskServiceRemoteTest("testEscalateTaskToRoleEscalationPath"));
        suite.addTest((Test)new BPMOrganizationTaskServiceRemoteTest("testGetParentOrgUnitForChild"));
        suite.addTest((Test)new BPMOrganizationTaskServiceRemoteTest("testGetParentOrgUnitForInvalidChildOrg"));
        suite.addTest((Test)new BPMOrganizationTaskServiceRemoteTest("testGetParentOrgUnitForChildInMultiplePaths"));
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)BPMOrganizationTaskServiceRemoteTest.suite());
    }

    public ITaskService getTaskService() {
        ITaskService taskService = this.getRemoteWorkflowServiceClient().getTaskService();
        return taskService;
    }

    public ITaskQueryService getTaskQueryService() {
        ITaskQueryService taskQueryService = this.getRemoteWorkflowServiceClient().getTaskQueryService();
        return taskQueryService;
    }

    public ITaskMetadataService getTaskMetadataService() {
        ITaskMetadataService taskMetadataService = this.getRemoteWorkflowServiceClient().getTaskMetadataService();
        return taskMetadataService;
    }

    public IWorkflowServiceClient getClient() {
        return this.getRemoteWorkflowServiceClient();
    }

    private IWorkflowServiceClient getRemoteWorkflowServiceClient() {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, TestUtil.getWFEJBURL());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_CREDENTIALS, TestUtil.getEJBCred());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_PRINCIPAL, TestUtil.getEJBUser());
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_INITIAL_CONTEXT_FACTORY, TestUtil.getJNDIInitialContextFactoryName());
        IWorkflowServiceClient client = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"REMOTE", properties, null);
        return client;
    }
}

