/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.BPMOrganizationService;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociation;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.ChildOrganizationalUnitRetrievalModeTypeEnum;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.RoleProfileType;
import oracle.bpm.services.organization.model.WeekDaysEnum;
import oracle.bpm.services.organization.model.WorkPeriodType;
import oracle.bpm.services.organization.model.WorkdayListType;
import oracle.bpm.services.organization.model.WorkdayType;

public class BPMOrganizationDemo {
    ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation = null;
    CalendarRule calendarRule = null;
    OrganizationalUnit childOrganizationalUnit1 = null;
    OrganizationalUnit childOrganizationalUnit2 = null;
    IBPMContext ctx = null;
    ObjectFactory objectFactory = new ObjectFactory();
    OrganizationalUnit organizationalUnit = null;
    Date today = new Date();
    IWorkflowServiceClient wfSvcClient = null;
    private static DatatypeFactory datatypeFactory = null;

    public BPMOrganizationDemo() {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.MODE, "dynamic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_PROVIDER_URL, "t3://140.87.22.83:7001");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_PRINCIPAL, "weblogic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.EJB_SECURITY_CREDENTIALS, "weblogic1");
        this.wfSvcClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"REMOTE", properties, null);
    }

    public static void main(String[] args) {
        try {
            BPMOrganizationDemo bpmOrganizationDemo = new BPMOrganizationDemo();
            bpmOrganizationDemo.demo();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public void createCalendarRule() throws Exception {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        this.calendarRule = this.objectFactory.createCalendarRule();
        this.calendarRule.setId(Util.getGuid());
        this.calendarRule.setName("2009 Fiscal Year Calendar");
        this.calendarRule.setCreatedBy("jstein");
        this.calendarRule.setCreatedDate(calendar);
        this.calendarRule.setLastUpdatedBy("jstein");
        this.calendarRule.setLastUpdatedDate(calendar);
        this.calendarRule.setTimeZone("PST");
        WorkdayListType workdayListType = this.objectFactory.createWorkdayListType();
        WorkdayType workdayType = this.objectFactory.createWorkdayType();
        workdayType.setWeekDay(WeekDaysEnum.MONDAY);
        WorkPeriodType workPeriodType = this.objectFactory.createWorkPeriodType();
        workPeriodType.setStartTime(calendar);
        workPeriodType.setEndTime(calendar);
        workdayType.getWorkPeriod().add(workPeriodType);
        workdayListType.getWorkday().add(workdayType);
        this.calendarRule.setWorkdayList(workdayListType);
    }

    public void createChildOrganizationalUnit1() throws Exception {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        this.childOrganizationalUnit1 = this.objectFactory.createOrganizationalUnit();
        this.childOrganizationalUnit1.setOrganizationalUnitId(Util.getGuid());
        this.childOrganizationalUnit1.setParentOrganizationalUnitId(this.organizationalUnit.getOrganizationalUnitId());
        this.childOrganizationalUnit1.setOrganizationalUnitName("Customer Support");
        this.childOrganizationalUnit1.setDescription("Customer support department");
        this.childOrganizationalUnit1.setCreatedBy("jstein");
        this.childOrganizationalUnit1.setCreatedByIdentityContext("jazn.com");
        this.childOrganizationalUnit1.setCreatedDate(calendar);
        this.childOrganizationalUnit1.setLastUpdatedBy("jstein");
        this.childOrganizationalUnit1.setLastUpdatedByIdentityContext("jazn.com");
        this.childOrganizationalUnit1.setLastUpdatedDate(calendar);
    }

    public void createChildOrganizationalUnit2() throws Exception {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        this.childOrganizationalUnit2 = this.objectFactory.createOrganizationalUnit();
        this.childOrganizationalUnit2.setOrganizationalUnitId(Util.getGuid());
        this.childOrganizationalUnit2.setParentOrganizationalUnitId(this.childOrganizationalUnit1.getOrganizationalUnitId());
        this.childOrganizationalUnit2.setOrganizationalUnitName("SOA Customer Support");
        this.childOrganizationalUnit2.setDescription("SOA Middleware Customer support department");
        this.childOrganizationalUnit2.setCreatedBy("jstein");
        this.childOrganizationalUnit2.setCreatedByIdentityContext("jazn.com");
        this.childOrganizationalUnit2.setCreatedDate(calendar);
        this.childOrganizationalUnit2.setLastUpdatedBy("jstein");
        this.childOrganizationalUnit2.setLastUpdatedByIdentityContext("jazn.com");
        this.childOrganizationalUnit2.setLastUpdatedDate(calendar);
    }

    public void createOrganizationalUnit() throws Exception {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        System.out.println("XMLGregorianCalendar:" + calendar.toString());
        this.organizationalUnit = this.objectFactory.createOrganizationalUnit();
        this.organizationalUnit.setOrganizationalUnitId(Util.getGuid());
        this.organizationalUnit.setOrganizationalUnitName("California");
        this.organizationalUnit.setDescription("California - Unites States of America");
        this.organizationalUnit.setCreatedBy("jstein");
        this.organizationalUnit.setCreatedByIdentityContext("jazn.com");
        this.organizationalUnit.setCreatedDate(calendar);
        this.organizationalUnit.setLastUpdatedBy("jstein");
        this.organizationalUnit.setLastUpdatedByIdentityContext("jazn.com");
        this.organizationalUnit.setLastUpdatedDate(calendar);
    }

    public void addPeopleQueryUser() throws Exception {
    }

    public void addManager(int count) {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        for (int index = 0; index < count; ++index) {
            MemberType manager = this.objectFactory.createMemberType();
            manager.setMemberId(Util.getGuid());
            if (index == 0) {
                manager.setName("wfaulk");
            } else {
                manager.setName("istone");
            }
            manager.setType(ParticipantTypeEnum.USER);
            manager.setRealm("jazn.com");
            manager.setCreatedBy("jcooper");
            manager.setCreatedByIdentityContext("jazn.com");
            manager.setCreatedDate(calendar);
            manager.setLastUpdatedBy("jcooper");
            manager.setLastUpdatedByIdentityContext("jazn.com");
            manager.setLastUpdatedDate(calendar);
            this.organizationalUnit.getManagedByMember().add(manager);
        }
    }

    public void deleteManager(int index) {
        List managers = this.organizationalUnit.getManagedByMember();
        if (!this.isListNullOrEmpty(managers) && index >= 0 && index < managers.size()) {
            MemberType memberType = (MemberType)managers.remove(index);
        }
    }

    public void deleteUser(int index) {
        List users = this.organizationalUnit.getMember();
        if (!this.isListNullOrEmpty(users) && index >= 0 && index < users.size()) {
            MemberType memberType = (MemberType)users.remove(index);
        }
    }

    public void addUser(int count) {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        for (int index = 0; index < count; ++index) {
            MemberType user = this.objectFactory.createMemberType();
            user.setMemberId(Util.getGuid());
            if (index == 0) {
                user.setName("wfaulk");
            } else {
                user.setName("istone");
            }
            user.setType(ParticipantTypeEnum.USER);
            user.setRealm("jazn.com");
            user.setCreatedBy("jcooper");
            user.setCreatedByIdentityContext("jazn.com");
            user.setCreatedDate(calendar);
            user.setLastUpdatedBy("jcooper");
            user.setLastUpdatedByIdentityContext("jazn.com");
            user.setLastUpdatedDate(calendar);
            this.organizationalUnit.getMember().add(user);
        }
    }

    public void demo() {
        try {
            System.out.println("OrganizationalUnit Demo Usecases");
            System.out.println("--------------------------------");
            System.out.println("Usecase 1: Creating an OrganizationalUnit");
            System.out.println("Usecase 2: Updating an OrganizationalUnit");
            System.out.println("Usecase 3: Creating an OrganizationalUnit as an child OrganizationalUnit");
            System.out.println("Usecase 4: Creating a child OrganizationalUnit to the child OrganizationalUnit");
            System.out.println("Usecase 5: Creating a CalendarRule and attaching it to an OrganizationalUnit");
            System.out.println("Usecase 6: Adding members to an OrganizationalUnit");
            System.out.println("Usecase 7: Deleting member of an OrganizationalUnit");
            System.out.println("Usecase 8: Adding PeopleQuery members to an OrganizationalUnit");
            System.out.println("Usecase 9: Associting a CalenderRule for a Role in an OrganizationalUnit");
            System.out.println();
            String userName = "jstein";
            System.out.println("Authenticating as " + userName + " ........");
            this.ctx = (IBPMContext)this.wfSvcClient.getTaskQueryService().authenticate(userName, "welcome1", null, null);
            System.out.println("Context: " + this.ctx.toString());
            System.out.println("User: " + this.ctx.getUser());
            System.out.println("Realm: " + this.ctx.getIdentityContext());
            System.out.println("Today's date:" + this.today);
            System.out.println();
            this.waitForEnter();
            BPMOrganizationService service = new BPMOrganizationService();
            System.out.println("Usecase 1: Creating an OrganizationalUnit");
            this.createOrganizationalUnit();
            this.print(this.organizationalUnit);
            this.waitForEnter();
            service.createOrganizationalUnit(this.ctx, this.organizationalUnit);
            System.out.println("Created OrganizationalUnit queried back:");
            OrganizationalUnit queriedOrganizationalUnit = service.getOrganizationalUnit(this.ctx, this.organizationalUnit.getOrganizationalUnitId(), ChildOrganizationalUnitRetrievalModeTypeEnum.HIRERARCHY);
            this.print(queriedOrganizationalUnit);
            this.waitForEnter();
            System.out.println("Usecase 2: Updating an OrganizationalUnit");
            System.out.println("Changing the OrganizationalUnit name to: \"Headquarters-California\"");
            this.organizationalUnit.setOrganizationalUnitName("Headquarters-California");
            System.out.println("Changing description to: California state (USA)");
            this.organizationalUnit.setDescription("California state (USA)");
            service.updateOrganizationalUnit(this.ctx, this.organizationalUnit);
            System.out.println("Updated OrganizationalUnit queried back:");
            queriedOrganizationalUnit = service.getOrganizationalUnit(this.ctx, this.organizationalUnit.getOrganizationalUnitId(), ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
            this.print(queriedOrganizationalUnit);
            this.waitForEnter();
            System.out.println("Usecase 5: reating a CalendarRule and attaching it to an OrganizationalUnit");
            this.waitForEnter();
            System.out.println("Attaching the CalendarRule to OrganizationalUnit:");
            this.waitForEnter();
            service.updateOrganizationalUnit(this.ctx, this.organizationalUnit);
            System.out.println("Updated OrganizationalUnit queried back:");
            queriedOrganizationalUnit = service.getOrganizationalUnit(this.ctx, this.organizationalUnit.getOrganizationalUnitId(), ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
            this.print(queriedOrganizationalUnit);
            this.waitForEnter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createBpmAppRoleOuCalAssoc() {
        this.applicationRoleOrgUnitCalendarAssociation = this.objectFactory.createApplicationRoleOrgUnitCalendarAssociation();
        this.applicationRoleOrgUnitCalendarAssociation.setApplicationRoleOrgUnitCalendarAssociationId(Util.getGuid());
        RoleProfileType applicationRole = this.objectFactory.createRoleProfileType();
        applicationRole.setName("LoanAgents");
        applicationRole.setIdentityContext("jazn.com");
        this.applicationRoleOrgUnitCalendarAssociation.setApplicationRole(applicationRole);
        this.applicationRoleOrgUnitCalendarAssociation.setCalendarRuleId(this.calendarRule.getId());
        this.applicationRoleOrgUnitCalendarAssociation.setCalendarRuleName(this.calendarRule.getName());
        this.applicationRoleOrgUnitCalendarAssociation.setOrganizationalUnitId(this.organizationalUnit.getOrganizationalUnitId());
        this.applicationRoleOrgUnitCalendarAssociation.setOrganizationalUnitName(this.organizationalUnit.getOrganizationalUnitName());
    }

    public boolean isListNullOrEmpty(List objects) {
        if (objects == null) {
            return true;
        }
        return objects.size() == 0;
    }

    private void waitForEnter() throws IOException {
    }

    private void printAllAssociation() throws BPMOrganizationException {
    }

    private void printAssociation(ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation) {
    }

    private void print(OrganizationalUnit ou) {
        if (ou != null) {
            System.out.println("Id:" + ou.getOrganizationalUnitId());
            System.out.println("Name:" + ou.getOrganizationalUnitName());
            System.out.println("Parent:" + ou.getParentOrganizationalUnitName());
            System.out.println("Description:" + ou.getDescription());
            System.out.println("CalendarRuleId:" + ou.getCalendarRuleId());
            System.out.println("User:" + ou.getMember());
            System.out.println("PeopleQueryUser:" + ou.getPeopleQueryMember());
            System.out.println("Manager:" + ou.getManagedByMember());
            System.out.println("CreatedBy:" + ou.getCreatedBy());
            System.out.println("CreatedByIdentityContext:" + ou.getCreatedByIdentityContext());
            System.out.println("CreatedDate:" + ou.getCreatedDate());
            System.out.println("LastUpdatedBy:" + ou.getLastUpdatedBy());
            System.out.println("LastUpdatedByIdentityContext:" + ou.getLastUpdatedByIdentityContext());
            System.out.println("LastUpdatedDate:" + ou.getLastUpdatedDate());
        }
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

