/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.test.IInternalOrganizationTestUtilityService;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.authentication.impl.BPMUserAuthenticationService;
import oracle.bpm.services.common.BPMServicesUtil;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.BPMOrganizationService;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.persistency.PropertyValueTypeEnum;

public class BPMInternalOrganizationTestUtilityService
implements IInternalOrganizationTestUtilityService {
    private static final BPMOrganizationService bpmOrganizationService = new BPMOrganizationService();
    private static final String IDTTY_CTXT = "jazn.com";
    private static final String CLASS_NAME = "oracle.bpm.services.organization.impl.BPMInternalOrganizationService";
    private static final IBPMUserAuthenticationService authService = new BPMUserAuthenticationService();

    public boolean createEscalationPathForUnitTest(IBPMContext ctx, Map<IdentityType, IdentityType> participants) {
        ObjectFactory objectFactory = new ObjectFactory();
        PrincipleRefType part = null;
        ParticipantProperty partProp = null;
        ParticipantProperties properties = null;
        ArrayList<ParticipantProperties> expectedParticipantPropertiesList = new ArrayList<ParticipantProperties>();
        boolean flag = true;
        for (IdentityType participant : participants.keySet()) {
            part = objectFactory.createPrincipleRefType();
            part.setName(participant.getId());
            part.setType(ParticipantTypeEnum.APPROLE);
            part.setRealm(IDTTY_CTXT);
            part.setApplicationContext("soa-infra");
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("ESCALATIONPATH");
            partProp.setPropertyType(PropertyValueTypeEnum.FREEFORM_STRING.toString());
            partProp.getValue().add(BPMServicesUtil.formatIdentityValue((IdentityType)participants.get(participant)));
            properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part);
            properties.getParticipantProperty().add(partProp);
            expectedParticipantPropertiesList.add(properties);
        }
        try {
            ctx = authService.authenticate("weblogic", new char[]{'w', 'e', 'b', 'l', 'o', 'g', 'i', 'c', '1'}, IDTTY_CTXT);
            bpmOrganizationService.setPropertiesOnParticipants(ctx, expectedParticipantPropertiesList);
        }
        catch (BPMOrganizationException e) {
            this.warningLog("createEscalationPathForUnitTest", (Exception)((Object)e));
            this.debugLog("createEscalationPathForUnitTest", "Error while creating ESCALATIONPATH " + e.getMessage());
            flag = false;
        }
        catch (BPMException be) {
            this.warningLog("createEscalationPathForUnitTest", (Exception)((Object)be));
            this.debugLog("createEscalationPathForUnitTest", "Error while creating ESCALATIONPATH " + be.getMessage());
            flag = false;
        }
        return flag;
    }

    public boolean createPotentialAssigneeForUnitTest(IBPMContext ctx, Map<IdentityType, IdentityType> participants) {
        ObjectFactory objectFactory = new ObjectFactory();
        PrincipleRefType part = null;
        ParticipantProperty partProp = null;
        ParticipantProperties properties = null;
        ArrayList<ParticipantProperties> expectedParticipantPropertiesList = new ArrayList<ParticipantProperties>();
        boolean flag = true;
        for (IdentityType participant : participants.keySet()) {
            part = objectFactory.createPrincipleRefType();
            part.setName(participant.getId());
            part.setType(ParticipantTypeEnum.APPROLE);
            part.setRealm(IDTTY_CTXT);
            part.setApplicationContext("soa-infra");
            partProp = objectFactory.createParticipantProperty();
            partProp.setName("POTENTIAL_ASSIGNEE");
            partProp.setPropertyType(PropertyValueTypeEnum.FREEFORM_STRING.toString());
            partProp.getValue().add(BPMServicesUtil.formatIdentityValue((IdentityType)participants.get(participant)));
            properties = objectFactory.createParticipantProperties();
            properties.setParticipant(part);
            properties.getParticipantProperty().add(partProp);
            expectedParticipantPropertiesList.add(properties);
        }
        try {
            ctx = authService.authenticate("weblogic", new char[]{'w', 'e', 'b', 'l', 'o', 'g', 'i', 'c', '1'}, IDTTY_CTXT);
            bpmOrganizationService.setPropertiesOnParticipants(ctx, expectedParticipantPropertiesList);
        }
        catch (BPMOrganizationException e) {
            this.warningLog("createPotentialAssigneeForUnitTest", (Exception)((Object)e));
            this.debugLog("createPotentialAssigneeForUnitTest", "Error while creating POTENTIAL_ASSIGNEE " + e.getMessage());
            flag = false;
        }
        catch (BPMException be) {
            this.warningLog("createPotentialAssigneeForUnitTest", (Exception)((Object)be));
            this.debugLog("createPotentialAssigneeForUnitTest", "Error while creating POTENTIAL_ASSIGNEE " + be.getMessage());
            flag = false;
        }
        return flag;
    }

    public boolean deleteParticipantProperties(IBPMContext ctx, List<String> propertyNames) {
        ObjectFactory objectFactory = new ObjectFactory();
        ParticipantProperty partProp = null;
        boolean flag = true;
        for (String propertyName : propertyNames) {
            partProp = objectFactory.createParticipantProperty();
            partProp.setName(propertyName);
            try {
                ctx = authService.authenticate("weblogic", new char[]{'w', 'e', 'b', 'l', 'o', 'g', 'i', 'c', '1'}, IDTTY_CTXT);
                bpmOrganizationService.deleteParticipantProperty(ctx, partProp, true);
            }
            catch (BPMOrganizationException e) {
                this.warningLog("deleteParticipantProperties", (Exception)((Object)e));
                this.debugLog("deleteParticipantProperties", "Error while deleting " + propertyName + e.getMessage());
                return false;
            }
            catch (BPMException be) {
                this.warningLog("deleteParticipantProperties", (Exception)((Object)be));
                this.debugLog("deleteParticipantProperties", "Error while deleting " + propertyName + be.getMessage());
                return false;
            }
        }
        return flag;
    }

    private static IBPMContext getInternalBPMContext() throws BPMOrganizationException {
        try {
            IBPMContext ctx = (IBPMContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return ctx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw new BPMOrganizationException(orgEx);
            }
            throw new BPMOrganizationException((Exception)pae);
        }
    }

    private void warningLog(String method, Exception e) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.WARNING)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.WARNING, (String)CLASS_NAME, (String)method, (Throwable)e);
        }
    }

    private void debugLog(String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)method, (String)msg);
        }
    }
}

