/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.test.TestUtil;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.model.ApplicationContext;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociation;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociations;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.bpm.services.organization.model.ApplicationRoles;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.CalendarRules;
import oracle.bpm.services.organization.model.HolidayPatternEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayRules;
import oracle.bpm.services.organization.model.HolidayType;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Organization;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.OrganizationalUnits;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantPropertiesList;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantPropertyList;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.RoleProfileType;
import oracle.bpm.services.organization.model.WeekDaysEnum;
import oracle.bpm.services.organization.model.WorkPeriodType;
import oracle.bpm.services.organization.model.WorkdayListType;
import oracle.bpm.services.organization.model.WorkdayType;

public abstract class AbstractExportImportOrganizationTest
extends TestCase {
    public static final String REALM_NAME = "jazn.com";
    public static final String PASSWORD = "welcome1";
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static DatatypeFactory datatypeFactory = null;
    private static Organization organization = objectFactory.createOrganization();
    private static Organization organization2 = objectFactory.createOrganization();
    private static Organization exportedOrganization = objectFactory.createOrganization();
    private static OrganizationalUnit organizationalUnit = objectFactory.createOrganizationalUnit();
    private static OrganizationalUnit organizationalUnit1 = objectFactory.createOrganizationalUnit();
    private static OrganizationalUnit organizationalUnit2 = objectFactory.createOrganizationalUnit();
    private static OrganizationalUnits organizationalUnits = objectFactory.createOrganizationalUnits();
    private static HolidayRules holidayRules = objectFactory.createHolidayRules();
    private static HolidayRule holRul = objectFactory.createHolidayRule();
    private static HolidayRule holRul2 = objectFactory.createHolidayRule();
    private static CalendarRules calendarRules = objectFactory.createCalendarRules();
    private static CalendarRule calRul = objectFactory.createCalendarRule();
    private static CalendarRule calRul2 = objectFactory.createCalendarRule();
    private static ParticipantPropertyList participantPropertyList = objectFactory.createParticipantPropertyList();
    private static ParticipantProperty partProp = objectFactory.createParticipantProperty();
    private static ParticipantProperty partProp2 = objectFactory.createParticipantProperty();
    private static ParticipantPropertiesList participantPropertiesList = objectFactory.createParticipantPropertiesList();
    private static ParticipantProperties properties = objectFactory.createParticipantProperties();
    private static ParticipantProperties properties2 = objectFactory.createParticipantProperties();
    private static ApplicationRoles applicationRoles = objectFactory.createApplicationRoles();
    private static ApplicationRoleType appRoleType1 = objectFactory.createApplicationRoleType();
    private static ApplicationRoleType appRoleType2 = objectFactory.createApplicationRoleType();
    private static ApplicationRoleOrgUnitCalendarAssociations associations = objectFactory.createApplicationRoleOrgUnitCalendarAssociations();
    private static ApplicationRoleOrgUnitCalendarAssociation assoc1 = objectFactory.createApplicationRoleOrgUnitCalendarAssociation();
    private static ApplicationRoleOrgUnitCalendarAssociation assoc2 = objectFactory.createApplicationRoleOrgUnitCalendarAssociation();

    public AbstractExportImportOrganizationTest(String testName) {
        super(testName);
    }

    public abstract IBPMOrganizationService getBPMOrganizationService();

    public abstract IBPMUserAuthenticationService getBPMUserAuthenticationService();

    public static Test suite() {
        TestSuite suite = new TestSuite(AbstractExportImportOrganizationTest.class);
        return suite;
    }

    public static ApplicationContext createApplicationContext(String appCtx) {
        ApplicationContext applName = objectFactory.createApplicationContext();
        applName.setApplicationType(ApplicationContextTypeEnum.fromValue((String)appCtx));
        return applName;
    }

    public void createOrganization() throws Exception {
        this.createOrganizationalUnits();
        this.createHolidayRules();
        this.createCalendarRules();
        this.createParticipantPropertyList();
        this.createApplicationRoles();
        this.createApplicationRoleOrgUnitCalendarAssociations();
        organization.setOrganizationalUnits(organizationalUnits);
        organization.setApplicationRoles(applicationRoles);
        organization.setApplicationRoleOrgUnitCalendarAssociations(associations);
        organization.setParticipantPropertyList(participantPropertyList);
        organization.setHolidayRules(holidayRules);
        organization.setCalendarRules(calendarRules);
        organization.setOrganizationalUnits(organizationalUnits);
        organization.setApplicationRoleOrgUnitCalendarAssociations(associations);
    }

    public void createOrganization2() throws Exception {
        this.createParticipantPropertiesList();
        organization2.setParticipantPropertiesList(participantPropertiesList);
    }

    public void deleteOrganization(IBPMContext ctx) throws Exception {
        IBPMOrganizationService service = this.getBPMOrganizationService();
        service.deleteApplicationRoleOrgUnitCalendarAssociation(ctx, assoc1.getApplicationRoleOrgUnitCalendarAssociationId());
        service.removeAppRole(ctx, AbstractExportImportOrganizationTest.createApplicationContext(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value()), "Role2", true);
        service.removeAppRole(ctx, AbstractExportImportOrganizationTest.createApplicationContext(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value()), "Role1", true);
        service.deleteOrganizationalUnit(ctx, organizationalUnit1.getOrganizationalUnitId(), true, false);
        service.deleteOrganizationalUnit(ctx, organizationalUnit2.getOrganizationalUnitId(), true, false);
        service.deleteOrganizationalUnit(ctx, organizationalUnit.getOrganizationalUnitId(), true, false);
        service.deleteCalendarRule(ctx, calRul.getId(), false);
        service.deleteCalendarRule(ctx, calRul2.getId(), false);
        service.deleteHolidayRule(ctx, holRul.getId(), false);
        service.deleteHolidayRule(ctx, holRul2.getId(), false);
        service.deleteParticipantProperty(ctx, partProp, true);
        service.deleteParticipantProperty(ctx, partProp2, true);
    }

    public void createOrganizationalUnits() throws Exception {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        organizationalUnit = objectFactory.createOrganizationalUnit();
        organizationalUnit.setOrganizationalUnitId(Util.getGuid());
        organizationalUnit.setOrganizationalUnitName("Oracle");
        organizationalUnit.setDescription("Oracle");
        organizationalUnit.setCreatedBy("jstein");
        organizationalUnit.setCreatedByIdentityContext(REALM_NAME);
        organizationalUnit.setCreatedDate(calendar);
        organizationalUnit.setLastUpdatedBy("jstein");
        organizationalUnit.setLastUpdatedByIdentityContext(REALM_NAME);
        organizationalUnit.setLastUpdatedDate(calendar);
        MemberType manager = objectFactory.createMemberType();
        manager.setMemberId(Util.getGuid());
        manager.setName("cdickens");
        manager.setType(ParticipantTypeEnum.USER);
        manager.setRealm(REALM_NAME);
        manager.setCreatedBy("jstein");
        manager.setCreatedByIdentityContext(REALM_NAME);
        manager.setCreatedDate(calendar);
        manager.setLastUpdatedBy("jstein");
        manager.setLastUpdatedByIdentityContext(REALM_NAME);
        manager.setLastUpdatedDate(calendar);
        organizationalUnit.getManagedByMember().add(manager);
        MemberType user = objectFactory.createMemberType();
        user.setMemberId(Util.getGuid());
        user.setName("jcooper");
        user.setType(ParticipantTypeEnum.USER);
        user.setRealm(REALM_NAME);
        user.setCreatedBy("jstein");
        user.setCreatedByIdentityContext(REALM_NAME);
        user.setCreatedDate(calendar);
        user.setLastUpdatedBy("jstein");
        user.setLastUpdatedByIdentityContext(REALM_NAME);
        user.setLastUpdatedDate(calendar);
        organizationalUnit.getMember().add(user);
        organizationalUnit1.setOrganizationalUnitId(Util.getGuid());
        organizationalUnit1.setOrganizationalUnitName("HQ");
        organizationalUnit1.setParentOrganizationalUnitId(organizationalUnit.getOrganizationalUnitId());
        organizationalUnit1.setParentOrganizationalUnitName(organizationalUnit.getOrganizationalUnitName());
        organizationalUnit1.setDescription("HeadQuarters OrgUnit");
        organizationalUnit1.setCreatedBy("cdickens");
        organizationalUnit1.setCreatedByIdentityContext(REALM_NAME);
        organizationalUnit1.setCreatedDate(calendar);
        organizationalUnit1.setLastUpdatedBy("jstein");
        organizationalUnit1.setLastUpdatedByIdentityContext(REALM_NAME);
        organizationalUnit1.setLastUpdatedDate(calendar);
        MemberType manager1 = objectFactory.createMemberType();
        manager1.setMemberId(Util.getGuid());
        manager1.setName("cdickens");
        manager1.setType(ParticipantTypeEnum.USER);
        manager1.setRealm(REALM_NAME);
        manager1.setCreatedBy("cdickens");
        manager1.setCreatedByIdentityContext(REALM_NAME);
        manager1.setCreatedDate(calendar);
        manager1.setLastUpdatedBy("jstein");
        manager1.setLastUpdatedByIdentityContext(REALM_NAME);
        manager1.setLastUpdatedDate(calendar);
        organizationalUnit1.getManagedByMember().add(manager1);
        MemberType user1 = objectFactory.createMemberType();
        user1.setMemberId(Util.getGuid());
        user1.setName("jcooper");
        user1.setType(ParticipantTypeEnum.USER);
        user1.setRealm(REALM_NAME);
        user1.setCreatedBy("jstein");
        user1.setCreatedByIdentityContext(REALM_NAME);
        user1.setCreatedDate(calendar);
        user1.setLastUpdatedBy("jstein");
        user1.setLastUpdatedByIdentityContext(REALM_NAME);
        user1.setLastUpdatedDate(calendar);
        organizationalUnit1.getMember().add(user1);
        organizationalUnit2.setOrganizationalUnitId(Util.getGuid());
        organizationalUnit2.setOrganizationalUnitName("IDC");
        organizationalUnit2.setParentOrganizationalUnitId(organizationalUnit.getOrganizationalUnitId());
        organizationalUnit2.setParentOrganizationalUnitName(organizationalUnit.getOrganizationalUnitName());
        organizationalUnit2.setDescription("IDC OrgUnit");
        organizationalUnit2.setCreatedBy("wfaulk");
        organizationalUnit2.setCreatedByIdentityContext(REALM_NAME);
        organizationalUnit2.setCreatedDate(calendar);
        organizationalUnit2.setLastUpdatedBy("wfaulk");
        organizationalUnit2.setLastUpdatedByIdentityContext(REALM_NAME);
        organizationalUnit2.setLastUpdatedDate(calendar);
        MemberType manager2 = objectFactory.createMemberType();
        manager2.setMemberId(Util.getGuid());
        manager2.setName("jlondon");
        manager2.setType(ParticipantTypeEnum.USER);
        manager2.setRealm(REALM_NAME);
        manager2.setCreatedBy("wfaulk");
        manager2.setCreatedByIdentityContext(REALM_NAME);
        manager2.setCreatedDate(calendar);
        manager2.setLastUpdatedBy("wfaulk");
        manager2.setLastUpdatedByIdentityContext(REALM_NAME);
        manager2.setLastUpdatedDate(calendar);
        organizationalUnit2.getManagedByMember().add(manager2);
        MemberType user2 = objectFactory.createMemberType();
        user2.setMemberId(Util.getGuid());
        user2.setName("jcooper");
        user2.setType(ParticipantTypeEnum.USER);
        user2.setRealm(REALM_NAME);
        user2.setCreatedBy("jlondon");
        user2.setCreatedByIdentityContext(REALM_NAME);
        user2.setCreatedDate(calendar);
        user2.setLastUpdatedBy("jlondon");
        user2.setLastUpdatedByIdentityContext(REALM_NAME);
        user2.setLastUpdatedDate(calendar);
        organizationalUnit2.getMember().add(user2);
        organizationalUnit.getChildOrganizationalUnits().add(organizationalUnit1);
        organizationalUnit.getChildOrganizationalUnits().add(organizationalUnit2);
        organizationalUnits.getOrganizationalUnit().add(organizationalUnit);
    }

    public void createHolidayRules() throws BPMOrganizationException, BPMException {
        HolidayRule holRul = objectFactory.createHolidayRule();
        holRul.setName("Oracle Holiday List");
        holRul.setId(Util.getGuid());
        List holidayList = holRul.getHolidays();
        HolidayType holiday = objectFactory.createHolidayType();
        holiday.setName("New year day");
        holiday.setHolidayPattern(HolidayPatternEnum.SAME_DAY_EVERY_YEAR);
        Calendar cal = Calendar.getInstance();
        cal.set(2009, 1, 1, 1, 1, 1);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList.add(holiday);
        holiday = objectFactory.createHolidayType();
        holiday.setName("Independence day");
        holiday.setHolidayPattern(HolidayPatternEnum.SAME_DAY_EVERY_YEAR);
        cal = Calendar.getInstance();
        cal.set(2009, 8, 15, 1, 1, 1);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList.add(holiday);
        holiday = objectFactory.createHolidayType();
        holiday.setName("Christmas");
        holiday.setHolidayPattern(HolidayPatternEnum.SAME_DAY_EVERY_YEAR);
        cal = Calendar.getInstance();
        cal.set(2009, 12, 25, 1, 1, 1);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList.add(holiday);
        HolidayRule holRul2 = objectFactory.createHolidayRule();
        holRul2.setName("IDC Holiday List");
        holRul2.setId(Util.getGuid());
        List holidayList2 = holRul2.getHolidays();
        holiday = objectFactory.createHolidayType();
        holiday.setName("New year day");
        holiday.setHolidayPattern(HolidayPatternEnum.SAME_DAY_EVERY_YEAR);
        cal = Calendar.getInstance();
        cal.set(2009, 1, 1, 1, 1, 1);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList2.add(holiday);
        holiday = objectFactory.createHolidayType();
        holiday.setName("Independence day");
        holiday.setHolidayPattern(HolidayPatternEnum.SAME_DAY_EVERY_YEAR);
        cal = Calendar.getInstance();
        cal.set(2009, 8, 15, 1, 1, 1);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList2.add(holiday);
        holiday = objectFactory.createHolidayType();
        holiday.setName("Christmas");
        holiday.setHolidayPattern(HolidayPatternEnum.SAME_DAY_EVERY_YEAR);
        cal = Calendar.getInstance();
        cal.set(2009, 12, 25, 1, 1, 1);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList2.add(holiday);
        holidayRules.getHolidayRule().add(holRul);
        holidayRules.getHolidayRule().add(holRul2);
    }

    public void createCalendarRules() throws BPMOrganizationException, BPMException {
        calRul.setName("HQ Calendar");
        calRul.setId(Util.getGuid());
        calRul.setTimeZone("Asia/Calcutta");
        WorkdayListType workList = objectFactory.createWorkdayListType();
        List wList = workList.getWorkday();
        wList.add(this.getWeekDay("Monday"));
        wList.add(this.getWeekDay("Tuesday"));
        wList.add(this.getWeekDay("Wednesday"));
        wList.add(this.getWeekDay("Thursday"));
        wList.add(this.getWeekDay("Friday"));
        calRul.setWorkdayList(workList);
        calRul.setHolidayRuleName(holRul.getName());
        calRul.setHolidayRuleId(holRul.getId());
        calRul2.setName("HQ Calendar");
        calRul2.setId(Util.getGuid());
        calRul2.setTimeZone("Asia/Calcutta");
        workList = objectFactory.createWorkdayListType();
        wList = workList.getWorkday();
        wList.add(this.getWeekDay("Monday"));
        wList.add(this.getWeekDay("Tuesday"));
        wList.add(this.getWeekDay("Wednesday"));
        wList.add(this.getWeekDay("Thursday"));
        wList.add(this.getWeekDay("Friday"));
        calRul2.setWorkdayList(workList);
        calRul2.setHolidayRuleName(holRul2.getName());
        calRul2.setHolidayRuleId(holRul2.getId());
        calendarRules.getCalendarRule().add(calRul);
        calendarRules.getCalendarRule().add(calRul2);
    }

    public void createParticipantPropertyList() {
        partProp.setName("SKILL");
        partProp.setPropertyType("STRING");
        List values = partProp.getValue();
        values.add("Java");
        values.add("COBOL");
        values.add("C#");
        partProp2.setName("LICENSES_SOLD");
        partProp2.setPropertyType("NUMBER");
        participantPropertyList.getParticipantProperty().add(partProp);
        participantPropertyList.getParticipantProperty().add(partProp2);
    }

    public void createParticipantPropertiesList() {
        PrincipleRefType part = objectFactory.createPrincipleRefType();
        part.setName("jstein");
        part.setType(ParticipantTypeEnum.USER);
        part.setRealm(REALM_NAME);
        properties.setParticipant(part);
        properties.getParticipantProperty().add(partProp);
        PrincipleRefType part2 = objectFactory.createPrincipleRefType();
        part2.setName("jcooper");
        part2.setType(ParticipantTypeEnum.USER);
        part2.setRealm(REALM_NAME);
        partProp2.setName("LICENSES_SOLD");
        List values = partProp2.getValue();
        values.add(10);
        properties2.setParticipant(part2);
        properties2.getParticipantProperty().add(partProp2);
        participantPropertiesList.getParticipantProperties().add(properties);
        participantPropertiesList.getParticipantProperties().add(properties2);
    }

    public void createApplicationRoles() {
        appRoleType1.setName("Role1");
        appRoleType1.setIdentityContext(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value());
        PrincipleRefType part = objectFactory.createPrincipleRefType();
        part.setName("jstein");
        part.setType(ParticipantTypeEnum.USER);
        part.setRealm(REALM_NAME);
        PrincipleRefType part2 = objectFactory.createPrincipleRefType();
        part2.setName("California");
        part2.setType(ParticipantTypeEnum.GROUP);
        part2.setRealm(REALM_NAME);
        appRoleType1.getMember().add(part);
        appRoleType1.getMember().add(part2);
        appRoleType2.setName("Role2");
        appRoleType2.setIdentityContext(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value());
        part = objectFactory.createPrincipleRefType();
        part.setName("wfaulk");
        part.setType(ParticipantTypeEnum.USER);
        part.setRealm(REALM_NAME);
        part2 = objectFactory.createPrincipleRefType();
        part2.setName("Role1");
        part2.setType(ParticipantTypeEnum.APPROLE);
        part2.setRealm(REALM_NAME);
        appRoleType2.getMember().add(part);
        appRoleType2.getMember().add(part2);
        applicationRoles.getApplicationRole().add(appRoleType1);
        applicationRoles.getApplicationRole().add(appRoleType2);
    }

    public void createApplicationRoleOrgUnitCalendarAssociations() {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        assoc1.setApplicationRoleOrgUnitCalendarAssociationId(Util.getGuid());
        assoc1.setApplicationRole((RoleProfileType)appRoleType1);
        assoc1.setOrganizationalUnitId(organizationalUnit.getOrganizationalUnitId());
        assoc1.setOrganizationalUnitName(organizationalUnit.getOrganizationalUnitName());
        assoc1.setCalendarRuleId(calRul.getId());
        assoc1.setCalendarRuleName(calRul.getName());
        associations.getApplicationRoleOrgUnitCalendarAssociation().add(assoc1);
    }

    public IBPMContext createWFContext(String user, String password, String realm) throws BPMException {
        return this.getBPMUserAuthenticationService().authenticate(user, password.toCharArray(), realm);
    }

    public void testImportOrganization() throws Exception {
        IBPMContext ctx = null;
        this.createOrganization();
        ctx = this.createWFContext(TestUtil.getEJBUser(), TestUtil.getEJBCred(), REALM_NAME);
        this.getBPMOrganizationService().importOrganization(ctx, organization, false);
    }

    private WorkdayType getWeekDay(String weekday) {
        WorkdayType wDay = objectFactory.createWorkdayType();
        wDay.setWeekDay(WeekDaysEnum.fromValue((String)weekday));
        List wPrdList = wDay.getWorkPeriod();
        WorkPeriodType wPrd = objectFactory.createWorkPeriodType();
        Calendar cal = Calendar.getInstance();
        cal.set(2009, 1, 2, 3, 10, 30);
        wPrd.setStartTime(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        Calendar calend = Calendar.getInstance();
        calend.set(2009, 1, 2, 3, 10, 30);
        wPrd.setEndTime(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)calend));
        wPrdList.add(wPrd);
        return wDay;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

