/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.task.ITaskService;
import oracle.bpel.services.workflow.task.model.ActionType;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.test.TestUtil;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.ChildOrganizationalUnitRetrievalModeTypeEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processmetadata.StatusEnum;
import oracle.tip.pc.services.identity.BPMIdentityService;

public abstract class AbstractEndToEndOrganizationServiceTest
extends TestCase {
    private static final String APP_ROLE_NAME = ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value();
    private static final String PROCESS_INPUT = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ns=\"http://xmlns.oracle.com/bpmn/bpmnProcess/HWFM4IntegratedTestProcess\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">    <soap:Body>        <ns:operation3>            <customArgument1 xsi:type=\"xsd:string\">identificationKey</customArgument1>        </ns:operation3>    </soap:Body></soap:Envelope>";
    private static final int RETRY = 10;
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static DatatypeFactory datatypeFactory = null;

    public AbstractEndToEndOrganizationServiceTest(String testName) {
        super(testName);
    }

    public abstract IBPMOrganizationService getBPMOrganizationService();

    public abstract IBPMUserAuthenticationService getBPMUserAuthenticationService();

    public abstract BPMIdentityService getBPMIdentityService();

    public abstract ITaskService getTaskService();

    public abstract ITaskQueryService getTaskQueryService();

    public abstract IProcessMetadataService getProcessMetadataService();

    public static Test suite() {
        TestSuite suite = new TestSuite(AbstractEndToEndOrganizationServiceTest.class);
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AbstractEndToEndOrganizationServiceTest.suite());
    }

    public void testOrgUnitInTask() throws Exception {
        String identificationKey = "testOrgUnitInTask" + Calendar.getInstance().getTime().getTime();
        this.initiateProcess(identificationKey);
        IBPMContext ctx = this.getContext("jstein", "welcome1");
        Task task = this.queryTask("jstein", "welcome1", identificationKey, "HWFM4IntegratedTestProject");
        AbstractEndToEndOrganizationServiceTest.assertNotNull((String)"Task not found for jstein", (Object)task);
        AbstractEndToEndOrganizationServiceTest.assertEquals((String)"California", (String)task.getSystemAttributes().getOrganizationalUnitId());
        task = this.getTaskQueryService().getTaskDetailsById((IWorkflowContext)ctx, task.getSystemAttributes().getTaskId());
        AbstractEndToEndOrganizationServiceTest.assertEquals((String)"California", (String)task.getSystemAttributes().getOrganizationalUnitId());
    }

    public void testTaskAssigneeAndAction() throws Exception {
        ActionType at;
        int i;
        String identificationKey = "testOrgUnitInTask" + Calendar.getInstance().getTime().getTime();
        this.initiateProcess(identificationKey);
        IBPMContext ctx = this.getContext("jstein", "welcome1");
        Task task = this.queryTask("jstein", "welcome1", identificationKey, "HWFM4IntegratedTestProject");
        AbstractEndToEndOrganizationServiceTest.assertNotNull((String)"Task not found for jstein", (Object)task);
        List assignees = task.getSystemAttributes().getAssignees();
        AbstractEndToEndOrganizationServiceTest.assertEquals((int)1, (int)assignees.size());
        AbstractEndToEndOrganizationServiceTest.assertEquals((String)"HWFM4IntegratedTestProject.SalesClerk", (String)((IdentityType)assignees.get(0)).getId());
        AbstractEndToEndOrganizationServiceTest.assertEquals((String)APP_ROLE_NAME, (String)task.getApplicationContext());
        boolean isAcquire = false;
        List systemActions = task.getSystemAttributes().getSystemActions();
        for (i = 0; i < systemActions.size(); ++i) {
            at = (ActionType)systemActions.get(i);
            if (!"ACQUIRE".equals(at.getAction())) continue;
            isAcquire = true;
        }
        AbstractEndToEndOrganizationServiceTest.assertEquals((String)"Acquire action not present", (boolean)true, (boolean)isAcquire);
        task = this.getTaskQueryService().getTaskDetailsById((IWorkflowContext)ctx, task.getSystemAttributes().getTaskId());
        assignees = task.getSystemAttributes().getAssignees();
        AbstractEndToEndOrganizationServiceTest.assertEquals((int)1, (int)assignees.size());
        AbstractEndToEndOrganizationServiceTest.assertEquals((String)"HWFM4IntegratedTestProject.SalesClerk", (String)((IdentityType)assignees.get(0)).getId());
        AbstractEndToEndOrganizationServiceTest.assertEquals((String)APP_ROLE_NAME, (String)task.getApplicationContext());
        isAcquire = false;
        systemActions = task.getSystemAttributes().getSystemActions();
        for (i = 0; i < systemActions.size(); ++i) {
            at = (ActionType)systemActions.get(i);
            if (!"ACQUIRE".equals(at.getAction())) continue;
            isAcquire = true;
        }
        AbstractEndToEndOrganizationServiceTest.assertEquals((String)"Acquire action not present", (boolean)true, (boolean)isAcquire);
    }

    public void testTaskVisibilityPositive() throws Exception {
        String identificationKey = "testOrgUnitInTask" + Calendar.getInstance().getTime().getTime();
        this.initiateProcess(identificationKey);
        Task task = this.queryTask("jstein", "welcome1", identificationKey, "HWFM4IntegratedTestProject");
        AbstractEndToEndOrganizationServiceTest.assertNotNull((String)"Task not found for jstein", (Object)task);
    }

    public void testTaskVisibilityNegative1() throws Exception {
        String identificationKey = "testOrgUnitInTask" + Calendar.getInstance().getTime().getTime();
        this.initiateProcess(identificationKey);
        Task task = this.queryTask("wfaulk", "welcome1", identificationKey, "HWFM4IntegratedTestProject");
        AbstractEndToEndOrganizationServiceTest.assertNull((String)"Task found for wfaulk", (Object)task);
    }

    public void testTaskVisibilityNegative2() throws Exception {
        String identificationKey = "testOrgUnitInTask" + Calendar.getInstance().getTime().getTime();
        this.initiateProcess(identificationKey);
        Task task = this.queryTask("jcooper", "welcome1", identificationKey, "HWFM4IntegratedTestProject");
        AbstractEndToEndOrganizationServiceTest.assertNull((String)"Task found for jcooper", (Object)task);
    }

    public void testOrganizationalUnitCreation() throws Exception {
        IBPMContext ctx = this.getContext("demoadmin", "welcome1");
        OrganizationalUnit orgUnit = this.getBPMOrganizationService().getOrganizationalUnit(ctx, "California", ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
        AbstractEndToEndOrganizationServiceTest.assertNotNull((String)"Organization unit not found", (Object)orgUnit);
    }

    public void testCalendarCreation() throws Exception {
        IBPMContext ctx = this.getContext("demoadmin", "welcome1");
        CalendarRule cal = this.getBPMOrganizationService().getCalendarRule(ctx, "CACalendar");
        AbstractEndToEndOrganizationServiceTest.assertNotNull((String)"Calendar not found", (Object)cal);
    }

    public void testHolidayCreation() throws Exception {
        IBPMContext ctx = this.getContext("demoadmin", "welcome1");
        HolidayRule hol = this.getBPMOrganizationService().getHolidayRule(ctx, "CAHolidays");
        AbstractEndToEndOrganizationServiceTest.assertNotNull((String)"Holidays not found", (Object)hol);
    }

    public void testTaskExpiration() throws Exception {
        System.out.println("========== testTaskExpiration ==========");
        String identificationKey = "testOrgUnitInTask" + Calendar.getInstance().getTime().getTime();
        this.initiateProcess(identificationKey);
        Task task = this.queryTask("jstein", "welcome1", identificationKey, "HWFM4IntegratedTestProject");
        Calendar expirationDate = task.getSystemAttributes().getExpirationDate();
        AbstractEndToEndOrganizationServiceTest.assertNotNull((String)"Expiration date is null", (Object)expirationDate);
        System.out.println("Expiration is " + expirationDate.getTime());
        long diff = expirationDate.getTime().getTime() - Calendar.getInstance().getTime().getTime();
        long sevenDays = 604800000L;
        long diffWithSevenDays = diff - sevenDays;
        System.out.println("diffWithSevenDays is " + diffWithSevenDays);
        AbstractEndToEndOrganizationServiceTest.assertTrue((String)"Expiration is not greater than 7 absolute days", (diff > sevenDays ? 1 : 0) != 0);
        System.out.println("========== testTaskExpiration ==========");
    }

    public void testGetProcessMetadata() throws Exception {
        System.out.println("\n ===>>> Test name: " + this.getName());
        IBPMContext ctx = this.getContext("demoadmin", "welcome1");
        List list = this.getProcessMetadataService().listProcessMetadataSummary(ctx, null, null, null);
        for (ProcessMetadataSummary p : list) {
            String compositeName = p.getCompositeName();
            if (!"HWFM4IntegratedTestProject".equals(compositeName)) continue;
            return;
        }
        AbstractEndToEndOrganizationServiceTest.fail((String)"Process metadata summary not found for HWFM4IntegratedTestProject");
    }

    public void testGetRolesFromProcessMetadataService() throws Exception {
        System.out.println("\n ===>>> Test name: " + this.getName());
        IBPMContext ctx = this.getContext("demoadmin", "welcome1");
        List list = this.getProcessMetadataService().listProcessMetadataSummary(ctx, null, null, null);
        String compositeDN = null;
        for (ProcessMetadataSummary p : list) {
            Map processRoles;
            if (p.getStatus() != StatusEnum.ACTIVE) continue;
            if ("HWFM4IntegratedTestProject".equals(p.getCompositeName())) {
                compositeDN = p.getCompositeDN();
                AbstractEndToEndOrganizationServiceTest.assertNotNull((String)"compositeDN not found", (Object)compositeDN);
                System.out.println("\n compositeDN is " + compositeDN);
                processRoles = this.getProcessMetadataService().getProcessRoles(ctx, compositeDN);
                System.out.println("processRoles is " + processRoles);
                AbstractEndToEndOrganizationServiceTest.assertEquals((String)"SalesClerk role mapping incorrect", (String)"HWFM4IntegratedTestProject.SalesClerk", (String)((String)processRoles.get("SalesClerk")));
            }
            if (!"InitiableTaskProject".equals(p.getCompositeName())) continue;
            compositeDN = p.getCompositeDN();
            AbstractEndToEndOrganizationServiceTest.assertNotNull((String)"compositeDN not found", (Object)compositeDN);
            System.out.println("\n compositeDN is " + compositeDN);
            processRoles = this.getProcessMetadataService().getProcessRoles(ctx, compositeDN);
            System.out.println("processRoles is " + processRoles);
            AbstractEndToEndOrganizationServiceTest.assertEquals((String)"Developer role mapping incorrect", (String)"InitiableTaskProject.Developer", (String)((String)processRoles.get("Developer")));
        }
    }

    public void testOUFromProcessMetadataService() throws Exception {
        System.out.println("\n ===>>> Test name: " + this.getName());
        IBPMContext ctx = this.getContext("demoadmin", "welcome1");
        List list = this.getProcessMetadataService().listProcessMetadataSummary(ctx, null, null, null);
        String compositeDN = null;
        for (ProcessMetadataSummary p : list) {
            if (p.getStatus() != StatusEnum.ACTIVE || !"HWFM4IntegratedTestProject".equals(p.getCompositeName())) continue;
            compositeDN = p.getCompositeDN();
        }
        AbstractEndToEndOrganizationServiceTest.assertNotNull((String)"Process metadata summary not found", compositeDN);
        System.out.println("\n compositeDN is " + compositeDN);
        String ou = this.getProcessMetadataService().getOrganizationalUnit(ctx, compositeDN);
        AbstractEndToEndOrganizationServiceTest.assertEquals((String)"Organization unit incorrect", (String)"California", (String)ou);
    }

    public void testGetProcessMetadataInitiableProcess() throws Exception {
        System.out.println("\n ===>>> Test name: " + this.getName());
        IBPMContext ctx = this.getContext("demoadmin", "welcome1");
        List list = this.getProcessMetadataService().listProcessMetadataSummary(ctx, null, null, null);
        for (ProcessMetadataSummary p : list) {
            String compositeName = p.getCompositeName();
            String processId = p.getProcessId();
            System.out.println(" p.getStatus(): " + p.getStatus());
            if (!"InitiableTaskProject".equals(compositeName)) continue;
            return;
        }
        AbstractEndToEndOrganizationServiceTest.fail((String)"Process metadata summary not found for InitiableTaskProject");
    }

    public void testGetInitiableProcessMetadata() throws Exception {
        System.out.println("\n ===>>> Test name: " + this.getName());
        IBPMContext ctx = this.getContext("jcooper", "welcome1");
        List list = this.getProcessMetadataService().getInitiatableProcesses(ctx);
        boolean flag = false;
        for (ProcessMetadataSummary p : list) {
            String compositeName = p.getCompositeName();
            System.out.println(" p.getStatus(): " + p.getStatus());
            if (!"InitiableTaskProject".equals(compositeName)) continue;
            flag = true;
            return;
        }
        AbstractEndToEndOrganizationServiceTest.assertFalse((String)"Process metadata summary found for InitiableTaskProject", (boolean)flag);
    }

    public void testGetInitiableProcessMetadataNegative1() throws Exception {
        IBPMContext ctx = this.getContext("jstein", "welcome1");
        List list = this.getProcessMetadataService().getInitiatableProcesses(ctx);
        for (ProcessMetadataSummary p : list) {
            String compositeName = p.getCompositeName();
            String processId = p.getProcessId();
            if (!"InitiableTaskProject".equals(compositeName)) continue;
            AbstractEndToEndOrganizationServiceTest.fail((String)"Process metadata summary found for InitiableTaskProject for user jstein");
        }
    }

    public void testGetInitiableProcessMetadataNegative2() throws Exception {
        IBPMContext ctx = this.getContext("mmitch", "welcome1");
        List list = this.getProcessMetadataService().getInitiatableProcesses(ctx);
        for (ProcessMetadataSummary p : list) {
            String compositeName = p.getCompositeName();
            String processId = p.getProcessId();
            if (!"InitiableTaskProject".equals(compositeName)) continue;
            AbstractEndToEndOrganizationServiceTest.fail((String)"Process metadata summary found for InitiableTaskProject for user jstein");
        }
    }

    public IBPMContext getContext(String user, String password) throws Exception {
        return this.getBPMUserAuthenticationService().authenticate(user, password.toCharArray(), "jazn.com");
    }

    public Task queryTask(String user, String password, String identificationKey, String compositeName) throws Exception {
        return this.queryTask(user, password, identificationKey, compositeName, 0);
    }

    public Task queryTask(String user, String password, String identificationKey, String compositeName, int retry) throws Exception {
        IBPMContext ctx = this.getContext(user, password);
        ArrayList<String> queryColumns = new ArrayList<String>();
        queryColumns.add("TASKID");
        queryColumns.add("TASKNUMBER");
        queryColumns.add("TITLE");
        queryColumns.add("PRIORITY");
        queryColumns.add("ORGANIZATIONALUNITID");
        queryColumns.add("EXPIRATIONDATE");
        ArrayList<ITaskQueryService.OptionalInfo> optionalInfo = new ArrayList<ITaskQueryService.OptionalInfo>();
        optionalInfo.add(ITaskQueryService.OptionalInfo.ALL_ACTIONS);
        Predicate pred = new Predicate(TableConstants.WFTASK_COMPOSITENAME_COLUMN, 0, (Object)compositeName);
        Ordering descTaskNumberOrder = new Ordering(Column.getColumn((String)"TASKNUMBER"), false, true);
        List tasksList = this.getTaskQueryService().queryTasks((IWorkflowContext)ctx, queryColumns, optionalInfo, ITaskQueryService.AssignmentFilter.MY_AND_GROUP, identificationKey, pred, descTaskNumberOrder, 0, 0);
        if (tasksList.size() > 0) {
            System.out.println("Returning task " + ((Task)tasksList.get(0)).getSystemAttributes().getTaskNumber());
            return (Task)tasksList.get(0);
        }
        if (retry < 10) {
            System.out.println("Task not found. Sleeping 2 sec before retry " + (retry + 1) + " times ... ");
            Thread.sleep(3000L);
            return this.queryTask(user, password, identificationKey, compositeName, retry + 1);
        }
        return null;
    }

    public void testDynamicProcessOUAssociation1() throws Exception {
        String organizationUnitId = "DynamicProcessOUTestId" + new Random().nextInt();
        String organizationUnitName = "DynamicProcessOUTestName" + new Random().nextInt();
        String user = "weblogic";
        String compositeName = "BPMOUProj";
        OrganizationalUnit orgUnit = this.createOrganizationalUnit(this.getContext(user, "weblogic1"), organizationUnitId, organizationUnitName, null);
        String url = TestUtil.getWFWSSOAPEndPointRoot() + "/soa-infra/services/default/BPMOUProj!1.0/TestOUprocess.service";
        System.out.println("URL is " + url);
        String operation = "operation";
        String payload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body xmlns:ns=\"http://xmlns.oracle.com/bpmn/bpmnProcess/TestOUprocess\"><ns:operation><OUName>" + organizationUnitName + "</OUName>" + "</ns:operation>" + "</soap:Body>" + "</soap:Envelope>";
        this.invokeBusinessProcess(url, operation, payload);
        Task task = this.queryTask(user, "weblogic1", organizationUnitName, compositeName);
        AbstractEndToEndOrganizationServiceTest.assertNotNull((String)("Task not found for " + user), (Object)task);
        if (task != null) {
            AbstractEndToEndOrganizationServiceTest.assertEquals((String)"Organization unit id not set on task", (String)organizationUnitId, (String)task.getSystemAttributes().getOrganizationalUnitId());
        }
    }

    public void testDynamicProcessOUAssociation2() throws Exception {
        String parentOrganizationUnitId = "DynamicProcessOUParentId" + new Random().nextInt();
        String parentOrganizationUnitName = "DynamicProcessOUTestName" + new Random().nextInt();
        String childOrganizationUnitId = "DynamicProcessOUChildId" + new Random().nextInt();
        String childOrganizationUnitName = parentOrganizationUnitName;
        String user = "weblogic";
        String compositeName = "BPMOUProj";
        OrganizationalUnit parentOrgUnit = this.createOrganizationalUnit(this.getContext(user, "weblogic1"), parentOrganizationUnitId, parentOrganizationUnitName, null);
        OrganizationalUnit childOrgUnit = this.createOrganizationalUnit(this.getContext(user, "weblogic1"), childOrganizationUnitId, childOrganizationUnitName, parentOrgUnit);
        String url = TestUtil.getWFWSSOAPEndPointRoot() + "/soa-infra/services/default/BPMOUProj!1.0/TestOUprocess.service";
        System.out.println("URL is " + url);
        String operation = "operation";
        String processOUPath = parentOrganizationUnitName + "/" + childOrganizationUnitName;
        String payload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body xmlns:ns=\"http://xmlns.oracle.com/bpmn/bpmnProcess/TestOUprocess\"><ns:operation><OUName>" + processOUPath + "</OUName>" + "</ns:operation>" + "</soap:Body>" + "</soap:Envelope>";
        this.invokeBusinessProcess(url, operation, payload);
        Task task = this.queryTask(user, "weblogic1", processOUPath, compositeName);
        AbstractEndToEndOrganizationServiceTest.assertNotNull((String)("Task not found for " + user), (Object)task);
        if (task != null) {
            AbstractEndToEndOrganizationServiceTest.assertEquals((String)"Organization unit id not set on task", (String)childOrganizationUnitId, (String)task.getSystemAttributes().getOrganizationalUnitId());
        }
    }

    public OrganizationalUnit createOrganizationalUnit(IBPMContext ctx, String id, String name, OrganizationalUnit parent) throws Exception {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        OrganizationalUnit organizationalUnit = objectFactory.createOrganizationalUnit();
        organizationalUnit.setOrganizationalUnitId(id);
        String memberUser = ctx.getUser();
        organizationalUnit.setOrganizationalUnitName(name);
        organizationalUnit.setDescription("Oracle");
        organizationalUnit.setCreatedBy(memberUser);
        organizationalUnit.setCreatedByIdentityContext("jazn.com");
        organizationalUnit.setCreatedDate(calendar);
        organizationalUnit.setLastUpdatedBy(memberUser);
        organizationalUnit.setLastUpdatedByIdentityContext("jazn.com");
        organizationalUnit.setLastUpdatedDate(calendar);
        if (parent != null) {
            organizationalUnit.setParentOrganizationalUnitId(parent.getOrganizationalUnitId());
            organizationalUnit.setParentOrganizationalUnitName(parent.getOrganizationalUnitName());
            organizationalUnit.setHierarchyPath(parent.getOrganizationalUnitId() + "/" + id + "/");
        }
        MemberType user = objectFactory.createMemberType();
        user.setMemberId(Util.getGuid());
        user.setName(memberUser);
        user.setType(ParticipantTypeEnum.USER);
        user.setRealm("jazn.com");
        user.setCreatedBy(memberUser);
        user.setCreatedByIdentityContext("jazn.com");
        user.setCreatedDate(calendar);
        user.setLastUpdatedBy(memberUser);
        user.setLastUpdatedByIdentityContext("jazn.com");
        user.setLastUpdatedDate(calendar);
        organizationalUnit.getMember().add(user);
        organizationalUnit = this.getBPMOrganizationService().createOrganizationalUnit(ctx, organizationalUnit);
        return organizationalUnit;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void initiateProcess(String identificationKey) throws Exception {
        String url = TestUtil.getWFWSSOAPEndPointRoot() + "/soa-infra/services/default/HWFM4IntegratedTestProject!1.0/HWFM4IntegratedTestProcess.service";
        System.out.println("URL is " + url);
        String operation = "operation3";
        String payload = PROCESS_INPUT.replaceAll("identificationKey", identificationKey);
        this.invokeBusinessProcess(url, operation, payload);
    }

    private void invokeBusinessProcess(String urlString, String operationName, String payload) throws Exception {
        HttpURLConnection uc = null;
        URL url = null;
        byte[] data = payload.getBytes();
        url = new URL(urlString);
        System.out.println("Payload is " + payload);
        System.out.println("Payload length is " + payload.length());
        System.out.println("Data length is " + data.length);
        System.out.println("Data is " + data);
        uc = (HttpURLConnection)url.openConnection();
        uc.setDoInput(true);
        uc.setDoOutput(true);
        uc.setUseCaches(false);
        uc.setRequestProperty("Content-Length", "" + payload.length());
        uc.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
        uc.setRequestProperty("SOAPAction", operationName);
        uc.setRequestMethod("POST");
        uc.connect();
        DataOutputStream dos = new DataOutputStream(uc.getOutputStream());
        dos.write(data, 0, data.length);
        dos.flush();
        dos.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(uc.getInputStream()));
        String res = null;
        while ((res = br.readLine()) != null) {
            System.out.println(res);
        }
        br.close();
        uc.disconnect();
        System.out.println("Disconnected...");
    }

    static {
        try {
            Class<?> dataTypeFactoryClass = Class.forName("com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl");
            Constructor<?> constructor = dataTypeFactoryClass.getConstructor(new Class[0]);
            datatypeFactory = (DatatypeFactory)constructor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
    }
}

