/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.metadata.routingslip.RoutingSlipUtil;
import oracle.bpel.services.workflow.metadata.routingslip.model.RoutingSlip;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.task.IRestrictedAssignees;
import oracle.bpel.services.workflow.task.IRestrictedAssignmentCallback;
import oracle.bpel.services.workflow.task.ITaskAssignee;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.task.test.AbstractTaskServiceTest1;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.BPMInternalOrganizationService;
import oracle.bpm.services.organization.impl.BPMOrganizationService;
import oracle.bpm.services.organization.model.ApplicationContext;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMAuthorizationService;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMUser;
import oracle.tip.pc.services.identity.ComplexSearchFilter;
import oracle.tip.pc.services.identity.SearchFilter;

public abstract class AbstractBPMOrganizationTaskServiceTest
extends AbstractTaskServiceTest1 {
    private OrganizationalUnit organizationalUnit = null;
    private static oracle.bpm.services.organization.model.ObjectFactory objectFactory = new oracle.bpm.services.organization.model.ObjectFactory();
    public static IBPMContext ctx;
    private static DatatypeFactory datatypeFactory;

    public AbstractBPMOrganizationTaskServiceTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPermittedAssigneesAPI() throws Exception {
        ArrayList<String> deletePropList = new ArrayList<String>();
        OrganizationalUnit OU1 = null;
        OrganizationalUnit OU2 = null;
        ApplicationContext appCtx = objectFactory.createApplicationContext();
        appCtx.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP);
        IWorkflowContext ctx = null;
        try {
            ctx = this.getTaskQueryService().authenticate("weblogic", "weblogic1", "jazn.com", null);
            this.getBPMOrganizationService().createAppRole((IBPMContext)ctx, appCtx, "RoleA", "RoleA", "AppRole with PotentialAssignee Property");
            this.getBPMOrganizationService().createAppRole((IBPMContext)ctx, appCtx, "RoleB", "RoleB", "Potential Assignee of RoleA");
            PrincipleRefType part = objectFactory.createPrincipleRefType();
            Participant participant = null;
            ArrayList<String> appRoleMembers = new ArrayList<String>();
            appRoleMembers.add("achrist");
            appRoleMembers.add("jlondon");
            for (String user : appRoleMembers) {
                part.setName(user);
                part.setType(ParticipantTypeEnum.USER);
                participant = objectFactory.createParticipant(part);
                this.getBPMOrganizationService().grantAppRoleToPrincipal((IBPMContext)ctx, appCtx, "RoleA", participant);
            }
            appRoleMembers.removeAll(appRoleMembers);
            appRoleMembers.add("jcooper");
            appRoleMembers.add("jausten");
            appRoleMembers.add("fkafka");
            appRoleMembers.add("wfaulk");
            for (String user : appRoleMembers) {
                part.setName(user);
                part.setType(ParticipantTypeEnum.USER);
                participant = objectFactory.createParticipant(part);
                this.getBPMOrganizationService().grantAppRoleToPrincipal((IBPMContext)ctx, appCtx, "RoleB", participant);
            }
            deletePropList.add("POTENTIAL_ASSIGNEE");
            ObjectFactory objFactory = new ObjectFactory();
            IdentityType roleType = objFactory.createIdentityType();
            roleType.setId("RoleA");
            roleType.setType("application_role");
            IdentityType potentialAssigneeValue = objFactory.createIdentityType();
            potentialAssigneeValue.setId("RoleB");
            potentialAssigneeValue.setType("application_role");
            HashMap<IdentityType, IdentityType> map = new HashMap<IdentityType, IdentityType>();
            map.put(roleType, potentialAssigneeValue);
            if (!WorkflowUtil.isBPMInstall()) {
                return;
            }
            boolean flag = WorkflowUtil.getInternalOrganizationTestUtilityService().createPotentialAssigneeForUnitTest((IBPMContext)ctx, map);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((boolean)flag, (boolean)true);
            ArrayList<String> userList = new ArrayList<String>();
            userList.add("jausten");
            userList.add("wfaulk");
            userList.add("mmitch");
            userList.add("jcooper");
            OU1 = this.createOrgUnitWithUserList((IBPMContext)ctx, "OU1", userList);
            userList.add("jausten");
            userList.add("fkafka");
            userList.add("achrist");
            userList.add("jcooper");
            OU2 = this.createOrgUnitWithUserList((IBPMContext)ctx, "OU2", userList);
            this.mySetUp();
            IRestrictedAssignees restrictedAssignees = null;
            InputStream[] is = new InputStream[4];
            RoutingSlip[] rs = new RoutingSlip[4];
            for (int i = 0; i < 4; ++i) {
                is[i] = AbstractBPMOrganizationTaskServiceTest.getInputStreamFromClassLoader((String)(DATA_DIR + "RS" + i + "-RestrictedAssignemnt.xml"));
                rs[i] = (RoutingSlip)RoutingSlipUtil.getInstance().unmarshal(is[i]);
            }
            ArrayList<String> taskList = new ArrayList<String>();
            for (int i = 0; i <= 3; ++i) {
                taskList.add(this.getTaskService().initiateTask(this.createTask(DATA_DIR + "Task" + i + "-RestrictedAssignemnt.xml"), rs[i]).getTask().getSystemAttributes().getTaskId());
            }
            SearchFilter filter = AbstractBPMOrganizationTaskServiceTest.createFilter(ServiceFactory.getAuthorizationServiceInstance(), "j*");
            restrictedAssignees = this.getTaskQueryService().getPermittedAssigneesForTasks(ctx, taskList, IRestrictedAssignmentCallback.OperationType.REASSIGN.toString(), "USER", filter, null, null);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((int)2, (int)restrictedAssignees.getPermittedAssignees().size());
            ArrayList<String> assigneeIds = new ArrayList<String>();
            for (ITaskAssignee taskAssignee : restrictedAssignees.getPermittedAssignees()) {
                assigneeIds.add(taskAssignee.getName());
            }
            AbstractBPMOrganizationTaskServiceTest.assertTrue((assigneeIds.contains("jausten") && assigneeIds.contains("jcooper") ? 1 : 0) != 0);
            ArrayList<String> assigneeFirstNames = new ArrayList<String>();
            for (ITaskAssignee taskAssignee : restrictedAssignees.getPermittedAssignees()) {
                assigneeFirstNames.add(taskAssignee.getFirstName());
            }
            AbstractBPMOrganizationTaskServiceTest.assertTrue((assigneeFirstNames.contains("Jane") && assigneeFirstNames.contains("James") ? 1 : 0) != 0);
        }
        catch (WorkflowException wfe) {
            wfe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            WorkflowUtil.getInternalOrganizationTestUtilityService().deleteParticipantProperties((IBPMContext)ctx, deletePropList);
            this.getBPMOrganizationService().removeAppRole((IBPMContext)ctx, appCtx, "RoleA", true);
            this.getBPMOrganizationService().removeAppRole((IBPMContext)ctx, appCtx, "RoleB", true);
            this.deleteOrgUnit((IBPMContext)ctx, OU1.getOrganizationalUnitId());
            this.deleteOrgUnit((IBPMContext)ctx, OU2.getOrganizationalUnitId());
            this.myTearDown();
        }
    }

    public void testReassignTaskToPotentialAssignee() throws Exception {
        ArrayList<String> deletePropList = new ArrayList<String>();
        IWorkflowContext ctx = null;
        try {
            ctx = this.getTaskQueryService().authenticate("weblogic", "weblogic1", "jazn.com", null);
            deletePropList.add("POTENTIAL_ASSIGNEE");
            ObjectFactory objFactory = new ObjectFactory();
            IdentityType roleType = objFactory.createIdentityType();
            roleType.setId("BPMWorkflowAdmin");
            roleType.setType("application_role");
            IdentityType potentialAssigneeValue = objFactory.createIdentityType();
            potentialAssigneeValue.setId("BPMProcessAdmin");
            potentialAssigneeValue.setType("application_role");
            HashMap<IdentityType, IdentityType> map = new HashMap<IdentityType, IdentityType>();
            map.put(roleType, potentialAssigneeValue);
            if (!WorkflowUtil.isBPMInstall()) {
                return;
            }
            boolean flag = WorkflowUtil.getInternalOrganizationTestUtilityService().createPotentialAssigneeForUnitTest((IBPMContext)ctx, map);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((boolean)flag, (boolean)true);
            this.mySetUp();
            InputStream is = AbstractBPMOrganizationTaskServiceTest.getInputStreamFromClassLoader((String)(DATA_DIR + "RS-PotentialAssignee.xml"));
            RoutingSlip rs = (RoutingSlip)RoutingSlipUtil.getInstance().unmarshal(is);
            Task task = this.getTaskService().initiateTask(this.createTask(DATA_DIR + "Task-PotentialAssignee.xml"), rs).getTask();
            task.getSystemAttributes().setSwimlaneRole("BPMWorkflowAdmin");
            boolean isAggineesAppRole = WorkflowUtil.isCurrentAssigneeApprole((Task)task);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((boolean)true, (boolean)isAggineesAppRole);
            List taskAssignees = new ArrayList();
            IRestrictedAssignees restrictedAssignees = this.getTaskQueryService().getPermittedAssignees(ctx, task, IRestrictedAssignmentCallback.OperationType.REASSIGN.toString());
            taskAssignees = restrictedAssignees.getPermittedAssignees();
            task = this.getTaskService().reassignTask(ctx, task, taskAssignees);
            boolean check = false;
            IdentityType assigneeIdType = (IdentityType)task.getSystemAttributes().getAssignees().get(0);
            if (assigneeIdType.getType().equals("application_role") && assigneeIdType.getId().equals("BPMProcessAdmin")) {
                check = true;
            }
            AbstractBPMOrganizationTaskServiceTest.assertEquals((boolean)true, (boolean)check);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            WorkflowUtil.getInternalOrganizationTestUtilityService().deleteParticipantProperties((IBPMContext)ctx, deletePropList);
            this.myTearDown();
        }
    }

    public void testEscalateTaskToEscalationPath() throws Exception {
        ArrayList<String> deletePropList = new ArrayList<String>();
        IWorkflowContext ctx = null;
        try {
            ctx = this.getTaskQueryService().authenticate("weblogic", "weblogic1", "jazn.com", null);
            deletePropList.add("ESCALATIONPATH");
            ObjectFactory objFactory = new ObjectFactory();
            IdentityType roleType = objFactory.createIdentityType();
            roleType.setId("BPMProcessAdmin");
            roleType.setType("application_role");
            IdentityType escalationValue = objFactory.createIdentityType();
            escalationValue.setId("jstein");
            escalationValue.setType("user");
            HashMap<IdentityType, IdentityType> map = new HashMap<IdentityType, IdentityType>();
            map.put(roleType, escalationValue);
            if (!WorkflowUtil.isBPMInstall()) {
                return;
            }
            boolean flag = WorkflowUtil.getInternalOrganizationTestUtilityService().createEscalationPathForUnitTest((IBPMContext)ctx, map);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((boolean)flag, (boolean)true);
            this.mySetUp();
            InputStream is = AbstractBPMOrganizationTaskServiceTest.getInputStreamFromClassLoader((String)(DATA_DIR + "RS-EscalationPath.xml"));
            RoutingSlip rs = (RoutingSlip)RoutingSlipUtil.getInstance().unmarshal(is);
            Task task = this.getTaskService().initiateTask(this.createTask(DATA_DIR + "Task-EscalationPath.xml"), rs).getTask();
            boolean isAggineesAppRole = WorkflowUtil.isCurrentAssigneeApprole((Task)task);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((boolean)true, (boolean)isAggineesAppRole);
            TimeUnit.SECONDS.sleep(160L);
            task = this.getTaskQueryService().getTaskDetailsById(ctx, task.getSystemAttributes().getTaskId());
            String currentAssignee = WorkflowUtil.getCurrentAssignee((Task)task);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((String)"jstein", (String)currentAssignee);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            WorkflowUtil.getInternalOrganizationTestUtilityService().deleteParticipantProperties((IBPMContext)ctx, deletePropList);
            this.myTearDown();
        }
    }

    public void testEscalateTaskToMultipleEscalationPaths() throws Exception {
        ArrayList<String> deletePropList = new ArrayList<String>();
        deletePropList.add("ESCALATIONPATH");
        IWorkflowContext ctx = null;
        try {
            int i;
            ctx = this.getTaskQueryService().authenticate("weblogic", "weblogic1", "jazn.com", null);
            ObjectFactory objFactory = new ObjectFactory();
            IdentityType roleType = objFactory.createIdentityType();
            roleType.setId("BPMOrganizationAdmin");
            roleType.setType("application_role");
            IdentityType roleType2 = objFactory.createIdentityType();
            roleType2.setId("BPMWorkflowAdmin");
            roleType2.setType("application_role");
            IdentityType escalationValue = objFactory.createIdentityType();
            escalationValue.setId("jstein");
            escalationValue.setType("user");
            IdentityType escalationValue2 = objFactory.createIdentityType();
            escalationValue2.setId("jcooper");
            escalationValue2.setType("user");
            HashMap<IdentityType, IdentityType> map = new HashMap<IdentityType, IdentityType>();
            map.put(roleType, escalationValue);
            map.put(roleType2, escalationValue2);
            if (!WorkflowUtil.isBPMInstall()) {
                return;
            }
            boolean flag = WorkflowUtil.getInternalOrganizationTestUtilityService().createEscalationPathForUnitTest((IBPMContext)ctx, map);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((boolean)flag, (boolean)true);
            this.mySetUp();
            InputStream is = AbstractBPMOrganizationTaskServiceTest.getInputStreamFromClassLoader((String)(DATA_DIR + "RS-EscalationPathMultiple.xml"));
            RoutingSlip rs = (RoutingSlip)RoutingSlipUtil.getInstance().unmarshal(is);
            Task task = this.getTaskService().initiateTask(this.createTask(DATA_DIR + "Task-EscalationPathMultiple.xml"), rs).getTask();
            boolean isAggineesAppRole = WorkflowUtil.isCurrentAssigneeApprole((Task)task);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((boolean)true, (boolean)isAggineesAppRole);
            TimeUnit.SECONDS.sleep(160L);
            task = this.getTaskQueryService().getTaskDetailsById(ctx, task.getSystemAttributes().getTaskId());
            List currentAssignees = WorkflowUtil.getAllAssignees((Task)task);
            if (currentAssignees == null) {
                AbstractBPMOrganizationTaskServiceTest.fail((String)"Esacalation failed!");
            }
            BPMUser user = null;
            int count = 0;
            for (i = 0; i < currentAssignees.size(); ++i) {
                if (!(currentAssignees.get(i) instanceof BPMUser) || !(user = (BPMUser)currentAssignees.get(i)).getName().equalsIgnoreCase("jstein") && !user.getName().equalsIgnoreCase("jcooper")) continue;
                ++count;
            }
            AbstractBPMOrganizationTaskServiceTest.assertEquals((int)count, (int)i);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            WorkflowUtil.getInternalOrganizationTestUtilityService().deleteParticipantProperties((IBPMContext)ctx, deletePropList);
            this.myTearDown();
        }
    }

    public void testEscalateTaskToRoleEscalationPath() throws Exception {
        ArrayList<String> deletePropList = new ArrayList<String>();
        IWorkflowContext ctx = null;
        try {
            ctx = this.getTaskQueryService().authenticate("weblogic", "weblogic1", "jazn.com", null);
            deletePropList.add("ESCALATIONPATH");
            ObjectFactory objFactory = new ObjectFactory();
            IdentityType roleType = objFactory.createIdentityType();
            roleType.setId("DevTeam");
            roleType.setType("application_role");
            IdentityType escalationValue = objFactory.createIdentityType();
            escalationValue.setId("jstein");
            escalationValue.setType("user");
            HashMap<IdentityType, IdentityType> map = new HashMap<IdentityType, IdentityType>();
            map.put(roleType, escalationValue);
            if (!WorkflowUtil.isBPMInstall()) {
                return;
            }
            boolean flag = WorkflowUtil.getInternalOrganizationTestUtilityService().createEscalationPathForUnitTest((IBPMContext)ctx, map);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((boolean)flag, (boolean)true);
            this.mySetUp();
            InputStream is = AbstractBPMOrganizationTaskServiceTest.getInputStreamFromClassLoader((String)(DATA_DIR + "RS-RoleEscalationPath.xml"));
            RoutingSlip rs = (RoutingSlip)RoutingSlipUtil.getInstance().unmarshal(is);
            Task task = this.getTaskService().initiateTask(this.createTask(DATA_DIR + "Task-RoleEscalationPath.xml"), rs).getTask();
            boolean isAggineesAppRole = WorkflowUtil.isCurrentAssigneeApprole((Task)task);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((boolean)true, (boolean)isAggineesAppRole);
            this.getTaskService().escalateTask(ctx, task.getSystemAttributes().getTaskId());
            task = this.getTaskQueryService().getTaskDetailsById(ctx, task.getSystemAttributes().getTaskId());
            String currentAssignee = WorkflowUtil.getCurrentAssignee((Task)task);
            AbstractBPMOrganizationTaskServiceTest.assertEquals((String)"jstein", (String)currentAssignee);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            WorkflowUtil.getInternalOrganizationTestUtilityService().deleteParticipantProperties((IBPMContext)ctx, deletePropList);
            this.myTearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetParentOrgUnitForChild() {
        try {
            ctx = (IBPMContext)this.getTaskQueryService().authenticate("weblogic", "weblogic1", "jazn.com", null);
            String parentOrgUnit = null;
            this.createOrganizationalUnit("Oracle");
            OrganizationalUnit childOrganizationalUnit_1 = objectFactory.createOrganizationalUnit();
            childOrganizationalUnit_1.setOrganizationalUnitId(Util.getGuid());
            childOrganizationalUnit_1.setParentOrganizationalUnitId(this.organizationalUnit.getOrganizationalUnitId());
            childOrganizationalUnit_1.setOrganizationalUnitName("Japan");
            childOrganizationalUnit_1.setDescription("Japan");
            MemberType user1 = objectFactory.createMemberType();
            user1.setMemberId(Util.getGuid());
            user1.setName("sfitzger");
            user1.setType(ParticipantTypeEnum.USER);
            user1.setRealm("jazn.com");
            childOrganizationalUnit_1.getMember().add(user1);
            childOrganizationalUnit_1 = this.getBPMOrganizationService().createOrganizationalUnit(ctx, childOrganizationalUnit_1);
            OrganizationalUnit childOrganizationalUnit_2 = objectFactory.createOrganizationalUnit();
            childOrganizationalUnit_2.setOrganizationalUnitId(Util.getGuid());
            childOrganizationalUnit_2.setParentOrganizationalUnitId(childOrganizationalUnit_1.getOrganizationalUnitId());
            childOrganizationalUnit_2.setOrganizationalUnitName("Sales");
            childOrganizationalUnit_2.setDescription("sales");
            MemberType user2 = objectFactory.createMemberType();
            user2.setMemberId(Util.getGuid());
            user2.setName("sfitzger");
            user2.setType(ParticipantTypeEnum.USER);
            user2.setRealm("jazn.com");
            childOrganizationalUnit_2.getMember().add(user2);
            childOrganizationalUnit_2 = this.getBPMOrganizationService().createOrganizationalUnit(ctx, childOrganizationalUnit_2);
            parentOrgUnit = this.getBPMInternalOrgService().getParentOrgUnitForChild(childOrganizationalUnit_2.getOrganizationalUnitName());
            AbstractBPMOrganizationTaskServiceTest.assertEquals((String)"Parent path for the given child org unit is not correct", (String)"Oracle/Japan/", (String)parentOrgUnit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.deleteOrgUnit(ctx, this.organizationalUnit.getOrganizationalUnitId());
        }
    }

    public void testGetParentOrgUnitForInvalidChildOrg() {
        try {
            String parentOrgUnit = null;
            parentOrgUnit = this.getBPMInternalOrgService().getParentOrgUnitForChild("USA");
        }
        catch (BPMOrganizationException e) {
            int errorCode = e.getErrorCode();
            AbstractBPMOrganizationTaskServiceTest.assertEquals((String)"Exception Error code is not matching", (int)70702, (int)errorCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testGetParentOrgUnitForChildInMultiplePaths() {
        block7: {
            String indiaOrgId = null;
            String chinaOrgId = null;
            try {
                String parentOrgUnit = null;
                this.createOrganizationalUnit("India");
                OrganizationalUnit childOrganizationalUnit_1 = objectFactory.createOrganizationalUnit();
                childOrganizationalUnit_1.setOrganizationalUnitId(Util.getGuid());
                childOrganizationalUnit_1.setParentOrganizationalUnitId(this.organizationalUnit.getOrganizationalUnitId());
                childOrganizationalUnit_1.setOrganizationalUnitName("Finance");
                childOrganizationalUnit_1.setDescription("Finance");
                MemberType user1 = objectFactory.createMemberType();
                user1.setMemberId(Util.getGuid());
                user1.setName("sfitzger");
                user1.setType(ParticipantTypeEnum.USER);
                user1.setRealm("jazn.com");
                childOrganizationalUnit_1.getMember().add(user1);
                childOrganizationalUnit_1 = this.getBPMOrganizationService().createOrganizationalUnit(ctx, childOrganizationalUnit_1);
                indiaOrgId = this.organizationalUnit.getOrganizationalUnitId();
                this.createOrganizationalUnit("China");
                OrganizationalUnit childOrganizationalUnit_2 = objectFactory.createOrganizationalUnit();
                childOrganizationalUnit_2.setOrganizationalUnitId(Util.getGuid());
                childOrganizationalUnit_2.setParentOrganizationalUnitId(this.organizationalUnit.getOrganizationalUnitId());
                childOrganizationalUnit_2.setOrganizationalUnitName("Finance");
                childOrganizationalUnit_2.setDescription("Finance");
                MemberType user2 = objectFactory.createMemberType();
                user2.setMemberId(Util.getGuid());
                user2.setName("sfitzger");
                user2.setType(ParticipantTypeEnum.USER);
                user2.setRealm("jazn.com");
                childOrganizationalUnit_2.getMember().add(user2);
                childOrganizationalUnit_2 = this.getBPMOrganizationService().createOrganizationalUnit(ctx, childOrganizationalUnit_2);
                chinaOrgId = this.organizationalUnit.getOrganizationalUnitId();
                parentOrgUnit = this.getBPMInternalOrgService().getParentOrgUnitForChild(childOrganizationalUnit_2.getOrganizationalUnitName());
                this.deleteOrgUnit(ctx, indiaOrgId);
                this.deleteOrgUnit(ctx, chinaOrgId);
            }
            catch (BPMOrganizationException e) {
                int errorCode = e.getErrorCode();
                AbstractBPMOrganizationTaskServiceTest.assertEquals((String)"Exception Error code is not matching", (int)70701, (int)errorCode);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.deleteOrgUnit(ctx, indiaOrgId);
                this.deleteOrgUnit(ctx, chinaOrgId);
            }
        }
    }

    private static SearchFilter createFilter(BPMAuthorizationService svc, String queryString) throws BPMIdentityException {
        String[] sSearchableAttributes = new String[]{"name", "uid", "lastName", "firstName"};
        ComplexSearchFilter filter = svc.getSearchFilterInstance(BPMUser.class, sSearchableAttributes[0], "EQUAL", queryString);
        filter.setLogicalOperator("OR");
        for (int i = 1; i < sSearchableAttributes.length; ++i) {
            ComplexSearchFilter f = svc.getSearchFilterInstance(BPMUser.class, sSearchableAttributes[i], "EQUAL", queryString);
            filter.addFilterComponent((SearchFilter)f);
        }
        return filter;
    }

    private void deleteOrgUnit(IBPMContext ctx, String orgId) {
        try {
            this.getBPMOrganizationService().deleteOrganizationalUnit(ctx, orgId, true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BPMOrganizationService getBPMOrganizationService() throws Exception {
        BPMOrganizationService bpmInternalOrgService = new BPMOrganizationService();
        return bpmInternalOrgService;
    }

    private BPMInternalOrganizationService getBPMInternalOrgService() throws Exception {
        BPMInternalOrganizationService bpmInternalOrgService = new BPMInternalOrganizationService();
        return bpmInternalOrgService;
    }

    private void createOrganizationalUnit(String name) throws Exception {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        this.organizationalUnit = objectFactory.createOrganizationalUnit();
        this.organizationalUnit.setOrganizationalUnitId(Util.getGuid());
        this.organizationalUnit.setOrganizationalUnitName(name);
        this.organizationalUnit.setDescription(name);
        this.organizationalUnit.setCreatedBy("jstein");
        this.organizationalUnit.setCreatedByIdentityContext("jazn.com");
        this.organizationalUnit.setCreatedDate(calendar);
        this.organizationalUnit.setLastUpdatedBy("jstein");
        this.organizationalUnit.setLastUpdatedByIdentityContext("jazn.com");
        this.organizationalUnit.setLastUpdatedDate(calendar);
        MemberType manager = objectFactory.createMemberType();
        manager.setMemberId(Util.getGuid());
        manager.setName("cdickens");
        manager.setType(ParticipantTypeEnum.USER);
        manager.setRealm("jazn.com");
        manager.setCreatedBy("jstein");
        manager.setCreatedByIdentityContext("jazn.com");
        manager.setCreatedDate(calendar);
        manager.setLastUpdatedBy("jstein");
        manager.setLastUpdatedByIdentityContext("jazn.com");
        manager.setLastUpdatedDate(calendar);
        this.organizationalUnit.getManagedByMember().add(manager);
        MemberType user = objectFactory.createMemberType();
        user.setMemberId(Util.getGuid());
        user.setName("jcooper");
        user.setType(ParticipantTypeEnum.USER);
        user.setRealm("jazn.com");
        user.setCreatedBy("jstein");
        user.setCreatedByIdentityContext("jazn.com");
        user.setCreatedDate(calendar);
        user.setLastUpdatedBy("jstein");
        user.setLastUpdatedByIdentityContext("jazn.com");
        user.setLastUpdatedDate(calendar);
        this.organizationalUnit.getMember().add(user);
        this.organizationalUnit = this.getBPMOrganizationService().createOrganizationalUnit(ctx, this.organizationalUnit);
    }

    private OrganizationalUnit createOrgUnitWithUserList(IBPMContext ctx, String ouName, List<String> userList) {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        OrganizationalUnit organizationalUnit = objectFactory.createOrganizationalUnit();
        organizationalUnit.setOrganizationalUnitId(ouName + "ID");
        organizationalUnit.setOrganizationalUnitName(ouName);
        organizationalUnit.setDescription(ouName);
        organizationalUnit.setCreatedBy("jstein");
        organizationalUnit.setCreatedByIdentityContext("jazn.com");
        organizationalUnit.setCreatedDate(calendar);
        organizationalUnit.setLastUpdatedBy("jstein");
        organizationalUnit.setLastUpdatedByIdentityContext("jazn.com");
        organizationalUnit.setLastUpdatedDate(calendar);
        for (String username : userList) {
            MemberType user = objectFactory.createMemberType();
            user.setMemberId(Util.getGuid());
            user.setName(username);
            user.setType(ParticipantTypeEnum.USER);
            user.setRealm("jazn.com");
            user.setCreatedBy("jstein");
            user.setCreatedByIdentityContext("jazn.com");
            user.setCreatedDate(calendar);
            user.setLastUpdatedBy("jstein");
            user.setLastUpdatedByIdentityContext("jazn.com");
            user.setLastUpdatedDate(calendar);
            organizationalUnit.getMember().add(user);
        }
        try {
            organizationalUnit = this.getBPMOrganizationService().createOrganizationalUnit(ctx, organizationalUnit);
        }
        catch (BPMOrganizationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return organizationalUnit;
    }

    static {
        datatypeFactory = null;
        try {
            Class<?> dataTypeFactoryClass = Class.forName("com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl");
            Constructor<?> constructor = dataTypeFactoryClass.getConstructor(new Class[0]);
            datatypeFactory = (DatatypeFactory)constructor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
    }
}

