/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.test;

import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.test.TestUtil;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.impl.BPMOrganizationUtil;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociation;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.ChildOrganizationalUnitRetrievalModeTypeEnum;
import oracle.bpm.services.organization.model.HolidayPatternEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayType;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.OrganizationEntityTypeEnum;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.RoleProfileType;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;
import oracle.bpm.services.organization.model.WeekDaysEnum;
import oracle.bpm.services.organization.model.WorkPeriodType;
import oracle.bpm.services.organization.model.WorkdayListType;
import oracle.bpm.services.organization.model.WorkdayType;

public abstract class AbstractBPMOrganizationServiceTest
extends TestCase {
    private IBPMContext ctx;
    private CalendarRule mCalRul = null;
    private HolidayRule mHolRul = null;
    private OrganizationalUnit organizationalUnit = null;
    private String TEST_DATA_DIR = "oracle/bpel/services/bpm/organization/test/data/";
    public static final String REALM_NAME = "jazn.com";
    public static final String PASSWORD = "welcome1";
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static DatatypeFactory datatypeFactory = null;
    private static String IDCalendarId;
    private static String IDCHolidayListId;
    private static final String CALENDAR_NAME = "IDC Calendar";
    private static final String HOLIDAY_LIST_NAME = "IDC Holiday List";

    public AbstractBPMOrganizationServiceTest(String testName) {
        super(testName);
    }

    public abstract IBPMOrganizationService getBPMOrganizationService();

    public abstract IBPMUserAuthenticationService getBPMUserAuthenticationService();

    public static Test suite() {
        TestSuite suite = new TestSuite(AbstractBPMOrganizationServiceTest.class);
        return suite;
    }

    public IBPMContext getContext(String user) {
        try {
            return this.getBPMUserAuthenticationService().authenticate(user, PASSWORD.toCharArray(), REALM_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void createOrganizationalUnit() throws Exception {
        this.createOrganizationalUnit(1);
    }

    public void createOrganizationalUnit(int index) throws Exception {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        this.organizationalUnit = objectFactory.createOrganizationalUnit();
        this.organizationalUnit.setOrganizationalUnitId(Util.getGuid());
        this.organizationalUnit.setOrganizationalUnitName(this.getName() + index);
        this.organizationalUnit.setDescription("Oracle");
        this.organizationalUnit.setCreatedBy("jstein");
        this.organizationalUnit.setCreatedByIdentityContext(REALM_NAME);
        this.organizationalUnit.setCreatedDate(calendar);
        this.organizationalUnit.setLastUpdatedBy("jstein");
        this.organizationalUnit.setLastUpdatedByIdentityContext(REALM_NAME);
        this.organizationalUnit.setLastUpdatedDate(calendar);
        MemberType manager = objectFactory.createMemberType();
        manager.setMemberId(Util.getGuid());
        manager.setName("cdickens");
        manager.setType(ParticipantTypeEnum.USER);
        manager.setRealm(REALM_NAME);
        manager.setCreatedBy("jstein");
        manager.setCreatedByIdentityContext(REALM_NAME);
        manager.setCreatedDate(calendar);
        manager.setLastUpdatedBy("jstein");
        manager.setLastUpdatedByIdentityContext(REALM_NAME);
        manager.setLastUpdatedDate(calendar);
        this.organizationalUnit.getManagedByMember().add(manager);
        MemberType user = objectFactory.createMemberType();
        user.setMemberId(Util.getGuid());
        user.setName("jcooper");
        user.setType(ParticipantTypeEnum.USER);
        user.setRealm(REALM_NAME);
        user.setCreatedBy("jstein");
        user.setCreatedByIdentityContext(REALM_NAME);
        user.setCreatedDate(calendar);
        user.setLastUpdatedBy("jstein");
        user.setLastUpdatedByIdentityContext(REALM_NAME);
        user.setLastUpdatedDate(calendar);
        this.organizationalUnit.getMember().add(user);
        this.print(this.organizationalUnit);
        this.organizationalUnit = this.getBPMOrganizationService().createOrganizationalUnit(this.ctx, this.organizationalUnit);
    }

    public List<String> createOrganizationalUnits(int count) throws Exception {
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
            OrganizationalUnit organizationalUnit = objectFactory.createOrganizationalUnit();
            String id = Util.getGuid();
            organizationalUnit.setOrganizationalUnitId(id);
            organizationalUnit.setOrganizationalUnitName(this.getName() + (i + 1000));
            organizationalUnit.setDescription("Oracle");
            organizationalUnit.setCreatedBy("jstein");
            organizationalUnit.setCreatedByIdentityContext(REALM_NAME);
            organizationalUnit.setCreatedDate(calendar);
            organizationalUnit.setLastUpdatedBy("jstein");
            organizationalUnit.setLastUpdatedByIdentityContext(REALM_NAME);
            organizationalUnit.setLastUpdatedDate(calendar);
            this.getBPMOrganizationService().createOrganizationalUnit(this.ctx, organizationalUnit);
            orgUnitIds.add(id);
        }
        return orgUnitIds;
    }

    public void updateManager() {
        List managers = this.organizationalUnit.getManagedByMember();
        if (!this.isListNullOrEmpty(managers)) {
            MemberType manager = (MemberType)managers.get(0);
            manager.setName("UPDATED" + manager.getName());
        }
    }

    public void deleteManager(int index) {
        List managers = this.organizationalUnit.getManagedByMember();
        if (!this.isListNullOrEmpty(managers) && index >= 0 && index < this.organizationalUnit.getManagedByMember().size()) {
            this.organizationalUnit.getManagedByMember().remove(index);
        }
    }

    public void addManager(int count) {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        for (int index = 0; index < count; ++index) {
            MemberType manager = objectFactory.createMemberType();
            manager.setMemberId(Util.getGuid());
            if (index == 0) {
                manager.setName("wfaulk");
            } else {
                manager.setName("istone");
            }
            manager.setType(ParticipantTypeEnum.USER);
            manager.setRealm(REALM_NAME);
            manager.setCreatedBy("jcooper");
            manager.setCreatedByIdentityContext(REALM_NAME);
            manager.setCreatedDate(calendar);
            manager.setLastUpdatedBy("jcooper");
            manager.setLastUpdatedByIdentityContext(REALM_NAME);
            manager.setLastUpdatedDate(calendar);
            this.organizationalUnit.getManagedByMember().add(manager);
        }
    }

    public void updateUser() {
        List users = this.organizationalUnit.getMember();
        if (!this.isListNullOrEmpty(users)) {
            MemberType user = (MemberType)users.get(0);
            user.setName("UPDATED" + user.getName());
        }
    }

    public void deleteUser(int index) {
        List users = this.organizationalUnit.getMember();
        if (!this.isListNullOrEmpty(users) && index >= 0 && index < this.organizationalUnit.getMember().size()) {
            this.organizationalUnit.getMember().remove(index);
        }
    }

    public void addUser(int count) {
        XMLGregorianCalendar calendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        for (int index = 0; index < count; ++index) {
            MemberType user = objectFactory.createMemberType();
            user.setMemberId(Util.getGuid());
            if (index == 0) {
                user.setName("wfaulk");
            } else {
                user.setName("istone");
            }
            user.setType(ParticipantTypeEnum.USER);
            user.setRealm(REALM_NAME);
            user.setCreatedBy("jcooper");
            user.setCreatedByIdentityContext(REALM_NAME);
            user.setCreatedDate(calendar);
            user.setLastUpdatedBy("jcooper");
            user.setLastUpdatedByIdentityContext(REALM_NAME);
            user.setLastUpdatedDate(calendar);
            this.organizationalUnit.getMember().add(user);
        }
    }

    public boolean isListNullOrEmpty(List objects) {
        if (objects == null) {
            return true;
        }
        return objects.size() == 0;
    }

    public void testCreateOrganizationalUnit() throws Exception {
        try {
            this.createOrganizationalUnit();
            OrganizationalUnit queriedOrganizationalUnit = this.getBPMOrganizationService().getOrganizationalUnit(this.ctx, this.organizationalUnit.getOrganizationalUnitId(), ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
            AbstractBPMOrganizationServiceTest.assertEquals((String)"OrganizationalUnitId of the created OrganizationalUnit should match with the queried back OrganizationalUnit", (String)this.organizationalUnit.getOrganizationalUnitId(), (String)queriedOrganizationalUnit.getOrganizationalUnitId());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reportException(e);
        }
    }

    public void testUpdateOrganizationalUnit() throws Exception {
        try {
            String description = "Updated " + this.organizationalUnit.getDescription();
            this.organizationalUnit.setDescription(description);
            this.organizationalUnit = this.getBPMOrganizationService().updateOrganizationalUnit(this.ctx, this.organizationalUnit);
            OrganizationalUnit queriedOrganizationalUnit = this.getBPMOrganizationService().getOrganizationalUnit(this.ctx, this.organizationalUnit.getOrganizationalUnitId(), ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
            AbstractBPMOrganizationServiceTest.assertEquals((String)"Updated deccription should match with the queried back OrganizationalUnit's decsiption", (String)this.organizationalUnit.getDescription(), (String)queriedOrganizationalUnit.getDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reportException(e);
        }
    }

    public void testDeleteOrganizationalUnit() throws Exception {
        try {
            this.getBPMOrganizationService().deleteOrganizationalUnit(this.ctx, this.organizationalUnit.getOrganizationalUnitId(), false, false);
            List organizationalUnits = this.getBPMOrganizationService().searchOrganizationEntity(this.ctx, OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.EQUALS, this.organizationalUnit.getOrganizationalUnitName(), 0, 0, null);
            if (organizationalUnits != null && organizationalUnits.size() > 0) {
                AbstractBPMOrganizationServiceTest.fail((String)("Deleted OrganizationalUnit shouldn't be queried back, but got " + organizationalUnits.size() + " OrganizationalUnits"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reportException(e);
        }
    }

    public void testGetOrganizationalUnit() throws Exception {
        try {
            OrganizationalUnit queriedOrganizationalUnit = this.getBPMOrganizationService().getOrganizationalUnit(this.ctx, this.organizationalUnit.getOrganizationalUnitId(), ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
            AbstractBPMOrganizationServiceTest.assertEquals((String)"OrganizationalUnitId should match with the queried back OrganizationalUnit", (String)this.organizationalUnit.getOrganizationalUnitId(), (String)queriedOrganizationalUnit.getOrganizationalUnitId());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reportException(e);
        }
    }

    public void testGetOrganizationalUnitForUser() throws Exception {
        try {
            OrganizationalUnit childOrganizationalUnit = objectFactory.createOrganizationalUnit();
            childOrganizationalUnit.setOrganizationalUnitId(Util.getGuid());
            childOrganizationalUnit.setParentOrganizationalUnitId(this.organizationalUnit.getOrganizationalUnitId());
            childOrganizationalUnit.setOrganizationalUnitName(this.getName());
            childOrganizationalUnit.setDescription("Oracle");
            MemberType user = objectFactory.createMemberType();
            user.setMemberId(Util.getGuid());
            user.setName("sfitzger");
            user.setType(ParticipantTypeEnum.USER);
            user.setRealm(REALM_NAME);
            childOrganizationalUnit.getMember().add(user);
            this.print(childOrganizationalUnit);
            childOrganizationalUnit = this.getBPMOrganizationService().createOrganizationalUnit(this.ctx, childOrganizationalUnit);
            List queriedOrganizationalUnitList = this.getBPMOrganizationService().getOrganizationalUnitForUser(this.ctx, "sfitzger", REALM_NAME, true);
            AbstractBPMOrganizationServiceTest.assertNotNull((String)"List of direct OrganizationalUnits for an user cannot be null", (Object)queriedOrganizationalUnitList);
            AbstractBPMOrganizationServiceTest.assertEquals((String)"Number of direct OrganizationalUnits for an user is not correct", (int)1, (int)queriedOrganizationalUnitList.size());
            for (OrganizationalUnit queriedOrganizationalUnit : queriedOrganizationalUnitList) {
                if (queriedOrganizationalUnit.getOrganizationalUnitId().equals(childOrganizationalUnit.getOrganizationalUnitId())) continue;
                AbstractBPMOrganizationServiceTest.fail((String)"OrganizationalUnitId for direct OrganizationalUnits for an user is not matching");
            }
            queriedOrganizationalUnitList = this.getBPMOrganizationService().getOrganizationalUnitForUser(this.ctx, "sfitzger", REALM_NAME, false);
            AbstractBPMOrganizationServiceTest.assertNotNull((String)"List of all OrganizationalUnits for an user cannot be null", (Object)queriedOrganizationalUnitList);
            AbstractBPMOrganizationServiceTest.assertEquals((String)"Number of all OrganizationalUnits for an user is not correct", (int)2, (int)queriedOrganizationalUnitList.size());
            for (OrganizationalUnit queriedOrganizationalUnit : queriedOrganizationalUnitList) {
                if (queriedOrganizationalUnit.getOrganizationalUnitId().equals(this.organizationalUnit.getOrganizationalUnitId()) || queriedOrganizationalUnit.getOrganizationalUnitId().equals(childOrganizationalUnit.getOrganizationalUnitId())) continue;
                AbstractBPMOrganizationServiceTest.fail((String)"OrganizationalUnitId for all OrganizationalUnits for an user is not matching");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reportException(e);
        }
    }

    public void testSearchOrganizationalUnit() throws Exception {
        try {
            String organizationUnitName = this.organizationalUnit.getOrganizationalUnitName();
            String searchOranizationalUnitName = organizationUnitName.substring(0, organizationUnitName.length() - 2);
            List organizationalUnits = this.getBPMOrganizationService().searchOrganizationEntity(this.ctx, OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.STARTS_WITH, searchOranizationalUnitName, 0, 0, null);
            OrganizationalUnit queriedOrganizationalUnit = (OrganizationalUnit)organizationalUnits.get(0);
            AbstractBPMOrganizationServiceTest.assertEquals((String)"OrganizationalUnitName should match with the searched back OrganizationalUnit", (String)this.organizationalUnit.getOrganizationalUnitName(), (String)queriedOrganizationalUnit.getOrganizationalUnitName());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reportException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchOrganizationalUnitPagination() throws Exception {
        List<Object> ids = new ArrayList();
        try {
            ids = this.createOrganizationalUnits(10);
            List organizationalUnits = this.getBPMOrganizationService().searchOrganizationEntity(this.ctx, OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.LIKE, "testSearchOrganizationalUnitPagination%", 0, 4, null);
            AbstractBPMOrganizationServiceTest.assertTrue((String)("Expected 5 OUs to be returned but got " + organizationalUnits.size() + " OUs"), (organizationalUnits.size() == 5 ? 1 : 0) != 0);
            organizationalUnits = this.getBPMOrganizationService().searchOrganizationEntity(this.ctx, OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.LIKE, "testSearchOrganizationalUnitPagination%", 5, 9, null);
            AbstractBPMOrganizationServiceTest.assertTrue((String)("Expected 5 OUs to be returned but got " + organizationalUnits.size() + " OUs"), (organizationalUnits.size() == 5 ? 1 : 0) != 0);
            organizationalUnits = this.getBPMOrganizationService().searchOrganizationEntity(this.ctx, OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.LIKE, "testSearchOrganizationalUnitPagination%", 0, 0, null);
            AbstractBPMOrganizationServiceTest.assertTrue((String)("Expected 10 OUs to be returned but got " + organizationalUnits.size() + " OUs"), (organizationalUnits.size() == 10 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reportException(e);
        }
        finally {
            for (int i = 0; i < 10; ++i) {
                this.purgeOrganization((String)ids.get(i));
            }
        }
    }

    public void testCreateOrganizationalUnitManagers() throws Exception {
        try {
            System.out.println("Original OU managers:" + this.organizationalUnit.getManagedByMember().size());
            OrganizationalUnit queriedOrganizationalUnit = this.getBPMOrganizationService().getOrganizationalUnit(this.ctx, this.organizationalUnit.getOrganizationalUnitId(), ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
            List queriedManagers = queriedOrganizationalUnit.getManagedByMember();
            System.out.println("Queried back OU managers:" + queriedManagers.size());
            AbstractBPMOrganizationServiceTest.assertEquals((String)"Queried back OrganizationalUnit should have the same set of    managedBymembers", (int)this.organizationalUnit.getManagedByMember().size(), (int)queriedOrganizationalUnit.getManagedByMember().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reportException(e);
        }
    }

    public HolidayRule createHolidayRule() throws BPMOrganizationException, BPMException {
        IBPMContext ctx = this.createWFContext(TestUtil.getEJBUser(), TestUtil.getEJBCred(), REALM_NAME);
        HolidayRule holRul = this.getTestHolidayRule(IDCHolidayListId, HOLIDAY_LIST_NAME);
        this.mHolRul = this.getBPMOrganizationService().createHolidayRule(ctx, holRul);
        System.out.println("Returned Holiday Rule id : " + this.mHolRul.getId());
        return this.mHolRul;
    }

    public HolidayRule getTestHolidayRule(String holidayListId, String holidayListName) {
        HolidayRule holRul = objectFactory.createHolidayRule();
        holRul.setName(holidayListName);
        holRul.setId(holidayListId);
        List holidayList = holRul.getHolidays();
        HolidayType holiday = objectFactory.createHolidayType();
        holiday.setName("New year day");
        holiday.setHolidayPattern(HolidayPatternEnum.SAME_DAY_EVERY_YEAR);
        Calendar cal = Calendar.getInstance();
        cal.set(2009, 0, 1, 1, 1, 1);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList.add(holiday);
        holiday = objectFactory.createHolidayType();
        holiday.setName("Independence day");
        holiday.setHolidayPattern(HolidayPatternEnum.SAME_DAY_EVERY_YEAR);
        cal = Calendar.getInstance();
        cal.set(2009, 7, 15, 1, 1, 1);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList.add(holiday);
        holiday = objectFactory.createHolidayType();
        holiday.setName("Christmas");
        holiday.setHolidayPattern(HolidayPatternEnum.SAME_DAY_EVERY_YEAR);
        cal = Calendar.getInstance();
        cal.set(2009, 11, 25, 1, 1, 1);
        holiday.setHolidayDate(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        holidayList.add(holiday);
        holiday = objectFactory.createHolidayType();
        holiday.setName("Christmas Eve");
        holiday.setHolidayPattern(HolidayPatternEnum.NTH_DAY_OF_REF_HOLIDAY);
        holiday.setNth(BigInteger.valueOf(-1L));
        holiday.setRefHoliday("Christmas");
        holidayList.add(holiday);
        return holRul;
    }

    public CalendarRule createCalendarRule() throws BPMOrganizationException, BPMException {
        return this.createCalendarRule(CALENDAR_NAME, IDCalendarId);
    }

    public CalendarRule createCalendarRule(String name, String calendarId) throws BPMOrganizationException, BPMException {
        IBPMContext ctx = this.createWFContext(TestUtil.getEJBUser(), TestUtil.getEJBCred(), REALM_NAME);
        CalendarRule calRul = objectFactory.createCalendarRule();
        calRul.setName(name);
        calRul.setId(calendarId);
        calRul.setTimeZone("Asia/Calcutta");
        WorkdayListType workList = objectFactory.createWorkdayListType();
        List wList = workList.getWorkday();
        wList.add(this.getWeekDay("Monday"));
        wList.add(this.getWeekDay("Tuesday"));
        wList.add(this.getWeekDay("Wednesday"));
        wList.add(this.getWeekDay("Thursday"));
        wList.add(this.getWeekDay("Friday"));
        calRul.setWorkdayList(workList);
        calRul.setHolidayRuleName(HOLIDAY_LIST_NAME);
        calRul.setHolidayRuleId(IDCHolidayListId);
        this.mCalRul = this.getBPMOrganizationService().createCalendarRule(ctx, calRul);
        System.out.println("Returned Calendar  Rule id : " + this.mCalRul.getId());
        return this.mCalRul;
    }

    public void testCreateCalendarRule() {
        System.out.println("========== testCreateCalendarRule ==========");
        try {
            AbstractBPMOrganizationServiceTest.assertTrue((this.mCalRul != null && this.mCalRul.getId().equals(IDCalendarId) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing testCreateCalendarRule : " + e.getMessage()));
        }
    }

    public void testNegetiveCreateCalendarRule() {
        System.out.println("========== testNegetiveCreateCalendarRule ==========");
        boolean cannotCreateError = false;
        CalendarRule calRul = null;
        try {
            IBPMContext bpmCtx = this.createWFContext("jcooper", PASSWORD, REALM_NAME);
            calRul = objectFactory.createCalendarRule();
            calRul.setName("NegetiveTestIDC Calendar");
            calRul.setId("NegetiveTest" + IDCalendarId);
            calRul.setTimeZone("Asia/Calcutta");
            WorkdayListType workList = objectFactory.createWorkdayListType();
            List wList = workList.getWorkday();
            wList.add(this.getWeekDay("Monday"));
            wList.add(this.getWeekDay("Tuesday"));
            wList.add(this.getWeekDay("Wednesday"));
            wList.add(this.getWeekDay("Thursday"));
            wList.add(this.getWeekDay("Friday"));
            calRul.setWorkdayList(workList);
            calRul.setHolidayRuleName("NegetiveTest IDC Holiday List");
            calRul = this.getBPMOrganizationService().createCalendarRule(bpmCtx, calRul);
            System.out.println("Returned Calendar  Rule id : " + calRul.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            cannotCreateError = true;
        }
        AbstractBPMOrganizationServiceTest.assertTrue((boolean)cannotCreateError);
    }

    public void testCreateHolidayRule() {
        System.out.println("========== testCreateHolidayRule ==========");
        try {
            AbstractBPMOrganizationServiceTest.assertTrue((this.mHolRul != null && this.mHolRul.getId().equals(IDCHolidayListId) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing CreateCalendarRule : " + e.getMessage()));
        }
    }

    public void testSearchCalendarRule() {
        System.out.println("========== testSearchCalendarRule ==========");
        try {
            IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
            List list = this.getBPMOrganizationService().searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.CALENDAR_RULE, SearchModeTypeEnum.LIKE, "%IDC Calendar%", 0, 0, null);
            System.out.println("No of Calendars : " + list.size());
            AbstractBPMOrganizationServiceTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            for (int i = 0; i < list.size(); ++i) {
                System.out.println("----------------------------------------------------------------------------");
                System.out.println(BPMOrganizationUtil.getJaxbObjectXMLAsString(list.get(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing testSearchCalendarRule: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchCalendarRulePagination() throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            for (int i = 1; i <= 10; ++i) {
                String id = Util.getGuid();
                ids.add(id);
                this.createCalendarRule("TestCalendarPagination" + i, id);
            }
            List returnList = this.getBPMOrganizationService().searchOrganizationEntity(this.ctx, OrganizationEntityTypeEnum.CALENDAR_RULE, SearchModeTypeEnum.LIKE, "TestCalendarPagination%", 0, 4, null);
            AbstractBPMOrganizationServiceTest.assertEquals((String)("Expected 5 calendar rules to be returned but got " + returnList.size()), (int)5, (int)returnList.size());
            returnList = this.getBPMOrganizationService().searchOrganizationEntity(this.ctx, OrganizationEntityTypeEnum.CALENDAR_RULE, SearchModeTypeEnum.LIKE, "TestCalendarPagination%", 5, 9, null);
            AbstractBPMOrganizationServiceTest.assertEquals((String)("Expected 5 calendar rules to be returned but got " + returnList.size()), (int)5, (int)returnList.size());
            returnList = this.getBPMOrganizationService().searchOrganizationEntity(this.ctx, OrganizationEntityTypeEnum.CALENDAR_RULE, SearchModeTypeEnum.LIKE, "TestCalendarPagination%", 0, 0, null);
            AbstractBPMOrganizationServiceTest.assertEquals((String)("Expected 10 calendar rules to be returned but got " + returnList.size()), (int)10, (int)returnList.size());
        }
        catch (BPMOrganizationException e) {
            for (int i = 0; i < ids.size(); ++i) {
                this.getBPMOrganizationService().deleteCalendarRule(this.ctx, (String)ids.get(i), false);
            }
        }
        catch (BPMException e) {
            for (int i = 0; i < ids.size(); ++i) {
                this.getBPMOrganizationService().deleteCalendarRule(this.ctx, (String)ids.get(i), false);
            }
        }
        finally {
            for (int i = 0; i < ids.size(); ++i) {
                this.getBPMOrganizationService().deleteCalendarRule(this.ctx, (String)ids.get(i), false);
            }
        }
    }

    public void testSearchHolidayRule() {
        System.out.println("========== testSearchHolidayRule ==========");
        try {
            IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
            List hlist = this.getBPMOrganizationService().searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.HOLIDAY_RULE, SearchModeTypeEnum.EQUALS, HOLIDAY_LIST_NAME, 0, 0, null);
            System.out.println("No of Holiday Rules : " + hlist.size());
            AbstractBPMOrganizationServiceTest.assertTrue((hlist.size() == 1 ? 1 : 0) != 0);
            for (int i = 0; i < hlist.size(); ++i) {
                System.out.println("----------------------------------------------------------------------------");
                System.out.println(BPMOrganizationUtil.getJaxbObjectXMLAsString(hlist.get(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing testSearchHolidayRule: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchHolidayRulePagination() throws Exception {
        System.out.println("========== testSearchHolidayRulePagination ==========");
        ArrayList<String> ids = new ArrayList<String>();
        try {
            IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
            for (int i = 0; i < 10; ++i) {
                String id = Util.getGuid();
                ids.add(id);
                this.getBPMOrganizationService().createHolidayRule(ctx, this.getTestHolidayRule((String)ids.get(i), "TESTHOLIDAYPAGINATION" + i));
            }
            List hlist = this.getBPMOrganizationService().searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.HOLIDAY_RULE, SearchModeTypeEnum.LIKE, "TESTHOLIDAYPAGINATION%", 0, 4, null);
            AbstractBPMOrganizationServiceTest.assertTrue((String)("Expected 5 holiday rules to be display but got " + hlist.size()), (hlist.size() == 5 ? 1 : 0) != 0);
            hlist = this.getBPMOrganizationService().searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.HOLIDAY_RULE, SearchModeTypeEnum.LIKE, "TESTHOLIDAYPAGINATION%", 5, 9, null);
            AbstractBPMOrganizationServiceTest.assertTrue((String)("Expected 5 holiday rules to be display but got " + hlist.size()), (hlist.size() == 5 ? 1 : 0) != 0);
            hlist = this.getBPMOrganizationService().searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.HOLIDAY_RULE, SearchModeTypeEnum.LIKE, "TESTHOLIDAYPAGINATION%", 0, 0, null);
            AbstractBPMOrganizationServiceTest.assertTrue((String)("Expected 10 holiday rules to be display but got " + hlist.size()), (hlist.size() == 10 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing testSearchHolidayRule: " + e.getMessage()));
        }
        finally {
            for (int i = 0; i < ids.size(); ++i) {
                this.getBPMOrganizationService().deleteHolidayRule(this.ctx, (String)ids.get(i), false);
            }
        }
    }

    public void testGetCalendarRule() {
        System.out.println("========== testGetCalendarRule ==========");
        try {
            IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
            CalendarRule cal = this.getBPMOrganizationService().getCalendarRule(ctx, IDCalendarId);
            System.out.println("----------------------------------------------------------------------------");
            System.out.println(BPMOrganizationUtil.getJaxbObjectXMLAsString(cal));
            AbstractBPMOrganizationServiceTest.assertTrue((cal != null && cal.getId().equals(IDCalendarId) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing testGetCalendarRule: " + e.getMessage()));
        }
    }

    public void testGetHolidayRule() {
        System.out.println("========== testGetHolidayRule ==========");
        try {
            IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
            HolidayRule hol = this.getBPMOrganizationService().getHolidayRule(ctx, IDCHolidayListId);
            System.out.println("----------------------------------------------------------------------------");
            System.out.println(BPMOrganizationUtil.getJaxbObjectXMLAsString(hol));
            AbstractBPMOrganizationServiceTest.assertTrue((hol != null && hol.getId().equals(IDCHolidayListId) ? 1 : 0) != 0);
            boolean christmasFound = false;
            List jaxHolidayList = hol.getHolidays();
            for (int i = 0; jaxHolidayList != null && i < jaxHolidayList.size(); ++i) {
                HolidayType jaxHoliday = (HolidayType)jaxHolidayList.get(i);
                XMLGregorianCalendar holidayDate = jaxHoliday.getHolidayDate();
                if (holidayDate == null || holidayDate.getDay() != 25 || holidayDate.getMonth() != 12) continue;
                christmasFound = true;
            }
            AbstractBPMOrganizationServiceTest.assertTrue((boolean)christmasFound);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing testGetHolidayRule: " + e.getMessage()));
        }
    }

    public void testCalendarRuleHolidayAssociation() {
        System.out.println("============ testCalendarHolidayAssociation ==========");
        try {
            IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
            CalendarRule cal = this.getBPMOrganizationService().getCalendarRule(ctx, IDCalendarId);
            System.out.println("----------------------------------------------------------------------------");
            System.out.println(BPMOrganizationUtil.getJaxbObjectXMLAsString(cal));
            AbstractBPMOrganizationServiceTest.assertTrue((cal.getHolidayRuleId() != null ? 1 : 0) != 0);
            cal.setHolidayRuleId(null);
            this.getBPMOrganizationService().updateCalendarRule(ctx, cal);
            cal = this.getBPMOrganizationService().getCalendarRule(ctx, IDCalendarId);
            AbstractBPMOrganizationServiceTest.assertTrue((cal.getHolidayRuleId() == null ? 1 : 0) != 0);
            cal.setHolidayRuleId(IDCHolidayListId);
            this.getBPMOrganizationService().updateCalendarRule(ctx, cal);
            cal = this.getBPMOrganizationService().getCalendarRule(ctx, IDCalendarId);
            AbstractBPMOrganizationServiceTest.assertTrue((cal.getHolidayRuleId() != null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing testCalendarHolidayAssociation: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testUpdateCalendarRule() {
        System.out.println("========== testUpdateCalendarRule ==========");
        CalendarRule cal = null;
        IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
        HolidayRule holRul = this.getTestHolidayRule("test" + IDCHolidayListId, "testIDC Holiday List");
        holRul = this.getBPMOrganizationService().createHolidayRule(ctx, holRul);
        cal = this.getBPMOrganizationService().getCalendarRule(ctx, IDCalendarId);
        cal.setName("IDC Calendar_2009");
        cal.setHolidayRuleId(holRul.getId());
        cal.setHolidayRuleName(holRul.getName());
        cal = this.getBPMOrganizationService().updateCalendarRule(ctx, cal);
        System.out.println("----------------------------------------------------------------------------");
        System.out.println(BPMOrganizationUtil.getJaxbObjectXMLAsString(cal));
        AbstractBPMOrganizationServiceTest.assertTrue((boolean)cal.getName().equals("IDC Calendar_2009"));
        if (cal == null) return;
        try {
            cal.setHolidayRuleId(IDCHolidayListId);
            cal.setHolidayRuleName(HOLIDAY_LIST_NAME);
            this.getBPMOrganizationService().updateCalendarRule(this.ctx, cal);
            this.getBPMOrganizationService().deleteHolidayRule(this.ctx, "test" + IDCHolidayListId, false);
            return;
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return;
        catch (Exception e) {
            try {
                e.printStackTrace();
                AbstractBPMOrganizationServiceTest.fail((String)("Exception performing testUpdateCalendarRule: " + e.getMessage()));
                if (cal == null) return;
            }
            catch (Throwable throwable) {
                if (cal == null) throw throwable;
                try {
                    cal.setHolidayRuleId(IDCHolidayListId);
                    cal.setHolidayRuleName(HOLIDAY_LIST_NAME);
                    this.getBPMOrganizationService().updateCalendarRule(this.ctx, cal);
                    this.getBPMOrganizationService().deleteHolidayRule(this.ctx, "test" + IDCHolidayListId, false);
                    throw throwable;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                throw throwable;
            }
            try {
                cal.setHolidayRuleId(IDCHolidayListId);
                cal.setHolidayRuleName(HOLIDAY_LIST_NAME);
                this.getBPMOrganizationService().updateCalendarRule(this.ctx, cal);
                this.getBPMOrganizationService().deleteHolidayRule(this.ctx, "test" + IDCHolidayListId, false);
                return;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return;
        }
    }

    public void testUpdateHolidayRule() {
        System.out.println("============ testUpdateHolidayRule ==========");
        try {
            IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
            HolidayRule hol = this.getBPMOrganizationService().getHolidayRule(ctx, IDCHolidayListId);
            hol.setName("IDC Holiday List_2009");
            hol = this.getBPMOrganizationService().updateHolidayRule(ctx, hol);
            System.out.println("----------------------------------------------------------------------------");
            System.out.println(BPMOrganizationUtil.getJaxbObjectXMLAsString(hol));
            AbstractBPMOrganizationServiceTest.assertTrue((boolean)hol.getName().equals("IDC Holiday List_2009"));
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing testUpdateHolidayRule: " + e.getMessage()));
        }
    }

    public void testNegetiveDeleteHolidayRuleReferredByCalendarRule() {
        System.out.println("========== testNegetiveDeleteHolidayRuleReferredByCalendarRule ==========");
        boolean passed = false;
        try {
            IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
            this.getBPMOrganizationService().deleteHolidayRule(ctx, IDCHolidayListId, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            passed = true;
        }
        AbstractBPMOrganizationServiceTest.assertTrue((boolean)passed);
    }

    public void testDeleteCalendarRuleHolidayRule() {
        System.out.println("========== testDeleteCalendarRuleHolidayRule ==========");
        try {
            IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
            this.deleteCalendarRule();
            CalendarRule cal = this.getBPMOrganizationService().getCalendarRule(ctx, IDCalendarId);
            AbstractBPMOrganizationServiceTest.assertTrue((cal == null ? 1 : 0) != 0);
            this.deleteHolidayRule();
            HolidayRule hol = this.getBPMOrganizationService().getHolidayRule(ctx, IDCHolidayListId);
            AbstractBPMOrganizationServiceTest.assertTrue((hol == null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing testDeleteCalendarRuleHolidayRule: " + e.getMessage()));
        }
    }

    public IBPMContext createWFContext(String user, String password, String realm) throws BPMException {
        return this.getBPMUserAuthenticationService().authenticate(user, password.toCharArray(), realm);
    }

    public void deleteCalendarRule() throws BPMOrganizationException, BPMException {
        IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
        this.getBPMOrganizationService().deleteCalendarRule(ctx, IDCalendarId, false);
        this.mCalRul = null;
    }

    public void deleteHolidayRule() throws BPMOrganizationException, BPMException {
        IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
        this.getBPMOrganizationService().deleteHolidayRule(ctx, IDCHolidayListId, false);
        this.mHolRul = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateApplicationRoleOrganizationalUnitCalendarAssociation() {
        CalendarRule calendar = null;
        ApplicationRoleOrgUnitCalendarAssociation association = null;
        try {
            calendar = this.createSimpleCalendar(1);
            RoleProfileType appRole = objectFactory.createRoleProfileType();
            appRole.setName("BPMWorkflowAdmin");
            appRole.setApplicationContext("soa-infra");
            association = objectFactory.createApplicationRoleOrgUnitCalendarAssociation();
            association.setApplicationRoleOrgUnitCalendarAssociationId(Util.getGuid());
            association.setCalendarRuleId(calendar.getId());
            association.setOrganizationalUnitId(this.organizationalUnit.getOrganizationalUnitId());
            association.setApplicationRole(appRole);
            association = this.getBPMOrganizationService().createApplicationRoleOrgUnitCalendarAssociation(this.ctx, association);
            List queriedAssociations = this.getBPMOrganizationService().getApplicationRoleOrgUnitCalendarAssociation(this.ctx, objectFactory.createRoleProfile(appRole));
            AbstractBPMOrganizationServiceTest.assertNotNull((String)"Queried list of associations cannot be null", (Object)queriedAssociations);
            AbstractBPMOrganizationServiceTest.assertEquals((String)"Queried number of associations should be 1", (int)1, (int)queriedAssociations.size());
            AbstractBPMOrganizationServiceTest.assertEquals((String)"Queried association Id should match", (String)association.getApplicationRoleOrgUnitCalendarAssociationId(), (String)((ApplicationRoleOrgUnitCalendarAssociation)queriedAssociations.get(0)).getApplicationRoleOrgUnitCalendarAssociationId());
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing " + this.getName() + " : " + e.getMessage()));
        }
        finally {
            if (association != null) {
                try {
                    this.getBPMOrganizationService().deleteApplicationRoleOrgUnitCalendarAssociation(this.ctx, association.getApplicationRoleOrgUnitCalendarAssociationId());
                }
                catch (Exception exception) {}
            }
            this.deleteSimpleCalendar(calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testUpdateApplicationRoleOrganizationalUnitCalendarAssociation2() {
        ApplicationRoleOrgUnitCalendarAssociation association;
        CalendarRule calendar2;
        CalendarRule calendar1;
        block12: {
            calendar1 = null;
            calendar2 = null;
            association = null;
            try {
                calendar1 = this.createSimpleCalendar(1);
                RoleProfileType appRole = objectFactory.createRoleProfileType();
                appRole.setName("BPMWorkflowAdmin2");
                appRole.setApplicationContext("soa-infra");
                association = objectFactory.createApplicationRoleOrgUnitCalendarAssociation();
                association.setApplicationRoleOrgUnitCalendarAssociationId(Util.getGuid());
                association.setCalendarRuleId(calendar1.getId());
                association.setOrganizationalUnitId(this.organizationalUnit.getOrganizationalUnitId());
                association.setApplicationRole(appRole);
                association = this.getBPMOrganizationService().createApplicationRoleOrgUnitCalendarAssociation(this.ctx, association);
                calendar2 = this.createSimpleCalendar(2);
                association.setCalendarRuleId(calendar2.getId());
                association = this.getBPMOrganizationService().updateApplicationRoleOrgUnitCalendarAssociation(this.ctx, association);
                List queriedAssociations = this.getBPMOrganizationService().getApplicationRoleOrgUnitCalendarAssociation(this.ctx, objectFactory.createRoleProfile(appRole));
                AbstractBPMOrganizationServiceTest.assertNotNull((String)"Queried list of associations cannot be null", (Object)queriedAssociations);
                AbstractBPMOrganizationServiceTest.assertEquals((String)"Queried number of associations should be 1", (int)1, (int)queriedAssociations.size());
                AbstractBPMOrganizationServiceTest.assertEquals((String)"Queried association Id should match", (String)association.getApplicationRoleOrgUnitCalendarAssociationId(), (String)((ApplicationRoleOrgUnitCalendarAssociation)queriedAssociations.get(0)).getApplicationRoleOrgUnitCalendarAssociationId());
                AbstractBPMOrganizationServiceTest.assertEquals((String)"Queried association calender Id should match", (String)association.getCalendarRuleId(), (String)((ApplicationRoleOrgUnitCalendarAssociation)queriedAssociations.get(0)).getCalendarRuleId());
                if (association == null) break block12;
            }
            catch (Exception e) {
                e.printStackTrace();
                AbstractBPMOrganizationServiceTest.fail((String)("Exception performing " + this.getName() + " : " + e.getMessage()));
                return;
            }
            try {
                this.getBPMOrganizationService().deleteApplicationRoleOrgUnitCalendarAssociation(this.ctx, association.getApplicationRoleOrgUnitCalendarAssociationId());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.deleteSimpleCalendar(calendar1);
        this.deleteSimpleCalendar(calendar2);
        return;
        finally {
            if (association != null) {
                try {
                    this.getBPMOrganizationService().deleteApplicationRoleOrgUnitCalendarAssociation(this.ctx, association.getApplicationRoleOrgUnitCalendarAssociationId());
                }
                catch (Exception e) {}
            }
            this.deleteSimpleCalendar(calendar1);
            this.deleteSimpleCalendar(calendar2);
        }
    }

    /*
     * Exception decompiling
     */
    public void testUpdateApplicationRoleOrganizationalUnitCalendarAssociation() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteApplicationRoleOrganizationalUnitCalendarAssociation() {
        CalendarRule calendar = null;
        try {
            calendar = this.createSimpleCalendar(1);
            RoleProfileType appRole = objectFactory.createRoleProfileType();
            appRole.setName("BPMWorkflowAdmin");
            appRole.setApplicationContext("soa-infra");
            ApplicationRoleOrgUnitCalendarAssociation association = objectFactory.createApplicationRoleOrgUnitCalendarAssociation();
            association.setApplicationRoleOrgUnitCalendarAssociationId(Util.getGuid());
            association.setCalendarRuleId(calendar.getId());
            association.setOrganizationalUnitId(this.organizationalUnit.getOrganizationalUnitId());
            association.setApplicationRole(appRole);
            association = this.getBPMOrganizationService().createApplicationRoleOrgUnitCalendarAssociation(this.ctx, association);
            this.getBPMOrganizationService().deleteApplicationRoleOrgUnitCalendarAssociation(this.ctx, association.getApplicationRoleOrgUnitCalendarAssociationId());
            List queriedAssociations = this.getBPMOrganizationService().getApplicationRoleOrgUnitCalendarAssociation(this.ctx, objectFactory.createRoleProfile(appRole));
            AbstractBPMOrganizationServiceTest.assertNotNull((String)"Queried list of associations cannot be null", (Object)queriedAssociations);
            AbstractBPMOrganizationServiceTest.assertEquals((String)"Queried number of associations should be 0", (int)0, (int)queriedAssociations.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractBPMOrganizationServiceTest.fail((String)("Exception performing " + this.getName() + " : " + e.getMessage()));
        }
        finally {
            this.deleteSimpleCalendar(calendar);
        }
    }

    protected void setUp() {
        this.ctx = this.getContext("demoadmin");
        this.purgeOrganization();
        try {
            if (!this.getName().equals("testCreateOrganizationalUnit") && !this.getName().equals("testSearchOrganizationalUnitPagination") && this.getName().indexOf("OrganizationalUnit") != -1) {
                this.createOrganizationalUnit();
            }
            if (this.getName().indexOf("CalendarRule") != -1 || this.getName().indexOf("HolidayRule") != -1) {
                this.createHolidayRule();
                this.createCalendarRule();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        this.purgeOrganization();
        try {
            if (this.getName().indexOf("CalendarRule") != -1 || this.getName().indexOf("HolidayRule") != -1) {
                this.deleteCalendarRule();
                this.deleteHolidayRule();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void purgeOrganization() {
        if (this.organizationalUnit != null) {
            this.purgeOrganization(this.organizationalUnit.getOrganizationalUnitId());
        }
    }

    private void purgeOrganization(String organizationalUnitId) {
        try {
            if (!this.getName().equals("testDeleteOrganizationalUnit") && organizationalUnitId != null) {
                this.getBPMOrganizationService().deleteOrganizationalUnit(this.ctx, organizationalUnitId, true, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("purgeOrganization failed while performing test (" + this.getName() + ") with the error: " + e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    private void reportError(String errorMessage) {
        AbstractBPMOrganizationServiceTest.fail((String)errorMessage);
    }

    private void reportException(Exception exception) {
        AbstractBPMOrganizationServiceTest.fail((String)exception.toString());
    }

    private void print(OrganizationalUnit ou) {
        if (ou != null) {
            System.out.println("Id:" + ou.getOrganizationalUnitId());
            System.out.println("Name:" + ou.getOrganizationalUnitName());
            System.out.println("Parent:" + ou.getParentOrganizationalUnitName());
            System.out.println("Description:" + ou.getDescription());
            System.out.println("CalendarRuleId:" + ou.getCalendarRuleId());
            System.out.println("User:" + ou.getMember());
            System.out.println("PeopleQueryUser:" + ou.getPeopleQueryMember());
            System.out.println("Manager:" + ou.getManagedByMember());
            System.out.println("CreatedBy:" + ou.getCreatedBy());
            System.out.println("CreatedByIdentityContext:" + ou.getCreatedByIdentityContext());
            System.out.println("CreatedDate:" + ou.getCreatedDate());
            System.out.println("LastUpdatedBy:" + ou.getLastUpdatedBy());
            System.out.println("LastUpdatedByIdentityContext:" + ou.getLastUpdatedByIdentityContext());
            System.out.println("LastUpdatedDate:" + ou.getLastUpdatedDate());
        }
    }

    private WorkdayType getWeekDay(String weekday) {
        WorkdayType wDay = objectFactory.createWorkdayType();
        wDay.setWeekDay(WeekDaysEnum.fromValue((String)weekday));
        List wPrdList = wDay.getWorkPeriod();
        TimeZone tz = TimeZone.getTimeZone("Asia/Calcutta");
        WorkPeriodType wPrd = objectFactory.createWorkPeriodType();
        Calendar cal = Calendar.getInstance(tz);
        cal.set(2009, 0, 1, 8, 0, 0);
        wPrd.setStartTime(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        Calendar calend = Calendar.getInstance(tz);
        calend.set(2009, 0, 1, 12, 0, 0);
        wPrd.setEndTime(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)calend));
        wPrdList.add(wPrd);
        wPrd = objectFactory.createWorkPeriodType();
        cal = Calendar.getInstance(tz);
        cal.set(2009, 0, 1, 13, 0, 0);
        wPrd.setStartTime(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal));
        calend = Calendar.getInstance(tz);
        calend.set(2009, 0, 1, 17, 0, 0);
        wPrd.setEndTime(datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)calend));
        wPrdList.add(wPrd);
        return wDay;
    }

    private CalendarRule createSimpleCalendar(int index) throws BPMOrganizationException {
        CalendarRule calRul = objectFactory.createCalendarRule();
        calRul.setName(this.getName() + "Calendar" + index);
        calRul.setId(Util.getGuid());
        calRul.setTimeZone("Asia/Calcutta");
        WorkdayListType workList = objectFactory.createWorkdayListType();
        List wList = workList.getWorkday();
        wList.add(this.getWeekDay("Monday"));
        wList.add(this.getWeekDay("Tuesday"));
        wList.add(this.getWeekDay("Wednesday"));
        wList.add(this.getWeekDay("Thursday"));
        wList.add(this.getWeekDay("Friday"));
        calRul.setWorkdayList(workList);
        return this.getBPMOrganizationService().createCalendarRule(this.ctx, calRul);
    }

    private void deleteSimpleCalendar(CalendarRule calRul) {
        if (calRul == null || calRul.getId() == null) {
            return;
        }
        try {
            IBPMContext ctx = this.createWFContext("demoadmin", PASSWORD, REALM_NAME);
            this.getBPMOrganizationService().deleteCalendarRule(ctx, calRul.getId(), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            Class<?> dataTypeFactoryClass = Class.forName("com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl");
            Constructor<?> constructor = dataTypeFactoryClass.getConstructor(new Class[0]);
            datatypeFactory = (DatatypeFactory)constructor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
        IDCalendarId = Util.getGuid();
        IDCHolidayListId = Util.getGuid();
    }
}

