/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.soap;

import com.oracle.xmlns.bpm.organizationservice.wrappeddoclittypes.FaultType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.Holder;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.common.WorkflowServiceLocator;
import oracle.bpel.services.workflow.common.model.CredentialType;
import oracle.bpel.services.workflow.common.model.WorkflowContextType;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.common.BPMContextType;
import oracle.bpm.services.organization.common.ObjectFactory;
import oracle.bpm.services.organization.ejb.BPMOrganizationServiceRemote;
import oracle.bpm.services.organization.model.ApplicationContext;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociation;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.ChildOrganizationalUnitRetrievalModeTypeEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.OrganizationEntitySearchContext;
import oracle.bpm.services.organization.model.OrganizationEntityTypeEnum;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.PeopleQuery;
import oracle.bpm.services.organization.model.PeopleQueryContext;
import oracle.bpm.services.organization.model.PeopleQueryContextType;
import oracle.bpm.services.organization.model.PeopleQueryType;
import oracle.bpm.services.organization.model.Permission;
import oracle.bpm.services.organization.model.Predicate;
import oracle.bpm.services.organization.model.PredicateType;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.RoleProfile;
import oracle.bpm.services.organization.model.RoleProfileType;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;
import oracle.bpm.services.organization.soap.OrganizationServicePortType;
import oracle.bpm.services.organization.soap.WorkflowErrorMessage;
import oracle.webservices.annotations.PortableWebService;

@PortableWebService(wsdlLocation="/WEB-INF/wsdl/OrganizationServiceInterface.wsdl", targetNamespace="http://xmlns.oracle.com/bpm/organizationService", serviceName="OrganizationService", portName="OrganizationServicePort", endpointInterface="oracle.bpm.services.organization.soap.OrganizationServicePortType", name="OrganizationServicePortType")
@XmlSeeAlso(value={com.oracle.xmlns.bpm.organizationservice.wrappeddoclittypes.ObjectFactory.class, ObjectFactory.class, oracle.bpm.services.organization.model.ObjectFactory.class})
public class AbstractOrganizationServicePortImpl
implements OrganizationServicePortType {
    @Resource
    private SessionContext ctx;
    private oracle.bpm.services.organization.model.ObjectFactory objectFactory;
    @EJB(beanInterface=BPMOrganizationServiceRemote.class, name="BPMOrganizationServiceBean")
    private IBPMOrganizationService orgSvcEJB;

    public AbstractOrganizationServicePortImpl() {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"AbstractOrganizationServicePortImpl.ctor() >> Instantiated ... ");
        this.objectFactory = new oracle.bpm.services.organization.model.ObjectFactory();
        if (this.orgSvcEJB == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"Org Service EJB reference is NULL");
        } else {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"Org Service EJB reference is NOT null");
        }
    }

    @Override
    public List<OrganizationalUnit> searchOrganizationEntity(BPMContextType bpmContext, OrganizationEntityTypeEnum organizationEntity, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow, OrganizationEntitySearchContext organizationEntitySearchContext) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            return this.orgSvcEJB.searchOrganizationEntity(bpmCtx, organizationEntity, searchMode, searchCriteria, startRow, endRow, organizationEntitySearchContext);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void createOrganizationalUnit(BPMContextType bpmContext, Holder<OrganizationalUnit> organizationalUnit) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            OrganizationalUnit result = this.orgSvcEJB.createOrganizationalUnit(bpmCtx, (OrganizationalUnit)organizationalUnit.value);
            organizationalUnit.value = result;
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void updateOrganizationalUnit(BPMContextType bpmContext, Holder<OrganizationalUnit> organizationalUnit) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            OrganizationalUnit result = this.orgSvcEJB.updateOrganizationalUnit(bpmCtx, (OrganizationalUnit)organizationalUnit.value);
            organizationalUnit.value = result;
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void deleteOrganizationalUnit(BPMContextType bpmContext, String organizationalUnitId, boolean includingChildren, boolean force) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.deleteOrganizationalUnit(bpmCtx, organizationalUnitId, includingChildren, force);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public OrganizationalUnit getOrganizationalUnit(BPMContextType bpmContext, String organizationalUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum childOrganizationalUnitRetrievalMode) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            return this.orgSvcEJB.getOrganizationalUnit(bpmCtx, organizationalUnitId, childOrganizationalUnitRetrievalMode);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void createApplicationRoleOrgUnitCalendarAssociation(BPMContextType bpmContext, Holder<ApplicationRoleOrgUnitCalendarAssociation> applicationRoleOrgUnitCalendarAssociation) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            ApplicationRoleOrgUnitCalendarAssociation result = this.orgSvcEJB.createApplicationRoleOrgUnitCalendarAssociation(bpmCtx, (ApplicationRoleOrgUnitCalendarAssociation)applicationRoleOrgUnitCalendarAssociation.value);
            applicationRoleOrgUnitCalendarAssociation.value = result;
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void updateApplicationRoleOrgUnitCalendarAssociation(BPMContextType bpmContext, Holder<ApplicationRoleOrgUnitCalendarAssociation> applicationRoleOrgUnitCalendarAssociation) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            ApplicationRoleOrgUnitCalendarAssociation result = this.orgSvcEJB.updateApplicationRoleOrgUnitCalendarAssociation(bpmCtx, (ApplicationRoleOrgUnitCalendarAssociation)applicationRoleOrgUnitCalendarAssociation.value);
            applicationRoleOrgUnitCalendarAssociation.value = result;
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void deleteApplicationRoleOrgUnitCalendarAssociation(BPMContextType bpmContext, String applicationRoleOrgUnitCalendarAssociationId) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.deleteApplicationRoleOrgUnitCalendarAssociation(bpmCtx, applicationRoleOrgUnitCalendarAssociationId);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public List<ApplicationRoleOrgUnitCalendarAssociation> getApplicationRoleOrgUnitCalendarAssociation(BPMContextType bpmContext, RoleProfileType applicationRole) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            return this.orgSvcEJB.getApplicationRoleOrgUnitCalendarAssociation(bpmCtx, new RoleProfile(applicationRole));
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public CalendarRule getCalendarRule(BPMContextType bpmContext, String organizationalUnitId) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            return this.orgSvcEJB.getCalendarRule(bpmCtx, organizationalUnitId);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public CalendarRule getCalendarRuleForRole(BPMContextType bpmContext, String organizationalUnitId, RoleProfileType applicationRole) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            return this.orgSvcEJB.getCalendarRuleForRole(bpmCtx, organizationalUnitId, new RoleProfile(applicationRole));
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void createCalendarRule(BPMContextType bpmContext, Holder<CalendarRule> calendarRule) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            CalendarRule retVal = this.orgSvcEJB.createCalendarRule(bpmCtx, (CalendarRule)calendarRule.value);
            calendarRule.value = retVal;
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void updateCalendarRule(BPMContextType bpmContext, Holder<CalendarRule> calendarRule) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            CalendarRule retVal = this.orgSvcEJB.updateCalendarRule(bpmCtx, (CalendarRule)calendarRule.value);
            calendarRule.value = retVal;
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void deleteCalendarRule(BPMContextType bpmContext, String calendarID, boolean force) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.deleteCalendarRule(bpmCtx, calendarID, force);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public HolidayRule getHolidayRule(BPMContextType bpmContext, String holidayRuleId) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            return this.orgSvcEJB.getHolidayRule(bpmCtx, holidayRuleId);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void createHolidayRule(BPMContextType bpmContext, Holder<HolidayRule> holidayRule) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            HolidayRule retVal = this.orgSvcEJB.createHolidayRule(bpmCtx, (HolidayRule)holidayRule.value);
            holidayRule.value = retVal;
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void updateHolidayRule(BPMContextType bpmContext, Holder<HolidayRule> holidayRule) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            HolidayRule retVal = this.orgSvcEJB.updateHolidayRule(bpmCtx, (HolidayRule)holidayRule.value);
            holidayRule.value = retVal;
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void deleteHolidayRule(BPMContextType bpmContext, String holidayRuleId, boolean force) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.deleteHolidayRule(bpmCtx, holidayRuleId, force);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void createAppRole(BPMContextType bpmContext, ApplicationContext applicationContext, String appRoleName, String optionalDisplayName, String optionalDesc) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.createAppRole(bpmCtx, applicationContext, appRoleName, optionalDisplayName, optionalDesc);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void removeAppRole(BPMContextType bpmContext, ApplicationContext applicationContext, String appRoleName, boolean force) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.removeAppRole(bpmCtx, applicationContext, appRoleName, force);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void grantAppRoleToPrincipal(BPMContextType bpmContext, ApplicationContext applicationContext, String appRoleName, PrincipleRefType participant) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            Participant part = this.objectFactory.createParticipant(participant);
            this.orgSvcEJB.grantAppRoleToPrincipal(bpmCtx, applicationContext, appRoleName, part);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void revokeAppRoleFromPrincipal(BPMContextType bpmContext, ApplicationContext applicationContext, String appRoleName, PrincipleRefType participant) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            Participant part = this.objectFactory.createParticipant(participant);
            this.orgSvcEJB.revokeAppRoleFromPrincipal(bpmCtx, applicationContext, appRoleName, part);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void grantPermissionToAppRole(BPMContextType bpmContext, ApplicationContext applicationContext, String appRoleName, Permission permission) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.grantPermissionToAppRole(bpmCtx, applicationContext, appRoleName, permission);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void revokePermissionFromAppRole(BPMContextType bpmContext, ApplicationContext applicationContext, String appRoleName, Permission permission) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.revokePermissionFromAppRole(bpmCtx, applicationContext, appRoleName, permission);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public List<PrincipleRefType> executePeopleQuery(BPMContextType bpmContext, PeopleQueryType peopleQuery, PeopleQueryContextType peopleQueryContext) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            PeopleQuery pq = this.objectFactory.createPeopleQuery(peopleQuery);
            PeopleQueryContext pqc = this.objectFactory.createPeopleQueryContext(peopleQueryContext);
            List iResult = this.orgSvcEJB.executePeopleQuery(bpmCtx, pq, pqc);
            ArrayList<PrincipleRefType> fResult = new ArrayList<PrincipleRefType>();
            for (Participant part : iResult) {
                fResult.add((PrincipleRefType)part.getValue());
            }
            return fResult;
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public List<PrincipleRefType> getParticipantsWithProperties(BPMContextType bpmContext, List<PrincipleRefType> participant, List<ParticipantProperty> participantProperty, int startRow, int endRow) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            ArrayList<Participant> iPart = new ArrayList<Participant>();
            for (PrincipleRefType prt : participant) {
                iPart.add(this.objectFactory.createParticipant(prt));
            }
            List iResult = this.orgSvcEJB.getParticipantsWithProperties(bpmCtx, iPart, participantProperty, startRow, endRow);
            ArrayList<PrincipleRefType> fResult = new ArrayList<PrincipleRefType>();
            for (Participant part : iResult) {
                fResult.add((PrincipleRefType)part.getValue());
            }
            return fResult;
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public List<PrincipleRefType> searchParticipantsWithProperties(BPMContextType bpmContext, List<PrincipleRefType> participant, PredicateType predicate, int startRow, int endRow) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            ArrayList<Participant> iPart = new ArrayList<Participant>();
            for (PrincipleRefType prt : participant) {
                iPart.add(this.objectFactory.createParticipant(prt));
            }
            List iResult = this.orgSvcEJB.searchParticipantsWithProperties(bpmCtx, iPart, new Predicate(predicate), startRow, endRow);
            ArrayList<PrincipleRefType> fResult = new ArrayList<PrincipleRefType>();
            for (Participant part : iResult) {
                fResult.add((PrincipleRefType)part.getValue());
            }
            return fResult;
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public List<ParticipantProperties> getAllAssignedParticipantProperties(BPMContextType bpmContext) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            return this.orgSvcEJB.getAllAssignedParticipantProperties(bpmCtx);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void deleteAllPropertiesOnParticipants(BPMContextType bpmContext, List<PrincipleRefType> participant) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            ArrayList<Participant> iPart = new ArrayList<Participant>();
            for (PrincipleRefType prt : participant) {
                iPart.add(this.objectFactory.createParticipant(prt));
            }
            this.orgSvcEJB.deleteAllPropertiesOnParticipants(bpmCtx, iPart);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void setPropertiesOnParticipants(BPMContextType bpmContext, List<ParticipantProperties> participantProperties) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.setPropertiesOnParticipants(bpmCtx, participantProperties);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public List<ParticipantProperties> getPropertiesOfParticipants(BPMContextType bpmContext, List<PrincipleRefType> participant) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            ArrayList<Participant> iPart = new ArrayList<Participant>();
            for (PrincipleRefType prt : participant) {
                iPart.add(this.objectFactory.createParticipant(prt));
            }
            return this.orgSvcEJB.getPropertiesOfParticipants(bpmCtx, iPart);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void createParticipantProperty(BPMContextType bpmContext, ParticipantProperty participantProperty) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.createParticipantProperty(bpmCtx, participantProperty);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void addParticipantPropertyValue(BPMContextType bpmContext, ParticipantProperty participantProperty) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.addParticipantPropertyValue(bpmCtx, participantProperty);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void deleteParticipantProperty(BPMContextType bpmContext, ParticipantProperty participantProperty, boolean force) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.deleteParticipantProperty(bpmCtx, participantProperty, force);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void deleteParticipantPropertyValue(BPMContextType bpmContext, ParticipantProperty participantProperty, boolean force) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.deleteParticipantPropertyValue(bpmCtx, participantProperty, force);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void updateParticipantPropertyName(BPMContextType bpmContext, String oldName, String newName) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.updateParticipantPropertyName(bpmCtx, oldName, newName);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public void updateParticipantPropertyValue(BPMContextType bpmContext, String propertyName, String oldValue, String newValue) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            this.orgSvcEJB.updateParticipantPropertyValue(bpmCtx, propertyName, oldValue, newValue);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    @Override
    public List<ParticipantProperty> searchExtendedUserProperties(BPMContextType bpmContext, String propertyName) throws WorkflowErrorMessage {
        try {
            WorkflowContextType wkflCtxt = this.createWorkflowContextTypeFrom(bpmContext);
            IBPMContext bpmCtx = (IBPMContext)WorkflowServiceLocator.getVerificationService().getContextFromJAXBObject(wkflCtxt);
            return this.orgSvcEJB.searchExtendedUserProperties(bpmCtx, propertyName);
        }
        catch (Exception e) {
            WorkflowErrorMessage w = new WorkflowErrorMessage(e.getLocalizedMessage(), new FaultType(), e);
            throw w;
        }
    }

    private WorkflowContextType createWorkflowContextTypeFrom(BPMContextType bpmCtx) throws Exception {
        return this.convertBPMContextTypeToWorkflowContextType(bpmCtx);
    }

    private WorkflowContextType convertBPMContextTypeToWorkflowContextType(BPMContextType bpmCtx) {
        oracle.bpel.services.workflow.common.model.ObjectFactory objFac = new oracle.bpel.services.workflow.common.model.ObjectFactory();
        oracle.bpm.services.organization.common.CredentialType credentialType = bpmCtx.getCredential();
        String token = bpmCtx.getToken();
        String locale = bpmCtx.getLocale();
        String timezone = bpmCtx.getTimeZone();
        WorkflowContextType wkflwCtxtType = objFac.createWorkflowContextType();
        CredentialType bpelCredType = objFac.createCredentialType();
        bpelCredType.setIdentityContext(credentialType.getIdentityContext());
        bpelCredType.setLogin(credentialType.getLogin());
        bpelCredType.setOnBehalfOfUser(credentialType.getOnBehalfOfUser());
        bpelCredType.setPassword(credentialType.getPassword());
        wkflwCtxtType.setLocale(locale);
        wkflwCtxtType.setTimeZone(timezone);
        wkflwCtxtType.setToken(token);
        wkflwCtxtType.setCredential(bpelCredType);
        return wkflwCtxtType;
    }
}

