/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.persistency;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.HolidayPatternEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayType;
import oracle.bpm.services.organization.model.MonthsEnum;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.WeekDaysEnum;
import oracle.bpm.services.organization.model.WorkPeriodType;
import oracle.bpm.services.organization.model.WorkdayListType;
import oracle.bpm.services.organization.model.WorkdayType;
import oracle.bpm.services.organization.persistency.AbstractPersistencyDriver;
import oracle.bpm.services.organization.persistency.model.BpmCalendarRule;
import oracle.bpm.services.organization.persistency.model.BpmCalendarWorkday;
import oracle.bpm.services.organization.persistency.model.BpmHolidayRule;
import oracle.bpm.services.organization.persistency.model.BpmHolidays;

public class BPMCalendarHolidayPersistency {
    private static final String BIZ_TIME_FORMAT = "HH:mm:ss";
    private static final String HOLIDAY_TZ = "Etc/GMT";
    private static ObjectFactory objectFactory = null;
    private static DatatypeFactory datatypeFactory = null;

    public CalendarRule convertCalendarFromToplink(BpmCalendarRule bpmCal) throws BPMOrganizationException {
        CalendarRule jaxCal = objectFactory.createCalendarRule();
        jaxCal.setName(bpmCal.getName());
        jaxCal.setId(bpmCal.getId());
        jaxCal.setCreatedBy(bpmCal.getCreatedBy());
        jaxCal.setCreatedIdentityCtx(bpmCal.getCreatedByIdctx());
        jaxCal.setCreatedDate(this.convertDateToCalendar(bpmCal.getCreatedDate()));
        jaxCal.setLastUpdatedBy(bpmCal.getLastUpdatedBy());
        jaxCal.setLastUpdatedIdentityCtx(bpmCal.getLastUpdatedIdctx());
        jaxCal.setLastUpdatedDate(this.convertDateToCalendar(bpmCal.getLastUpdatedDate()));
        jaxCal.setTimeZone(bpmCal.getTimeZoneId());
        WorkdayListType jaxWdayList = objectFactory.createWorkdayListType();
        List jaxWdays = jaxWdayList.getWorkday();
        this.debugLog("convertCalendarFromToplink", "TimeZONE : " + bpmCal.getTimeZoneId());
        TimeZone calTz = bpmCal.getTimeZoneId() != null ? TimeZone.getTimeZone(bpmCal.getTimeZoneId().trim()) : TimeZone.getDefault();
        List<BpmCalendarWorkday> bpmWdayList = bpmCal.getBpmCalendarWorkdayCollection();
        HashMap<String, WorkdayType> wdayMap = new HashMap<String, WorkdayType>();
        for (int i = 0; i < bpmWdayList.size(); ++i) {
            BpmCalendarWorkday bpmWday = bpmWdayList.get(i);
            WorkdayType jaxWday = (WorkdayType)wdayMap.get(bpmWday.getWeekday());
            if (jaxWday == null) {
                jaxWday = objectFactory.createWorkdayType();
                jaxWday.setWeekDay(WeekDaysEnum.fromValue((String)bpmWday.getWeekday()));
                jaxWdays.add(jaxWday);
                wdayMap.put(bpmWday.getWeekday(), jaxWday);
            }
            WorkPeriodType jaxWprd = objectFactory.createWorkPeriodType();
            jaxWprd.setStartTime(this.convertTimeStringToCalendar(bpmWday.getStartTime(), calTz));
            jaxWprd.setEndTime(this.convertTimeStringToCalendar(bpmWday.getEndTime(), calTz));
            List jaxWprdList = jaxWday.getWorkPeriod();
            jaxWprdList.add(jaxWprd);
        }
        jaxCal.setWorkdayList(jaxWdayList);
        if (bpmCal.getHolidayRule() != null) {
            jaxCal.setHolidayRuleId(bpmCal.getHolidayRule().getId());
            jaxCal.setHolidayRuleName(bpmCal.getHolidayRule().getName());
        }
        return jaxCal;
    }

    public BpmCalendarRule convertCalendarToToplink(AbstractPersistencyDriver.OPERATION operation, CalendarRule jaxCal, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) {
        this.debugPointValidateUnitOfWork(unitOfWorkHolder);
        BpmCalendarRule bpmCal = new BpmCalendarRule();
        bpmCal.setId(jaxCal.getId());
        if (operation == AbstractPersistencyDriver.OPERATION.CREATE) {
            bpmCal = (BpmCalendarRule)unitOfWorkHolder.registerNewObject(bpmCal);
            unitOfWorkHolder.setShouldNewObjectsBeCached(true);
            bpmCal.setCreatedBy(jaxCal.getCreatedBy());
            bpmCal.setCreatedByIdctx(jaxCal.getCreatedIdentityCtx());
            bpmCal.setCreatedDate(this.convertCalendarToTimeStamp(jaxCal.getCreatedDate()));
        } else if (operation == AbstractPersistencyDriver.OPERATION.UPDATE) {
            unitOfWorkHolder.shouldPerformDeletesFirst();
            bpmCal = (BpmCalendarRule)unitOfWorkHolder.readObject(bpmCal);
            bpmCal.setHolidayRule(null);
            List<BpmCalendarWorkday> bpmCalendarWorkdayCollectionOldVal = bpmCal.getBpmCalendarWorkdayCollection();
            Object[] bpmCalendarWorkdayArrayOldVal = bpmCalendarWorkdayCollectionOldVal.toArray();
            for (int i = 0; i < bpmCalendarWorkdayArrayOldVal.length; ++i) {
                BpmCalendarWorkday bpmWdayOldVal = (BpmCalendarWorkday)bpmCalendarWorkdayArrayOldVal[i];
                unitOfWorkHolder.deleteObject(bpmWdayOldVal);
                bpmCal.removeBpmCalendarWorkday(bpmWdayOldVal);
            }
        } else if (operation == AbstractPersistencyDriver.OPERATION.DELETE) {
            return bpmCal;
        }
        this.debugPointValidateUnitOfWork(unitOfWorkHolder);
        bpmCal.setLastUpdatedBy(jaxCal.getLastUpdatedBy());
        bpmCal.setLastUpdatedIdctx(jaxCal.getLastUpdatedIdentityCtx());
        bpmCal.setLastUpdatedDate(this.convertCalendarToTimeStamp(jaxCal.getLastUpdatedDate()));
        bpmCal.setName(jaxCal.getName());
        bpmCal.setTimeZoneId(jaxCal.getTimeZone());
        TimeZone tz = TimeZone.getTimeZone(jaxCal.getTimeZone());
        if (jaxCal.getHolidayRuleId() != null) {
            BpmHolidayRule bpmHol = new BpmHolidayRule();
            bpmHol.setId(jaxCal.getHolidayRuleId());
            bpmHol = (BpmHolidayRule)unitOfWorkHolder.readObject(bpmHol);
            bpmCal.setHolidayRule(bpmHol);
        }
        this.debugPointValidateUnitOfWork(unitOfWorkHolder);
        ArrayList bpmCalendarWorkdayCollection = new ArrayList();
        List jaxWdayList = jaxCal.getWorkdayList().getWorkday();
        if (jaxWdayList != null && jaxWdayList.size() > 0) {
            for (int i = 0; i < jaxWdayList.size(); ++i) {
                WorkdayType jaxWday = (WorkdayType)jaxWdayList.get(i);
                List jaxWprdList = jaxWday.getWorkPeriod();
                for (int j = 0; j < jaxWprdList.size(); ++j) {
                    WorkPeriodType jaxWprd = (WorkPeriodType)jaxWprdList.get(j);
                    BpmCalendarWorkday bpmWday = new BpmCalendarWorkday();
                    bpmWday.setId(Util.getGuid());
                    bpmWday.setWeekday(jaxWday.getWeekDay().value());
                    bpmWday.setStartTime(this.convertCalendarToTimeString(jaxWprd.getStartTime(), tz));
                    bpmWday.setEndTime(this.convertCalendarToTimeString(jaxWprd.getEndTime(), tz));
                    bpmWday.setCalendarRule(bpmCal);
                    bpmCal.addBpmCalendarWorkday(bpmWday);
                }
            }
        }
        this.debugPointValidateUnitOfWork(unitOfWorkHolder);
        return bpmCal;
    }

    public HolidayRule convertHolidayFromToplink(BpmHolidayRule bpmHol) {
        HolidayRule jaxHol = objectFactory.createHolidayRule();
        jaxHol.setName(bpmHol.getName());
        jaxHol.setId(bpmHol.getId());
        jaxHol.setCreatedBy(bpmHol.getCreatedBy());
        jaxHol.setCreatedIdentityCtx(bpmHol.getCreatedByIdctx());
        jaxHol.setCreatedDate(this.convertDateToCalendar(bpmHol.getCreatedDate()));
        jaxHol.setLastUpdatedBy(bpmHol.getLastUpdatedBy());
        jaxHol.setLastUpdatedIdentityCtx(bpmHol.getLastUpdatedByIdctx());
        jaxHol.setLastUpdatedDate(this.convertDateToCalendar(bpmHol.getLastUpdatedDate()));
        List jaxHolList = jaxHol.getHolidays();
        List<BpmHolidays> bpmHolList = bpmHol.getBpmHolidaysCollection();
        for (int i = 0; i < bpmHolList.size(); ++i) {
            BpmHolidays refHoliday;
            BpmHolidays bpmHoliday = bpmHolList.get(i);
            HolidayType jaxHoliday = objectFactory.createHolidayType();
            jaxHoliday.setName(bpmHoliday.getName());
            jaxHoliday.setHolidayPattern(HolidayPatternEnum.fromValue((String)bpmHoliday.getHolidayPattern()));
            if (bpmHoliday.getHolidayDate() != null) {
                jaxHoliday.setHolidayDate(this.convertHolidayDateFromSQL(bpmHoliday.getHolidayDate()));
            }
            if (bpmHoliday.getNth() != null) {
                jaxHoliday.setNth(bpmHoliday.getNth().toBigInteger());
            }
            if (bpmHoliday.getWeekDay() != null) {
                jaxHoliday.setWeekDay(WeekDaysEnum.fromValue((String)bpmHoliday.getWeekDay()));
            }
            if (bpmHoliday.getMonth() != null) {
                jaxHoliday.setMonth(MonthsEnum.fromValue((String)bpmHoliday.getMonth()));
            }
            if ((refHoliday = bpmHoliday.getBpmHolidays()) != null) {
                jaxHoliday.setRefHoliday(refHoliday.getName());
            }
            jaxHolList.add(jaxHoliday);
        }
        return jaxHol;
    }

    public BpmHolidayRule convertHolidayToToplink(AbstractPersistencyDriver.OPERATION operation, HolidayRule jaxHol, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) {
        this.debugPointValidateUnitOfWork(unitOfWorkHolder);
        BpmHolidayRule bpmHol = new BpmHolidayRule();
        bpmHol.setId(jaxHol.getId());
        HashMap<String, BpmHolidays> oldHolidaysMap = new HashMap<String, BpmHolidays>();
        if (operation == AbstractPersistencyDriver.OPERATION.CREATE) {
            bpmHol = (BpmHolidayRule)unitOfWorkHolder.registerNewObject(bpmHol);
            unitOfWorkHolder.setShouldNewObjectsBeCached(true);
            bpmHol.setCreatedBy(jaxHol.getCreatedBy());
            bpmHol.setCreatedByIdctx(jaxHol.getCreatedIdentityCtx());
            bpmHol.setCreatedDate(this.convertCalendarToTimeStamp(jaxHol.getCreatedDate()));
        } else if (operation == AbstractPersistencyDriver.OPERATION.UPDATE) {
            unitOfWorkHolder.shouldPerformDeletesLast();
            bpmHol = (BpmHolidayRule)unitOfWorkHolder.readObject(bpmHol);
            List<BpmHolidays> bpmHolidaysCollectionOldVal = bpmHol.getBpmHolidaysCollection();
            Object[] bpmHolidaysbpmHolidaysArrayOldVal = bpmHolidaysCollectionOldVal.toArray();
            for (int i = 0; i < bpmHolidaysbpmHolidaysArrayOldVal.length; ++i) {
                BpmHolidays bpmHolidayOldVal = (BpmHolidays)bpmHolidaysbpmHolidaysArrayOldVal[i];
                String holidayName = bpmHolidayOldVal.getName();
                oldHolidaysMap.put(holidayName, bpmHolidayOldVal);
            }
        } else if (operation == AbstractPersistencyDriver.OPERATION.DELETE) {
            return bpmHol;
        }
        this.debugPointValidateUnitOfWork(unitOfWorkHolder);
        bpmHol.setLastUpdatedBy(jaxHol.getLastUpdatedBy());
        bpmHol.setLastUpdatedByIdctx(jaxHol.getLastUpdatedIdentityCtx());
        bpmHol.setLastUpdatedDate(this.convertCalendarToTimeStamp(jaxHol.getLastUpdatedDate()));
        bpmHol.setName(jaxHol.getName());
        List jaxHolidayList = jaxHol.getHolidays();
        HashMap<String, BpmHolidays> holidayListMap = new HashMap<String, BpmHolidays>();
        HashMap<String, String> refHolidayListMap = new HashMap<String, String>();
        ArrayList<String> newHolidays = new ArrayList<String>();
        if (jaxHolidayList != null && jaxHolidayList.size() > 0) {
            for (int i = 0; i < jaxHolidayList.size(); ++i) {
                BpmHolidays existingHoliday;
                String refHolName;
                HolidayType jaxHoliday = (HolidayType)jaxHolidayList.get(i);
                BpmHolidays bpmHoliday = new BpmHolidays();
                bpmHoliday.setId(Util.getGuid());
                bpmHoliday.setName(jaxHoliday.getName());
                newHolidays.add(jaxHoliday.getName());
                bpmHoliday.setHolidayPattern(jaxHoliday.getHolidayPattern().value());
                if (jaxHoliday.getHolidayDate() != null) {
                    bpmHoliday.setHolidayDate(this.convertHolidayDateToSQL(jaxHoliday.getHolidayDate()));
                }
                if (jaxHoliday.getNth() != null) {
                    bpmHoliday.setNth(new BigDecimal(jaxHoliday.getNth()));
                }
                if (jaxHoliday.getWeekDay() != null) {
                    bpmHoliday.setWeekDay(jaxHoliday.getWeekDay().value());
                }
                if (jaxHoliday.getMonth() != null) {
                    bpmHoliday.setMonth(jaxHoliday.getMonth().value());
                }
                if ((refHolName = jaxHoliday.getRefHoliday()) != null && !refHolName.trim().equals("")) {
                    refHolidayListMap.put(jaxHoliday.getName(), jaxHoliday.getRefHoliday());
                }
                if ((existingHoliday = (BpmHolidays)oldHolidaysMap.get(bpmHoliday.getName())) == null) {
                    bpmHoliday = (BpmHolidays)unitOfWorkHolder.registerNewObject(bpmHoliday);
                    holidayListMap.put(jaxHoliday.getName(), bpmHoliday);
                    bpmHol.addBpmHolidays(bpmHoliday);
                    continue;
                }
                if (!this.isBpmHolidaysSame(existingHoliday, bpmHoliday)) {
                    this.updateExistingHoliday(existingHoliday, bpmHoliday);
                }
                existingHoliday.setBpmHolidays(null);
                holidayListMap.put(jaxHoliday.getName(), existingHoliday);
            }
            Set refHolidaySet = refHolidayListMap.keySet();
            for (String referringHolidayName : refHolidaySet) {
                String referredHolidayName = (String)refHolidayListMap.get(referringHolidayName);
                BpmHolidays referringHoliday = (BpmHolidays)holidayListMap.get(referringHolidayName);
                BpmHolidays referredHoliday = (BpmHolidays)holidayListMap.get(referredHolidayName);
                referredHoliday.addBpmHolidays(referringHoliday);
                this.debugLog("convertHolidayToToplink", "referringHoliday : " + referringHoliday.getName() + ", referredHoliday : " + referredHoliday.getName());
            }
        }
        Set oldHolidaySet = oldHolidaysMap.keySet();
        for (String holidayName : oldHolidaySet) {
            if (newHolidays.contains(holidayName)) continue;
            BpmHolidays deletedHoliday = (BpmHolidays)oldHolidaysMap.get(holidayName);
            bpmHol.removeBpmHolidays(deletedHoliday);
            unitOfWorkHolder.deleteObject(deletedHoliday);
        }
        this.debugPointValidateUnitOfWork(unitOfWorkHolder);
        return bpmHol;
    }

    protected void debugLog(String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)"BPMCalendarHolidayPersistency", (String)method, (String)msg);
        }
    }

    private Timestamp convertCalendarToTimeStamp(XMLGregorianCalendar cal) {
        if (cal == null) {
            return null;
        }
        return new Timestamp(cal.toGregorianCalendar().getTimeInMillis());
    }

    private XMLGregorianCalendar convertDateToCalendar(Date dt) {
        if (dt == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(dt.getTime());
        return datatypeFactory.newXMLGregorianCalendar(calendar);
    }

    private Date convertHolidayDateToSQL(XMLGregorianCalendar cal) {
        if (cal == null) {
            return null;
        }
        TimeZone tz = TimeZone.getTimeZone(HOLIDAY_TZ);
        Calendar tcal = Calendar.getInstance(tz);
        tcal.set(1, cal.getYear());
        tcal.set(2, cal.getMonth() - 1);
        tcal.set(5, cal.getDay());
        this.debugLog("convertHolidayDateToSQL", "Holiday date : " + tcal.getTime());
        return tcal.getTime();
    }

    private XMLGregorianCalendar convertHolidayDateFromSQL(Date dt) {
        TimeZone tz = TimeZone.getTimeZone(HOLIDAY_TZ);
        GregorianCalendar calendar = new GregorianCalendar(tz);
        calendar.setTimeInMillis(dt.getTime());
        this.debugLog("convertHolidayDateFromSQL", "Holiday date : " + calendar.getTime());
        return datatypeFactory.newXMLGregorianCalendar(calendar);
    }

    private XMLGregorianCalendar convertTimeStringToCalendar(String st, TimeZone tz) throws BPMOrganizationException {
        if (st == null || "".equals(st.trim())) {
            return null;
        }
        SimpleDateFormat tmFmt = new SimpleDateFormat(BIZ_TIME_FORMAT);
        tmFmt.setTimeZone(tz);
        try {
            Date dt = tmFmt.parse(st);
            GregorianCalendar calendar = new GregorianCalendar(tz);
            calendar.setTime(dt);
            return datatypeFactory.newXMLGregorianCalendar(calendar);
        }
        catch (ParseException pe) {
            throw new BPMOrganizationException((Exception)pe);
        }
    }

    private String convertCalendarToTimeString(XMLGregorianCalendar cal, TimeZone tz) {
        if (cal == null) {
            return "";
        }
        Calendar tcal = Calendar.getInstance(tz);
        tcal.set(11, cal.getHour());
        tcal.set(12, cal.getMinute());
        tcal.set(13, 0);
        tcal.set(14, 0);
        SimpleDateFormat tmFmt = new SimpleDateFormat(BIZ_TIME_FORMAT);
        tmFmt.setTimeZone(tz);
        return tmFmt.format(tcal.getTime());
    }

    private void debugPointValidateUnitOfWork(AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) {
        if (this.debug()) {
            unitOfWorkHolder.validateObjectSpace();
        }
    }

    private boolean debug() {
        return false;
    }

    private boolean isBpmHolidaysSame(BpmHolidays existingHoliday, BpmHolidays updatedHoliday) {
        if (!this.isNotNullValueSame(existingHoliday.getName(), updatedHoliday.getName())) {
            return false;
        }
        if (!this.isNotNullValueSame(existingHoliday.getMonth(), updatedHoliday.getMonth())) {
            return false;
        }
        if (!this.isNotNullValueSame(existingHoliday.getMonth(), updatedHoliday.getMonth())) {
            return false;
        }
        if (!this.isNotNullValueSame(existingHoliday.getNth(), updatedHoliday.getNth())) {
            return false;
        }
        if (!this.isNotNullValueSame(existingHoliday.getHolidayPattern(), updatedHoliday.getHolidayPattern())) {
            return false;
        }
        if (!this.isNotNullValueSame(existingHoliday.getWeekDay(), updatedHoliday.getWeekDay())) {
            return false;
        }
        return this.isNotNullValueSame(existingHoliday.getHolidayDate(), updatedHoliday.getHolidayDate());
    }

    private boolean isNotNullValueSame(Object object1, Object object2) {
        if (object1 != null && object2 == null) {
            return false;
        }
        if (object1 == null && object2 != null) {
            return false;
        }
        if (object1 == null && object2 == null) {
            return true;
        }
        return object1.equals(object2);
    }

    private void updateExistingHoliday(BpmHolidays existingHoliday, BpmHolidays updatedHoliday) {
        if (!this.isNotNullValueSame(existingHoliday.getName(), updatedHoliday.getName())) {
            existingHoliday.setName(updatedHoliday.getName());
        }
        if (!this.isNotNullValueSame(existingHoliday.getMonth(), updatedHoliday.getMonth())) {
            existingHoliday.setMonth(updatedHoliday.getMonth());
        }
        if (!this.isNotNullValueSame(existingHoliday.getNth(), updatedHoliday.getNth())) {
            existingHoliday.setNth(updatedHoliday.getNth());
        }
        if (!this.isNotNullValueSame(existingHoliday.getHolidayPattern(), updatedHoliday.getHolidayPattern())) {
            existingHoliday.setHolidayPattern(updatedHoliday.getHolidayPattern());
        }
        if (!this.isNotNullValueSame(existingHoliday.getWeekDay(), updatedHoliday.getWeekDay())) {
            existingHoliday.setWeekDay(updatedHoliday.getWeekDay());
        }
        if (!this.isNotNullValueSame(existingHoliday.getHolidayDate(), updatedHoliday.getHolidayDate())) {
            existingHoliday.setHolidayDate(updatedHoliday.getHolidayDate());
        }
    }

    static {
        try {
            objectFactory = new ObjectFactory();
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

