/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.xpath;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.BPMCalendarHolidayService;
import oracle.bpm.services.organization.impl.BPMInternalOrganizationService;
import oracle.bpm.services.organization.impl.BPMOrganizationService;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;

public class XPathCalendarUtil {
    private static final BPMOrganizationService bpmOrganizationService = new BPMOrganizationService();

    public static String getDefaultDateFormat(String dateTime) {
        if (dateTime != null && !dateTime.contains("T")) {
            return "yyyy-MM-dd";
        }
        return "yyyy-MM-dd'T'HH:mm:ss";
    }

    public static Calendar getDate(String date, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Calendar calDate = Calendar.getInstance();
        if (date != null && !date.trim().equals("")) {
            calDate.setTime(sdf.parse(date));
        }
        return calDate;
    }

    public static String getFormattedDateString(Calendar date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String formattedDateString = null;
        if (date != null && format != null && !format.trim().equals("")) {
            formattedDateString = sdf.format(date.getTime());
        }
        return formattedDateString;
    }

    public static HolidayRule getHolidayRuleToUse(IBPMContext ctx, CalendarRule cal) throws BPMOrganizationException {
        String holRulId = cal.getHolidayRuleId();
        if (holRulId == null || holRulId.trim().equals("")) {
            return null;
        }
        return BPMCalendarHolidayService.getInstance().getHolidayRule(ctx, holRulId);
    }

    public static CalendarRule getCalendarRule(IBPMContext ctx, String calendarName) throws BPMOrganizationException {
        if (calendarName == null) {
            return null;
        }
        BPMCalendarHolidayService bpmCalendarHolidayService = BPMCalendarHolidayService.getInstance();
        List<Object> calRulList = bpmCalendarHolidayService.searchCalendarRule(ctx, SearchModeTypeEnum.EQUALS, calendarName, 0, 0);
        if (calRulList == null || calRulList.size() == 0) {
            return null;
        }
        CalendarRule calRule = (CalendarRule)calRulList.get(0);
        return bpmCalendarHolidayService.getCalendarRule(ctx, calRule.getId());
    }

    public static String getCalendarForOrganizationalUnit(String orgUnitName) throws BPMOrganizationException {
        try {
            if (orgUnitName == null) {
                return null;
            }
            IBPMContext ctx = InternalBPMContext.getInternalBPMContext();
            OrganizationalUnit orgUnit = bpmOrganizationService.searchByOUNameOrHierarchyPath(ctx, orgUnitName, null);
            BPMInternalOrganizationService bpmInternalOrgSvc = new BPMInternalOrganizationService();
            String calRuleID = bpmInternalOrgSvc.searchOUTreeBottomUpForCalendar(ctx, bpmOrganizationService, orgUnit.getOrganizationalUnitId());
            CalendarRule calRule = bpmOrganizationService.getCalendarRule(InternalBPMContext.getInternalBPMContext(), calRuleID);
            if (calRule != null) {
                return calRule.getName();
            }
            return null;
        }
        catch (BPMException be) {
            be.printStackTrace();
            throw new BPMOrganizationException((Exception)((Object)be));
        }
    }
}

