/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.xpath;

import java.util.List;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpm.services.organization.impl.xpath.XPathBPMOrganizationUnitUtil;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.fabric.common.xml.xpath.IXPathFunction;
import oracle.fabric.common.xml.xpath.XPathFunctionException;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMIdentityService;
import oracle.tip.pc.services.identity.BPMUser;

public class GetUserOrganizationUnit
implements IXPathFunction {
    public Object call(IXPathContext context, List args) throws XPathFunctionException {
        String userId = null;
        String parentPath = null;
        String realmName = null;
        int size = args.size();
        try {
            if (size < 1) {
                return null;
            }
            Object source = args.get(0);
            userId = XMLUtil.getNodeValue(source);
            if (size >= 2) {
                source = args.get(1);
                realmName = XMLUtil.getNodeValue(source);
            }
            if (size > 2) {
                source = args.get(2);
                parentPath = XMLUtil.getNodeValue(source);
            }
            if (userId != null && !"".equals(userId.trim())) {
                BPMIdentityService service = ServiceFactory.getIdentityServiceInstance((String)realmName);
                BPMUser user = null;
                user = service.lookupUser(userId);
                if (user != null) {
                    return XPathBPMOrganizationUnitUtil.getOrgUnitForUser(user, parentPath);
                }
            }
            return null;
        }
        catch (Exception e) {
            WorkflowException wfe = new WorkflowException(30043, (Object[])new String[]{userId, "bpm:getUserOrganizationUnit"}, (Throwable)e);
            throw new XPathFunctionException((Throwable)wfe);
        }
    }
}

