/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.xpath;

import com.collaxa.cube.xml.xpath.XPathException;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.task.impl.Duration;
import oracle.bpel.services.workflow.task.impl.xpath.Util;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.bpm.services.organization.impl.calendar.CalendarMgr;
import oracle.bpm.services.organization.impl.xpath.XPathCalendarUtil;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.fabric.common.xml.xpath.IXPathFunction;
import oracle.fabric.common.xml.xpath.XPathFunctionException;

public class GetBusinessCalendarDuration
implements IXPathFunction {
    public Object call(IXPathContext context, List args) throws XPathFunctionException {
        String fromDate = null;
        String toDate = null;
        String calendarName = null;
        String format = null;
        try {
            IBPMContext ctx;
            CalendarRule calRul;
            fromDate = Util.getArgValue((List)args, (int)0);
            toDate = Util.getArgValue((List)args, (int)1);
            calendarName = Util.getArgValue((List)args, (int)2);
            format = Util.getArgValue((List)args, (int)3);
            if (fromDate == null || toDate == null || calendarName == null || fromDate.trim().equals("") || toDate.trim().equals("") || calendarName.trim().equals("")) {
                return null;
            }
            if (format == null || format.trim().equals("")) {
                format = XPathCalendarUtil.getDefaultDateFormat(fromDate);
            }
            if ((calRul = XPathCalendarUtil.getCalendarRule(ctx = InternalBPMContext.getInternalBPMContext(), calendarName)) == null) {
                throw new XPathException(40001, (Object[])new String[]{calendarName, "bpmn:getBusinessCalendarDuration"});
            }
            HolidayRule holRul = XPathCalendarUtil.getHolidayRuleToUse(ctx, calRul);
            CalendarMgr cMgr = new CalendarMgr(calRul, holRul);
            Calendar fromCalDate = XPathCalendarUtil.getDate(fromDate, format);
            Calendar toCalDate = XPathCalendarUtil.getDate(toDate, format);
            fromCalDate.setTimeZone(TimeZone.getTimeZone(calRul.getTimeZone()));
            toCalDate.setTimeZone(TimeZone.getTimeZone(calRul.getTimeZone()));
            long duration = cMgr.getCalendarDuration(fromCalDate, toCalDate);
            Duration durToRet = new Duration(duration);
            return durToRet.getJavaxXMLDatatypeDuration().toString();
        }
        catch (Throwable e) {
            WorkflowException wfe = new WorkflowException(30043, (Object[])new String[]{calendarName, "bpmn:getBusinessCalendarDuration"}, e);
            throw new XPathFunctionException((Throwable)wfe);
        }
    }
}

