/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.xpath;

import com.collaxa.cube.xml.xpath.XPathException;
import java.util.Calendar;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.task.impl.Duration;
import oracle.bpel.services.workflow.task.impl.xpath.Util;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.bpm.services.organization.impl.calendar.CalendarMgr;
import oracle.bpm.services.organization.impl.xpath.XPathCalendarUtil;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.fabric.common.xml.xpath.IXPathFunction;
import oracle.fabric.common.xml.xpath.XPathFunctionException;

public class GetAbsoluteDurationFromBusinessCalendar
implements IXPathFunction {
    public Object call(IXPathContext context, List args) throws XPathFunctionException {
        String fromDate = null;
        String duration = null;
        String calendarName = null;
        String format = null;
        try {
            IBPMContext ctx;
            CalendarRule calRul;
            fromDate = Util.getArgValue((List)args, (int)0);
            duration = Util.getArgValue((List)args, (int)1);
            calendarName = Util.getArgValue((List)args, (int)2);
            format = Util.getArgValue((List)args, (int)3);
            if (calendarName == null || calendarName.trim().equals("")) {
                return duration;
            }
            if (format == null || format.trim().equals("")) {
                format = XPathCalendarUtil.getDefaultDateFormat(fromDate);
            }
            if ((calRul = XPathCalendarUtil.getCalendarRule(ctx = InternalBPMContext.getInternalBPMContext(), calendarName)) == null) {
                throw new XPathException(40001, (Object[])new String[]{calendarName, "bpmn:getAbsoluteDurationFromBusinessCalendar"});
            }
            HolidayRule holRul = XPathCalendarUtil.getHolidayRuleToUse(ctx, calRul);
            Calendar fromCalDate = XPathCalendarUtil.getDate(fromDate, format);
            CalendarMgr cMgr = new CalendarMgr(calRul, holRul);
            if (duration == null || duration.trim().equals("")) {
                Duration durToRet = new Duration(0L);
                return durToRet.getJavaxXMLDatatypeDuration().toString();
            }
            Duration durToAdd = new Duration(duration);
            Calendar toCalDate = cMgr.addCalendarDuration(fromCalDate, durToAdd.getJavaxXMLDatatypeDuration());
            long absduration = cMgr.getAbsoluteDuration(fromCalDate, toCalDate);
            Duration durToRet = new Duration(absduration);
            return durToRet.getJavaxXMLDatatypeDuration().toString();
        }
        catch (Throwable e) {
            WorkflowException wfe = new WorkflowException(30043, (Object[])new String[]{"bpmn:getAbsoluteDurationFromBusinessCalendar"}, e);
            throw new XPathFunctionException((Throwable)wfe);
        }
    }
}

