/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.xpath;

import com.collaxa.cube.xml.xpath.XPathException;
import java.util.Calendar;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.task.impl.Duration;
import oracle.bpel.services.workflow.task.impl.xpath.Util;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.bpm.services.organization.impl.calendar.CalendarMgr;
import oracle.bpm.services.organization.impl.xpath.XPathCalendarUtil;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.fabric.common.xml.xpath.IXPathContext;
import oracle.fabric.common.xml.xpath.IXPathFunction;
import oracle.fabric.common.xml.xpath.XPathFunctionException;

public class AddBusinessCalendarDuration
implements IXPathFunction {
    public Object call(IXPathContext context, List args) throws XPathFunctionException {
        String fromDate = null;
        String duration = null;
        String calendarName = null;
        String format = null;
        try {
            IBPMContext ctx;
            CalendarRule calRul;
            fromDate = Util.getArgValue((List)args, (int)0);
            duration = Util.getArgValue((List)args, (int)1);
            calendarName = Util.getArgValue((List)args, (int)2);
            format = Util.getArgValue((List)args, (int)3);
            if (calendarName == null || calendarName.trim().equals("")) {
                return null;
            }
            if (format == null || format.trim().equals("")) {
                format = XPathCalendarUtil.getDefaultDateFormat(fromDate);
            }
            if ((calRul = XPathCalendarUtil.getCalendarRule(ctx = InternalBPMContext.getInternalBPMContext(), calendarName)) == null) {
                throw new XPathException(40001, (Object[])new String[]{calendarName, "bpmn:addBusinessCalendarDuration"});
            }
            HolidayRule holRul = XPathCalendarUtil.getHolidayRuleToUse(ctx, calRul);
            CalendarMgr cMgr = new CalendarMgr(calRul, holRul);
            Calendar fromCalDate = XPathCalendarUtil.getDate(fromDate, format);
            if (duration == null || duration.trim().equals("")) {
                Duration durToRet = new Duration(fromCalDate.getTimeInMillis());
                return durToRet.getJavaxXMLDatatypeDuration().toString();
            }
            Duration durToAdd = new Duration(duration);
            Calendar toCalDate = cMgr.addCalendarDuration(fromCalDate, durToAdd.getJavaxXMLDatatypeDuration());
            String formattedDateString = XPathCalendarUtil.getFormattedDateString(toCalDate, format);
            return formattedDateString;
        }
        catch (Throwable e) {
            WorkflowException wfe = new WorkflowException(30043, (Object[])new String[]{calendarName, "bpmn:addBusinessCalendarDuration"}, e);
            throw new XPathFunctionException((Throwable)wfe);
        }
    }
}

