/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.calendar;

import java.util.Calendar;
import oracle.bpm.services.organization.impl.calendar.AbstractWorkShift;
import oracle.bpm.services.organization.impl.calendar.CalendarUtil;
import oracle.bpm.services.organization.impl.calendar.DefaultWorkShiftPattern;
import oracle.bpm.services.organization.model.CalendarRule;

public class WorkDayMgr {
    private AbstractWorkShift mWorkShift = null;

    public WorkDayMgr(CalendarRule cal) {
        this.mWorkShift = new DefaultWorkShiftPattern(cal);
    }

    public boolean isWorkDay(Calendar cal) {
        return this.mWorkShift.isWorkDay(cal);
    }

    public long getWorkingDayDurationInMillis(Calendar cal) {
        return this.mWorkShift.getWorkingDayDuration(cal);
    }

    public long getRestOfWorkingDayDurationInMillis(Calendar cal) {
        return this.mWorkShift.getRemainingWorkingDayDuration(cal);
    }

    public long getElapsedWorkingDayDurationInMillis(Calendar cal) {
        return this.mWorkShift.getElapsedWorkingDayDuration(cal);
    }

    public void setTimeToWorkingDayStartTime(Calendar cal) {
        long startTime = this.mWorkShift.getWorkingDayStartTime(cal);
        CalendarUtil.setMilliSecOfDay(cal, startTime);
    }

    public void setTimeToWorkingDayEndTime(Calendar cal) {
        long endTime = this.mWorkShift.getWorkingDayEndTime(cal);
        CalendarUtil.setMilliSecOfDay(cal, endTime);
    }

    public void addWorkingDayTime(Calendar cal, long duration) {
        long addedTime = this.mWorkShift.getAddedWorkingDayTime(cal, duration);
        CalendarUtil.setMilliSecOfDay(cal, addedTime);
    }

    public void subtractWorkingDayTime(Calendar cal, long duration) {
        long addedTime = this.mWorkShift.getSubtractedWorkingDayTime(cal, duration);
        CalendarUtil.setMilliSecOfDay(cal, addedTime);
    }
}

