/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.calendar;

import java.util.Calendar;
import oracle.bpm.services.organization.impl.calendar.AbstractHolidayPattern;
import oracle.bpm.services.organization.impl.calendar.CalendarUtil;
import oracle.bpm.services.organization.model.HolidayType;

public class NthWeekDayOfMonthHolidayPattern
extends AbstractHolidayPattern {
    private int month;
    private int Nth;
    private int weekDay;

    public NthWeekDayOfMonthHolidayPattern(HolidayType holiday) {
        super(holiday);
        this.Nth = holiday.getNth().intValue();
        this.weekDay = CalendarUtil.convertFromJAXBWeekDayToCalendarWeekDay(holiday.getWeekDay());
        this.month = CalendarUtil.convertFromJAXBMonthToCalendarMonth(holiday.getMonth());
    }

    @Override
    public boolean isHoliday(Calendar cal) {
        if (cal.get(2) != this.month) {
            return false;
        }
        if (cal.get(7) != this.weekDay) {
            return false;
        }
        if (this.Nth > 0) {
            if (cal.get(8) != this.Nth) {
                return false;
            }
        } else {
            Calendar cpyCal = (Calendar)cal.clone();
            int refmonth = cpyCal.get(2);
            int weeksToEndOfMonth = 0;
            for (int i = 1; i <= 5; ++i) {
                cpyCal.add(5, 7);
                if (refmonth == cpyCal.get(2)) continue;
                weeksToEndOfMonth = i;
                break;
            }
            if (weeksToEndOfMonth != -this.Nth) {
                return false;
            }
        }
        this.debugLog("isHoliday", "day : " + cal.getTime() + " : NthWeekDayOfMonthHolidayPattern : Nth : " + this.Nth + ", weekday : " + this.weekDay + ", month : " + this.month);
        this.debugLog("isHoliday", "OUT");
        return true;
    }

    private void debugLog(String method, String msg) {
        this.debugLog("NthWeekDayOfMonthHolidayPattern", method, msg);
    }
}

