/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.calendar;

import java.util.Calendar;
import java.util.List;
import oracle.bpm.services.organization.impl.calendar.AbstractWorkShift;
import oracle.bpm.services.organization.impl.calendar.CalendarUtil;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.WeekDaysEnum;
import oracle.bpm.services.organization.model.WorkPeriodType;
import oracle.bpm.services.organization.model.WorkdayType;

public class DefaultWorkShiftPattern
extends AbstractWorkShift {
    long[] firstHalfEndTime = null;
    long[] firstHalfStartTime = null;
    long[] secondHalffEndTime = null;
    long[] secondHalfStartTime = null;
    WorkdayType[] workDays = new WorkdayType[7];
    private static final int SUNDAY = 0;
    private static final int MONDAY = 1;
    private static final int TUESDAY = 2;
    private static final int WEDNESDAY = 3;
    private static final int THURSDAY = 4;
    private static final int FRIDAY = 5;
    private static final int SATURDAY = 6;

    public DefaultWorkShiftPattern(CalendarRule cal) {
        super(cal);
        this.firstHalfStartTime = new long[7];
        this.firstHalfEndTime = new long[7];
        this.secondHalfStartTime = new long[7];
        this.secondHalffEndTime = new long[7];
        List wDayList = cal.getWorkdayList().getWorkday();
        if (wDayList != null && wDayList.size() > 0) {
            for (int i = 0; i < wDayList.size(); ++i) {
                WorkdayType wDay = (WorkdayType)wDayList.get(i);
                int weekDayNum = this.convertFromJAXBWeekDay(wDay.getWeekDay());
                this.workDays[weekDayNum] = wDay;
                List wPrdList = wDay.getWorkPeriod();
                for (int j = 0; j < wPrdList.size(); ++j) {
                    WorkPeriodType wPrd = (WorkPeriodType)wPrdList.get(j);
                    if (j == 0) {
                        this.firstHalfStartTime[weekDayNum] = CalendarUtil.getMilliSecOfDay(wPrd.getStartTime().toGregorianCalendar());
                        this.firstHalfEndTime[weekDayNum] = CalendarUtil.getMilliSecOfDay(wPrd.getEndTime().toGregorianCalendar());
                        this.secondHalffEndTime[weekDayNum] = 0L;
                        this.secondHalfStartTime[weekDayNum] = 0L;
                        continue;
                    }
                    long startTime = CalendarUtil.getMilliSecOfDay(wPrd.getStartTime().toGregorianCalendar());
                    long endTime = CalendarUtil.getMilliSecOfDay(wPrd.getEndTime().toGregorianCalendar());
                    if (this.firstHalfStartTime[weekDayNum] == 0L && this.firstHalfEndTime[weekDayNum] == 0L || this.firstHalfStartTime[weekDayNum] > startTime) {
                        this.secondHalfStartTime[weekDayNum] = this.firstHalfStartTime[weekDayNum];
                        this.secondHalffEndTime[weekDayNum] = this.firstHalfEndTime[weekDayNum];
                        this.firstHalfStartTime[weekDayNum] = startTime;
                        this.firstHalfEndTime[weekDayNum] = endTime;
                        continue;
                    }
                    this.secondHalfStartTime[weekDayNum] = startTime;
                    this.secondHalffEndTime[weekDayNum] = endTime;
                }
            }
        }
    }

    @Override
    public boolean isWorkDay(Calendar cal) {
        boolean isWorkDay = false;
        if (this.workDays[this.convertFromCalendarWeekDay(cal.get(7))] != null) {
            isWorkDay = true;
        }
        return isWorkDay;
    }

    @Override
    public long getWorkingDayDuration(Calendar cal) {
        int weekDayNum = this.convertFromCalendarWeekDay(cal.get(7));
        return this.getTimeAvailableInFirstHalf(weekDayNum) + this.getTimeAvailableInSecondHalf(weekDayNum);
    }

    @Override
    public long getRemainingWorkingDayDuration(Calendar cal) {
        int weekDayNum = this.convertFromCalendarWeekDay(cal.get(7));
        long calTime = CalendarUtil.getMilliSecOfDay(cal);
        this.debugLog("getRemainingWorkingDayDuration", "calTime : " + calTime + this.weekDayDebugMsg(weekDayNum));
        switch (this.getWorkTimeWindow(weekDayNum, calTime)) {
            case BEFORE_WORK_HOURS: {
                return this.getTimeAvailableInFirstHalf(weekDayNum) + this.getTimeAvailableInSecondHalf(weekDayNum);
            }
            case WITHIN_FIRST_HALF: {
                return this.getRemainingTimeInFirstHalf(weekDayNum, calTime) + this.getTimeAvailableInSecondHalf(weekDayNum);
            }
            case BETWEEN_FIRST_AND_SECOND_HALF: {
                return this.getTimeAvailableInSecondHalf(weekDayNum);
            }
            case WITHIN_SECOND_HALF: {
                return this.getRemainingTimeInSecondHalf(weekDayNum, calTime);
            }
            case AFTER_WORK_HOURS: {
                return 0L;
            }
        }
        return -1L;
    }

    @Override
    public long getElapsedWorkingDayDuration(Calendar cal) {
        int weekDayNum = this.convertFromCalendarWeekDay(cal.get(7));
        long calTime = CalendarUtil.getMilliSecOfDay(cal);
        this.debugLog("getElapsedWorkingDayDuration", "calTime : " + calTime + this.weekDayDebugMsg(weekDayNum));
        switch (this.getWorkTimeWindow(weekDayNum, calTime)) {
            case BEFORE_WORK_HOURS: {
                return 0L;
            }
            case WITHIN_FIRST_HALF: {
                return this.getElapsedTimeInFirstHalf(weekDayNum, calTime);
            }
            case BETWEEN_FIRST_AND_SECOND_HALF: {
                return this.getTimeAvailableInFirstHalf(weekDayNum);
            }
            case WITHIN_SECOND_HALF: {
                return this.getTimeAvailableInFirstHalf(weekDayNum) + this.getElapsedTimeInSecondHalf(weekDayNum, calTime);
            }
            case AFTER_WORK_HOURS: {
                return this.getTimeAvailableInFirstHalf(weekDayNum) + this.getTimeAvailableInSecondHalf(weekDayNum);
            }
        }
        return -1L;
    }

    @Override
    public long getAddedWorkingDayTime(Calendar cal, long duration) {
        int weekDayNum = this.convertFromCalendarWeekDay(cal.get(7));
        long calTime = CalendarUtil.getMilliSecOfDay(cal);
        this.debugLog("getAddedWorkingDayTime", "calTime : " + calTime + this.weekDayDebugMsg(weekDayNum));
        switch (this.getWorkTimeWindow(weekDayNum, calTime)) {
            case BEFORE_WORK_HOURS: {
                long addedTime = this.firstHalfStartTime[weekDayNum] + duration;
                if (addedTime <= this.firstHalfEndTime[weekDayNum]) {
                    return addedTime;
                }
                long spillTime = addedTime - this.firstHalfEndTime[weekDayNum];
                return this.secondHalfStartTime[weekDayNum] + spillTime;
            }
            case WITHIN_FIRST_HALF: {
                long addedTime = calTime + duration;
                if (addedTime <= this.firstHalfEndTime[weekDayNum]) {
                    return addedTime;
                }
                long spillTime = addedTime - this.firstHalfEndTime[weekDayNum];
                return this.secondHalfStartTime[weekDayNum] + spillTime;
            }
            case BETWEEN_FIRST_AND_SECOND_HALF: {
                return this.secondHalfStartTime[weekDayNum] + duration;
            }
            case WITHIN_SECOND_HALF: {
                return calTime + duration;
            }
            case AFTER_WORK_HOURS: {
                return -1L;
            }
        }
        return -1L;
    }

    @Override
    public long getSubtractedWorkingDayTime(Calendar cal, long duration) {
        int weekDayNum = this.convertFromCalendarWeekDay(cal.get(7));
        long calTime = CalendarUtil.getMilliSecOfDay(cal);
        this.debugLog("getSubtractedWorkingDayTime", "calTime : " + calTime + this.weekDayDebugMsg(weekDayNum));
        switch (this.getWorkTimeWindow(weekDayNum, calTime)) {
            case BEFORE_WORK_HOURS: {
                return -1L;
            }
            case WITHIN_FIRST_HALF: {
                return calTime - duration;
            }
            case BETWEEN_FIRST_AND_SECOND_HALF: {
                return this.firstHalfEndTime[weekDayNum] - duration;
            }
            case WITHIN_SECOND_HALF: {
                long subTime = calTime - duration;
                if (subTime > this.secondHalfStartTime[weekDayNum]) {
                    return subTime;
                }
                long spillTime = subTime - this.secondHalfStartTime[weekDayNum];
                return this.firstHalfEndTime[weekDayNum] - spillTime;
            }
            case AFTER_WORK_HOURS: {
                if (this.isSecondHalfDefined(weekDayNum)) {
                    long subTime = this.secondHalffEndTime[weekDayNum] - duration;
                    if (subTime > this.secondHalfStartTime[weekDayNum]) {
                        return subTime;
                    }
                    long spillTime = subTime - this.secondHalfStartTime[weekDayNum];
                    return this.firstHalfEndTime[weekDayNum] - spillTime;
                }
                return this.firstHalfEndTime[weekDayNum] - duration;
            }
        }
        return -1L;
    }

    @Override
    public long getWorkingDayStartTime(Calendar cal) {
        int weekDayNum = this.convertFromCalendarWeekDay(cal.get(7));
        return this.firstHalfStartTime[weekDayNum];
    }

    @Override
    public long getWorkingDayEndTime(Calendar cal) {
        int weekDayNum = this.convertFromCalendarWeekDay(cal.get(7));
        long endTimeInMillis = this.secondHalffEndTime[weekDayNum];
        if (endTimeInMillis == 0L) {
            endTimeInMillis = this.firstHalfEndTime[weekDayNum];
        }
        return endTimeInMillis;
    }

    private long getTimeAvailableInFirstHalf(int weekDayNum) {
        return this.firstHalfEndTime[weekDayNum] - this.firstHalfStartTime[weekDayNum];
    }

    private long getTimeAvailableInSecondHalf(int weekDayNum) {
        return this.secondHalffEndTime[weekDayNum] - this.secondHalfStartTime[weekDayNum];
    }

    private long getRemainingTimeInFirstHalf(int weekDayNum, long calTime) {
        return this.firstHalfEndTime[weekDayNum] - calTime;
    }

    private long getElapsedTimeInFirstHalf(int weekDayNum, long calTime) {
        return calTime - this.firstHalfStartTime[weekDayNum];
    }

    private long getRemainingTimeInSecondHalf(int weekDayNum, long calTime) {
        return this.secondHalffEndTime[weekDayNum] - calTime;
    }

    private long getElapsedTimeInSecondHalf(int weekDayNum, long calTime) {
        return calTime - this.secondHalfStartTime[weekDayNum];
    }

    private boolean isSecondHalfDefined(int weekDayNum) {
        return this.secondHalfStartTime[weekDayNum] != 0L && this.secondHalffEndTime[weekDayNum] != 0L;
    }

    private WorkTimeWindow getWorkTimeWindow(int weekDayNum, long calTime) {
        if (calTime < this.firstHalfStartTime[weekDayNum]) {
            return WorkTimeWindow.BEFORE_WORK_HOURS;
        }
        if (calTime >= this.firstHalfStartTime[weekDayNum] && calTime < this.firstHalfEndTime[weekDayNum]) {
            return WorkTimeWindow.WITHIN_FIRST_HALF;
        }
        if (this.isSecondHalfDefined(weekDayNum) && calTime >= this.firstHalfEndTime[weekDayNum] && calTime < this.secondHalfStartTime[weekDayNum]) {
            return WorkTimeWindow.BETWEEN_FIRST_AND_SECOND_HALF;
        }
        if (this.isSecondHalfDefined(weekDayNum) && calTime >= this.secondHalfStartTime[weekDayNum] && calTime < this.secondHalffEndTime[weekDayNum]) {
            return WorkTimeWindow.WITHIN_SECOND_HALF;
        }
        return WorkTimeWindow.AFTER_WORK_HOURS;
    }

    private int convertFromCalendarWeekDay(int weekDay) {
        switch (weekDay) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        this.debugLog("convertFromCalendarWeekDay", "Unknown weekday : " + weekDay);
        return 1;
    }

    private int convertFromJAXBWeekDay(WeekDaysEnum weekDayEnum) {
        switch (weekDayEnum) {
            case SUNDAY: {
                return 0;
            }
            case MONDAY: {
                return 1;
            }
            case TUESDAY: {
                return 2;
            }
            case WEDNESDAY: {
                return 3;
            }
            case THURSDAY: {
                return 4;
            }
            case FRIDAY: {
                return 5;
            }
            case SATURDAY: {
                return 6;
            }
        }
        this.debugLog("convertFromJAXBWeekDay", "Unknown weekday : " + weekDayEnum);
        return 0;
    }

    private String weekDayDebugMsg(int weekDayNum) {
        return " Weekday Num : " + weekDayNum + ", firstHalfStartTime : " + this.firstHalfStartTime[weekDayNum] + ", firstHalfEndTime : " + this.firstHalfEndTime[weekDayNum] + ", secondHalfStartTime : " + this.secondHalfStartTime[weekDayNum] + ", secondHalffEndTime : " + this.secondHalffEndTime[weekDayNum];
    }

    private void debugLog(String method, String msg) {
        this.debugLog("DefaultWorkShiftPattern", method, msg);
    }

    private static enum WorkTimeWindow {
        BEFORE_WORK_HOURS,
        WITHIN_FIRST_HALF,
        BETWEEN_FIRST_AND_SECOND_HALF,
        WITHIN_SECOND_HALF,
        AFTER_WORK_HOURS,
        UNKNOWN;

    }
}

