/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl.calendar;

import java.util.Calendar;
import java.util.HashMap;
import javax.xml.datatype.Duration;
import oracle.bpm.services.organization.model.MonthsEnum;
import oracle.bpm.services.organization.model.WeekDaysEnum;

public class CalendarUtil {
    private static HashMap<String, String> timeZoneMap = new HashMap();

    public static int convertFromJAXBWeekDayToCalendarWeekDay(WeekDaysEnum weekDayEnum) {
        switch (weekDayEnum) {
            case SUNDAY: {
                return 1;
            }
            case MONDAY: {
                return 2;
            }
            case TUESDAY: {
                return 3;
            }
            case WEDNESDAY: {
                return 4;
            }
            case THURSDAY: {
                return 5;
            }
            case FRIDAY: {
                return 6;
            }
            case SATURDAY: {
                return 7;
            }
        }
        return 1;
    }

    public static int convertFromJAXBMonthToCalendarMonth(MonthsEnum monthEnum) {
        switch (monthEnum) {
            case JANUARY: {
                return 0;
            }
            case FEBRUARY: {
                return 1;
            }
            case MARCH: {
                return 2;
            }
            case APRIL: {
                return 3;
            }
            case MAY: {
                return 4;
            }
            case JUNE: {
                return 5;
            }
            case JULY: {
                return 6;
            }
            case AUGUST: {
                return 7;
            }
            case SEPTEMBER: {
                return 8;
            }
            case OCTOBER: {
                return 9;
            }
            case NOVEMBER: {
                return 10;
            }
            case DECEMBER: {
                return 11;
            }
        }
        return 0;
    }

    public static long getTimeComponentInMillis(Duration duration) {
        return ((duration.getHours() * 60 + duration.getMinutes()) * 60 + duration.getSeconds()) * 1000;
    }

    public static long getMilliSecOfDay(Calendar cal) {
        long calTime = ((cal.get(11) * 60 + cal.get(12)) * 60 + cal.get(13)) * 1000 + cal.get(14);
        return calTime;
    }

    public static void setMilliSecOfDay(Calendar cal, long millis) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.setTimeInMillis(cal.getTimeInMillis() + millis);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1.get(6) != cal2.get(6)) {
            return false;
        }
        return cal1.get(1) == cal2.get(1);
    }

    public static String getLongTimeZoneName(String shortTZName) {
        if (shortTZName.indexOf("/") > 0) {
            return shortTZName;
        }
        String longTZName = timeZoneMap.get(shortTZName);
        if (longTZName != null) {
            return longTZName;
        }
        return shortTZName;
    }

    static {
        timeZoneMap.put("MIT", "Pacific/Apia");
        timeZoneMap.put("HST", "Pacific/Johnston");
        timeZoneMap.put("AST", "America/Anchorage");
        timeZoneMap.put("PST", "America/Los_Angeles");
        timeZoneMap.put("MST", "Etc/GMT+7");
        timeZoneMap.put("Navajo", "US/Mountain");
        timeZoneMap.put("PNT", "America/Phoenix");
        timeZoneMap.put("CST", "America/Chicago");
        timeZoneMap.put("Cuba", "America/Havana");
        timeZoneMap.put("EST", "Etc/GMT+5");
        timeZoneMap.put("IET", "America/Indianapolis");
        timeZoneMap.put("Jamaica", "America/Jamaica");
        timeZoneMap.put("PRT", "America/Puerto_Rico");
        timeZoneMap.put("CNT", "America/St_Johns");
        timeZoneMap.put("AGT", "America/Buenos_Aires");
        timeZoneMap.put("BET", "America/Sao_Paulo");
        timeZoneMap.put("Eire", "Europe/Dublin");
        timeZoneMap.put("GB", "Europe/London");
        timeZoneMap.put("GB-Eire", "Europe/Belfast");
        timeZoneMap.put("GMT", "Etc/GMT");
        timeZoneMap.put("GMT0", "Etc/GMT");
        timeZoneMap.put("Greenwich", "Etc/GMT");
        timeZoneMap.put("Iceland", "Atlantic/Reykjavik");
        timeZoneMap.put("Portugal", "Europe/Lisbon");
        timeZoneMap.put("UCT", "Etc/GMT");
        timeZoneMap.put("UTC", "Etc/GMT");
        timeZoneMap.put("Universal", "Etc/GMT");
        timeZoneMap.put("Zulu", "Etc/Zulu");
        timeZoneMap.put("ECT", "Europe/Paris");
        timeZoneMap.put("Poland", "Europe/Warsaw");
        timeZoneMap.put("ART", "Africa/Cairo");
        timeZoneMap.put("CAT", "Africa/Harare");
        timeZoneMap.put("Egypt", "Africa/Cairo");
        timeZoneMap.put("Israel", "Asia/Jerusalem");
        timeZoneMap.put("Libya", "Africa/Tripoli");
        timeZoneMap.put("Turkey", "Asia/Istanbul");
        timeZoneMap.put("EAT", "Africa/Addis_Ababa");
        timeZoneMap.put("W-SU", "Europe/Moscow");
        timeZoneMap.put("Iran", "Asia/Tehran");
        timeZoneMap.put("NET", "Asia/Yerevan");
        timeZoneMap.put("PLT", "Asia/Karachi");
        timeZoneMap.put("IST", "Asia/Calcutta");
        timeZoneMap.put("BST", "Asia/Dhaka");
        timeZoneMap.put("VST", "Asia/Saigon");
        timeZoneMap.put("CTT", "Asia/Shanghai");
        timeZoneMap.put("Hongkong", "Asia/Hong_Kong");
        timeZoneMap.put("PRC", "Asia/Shanghai");
        timeZoneMap.put("Singapore", "Asia/Singapore");
        timeZoneMap.put("JST", "Asia/Tokyo");
        timeZoneMap.put("Japan", "Asia/Tokyo");
        timeZoneMap.put("ROK", "Asia/Seoul");
        timeZoneMap.put("ACT", "Australia/Darwin");
        timeZoneMap.put("AET", "Australia/Sydney");
        timeZoneMap.put("SST", "Pacific/Guadalcanal");
        timeZoneMap.put("Kwajalein", "Pacific/Kwajalein");
        timeZoneMap.put("NST", "Pacific/Auckland");
        timeZoneMap.put("NZ", "Pacific/Auckland");
        timeZoneMap.put("NZ-CHAT", "Pacific/Chatham");
    }
}

