/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.Jaxb20ContextFactory;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.common.IdentityType;
import oracle.bpm.services.organization.common.ObjectFactory;
import oracle.bpm.services.organization.impl.AppRoleUtil;
import oracle.bpm.services.organization.impl.BPMOrganizationUtil;
import oracle.bpm.services.organization.impl.PeopleQueryService;
import oracle.bpm.services.organization.model.ArgumentType;
import oracle.bpm.services.organization.model.AttributeType;
import oracle.bpm.services.organization.model.ClauseType;
import oracle.bpm.services.organization.model.ConditionType;
import oracle.bpm.services.organization.model.GranteesType;
import oracle.bpm.services.organization.model.GroupManagersType;
import oracle.bpm.services.organization.model.GroupOwnersType;
import oracle.bpm.services.organization.model.IdentityTypeValueListType;
import oracle.bpm.services.organization.model.LogicalPeopleGroup;
import oracle.bpm.services.organization.model.ParameterListType;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.PeopleQuery;
import oracle.bpm.services.organization.model.PeopleQueryContext;
import oracle.bpm.services.organization.model.PeopleQueryContextType;
import oracle.bpm.services.organization.model.PeopleQueryType;
import oracle.bpm.services.organization.model.PredicateType;
import oracle.bpm.services.organization.model.PrincipleListType;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.ReporteesType;
import oracle.bpm.services.organization.model.SearchFilterType;
import oracle.bpm.services.organization.model.SearchUserType;
import oracle.bpm.services.organization.model.StatusTypeEnum;
import oracle.bpm.services.organization.model.UserManagementChainType;
import oracle.bpm.services.organization.model.UserManagerType;
import oracle.bpm.services.organization.model.UsersWithPropertiesType;
import oracle.bpm.services.organization.model.ValueListType;
import oracle.bpm.services.organization.persistency.AbstractPersistencyDriver;
import oracle.bpm.services.organization.persistency.BPMLogicalPeopleGroupPersistency;
import oracle.bpm.services.organization.persistency.ExtendedUserPropertiesPersistencyDriver;
import oracle.integration.platform.blocks.FabricConfigManager;
import oracle.soa.management.config.ConfigDefs;
import oracle.soa.management.config.bpmn.BPMNConfig;
import org.quartz.CronTrigger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PeopleQueryUtil {
    private static final String CLASSNAME = "PeopleQueryUtil";
    private static oracle.bpm.services.organization.model.ObjectFactory objectFactory = new oracle.bpm.services.organization.model.ObjectFactory();
    private static ObjectFactory commonObjectFactory = new ObjectFactory();
    private static String DEFAULT_REALM_NAME = AppRoleUtil.getInstance().getDefaultRealmName();
    private static Unmarshaller unMarshaller;
    private static Marshaller marshaller;
    protected static final String CRON_EXPR = "0 0/10 * * * ?";

    public static PeopleQuery getPeopleQuery(String fileName, Logger logger) throws BPMOrganizationException {
        String METHOD = "getPeopleQuery";
        PeopleQueryUtil.debugLog("getPeopleQuery", "Begin");
        InputStream is = null;
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader classLoader = currentThread.getContextClassLoader();
            is = classLoader.getResourceAsStream(fileName);
            if (is == null) {
                if (logger != null) {
                    logger.log(Level.FINE, "WorkflowServiceClientContext: Cannot find client configuration file: " + fileName);
                }
                PeopleQuery peopleQuery = null;
                return peopleQuery;
            }
            JAXBElement peopleQueryElement = (JAXBElement)unMarshaller.unmarshal(is);
            PeopleQuery peopleQuery = (PeopleQuery)peopleQueryElement.getValue();
            return peopleQuery;
        }
        catch (JAXBException e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getPeopleQuery");
            exCtx.setErrorCode(70912);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
            PeopleQueryUtil.debugLog("getPeopleQuery", "End");
        }
    }

    public static PeopleQuery getPeopleQuery(Node node) throws BPMOrganizationException {
        try {
            return (PeopleQuery)unMarshaller.unmarshal(node);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    public static String getPeopleQueryAsString(PeopleQuery peopleQuery) throws BPMOrganizationException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            marshaller.marshal((Object)peopleQuery, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    public static PeopleQuery getPeopleQueryFromXMLString(String peopleQueryXML) throws BPMOrganizationException {
        try {
            if (peopleQueryXML == null) {
                return null;
            }
            Document doc = XMLUtil.parseDocumentFromXMLString((String)peopleQueryXML);
            Element node = doc.getDocumentElement();
            return (PeopleQuery)unMarshaller.unmarshal((Node)node);
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (JAXBException e) {
            String METHOD = "getPeopleQueryFromXMLString";
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getPeopleQueryFromXMLString");
            exCtx.setErrorCode(70912);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public static PeopleQuery getPeopleQueryFromString(String queryString) throws BPMOrganizationException {
        try {
            if (queryString == null) {
                return null;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(queryString.getBytes());
            return (PeopleQuery)unMarshaller.unmarshal((InputStream)stream);
        }
        catch (JAXBException e) {
            String METHOD = "getPeopleQueryFromString";
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getPeopleQueryFromString");
            exCtx.setErrorCode(70912);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    public static LogicalPeopleGroup execute(IBPMContext ctx, LogicalPeopleGroup lpg, AbstractPersistencyDriver.UnitOfWorkHolder uowh) throws BPMOrganizationException {
        if (lpg == null) {
            throw new IllegalArgumentException();
        }
        PeopleQuery peopleQuery = new PeopleQuery(lpg.getPeopleQuery());
        PrincipleListType plt = objectFactory.createPrincipleListType();
        List<Participant> list = PeopleQueryUtil.execute(ctx, peopleQuery, null, uowh);
        List prt = plt.getParticipant();
        for (Participant participant : list) {
            prt.add(participant.getValue());
        }
        lpg.setMembers(plt);
        return lpg;
    }

    public static List<Participant> execute(IBPMContext ctx, String peopleQueryXML, Map<String, String> ctxMap, AbstractPersistencyDriver.UnitOfWorkHolder uowh) throws BPMOrganizationException {
        try {
            PeopleQuery peopleQuery = PeopleQueryUtil.getPeopleQueryFromXMLString(peopleQueryXML);
            PeopleQueryContext peopleQueryCtx = PeopleQueryUtil.getPeopleQueryContext(ctxMap);
            return PeopleQueryUtil.execute(ctx, peopleQuery, peopleQueryCtx, uowh);
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public static List<Participant> execute(IBPMContext ctx, PeopleQuery pq, PeopleQueryContext pqCtx, AbstractPersistencyDriver.UnitOfWorkHolder uowh) throws BPMOrganizationException {
        String METHOD = "execute";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            PeopleQueryUtil.debugLog("execute", "Begin");
        }
        if (pq == null) {
            return new ArrayList<Participant>();
        }
        try {
            PredicateType predicateType;
            Participant participant;
            PeopleQueryType pqt = (PeopleQueryType)pq.getValue();
            PeopleQueryUtil.debugLog("execute", "People Query original request: \n" + PeopleQueryUtil.getPeopleQueryAsString(pq));
            PeopleQueryType npqt = PeopleQueryUtil.resolveRuntimeContext(pqt, pqCtx);
            PeopleQuery peopleQuery = new PeopleQuery(npqt);
            PeopleQueryUtil.debugLog("execute", "People Query argument bind request: \n" + PeopleQueryUtil.getPeopleQueryAsString(peopleQuery));
            PeopleQueryService pqs = new PeopleQueryService();
            List<Participant> list = new ArrayList();
            SearchUserType sut = npqt.getSearchUsers();
            GranteesType gt = npqt.getGrantees();
            GroupManagersType gmt = npqt.getGroupManagers();
            GroupOwnersType got = npqt.getGroupOwners();
            ReporteesType rt = npqt.getReportees();
            UserManagerType umt = npqt.getUserManager();
            UserManagementChainType umct = npqt.getUserManagementChain();
            UsersWithPropertiesType userWithProp = npqt.getUsersWithProperties();
            PredicateType pt = npqt.getPredicate();
            boolean participantDefined = true;
            if (sut != null) {
                list = pqs.searchUsers(sut);
            } else if (gt != null) {
                list = pqs.getGrantees(gt);
            } else if (umct != null) {
                list = pqs.getManagementChain(umct);
            } else if (gmt != null) {
                list = pqs.getGroupManagers(gmt);
            } else if (got != null) {
                list = pqs.getGroupOwners(got);
            } else if (rt != null) {
                list = pqs.getReportees(rt);
            } else if (umt != null) {
                participant = pqs.getUserManager(umt);
                if (participant != null) {
                    list.add(participant);
                }
            } else {
                participantDefined = false;
            }
            if (participantDefined && list.size() == 0) {
                PeopleQueryUtil.debugLog("execute", "Returning empty list from people query result from Identity Provider , no pariticpants found.");
                participant = list;
                return participant;
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                PeopleQueryUtil.debugLog("execute", "People Query result size from Identity Provider :" + list.size());
                String msg = null;
                for (Participant p : list) {
                    if (msg == null) {
                        msg = ((PrincipleRefType)p.getValue()).getName();
                        continue;
                    }
                    msg = msg + ", " + ((PrincipleRefType)p.getValue()).getName();
                }
                PeopleQueryUtil.debugLog("execute", "List of participants from Identity Provider:" + msg);
            }
            if (userWithProp != null && (predicateType = userWithProp.getPredicate()) != null) {
                Object msg1;
                oracle.bpm.services.organization.model.Predicate predicate = new oracle.bpm.services.organization.model.Predicate(predicateType);
                list = PeopleQueryUtil.getParticipantsWithProperties(ctx, list, predicate, uowh);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    msg1 = "\nFinal People Query result size :" + list.size();
                    String msg2 = null;
                    for (Participant p : list) {
                        if (msg2 == null) {
                            msg2 = ((PrincipleRefType)p.getValue()).getName();
                            continue;
                        }
                        msg2 = msg2 + ", " + ((PrincipleRefType)p.getValue()).getName();
                    }
                    PeopleQueryUtil.debugLog("execute", (String)msg1 + "\n\t Participants:" + msg2);
                }
                msg1 = list;
                return msg1;
            }
            if (pt != null) {
                oracle.bpm.services.organization.model.Predicate predicate = new oracle.bpm.services.organization.model.Predicate(pt);
                list = PeopleQueryUtil.getParticipantsWithProperties(ctx, list, predicate, uowh);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    String msg1 = "\nFinal People Query result size :" + list.size();
                    String msg2 = null;
                    for (Participant p : list) {
                        if (msg2 == null) {
                            msg2 = ((PrincipleRefType)p.getValue()).getName();
                            continue;
                        }
                        msg2 = msg2 + ", " + ((PrincipleRefType)p.getValue()).getName();
                    }
                    PeopleQueryUtil.debugLog("execute", msg1 + "\n\t Participants:" + msg2);
                }
                List<Participant> list2 = list;
                return list2;
            }
            List<Participant> list3 = list;
            return list3;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "execute");
            exCtx.setErrorCode(70907);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                PeopleQueryUtil.debugLog("execute", "End");
            }
        }
    }

    public static PeopleQueryContext getPeopleQueryContextFromElem(Element elem) throws BPMOrganizationException {
        try {
            return (PeopleQueryContext)PeopleQueryUtil.unmarshallFromElement(elem, "peopleQueryContext", "http://xmlns.oracle.com/bpm/lpg/peopleQuery");
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public static PeopleQuery getPeopleQueryFromElem(Element elem) throws BPMOrganizationException {
        try {
            return (PeopleQuery)PeopleQueryUtil.unmarshallFromElement(elem, "peopleQuery", "http://xmlns.oracle.com/bpm/lpg/peopleQuery");
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public static Object unmarshallFromElement(Element parentElem, String elementName, String namespace) throws BPMOrganizationException {
        Object jaxbObj = null;
        try {
            Element elem = XMLUtil.getFirstChildElement((Element)parentElem, (String)namespace, (String)elementName);
            jaxbObj = unMarshaller.unmarshal((Node)elem);
        }
        catch (Exception e) {
            Object[] objs = new Object[]{namespace + ':' + elementName, PeopleQueryUtil.getJaxbContextString(), e.getMessage()};
            throw new BPMOrganizationException(70920, objs, e);
        }
        return jaxbObj;
    }

    public static Document getNewDocument() throws Exception {
        DocumentBuilderFactory dbf = XMLUtil.getDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.newDocument();
    }

    public static PeopleQueryContext getPeopleQueryContext(Map<String, String> map) {
        PeopleQueryContextType peopleQueryCtxType = objectFactory.createPeopleQueryContextType();
        List list = peopleQueryCtxType.getArgument();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            ArgumentType arg = objectFactory.createArgumentType();
            arg.setName(name);
            arg.setValue(value);
            list.add(arg);
        }
        return new PeopleQueryContext(peopleQueryCtxType);
    }

    public static PeopleQueryType resolveRuntimeContext(PeopleQueryType pqt, PeopleQueryContext pqCtx) throws BPMOrganizationException {
        SearchFilterType nsft;
        SearchFilterType sft;
        if (pqt == null || pqCtx == null) {
            return pqt;
        }
        HashMap<String, String> ctxMap = new HashMap<String, String>();
        List list = ((PeopleQueryContextType)pqCtx.getValue()).getArgument();
        for (ArgumentType arg : list) {
            ctxMap.put(arg.getName(), arg.getValue());
        }
        PeopleQueryType npqt = objectFactory.createPeopleQueryType();
        npqt.setTimeout(pqt.getTimeout());
        SearchUserType sut = pqt.getSearchUsers();
        GranteesType gt = pqt.getGrantees();
        GroupManagersType gmt = pqt.getGroupManagers();
        GroupOwnersType got = pqt.getGroupOwners();
        ReporteesType rt = pqt.getReportees();
        UserManagerType umt = pqt.getUserManager();
        PredicateType pt = pqt.getPredicate();
        UsersWithPropertiesType userWithProp = pqt.getUsersWithProperties();
        UserManagementChainType umct = pqt.getUserManagementChain();
        if (sut != null) {
            AttributeType at = sut.getAttribute();
            sft = sut.getFilter();
            SearchUserType nsut = objectFactory.createSearchUserType();
            nsut.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, sut.getIdentityContext()));
            if (at != null) {
                AttributeType nat = objectFactory.createAttributeType();
                String name = PeopleQueryUtil.getValue(ctxMap, at.getName());
                nat.setName(name);
                String value = PeopleQueryUtil.getValue(ctxMap, at.getValue());
                nat.setValue(value);
                nsut.setAttribute(nat);
            } else if (sft != null) {
                SearchFilterType nsft2 = PeopleQueryUtil.createSearchFilterType(ctxMap, sft);
                nsut.setFilter(nsft2);
            }
            npqt.setSearchUsers(nsut);
        } else if (gt != null) {
            GranteesType ngt = objectFactory.createGranteesType();
            ngt.setGroup(PeopleQueryUtil.getValue(ctxMap, gt.getGroup()));
            sft = gt.getFilter();
            nsft = PeopleQueryUtil.createSearchFilterType(ctxMap, sft);
            ngt.setFilter(nsft);
            ngt.setRole(PeopleQueryUtil.getValue(ctxMap, gt.getRole()));
            ngt.setApplication(PeopleQueryUtil.getValue(ctxMap, gt.getApplication()));
            boolean direct = gt.isDirect();
            ngt.setDirect(direct);
            npqt.setGrantees(ngt);
        } else if (umct != null) {
            UserManagementChainType numtc = objectFactory.createUserManagementChainType();
            numtc.setUser(PeopleQueryUtil.getValue(ctxMap, umct.getUser()));
            numtc.setTitle(PeopleQueryUtil.getValue(ctxMap, umct.getTitle()));
            numtc.setUptoUser(PeopleQueryUtil.getValue(ctxMap, umct.getUptoUser()));
            numtc.setLevel(umct.getLevel());
            numtc.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, umct.getIdentityContext()));
            npqt.setUserManagementChain(numtc);
        } else if (gmt != null) {
            GroupManagersType ngmt = objectFactory.createGroupManagersType();
            ngmt.setGroup(PeopleQueryUtil.getValue(ctxMap, gmt.getGroup()));
            ngmt.setDirect(gmt.isDirect());
            sft = gmt.getFilter();
            nsft = PeopleQueryUtil.createSearchFilterType(ctxMap, sft);
            ngmt.setFilter(nsft);
            ngmt.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, gmt.getIdentityContext()));
            npqt.setGroupManagers(ngmt);
        } else if (got != null) {
            GroupOwnersType ngot = objectFactory.createGroupOwnersType();
            ngot.setGroup(PeopleQueryUtil.getValue(ctxMap, got.getGroup()));
            ngot.setDirect(got.isDirect());
            sft = got.getFilter();
            nsft = PeopleQueryUtil.createSearchFilterType(ctxMap, sft);
            ngot.setFilter(nsft);
            ngot.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, got.getIdentityContext()));
            npqt.setGroupOwners(ngot);
        } else if (rt != null) {
            ReporteesType nrt = objectFactory.createReporteesType();
            nrt.setUser(PeopleQueryUtil.getValue(ctxMap, rt.getUser()));
            nrt.setLevel(rt.getLevel());
            nrt.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, rt.getIdentityContext()));
            npqt.setReportees(nrt);
        } else if (umt != null) {
            UserManagerType numt = objectFactory.createUserManagerType();
            numt.setUser(PeopleQueryUtil.getValue(ctxMap, umt.getUser()));
            numt.setIdentityContext(PeopleQueryUtil.getValue(ctxMap, umt.getIdentityContext()));
            npqt.setUserManager(numt);
        }
        if (userWithProp != null) {
            UsersWithPropertiesType nUserWithProp = objectFactory.createUsersWithPropertiesType();
            PredicateType upt = userWithProp.getPredicate();
            PredicateType nupt = PeopleQueryUtil.cloneWithValue(upt, ctxMap);
            nUserWithProp.setPredicate(nupt);
            npqt.setUsersWithProperties(nUserWithProp);
        }
        if (pt != null) {
            PredicateType npt = PeopleQueryUtil.cloneWithValue(pt, ctxMap);
            npqt.setPredicate(npt);
        }
        return npqt;
    }

    public static String getJaxbContextString() {
        return "oracle.bpel.services.bpm.lpg.model";
    }

    public static void debugLog(String method, String message) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASSNAME, (String)method, (String)message);
        }
    }

    public static void print(String message, Object object) {
        BPMLogicalPeopleGroupPersistency.print(message, object);
    }

    public static String getTimeout(LogicalPeopleGroup lpg) {
        String timeout = lpg.getTimeout();
        if (timeout == null) {
            timeout = lpg.getPeopleQuery().getTimeout();
        }
        if (timeout == null) {
            timeout = PeopleQueryUtil.getDefaultPeopleQueryTimeout();
        }
        if (timeout == null) {
            timeout = CRON_EXPR;
        }
        return timeout;
    }

    public static String getDefaultPeopleQueryTimeout() {
        try {
            BPMNConfig bpmnConfigObj = (BPMNConfig)FabricConfigManager.loadConfigObject((String)ConfigDefs.URL_BPMN_CONFIG);
            String peopleQueryTimeout = bpmnConfigObj.getPeopleQueryTimeout();
            if (peopleQueryTimeout == null || peopleQueryTimeout.isEmpty()) {
                return CRON_EXPR;
            }
            return peopleQueryTimeout;
        }
        catch (Exception exception) {
            return CRON_EXPR;
        }
    }

    public static void setCreateUpdateInfo(IBPMContext ctx, LogicalPeopleGroup lpg, boolean isCreated, boolean isExecuted) throws BPMOrganizationException {
        String METHOD = "setCreateUpdateInfo";
        XMLGregorianCalendar calendar = AbstractPersistencyDriver.getXMLGregorianCalendar(Calendar.getInstance());
        String identityContext = ctx.getIdentityContext();
        if (WorkflowUtil.isNull((String)identityContext)) {
            identityContext = DEFAULT_REALM_NAME;
        }
        if (isCreated) {
            lpg.setCreatedBy(ctx.getUser());
            lpg.setCreatedDate(calendar);
            lpg.setCreatedByIdentityContext(identityContext);
        }
        lpg.setLastUpdatedBy(ctx.getUser());
        lpg.setLastUpdatedDate(calendar);
        lpg.setLastUpdatedByIdentityContext(identityContext);
        if (isExecuted) {
            lpg.setLastExecutedDate(calendar);
        }
        if (StatusTypeEnum.ENABLED.equals((Object)lpg.getStatus())) {
            XMLGregorianCalendar gregExpCal = PeopleQueryUtil.getExpirationTime(lpg);
            if (gregExpCal != null) {
                lpg.setExpirationTime(gregExpCal);
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASSNAME, "setCreateUpdateInfo", "Cron Trigger Name=" + lpg.getName() + " trigger group=" + "PeopleQueryGroup" + " Timeout expression: " + PeopleQueryUtil.getTimeout(lpg) + " Next fire time: " + gregExpCal);
            }
        }
    }

    public static XMLGregorianCalendar getExpirationTime(LogicalPeopleGroup lpg) throws BPMOrganizationException {
        String METHOD = "getExpirationTime";
        try {
            String timeout = PeopleQueryUtil.getTimeout(lpg);
            CronTrigger ct = new CronTrigger(lpg.getId(), "PeopleQueryGroup", timeout);
            Calendar expCal = Calendar.getInstance();
            Date date = ct.getFireTimeAfter(expCal.getTime());
            XMLGregorianCalendar gregExpCal = null;
            if (date != null) {
                expCal.setTime(date);
                gregExpCal = AbstractPersistencyDriver.getXMLGregorianCalendar(expCal);
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASSNAME, "getExpirationTime", "Cron Trigger Name=" + lpg.getName() + " trigger group=" + "PeopleQueryGroup" + " Cron timeout expression: " + timeout + " Next fire time: " + date);
            }
            return gregExpCal;
        }
        catch (ParseException e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getExpirationTime");
            exCtx.setErrorCode(70918);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
    }

    public static boolean isParamentricQuery(PeopleQueryType pqt) {
        if (pqt == null) {
            return false;
        }
        ParameterListType lpgParameterListType = pqt.getParameters();
        return lpgParameterListType != null && lpgParameterListType.getParameter() != null && lpgParameterListType.getParameter().size() != 0;
    }

    private static PredicateType cloneWithValue(PredicateType pt, Map<String, String> ctxMap) {
        if (pt == null) {
            return null;
        }
        PredicateType npt = objectFactory.createPredicateType();
        npt.setLogicalOperator(pt.getLogicalOperator());
        List ctList = pt.getClause();
        List nctList = npt.getClause();
        if (ctList != null) {
            for (ClauseType ct : ctList) {
                IdentityTypeValueListType itvlt;
                IdentityType it;
                if (ct == null) continue;
                ClauseType nct = objectFactory.createClauseType();
                nctList.add(nct);
                if (ct.isSetIgnoreCase()) {
                    nct.setIgnoreCase(ct.isIgnoreCase());
                }
                nct.setColumnValue(ct.getColumnValue());
                nct.setColumn(ct.getColumn());
                XMLGregorianCalendar gregCal = ct.getDateValue();
                if (gregCal != null) {
                    nct.setDateValue((XMLGregorianCalendar)gregCal.clone());
                }
                if ((it = ct.getIdentityTypeValue()) != null) {
                    IdentityType nit = PeopleQueryUtil.clone(it);
                    nct.setIdentityTypeValue(nit);
                }
                if ((itvlt = ct.getIdentityTypeValueList()) != null) {
                    IdentityTypeValueListType nitvlt = objectFactory.createIdentityTypeValueListType();
                    nct.setIdentityTypeValueList(nitvlt);
                    List itList = itvlt.getValue();
                    List nitList = nitvlt.getValue();
                    for (IdentityType _it : itList) {
                        IdentityType nit = PeopleQueryUtil.clone(_it);
                        nitList.add(nit);
                    }
                }
                nct.setJoinOperator(ct.getJoinOperator());
                nct.setOperator(ct.getOperator());
                String value = ct.getValue();
                value = PeopleQueryUtil.getValue(ctxMap, value);
                nct.setValue(value);
                ValueListType vlt = ct.getValueList();
                if (vlt == null) continue;
                ValueListType nvlt = objectFactory.createValueListType();
                List valueList = vlt.getValue();
                List nvalueList = nvlt.getValue();
                for (String val : valueList) {
                    String nv = PeopleQueryUtil.getValue(ctxMap, val);
                    nvalueList.add(nv);
                }
                nct.setValueList(nvlt);
            }
            PredicateType rhs = pt.getRhs();
            PredicateType lhs = pt.getLhs();
            if (lhs != null) {
                PredicateType nlhs = PeopleQueryUtil.cloneWithValue(lhs, ctxMap);
                npt.setLhs(nlhs);
            }
            if (rhs != null) {
                PredicateType nrhs = PeopleQueryUtil.cloneWithValue(rhs, ctxMap);
                npt.setRhs(nrhs);
            }
        }
        return npt;
    }

    private static IdentityType clone(IdentityType it) {
        if (it == null) {
            return null;
        }
        IdentityType nit = commonObjectFactory.createIdentityType();
        nit.setDisplayName(it.getDisplayName());
        nit.setId(it.getId());
        nit.setSystemVersionFlag(it.getSystemVersionFlag());
        nit.setType(it.getType());
        return nit;
    }

    private static String getValue(Map<String, String> contextMap, String argName) {
        if (argName == null) {
            return null;
        }
        String value = argName;
        if (argName.startsWith("$")) {
            String key = argName.substring(1);
            value = contextMap.get(key);
        }
        return value;
    }

    private static SearchFilterType createSearchFilterType(Map<String, String> ctxMap, SearchFilterType sft) {
        ConditionType ct;
        if (sft == null) {
            return null;
        }
        SearchFilterType nsft = objectFactory.createSearchFilterType();
        if (sft.getLhs() != null) {
            SearchFilterType nlht = PeopleQueryUtil.createSearchFilterType(ctxMap, sft.getLhs());
            nsft.setLhs(nlht);
        }
        nsft.setLogicalOperator(sft.getLogicalOperator());
        if (sft.getRhs() != null) {
            SearchFilterType nrht = PeopleQueryUtil.createSearchFilterType(ctxMap, sft.getRhs());
            nsft.setRhs(nrht);
        }
        if ((ct = sft.getCondition()) != null) {
            ConditionType nct = objectFactory.createConditionType();
            nct.setAttribute(PeopleQueryUtil.getValue(ctxMap, ct.getAttribute()));
            nct.setOperator(ct.getOperator());
            nct.setValue(PeopleQueryUtil.getValue(ctxMap, ct.getValue()));
            nsft.setCondition(nct);
        }
        return nsft;
    }

    private static List<Participant> getParticipantsWithProperties(IBPMContext ctx, List<Participant> participants, oracle.bpm.services.organization.model.Predicate predicate, AbstractPersistencyDriver.UnitOfWorkHolder uowh) throws BPMOrganizationException {
        String METHOD = "getParticipantsWithProperties";
        PeopleQueryUtil.debugLog("getParticipantsWithProperties", "Begin");
        try {
            if (predicate == null) {
                List<Participant> list = participants;
                return list;
            }
            oracle.bpel.services.workflow.query.model.PredicateType queryPredicateType = BPMOrganizationUtil.convertJAXB2PredicateIntoJAXB1Predicate((PredicateType)predicate.getValue());
            Predicate repos_predicate = new Predicate(queryPredicateType);
            ExtendedUserPropertiesPersistencyDriver eupPersistenceDriver = ExtendedUserPropertiesPersistencyDriver.getInstance();
            List<Participant> list = eupPersistenceDriver.getParticipantsWithProperties(participants, repos_predicate, 1, Integer.MAX_VALUE, uowh);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                PeopleQueryUtil.debugLog("getParticipantsWithProperties", "Participants with properties, list size=" + list.size());
            }
            List<Participant> list2 = list;
            return list2;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getParticipantsWithProperties");
            exCtx.setErrorCode(70907);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            PeopleQueryUtil.debugLog("getParticipantsWithProperties", "End");
        }
    }

    static {
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = Jaxb20ContextFactory.getJAXBContext((String)"oracle.bpm.services.organization.model");
            unMarshaller = jaxbContext.createUnmarshaller();
            marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

