/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.IPeopleQueryService;
import oracle.bpm.services.organization.model.ConditionType;
import oracle.bpm.services.organization.model.GranteesType;
import oracle.bpm.services.organization.model.GroupManagersType;
import oracle.bpm.services.organization.model.GroupOwnersType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.ReporteesType;
import oracle.bpm.services.organization.model.SearchFilterType;
import oracle.bpm.services.organization.model.SearchUserType;
import oracle.bpm.services.organization.model.UserManagementChainType;
import oracle.bpm.services.organization.model.UserManagerType;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMAuthorizationService;
import oracle.tip.pc.services.identity.BPMIdentity;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMUser;
import oracle.tip.pc.services.identity.ComplexSearchFilter;
import oracle.tip.pc.services.identity.SearchFilter;

public class PeopleQueryService
implements IPeopleQueryService {
    private final ObjectFactory objectFactory = new ObjectFactory();

    public List<Participant> searchUsers(SearchUserType sut) throws BPMOrganizationException {
        try {
            String identityCtx = sut.getIdentityContext();
            BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance((String)identityCtx);
            ArrayList<Participant> list = new ArrayList<Participant>();
            List userList = null;
            if (sut.getAttribute() != null) {
                String attrName = sut.getAttribute().getName();
                String attrPatternValue = sut.getAttribute().getValue();
                userList = as.searchUsers(attrName, attrPatternValue);
            } else if (sut.getFilter() != null) {
                SearchFilterType sft = sut.getFilter();
                ComplexSearchFilter csf = PeopleQueryService.getUserSearchFilter(sft, identityCtx);
                userList = as.searchUsers((SearchFilter)csf);
            }
            for (Object user : userList) {
                BPMUser bpmUser = (BPMUser)user;
                PrincipleRefType principle = this.objectFactory.createPrincipleRefType();
                principle.setName(bpmUser.getName());
                principle.setRealm(bpmUser.getRealmName());
                principle.setType(ParticipantTypeEnum.USER);
                list.add(new Participant(principle));
            }
            return list;
        }
        catch (BPMIdentityException e) {
            throw new BPMOrganizationException((Exception)((Object)e));
        }
    }

    public List<Participant> getReportees(ReporteesType rt) throws BPMOrganizationException {
        try {
            String identityCtx = rt.getIdentityContext();
            BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance((String)identityCtx);
            ArrayList<Participant> list = new ArrayList<Participant>();
            String user = rt.getUser();
            int level = rt.getLevel();
            List userList = as.getReportees(user, level);
            for (Object usr : userList) {
                BPMUser bpmUser = (BPMUser)usr;
                PrincipleRefType principle = this.objectFactory.createPrincipleRefType();
                principle.setName(bpmUser.getName());
                principle.setRealm(bpmUser.getRealmName());
                principle.setType(ParticipantTypeEnum.USER);
                list.add(new Participant(principle));
            }
            return list;
        }
        catch (BPMIdentityException e) {
            throw new BPMOrganizationException((Exception)((Object)e));
        }
    }

    public Participant getUserManager(UserManagerType umt) throws BPMOrganizationException {
        try {
            String identityCtx = umt.getIdentityContext();
            BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance((String)identityCtx);
            String user = umt.getUser();
            BPMUser bpmUser = as.getManager(user);
            PrincipleRefType principle = this.objectFactory.createPrincipleRefType();
            principle.setName(bpmUser.getName());
            principle.setRealm(bpmUser.getRealmName());
            principle.setType(ParticipantTypeEnum.USER);
            return new Participant(principle);
        }
        catch (BPMIdentityException e) {
            throw new BPMOrganizationException((Exception)((Object)e));
        }
    }

    public List<Participant> getManagementChain(UserManagementChainType umct) throws BPMOrganizationException {
        try {
            String identityCtx = umct.getIdentityContext();
            BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance((String)identityCtx);
            ArrayList<Participant> list = new ArrayList<Participant>();
            String user = umct.getUser();
            String title = umct.getTitle();
            String upToUser = umct.getUptoUser();
            int level = umct.getLevel();
            List userList = as.getManagementChain(user, upToUser, title, level);
            for (Object usr : userList) {
                BPMUser bpmUser = (BPMUser)usr;
                PrincipleRefType principle = this.objectFactory.createPrincipleRefType();
                principle.setName(bpmUser.getName());
                principle.setRealm(bpmUser.getRealmName());
                principle.setType(ParticipantTypeEnum.USER);
                list.add(new Participant(principle));
            }
            return list;
        }
        catch (BPMIdentityException e) {
            throw new BPMOrganizationException((Exception)((Object)e));
        }
    }

    public List<Participant> getGrantees(GranteesType gt) throws BPMOrganizationException {
        try {
            boolean direct;
            String identityCtx = gt.getIdentityContext();
            BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance((String)identityCtx);
            ArrayList<Participant> list = new ArrayList<Participant>();
            Set bpmSet = null;
            if (gt.getGroup() != null) {
                String group = gt.getGroup();
                direct = gt.isDirect();
                bpmSet = as.getGranteesToGroup(group, direct);
            } else if (gt.getRole() != null) {
                String role = gt.getRole();
                direct = gt.isDirect();
                String appName = gt.getApplication();
                bpmSet = as.getGranteesToAppRole(role, appName, direct);
            }
            for (BPMIdentity bpmIdentity : bpmSet) {
                if (!(bpmIdentity instanceof BPMUser)) continue;
                PrincipleRefType principle = this.objectFactory.createPrincipleRefType();
                principle.setName(bpmIdentity.getName());
                principle.setRealm(bpmIdentity.getRealmName());
                principle.setType(ParticipantTypeEnum.USER);
                list.add(new Participant(principle));
            }
            return list;
        }
        catch (BPMIdentityException e) {
            throw new BPMOrganizationException((Exception)((Object)e));
        }
    }

    public List<Participant> getGroupManagers(GroupManagersType gmt) throws BPMOrganizationException {
        try {
            String identityCtx = gmt.getIdentityContext();
            BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance((String)identityCtx);
            ArrayList<Participant> list = new ArrayList<Participant>();
            String group = gmt.getGroup();
            boolean direct = gmt.isDirect();
            List bpmList = as.getRoleManagers(group, direct);
            for (Object bpmIdentity : bpmList) {
                if (!(bpmIdentity instanceof BPMUser)) continue;
                BPMUser bpmUser = (BPMUser)bpmIdentity;
                PrincipleRefType principle = this.objectFactory.createPrincipleRefType();
                principle.setName(bpmUser.getName());
                principle.setRealm(bpmUser.getRealmName());
                principle.setType(ParticipantTypeEnum.USER);
                list.add(new Participant(principle));
            }
            return list;
        }
        catch (BPMIdentityException e) {
            throw new BPMOrganizationException((Exception)((Object)e));
        }
    }

    public List<Participant> getGroupOwners(GroupOwnersType got) throws BPMOrganizationException {
        try {
            String identityCtx = got.getIdentityContext();
            BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance((String)identityCtx);
            ArrayList<Participant> list = new ArrayList<Participant>();
            String group = got.getGroup();
            boolean direct = got.isDirect();
            Set bpmSet = as.getRoleOwners(group, direct);
            for (Object bpmIdentity : bpmSet) {
                if (!(bpmIdentity instanceof BPMUser)) continue;
                BPMUser bpmUser = (BPMUser)bpmIdentity;
                PrincipleRefType principle = this.objectFactory.createPrincipleRefType();
                principle.setName(bpmUser.getName());
                principle.setRealm(bpmUser.getRealmName());
                principle.setType(ParticipantTypeEnum.USER);
                list.add(new Participant(principle));
            }
            return list;
        }
        catch (BPMIdentityException e) {
            throw new BPMOrganizationException((Exception)((Object)e));
        }
    }

    private static ComplexSearchFilter getUserSearchFilter(SearchFilterType sft, String identityCtx) throws BPMOrganizationException {
        if (sft == null) {
            return null;
        }
        try {
            SearchFilterType rhs;
            SearchFilterType lhs = sft.getLhs();
            ComplexSearchFilter lsf = null;
            if (lhs != null) {
                lsf = PeopleQueryService.getUserSearchFilter(lhs, identityCtx);
            }
            if (lsf != null) {
                if ("AND".equals(sft.getLogicalOperator().value())) {
                    lsf.setLogicalOperator("AND");
                } else if ("OR".equals(sft.getLogicalOperator().value())) {
                    lsf.setLogicalOperator("OR");
                }
            }
            if ((rhs = sft.getRhs()) != null) {
                ComplexSearchFilter rsf = PeopleQueryService.getUserSearchFilter(rhs, identityCtx);
                if (lsf != null) {
                    lsf.addFilterComponent((SearchFilter)rsf);
                    return lsf;
                }
                return rsf;
            }
            ConditionType ct = sft.getCondition();
            if (ct != null) {
                String at = ct.getAttribute();
                String value = ct.getValue();
                String operator = ct.getOperator().value();
                operator = "EQ".equals(operator) ? "EQUAL" : ("NEQ".equals(operator) ? "NOTEQUAL" : "EQUAL");
                BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance((String)identityCtx);
                return as.getSearchFilterInstance(BPMUser.class, at, operator, value);
            }
            return null;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }
}

