/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.BPMOrganizationService;
import oracle.bpm.services.organization.impl.PeopleQueryPublisher;
import oracle.bpm.services.organization.impl.PeopleQueryUtil;
import oracle.bpm.services.organization.model.LogicalPeopleGroup;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.PeopleQueryType;
import oracle.bpm.services.organization.model.PrincipleListType;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;
import oracle.bpm.services.organization.model.StatusTypeEnum;
import oracle.bpm.services.organization.persistency.BPMLogicalPeopleGroupPersistency;
import oracle.fabric.common.FabricException;
import oracle.integration.platform.blocks.mesh.FabricLifecycleListener;
import oracle.integration.platform.blocks.scheduler.FabricSchedulerFactory;
import oracle.integration.platform.blocks.scheduler.FabricSchedulerService;
import oracle.integration.platform.blocks.scheduler.StringProperties;
import oracle.integration.platform.blocks.scheduler.SystemJob;

public class PeopleQueryExecutor
implements FabricLifecycleListener {
    private BPMOrganizationService service = new BPMOrganizationService();
    private static final String CLASSNAME = "PeopleQueryExecutor";
    private static PeopleQueryExecutor singletonPeopleQueryTimerAgent = new PeopleQueryExecutor();
    private static ObjectFactory objectFactory = new ObjectFactory();
    public static final String CRON_TRIGGER_GROUP_NAME = "PeopleQueryGroup";

    private PeopleQueryExecutor() {
    }

    public static PeopleQueryExecutor getInstance() {
        return new PeopleQueryExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(int newState) {
        String METHOD = "stateChanged";
        PeopleQueryExecutor.debugLog(CLASSNAME, "stateChanged", "Begin");
        if (3 == newState) {
            try {
                this.scheduleExecutionJob(null);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    PeopleQueryExecutor.debugLog(CLASSNAME, "stateChanged", "Execution scheduled");
                }
            }
            catch (Exception we) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS)) {
                    PeopleQueryExecutor.debugLog(CLASSNAME, "stateChanged", "stateChanged");
                }
            }
            finally {
                PeopleQueryExecutor.debugLog(CLASSNAME, "stateChanged", "End");
            }
        }
    }

    public void scheduleExecutionJob(LogicalPeopleGroup lpg) throws BPMOrganizationException {
        String METHOD = "scheduleExecutionJob";
        PeopleQueryExecutor.debugLog(CLASSNAME, "scheduleExecutionJob", "Begin");
        try {
            if (lpg != null) {
                StringProperties props = new StringProperties();
                props.put((Object)"id", (Object)lpg.getId());
                props.put((Object)"name", (Object)lpg.getName());
                String timeout = PeopleQueryUtil.getTimeout(lpg);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    PeopleQueryExecutor.debugLog(CLASSNAME, "scheduleExecutionJob", "timeout=" + timeout);
                }
                PeopleQueryUtil.print("Schedule lpg", lpg);
                this.getScheduler().scheduleJob(CRON_TRIGGER_GROUP_NAME, lpg.getId(), props, timeout, PeopleQueryExecitionJob.class);
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    PeopleQueryExecutor.debugLog(CLASSNAME, "scheduleExecutionJob", "PepoleQueryExecution scheduled for lpgName=" + lpg.getName() + " lpgId=" + lpg.getId());
                }
            } else {
                List<LogicalPeopleGroup> list = this.service.searchLogicalPeopleGroups(PeopleQueryExecutor.getBPMContext(), SearchModeTypeEnum.LIKE, "%", 0, -1);
                FabricSchedulerService fss = this.getScheduler();
                for (LogicalPeopleGroup g : list) {
                    StringProperties props = new StringProperties();
                    props.put((Object)"id", (Object)g.getId());
                    props.put((Object)"name", (Object)g.getName());
                    String timeout = PeopleQueryUtil.getTimeout(g);
                    if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                        PeopleQueryExecutor.debugLog(CLASSNAME, "scheduleExecutionJob", "timeout=" + timeout);
                    }
                    fss.scheduleJob(CRON_TRIGGER_GROUP_NAME, g.getId(), props, timeout, PeopleQueryExecitionJob.class);
                }
            }
        }
        catch (Throwable t) {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS)) {
                PeopleQueryExecutor.debugLog(CLASSNAME, "scheduleExecutionJob", "PepoleQueryExecution scheduled failed");
            }
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "scheduleExecutionJob");
            exCtx.setErrorCode(70909);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable(t);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            PeopleQueryExecutor.debugLog(CLASSNAME, "scheduleExecutionJob", "End");
        }
    }

    public void unscheduleExecutionJob(LogicalPeopleGroup lpg) throws BPMOrganizationException {
        if (lpg == null) {
            throw new BPMOrganizationException((Exception)new IllegalArgumentException());
        }
        String METHOD = "unscheduleExecutionJob";
        PeopleQueryExecutor.debugLog(CLASSNAME, "unscheduleExecutionJob", "Begin");
        try {
            PeopleQueryUtil.print("Unschedule lpg", lpg);
            this.getScheduler().unscheduleJob(CRON_TRIGGER_GROUP_NAME, lpg.getId());
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                PeopleQueryExecutor.debugLog(CLASSNAME, "unscheduleExecutionJob", "PepoleQueryExecution unscheduled for lpgName=" + lpg.getName() + " lpgId=" + lpg.getId());
            }
        }
        catch (Throwable t) {
            PeopleQueryExecutor.debugLog(CLASSNAME, "unscheduleExecutionJob", "PepoleQueryExecution was not unscheduled. Unschedule failed");
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "unscheduleExecutionJob");
            exCtx.setErrorCode(70909);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable(t);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            PeopleQueryExecutor.debugLog(CLASSNAME, "unscheduleExecutionJob", "End");
        }
    }

    public void unscheduleAllExecutionJobs() throws BPMOrganizationException {
        FabricSchedulerService scheduler = this.getScheduler();
        List spl = scheduler.listScheduledJobs(CRON_TRIGGER_GROUP_NAME);
        if (spl == null) {
            PeopleQueryExecutor.debugLog(CLASSNAME, "unscheduleAllExecutionJobs", "no scheduled jobs");
            return;
        }
        for (StringProperties sp : spl) {
            Set set = sp.entrySet();
            for (Map.Entry entry : set) {
                PeopleQueryExecutor.debugLog(CLASSNAME, "unscheduleAllExecutionJobs", "Unschedule job : " + (String)entry.getKey() + " value: " + (String)entry.getValue());
                scheduler.unscheduleJob(CRON_TRIGGER_GROUP_NAME, (String)entry.getKey());
                PeopleQueryExecutor.debugLog(CLASSNAME, "unscheduleAllExecutionJobs", " job: " + (String)entry.getKey() + " was successfully unscheduled");
            }
        }
    }

    public void executePeopleQuery(String lpgId) throws BPMOrganizationException {
        String METHOD = "executePeopleQuery";
        try {
            PeopleQueryExecutor.debugLog(CLASSNAME, "executePeopleQuery", "Begin");
            if (lpgId == null) {
                throw new BPMOrganizationException((Exception)new IllegalArgumentException());
            }
            IBPMContext adminContext = PeopleQueryExecutor.getBPMContext();
            LogicalPeopleGroup lpg = this.service.getLogicalPeopleGroup(adminContext, lpgId);
            if (!StatusTypeEnum.ENABLED.equals((Object)lpg.getStatus())) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)CLASSNAME, (String)"executePeopleQuery", (String)("LogicalPeopleGroup id=" + lpg.getId() + " is in disabled state. It cannot be executed by scheduled event"));
                    PeopleQueryUtil.print("lpg details", lpg);
                }
                return;
            }
            PeopleQueryType pqt = lpg.getPeopleQuery();
            if (PeopleQueryUtil.isParamentricQuery(pqt)) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)CLASSNAME, (String)"executePeopleQuery", (String)("LogicalPeopleGroup id=" + lpg.getId() + " is a parametric. It cannot be executed by scheduled event"));
                    PeopleQueryUtil.print("lpg details", lpg);
                }
                return;
            }
            try {
                lpg = PeopleQueryUtil.execute(adminContext, lpg, null);
            }
            catch (Throwable t) {
                BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "executePeopleQuery");
                exCtx.setErrorCode(70907);
                exCtx.setSeverity(Severity.ERRORS);
                exCtx.setThrowable(t);
                new BPMOrganizationException(exCtx);
                PrincipleListType plt = objectFactory.createPrincipleListType();
                lpg.setMembers(plt);
                lpg.setStatus(StatusTypeEnum.FAILED);
            }
            PeopleQueryUtil.setCreateUpdateInfo(adminContext, lpg, false, true);
            BPMLogicalPeopleGroupPersistency persistency = BPMLogicalPeopleGroupPersistency.getInstance();
            persistency.update(adminContext, lpg);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                PeopleQueryExecutor.debugLog(CLASSNAME, "executePeopleQuery", "People Query Members are updated for lpgId=" + lpgId);
                PeopleQueryUtil.print("New lpg details", lpg);
            }
        }
        catch (BPMOrganizationException ex) {
            throw ex;
        }
        catch (Throwable t) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "executePeopleQuery");
            exCtx.setErrorCode(70907);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable(t);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            PeopleQueryExecutor.debugLog(CLASSNAME, "executePeopleQuery", "End");
        }
    }

    private static IBPMContext getBPMContext() throws BPMException {
        String METHOD = "getBPMContext";
        PeopleQueryExecutor.debugLog(CLASSNAME, "getBPMContext", "Begin");
        try {
            IBPMContext ctx;
            IBPMContext iBPMContext = ctx = (IBPMContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return InternalBPMContext.getInternalBPMContext();
                }
            });
            return iBPMContext;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            PeopleQueryExecutor.debugLog(CLASSNAME, "getBPMContext", "error in getting IBPMContext");
            if (orgEx instanceof BPMException) {
                throw (BPMException)((Object)orgEx);
            }
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getBPMContext");
            exCtx.setErrorCode(70909);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)pae);
            throw new BPMException(orgEx);
        }
        finally {
            PeopleQueryExecutor.debugLog(CLASSNAME, "getBPMContext", "End");
        }
    }

    private static void debugLog(String className, String method, String message) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)className, (String)method, (String)message);
        }
    }

    private FabricSchedulerService getScheduler() throws BPMOrganizationException {
        FabricSchedulerFactory scheduleFactory = FabricSchedulerFactory.getInstance();
        FabricSchedulerService scheduler = scheduleFactory.getSchedulerService();
        if (scheduler == null) {
            BPMOrganizationException ex = new BPMOrganizationException(70919, (Object[])new String[0]);
            throw ex;
        }
        return scheduler;
    }

    public static class PeopleQueryExecitionJob
    implements SystemJob {
        private static final String CLASSNAME = "PeopleQueryExecitionJob";

        public PeopleQueryExecitionJob() {
            PeopleQueryExecutor.debugLog(CLASSNAME, "constructor", "Object PeopleQueryExecitionJob is created");
        }

        public void execute(List<String> loadedComposites, StringProperties opaqueProperties) throws FabricException {
            String METHOD = "execute";
            PeopleQueryExecutor.debugLog(CLASSNAME, "execute", "Begin");
            try {
                String lpgId = opaqueProperties.get("id");
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    PeopleQueryExecutor.debugLog(CLASSNAME, "execute", " Publish lpgId into Topic. lpgId=" + lpgId);
                }
                PeopleQueryPublisher publisher = PeopleQueryPublisher.getInstance();
                publisher.publishPeopleQueryMessage(lpgId);
            }
            catch (Throwable t) {
                throw new FabricException(t);
            }
            finally {
                PeopleQueryExecutor.debugLog(CLASSNAME, "execute", "End");
            }
        }

        public List<String> getCompositesForLoad(StringProperties opaqueProperties) {
            return Collections.EMPTY_LIST;
        }
    }
}

