/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.exception.DiagnosticService;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.metadata.routingslip.model.LogicalPeopleGroupListType;
import oracle.bpel.services.workflow.metadata.routingslip.model.LpgParameterType;
import oracle.bpel.services.workflow.metadata.routingslip.model.LpgParametersType;
import oracle.bpel.services.workflow.metadata.routingslip.model.RoutingSlip;
import oracle.bpel.services.workflow.task.impl.AbstractParticipantListBuilder;
import oracle.bpel.services.workflow.task.impl.AbstractRoutingSlipInterpretor;
import oracle.bpel.services.workflow.task.impl.IrrecoverableRSInterpretationException;
import oracle.bpel.services.workflow.task.impl.ParticipantListBuilderResponse;
import oracle.bpel.services.workflow.task.impl.RecoverableRSInterpretationException;
import oracle.bpel.services.workflow.task.impl.TaskAssignee;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.client.BPMServiceClientFactory;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.impl.PeopleQueryUtil;
import oracle.bpm.services.organization.model.LogicalPeopleGroup;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.PeopleQuery;
import oracle.bpm.services.organization.model.PeopleQueryContext;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;

public class LPGListBuilder
extends AbstractParticipantListBuilder {
    private static final String CLASSNAME = "LPGListBuilder";

    public List<ParticipantListBuilderResponse> getParticipantList() throws WorkflowException, RecoverableRSInterpretationException, IrrecoverableRSInterpretationException {
        String METHOD = "getBPMContext";
        LPGListBuilder.debugLog(CLASSNAME, "getBPMContext", "Begin");
        ArrayList<ParticipantListBuilderResponse> participantListBuilderResponses = new ArrayList<ParticipantListBuilderResponse>();
        List participantList = new ArrayList();
        LogicalPeopleGroupListType logicalPeopleGroupListType = this.getLogicalPeopleListType();
        String lpgName = logicalPeopleGroupListType.getName();
        LpgParametersType lpgParametersType = logicalPeopleGroupListType.getLpgParameters();
        List lpgParameterList = lpgParametersType.getLpgParameter();
        PeopleQueryContext peopleQueryCtx = null;
        if (lpgParameterList != null && !lpgParameterList.isEmpty()) {
            HashMap<String, String> lpgParamMap = new HashMap<String, String>();
            for (LpgParameterType lpgParameter : lpgParameterList) {
                String paramName = lpgParameter.getName();
                String paramValue = lpgParameter.getValue();
                if (paramValue == null) continue;
                String paramType = lpgParameter.getType();
                try {
                    if ("STATIC".equals(paramType)) {
                        lpgParamMap.put(paramName, paramValue);
                        continue;
                    }
                    String xpathValue = AbstractRoutingSlipInterpretor.getStringValueForXPath((String)paramValue, (Task)this.mTask, (RoutingSlip)this.mRoutingSlip);
                    if (xpathValue == null) continue;
                    lpgParamMap.put(paramName, xpathValue);
                }
                catch (Exception e) {
                    WorkflowException wfe = new WorkflowException(30053, this.mTask, (Object[])new String[]{e.getMessage(), this.mTask.getTaskDefinitionId()}, (Throwable)e);
                    throw new RecoverableRSInterpretationException(wfe);
                }
            }
            peopleQueryCtx = PeopleQueryUtil.getPeopleQueryContext(lpgParamMap);
        }
        IBPMOrganizationService service = this.getBPMOrganizationService();
        PeopleQuery peopleQuery = null;
        try {
            IBPMContext ctx = LPGListBuilder.getBPMContext();
            List list = service.searchLogicalPeopleGroups(ctx, SearchModeTypeEnum.EQUALS, lpgName, 0, -1);
            if (list.size() > 1) {
                throw new RecoverableRSInterpretationException(null);
            }
            LogicalPeopleGroup lpg = (LogicalPeopleGroup)list.get(0);
            LogicalPeopleGroup lpgDetails = service.getLogicalPeopleGroup(ctx, lpg.getId());
            peopleQuery = new PeopleQuery(lpgDetails.getPeopleQuery());
            participantList = service.executePeopleQuery(ctx, peopleQuery, peopleQueryCtx);
        }
        catch (BPMException e) {
            WorkflowException wfe = new WorkflowException(30053, this.mTask, (Object[])new String[]{e.getMessage(), this.mTask.getTaskDefinitionId()}, (Throwable)e);
            throw new RecoverableRSInterpretationException(wfe);
        }
        for (Participant participant : participantList) {
            String resourceType;
            String resourceValue = ((PrincipleRefType)participant.getValue()).getName();
            if (!this.existsInPreviouslyAssignedAssignees(resourceValue, resourceType = "user")) {
                LPGListBuilder.debugLog(CLASSNAME, "getBPMContext", "New member of LPGListBulder: name=" + resourceValue + " type =" + resourceType);
                TaskAssignee taskAssignee = new TaskAssignee(resourceValue, resourceType);
                ParticipantListBuilderResponse response = new ParticipantListBuilderResponse();
                ArrayList<TaskAssignee> taskAssignees = new ArrayList<TaskAssignee>();
                taskAssignees.add(taskAssignee);
                response.setTaskAssignees(taskAssignees);
                participantListBuilderResponses.add(response);
                continue;
            }
            LPGListBuilder.debugLog(CLASSNAME, "getBPMContext", "Member previously assigned to LPGListBuilder: name=" + resourceValue + " type =" + resourceType);
        }
        LPGListBuilder.debugLog(CLASSNAME, "getBPMContext", "participantListBuilderResponse: \n\t " + participantListBuilderResponses);
        LPGListBuilder.debugLog(CLASSNAME, "getBPMContext", "End");
        return participantListBuilderResponses;
    }

    private static IBPMContext getBPMContext() throws BPMException {
        String METHOD = "getBPMContext";
        LPGListBuilder.debugLog(CLASSNAME, "getBPMContext", "Begin");
        try {
            IBPMContext ctx;
            IBPMContext iBPMContext = ctx = (IBPMContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return InternalBPMContext.getInternalBPMContext();
                }
            });
            return iBPMContext;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            LPGListBuilder.debugLog(CLASSNAME, "getBPMContext", "error in getting IBPMContext");
            if (orgEx instanceof BPMException) {
                throw (BPMException)((Object)orgEx);
            }
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASSNAME, "getBPMContext");
            exCtx.setErrorCode(70909);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)pae);
            throw new BPMException(orgEx);
        }
        finally {
            LPGListBuilder.debugLog(CLASSNAME, "getBPMContext", "End");
        }
    }

    private static IWorkflowContext getInternalContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)((Object)orgEx);
            }
            throw new WorkflowException((Throwable)pae);
        }
    }

    private static void debugLog(String className, String method, String message) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)className, (String)method, (String)message);
        }
    }

    private LogicalPeopleGroupListType getLogicalPeopleListType() {
        return (LogicalPeopleGroupListType)this.mListObject;
    }

    private List<Participant> compareAndPare(List<Participant> participantList) {
        String METHOD = "getBPMContext";
        ArrayList<Participant> l = new ArrayList<Participant>();
        for (Participant participant : participantList) {
            String name = ((PrincipleRefType)participant.getValue()).getName();
            String type = ((PrincipleRefType)participant.getValue()).getType().value();
            DiagnosticService.log((int)14, (int)DiagnosticService.DIAGNOSTICS_DEBUG, (String)("LPGListBuilder.compareAndPare(): member being compared is " + name + " Type is " + type));
            if (this.existsInPreviouslyAssignedAssignees(name, type)) {
                LPGListBuilder.debugLog(CLASSNAME, "getBPMContext", "member previously assigned ");
                continue;
            }
            LPGListBuilder.debugLog(CLASSNAME, "getBPMContext", "New member ");
            l.add(participant);
        }
        return l;
    }

    private IBPMOrganizationService getBPMOrganizationService() {
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.CLIENT_TYPE, "REMOTE");
        BPMServiceClientFactory bpmServiceClientFactory = BPMServiceClientFactory.getInstance(properties, null, null);
        IBPMServiceClient svcClient = bpmServiceClientFactory.getBPMServiceClient();
        IBPMOrganizationService orgService = svcClient.getBPMOrganizationService();
        return orgService;
    }
}

