/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.common.util.CommonUtil;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.fabric.DatabaseInfo;
import oracle.bpel.services.workflow.query.model.PredicateType;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.Util;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.verification.IVerificationService;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.services.authentication.IBPMUserAuthenticationService;
import oracle.bpm.services.common.BPMServicesUtil;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.impl.AppRoleUtil;
import oracle.bpm.services.organization.impl.BPMCalendarHolidayService;
import oracle.bpm.services.organization.impl.BPMOrganizationImportExportService;
import oracle.bpm.services.organization.impl.BPMOrganizationUtil;
import oracle.bpm.services.organization.impl.PeopleQueryExecutor;
import oracle.bpm.services.organization.impl.PeopleQueryUtil;
import oracle.bpm.services.organization.model.ApplicationContext;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociation;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.ChildOrganizationalUnitRetrievalModeTypeEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.LogicalPeopleGroup;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Organization;
import oracle.bpm.services.organization.model.OrganizationEntitySearchContext;
import oracle.bpm.services.organization.model.OrganizationEntityTypeEnum;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PeopleQuery;
import oracle.bpm.services.organization.model.PeopleQueryContext;
import oracle.bpm.services.organization.model.PeopleQueryMemberType;
import oracle.bpm.services.organization.model.PeopleQueryType;
import oracle.bpm.services.organization.model.Permission;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.RoleProfile;
import oracle.bpm.services.organization.model.RoleProfileType;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;
import oracle.bpm.services.organization.model.StatusTypeEnum;
import oracle.bpm.services.organization.persistency.AbstractPersistencyDriver;
import oracle.bpm.services.organization.persistency.BPMLogicalPeopleGroupPersistency;
import oracle.bpm.services.organization.persistency.BPMOrganizationPersistency;
import oracle.bpm.services.organization.persistency.ExtendedUserPropertiesPersistencyDriver;
import oracle.bpm.services.organization.persistency.PropertyValueTypeEnum;
import oracle.bpm.services.organization.persistency.model.BpmAppRoleOuCalAssoc;
import oracle.bpm.services.organization.persistency.model.BpmCalendarRule;
import oracle.bpm.services.organization.persistency.model.BpmLogicalPeopleGroup;
import oracle.bpm.services.organization.persistency.model.BpmOrganizationalUnit;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ProcessMetadataServiceException;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processmetadata.StatusEnum;
import oracle.bpm.services.processmetadata.impl.ProcessMetadataService;
import oracle.bpm.services.resource.BPMi18NUtil;
import oracle.security.jps.service.policystore.ApplicationRoleInUseException;
import oracle.security.jps.service.policystore.PolicyObjectAlreadyExistsException;
import oracle.security.jps.service.policystore.PolicyObjectNotFoundException;
import oracle.security.jps.service.policystore.PolicyStoreException;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMAuthorizationService;
import oracle.tip.pc.services.identity.BPMGroup;
import oracle.tip.pc.services.identity.BPMIdentity;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMIdentityNotFoundException;
import oracle.tip.pc.services.identity.BPMUser;
import oracle.tip.pc.services.identity.config.BPMConfigException;
import oracle.tip.pc.services.identity.config.ISConfiguration;
import oracle.tip.pc.services.identity.jps.AuthorizationServiceImpl;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.sessions.DatabaseRecord;

public class BPMOrganizationService
implements IBPMOrganizationService {
    private BPMLogicalPeopleGroupPersistency bpmLogicalPeopleGroupPersistency = BPMLogicalPeopleGroupPersistency.getInstance();
    private BPMOrganizationPersistency bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
    private IBPMUserAuthenticationService bpmUserAuthenticationService = null;
    private ExtendedUserPropertiesPersistencyDriver extUserPropertiesPersistenceDriver = ExtendedUserPropertiesPersistencyDriver.getInstance();
    private ObjectFactory objectFactory = new ObjectFactory();
    private IProcessMetadataService processMetadataService = null;
    private IVerificationService verificationService = null;
    public static final String hirearchyPathSeparator = "/";
    private static final String CLASS_NAME = "BPMOrganizationService";
    private static final int BPM_SELECT_OPERATION = 11;
    private static final int BPM_CREATE_OPERATION = 12;
    private static final int BPM_UPDATE_OPERATION = 13;
    private static final int BPM_DELETE_OPERATION = 14;
    private static final String DEFAULT_REALM_NAME = AppRoleUtil.getInstance().getDefaultRealmName();
    private static boolean isEscalationPathCreated = false;
    private static boolean isPotentialAssigneeCreated = false;

    public IVerificationService getVerificationService() {
        return this.verificationService;
    }

    public void setVerificationService(IVerificationService newVerificationService) {
        this.verificationService = newVerificationService;
    }

    public IBPMUserAuthenticationService getBpmUserAuthenticationService() {
        return this.bpmUserAuthenticationService;
    }

    public void setBpmUserAuthenticationService(IBPMUserAuthenticationService newBPMUserAuthenticationService) {
        this.bpmUserAuthenticationService = newBPMUserAuthenticationService;
    }

    public IProcessMetadataService getProcessMetadataService() {
        return this.processMetadataService;
    }

    public void setProcessMetadataService(IProcessMetadataService newProcessMetadataService) {
        this.processMetadataService = newProcessMetadataService;
    }

    public List searchOrganizationEntity(IBPMContext ctx, OrganizationEntityTypeEnum organizationEntity, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow) throws BPMOrganizationException {
        return this.searchOrganizationEntity(ctx, organizationEntity, searchMode, searchCriteria, startRow, endRow, null);
    }

    public List searchOrganizationEntity(IBPMContext ctx, OrganizationEntityTypeEnum organizationEntity, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow, OrganizationEntitySearchContext organizationEntitySearchContext) throws BPMOrganizationException {
        String METHOD = "searchOrganizationEntity";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "ctx:" + ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext());
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "organizationEntity:" + organizationEntity == null ? "null" : organizationEntity.name());
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "searchMode:" + searchMode == null ? "null" : searchMode.name());
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "searchCriteria:" + searchCriteria);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "startRow:" + startRow);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "endRow:" + endRow);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "organizationEntitySearchContext:" + (organizationEntitySearchContext == null ? "null" : organizationEntitySearchContext.name()));
        }
        List returnList = null;
        try {
            this.validateBPMOperation(ctx, 11);
            String searchString = searchCriteria;
            if (SearchModeTypeEnum.STARTS_WITH == searchMode) {
                searchString = searchCriteria + "%";
            } else if (SearchModeTypeEnum.ENDS_WITH == searchMode) {
                searchString = "%" + searchCriteria;
            } else if (SearchModeTypeEnum.CONTAINS == searchMode) {
                searchString = "%" + searchCriteria + "%";
            } else if (SearchModeTypeEnum.EQUALS == searchMode) {
                searchString = searchCriteria;
            } else if (SearchModeTypeEnum.LIKE == searchMode) {
                searchString = searchCriteria;
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "searchString:" + searchString);
            }
            if (OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT == organizationEntity) {
                ExpressionBuilder builder = new ExpressionBuilder();
                Expression expression = null;
                Expression orderingExpression = builder.get("organizationalUnitName").ascending();
                expression = SearchModeTypeEnum.EQUALS == searchMode ? builder.get("organizationalUnitName").equalsIgnoreCase(searchString) : builder.get("organizationalUnitName").likeIgnoreCase(searchString);
                if (organizationEntitySearchContext != null && OrganizationEntitySearchContext.ORGANIZATIONAL_UNIT_ROOT_ORGANIZATIONAL_UNIT == organizationEntitySearchContext) {
                    expression = expression.and(builder.get("parentOrganizationalUnit").isNull());
                }
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                    BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "expression:" + expression);
                }
                returnList = (List)this.bpmOrganizationPersistency.executePagingQuery(ctx, BpmOrganizationalUnit.class, expression, orderingExpression, startRow, endRow);
            } else {
                if (OrganizationEntityTypeEnum.CALENDAR_RULE == organizationEntity) {
                    BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
                    List<Object> list = calSrv.searchCalendarRule(ctx, searchMode, searchCriteria, startRow, endRow);
                    return list;
                }
                if (OrganizationEntityTypeEnum.HOLIDAY_RULE == organizationEntity) {
                    BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
                    List<Object> list = calSrv.searchHolidayRule(ctx, searchMode, searchCriteria, startRow, endRow);
                    return list;
                }
            }
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "searchOrganizationEntity");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "searchOrganizationEntity", "End");
            }
        }
        return returnList;
    }

    public OrganizationalUnit createOrganizationalUnit(IBPMContext ctx, OrganizationalUnit organizationalUnit) throws BPMOrganizationException {
        return this.createOrganizationalUnit(ctx, organizationalUnit, null);
    }

    public OrganizationalUnit updateOrganizationalUnit(IBPMContext ctx, OrganizationalUnit organizationalUnit) throws BPMOrganizationException {
        String METHOD = "updateOrganizationalUnit";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateOrganizationalUnit", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateOrganizationalUnit", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateOrganizationalUnit", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.printOrganizationalUnit(CLASS_NAME, "updateOrganizationalUnit", organizationalUnit);
        }
        try {
            this.validateBPMOperation(ctx, 13);
            XMLGregorianCalendar calendar = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
            this.setDefaults(ctx, organizationalUnit, 13, calendar);
            this.validate(ctx, organizationalUnit, null, 13);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "updateOrganizationalUnit", "organizationalUnit after setting the defaults:");
                BPMOrganizationUtil.printOrganizationalUnit(CLASS_NAME, "updateOrganizationalUnit", organizationalUnit);
            }
            List users = organizationalUnit.getMember();
            for (MemberType member : users) {
                if (!member.getType().value().equalsIgnoreCase(ParticipantTypeEnum.APPROLE.value()) || !AppRoleUtil.getInstance().isMemberSystemRole(member.getName(), ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value())) continue;
                throw new BPMOrganizationException(70707, new Object[]{member.getName(), organizationalUnit.getOrganizationalUnitName()});
            }
            this.bpmOrganizationPersistency.update(ctx, organizationalUnit);
            OrganizationalUnit organizationalUnit2 = organizationalUnit;
            return organizationalUnit2;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "updateOrganizationalUnit");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "updateOrganizationalUnit", "End");
            }
        }
    }

    public void deleteOrganizationalUnit(IBPMContext ctx, String organizationalUnitId, boolean includingChildren, boolean force) throws BPMOrganizationException {
        String METHOD = "deleteOrganizationalUnit";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteOrganizationalUnit", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteOrganizationalUnit", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteOrganizationalUnit", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteOrganizationalUnit", "organizationalUnitId:" + organizationalUnitId);
        }
        try {
            this.validateBPMOperation(ctx, 14);
            this.validate(ctx, (OrganizationalUnit)null, organizationalUnitId, 14, includingChildren);
            BpmOrganizationalUnit bpmOrganizationalUnit = new BpmOrganizationalUnit();
            bpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnitId);
            this.bpmOrganizationPersistency.deleteOrganizationalUnit(ctx, bpmOrganizationalUnit, includingChildren);
            List<BpmAppRoleOuCalAssoc> associations = bpmOrganizationalUnit.getBpmAppRoleOuCalAssocCollection();
            if (associations != null && associations.size() > 0) {
                for (BpmAppRoleOuCalAssoc association : associations) {
                    this.deleteApplicationRoleOrgUnitCalendarAssociation(ctx, association.getId());
                }
            }
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "deleteOrganizationalUnit");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteOrganizationalUnit", "End");
            }
        }
    }

    public OrganizationalUnit getOrganizationalUnit(IBPMContext ctx, String organizationalUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum childOrganizationalUnitRetrievalMode) throws BPMOrganizationException {
        return this.getOrganizationalUnit(ctx, organizationalUnitId, childOrganizationalUnitRetrievalMode, null);
    }

    public OrganizationalUnit getOrganizationalUnit(IBPMContext ctx, String organizationalUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum childOrganizationalUnitRetrievalMode, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "getOrganizationalUnit";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "ctx:" + ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext());
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "organizationalUnitId:" + organizationalUnitId);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "childOrganizationalUnitRetrievalMode:" + (childOrganizationalUnitRetrievalMode == null ? "null" : childOrganizationalUnitRetrievalMode.name()));
        }
        OrganizationalUnit organizationalUnit = null;
        this.validateBPMOperation(ctx, 11);
        this.validate(ctx, (OrganizationalUnit)null, organizationalUnitId, 11, unitOfWorkHolder);
        try {
            BpmOrganizationalUnit bpmOrganizationalUnit = new BpmOrganizationalUnit();
            bpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnitId);
            Object object = this.bpmOrganizationPersistency.read(ctx, bpmOrganizationalUnit, unitOfWorkHolder);
            organizationalUnit = (OrganizationalUnit)object;
            this.addChildrens(ctx, organizationalUnit, childOrganizationalUnitRetrievalMode);
            OrganizationalUnit organizationalUnit2 = organizationalUnit;
            return organizationalUnit2;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "getOrganizationalUnit");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnit", "End");
            }
        }
    }

    public ApplicationRoleOrgUnitCalendarAssociation createApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation) throws BPMOrganizationException {
        return this.createApplicationRoleOrgUnitCalendarAssociation(ctx, applicationRoleOrgUnitCalendarAssociation, null);
    }

    public ApplicationRoleOrgUnitCalendarAssociation createApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "createApplicationRoleOrgUnitCalendarAssociation";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", applicationRoleOrgUnitCalendarAssociation);
        }
        try {
            this.validateBPMOperation(ctx, 12);
            XMLGregorianCalendar calendar = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
            this.setDefaults(ctx, applicationRoleOrgUnitCalendarAssociation, 12, calendar);
            this.validate(ctx, applicationRoleOrgUnitCalendarAssociation, null, 12, unitOfWorkHolder);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", "applicationRoleOrgUnitCalendarAssociation after setting the defaults:");
                BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", applicationRoleOrgUnitCalendarAssociation);
            }
            this.bpmOrganizationPersistency.insert(ctx, applicationRoleOrgUnitCalendarAssociation, unitOfWorkHolder);
            ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation2 = applicationRoleOrgUnitCalendarAssociation;
            return applicationRoleOrgUnitCalendarAssociation2;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createApplicationRoleOrgUnitCalendarAssociation", "End");
            }
        }
    }

    public ApplicationRoleOrgUnitCalendarAssociation updateApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation) throws BPMOrganizationException {
        return this.updateApplicationRoleOrgUnitCalendarAssociation(ctx, applicationRoleOrgUnitCalendarAssociation, null);
    }

    public ApplicationRoleOrgUnitCalendarAssociation updateApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "updateApplicationRoleOrgUnitCalendarAssociation";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", applicationRoleOrgUnitCalendarAssociation);
        }
        try {
            this.validateBPMOperation(ctx, 13);
            XMLGregorianCalendar calendar = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
            this.setDefaults(ctx, applicationRoleOrgUnitCalendarAssociation, 13, calendar);
            this.validate(ctx, applicationRoleOrgUnitCalendarAssociation, null, 13, unitOfWorkHolder);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", "applicationRoleOrgUnitCalendarAssociation after setting the defaults:");
                BPMOrganizationUtil.printOrganizationalUnitAppRoleCalenderAssociation(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", applicationRoleOrgUnitCalendarAssociation);
            }
            this.bpmOrganizationPersistency.update(ctx, applicationRoleOrgUnitCalendarAssociation, unitOfWorkHolder);
            ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation2 = applicationRoleOrgUnitCalendarAssociation;
            return applicationRoleOrgUnitCalendarAssociation2;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "updateApplicationRoleOrgUnitCalendarAssociation", "End");
            }
        }
    }

    public void deleteApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, String applicationRoleOrgUnitCalendarAssociationId) throws BPMOrganizationException {
        String METHOD = "deleteApplicationRoleOrgUnitCalendarAssociation";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation", "applicationRoleOrgUnitCalendarAssociationId:" + applicationRoleOrgUnitCalendarAssociationId);
        }
        try {
            this.validateBPMOperation(ctx, 14);
            this.validate(ctx, (ApplicationRoleOrgUnitCalendarAssociation)null, applicationRoleOrgUnitCalendarAssociationId, 14, null);
            BpmAppRoleOuCalAssoc bpmAppRoleOuCalAssoc = new BpmAppRoleOuCalAssoc();
            bpmAppRoleOuCalAssoc.setId(applicationRoleOrgUnitCalendarAssociationId);
            Object obj = this.bpmOrganizationPersistency.readObject(ctx, bpmAppRoleOuCalAssoc);
            if (obj != null) {
                bpmAppRoleOuCalAssoc = (BpmAppRoleOuCalAssoc)obj;
                this.bpmOrganizationPersistency.deleteObject(ctx, bpmAppRoleOuCalAssoc);
            }
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteApplicationRoleOrgUnitCalendarAssociation", "End");
            }
        }
    }

    public List<ApplicationRoleOrgUnitCalendarAssociation> getApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, RoleProfile applicationRole) throws BPMOrganizationException {
        String METHOD = "getApplicationRoleOrgUnitCalendarAssociation";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation", "applicationRole:" + (applicationRole == null ? "null" : ((RoleProfileType)applicationRole.getValue()).getName() + ":" + ((RoleProfileType)applicationRole.getValue()).getIdentityContext()));
        }
        try {
            Vector<Object> results;
            this.validateBPMOperation(ctx, 11);
            ArrayList<ApplicationRoleOrgUnitCalendarAssociation> associations = new ArrayList<ApplicationRoleOrgUnitCalendarAssociation>();
            if (applicationRole == null || ((RoleProfileType)applicationRole.getValue()).getName() == null || ((RoleProfileType)applicationRole.getValue()).getName().trim().isEmpty()) {
                throw new BPMOrganizationException(70691, null);
            }
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = null;
            expression = "%".equals(((RoleProfileType)applicationRole.getValue()).getName()) ? builder.get("applicationRoleName").like(((RoleProfileType)applicationRole.getValue()).getName()) : builder.get("applicationRoleName").equal((Object)((RoleProfileType)applicationRole.getValue()).getName());
            if (((RoleProfileType)applicationRole.getValue()).getIdentityContext() != null) {
                expression = expression.and(builder.get("identityContext").likeIgnoreCase(((RoleProfileType)applicationRole.getValue()).getIdentityContext()));
            }
            if (((RoleProfileType)applicationRole.getValue()).getApplicationContext() != null) {
                expression = expression.and(builder.get("applicationContext").likeIgnoreCase(((RoleProfileType)applicationRole.getValue()).getApplicationContext()));
            }
            if ((results = this.bpmOrganizationPersistency.executeQuery(ctx, BpmAppRoleOuCalAssoc.class, expression)) != null && !results.isEmpty()) {
                for (int index = 0; index < results.size(); ++index) {
                    associations.add((ApplicationRoleOrgUnitCalendarAssociation)results.get(index));
                }
            }
            ArrayList<ApplicationRoleOrgUnitCalendarAssociation> arrayList = associations;
            return arrayList;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getApplicationRoleOrgUnitCalendarAssociation", "End");
            }
        }
    }

    public CalendarRule getCalendarRuleForRole(IBPMContext ctx, String organizationalUnitId, RoleProfile applicationRole) throws BPMOrganizationException {
        String METHOD = "getCalendarRuleForRole";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "organizationalUnitId:" + organizationalUnitId);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "applicationRole:" + (applicationRole == null ? "null" : ((RoleProfileType)applicationRole.getValue()).getName() + ":" + ((RoleProfileType)applicationRole.getValue()).getIdentityContext()));
        }
        try {
            String sqlQuery = "SELECT * FROM  BPM_APP_ROLE_OU_CAL_ASSOC WHERE ORGANIZATIONAL_UNIT_ID = '" + BPMOrganizationUtil.replaceSingleQuotesWithTwoSingleQuotes(organizationalUnitId) + "'" + "APPLICATION_ROLE_NAME = '" + BPMOrganizationUtil.replaceSingleQuotesWithTwoSingleQuotes(((RoleProfileType)applicationRole.getValue()).getName()) + "'" + "IDENTITY_CONTEXT = '" + BPMOrganizationUtil.replaceSingleQuotesWithTwoSingleQuotes(((RoleProfileType)applicationRole.getValue()).getIdentityContext()) + "'";
            Vector<Object> associations = this.bpmOrganizationPersistency.executeObjectQuery(ctx, BpmAppRoleOuCalAssoc.class, sqlQuery);
            if (associations != null && !associations.isEmpty()) {
                BpmAppRoleOuCalAssoc bpmAppRoleOuCalAssoc = (BpmAppRoleOuCalAssoc)associations.get(0);
                CalendarRule calendarRule = (CalendarRule)this.bpmOrganizationPersistency.convertFromTopLink(ctx, null, bpmAppRoleOuCalAssoc.getCalendarRule(), null);
                return calendarRule;
            }
            BpmOrganizationalUnit bpmOrganizationalUnit = new BpmOrganizationalUnit();
            bpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnitId);
            bpmOrganizationalUnit = (BpmOrganizationalUnit)this.bpmOrganizationPersistency.readObject(ctx, bpmOrganizationalUnit);
            if (bpmOrganizationalUnit.getParentOrganizationalUnit() == null) {
                CalendarRule calendarRule = null;
                return calendarRule;
            }
            CalendarRule calendarRule = this.getCalendarRuleForRole(ctx, bpmOrganizationalUnit.getParentOrganizationalUnit().getOrganizationalUnitId(), applicationRole);
            return calendarRule;
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "getCalendarRuleForRole");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRuleForRole", "End");
            }
        }
    }

    public CalendarRule getCalendarRule(IBPMContext ctx, String calendarID) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "getCalendarRule()", "IN");
        this.validateBPMOperation(ctx, 11);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.getCalendarRule(ctx, calendarID);
    }

    public CalendarRule createCalendarRule(IBPMContext ctx, CalendarRule cal) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "createCalendarRule()", "IN");
        this.validateBPMOperation(ctx, 12);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.createCalendarRule(ctx, cal, null);
    }

    public CalendarRule updateCalendarRule(IBPMContext ctx, CalendarRule updatedCalendar) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "updateCalendarRule()", "IN");
        this.validateBPMOperation(ctx, 13);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.updateCalendarRule(ctx, updatedCalendar);
    }

    public void deleteCalendarRule(IBPMContext ctx, String calendarID, boolean force) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteCalendarRule", "IN");
        this.validateBPMOperation(ctx, 14);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        calSrv.deleteCalendarRule(ctx, calendarID, force);
    }

    public HolidayRule getHolidayRule(IBPMContext ctx, String holidayRuleId) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "getHolidayRule", "IN");
        this.validateBPMOperation(ctx, 11);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.getHolidayRule(ctx, holidayRuleId);
    }

    public HolidayRule createHolidayRule(IBPMContext ctx, HolidayRule holidayRule) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "createHolidayRule", "IN");
        this.validateBPMOperation(ctx, 12);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.createHolidayRule(ctx, holidayRule, null);
    }

    public HolidayRule updateHolidayRule(IBPMContext ctx, HolidayRule updatedHolidayRule) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "updateHolidayRule", "IN");
        this.validateBPMOperation(ctx, 13);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        return calSrv.updateHolidayRule(ctx, updatedHolidayRule);
    }

    public void deleteHolidayRule(IBPMContext ctx, String holidayRuleId, boolean force) throws BPMOrganizationException {
        BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteHolidayRule", "IN");
        this.validateBPMOperation(ctx, 14);
        BPMCalendarHolidayService calSrv = BPMCalendarHolidayService.getInstance();
        calSrv.deleteHolidayRule(ctx, holidayRuleId, force);
    }

    public Organization exportOrganization(IBPMContext ctx) throws BPMOrganizationException {
        BPMOrganizationImportExportService bpmOrgImportExportService = BPMOrganizationImportExportService.getInstance(this);
        return bpmOrgImportExportService.exportOrganization(ctx);
    }

    public Organization importOrganization(IBPMContext ctx, Organization organization, boolean validateUsers) throws BPMOrganizationException {
        BPMOrganizationImportExportService bpmImpExpService = BPMOrganizationImportExportService.getInstance(this);
        return bpmImpExpService.importOrganization(ctx, organization, validateUsers);
    }

    public void createAppRole(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, String optionalDisplayName, String optionalDesc) throws BPMOrganizationException {
        try {
            boolean isSystemRole = false;
            this.createAppRoleInternal(ctx, appCtx, appRoleName, optionalDisplayName, optionalDesc, isSystemRole);
        }
        catch (BPMIdentityException bpmie) {
            throw new BPMOrganizationException(70647, new Object[]{appRoleName}, (Exception)((Object)bpmie));
        }
        catch (PolicyObjectAlreadyExistsException pse) {
            throw new BPMOrganizationException(70633, new Object[]{appRoleName, appCtx.getApplicationType().value()}, (Exception)((Object)pse));
        }
        catch (PolicyStoreException ime) {
            throw new BPMOrganizationException(70636, new Object[]{appRoleName}, (Exception)((Object)ime));
        }
        catch (PrivilegedActionException pae) {
            throw new BPMOrganizationException(70642, new Object[]{"createAppRole"}, (Exception)pae);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public void removeAppRole(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, boolean force) throws BPMOrganizationException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeAppRole", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n force=" + force));
        this.validateBPMOperation(ctx, 14);
        if (appRoleName.equals("BPMProcessAdmin")) {
            throw new BPMOrganizationException(70698, new Object[]{appRoleName});
        }
        try {
            List<OrganizationalUnit> orgUnits = this.getOrganizationalUnitForAppRoleInternal(ctx, appRoleName, ISConfiguration.getDefaultRealmName());
            PrincipleRefType user = this.objectFactory.createPrincipleRefType();
            user.setName(appRoleName);
            user.setRealm(ISConfiguration.getDefaultRealmName());
            user.setType(ParticipantTypeEnum.APPROLE);
            List<LogicalPeopleGroup> lpgs = this.getLogicalPeopleGroupsForUser(ctx, user);
            if (orgUnits != null && !orgUnits.isEmpty() || lpgs != null && !lpgs.isEmpty()) {
                StringBuilder orgNames = new StringBuilder();
                StringBuilder lpgName = new StringBuilder();
                for (OrganizationalUnit ou : orgUnits) {
                    orgNames.append(ou.getOrganizationalUnitName());
                    orgNames.append(",");
                }
                for (LogicalPeopleGroup lpg : lpgs) {
                    lpgName.append(lpg.getName());
                    lpgName.append(",");
                }
                int orgEnd = orgNames.length() == 0 ? 0 : orgNames.length() - 1;
                int lpgEnd = lpgName.length() == 0 ? 0 : lpgName.length() - 1;
                throw new BPMOrganizationException(70630, new Object[]{appRoleName, orgNames.substring(0, orgEnd), lpgName.substring(0, lpgEnd)});
            }
            RoleProfileType appRoleProfileType = this.objectFactory.createRoleProfileType();
            appRoleProfileType.setName(appRoleName);
            appRoleProfileType.setIdentityContext(appCtx.getApplicationType().value());
            RoleProfile appRoleProfile = new RoleProfile(appRoleProfileType);
            List<ApplicationRoleOrgUnitCalendarAssociation> list = this.getApplicationRoleOrgUnitCalendarAssociation(ctx, appRoleProfile);
            if (list != null && list.size() > 0 && force) {
                for (ApplicationRoleOrgUnitCalendarAssociation association : list) {
                    this.deleteApplicationRoleOrgUnitCalendarAssociation(ctx, association.getApplicationRoleOrgUnitCalendarAssociationId());
                }
            } else if (list != null && list.size() > 0 && !force) {
                throw new BPMOrganizationException(70643, new Object[]{appRoleName});
            }
            AppRoleUtil.getInstance().removeAppRole(appCtx, appRoleName, force);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeAppRole", (String)"Completed.");
    }

    public void grantAppRoleToPrincipal(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, Participant participant) throws BPMOrganizationException {
        try {
            this.grantAppRoleToPrincipalInternal(ctx, appCtx, appRoleName, participant);
            this.clearCache(ctx, appRoleName, participant);
        }
        catch (PolicyObjectAlreadyExistsException pse) {
            if (((PrincipleRefType)participant.getValue()).getName().equals("SOAOperator") && appCtx.getApplicationType().value().equals("soa-infra") && appRoleName.equals("BPMOrganizationAdmin")) {
                BPMOrganizationUtil.infoLog(CLASS_NAME, "grantAppRoleToPrincipal", "BPMOrganizationAdmin Role already granted to SOAOperator");
            }
            throw new BPMOrganizationException(70634, new Object[]{appRoleName, ((PrincipleRefType)participant.getValue()).getName()}, (Exception)((Object)pse));
        }
        catch (ApplicationRoleInUseException ae) {
            throw new BPMOrganizationException(70644, new Object[]{appRoleName, ((PrincipleRefType)participant.getValue()).getName(), "grantAppRoleToPrincipal"}, (Exception)((Object)ae));
        }
        catch (PolicyObjectNotFoundException pe) {
            throw new BPMOrganizationException(70645, new Object[]{appRoleName, ((PrincipleRefType)participant.getValue()).getName()}, (Exception)((Object)pe));
        }
        catch (PolicyStoreException pe) {
            throw new BPMOrganizationException(70638, new Object[]{appRoleName, ((PrincipleRefType)participant.getValue()).getName()}, (Exception)((Object)pe));
        }
        catch (NullPointerException je) {
            throw new BPMOrganizationException(70648, new Object[]{"grantAppRoleToPrincipal"}, (Exception)je);
        }
        catch (PrivilegedActionException pae) {
            throw new BPMOrganizationException(70642, new Object[]{"grantAppRoleToPrincipal"}, (Exception)pae);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public void revokeAppRoleFromPrincipal(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, Participant participant) throws BPMOrganizationException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokeAppRoleFromPrincipal", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n participant=" + participant));
        if (!this.validateIsBPMComposerAdmin(ctx)) {
            this.validateBPMOperation(ctx, 14);
        }
        try {
            AppRoleUtil.getInstance().revokeAppRoleFromPrincipal(appCtx, appRoleName, participant);
            this.clearCache(ctx, appRoleName, participant);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokeAppRoleFromPrincipal", (String)"Completed.");
    }

    public void grantPermissionToAppRole(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, Permission perm) throws BPMOrganizationException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantPermissionToAppRole", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n perm=" + perm));
        this.validateBPMOperation(ctx, 12);
        try {
            AppRoleUtil.getInstance().grantPermissionToAppRole(appCtx, appRoleName, perm);
            this.clearCache(ctx, appRoleName);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantPermissionToAppRole", (String)"Completed.");
    }

    public void revokePermissionFromAppRole(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, Permission perm) throws BPMOrganizationException {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokePermissionFromAppRole", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n perm=" + perm));
        this.validateBPMOperation(ctx, 14);
        try {
            AppRoleUtil.getInstance().revokePermissionFromAppRole(appCtx, appRoleName, perm);
            this.clearCache(ctx, appRoleName);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokePermissionFromAppRole", (String)"Completed.");
    }

    public String importParticipantProperties(IBPMContext ctx, List<ParticipantProperties> participantProperties) throws BPMOrganizationException {
        return "";
    }

    public void createParticipantProperty(IBPMContext ctx, ParticipantProperty property) throws BPMOrganizationException {
        this.createParticipantProperty(ctx, property, null);
    }

    public void createParticipantProperty(IBPMContext ctx, ParticipantProperty property, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String identityContext;
        this.validateBPMOperation(ctx, 12);
        if (property != null) {
            identityContext = ctx.getIdentityContext();
            if (WorkflowUtil.isNull((String)identityContext)) {
                identityContext = DEFAULT_REALM_NAME;
            }
        } else {
            Object[] objs = new Object[]{};
            throw new BPMOrganizationException(70669, objs);
        }
        property.setCreatedBy(ctx.getUser());
        property.setCreatedByIdentityContext(identityContext);
        XMLGregorianCalendar todaysDateAndTime = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
        property.setCreatedDate(todaysDateAndTime);
        property.setLastUpdatedBy(ctx.getUser());
        property.setLastUpdatedByIdentityContext(identityContext);
        property.setLastUpdatedDate(todaysDateAndTime);
        this.extUserPropertiesPersistenceDriver.addProperty(property, unitOfWorkHolder);
    }

    public void addParticipantPropertyValue(IBPMContext ctx, ParticipantProperty property) throws BPMOrganizationException {
        String identityContext;
        this.validateBPMOperation(ctx, 13);
        if (property != null) {
            identityContext = ctx.getIdentityContext();
            if (WorkflowUtil.isNull((String)identityContext)) {
                identityContext = DEFAULT_REALM_NAME;
            }
        } else {
            Object[] objs = new String[]{};
            throw new BPMOrganizationException(70669, objs);
        }
        Calendar todaysDateAndTime = Calendar.getInstance();
        property.setLastUpdatedBy(ctx.getUser());
        property.setLastUpdatedByIdentityContext(identityContext);
        property.setLastUpdatedDate(BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance()));
        this.extUserPropertiesPersistenceDriver.addPropertyValue(property, null);
    }

    public void deleteAllPropertiesOnParticipants(IBPMContext ctx, List<Participant> participants) throws BPMOrganizationException {
        this.isAdminOrManagerOfParticipants(ctx, participants);
        if (participants == null || participants.size() <= 0) {
            Object[] objs = new String[]{};
            throw new BPMOrganizationException(70669, objs);
        }
        this.extUserPropertiesPersistenceDriver.deleteAllPropertiesOnParticipants(participants, null);
    }

    public void deleteParticipantProperty(IBPMContext ctx, ParticipantProperty property, boolean force) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 14);
        if (property != null) {
            this.extUserPropertiesPersistenceDriver.deleteProperty(property, force, null);
            if ("ESCALATIONPATH".equals(property.getName())) {
                isEscalationPathCreated = false;
            }
            if ("POTENTIAL_ASSIGNEE".equals(property.getName())) {
                isPotentialAssigneeCreated = false;
            }
        } else {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
    }

    public void deleteParticipantPropertyValue(IBPMContext ctx, ParticipantProperty property, boolean force) throws BPMOrganizationException {
        String identityContext;
        this.validateBPMOperation(ctx, 13);
        if (property != null) {
            identityContext = ctx.getIdentityContext();
            if (WorkflowUtil.isNull((String)identityContext)) {
                identityContext = DEFAULT_REALM_NAME;
            }
        } else {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
        property.setLastUpdatedBy(ctx.getUser());
        property.setLastUpdatedByIdentityContext(identityContext);
        property.setLastUpdatedDate(BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance()));
        this.extUserPropertiesPersistenceDriver.deletePropertyValue(property, force, null);
    }

    public List<ParticipantProperties> getAllAssignedParticipantProperties(IBPMContext ctx) throws BPMOrganizationException {
        return this.getAllAssignedParticipantPropertiesByParticipantType(ctx, ParticipantTypeEnum.USER);
    }

    public List<ParticipantProperties> getAllAssignedParticipantPropertiesByParticipantType(IBPMContext ctx, ParticipantTypeEnum participantType) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 11);
        List<ParticipantProperties> result = this.extUserPropertiesPersistenceDriver.getAllParticipantProperties();
        for (ParticipantProperties partProp : result) {
            List propertiesList = partProp.getParticipantProperty();
            block13: for (ParticipantProperty pp : propertiesList) {
                String type = pp.getPropertyType();
                try {
                    PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(type);
                    switch (valueTypeEnum) {
                        case DATE: 
                        case FREEFORM_STRING: 
                        case NUMBER: {
                            String i18nName;
                            String name = pp.getName();
                            try {
                                i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                                pp.setLocalizedName(i18nName);
                            }
                            catch (Exception e) {
                                pp.setLocalizedName(name);
                            }
                            break;
                        }
                        case STRING: {
                            String i18nName;
                            String name = pp.getName();
                            try {
                                i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                                pp.setLocalizedName(i18nName);
                            }
                            catch (Exception e) {
                                pp.setLocalizedName(name);
                            }
                            List values = pp.getValue();
                            for (Object o : values) {
                                String value = (String)o;
                                try {
                                    String i18nValue = BPMi18NUtil.getExtendedUserPropertiesLabel(value, ctx.getLocale());
                                    pp.getLocalizedValue().add(i18nValue);
                                }
                                catch (Exception e) {
                                    pp.getLocalizedValue().add(value);
                                }
                            }
                            continue block13;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    Object[] objs = new Object[]{type};
                    throw new BPMOrganizationException(70662, objs);
                }
            }
        }
        return result;
    }

    public List<Participant> getParticipantsWithProperties(IBPMContext ctx, List<Participant> setOfParticipants, List<ParticipantProperty> props, int startRow, int endRow) throws BPMOrganizationException {
        if (props == null || props.size() == 0) {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
        this.validateBPMOperation(ctx, 11);
        return this.extUserPropertiesPersistenceDriver.getParticipantsWithProperties(setOfParticipants, props, startRow, endRow);
    }

    public List<Participant> searchParticipantsWithProperties(IBPMContext ctx, List<Participant> setOfParticipants, oracle.bpm.services.organization.model.Predicate predicate, int startRow, int endRow) throws BPMOrganizationException {
        if (predicate == null) {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
        try {
            this.validateBPMOperation(ctx, 11);
            PredicateType queryPredicateType = BPMOrganizationUtil.convertJAXB2PredicateIntoJAXB1Predicate((oracle.bpm.services.organization.model.PredicateType)predicate.getValue());
            Predicate repos_predicate = new Predicate(queryPredicateType);
            return this.extUserPropertiesPersistenceDriver.getParticipantsWithProperties(setOfParticipants, repos_predicate, startRow, endRow);
        }
        catch (BPMOrganizationException bpme) {
            throw bpme;
        }
        catch (WorkflowException e) {
            BPMExceptionContext ctxt = new BPMExceptionContext();
            ctxt.setClassName(this.getClass().getName());
            ctxt.setMethodName("searchParticipantsWithProperties");
            ctxt.setErrorCode(e.getErrorCode());
            ctxt.setMessage(e.getMessage());
            ctxt.setThrowable((Throwable)e);
            throw new BPMOrganizationException(ctxt);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public List<ParticipantProperty> searchExtendedUserProperties(IBPMContext ctx, String propertyName) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 11);
        List<ParticipantProperty> result = this.extUserPropertiesPersistenceDriver.searchExtendedUserProperties(propertyName);
        block12: for (ParticipantProperty pp : result) {
            String type = pp.getPropertyType();
            try {
                PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(type);
                switch (valueTypeEnum) {
                    case DATE: 
                    case FREEFORM_STRING: 
                    case NUMBER: {
                        String i18nName;
                        String name = pp.getName();
                        try {
                            i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                            pp.setLocalizedName(i18nName);
                        }
                        catch (Exception e) {
                            pp.setLocalizedName(name);
                        }
                        break;
                    }
                    case STRING: {
                        String i18nName;
                        String name = pp.getName();
                        try {
                            i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                            pp.setLocalizedName(i18nName);
                        }
                        catch (Exception e) {
                            pp.setLocalizedName(name);
                        }
                        List values = pp.getValue();
                        for (Object o : values) {
                            String value = (String)o;
                            try {
                                String i18nValue = BPMi18NUtil.getExtendedUserPropertiesLabel(value, ctx.getLocale());
                                pp.getLocalizedValue().add(i18nValue);
                            }
                            catch (Exception e) {
                                pp.getLocalizedValue().add(value);
                            }
                        }
                        continue block12;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Object[] objs = new Object[]{};
                throw new BPMOrganizationException(70662, objs);
            }
        }
        return result;
    }

    public List<ParticipantProperties> getPropertiesOfParticipants(IBPMContext ctx, List<Participant> participants) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 11);
        if (participants == null || participants.size() == 0) {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
        List<ParticipantProperties> result = this.extUserPropertiesPersistenceDriver.getPropertiesOfParticipants(participants);
        for (ParticipantProperties partProp : result) {
            List propertiesList = partProp.getParticipantProperty();
            block13: for (ParticipantProperty pp : propertiesList) {
                String type = pp.getPropertyType();
                try {
                    PropertyValueTypeEnum valueTypeEnum = PropertyValueTypeEnum.valueOf(type);
                    switch (valueTypeEnum) {
                        case DATE: 
                        case FREEFORM_STRING: 
                        case NUMBER: {
                            String i18nName;
                            String name = pp.getName();
                            try {
                                i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                                pp.setLocalizedName(i18nName);
                            }
                            catch (Exception e) {
                                pp.setLocalizedName(name);
                            }
                            break;
                        }
                        case STRING: {
                            String i18nName;
                            String name = pp.getName();
                            try {
                                i18nName = BPMi18NUtil.getExtendedUserPropertiesLabel(name, ctx.getLocale());
                                pp.setLocalizedName(i18nName);
                            }
                            catch (Exception e) {
                                pp.setLocalizedName(name);
                            }
                            List values = pp.getValue();
                            for (Object o : values) {
                                String value = (String)o;
                                try {
                                    String i18nValue = BPMi18NUtil.getExtendedUserPropertiesLabel(value, ctx.getLocale());
                                    pp.getLocalizedValue().add(i18nValue);
                                }
                                catch (Exception e) {
                                    pp.getLocalizedValue().add(value);
                                }
                            }
                            continue block13;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    Object[] objs = new Object[]{type};
                    throw new BPMOrganizationException(70662, objs);
                }
            }
        }
        return result;
    }

    public void setPropertiesOnParticipants(IBPMContext ctx, List<ParticipantProperties> properties) throws BPMOrganizationException {
        this.setPropertiesOnParticipants(ctx, properties, true, null);
    }

    public void updateParticipantPropertyName(IBPMContext ctx, String oldName, String newname) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 13);
        this.extUserPropertiesPersistenceDriver.updatePropertyName(ctx, oldName, newname, null);
    }

    public void updateParticipantPropertyValue(IBPMContext ctx, String propertyName, String oldValue, String newValue) throws BPMOrganizationException {
        this.validateBPMOperation(ctx, 13);
        this.extUserPropertiesPersistenceDriver.updatePropertyValue(ctx, propertyName, oldValue, newValue, null);
    }

    public LogicalPeopleGroup createLogicalPeopleGroup(IBPMContext ctx, LogicalPeopleGroup lpg, boolean isExecuteImmediate) throws BPMOrganizationException {
        return this.createLogicalPeopleGroup(ctx, lpg, isExecuteImmediate, null);
    }

    public LogicalPeopleGroup updateLogicalPeopleGroup(IBPMContext ctx, LogicalPeopleGroup lpg, boolean isExecuteImmediate) throws BPMOrganizationException {
        String METHOD = "updateLogicalPeopleGroup";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "updateLogicalPeopleGroup", "Begin");
        }
        this.validateBPMOperation(ctx, 13);
        if (lpg == null) {
            throw new BPMOrganizationException((Exception)new IllegalArgumentException());
        }
        if (lpg.getId() == null) {
            throw new BPMOrganizationException((Exception)new IllegalArgumentException());
        }
        String lpgName = lpg.getName();
        if (lpgName == null) {
            throw new BPMOrganizationException(Severity.ERRORS, 70904, null, (Throwable)new IllegalArgumentException());
        }
        if ("".equals(lpgName = lpgName.trim())) {
            throw new BPMOrganizationException(Severity.ERRORS, 70904, null, (Throwable)new IllegalArgumentException());
        }
        PeopleQueryType pqt = lpg.getPeopleQuery();
        if (pqt == null) {
            throw new BPMOrganizationException(Severity.ERRORS, 70905, null, (Throwable)new IllegalArgumentException());
        }
        if (PeopleQueryUtil.isParamentricQuery(pqt) && !DatabaseInfo.isWorkflowSchemaFor111151orLater()) {
            throw new BPMOrganizationException(Severity.ERRORS, 70925, null, (Throwable)new IllegalArgumentException());
        }
        try {
            List<OrganizationalUnit> list;
            LogicalPeopleGroup jaxbLogicalPeopleGroup = this.getLogicalPeopleGroup(ctx, lpg.getId());
            PeopleQuery newPQ = new PeopleQuery(lpg.getPeopleQuery());
            String newPQasString = PeopleQueryUtil.getPeopleQueryAsString(newPQ);
            PeopleQuery orgPQ = new PeopleQuery(jaxbLogicalPeopleGroup.getPeopleQuery());
            String orgPQasString = PeopleQueryUtil.getPeopleQueryAsString(orgPQ);
            boolean isParametric = PeopleQueryUtil.isParamentricQuery((PeopleQueryType)newPQ.getValue());
            Boolean wasParametric = jaxbLogicalPeopleGroup.isParametricLPG() == null ? false : jaxbLogicalPeopleGroup.isParametricLPG();
            boolean wasEnabled = StatusTypeEnum.ENABLED.equals((Object)jaxbLogicalPeopleGroup.getStatus());
            boolean isUpdated = false;
            if (!lpgName.equals(jaxbLogicalPeopleGroup.getName()) || !orgPQasString.equals(newPQasString) || lpg.getStatus() != null && !lpg.getStatus().equals((Object)jaxbLogicalPeopleGroup.getStatus()) || lpg.getTimeout() != null && lpg.getTimeout().equals(jaxbLogicalPeopleGroup.getTimeout()) || isParametric ^ wasParametric) {
                isUpdated = true;
                jaxbLogicalPeopleGroup.setName(lpgName);
                jaxbLogicalPeopleGroup.setTimeout(PeopleQueryUtil.getTimeout(lpg));
                jaxbLogicalPeopleGroup.setPeopleQuery(pqt);
                if (isParametric) {
                    jaxbLogicalPeopleGroup.setParametricLPG(Boolean.TRUE);
                } else {
                    jaxbLogicalPeopleGroup.setParametricLPG(Boolean.FALSE);
                }
                if (lpg.getStatus() != null) {
                    jaxbLogicalPeopleGroup.setStatus(lpg.getStatus());
                } else {
                    jaxbLogicalPeopleGroup.setStatus(StatusTypeEnum.ENABLED);
                }
            }
            boolean bl = isParametric = jaxbLogicalPeopleGroup.isParametricLPG() == null ? false : jaxbLogicalPeopleGroup.isParametricLPG();
            if (isParametric && (list = this.getOrganizationalUnitAssociatedWithLPG(ctx, jaxbLogicalPeopleGroup.getId())).size() != 0) {
                BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "updateLogicalPeopleGroup");
                exCtx.setErrorCode(70922);
                exCtx.setSeverity(Severity.ERRORS);
                exCtx.setMessageArguments(new Object[]{lpgName, list.get(0).getOrganizationalUnitName()});
                throw new BPMOrganizationException(exCtx);
            }
            if (isExecuteImmediate && !isParametric && StatusTypeEnum.ENABLED.equals((Object)jaxbLogicalPeopleGroup.getStatus())) {
                jaxbLogicalPeopleGroup = PeopleQueryUtil.execute(ctx, jaxbLogicalPeopleGroup, null);
            }
            PeopleQueryUtil.setCreateUpdateInfo(ctx, jaxbLogicalPeopleGroup, false, isExecuteImmediate);
            this.bpmLogicalPeopleGroupPersistency.update(ctx, jaxbLogicalPeopleGroup);
            if (isUpdated) {
                PeopleQueryExecutor scheduler = PeopleQueryExecutor.getInstance();
                if (!wasParametric.booleanValue() && wasEnabled) {
                    scheduler.unscheduleExecutionJob(jaxbLogicalPeopleGroup);
                }
                if (!isParametric && StatusTypeEnum.ENABLED.equals((Object)jaxbLogicalPeopleGroup.getStatus())) {
                    scheduler.scheduleExecutionJob(jaxbLogicalPeopleGroup);
                }
            }
            LogicalPeopleGroup logicalPeopleGroup = jaxbLogicalPeopleGroup;
            return logicalPeopleGroup;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "updateLogicalPeopleGroup");
            exCtx.setErrorCode(70903);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{lpgName});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "updateLogicalPeopleGroup", "End");
            }
        }
    }

    public void deleteLogicalPeopleGroup(IBPMContext ctx, String lpgId, boolean force) throws BPMOrganizationException {
        String METHOD = "deleteLogicalPeopleGroup";
        String lpgName = null;
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteLogicalPeopleGroup", "Begin");
        }
        try {
            this.validateBPMOperation(ctx, 14);
            if (lpgId == null) {
                throw new BPMOrganizationException((Exception)new IllegalArgumentException());
            }
            LogicalPeopleGroup jaxbLogicalPeopleGroup = this.getLogicalPeopleGroup(ctx, lpgId);
            lpgName = jaxbLogicalPeopleGroup.getName();
            List<OrganizationalUnit> list = this.getOrganizationalUnitAssociatedWithLPG(ctx, lpgId);
            if (list.size() != 0 && !force) {
                BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "deleteLogicalPeopleGroup");
                exCtx.setErrorCode(70921);
                exCtx.setSeverity(Severity.ERRORS);
                exCtx.setMessageArguments(new Object[]{lpgName, list.get(0).getOrganizationalUnitName()});
                throw new BPMOrganizationException(exCtx);
            }
            this.bpmLogicalPeopleGroupPersistency.delete(ctx, jaxbLogicalPeopleGroup);
            Boolean isParametric = jaxbLogicalPeopleGroup.isParametricLPG() == null ? false : jaxbLogicalPeopleGroup.isParametricLPG();
            if (!isParametric.booleanValue() && StatusTypeEnum.ENABLED.equals((Object)jaxbLogicalPeopleGroup.getStatus())) {
                PeopleQueryExecutor scheduler = PeopleQueryExecutor.getInstance();
                scheduler.unscheduleExecutionJob(jaxbLogicalPeopleGroup);
            }
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Throwable t) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "deleteLogicalPeopleGroup");
            exCtx.setErrorCode(70902);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{lpgId});
            exCtx.setThrowable(t);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "deleteLogicalPeopleGroup", "End");
            }
        }
    }

    public LogicalPeopleGroup getLogicalPeopleGroup(IBPMContext ctx, String lpgId) throws BPMOrganizationException {
        return this.getLogicalPeopleGroup(ctx, lpgId, null);
    }

    public LogicalPeopleGroup getLogicalPeopleGroup(IBPMContext ctx, String lpgId, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "getLogicalPeopleGroup";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getLogicalPeopleGroup", "Begin");
        }
        try {
            this.validateBPMOperation(ctx, 11);
            if (lpgId == null) {
                throw new BPMOrganizationException((Exception)new IllegalArgumentException());
            }
            BpmLogicalPeopleGroup tlLogicalPeopleGroup = new BpmLogicalPeopleGroup();
            tlLogicalPeopleGroup.setId(lpgId);
            LogicalPeopleGroup jaxbLogicalPeopleGroup = (LogicalPeopleGroup)this.bpmLogicalPeopleGroupPersistency.read(ctx, tlLogicalPeopleGroup, unitOfWorkHolder);
            if (jaxbLogicalPeopleGroup == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70906, (Object[])new String[]{lpgId}, null);
            }
            LogicalPeopleGroup logicalPeopleGroup = jaxbLogicalPeopleGroup;
            return logicalPeopleGroup;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Throwable t) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "getLogicalPeopleGroup");
            exCtx.setErrorCode(70910);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{lpgId});
            exCtx.setThrowable(t);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getLogicalPeopleGroup", "End");
            }
        }
    }

    public List<LogicalPeopleGroup> getLogicalPeopleGroupsForUser(IBPMContext ctx, PrincipleRefType user) throws BPMOrganizationException {
        String METHOD = "getLogicalPeopleGroupsForUser";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getLogicalPeopleGroupsForUser", "Begin");
        }
        try {
            List<LogicalPeopleGroup> list;
            this.validateBPMOperation(ctx, 11);
            if (user == null) {
                throw new BPMOrganizationException((Exception)new IllegalArgumentException());
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getLogicalPeopleGroupsForUser", "Find  LogicalPeopleGroups for user:" + user.getName());
            }
            List<LogicalPeopleGroup> list2 = list = this.bpmLogicalPeopleGroupPersistency.getLogicalPeopleGroupsByUser(user);
            return list2;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "getLogicalPeopleGroupsForUser");
            exCtx.setErrorCode(70908);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{user.getName()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getLogicalPeopleGroupsForUser", "End");
            }
        }
    }

    public List<LogicalPeopleGroup> searchLogicalPeopleGroups(IBPMContext ctx, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow) throws BPMOrganizationException {
        String METHOD = "searchLogicalPeopleGroups";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "searchLogicalPeopleGroups", "Begin");
        }
        try {
            this.validateBPMOperation(ctx, 11);
            ArrayList<LogicalPeopleGroup> list = new ArrayList<LogicalPeopleGroup>();
            String searchString = searchCriteria;
            if (SearchModeTypeEnum.STARTS_WITH == searchMode) {
                searchString = searchCriteria + "%";
            } else if (SearchModeTypeEnum.ENDS_WITH == searchMode) {
                searchString = "%" + searchCriteria;
            } else if (SearchModeTypeEnum.CONTAINS == searchMode) {
                searchString = "%" + searchCriteria + "%";
            } else if (SearchModeTypeEnum.EQUALS == searchMode) {
                searchString = searchCriteria;
            } else if (SearchModeTypeEnum.LIKE == searchMode) {
                searchString = searchCriteria;
            }
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = null;
            expression = SearchModeTypeEnum.EQUALS == searchMode ? builder.get("name").equalsIgnoreCase(searchString) : builder.get("name").likeIgnoreCase(searchString);
            Vector<Object> vector = this.bpmLogicalPeopleGroupPersistency.executeQuery(ctx, BpmLogicalPeopleGroup.class, expression);
            for (Object e : vector) {
                list.add((LogicalPeopleGroup)e);
            }
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "searchLogicalPeopleGroups", "Found the following list of LogicalPeopleGroup: " + list);
            }
            ArrayList<LogicalPeopleGroup> arrayList = list;
            return arrayList;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "searchLogicalPeopleGroups");
            exCtx.setErrorCode(70909);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "searchLogicalPeopleGroups", "End");
            }
        }
    }

    public List<Participant> getLogicalPeopleGroupMembers(IBPMContext ctx, String lpgId) throws BPMOrganizationException {
        ArrayList list = new ArrayList();
        LogicalPeopleGroup jaxbLogicalPeopleGroup = this.getLogicalPeopleGroup(ctx, lpgId);
        PeopleQuery peopleQuery = new PeopleQuery(jaxbLogicalPeopleGroup.getPeopleQuery());
        return PeopleQueryUtil.execute(ctx, peopleQuery, null, null);
    }

    public List<Participant> executePeopleQuery(IBPMContext ctx, PeopleQuery peopleQuery, PeopleQueryContext peopleQueryCtx) throws BPMOrganizationException {
        return PeopleQueryUtil.execute(ctx, peopleQuery, peopleQueryCtx, null);
    }

    public List<OrganizationalUnit> getOrganizationalUnitForUser(IBPMContext ctx, String userId, String identityContext, boolean direct) throws BPMOrganizationException {
        return this.getOrganizationalUnitForUserInternal(ctx, userId, identityContext, null, direct);
    }

    public List<OrganizationalUnit> getOrganizationalUnitForUser(IBPMContext ctx, BPMUser user, boolean direct) throws BPMOrganizationException {
        String identityContext;
        try {
            identityContext = ctx.getIdentityContext() != null ? ctx.getIdentityContext() : user.getRealmName();
        }
        catch (BPMIdentityException e) {
            throw new BPMOrganizationException((Exception)((Object)e));
        }
        return this.getOrganizationalUnitForUserInternal(ctx, user.getName(), identityContext, user, direct);
    }

    public List<OrganizationalUnit> getOrganizationalUnitAssociatedWithLPG(IBPMContext ctx, String lpgId) throws BPMOrganizationException {
        Vector<Object> queriedOrganizationalUnits;
        String METHOD = "getOrganizationalUnitAssociatedWithLPG";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "lpgId:" + lpgId);
        }
        BPMOrganizationPersistency bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
        ArrayList<OrganizationalUnit> organizationalUnitList = new ArrayList<OrganizationalUnit>();
        StringBuffer sqlQuery = new StringBuffer("SELECT DISTINCT(ORGANIZATIONAL_UNIT_ID) FROM BPM_OU_USER BPMOUUSER  WHERE BPMOUUSER.PEOPLE_QUERY = '");
        sqlQuery.append(BPMOrganizationUtil.replaceSingleQuotesWithTwoSingleQuotes(lpgId));
        sqlQuery.append("'");
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "OrgUnitForGivenLPGId is computed by running the SQL Query:" + sqlQuery.toString());
        }
        if ((queriedOrganizationalUnits = bpmOrganizationPersistency.executeQuery(ctx, BpmOrganizationalUnit.class, sqlQuery.toString())) != null && !queriedOrganizationalUnits.isEmpty()) {
            for (int index = 0; index < queriedOrganizationalUnits.size(); ++index) {
                OrganizationalUnit queriedOrganizationalUnit = (OrganizationalUnit)queriedOrganizationalUnits.get(index);
                organizationalUnitList.add(queriedOrganizationalUnit);
            }
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitAssociatedWithLPG", "Computed OrgUnitForLPGId (" + lpgId + "):" + organizationalUnitList);
        }
        return organizationalUnitList;
    }

    public List<ProcessMetadataSummary> getActiveOrRetiredProcessMetadataSummaryList(IBPMContext context, String organizationalUnitId) throws ProcessMetadataServiceException {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getActiveOrRetiredProcessMetadataSummaryList", (String)("\n context: " + context + "\n organizationalUnitId: " + organizationalUnitId));
        }
        try {
            ProcessMetadataService processMetadataSvc = new ProcessMetadataService();
            List processMetadataSummaryList = processMetadataSvc.listProcessMetadataSummary(context, organizationalUnitId, null, null);
            return this.getActiveOrRetiredProcessMetadataSummaryListForOU(processMetadataSummaryList, organizationalUnitId);
        }
        catch (Exception e) {
            ProcessMetadataServiceException pmse = new ProcessMetadataServiceException(70807, (Object[])new String[0]);
            throw pmse;
        }
    }

    public OrganizationalUnit searchByOUNameOrHierarchyPath(IBPMContext bpmContext, String inputString, String tasknumber) throws BPMOrganizationException {
        if (WorkflowUtil.isNull((String)inputString)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"searchByOUNameOrHierarchyPath", (String)"\n OU name search string is null ");
            return null;
        }
        if (!BPMOrganizationService.doesValueContainDelimiter(inputString)) {
            List orgList = this.searchOrganizationEntity(bpmContext, OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.EQUALS, inputString, 0, 0, null);
            if (orgList != null && !orgList.isEmpty()) {
                if (orgList.size() > 1) {
                    throw new BPMOrganizationException(70701, new Object[]{inputString, tasknumber});
                }
                OrganizationalUnit org = (OrganizationalUnit)orgList.get(0);
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"searchByOUNameOrHierarchyPath", (String)("\nFound 1 matching OU for OU name" + inputString));
                return org;
            }
            throw new BPMOrganizationException(70702, new Object[]{inputString, tasknumber});
        }
        OrganizationalUnit orgUnit = this.searchByOUPath(bpmContext, inputString, tasknumber);
        return orgUnit;
    }

    public String getPhysicalRoleForSwimlaneRole(IBPMContext context, String swimlaneRole, String compositeDN) throws BPMOrganizationException {
        Map<String, String> rolesMap = this.getProcessRoles(context, compositeDN);
        return rolesMap.get(swimlaneRole);
    }

    public Map<String, String> getProcessRoles(IBPMContext context, String compositeDN) throws BPMOrganizationException {
        try {
            ProcessMetadataService pms = new ProcessMetadataService();
            return pms.getProcessRoles(context, compositeDN);
        }
        catch (ProcessMetadataServiceException pme) {
            throw new BPMOrganizationException((Exception)((Object)pme));
        }
    }

    public void clearFullCache() {
        try {
            VerificationService.clearFullCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void validateBPMOperation(IBPMContext wfCtx, int operation) throws BPMOrganizationException {
        String METHOD = "validateBPMOperation";
        if (wfCtx == null) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "validateBPMOperation", "Called with null context !");
            throw new BPMOrganizationException(70684, new Object[0]);
        }
        BPMOrganizationUtil.debugLog(CLASS_NAME, "validateBPMOperation", "Called with: \n wfCtx user=" + wfCtx.getUser() + "\n operation=" + operation);
        try {
            this.debugLog("validateBPMOperation", "Invoking VerificationService to validate the context.");
            VerificationService verificationSvc = new VerificationService();
            verificationSvc.validateContext((IWorkflowContext)wfCtx);
            this.debugLog("validateBPMOperation", "Validated context successfully.");
        }
        catch (Exception e) {
            throw new BPMOrganizationException(70684, new Object[]{e.getMessage()});
        }
        if (operation == 11) {
            return;
        }
        try {
            if (!VerificationService.isBPMOrganizationAdmin((IWorkflowContext)wfCtx)) {
                this.debugLog("validateBPMOperation", wfCtx.getUser() + " is not an Administrator. Request to execute operation denied.");
                throw new BPMOrganizationException(70685, new Object[]{wfCtx.getUser() + " is not an Administrator. Request to execute operation denied.."});
            }
        }
        catch (WorkflowException wfe) {
            throw new BPMOrganizationException((Exception)((Object)wfe));
        }
        this.debugLog("validateBPMOperation", "Authorization check completed successfully. Request to execute operation granted.");
    }

    boolean validateIsBPMComposerAdmin(IBPMContext wfCtx) throws BPMOrganizationException {
        String METHOD = "validateIsBPMComposerAdmin";
        if (wfCtx == null) {
            this.debugLog("validateIsBPMComposerAdmin", "Called with null context !");
            throw new BPMOrganizationException(70684, new Object[]{"Called with null context !"});
        }
        try {
            this.debugLog("validateIsBPMComposerAdmin", "Invoking VerificationService to validate the context.");
            VerificationService verificationSvc = new VerificationService();
            verificationSvc.validateContext((IWorkflowContext)wfCtx);
            this.debugLog("validateIsBPMComposerAdmin", "Validated context successfully.");
        }
        catch (Exception e) {
            throw new BPMOrganizationException(70684, new Object[]{e.getMessage()});
        }
        try {
            return VerificationService.isBPMComposerAdmin((IWorkflowContext)wfCtx);
        }
        catch (WorkflowException wfe) {
            throw new BPMOrganizationException((Exception)((Object)wfe));
        }
    }

    void isAdminOrManagerOfParticipants(IBPMContext wfCtx, List<Participant> participants) throws BPMOrganizationException {
        String METHOD = "isAdminOrManagerOfParticipants";
        if (wfCtx == null) {
            this.debugLog("isAdminOrManagerOfParticipants", "Called with null context !");
            throw new BPMOrganizationException(70684, new Object[]{"Called with NULL context"});
        }
        if (participants == null || participants.size() == 0) {
            return;
        }
        this.debugLog("isAdminOrManagerOfParticipants", "Called with: \n wfCtx user=" + wfCtx.getUser());
        try {
            this.debugLog("isAdminOrManagerOfParticipants", "Invoking VerificationService to get context validated.");
            VerificationService verificationSvc = new VerificationService();
            verificationSvc.validateContext((IWorkflowContext)wfCtx);
            this.debugLog("isAdminOrManagerOfParticipants", "Validated context successfully.");
        }
        catch (Exception e) {
            throw new BPMOrganizationException(70684, new Object[]{e.getMessage()});
        }
        try {
            if (VerificationService.isBPMOrganizationAdmin((IWorkflowContext)wfCtx)) {
                this.debugLog("isAdminOrManagerOfParticipants", "User  wfCtx user=" + wfCtx.getUser() + " is an Administrator. Permission to execute requested operation granted.");
                return;
            }
        }
        catch (WorkflowException wfe) {
            throw new BPMOrganizationException((Exception)((Object)wfe));
        }
        if (!wfCtx.isManager()) {
            this.debugLog("isAdminOrManagerOfParticipants", "User : " + wfCtx.getUser() + " is neither a manager nor an Administrator. Permission to execute requested operation denied.");
            throw new BPMOrganizationException(70685, new Object[]{"User : " + wfCtx.getUser() + " is neither a manager nor an Administrator. Permission to execute requested operation denied."});
        }
        try {
            String identityContext = wfCtx.getIdentityContext();
            BPMAuthorizationService as = (BPMAuthorizationService)AuthorizationServiceImpl.getInstance((String)identityContext);
            List allReportees = as.getReportees(wfCtx.getUser(), 1);
            HashMap<String, BPMUser> reporteesMap = new HashMap<String, BPMUser>();
            for (BPMUser usr : allReportees) {
                reporteesMap.put(usr.getName(), usr);
            }
            for (Participant p : participants) {
                if (!((PrincipleRefType)p.getValue()).getRealm().equalsIgnoreCase(identityContext)) {
                    this.debugLog("isAdminOrManagerOfParticipants", "Participant " + p.getName() + "is not from the same realm of " + wfCtx.getUser() + " : " + identityContext + ". Permission to execute requested operation denied.");
                    throw new BPMOrganizationException(70685, new Object[]{"Participant " + p.getName() + "is not from the same realm of " + wfCtx.getUser() + " : " + identityContext + ". Permission to execute requested operation denied."});
                }
                if (reporteesMap.get(p.getName()) != null) continue;
                this.debugLog("isAdminOrManagerOfParticipants", "Participant " + p.getName() + "does not report to " + wfCtx.getUser() + ". Permission to execute requested operation denied.");
                throw new BPMOrganizationException(70685, new Object[]{"Participant " + p.getName() + "does not report to " + wfCtx.getUser() + ". Permission to execute requested operation denied."});
            }
        }
        catch (Exception e) {
            Object[] msgs = new String[]{e.getMessage()};
            throw new BPMOrganizationException(70685, msgs);
        }
        this.debugLog("isAdminOrManagerOfParticipants", "Completed successfully. Permission to execute requested operation granted.");
    }

    void setPropertiesOnParticipants(IBPMContext ctx, List<ParticipantProperties> properties, boolean validate, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        if (properties == null || properties.size() == 0) {
            Object[] msgs = new String[]{};
            throw new BPMOrganizationException(70669, msgs);
        }
        ArrayList<Participant> participants = new ArrayList<Participant>();
        for (ParticipantProperties partProp : properties) {
            if (partProp.getParticipant().getRealm() == null) {
                partProp.getParticipant().setRealm(DEFAULT_REALM_NAME);
            }
            Participant participant = this.objectFactory.createParticipant(partProp.getParticipant());
            participants.add(participant);
        }
        this.isAdminOrManagerOfParticipants(ctx, participants);
        XMLGregorianCalendar todaysDateAndTime = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
        for (ParticipantProperties pp : properties) {
            String identityContext = ctx.getIdentityContext();
            if (WorkflowUtil.isNull((String)identityContext)) {
                identityContext = DEFAULT_REALM_NAME;
            }
            pp.setCreatedBy(ctx.getUser());
            pp.setCreatedByIdentityContext(identityContext);
            pp.setCreatedDate(todaysDateAndTime);
            pp.setLastUpdatedBy(ctx.getUser());
            pp.setLastUpdatedByIdentityContext(identityContext);
            pp.setLastUpdatedDate(todaysDateAndTime);
            if (pp.getParticipant().getRealm() != null && pp.getParticipant().getRealm().trim().length() != 0) continue;
            try {
                pp.getParticipant().setRealm(ISConfiguration.getDefaultRealmName());
            }
            catch (BPMConfigException e) {
                throw new BPMOrganizationException((Exception)((Object)e));
            }
        }
        if (!isEscalationPathCreated || !isPotentialAssigneeCreated) {
            this.addExtendedAppRolePropertyIfNonExistantForTypeRole(ctx, properties, unitOfWorkHolder);
        }
        if (validate) {
            this.validatePropertyValue(ctx, properties);
        }
        this.extUserPropertiesPersistenceDriver.setPropertiesOnParticipants(properties, unitOfWorkHolder);
    }

    void restoreExistingAppRoleGrants(IBPMContext ctx, Map<String, Set<Participant>> newAppRoleGrantsMap, Map<String, Set<Participant>> existingAppRoleGrantsMap) {
        ApplicationContext appCtx;
        String appContext;
        Set<Participant> newGrantees;
        Set<String> editedAppRoles = newAppRoleGrantsMap.keySet();
        for (String appRoleName : editedAppRoles) {
            newGrantees = newAppRoleGrantsMap.get(appRoleName);
            for (Participant participant : newGrantees) {
                appContext = ((PrincipleRefType)participant.getValue()).getApplicationContext();
                appCtx = this.objectFactory.createApplicationContext();
                if (appContext == null) {
                    appCtx.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP);
                } else if (appContext.equals(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP.value())) {
                    appCtx.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP);
                } else {
                    appCtx.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP);
                }
                try {
                    this.revokeAppRoleFromPrincipal(ctx, appCtx, appRoleName, participant);
                }
                catch (Exception exception) {
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "Exceptions occured  while revoking approle from principal, either role " + appRoleName + " is already granted to " + ((PrincipleRefType)participant.getValue()).getName() + " or an error ocured while revoking the role from principal, see logs for detailed information.");
                }
            }
        }
        editedAppRoles = existingAppRoleGrantsMap.keySet();
        for (String appRoleName : editedAppRoles) {
            newGrantees = existingAppRoleGrantsMap.get(appRoleName);
            for (Participant participant : newGrantees) {
                appContext = ((PrincipleRefType)participant.getValue()).getApplicationContext();
                appCtx = this.objectFactory.createApplicationContext();
                if (appContext == null) {
                    appCtx.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP);
                } else if (appContext.equals(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP.value())) {
                    appCtx.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP);
                } else {
                    appCtx.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP);
                }
                try {
                    this.grantAppRoleToPrincipalInternal(ctx, appCtx, appRoleName, participant);
                }
                catch (Exception exception) {
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "Exceptions occured  while granting appRole to principal, either role " + appRoleName + " is already granted to " + ((PrincipleRefType)participant.getValue()).getName() + " or an error ocured while granting the role to principal, see logs for detailed information.");
                }
            }
        }
    }

    LogicalPeopleGroup createLogicalPeopleGroup(IBPMContext ctx, LogicalPeopleGroup lpg, boolean isExecuteImmediate, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "createLogicalPeopleGroup";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createLogicalPeopleGroup", "Begin");
        }
        String lpgName = null;
        try {
            Boolean isParametric;
            this.validateBPMOperation(ctx, 12);
            if (lpg == null) {
                throw new BPMOrganizationException((Exception)new IllegalArgumentException());
            }
            lpgName = lpg.getName();
            if (lpgName == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70904, null, (Throwable)new IllegalArgumentException());
            }
            if ("".equals(lpgName = lpgName.trim())) {
                throw new BPMOrganizationException(Severity.ERRORS, 70904, null, (Throwable)new IllegalArgumentException());
            }
            PeopleQueryType pqt = lpg.getPeopleQuery();
            if (pqt == null) {
                throw new BPMOrganizationException(Severity.ERRORS, 70905, null, (Throwable)new IllegalArgumentException());
            }
            PeopleQuery peopleQuery = new PeopleQuery(pqt);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createLogicalPeopleGroup", "Create LogicalPeopleGroup  with peopleQuery=" + PeopleQueryUtil.getPeopleQueryAsString(peopleQuery));
            }
            if (PeopleQueryUtil.isParamentricQuery(pqt) && !DatabaseInfo.isWorkflowSchemaFor111151orLater()) {
                throw new BPMOrganizationException(Severity.ERRORS, 70925, null, (Throwable)new IllegalArgumentException());
            }
            String lpgId = lpg.getId();
            LogicalPeopleGroup jaxbLogicalPeopleGroup = this.objectFactory.createLogicalPeopleGroup();
            if (lpgId == null) {
                BPMOrganizationService bPMOrganizationService = this;
                lpgId = bPMOrganizationService.bpmLogicalPeopleGroupPersistency.getGuid();
            }
            jaxbLogicalPeopleGroup.setId(lpgId);
            jaxbLogicalPeopleGroup.setName(lpgName);
            jaxbLogicalPeopleGroup.setPeopleQuery(pqt);
            jaxbLogicalPeopleGroup.setStatus(StatusTypeEnum.ENABLED);
            jaxbLogicalPeopleGroup.setTimeout(PeopleQueryUtil.getTimeout(lpg));
            if (PeopleQueryUtil.isParamentricQuery(pqt)) {
                jaxbLogicalPeopleGroup.setParametricLPG(Boolean.TRUE);
            } else {
                jaxbLogicalPeopleGroup.setParametricLPG(Boolean.FALSE);
            }
            boolean isExecuted = false;
            if ((lpg.getStatus() == null || lpg.getStatus() != null && StatusTypeEnum.ENABLED.equals((Object)lpg.getStatus())) && !(isParametric = Boolean.valueOf(jaxbLogicalPeopleGroup.isParametricLPG() == null ? false : jaxbLogicalPeopleGroup.isParametricLPG())).booleanValue()) {
                jaxbLogicalPeopleGroup = PeopleQueryUtil.execute(ctx, jaxbLogicalPeopleGroup, unitOfWorkHolder);
                isExecuted = true;
                PeopleQueryExecutor scheduler = PeopleQueryExecutor.getInstance();
                scheduler.scheduleExecutionJob(jaxbLogicalPeopleGroup);
            }
            PeopleQueryUtil.setCreateUpdateInfo(ctx, jaxbLogicalPeopleGroup, true, isExecuted);
            this.bpmLogicalPeopleGroupPersistency.insert(ctx, jaxbLogicalPeopleGroup, unitOfWorkHolder);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createLogicalPeopleGroup", "LogicalPeopleGroup " + lpgName + " is created. LPG's PeopleQuery: " + peopleQuery.toString());
            }
            LogicalPeopleGroup logicalPeopleGroup = jaxbLogicalPeopleGroup;
            return logicalPeopleGroup;
        }
        catch (BPMOrganizationException e) {
            throw e;
        }
        catch (Throwable t) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "createLogicalPeopleGroup");
            exCtx.setErrorCode(70901);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{lpgName});
            exCtx.setThrowable(t);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createLogicalPeopleGroup", "End");
            }
        }
    }

    OrganizationalUnit createOrganizationalUnit(IBPMContext ctx, OrganizationalUnit organizationalUnit, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String METHOD = "createOrganizationalUnit";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createOrganizationalUnit", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createOrganizationalUnit", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "createOrganizationalUnit", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.printOrganizationalUnit(CLASS_NAME, "createOrganizationalUnit", organizationalUnit);
        }
        try {
            this.validateBPMOperation(ctx, 12);
            XMLGregorianCalendar calendar = BPMOrganizationPersistency.getXMLGregorianCalendar(Calendar.getInstance());
            this.setDefaults(ctx, organizationalUnit, 12, calendar);
            this.validate(ctx, organizationalUnit, null, 12, unitOfWorkHolder);
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createOrganizationalUnit", "organizationalUnit after setting the defaults:");
                BPMOrganizationUtil.printOrganizationalUnit(CLASS_NAME, "createOrganizationalUnit", organizationalUnit);
            }
            this.bpmOrganizationPersistency.insert(ctx, organizationalUnit, unitOfWorkHolder);
        }
        catch (BPMOrganizationException bpmOrganizationException) {
            throw bpmOrganizationException;
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, CLASS_NAME, "createOrganizationalUnit");
            exCtx.setErrorCode(70600);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setMessageArguments(new Object[]{e.getMessage()});
            exCtx.setThrowable((Throwable)e);
            throw new BPMOrganizationException(exCtx);
        }
        finally {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "createOrganizationalUnit", "End");
            }
        }
        return organizationalUnit;
    }

    void populateExistingRoleGrants(IBPMContext ctx, ApplicationRoleType appRoleType, ApplicationContext appContext, Map<String, Set<Participant>> existingAppRoleGrantsMap) {
        Set<Object> grantees = new HashSet();
        try {
            grantees = AppRoleUtil.getInstance().getGrantees(appRoleType.getName(), true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        HashSet<Participant> participants = new HashSet<Participant>();
        for (BPMIdentity bPMIdentity : grantees) {
            PrincipleRefType principleRefType = this.objectFactory.createPrincipleRefType();
            principleRefType.setName(bPMIdentity.getName());
            try {
                if (bPMIdentity instanceof BPMUser) {
                    principleRefType.setRealm(bPMIdentity.getRealmName());
                    principleRefType.setType(ParticipantTypeEnum.USER);
                } else if (bPMIdentity instanceof BPMGroup) {
                    principleRefType.setRealm(bPMIdentity.getRealmName());
                    principleRefType.setType(ParticipantTypeEnum.GROUP);
                } else if (bPMIdentity instanceof BPMAppRole) {
                    principleRefType.setApplicationContext(((BPMAppRole)bPMIdentity).getAppID());
                    principleRefType.setType(ParticipantTypeEnum.APPROLE);
                }
                principleRefType.setApplicationContext(appRoleType.getIdentityContext());
                Participant participant = this.objectFactory.createParticipant(principleRefType);
                participants.add(participant);
                this.revokeAppRoleFromPrincipal(ctx, appContext, appRoleType.getName(), participant);
            }
            catch (Exception ex) {
                BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "Exceptions occured  while revoking approle from principal, either role " + appRoleType.getName() + " is already granted to " + bPMIdentity.getName() + " or an error ocured while revoking the role from principal, see logs for detailed information.");
            }
        }
        if (existingAppRoleGrantsMap.containsKey(appRoleType.getName())) {
            Set<Participant> set = existingAppRoleGrantsMap.get(appRoleType.getName());
            participants.addAll(set);
        }
        existingAppRoleGrantsMap.put(appRoleType.getName(), participants);
    }

    void populateNewRoleGrants(IBPMContext ctx, ApplicationRoleType appRoleType, ApplicationContext appContext, boolean validate, Map<String, Set<Participant>> newAppRoleGrantsMap) {
        List membersList = appRoleType.getMember();
        HashSet<Participant> newParticipants = new HashSet<Participant>();
        if (membersList != null) {
            for (PrincipleRefType member : membersList) {
                try {
                    boolean validParticipant = true;
                    if (validate) {
                        validParticipant = this.validateParticipant(new Participant(member));
                    }
                    if (validParticipant) {
                        this.grantAppRoleToPrincipalInternal(ctx, appContext, appRoleType.getName(), new Participant(member));
                    }
                    member.setApplicationContext(appRoleType.getIdentityContext());
                    Participant participant = this.objectFactory.createParticipant(member);
                    newParticipants.add(participant);
                }
                catch (Exception ex) {
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "insertAppRole", "Exceptions occured  while granting appRole to principal, either role " + appRoleType.getName() + " is already granted to " + member.getName() + " or an error ocured while granting the role to principal, see logs for detailed information.");
                }
            }
        }
        if (newAppRoleGrantsMap.containsKey(appRoleType.getName())) {
            Set<Participant> existingParticipants = newAppRoleGrantsMap.get(appRoleType.getName());
            newParticipants.addAll(existingParticipants);
        }
        newAppRoleGrantsMap.put(appRoleType.getName(), newParticipants);
    }

    void createAppRoleInternal(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, String optionalDisplayName, String optionalDesc, boolean isSystemRole) throws BPMIdentityException, PolicyObjectAlreadyExistsException, PolicyStoreException, PrivilegedActionException, Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"createAppRole", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n displayName=" + optionalDisplayName + "\n description=" + optionalDesc));
        this.validateBPMOperation(ctx, 12);
        AppRoleUtil.getInstance().createAppRole(appCtx, appRoleName, optionalDisplayName, optionalDesc, isSystemRole);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"createAppRole", (String)"Completed.");
    }

    void grantAppRoleToPrincipalInternal(IBPMContext ctx, ApplicationContext appCtx, String appRoleName, Participant participant) throws PolicyObjectAlreadyExistsException, ApplicationRoleInUseException, PolicyObjectNotFoundException, PolicyStoreException, NullPointerException, PrivilegedActionException, Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)("Called with:\n WorkflowContext=" + ctx + "\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n participant=" + participant));
        if (!this.validateIsBPMComposerAdmin(ctx)) {
            this.validateBPMOperation(ctx, 12);
        }
        AppRoleUtil.getInstance().grantAppRoleToPrincipal(appCtx, appRoleName, participant);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)"Completed.");
    }

    BPMAppRole getAppRoleForAppRoleName(String appRoleName, String applicationContext) {
        BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance();
        BPMAppRole role = null;
        try {
            role = as.lookupAppRole(appRoleName, applicationContext);
        }
        catch (BPMIdentityNotFoundException e) {
            BPMLogger.log((Throwable)e);
        }
        catch (BPMIdentityException e) {
            BPMLogger.log((Throwable)e);
        }
        return role;
    }

    void debugLog(String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)method, (String)msg);
        }
    }

    boolean validate(IBPMContext ctx, String processOrgUnitId, List<OrganizationalUnit> organizationalUnits) throws Exception {
        if (processOrgUnitId == null || processOrgUnitId.equals("")) {
            return true;
        }
        for (OrganizationalUnit orgUnit : organizationalUnits) {
            if (!orgUnit.getOrganizationalUnitId().equalsIgnoreCase(processOrgUnitId)) continue;
            return true;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = null;
        expression = builder.get("organizationalUnitId").equalsIgnoreCase(processOrgUnitId);
        Vector<Object> returnList = this.bpmOrganizationPersistency.executeQuery(ctx, BpmOrganizationalUnit.class, expression);
        return returnList != null && returnList.size() > 0;
    }

    boolean validateParticipant(Participant participant) throws BPMOrganizationException {
        try {
            return AppRoleUtil.getInstance().validateParticipant(participant);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    List<OrganizationalUnit> getOrganizationalUnitForAppRoleInternal(IBPMContext ctx, String appRoleName, String identityContext) throws BPMOrganizationException {
        String METHOD = "getOrganizationalUnitForAppRoleInternal";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForAppRoleInternal", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForAppRoleInternal", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForAppRoleInternal", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForAppRoleInternal", "appRoleName:" + appRoleName);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForAppRoleInternal", "identityContext:" + identityContext);
        }
        ArrayList<OrganizationalUnit> allOrganizationalUnitList = new ArrayList<OrganizationalUnit>();
        List<String> orgIds = this.bpmOrganizationPersistency.getOrganizationalUnitForAppRole(ctx, appRoleName, identityContext);
        if (orgIds != null && !orgIds.isEmpty()) {
            for (String orgId : orgIds) {
                allOrganizationalUnitList.add(this.getOrganizationalUnit(ctx, orgId, ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD));
            }
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForAppRoleInternal", "Computed OrgUnitForAppRole (" + appRoleName + "):" + allOrganizationalUnitList);
        }
        return allOrganizationalUnitList;
    }

    List<OrganizationalUnit> getOrganizationalUnitForGroup(IBPMContext ctx, String groupName) throws BPMOrganizationException {
        String METHOD = "getOrganizationalUnitForGroup";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForGroup", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForGroup", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForGroup", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForGroup", "appRoleName:" + groupName);
        }
        ArrayList<OrganizationalUnit> allOrganizationalUnitList = new ArrayList<OrganizationalUnit>();
        List<String> orgIds = this.bpmOrganizationPersistency.getOrganizationalUnitForGroup(ctx, groupName);
        if (orgIds != null && !orgIds.isEmpty()) {
            for (String orgId : orgIds) {
                allOrganizationalUnitList.add(this.getOrganizationalUnit(ctx, orgId, ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD));
            }
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForGroup", "Computed OrgUnitForAppRole (" + groupName + "):" + allOrganizationalUnitList);
        }
        return allOrganizationalUnitList;
    }

    private static List<OrganizationalUnit> getAllParentOrganizationalUnits(BPMOrganizationService bpmOrganizationService, IBPMContext ctx, OrganizationalUnit organizationalUnit) throws BPMOrganizationException {
        ArrayList<OrganizationalUnit> organizationalUnitList = new ArrayList<OrganizationalUnit>();
        organizationalUnitList.add(organizationalUnit);
        String parentOrganizationalUnitId = organizationalUnit.getParentOrganizationalUnitId();
        if (parentOrganizationalUnitId != null) {
            OrganizationalUnit parentOrganizationalUnit = bpmOrganizationService.getOrganizationalUnit(ctx, parentOrganizationalUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
            organizationalUnitList.addAll(BPMOrganizationService.getAllParentOrganizationalUnits(bpmOrganizationService, ctx, parentOrganizationalUnit));
        }
        return organizationalUnitList;
    }

    private static boolean doesValueContainDelimiter(String v) {
        boolean containsDelim = false;
        if (v != null && !v.trim().equals("")) {
            int indexOf = v.indexOf(hirearchyPathSeparator);
            containsDelim = indexOf != -1;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)BPMOrganizationService.class.getName(), (String)"doesValueContainDelimiter", (String)("\n Input OU name : " + v + " contains delimited ou path - " + containsDelim));
        return containsDelim;
    }

    private OrganizationalUnit searchByOUPath(IBPMContext bpmContext, String inputString, String tasknumber) throws BPMOrganizationException {
        List OUList;
        String[] ouNameTokens = inputString.split(hirearchyPathSeparator);
        if (ouNameTokens == null || ouNameTokens.length == 0) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"searchByOUPath", (String)"\n OU name not specified ");
            return null;
        }
        int tokenSize = ouNameTokens.length;
        boolean ouFound = false;
        OrganizationEntitySearchContext searchContext = null;
        if (inputString.startsWith(hirearchyPathSeparator) && tokenSize == 2) {
            searchContext = OrganizationEntitySearchContext.ORGANIZATIONAL_UNIT_ROOT_ORGANIZATIONAL_UNIT;
        }
        if ((OUList = this.searchOrganizationEntity(bpmContext, OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.EQUALS, ouNameTokens[tokenSize - 1], 0, 0, searchContext)) == null || OUList.isEmpty()) {
            throw new BPMOrganizationException(70702, new Object[]{inputString, tasknumber});
        }
        if (OUList.size() == 1) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"searchByOUPath", (String)("\nMatching OU found for " + inputString));
            return (OrganizationalUnit)OUList.get(0);
        }
        boolean alreadyFound = false;
        OrganizationalUnit returnOU = null;
        for (int i = 0; i < OUList.size(); ++i) {
            OrganizationalUnit currentOU = (OrganizationalUnit)OUList.get(i);
            if (!this.doesOUMatch(bpmContext, currentOU, tokenSize, ouNameTokens)) continue;
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"searchByOUPath", (String)("\nMatching OU with Id " + currentOU.getOrganizationalUnitId() + " found. " + "Checking if this is unique"));
            if (!alreadyFound) {
                alreadyFound = true;
                returnOU = currentOU;
                continue;
            }
            throw new BPMOrganizationException(70701, new Object[]{inputString, tasknumber});
        }
        if (returnOU == null) {
            throw new BPMOrganizationException(70702, new Object[]{inputString, tasknumber});
        }
        return returnOU;
    }

    private boolean doesOUMatch(IBPMContext bpmContext, OrganizationalUnit currentOU, int tokenSize, String[] ouNameTokens) throws BPMOrganizationException {
        OrganizationalUnit orgUnit = currentOU;
        for (int j = tokenSize - 2; j >= 0; --j) {
            boolean ouFound = false;
            String parentOUName = orgUnit.getParentOrganizationalUnitName();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"searchByOUPath", (String)("Comparing nametoken :" + ouNameTokens[j] + " with parent ou:" + parentOUName));
            if (parentOUName != null && parentOUName.equalsIgnoreCase(ouNameTokens[j])) {
                ouFound = true;
                orgUnit = this.getOrganizationalUnit(bpmContext, orgUnit.getParentOrganizationalUnitId(), null);
            }
            if (ouFound) {
                if (j != 0) continue;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"searchByOUPath", (String)("\nMatching OU with Id " + currentOU.getOrganizationalUnitId() + " found. "));
                return true;
            }
            break;
        }
        return false;
    }

    private List<OrganizationalUnit> getOrganizationalUnitForUserInternal(IBPMContext ctx, String userId, String identityContext, BPMUser user, boolean direct) throws BPMOrganizationException {
        Vector<DatabaseRecord> queriedOrganizationalUnitsMap;
        String METHOD = "getOrganizationalUnitForUser";
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "Begin");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "Parameters:");
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "ctx:" + (ctx == null ? "null" : ctx.getUser() + ":" + ctx.getIdentityContext()));
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "userId:" + userId);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "identityContext:" + identityContext);
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "direct:" + direct);
        }
        BPMOrganizationPersistency bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
        ArrayList organizationalUnitList = new ArrayList();
        ArrayList<OrganizationalUnit> allOrganizationalUnitList = new ArrayList<OrganizationalUnit>();
        StringBuffer sqlQuery = new StringBuffer("SELECT DISTINCT(subqry.ORGANIZATIONAL_UNIT_ID) FROM (SELECT ORGANIZATIONAL_UNIT_ID FROM BPM_OU_USER BPMOUUSER, BPM_LPG_MEMBER LPG  WHERE BPMOUUSER.PEOPLE_QUERY = LPG.QUERY_ID AND LPG.USER_ID = '");
        sqlQuery.append(BPMOrganizationUtil.replaceSingleQuotesWithTwoSingleQuotes(userId));
        sqlQuery.append("' AND LPG.IDENTITY_CONTEXT = '");
        sqlQuery.append(identityContext);
        sqlQuery.append("' UNION SELECT ORGANIZATIONAL_UNIT_ID FROM BPM_OU_USER WHERE (USER_ID = '");
        sqlQuery.append(BPMOrganizationUtil.replaceSingleQuotesWithTwoSingleQuotes(userId));
        sqlQuery.append("' AND USER_TYPE = '" + ParticipantTypeEnum.USER + "' ");
        sqlQuery.append(" AND IDENTITY_CONTEXT = '");
        sqlQuery.append(identityContext);
        sqlQuery.append("') ");
        try {
            List groups = user == null ? VerificationService.getGroupNamesList((String)userId, (String)identityContext) : VerificationService.getGroupNamesList((BPMIdentity)user);
            if (groups != null) {
                for (String group : groups) {
                    sqlQuery.append(" OR (USER_ID = '");
                    sqlQuery.append(BPMOrganizationUtil.replaceSingleQuotesWithTwoSingleQuotes(group));
                    sqlQuery.append("' AND USER_TYPE = '" + ParticipantTypeEnum.GROUP + "' ");
                    sqlQuery.append(" AND IDENTITY_CONTEXT = '");
                    sqlQuery.append(identityContext);
                    sqlQuery.append("') ");
                }
            }
            Map appRoles = user == null ? VerificationService.getAppRoleNamesMap((String)userId, (String)identityContext) : VerificationService.getAppRoleNamesMap((BPMIdentity)user);
            for (String appName : appRoles.keySet()) {
                Set set = (Set)appRoles.get(appName);
                if (set == null) continue;
                Iterator itr = set.iterator();
                while (itr.hasNext()) {
                    String appRoleId = itr.next().toString();
                    sqlQuery.append(" OR (USER_ID = '");
                    sqlQuery.append(BPMOrganizationUtil.replaceSingleQuotesWithTwoSingleQuotes(appRoleId));
                    sqlQuery.append("' AND USER_TYPE = '" + ParticipantTypeEnum.APPROLE + "' ");
                    sqlQuery.append(") ");
                }
            }
        }
        catch (WorkflowException wfe) {
            throw new BPMOrganizationException((Exception)((Object)wfe));
        }
        sqlQuery.append(") subqry");
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "OrgUnitForUser computed by running the SQL Query:" + sqlQuery.toString());
        }
        if ((queriedOrganizationalUnitsMap = bpmOrganizationPersistency.executeSQL(ctx, sqlQuery.toString())) != null && !queriedOrganizationalUnitsMap.isEmpty()) {
            for (DatabaseRecord databaseRecord : queriedOrganizationalUnitsMap) {
                if (databaseRecord == null || databaseRecord.isEmpty()) continue;
                Object key = databaseRecord.keySet().iterator().next();
                Object organizationalUnitIdObject = databaseRecord.get(key);
                String organizationalUnitId = (String)organizationalUnitIdObject;
                BPMOrganizationService bpmOrganizationService = new BPMOrganizationService();
                OrganizationalUnit organizationalUnit = bpmOrganizationService.getOrganizationalUnit(ctx, organizationalUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
                if (direct) {
                    allOrganizationalUnitList.add(organizationalUnit);
                    continue;
                }
                allOrganizationalUnitList.addAll(BPMOrganizationService.getAllParentOrganizationalUnits(bpmOrganizationService, ctx, organizationalUnit));
            }
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrganizationalUnitForUser", "Computed OrgUnitForUser (" + userId + "):" + organizationalUnitList);
        }
        return allOrganizationalUnitList;
    }

    private String getProcessNameList(List<ProcessMetadataSummary> processList) {
        StringBuffer sb = new StringBuffer();
        if (processList == null) {
            return sb.toString();
        }
        for (int i = 0; i < processList.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            ProcessMetadataSummary processMetadata = processList.get(i);
            sb.append(processMetadata.getProcessName());
        }
        return sb.toString();
    }

    private String getOrganizationalUnitNameList(List<OrganizationalUnit> ouList) {
        StringBuffer sb = new StringBuffer();
        if (ouList == null) {
            return sb.toString();
        }
        for (int i = 0; i < ouList.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ouList.get(i).getOrganizationalUnitName());
        }
        return sb.toString();
    }

    private void validate(IBPMContext ctx, OrganizationalUnit organizationalUnit, String organizationalUnitId, int operation) throws BPMOrganizationException {
        this.validate(ctx, organizationalUnit, organizationalUnitId, operation, false);
    }

    private void validate(IBPMContext ctx, OrganizationalUnit organizationalUnit, String organizationalUnitId, int operation, boolean deleteChildren) throws BPMOrganizationException {
        this.validate(ctx, organizationalUnit, organizationalUnitId, operation, deleteChildren, null, null);
    }

    private void validate(IBPMContext ctx, OrganizationalUnit organizationalUnit, String organizationalUnitId, int operation, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        this.validate(ctx, organizationalUnit, organizationalUnitId, operation, false, unitOfWorkHolder, null);
    }

    private void validate(IBPMContext ctx, OrganizationalUnit organizationalUnit, String organizationalUnitId, int operation, boolean deleteChildren, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder, OrganizationalUnit parentOrganizationalUnit) throws BPMOrganizationException {
        block30: {
            List childrens;
            block29: {
                if ((operation == 11 || operation == 14) && WorkflowUtil.isNull((String)organizationalUnitId)) {
                    throw new BPMOrganizationException(70605, null);
                }
                if (operation == 14) {
                    try {
                        List<ProcessMetadataSummary> processList = this.getActiveOrRetiredProcessMetadataSummaryList(ctx, organizationalUnitId);
                        if (processList != null && processList.size() > 0) {
                            throw new BPMOrganizationException(Severity.ERRORS, 70683, new Object[]{organizationalUnitId, this.getProcessNameList(processList)});
                        }
                    }
                    catch (ProcessMetadataServiceException e) {
                        throw new BPMOrganizationException((Exception)((Object)e));
                    }
                }
                if (operation == 12 || operation == 13) {
                    if (organizationalUnit == null) {
                        throw new BPMOrganizationException(70605, null);
                    }
                    organizationalUnitId = organizationalUnit.getOrganizationalUnitId();
                }
                BpmOrganizationalUnit bpmOrganizationalUnit = new BpmOrganizationalUnit();
                bpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnitId);
                Object obj = this.bpmOrganizationPersistency.readObject(ctx, bpmOrganizationalUnit, unitOfWorkHolder);
                if (operation == 11 || operation == 13 || operation == 14) {
                    if (obj == null) {
                        Object[] objs = new Object[]{organizationalUnitId};
                        throw new BPMOrganizationException(70602, objs);
                    }
                } else if (operation == 12 && obj != null) {
                    Object[] objs = new Object[]{organizationalUnitId};
                    throw new BPMOrganizationException(70686, objs);
                }
                if (operation == 12 || operation == 13) {
                    if (WorkflowUtil.isNull((String)organizationalUnit.getOrganizationalUnitName())) {
                        Object[] objs = new Object[]{organizationalUnit.getOrganizationalUnitId()};
                        throw new BPMOrganizationException(70604, objs);
                    }
                    String parentId = organizationalUnit.getParentOrganizationalUnitId();
                    if (parentId != null) {
                        OrganizationalUnit parentOU = null;
                        parentOU = operation == 12 && parentOrganizationalUnit != null ? parentOrganizationalUnit : this.getOrganizationalUnit(ctx, parentId, ChildOrganizationalUnitRetrievalModeTypeEnum.ONLY_FIRST_LEVEL_CHILD, unitOfWorkHolder);
                        List children = parentOU.getChildOrganizationalUnits();
                        String existingOUID = this.getOUWithSameName(organizationalUnit.getOrganizationalUnitId(), organizationalUnit.getOrganizationalUnitName(), children, operation);
                        if (existingOUID != null) {
                            Object[] objs = new Object[]{existingOUID, organizationalUnit.getOrganizationalUnitName()};
                            throw new BPMOrganizationException(70610, objs);
                        }
                    } else {
                        List rootOUList = this.searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.LIKE, "%", 0, 0, OrganizationEntitySearchContext.ORGANIZATIONAL_UNIT_ROOT_ORGANIZATIONAL_UNIT);
                        String existingOUID = this.getOUWithSameName(organizationalUnit.getOrganizationalUnitId(), organizationalUnit.getOrganizationalUnitName(), rootOUList, operation);
                        if (existingOUID != null) {
                            Object[] objs = new Object[]{existingOUID, organizationalUnit.getOrganizationalUnitName()};
                            throw new BPMOrganizationException(70610, objs);
                        }
                    }
                }
                if (operation == 12 || operation == 13) {
                    if (organizationalUnit != null && !WorkflowUtil.isNull((String)organizationalUnit.getCalendarRuleId())) {
                        BpmCalendarRule bpmCalendarRule = new BpmCalendarRule();
                        bpmCalendarRule.setId(organizationalUnit.getCalendarRuleId());
                        bpmCalendarRule = (BpmCalendarRule)this.bpmOrganizationPersistency.readObject(ctx, bpmCalendarRule);
                        if (bpmCalendarRule != null) {
                            organizationalUnit.setCalendarRuleName(bpmCalendarRule.getName());
                        }
                    }
                    if (organizationalUnit != null && !WorkflowUtil.isNull((String)organizationalUnit.getParentOrganizationalUnitId())) {
                        BpmOrganizationalUnit parentBpmOrganizationalUnit = new BpmOrganizationalUnit();
                        parentBpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnit.getParentOrganizationalUnitId());
                        if (operation == 12 && parentOrganizationalUnit != null) {
                            parentBpmOrganizationalUnit.setHierarchyPath(parentOrganizationalUnit.getHierarchyPath());
                        } else {
                            parentBpmOrganizationalUnit = (BpmOrganizationalUnit)this.bpmOrganizationPersistency.readObject(ctx, parentBpmOrganizationalUnit, unitOfWorkHolder);
                        }
                        if (parentBpmOrganizationalUnit == null) {
                            Object[] objs = new Object[]{organizationalUnit.getParentOrganizationalUnitId()};
                            throw new BPMOrganizationException(70603, objs);
                        }
                        organizationalUnit.setHierarchyPath(parentBpmOrganizationalUnit.getHierarchyPath() + organizationalUnit.getOrganizationalUnitId() + hirearchyPathSeparator);
                    } else if (organizationalUnit != null) {
                        organizationalUnit.setHierarchyPath(organizationalUnit.getOrganizationalUnitId() + hirearchyPathSeparator);
                    }
                }
                if (operation != 14 || !deleteChildren) break block29;
                organizationalUnit = this.getOrganizationalUnit(ctx, organizationalUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum.ONLY_FIRST_LEVEL_CHILD);
                childrens = organizationalUnit.getChildOrganizationalUnits();
                if (CommonUtil.isListNullOrEmpty((List)childrens)) break block30;
                for (OrganizationalUnit childOrganizationalUnit : childrens) {
                    this.validate(ctx, null, childOrganizationalUnit.getOrganizationalUnitId(), operation, deleteChildren, unitOfWorkHolder, null);
                }
                break block30;
            }
            if (organizationalUnit != null && !CommonUtil.isListNullOrEmpty((List)(childrens = organizationalUnit.getChildOrganizationalUnits()))) {
                for (OrganizationalUnit childOrganizationalUnit : childrens) {
                    this.validate(ctx, childOrganizationalUnit, null, operation, deleteChildren, unitOfWorkHolder, organizationalUnit);
                }
            }
        }
    }

    private String getOUWithSameName(String id, String name, List<OrganizationalUnit> list, int operation) {
        for (OrganizationalUnit ou : list) {
            String ouname = ou.getOrganizationalUnitName();
            if (ouname == null || !ouname.equals(name) || operation == 13 || id.equals(ou.getOrganizationalUnitId())) continue;
            return ou.getOrganizationalUnitId();
        }
        return null;
    }

    private void setDefaults(IBPMContext ctx, OrganizationalUnit organizationalUnit, int operation, XMLGregorianCalendar calendar) throws BPMOrganizationException {
        List childrens;
        if (organizationalUnit == null) {
            return;
        }
        if (WorkflowUtil.isNull((String)organizationalUnit.getOrganizationalUnitId())) {
            organizationalUnit.setOrganizationalUnitId(Util.getGuid());
        }
        if (operation == 12) {
            organizationalUnit.setCreatedBy(ctx.getUser());
            if (ctx.getIdentityContext() != null) {
                organizationalUnit.setCreatedByIdentityContext(ctx.getIdentityContext());
            } else {
                organizationalUnit.setCreatedByIdentityContext(DEFAULT_REALM_NAME);
            }
            organizationalUnit.setCreatedDate(calendar);
        }
        organizationalUnit.setLastUpdatedBy(ctx.getUser());
        organizationalUnit.setLastUpdatedDate(calendar);
        if (ctx.getIdentityContext() != null) {
            organizationalUnit.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
        } else {
            organizationalUnit.setLastUpdatedByIdentityContext(DEFAULT_REALM_NAME);
        }
        if (operation == 12 || operation == 13) {
            List lpgUsers;
            List users;
            List managers = organizationalUnit.getManagedByMember();
            if (!CommonUtil.isListNullOrEmpty((List)managers)) {
                for (int index = 0; index < managers.size(); ++index) {
                    MemberType manager = (MemberType)managers.get(index);
                    if (manager.getMemberId() != null) continue;
                    manager.setMemberId(Util.getGuid());
                }
            }
            if (!CommonUtil.isListNullOrEmpty((List)(users = organizationalUnit.getMember()))) {
                for (int index = 0; index < users.size(); ++index) {
                    MemberType user = (MemberType)users.get(index);
                    if (user.getMemberId() != null) continue;
                    user.setMemberId(Util.getGuid());
                }
            }
            if (!CommonUtil.isListNullOrEmpty((List)(lpgUsers = organizationalUnit.getPeopleQueryMember()))) {
                for (int index = 0; index < lpgUsers.size(); ++index) {
                    PeopleQueryMemberType peopleQueryUser = (PeopleQueryMemberType)lpgUsers.get(index);
                    if (peopleQueryUser.getMemberId() != null) continue;
                    peopleQueryUser.setMemberId(Util.getGuid());
                }
            }
        }
        if (CommonUtil.isListNullOrEmpty((List)(childrens = organizationalUnit.getChildOrganizationalUnits()))) {
            for (OrganizationalUnit childOrganizationalUnit : childrens) {
                this.setDefaults(ctx, childOrganizationalUnit, operation, calendar);
            }
        }
    }

    private void addChildrens(IBPMContext ctx, OrganizationalUnit organizationalUnit, ChildOrganizationalUnitRetrievalModeTypeEnum childOrganizationalUnitRetrievalMode) throws BPMOrganizationException {
        if (ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD == childOrganizationalUnitRetrievalMode) {
            return;
        }
        String sqlQuery = "SELECT * FROM BPM_ORGANIZATIONAL_UNIT WHERE  PARENT_ORGANIZATIONAL_UNIT_ID = '" + BPMOrganizationUtil.replaceSingleQuotesWithTwoSingleQuotes(organizationalUnit.getOrganizationalUnitId()) + "'";
        Vector<Object> childrens = this.bpmOrganizationPersistency.executeQuery(ctx, BpmOrganizationalUnit.class, sqlQuery);
        if (childrens != null && !childrens.isEmpty()) {
            for (int index = 0; index < childrens.size(); ++index) {
                OrganizationalUnit childrenOrganizationalUnit = (OrganizationalUnit)childrens.get(index);
                organizationalUnit.getChildOrganizationalUnits().add(childrenOrganizationalUnit);
                if (ChildOrganizationalUnitRetrievalModeTypeEnum.ONLY_FIRST_LEVEL_CHILD == childOrganizationalUnitRetrievalMode) continue;
                this.addChildrens(ctx, childrenOrganizationalUnit, childOrganizationalUnitRetrievalMode);
            }
        } else {
            return;
        }
    }

    private void validate(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation, String applicationRoleOrgUnitCalendarAssociationId, int operation, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        String ouId;
        String calRuleId;
        if (operation == 12 || operation == 13) {
            if (applicationRoleOrgUnitCalendarAssociation == null) {
                throw new BPMOrganizationException(70607, null);
            }
            if (WorkflowUtil.isNull((String)applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId())) {
                throw new BPMOrganizationException(70606, null);
            }
        }
        if (operation == 14 && WorkflowUtil.isNull((String)applicationRoleOrgUnitCalendarAssociationId)) {
            throw new BPMOrganizationException(70606, null);
        }
        if (!(operation != 12 && operation != 13 || applicationRoleOrgUnitCalendarAssociation.getApplicationRole() != null && applicationRoleOrgUnitCalendarAssociation.getApplicationRole().getName() != null && !applicationRoleOrgUnitCalendarAssociation.getApplicationRole().getName().trim().isEmpty())) {
            throw new BPMOrganizationException(70690, null);
        }
        BpmAppRoleOuCalAssoc bpmAppRoleOuCalAssoc = new BpmAppRoleOuCalAssoc();
        if (operation == 14) {
            bpmAppRoleOuCalAssoc.setId(applicationRoleOrgUnitCalendarAssociationId);
        }
        if (operation == 12 || operation == 13) {
            bpmAppRoleOuCalAssoc.setId(applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId());
        }
        Object obj = this.bpmOrganizationPersistency.readObject(ctx, bpmAppRoleOuCalAssoc, unitOfWorkHolder);
        List<ApplicationRoleOrgUnitCalendarAssociation> existingAssocs = null;
        RoleProfileType roleType = null;
        RoleProfile roleProfile = null;
        if (operation == 12 || operation == 13) {
            roleType = applicationRoleOrgUnitCalendarAssociation.getApplicationRole();
            roleProfile = new RoleProfile(roleType);
            existingAssocs = this.getApplicationRoleOrgUnitCalendarAssociation(ctx, roleProfile);
        }
        if (operation == 13 || operation == 14) {
            if (obj == null) {
                Object[] objs = new Object[]{applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId()};
                throw new BPMOrganizationException(70609, objs);
            }
            if (operation == 13 && existingAssocs != null && existingAssocs.size() > 0) {
                calRuleId = applicationRoleOrgUnitCalendarAssociation.getCalendarRuleId();
                ouId = applicationRoleOrgUnitCalendarAssociation.getOrganizationalUnitId();
                for (ApplicationRoleOrgUnitCalendarAssociation assoc : existingAssocs) {
                    if (applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId().equals(assoc.getApplicationRoleOrgUnitCalendarAssociationId())) continue;
                    if (assoc.getCalendarRuleId().equals(calRuleId) && assoc.getOrganizationalUnitId().equals(ouId)) {
                        Object[] objs = new Object[]{calRuleId, roleType.getName(), ouId};
                        throw new BPMOrganizationException(70681, objs);
                    }
                    if (!assoc.getOrganizationalUnitId().equals(ouId)) continue;
                    Object[] objs = new Object[]{calRuleId, roleType.getName(), ouId};
                    throw new BPMOrganizationException(70682, objs);
                }
            }
        } else if (operation == 12) {
            if (obj != null) {
                Object[] objs = new Object[]{applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId()};
                throw new BPMOrganizationException(70681, objs);
            }
            if (existingAssocs != null && existingAssocs.size() > 0) {
                calRuleId = applicationRoleOrgUnitCalendarAssociation.getCalendarRuleId();
                ouId = applicationRoleOrgUnitCalendarAssociation.getOrganizationalUnitId();
                for (ApplicationRoleOrgUnitCalendarAssociation assoc : existingAssocs) {
                    if (assoc.getCalendarRuleId().equals(calRuleId) && assoc.getOrganizationalUnitId().equals(ouId)) {
                        Object[] objs = new Object[]{calRuleId, roleType.getName(), ouId};
                        throw new BPMOrganizationException(70681, objs);
                    }
                    if (!assoc.getOrganizationalUnitId().equals(ouId)) continue;
                    Object[] objs = new Object[]{calRuleId, roleType.getName(), ouId};
                    throw new BPMOrganizationException(70682, objs);
                }
            }
        }
        if (operation == 12 || operation == 13) {
            Object[] objs;
            if (WorkflowUtil.isNull((String)applicationRoleOrgUnitCalendarAssociation.getCalendarRuleId())) {
                throw new BPMOrganizationException(70607, null);
            }
            BpmCalendarRule bpmCalendarRule = new BpmCalendarRule();
            bpmCalendarRule.setId(applicationRoleOrgUnitCalendarAssociation.getCalendarRuleId());
            bpmCalendarRule = (BpmCalendarRule)this.bpmOrganizationPersistency.readObject(ctx, bpmCalendarRule, unitOfWorkHolder);
            if (bpmCalendarRule == null) {
                objs = new Object[]{applicationRoleOrgUnitCalendarAssociation.getCalendarRuleId()};
                throw new BPMOrganizationException(70601, objs);
            }
            if (WorkflowUtil.isNull((String)applicationRoleOrgUnitCalendarAssociation.getOrganizationalUnitId())) {
                throw new BPMOrganizationException(70608, null);
            }
            BpmOrganizationalUnit bpmOrganizationalUnit = new BpmOrganizationalUnit();
            bpmOrganizationalUnit.setOrganizationalUnitId(applicationRoleOrgUnitCalendarAssociation.getOrganizationalUnitId());
            bpmOrganizationalUnit = (BpmOrganizationalUnit)this.bpmOrganizationPersistency.readObject(ctx, bpmOrganizationalUnit, unitOfWorkHolder);
            if (bpmOrganizationalUnit == null) {
                objs = new Object[]{applicationRoleOrgUnitCalendarAssociation.getOrganizationalUnitId()};
                throw new BPMOrganizationException(70602, objs);
            }
        }
    }

    private void setDefaults(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation, int operation, XMLGregorianCalendar calendar) throws BPMOrganizationException {
        if (applicationRoleOrgUnitCalendarAssociation == null) {
            return;
        }
        if (operation == 12 && WorkflowUtil.isNull((String)applicationRoleOrgUnitCalendarAssociation.getApplicationRoleOrgUnitCalendarAssociationId())) {
            applicationRoleOrgUnitCalendarAssociation.setApplicationRoleOrgUnitCalendarAssociationId(Util.getGuid());
        }
        if (operation == 12) {
            applicationRoleOrgUnitCalendarAssociation.setCreatedBy(ctx.getUser());
            if (ctx.getIdentityContext() != null) {
                applicationRoleOrgUnitCalendarAssociation.setCreatedByIdentityContext(ctx.getIdentityContext());
            } else {
                applicationRoleOrgUnitCalendarAssociation.setCreatedByIdentityContext(DEFAULT_REALM_NAME);
            }
            applicationRoleOrgUnitCalendarAssociation.setCreatedDate(calendar);
        }
        applicationRoleOrgUnitCalendarAssociation.setLastUpdatedBy(ctx.getUser());
        if (ctx.getIdentityContext() != null) {
            applicationRoleOrgUnitCalendarAssociation.setLastUpdatedByIdentityContext(ctx.getIdentityContext());
        } else {
            applicationRoleOrgUnitCalendarAssociation.setLastUpdatedByIdentityContext(DEFAULT_REALM_NAME);
        }
        applicationRoleOrgUnitCalendarAssociation.setLastUpdatedDate(calendar);
        if (applicationRoleOrgUnitCalendarAssociation.getApplicationRole().getIdentityContext() == null) {
            applicationRoleOrgUnitCalendarAssociation.getApplicationRole().setIdentityContext(DEFAULT_REALM_NAME);
        }
    }

    private List<ProcessMetadataSummary> getActiveOrRetiredProcessMetadataSummaryListForOU(List<ProcessMetadataSummary> processMetadataSummaryList, String organizationalUnitId) {
        ArrayList<ProcessMetadataSummary> pmsList = null;
        if (processMetadataSummaryList != null && processMetadataSummaryList.size() > 0 && organizationalUnitId != null && organizationalUnitId.length() > 0) {
            pmsList = new ArrayList<ProcessMetadataSummary>();
            for (int i = 0; i < processMetadataSummaryList.size(); ++i) {
                ProcessMetadataSummary p = processMetadataSummaryList.get(i);
                if (p.getStatus() == null || !p.getStatus().equals((Object)StatusEnum.ACTIVE) && !p.getStatus().equals((Object)StatusEnum.RETIRED) || p.getOrganizationalUnitId() == null || !p.getOrganizationalUnitId().equals(organizationalUnitId)) continue;
                pmsList.add(p);
            }
        }
        if (pmsList != null && !pmsList.isEmpty() && BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)this.getClass().getName(), (String)"getActiveOrRetiredProcessMetadataSummaryListForOU", (String)("\n The organizationalUnitId: " + organizationalUnitId + " is associated with active or retired processes: {" + this.getProcessNameList(pmsList) + "}"));
        }
        return pmsList;
    }

    private void addExtendedAppRolePropertyIfNonExistantForTypeRole(IBPMContext ctx, List<ParticipantProperties> properties, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        for (ParticipantProperties partProps : properties) {
            for (ParticipantProperty participantProp : partProps.getParticipantProperty()) {
                if (!"ESCALATIONPATH".equals(participantProp.getName()) && !"POTENTIAL_ASSIGNEE".equals(participantProp.getName()) || !ParticipantTypeEnum.APPROLE.equals((Object)partProps.getParticipant().getType())) continue;
                List<ParticipantProperty> list = null;
                if ("ESCALATIONPATH".equals(participantProp.getName())) {
                    list = this.searchExtendedUserProperties(ctx, "ESCALATIONPATH");
                } else if ("POTENTIAL_ASSIGNEE".equals(participantProp.getName())) {
                    list = this.searchExtendedUserProperties(ctx, "POTENTIAL_ASSIGNEE");
                }
                if (list == null || list.isEmpty()) {
                    ParticipantProperty partProp = this.objectFactory.createParticipantProperty();
                    partProp.setName(participantProp.getName());
                    partProp.setPropertyType(PropertyValueTypeEnum.FREEFORM_STRING.toString());
                    partProp.setCreatedBy(partProps.getCreatedBy());
                    partProp.setCreatedByIdentityContext(partProps.getCreatedByIdentityContext());
                    XMLGregorianCalendar todaysDateAndTime = AbstractPersistencyDriver.getXMLGregorianCalendar(Calendar.getInstance());
                    partProp.setCreatedDate(todaysDateAndTime);
                    partProp.setLastUpdatedBy(partProps.getLastUpdatedBy());
                    partProp.setLastUpdatedByIdentityContext(partProps.getLastUpdatedByIdentityContext());
                    partProp.setLastUpdatedDate(todaysDateAndTime);
                    this.extUserPropertiesPersistenceDriver.addProperty(partProp, unitOfWorkHolder);
                    if ("ESCALATIONPATH".equals(participantProp.getName())) {
                        isEscalationPathCreated = true;
                    } else if ("POTENTIAL_ASSIGNEE".equals(participantProp.getName())) {
                        isPotentialAssigneeCreated = true;
                    }
                }
                return;
            }
        }
    }

    private void validatePropertyValue(IBPMContext ctx, List<ParticipantProperties> properties) throws BPMOrganizationException {
        List value = null;
        for (ParticipantProperties partProps : properties) {
            for (ParticipantProperty participantProp : partProps.getParticipantProperty()) {
                if (!"ESCALATIONPATH".equals(participantProp.getName()) && (!"POTENTIAL_ASSIGNEE".equals(participantProp.getName()) || !ParticipantTypeEnum.APPROLE.equals((Object)partProps.getParticipant().getType())) || (value = participantProp.getValue()) == null || value.isEmpty()) continue;
                for (int i = 0; i < value.size(); ++i) {
                    BPMAppRole appRole;
                    IdentityType identityType = BPMServicesUtil.parseIdentityString((String)((String)value.get(i)));
                    if (identityType == null) {
                        Object[] objs = new Object[]{};
                        throw new BPMOrganizationException(70703, objs);
                    }
                    if (!"application_role".equals(identityType.getType()) || (appRole = this.getAppRoleForAppRoleName(identityType.getId(), ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value())) != null) continue;
                    Object[] objs = new Object[]{};
                    throw new BPMOrganizationException(70703, objs);
                }
            }
        }
    }

    private void clearCache(IBPMContext ctx, String appRoleName) {
        this.clearCache(ctx, appRoleName, null);
    }

    private void clearCache(IBPMContext ctx, String appRoleName, Participant participant) {
        VerificationService.clearCacheForUsers((IWorkflowContext)ctx, this.getUsersForCacheInvalidation(appRoleName, participant));
    }

    private Set<String> getUsersForCacheInvalidation(String appRoleName, Participant participant) {
        HashSet<String> userNames = new HashSet<String>();
        Set grantees = null;
        BPMAuthorizationService service = ServiceFactory.getAuthorizationServiceInstance();
        try {
            if (participant == null) {
                grantees = service.getGranteesToAppRole(appRoleName, ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value(), false);
            } else {
                if (((PrincipleRefType)participant.getValue()).getType().value().equalsIgnoreCase(ParticipantTypeEnum.USER.value())) {
                    userNames.add(((PrincipleRefType)participant.getValue()).getName());
                    return userNames;
                }
                if (((PrincipleRefType)participant.getValue()).getType().value().equalsIgnoreCase(ParticipantTypeEnum.GROUP.value())) {
                    grantees = service.getGranteesToGroup(((PrincipleRefType)participant.getValue()).getName(), false);
                } else if (((PrincipleRefType)participant.getValue()).getType().value().equalsIgnoreCase(ParticipantTypeEnum.APPROLE.value())) {
                    grantees = service.getGranteesToAppRole(((PrincipleRefType)participant.getValue()).getName(), ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value(), false);
                }
            }
            for (BPMIdentity bpmIdentity : grantees) {
                if (!(bpmIdentity instanceof BPMUser)) continue;
                BPMUser user = (BPMUser)bpmIdentity;
                userNames.add(user.getName());
            }
            return userNames;
        }
        catch (Exception e) {
            return new HashSet<String>();
        }
    }
}

