/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpm.services.common.BPMServicesUtil;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.AppRoleUtil;
import oracle.bpm.services.organization.impl.BPMCalendarHolidayService;
import oracle.bpm.services.organization.impl.BPMOrganizationService;
import oracle.bpm.services.organization.impl.BPMOrganizationUtil;
import oracle.bpm.services.organization.model.ApplicationContext;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociation;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociations;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.bpm.services.organization.model.ApplicationRoles;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.CalendarRules;
import oracle.bpm.services.organization.model.ChildOrganizationalUnitRetrievalModeTypeEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayRules;
import oracle.bpm.services.organization.model.LogicalPeopleGroup;
import oracle.bpm.services.organization.model.LogicalPeopleGroupList;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Organization;
import oracle.bpm.services.organization.model.OrganizationEntityTypeEnum;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.OrganizationalUnits;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantPropertiesList;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantPropertyList;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.RoleProfile;
import oracle.bpm.services.organization.model.RoleProfileType;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;
import oracle.bpm.services.organization.persistency.AbstractPersistencyDriver;
import oracle.bpm.services.organization.persistency.BPMOrganizationPersistency;
import oracle.bpm.services.organization.persistency.model.BpmAppRoleOuCalAssoc;
import oracle.bpm.services.organization.persistency.model.BpmOrganizationalUnit;
import oracle.security.jps.service.policystore.PolicyObjectAlreadyExistsException;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMIdentity;
import oracle.tip.pc.services.identity.BPMIdentityType;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;

public class BPMOrganizationImportExportService {
    private BPMOrganizationPersistency bpmOrganizationPersistency;
    private BPMOrganizationService bpmOrganizationService;
    private ObjectFactory objectFactory = new ObjectFactory();
    private static final String CLASS_NAME = "oracle.bpm.services.organization.impl.BPMOrganizationImportExportService";
    private static final int BPM_CREATE_OPERATION = 12;
    private static final int BPM_SELECT_OPERATION = 11;

    private BPMOrganizationImportExportService(BPMOrganizationService bpmOrgSrv) {
        this.bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
        this.bpmOrganizationService = bpmOrgSrv;
    }

    public static BPMOrganizationImportExportService getInstance(BPMOrganizationService bpmOrgSrv) {
        return new BPMOrganizationImportExportService(bpmOrgSrv);
    }

    public Organization importOrganization(IBPMContext ctx, Organization organization, boolean validateUsers) throws BPMOrganizationException {
        HashMap<String, Set<Participant>> existingAppRoleGrantsMap = new HashMap<String, Set<Participant>>();
        HashMap<String, Set<Participant>> newAppRoleGrantsMap = new HashMap<String, Set<Participant>>();
        boolean updateExistingObjects = false;
        try {
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 0, "STARTED IMPORT");
            this.bpmOrganizationService.validateBPMOperation(ctx, 12);
            Organization retOrganization = this.objectFactory.createOrganization();
            AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder = this.bpmOrganizationPersistency.getUnitOfWorkHolder(true);
            HolidayRules holidayRules = this.objectFactory.createHolidayRules();
            CalendarRules calendarRules = this.objectFactory.createCalendarRules();
            ParticipantPropertiesList participantPropertiesList = this.objectFactory.createParticipantPropertiesList();
            ParticipantPropertyList participantPropertyList = this.objectFactory.createParticipantPropertyList();
            ApplicationRoles appRoles = this.objectFactory.createApplicationRoles();
            ApplicationRoleOrgUnitCalendarAssociations associations = this.objectFactory.createApplicationRoleOrgUnitCalendarAssociations();
            OrganizationalUnits organizationalUnits = this.objectFactory.createOrganizationalUnits();
            LogicalPeopleGroupList logicalPeopleGroupList = this.objectFactory.createLogicalPeopleGroupList();
            HolidayRules retHolidayRules = this.objectFactory.createHolidayRules();
            CalendarRules retCalendarRules = this.objectFactory.createCalendarRules();
            ParticipantPropertiesList retParticipantPropertiesList = this.objectFactory.createParticipantPropertiesList();
            ParticipantPropertyList retParticipantPropList = this.objectFactory.createParticipantPropertyList();
            ApplicationRoles retAppRoles = this.objectFactory.createApplicationRoles();
            ApplicationRoleOrgUnitCalendarAssociations retAssociations = this.objectFactory.createApplicationRoleOrgUnitCalendarAssociations();
            OrganizationalUnits retOrganizationalUnits = this.objectFactory.createOrganizationalUnits();
            LogicalPeopleGroupList retLogicalPeopleGroupList = this.objectFactory.createLogicalPeopleGroupList();
            String processOrgUnitId = null;
            String processOrgUnitName = organization.getProcessOrganizationalUnitName();
            boolean isSetUpdateExistingObjects = false;
            try {
                processOrgUnitId = organization.getProcessOrganizationalUnitId();
                this.bpmOrganizationService.debugLog("importOrganization()", "process OrganizationalUnitId : " + processOrgUnitId);
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getProcessOrganizationalUnitId() failed", e);
            }
            try {
                isSetUpdateExistingObjects = organization.isSetUpdateExistingObjects();
                this.bpmOrganizationService.debugLog("importOrganization()", "UpdateExistingObjects flag is set");
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "Exceptions occured while trying to fetch UpdateExistingObjects flag", e);
            }
            try {
                if (isSetUpdateExistingObjects) {
                    updateExistingObjects = organization.isUpdateExistingObjects();
                }
                this.bpmOrganizationService.debugLog("importOrganization()", "UpdateExistingObjects set to : " + updateExistingObjects);
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "Exceptions occured while trying to fetch UpdateExistingObjects flag", e);
            }
            try {
                holidayRules = organization.getHolidayRules();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getHolidayRules() failed", e);
            }
            try {
                calendarRules = organization.getCalendarRules();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getCalendarRules() failed", e);
            }
            try {
                participantPropertiesList = organization.getParticipantPropertiesList();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getParticipantPropertiesList() failed", e);
            }
            try {
                participantPropertyList = organization.getParticipantPropertyList();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getParticipantPropertyList() failed", e);
            }
            try {
                appRoles = organization.getApplicationRoles();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getApplicationRoles() failed", e);
            }
            try {
                associations = organization.getApplicationRoleOrgUnitCalendarAssociations();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getApplicationRoleOrgUnitCalendarAssociations() failed", e);
            }
            try {
                organizationalUnits = organization.getOrganizationalUnits();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getOrganizationalUnits() failed", e);
            }
            try {
                logicalPeopleGroupList = organization.getLogicalPeopleGroupList();
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "getLogicalPeopleGroupList() failed", e);
            }
            try {
                BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Importing HolidayRules");
                if (holidayRules != null) {
                    retHolidayRules = this.importHolidayRules(ctx, holidayRules, validateUsers, updateExistingObjects, unitOfWorkHolder);
                }
                BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Holiday Rules imported successfully");
            }
            catch (Exception e) {
                if (e instanceof BPMOrganizationException) {
                    throw (BPMOrganizationException)((Object)e);
                }
                throw new BPMOrganizationException(e);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Importing CalendarRules");
            if (calendarRules != null) {
                retCalendarRules = this.importCalendarRules(ctx, calendarRules, validateUsers, updateExistingObjects, unitOfWorkHolder);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "CalendarRules imported successfully");
            try {
                if (participantPropertyList != null) {
                    retParticipantPropList = this.importParticipantProperty(ctx, participantPropertyList, updateExistingObjects, unitOfWorkHolder);
                }
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "errors while importing extended user properties", e);
                throw e;
            }
            try {
                if (participantPropertiesList != null) {
                    retParticipantPropertiesList = this.importPropertiesOnParticipants(ctx, participantPropertiesList, appRoles, unitOfWorkHolder);
                }
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "errors while importing user property assignments", e);
                throw e;
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Importing Application Roles");
            if (appRoles != null) {
                retAppRoles = this.importAppRoles(ctx, appRoles, validateUsers, updateExistingObjects, existingAppRoleGrantsMap, newAppRoleGrantsMap);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Application Roles imported successfully");
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Importing LogicalPeopleGroupList");
            if (logicalPeopleGroupList != null) {
                retLogicalPeopleGroupList = this.importLogicalPeopleGroupList(ctx, logicalPeopleGroupList, validateUsers, updateExistingObjects, unitOfWorkHolder);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "LogicalPeopleGroupList imported successfully");
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Importing Organizational Units");
            if (organizationalUnits != null) {
                retOrganizationalUnits = this.importOrgUnits(ctx, organizationalUnits, validateUsers, updateExistingObjects, unitOfWorkHolder);
            }
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Organizational Units imported successfully");
            try {
                if (associations != null) {
                    retAssociations = this.importAssociations(ctx, associations, updateExistingObjects, unitOfWorkHolder);
                }
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "errors while importing ApplicationRoleOrgUnitCalendarAssociations", e);
            }
            try {
                boolean validProcessOU = this.bpmOrganizationService.validate(ctx, processOrgUnitId, organizationalUnits.getOrganizationalUnit());
                if (!validProcessOU) {
                    throw new BPMOrganizationException(70626, new Object[]{processOrgUnitName, processOrgUnitId});
                }
            }
            catch (Exception e) {
                BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrganization", "invalid processOrganizationalUnitId : " + processOrgUnitId, e);
                if (e instanceof BPMOrganizationException) {
                    throw (BPMOrganizationException)((Object)e);
                }
                throw new BPMOrganizationException(e);
            }
            retOrganization.setOrganizationalUnits(retOrganizationalUnits);
            retOrganization.setApplicationRoles(retAppRoles);
            retOrganization.setHolidayRules(retHolidayRules);
            retOrganization.setCalendarRules(retCalendarRules);
            retOrganization.setApplicationRoleOrgUnitCalendarAssociations(retAssociations);
            retOrganization.setParticipantPropertyList(retParticipantPropList);
            retOrganization.setParticipantPropertiesList(retParticipantPropertiesList);
            unitOfWorkHolder.completed();
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 0, "IMPORT ENDED");
            return retOrganization;
        }
        catch (Exception e) {
            if (updateExistingObjects) {
                this.bpmOrganizationService.restoreExistingAppRoleGrants(ctx, newAppRoleGrantsMap, existingAppRoleGrantsMap);
            }
            if (e instanceof BPMOrganizationException) {
                throw (BPMOrganizationException)((Object)e);
            }
            throw new BPMOrganizationException(e);
        }
    }

    public Organization exportOrganization(IBPMContext ctx) throws BPMOrganizationException {
        try {
            this.bpmOrganizationService.validateBPMOperation(ctx, 11);
            Organization organization = this.objectFactory.createOrganization();
            OrganizationalUnits organizationalUnits = this.exportOrganizationalUnits(ctx);
            organization.setOrganizationalUnits(organizationalUnits);
            HolidayRules holidayRules = this.exportHolidayRules(ctx);
            organization.setHolidayRules(holidayRules);
            CalendarRules calendarRules = this.exportCalendarRules(ctx);
            organization.setCalendarRules(calendarRules);
            ApplicationRoleOrgUnitCalendarAssociations associations = this.exportApplicationRoleOrgUnitCalendarAssociations(ctx);
            organization.setApplicationRoleOrgUnitCalendarAssociations(associations);
            LogicalPeopleGroupList lpgList = this.exportLogicalPeopleGroups(ctx);
            organization.setLogicalPeopleGroupList(lpgList);
            ParticipantPropertyList participantPropertyList = this.exportParticipantPropertyList(ctx);
            organization.setParticipantPropertyList(participantPropertyList);
            ApplicationRoles applicationRoles = this.exportApplicationRoles(ctx);
            organization.setApplicationRoles(applicationRoles);
            ParticipantPropertiesList participantPropertiesList = this.exportParticipantPropertiesList(ctx);
            organization.setParticipantPropertiesList(participantPropertiesList);
            return organization;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private HolidayRules importHolidayRules(IBPMContext ctx, HolidayRules holidayRules, boolean validate, boolean updateExistingObjects, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        HolidayRules retHolidayRules = this.objectFactory.createHolidayRules();
        List holidayRuleList = new ArrayList();
        holidayRuleList = holidayRules.getHolidayRule();
        ArrayList<HolidayRule> retList = new ArrayList<HolidayRule>();
        if (holidayRuleList != null) {
            for (HolidayRule holidayRule : holidayRuleList) {
                try {
                    BPMCalendarHolidayService calSrv;
                    if (!this.isExistsHolidayRule(ctx, holidayRule, updateExistingObjects)) {
                        BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, holidayRule.getName());
                        calSrv = BPMCalendarHolidayService.getInstance();
                        calSrv.createHolidayRule(ctx, holidayRule, unitOfWorkHolder);
                        continue;
                    }
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "HolidayRule: " + holidayRule.getName() + " adlready exists");
                    if (!updateExistingObjects) continue;
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "updating HolidayRule: " + holidayRule.getName());
                    calSrv = BPMCalendarHolidayService.getInstance();
                    calSrv.updateHolidayRule(ctx, holidayRule);
                }
                catch (Exception e) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, holidayRule.getName() + " could not be processed due to : " + e.getMessage());
                    if (!validate) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importHolidayRules", "error while importing HolidayRule: " + holidayRule.getName(), e);
                        retList.add(holidayRule);
                        continue;
                    }
                    if (e instanceof BPMOrganizationException) {
                        throw (BPMOrganizationException)((Object)e);
                    }
                    throw new BPMOrganizationException(e);
                }
            }
        }
        if (retList != null) {
            retHolidayRules.getHolidayRule().addAll(retList);
        }
        return retHolidayRules;
    }

    private CalendarRules importCalendarRules(IBPMContext ctx, CalendarRules calendarRules, boolean validate, boolean updateExistingObjects, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        CalendarRules retCalendarRules = this.objectFactory.createCalendarRules();
        List calendarRuleList = new ArrayList();
        calendarRuleList = calendarRules.getCalendarRule();
        ArrayList<CalendarRule> retList = new ArrayList<CalendarRule>();
        if (calendarRuleList != null) {
            for (CalendarRule calendarRule : calendarRuleList) {
                try {
                    BPMCalendarHolidayService calSrv;
                    if (!this.isExistsCalendarRule(ctx, calendarRule, updateExistingObjects)) {
                        BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, calendarRule.getName());
                        calSrv = BPMCalendarHolidayService.getInstance();
                        calSrv.createCalendarRule(ctx, calendarRule, unitOfWorkHolder);
                        continue;
                    }
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "calendarRule: " + calendarRule.getName() + " adlready exists");
                    if (!updateExistingObjects) continue;
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "updating calendarRule: " + calendarRule.getName());
                    calSrv = BPMCalendarHolidayService.getInstance();
                    calSrv.updateCalendarRule(ctx, calendarRule);
                }
                catch (Exception e) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, calendarRule.getName() + " could not be processed due to : " + e.getMessage());
                    if (!validate) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importCalendarRules", "error while importing calendarRule: " + calendarRule.getName(), e);
                        retList.add(calendarRule);
                        continue;
                    }
                    if (e instanceof BPMOrganizationException) {
                        throw (BPMOrganizationException)((Object)e);
                    }
                    throw new BPMOrganizationException(e);
                }
            }
        }
        if (retList != null) {
            retCalendarRules.getCalendarRule().addAll(retList);
        }
        return retCalendarRules;
    }

    private ParticipantPropertyList importParticipantProperty(IBPMContext ctx, ParticipantPropertyList participantPropertyList, boolean updateExistingObjects, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        ParticipantPropertyList retParticipantPropertyList = this.objectFactory.createParticipantPropertyList();
        try {
            List propertyList = new ArrayList();
            propertyList = participantPropertyList.getParticipantProperty();
            ArrayList<ParticipantProperty> retList = new ArrayList<ParticipantProperty>();
            if (propertyList != null) {
                for (ParticipantProperty property : propertyList) {
                    try {
                        BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, property.getName());
                        if (!this.isExistsPP(ctx, property.getName())) {
                            this.bpmOrganizationService.createParticipantProperty(ctx, property, unitOfWorkHolder);
                            continue;
                        }
                        if (!updateExistingObjects) continue;
                        this.bpmOrganizationService.deleteParticipantProperty(ctx, property, true);
                        this.bpmOrganizationService.createParticipantProperty(ctx, property, unitOfWorkHolder);
                    }
                    catch (Exception e) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importParticipantProperty", "error importing ParticipantProperty: " + property.getName(), e);
                        retList.add(property);
                    }
                }
            }
            retParticipantPropertyList.getParticipantProperty().addAll(retList);
            return retParticipantPropertyList;
        }
        catch (Exception e) {
            BPMOrganizationUtil.errorLog(CLASS_NAME, "importParticipantProperty", "error importing ParticipantPropertyList", e);
            return retParticipantPropertyList;
        }
    }

    private ParticipantPropertiesList importPropertiesOnParticipants(IBPMContext ctx, ParticipantPropertiesList participantPropertiesList, ApplicationRoles appRoles, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        ParticipantPropertiesList retParticipantPropertiesList = this.objectFactory.createParticipantPropertiesList();
        try {
            List participantProperties = participantPropertiesList.getParticipantProperties();
            ArrayList<ParticipantProperties> retList = new ArrayList<ParticipantProperties>();
            for (ParticipantProperties pp : participantProperties) {
                try {
                    ArrayList<ParticipantProperties> ppList = new ArrayList<ParticipantProperties>();
                    ppList.add(pp);
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, pp.getParticipant().getName());
                    this.isEscalationPathValueValid(ctx, pp, appRoles);
                    this.bpmOrganizationService.setPropertiesOnParticipants(ctx, ppList, false, unitOfWorkHolder);
                }
                catch (Exception e) {
                    BPMOrganizationUtil.errorLog(CLASS_NAME, "importPropertiesOnParticipants", "error importing properties for participant: " + pp.getParticipant(), e);
                    retList.add(pp);
                }
            }
            retParticipantPropertiesList.getParticipantProperties().addAll(retList);
            return retParticipantPropertiesList;
        }
        catch (Exception e) {
            BPMOrganizationUtil.errorLog(CLASS_NAME, "importPropertiesOnParticipants", "error importing ParticipantPropertiesList", e);
            return retParticipantPropertiesList;
        }
    }

    private void isEscalationPathValueValid(IBPMContext ctx, ParticipantProperties pp, ApplicationRoles appRoles) throws BPMOrganizationException {
        List list = pp.getParticipantProperty();
        List value = null;
        List appRoleList = new ArrayList();
        if (appRoles != null) {
            appRoleList = appRoles.getApplicationRole();
        }
        boolean isAppRoleAvailable = false;
        for (ParticipantProperty partProp : list) {
            if (!"ESCALATIONPATH".equals(partProp.getName()) || (value = partProp.getValue()) == null || value.isEmpty()) continue;
            for (int i = 0; i < value.size(); ++i) {
                BPMAppRole appRole;
                IdentityType identityType = BPMServicesUtil.parseIdentityString((String)((String)value.get(i)));
                if (identityType == null) {
                    Object[] objs = new Object[]{};
                    throw new BPMOrganizationException(70703, objs);
                }
                if (!"application_role".equals(identityType.getType())) continue;
                for (ApplicationRoleType roleType : appRoleList) {
                    if (identityType.getId().equals(roleType.getName())) {
                        isAppRoleAvailable = true;
                        break;
                    }
                    isAppRoleAvailable = false;
                }
                if (isAppRoleAvailable || (appRole = this.bpmOrganizationService.getAppRoleForAppRoleName(identityType.getId(), ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value())) != null) continue;
                Object[] objs = new Object[]{};
                throw new BPMOrganizationException(70703, objs);
            }
        }
    }

    private ApplicationRoles importAppRoles(IBPMContext ctx, ApplicationRoles appRoles, boolean validate, boolean updateExistingObjects, Map<String, Set<Participant>> existingAppRoleGrantsMap, Map<String, Set<Participant>> newAppRoleGrantsMap) throws BPMOrganizationException {
        ApplicationRoles retAppRoles = this.objectFactory.createApplicationRoles();
        List appRoleList = new ArrayList();
        appRoleList = appRoles.getApplicationRole();
        ArrayList<ApplicationRoleType> retList = new ArrayList<ApplicationRoleType>();
        if (appRoleList != null && appRoleList.size() > 0) {
            for (ApplicationRoleType appRoleType : appRoleList) {
                try {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, appRoleType.getName());
                    this.insertAppRole(ctx, appRoleType, validate, updateExistingObjects, existingAppRoleGrantsMap, newAppRoleGrantsMap);
                }
                catch (Exception e) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, appRoleType.getName() + " could not be processed due to : " + e.getMessage());
                    if (!validate) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importAppRoles", "error in importing appRole: " + appRoleType.getName(), e);
                        retList.add(appRoleType);
                        continue;
                    }
                    if (e instanceof BPMOrganizationException) {
                        throw (BPMOrganizationException)((Object)e);
                    }
                    throw new BPMOrganizationException(e);
                }
            }
        }
        this.bpmOrganizationService.clearFullCache();
        if (retList != null && retList.size() > 0) {
            retAppRoles.getApplicationRole().addAll(retList);
        }
        return retAppRoles;
    }

    private LogicalPeopleGroupList importLogicalPeopleGroupList(IBPMContext ctx, LogicalPeopleGroupList logicalPeopleGroupList, boolean validate, boolean updateExistingObjects, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        ArrayList<LogicalPeopleGroup> retListOflogicalPeopleGroups = new ArrayList<LogicalPeopleGroup>();
        LogicalPeopleGroupList retLogicalPeopleGroupList = this.objectFactory.createLogicalPeopleGroupList();
        List logicalPeopleGroups = logicalPeopleGroupList.getLogicalPeopleGroup();
        if (logicalPeopleGroups != null) {
            for (LogicalPeopleGroup logicalPeopleGroup : logicalPeopleGroups) {
                try {
                    if (!this.isLogicalPeopleGroupExists(ctx, logicalPeopleGroup)) {
                        this.bpmOrganizationService.createLogicalPeopleGroup(ctx, logicalPeopleGroup, true, unitOfWorkHolder);
                        continue;
                    }
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "LogicalPeopleGroup " + logicalPeopleGroup.getName() + " alreadyExists");
                    if (!updateExistingObjects) continue;
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "updating LogicalPeopleGroup " + logicalPeopleGroup.getName());
                    this.bpmOrganizationService.updateLogicalPeopleGroup(ctx, logicalPeopleGroup, true);
                }
                catch (Exception e) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, logicalPeopleGroup.getName() + " could not be processed due to : " + e.getMessage());
                    if (!validate) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importLogicalPeopleGroupList", "Error while importing LogicalPeopleGroup " + logicalPeopleGroup.getName(), e);
                        retListOflogicalPeopleGroups.add(logicalPeopleGroup);
                        continue;
                    }
                    if (e instanceof BPMOrganizationException) {
                        throw (BPMOrganizationException)((Object)e);
                    }
                    throw new BPMOrganizationException(e);
                }
            }
        }
        if (retListOflogicalPeopleGroups.size() > 0) {
            retLogicalPeopleGroupList.getLogicalPeopleGroup().addAll(retListOflogicalPeopleGroups);
        }
        return retLogicalPeopleGroupList;
    }

    private OrganizationalUnits importOrgUnits(IBPMContext ctx, OrganizationalUnits organizationalUnits, boolean validateUsers, boolean updateExistingObjects, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        OrganizationalUnits retOrganizationalUnits = this.objectFactory.createOrganizationalUnits();
        List orgUnitList = new ArrayList();
        orgUnitList = organizationalUnits.getOrganizationalUnit();
        ArrayList<OrganizationalUnit> retList = new ArrayList<OrganizationalUnit>();
        if (orgUnitList != null) {
            for (OrganizationalUnit orgUnit : orgUnitList) {
                try {
                    if (!this.isOrgUnitExists(ctx, orgUnit, unitOfWorkHolder)) {
                        if (validateUsers) {
                            this.validateOUMembers(orgUnit);
                        }
                        BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, orgUnit.getOrganizationalUnitName());
                        this.bpmOrganizationService.createOrganizationalUnit(ctx, orgUnit, unitOfWorkHolder);
                        continue;
                    }
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "OrgUnit " + orgUnit.getOrganizationalUnitName() + " alreadyExists");
                    if (!updateExistingObjects) continue;
                    BPMOrganizationUtil.infoLog(CLASS_NAME, "importOrganization", "updating OrgUnit " + orgUnit.getOrganizationalUnitName());
                    this.bpmOrganizationService.updateOrganizationalUnit(ctx, orgUnit);
                }
                catch (Exception e) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, orgUnit.getOrganizationalUnitName() + " could not be processed due to : " + e.getMessage());
                    if (!validateUsers) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrgUnits", "Error while importing OrgUnit " + orgUnit.getOrganizationalUnitName(), e);
                        retList.add(orgUnit);
                        continue;
                    }
                    if (e instanceof BPMOrganizationException) {
                        throw (BPMOrganizationException)((Object)e);
                    }
                    throw new BPMOrganizationException(e);
                }
            }
        }
        if (retList != null) {
            retOrganizationalUnits.getOrganizationalUnit().addAll(retList);
        }
        return retOrganizationalUnits;
    }

    private ApplicationRoleOrgUnitCalendarAssociations importAssociations(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociations associations, boolean updateExistingObjects, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) throws BPMOrganizationException {
        ApplicationRoleOrgUnitCalendarAssociations retAssociations = this.objectFactory.createApplicationRoleOrgUnitCalendarAssociations();
        try {
            List appRoleOUCalAssocList = new ArrayList();
            appRoleOUCalAssocList = associations.getApplicationRoleOrgUnitCalendarAssociation();
            ArrayList<ApplicationRoleOrgUnitCalendarAssociation> retList = new ArrayList<ApplicationRoleOrgUnitCalendarAssociation>();
            if (appRoleOUCalAssocList != null) {
                for (ApplicationRoleOrgUnitCalendarAssociation association : appRoleOUCalAssocList) {
                    try {
                        if (!this.isAssociationExists(ctx, association)) {
                            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, association.getApplicationRoleOrgUnitCalendarAssociationId());
                            this.bpmOrganizationService.createApplicationRoleOrgUnitCalendarAssociation(ctx, association, unitOfWorkHolder);
                            continue;
                        }
                        BPMOrganizationUtil.debugLog(CLASS_NAME, "importOrganization", "ApplicationRoleOrgUnitCalendarAssociation " + association.getApplicationRoleOrgUnitCalendarAssociationId() + " already exists");
                    }
                    catch (Exception e) {
                        BPMOrganizationUtil.errorLog(CLASS_NAME, "importAssociations", "error while importing ApplicationRoleOrgUnitCalendarAssociation: " + association.getApplicationRoleOrgUnitCalendarAssociationId(), e);
                        retList.add(association);
                    }
                }
            }
            if (retList != null) {
                retAssociations.getApplicationRoleOrgUnitCalendarAssociation().addAll(retList);
            }
            return retAssociations;
        }
        catch (Exception e) {
            BPMOrganizationUtil.errorLog(CLASS_NAME, "importAssociations", "error while importing ApplicationRoleOrgUnitCalendarAssociations", e);
            return retAssociations;
        }
    }

    private boolean isOrgUnitExists(IBPMContext ctx, OrganizationalUnit organizationalUnit, AbstractPersistencyDriver.UnitOfWorkHolder unitOfWorkHolder) {
        try {
            BpmOrganizationalUnit bpmOrganizationalUnit = new BpmOrganizationalUnit();
            bpmOrganizationalUnit.setOrganizationalUnitId(organizationalUnit.getOrganizationalUnitId());
            Object obj = this.bpmOrganizationPersistency.readObject(ctx, bpmOrganizationalUnit, unitOfWorkHolder);
            if (obj == null) {
                return false;
            }
        }
        catch (BPMOrganizationException e) {
            return false;
        }
        return true;
    }

    private boolean isAssociationExists(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation association) throws BPMOrganizationException {
        try {
            Object associations = null;
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("id").equal((Object)association.getApplicationRoleOrgUnitCalendarAssociationId());
            Vector<Object> results = this.bpmOrganizationPersistency.executeQuery(ctx, BpmAppRoleOuCalAssoc.class, expression);
            return results != null && !results.isEmpty();
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private void validateOUMembers(OrganizationalUnit orgUnit) {
        try {
            List managedByMemberList = orgUnit.getManagedByMember();
            for (int i = 0; i < managedByMemberList.size(); ++i) {
                try {
                    boolean validMember = this.validateMember((MemberType)managedByMemberList.get(i));
                    if (validMember) continue;
                    managedByMemberList.remove(i);
                    --i;
                    continue;
                }
                catch (Exception e) {
                    BPMOrganizationUtil.errorLog(CLASS_NAME, "validateOUMembers", "OUMember " + ((MemberType)managedByMemberList.get(i)).getName() + " does not exist  in the identity store", e);
                    managedByMemberList.remove(i);
                    --i;
                }
            }
            List memberList = orgUnit.getMember();
            for (int i = 0; i < memberList.size(); ++i) {
                try {
                    boolean validMember = this.validateMember((MemberType)memberList.get(i));
                    if (validMember) continue;
                    memberList.remove(i);
                    --i;
                    continue;
                }
                catch (Exception e) {
                    BPMOrganizationUtil.errorLog(CLASS_NAME, "validateOUMembers", "OUMember " + ((MemberType)memberList.get(i)).getName() + " does not exist  in the identity store", e);
                    memberList.remove(i);
                    --i;
                }
            }
        }
        catch (Exception e) {
            BPMOrganizationUtil.errorLog(CLASS_NAME, "importOrgUnits", "exceptions while importing orgunits", e);
        }
    }

    private boolean validateMember(MemberType member) throws BPMOrganizationException {
        try {
            return AppRoleUtil.getInstance().validateMember(member);
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private boolean isLogicalPeopleGroupExists(IBPMContext ctx, LogicalPeopleGroup logicalPeopleGroup) throws BPMOrganizationException {
        List<LogicalPeopleGroup> listOfLogicalPeopleGroup = this.bpmOrganizationService.searchLogicalPeopleGroups(ctx, SearchModeTypeEnum.EQUALS, logicalPeopleGroup.getName(), 0, -1);
        return listOfLogicalPeopleGroup != null && listOfLogicalPeopleGroup.size() != 0;
    }

    private boolean insertAppRole(IBPMContext ctx, ApplicationRoleType appRoleType, boolean validate, boolean updateExistingObjects, Map<String, Set<Participant>> existingAppRoleGrantsMap, Map<String, Set<Participant>> newAppRoleGrantsMap) throws BPMOrganizationException {
        ApplicationContext appContext = this.objectFactory.createApplicationContext();
        String appCtx = appRoleType.getIdentityContext();
        if (appCtx == null) {
            appContext.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP);
        } else if (appCtx.equals(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP.value())) {
            appContext.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP);
        } else {
            appContext.setApplicationType(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP);
        }
        try {
            String roleId = BPMServicesUtil.getRoleId((ApplicationRoleType)appRoleType);
            this.bpmOrganizationService.createAppRoleInternal(ctx, appContext, roleId, appRoleType.getName(), appRoleType.getDescription(), appRoleType.isIsSystemRole());
            List membersList = appRoleType.getMember();
            if (membersList != null) {
                for (PrincipleRefType member : membersList) {
                    try {
                        boolean validParticipant = true;
                        if (validate) {
                            validParticipant = this.bpmOrganizationService.validateParticipant(new Participant(member));
                        }
                        if (!validParticipant) continue;
                        this.bpmOrganizationService.grantAppRoleToPrincipalInternal(ctx, appContext, roleId, new Participant(member));
                    }
                    catch (Exception e) {
                        BPMOrganizationUtil.infoLog(CLASS_NAME, "insertAppRole", "Exceptions occured  while granting appRole to principal, either role " + appRoleType.getName() + " is already granted to " + member.getName() + " or an error ocured while granting the role to principal, see logs for detailed information.");
                    }
                }
            }
        }
        catch (PolicyObjectAlreadyExistsException e) {
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, appRoleType.getName() + " already exists, hence ignored");
            if (updateExistingObjects) {
                this.bpmOrganizationService.populateExistingRoleGrants(ctx, appRoleType, appContext, existingAppRoleGrantsMap);
                this.bpmOrganizationService.populateNewRoleGrants(ctx, appRoleType, appContext, validate, newAppRoleGrantsMap);
            }
        }
        catch (Exception e) {
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 2, appRoleType.getName() + " could not be processed due to : " + e.getMessage());
            throw new BPMOrganizationException(e);
        }
        return true;
    }

    private OrganizationalUnits exportOrganizationalUnits(IBPMContext ctx) throws BPMOrganizationException {
        try {
            OrganizationalUnits organizationalUnits = this.objectFactory.createOrganizationalUnits();
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = null;
            expression = builder.get("parentOrganizationalUnit").equal(null);
            ArrayList<OrganizationalUnit> parentOrgUnitList = null;
            Vector<Object> v = this.bpmOrganizationPersistency.executeQuery(ctx, BpmOrganizationalUnit.class, expression);
            if (v.size() > 0) {
                parentOrgUnitList = new ArrayList<OrganizationalUnit>();
                for (int i = 0; i < v.size(); ++i) {
                    OrganizationalUnit orgUnit = (OrganizationalUnit)v.get(i);
                    parentOrgUnitList.add(orgUnit);
                }
            }
            if (parentOrgUnitList != null) {
                for (OrganizationalUnit parentOrgUnit : parentOrgUnitList) {
                    OrganizationalUnit orgUnit = this.bpmOrganizationService.getOrganizationalUnit(ctx, parentOrgUnit.getOrganizationalUnitId(), ChildOrganizationalUnitRetrievalModeTypeEnum.HIRERARCHY);
                    if (orgUnit == null) continue;
                    organizationalUnits.getOrganizationalUnit().add(orgUnit);
                }
            }
            return organizationalUnits;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private HolidayRules exportHolidayRules(IBPMContext ctx) throws BPMOrganizationException {
        try {
            HolidayRules holidayRules = this.objectFactory.createHolidayRules();
            List holidayRuleList = this.bpmOrganizationService.searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.HOLIDAY_RULE, SearchModeTypeEnum.LIKE, "%", 0, -1, null);
            if (holidayRuleList != null) {
                holidayRules.getHolidayRule().addAll(holidayRuleList);
            }
            return holidayRules;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private CalendarRules exportCalendarRules(IBPMContext ctx) throws BPMOrganizationException {
        try {
            CalendarRules calendarRules = this.objectFactory.createCalendarRules();
            List calendarRuleList = this.bpmOrganizationService.searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.CALENDAR_RULE, SearchModeTypeEnum.LIKE, "%", 0, -1, null);
            if (calendarRuleList != null) {
                calendarRules.getCalendarRule().addAll(calendarRuleList);
            }
            return calendarRules;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private ApplicationRoleOrgUnitCalendarAssociations exportApplicationRoleOrgUnitCalendarAssociations(IBPMContext ctx) throws BPMOrganizationException {
        try {
            ApplicationRoleOrgUnitCalendarAssociations associations = this.objectFactory.createApplicationRoleOrgUnitCalendarAssociations();
            List associationList = associations.getApplicationRoleOrgUnitCalendarAssociation();
            RoleProfileType appRoleProfileTypeForOracleBPMProcessRolesApp = this.objectFactory.createRoleProfileType();
            appRoleProfileTypeForOracleBPMProcessRolesApp.setName("%");
            appRoleProfileTypeForOracleBPMProcessRolesApp.setIdentityContext(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value());
            RoleProfile appRoleProfileForOracleBPMProcessRolesApp = new RoleProfile(appRoleProfileTypeForOracleBPMProcessRolesApp);
            List<ApplicationRoleOrgUnitCalendarAssociation> associationsListForRolesInOracleBPMProcessRolesApp = this.bpmOrganizationService.getApplicationRoleOrgUnitCalendarAssociation(ctx, appRoleProfileForOracleBPMProcessRolesApp);
            RoleProfileType appRoleProfileTypeForOracleBPMComposerRolesApp = this.objectFactory.createRoleProfileType();
            appRoleProfileTypeForOracleBPMComposerRolesApp.setName("%");
            appRoleProfileTypeForOracleBPMComposerRolesApp.setIdentityContext(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP.value());
            RoleProfile appRoleProfileForOracleBPMComposerRolesApp = new RoleProfile(appRoleProfileTypeForOracleBPMComposerRolesApp);
            List<ApplicationRoleOrgUnitCalendarAssociation> associationsListForRolesInOracleBPMComposerRolesApp = this.bpmOrganizationService.getApplicationRoleOrgUnitCalendarAssociation(ctx, appRoleProfileForOracleBPMComposerRolesApp);
            if (associationsListForRolesInOracleBPMProcessRolesApp != null) {
                associations.getApplicationRoleOrgUnitCalendarAssociation().addAll(associationsListForRolesInOracleBPMProcessRolesApp);
            }
            if (associationsListForRolesInOracleBPMComposerRolesApp != null) {
                associations.getApplicationRoleOrgUnitCalendarAssociation().addAll(associationsListForRolesInOracleBPMComposerRolesApp);
            }
            return associations;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private LogicalPeopleGroupList exportLogicalPeopleGroups(IBPMContext ctx) throws BPMOrganizationException {
        try {
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Export LogicalPeopleGroups begin");
            LogicalPeopleGroupList lpgList = this.objectFactory.createLogicalPeopleGroupList();
            List<LogicalPeopleGroup> list = this.bpmOrganizationService.searchLogicalPeopleGroups(ctx, SearchModeTypeEnum.LIKE, "%", 0, -1);
            if (list != null && list.size() > 0) {
                for (LogicalPeopleGroup lpg : list) {
                    BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Export found lpg: " + lpg.getName());
                    lpgList.getLogicalPeopleGroup().add(lpg);
                }
            }
            LogicalPeopleGroupList logicalPeopleGroupList = lpgList;
            return logicalPeopleGroupList;
        }
        catch (Exception e) {
            BPMOrganizationUtil.errorLog(CLASS_NAME, "exportLogicalPeopleGroups", null, e);
            throw new BPMOrganizationException(e);
        }
        finally {
            BPMOrganizationUtil.infoLogImportData(CLASS_NAME, 1, "Export LogicalPeopleGroups end");
        }
    }

    private ApplicationRoles exportApplicationRoles(IBPMContext ctx) throws BPMOrganizationException {
        try {
            ApplicationRoles applicationRoles = this.objectFactory.createApplicationRoles();
            List<ApplicationRoleType> appRoleListForProcessRoles = this.getAllAppRoles(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value());
            List<ApplicationRoleType> appRoleListForComposerRoles = this.getAllAppRoles(ApplicationContextTypeEnum.ORACLE_BPM_COMPOSER_ROLES_APP.value());
            if (appRoleListForProcessRoles != null) {
                applicationRoles.getApplicationRole().addAll(appRoleListForProcessRoles);
            }
            if (appRoleListForComposerRoles != null) {
                applicationRoles.getApplicationRole().addAll(appRoleListForComposerRoles);
            }
            return applicationRoles;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private ParticipantPropertyList exportParticipantPropertyList(IBPMContext ctx) throws BPMOrganizationException {
        try {
            ParticipantPropertyList participantPropertyList = this.objectFactory.createParticipantPropertyList();
            List<ParticipantProperty> propertyList = this.bpmOrganizationService.searchExtendedUserProperties(ctx, "*");
            if (propertyList != null) {
                participantPropertyList.getParticipantProperty().addAll(propertyList);
            }
            return participantPropertyList;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private ParticipantPropertiesList exportParticipantPropertiesList(IBPMContext ctx) throws BPMOrganizationException {
        try {
            ParticipantPropertiesList participantPropertiesList = this.objectFactory.createParticipantPropertiesList();
            List<ParticipantProperties> propertiesList = this.bpmOrganizationService.getAllAssignedParticipantProperties(ctx);
            if (propertiesList != null) {
                participantPropertiesList.getParticipantProperties().addAll(propertiesList);
            }
            return participantPropertiesList;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private List<ApplicationRoleType> getAllAppRoles(String appId) throws BPMOrganizationException {
        try {
            List<BPMAppRole> bpmAppRoleList = AppRoleUtil.getInstance().getAppRoles("*", appId);
            List<BPMAppRole> bpmSystemAppRoleList = AppRoleUtil.getInstance().getSystemAppRole(bpmAppRoleList, appId);
            ArrayList<ApplicationRoleType> appRoleTypeList = new ArrayList<ApplicationRoleType>();
            if (bpmAppRoleList != null) {
                for (BPMAppRole bpmAppRole : bpmAppRoleList) {
                    ApplicationRoleType appRoleType = this.objectFactory.createApplicationRoleType();
                    appRoleType.setName(bpmAppRole.getName());
                    appRoleType.setIdentityContext(appId);
                    if (bpmSystemAppRoleList.contains(bpmAppRole)) {
                        appRoleType.setIsSystemRole(true);
                    } else {
                        appRoleType.setIsSystemRole(false);
                    }
                    appRoleType.setDescription(bpmAppRole.getDescription());
                    Set<BPMIdentity> granteesList = AppRoleUtil.getInstance().getGrantees(bpmAppRole, true);
                    if (granteesList != null) {
                        for (BPMIdentity identity : granteesList) {
                            PrincipleRefType principleRefType = this.objectFactory.createPrincipleRefType();
                            principleRefType.setName(identity.getName());
                            if (identity.getIdentityType().equals((Object)BPMIdentityType.USER)) {
                                principleRefType.setType(ParticipantTypeEnum.USER);
                                principleRefType.setRealm(identity.getRealmName());
                            } else if (identity.getIdentityType().equals((Object)BPMIdentityType.GROUP)) {
                                principleRefType.setType(ParticipantTypeEnum.GROUP);
                                principleRefType.setRealm(identity.getRealmName());
                            } else if (identity.getIdentityType().equals((Object)BPMIdentityType.APPROLE)) {
                                principleRefType.setType(ParticipantTypeEnum.APPROLE);
                                principleRefType.setApplicationContext(appId);
                            }
                            appRoleType.getMember().add(principleRefType);
                        }
                    }
                    appRoleTypeList.add(appRoleType);
                }
            }
            return appRoleTypeList;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private boolean isExistsPP(IBPMContext ctx, String propertyName) throws BPMOrganizationException {
        try {
            List<ParticipantProperty> ppList = this.bpmOrganizationService.searchExtendedUserProperties(ctx, propertyName);
            return ppList != null && ppList.size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isExistsHolidayRule(IBPMContext ctx, HolidayRule holidayRule, boolean updateExistingObjects) throws BPMOrganizationException {
        List holidayRuleList = this.bpmOrganizationService.searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.HOLIDAY_RULE, SearchModeTypeEnum.EQUALS, holidayRule.getName(), 0, -1, null);
        if (holidayRuleList != null && holidayRuleList.size() > 0) {
            HolidayRule existingHolRule = (HolidayRule)holidayRuleList.get(0);
            if (!existingHolRule.getId().equals(holidayRule.getId())) {
                this.bpmOrganizationService.debugLog(CLASS_NAME, "holidayRule " + holidayRule.getName() + " already exists with different id");
                if (updateExistingObjects) {
                    throw new BPMOrganizationException(70697, new Object[]{existingHolRule.getId(), existingHolRule.getName()});
                }
            }
            return true;
        }
        return false;
    }

    private boolean isExistsCalendarRule(IBPMContext ctx, CalendarRule calendarRule, boolean updateExistingObjects) throws BPMOrganizationException {
        List calendarRuleList = this.bpmOrganizationService.searchOrganizationEntity(ctx, OrganizationEntityTypeEnum.CALENDAR_RULE, SearchModeTypeEnum.EQUALS, calendarRule.getName(), 0, -1, null);
        if (calendarRuleList != null && calendarRuleList.size() > 0) {
            CalendarRule existingCalRule = (CalendarRule)calendarRuleList.get(0);
            if (!existingCalRule.getId().equals(calendarRule.getId())) {
                this.bpmOrganizationService.debugLog(CLASS_NAME, "calendarRule " + calendarRule.getName() + " already exists with different id");
                if (updateExistingObjects) {
                    throw new BPMOrganizationException(70696, new Object[]{existingCalRule.getId(), existingCalRule.getName()});
                }
            }
            return true;
        }
        return false;
    }
}

