/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.task.IInternalOrganizationService;
import oracle.bpel.services.workflow.task.impl.Duration;
import oracle.bpel.services.workflow.task.impl.WorkflowInternalOrgSvcImpl;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.services.common.BPMServicesUtil;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.impl.BPMCalendarHolidayService;
import oracle.bpm.services.organization.impl.BPMOrganizationService;
import oracle.bpm.services.organization.impl.BPMOrganizationUtil;
import oracle.bpm.services.organization.impl.calendar.CalendarMgr;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.ChildOrganizationalUnitRetrievalModeTypeEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.OrganizationEntitySearchContext;
import oracle.bpm.services.organization.model.OrganizationEntityTypeEnum;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;
import oracle.bpm.services.organization.persistency.BPMOrganizationPersistency;
import oracle.bpm.services.organization.persistency.model.BpmCalendarRule;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMAuthorizationService;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMUser;
import oracle.tip.pc.services.identity.config.BPMConfigException;
import oracle.tip.pc.services.identity.config.ISConfiguration;
import oracle.toplink.sessions.DatabaseRecord;

public class BPMInternalOrganizationService
implements IInternalOrganizationService {
    private static final String CLASS_NAME = "oracle.bpm.services.organization.impl.BPMInternalOrganizationService";
    private static final BPMOrganizationService bpmOrganizationService = new BPMOrganizationService();

    public Duration getCalendarDuration(Task task, Calendar fromDate, Calendar toDate) {
        String METHOD = "getCalendarDuration";
        this.debugLog("getCalendarDuration", "Calculating business duration between 2 dates for the Task : " + task.getTitle() + " (" + task.getSystemAttributes().getTaskId() + ")" + ", From Date : " + fromDate + ", To Date : " + toDate);
        if (toDate == null || fromDate == null) {
            return null;
        }
        Duration retVal = null;
        try {
            IBPMContext ctx = BPMInternalOrganizationService.getInternalBPMContext();
            CalendarRule calRul = this.getCalendarRuleToUse(ctx, task);
            if (calRul != null) {
                HolidayRule holRul = this.getHolidayRuleToUse(ctx, calRul);
                CalendarMgr calMgr = new CalendarMgr(calRul, holRul);
                long longDuration = calMgr.getCalendarDuration(fromDate, toDate);
                retVal = new Duration(longDuration);
            }
        }
        catch (Exception e) {
            this.warningLog("getCalendarDuration", e);
        }
        if (retVal == null) {
            this.debugLog("getCalendarDuration", "Did not get any business calendar associated with the task. Proceeding with default calculation");
            WorkflowInternalOrgSvcImpl wfOrgSvc = new WorkflowInternalOrgSvcImpl();
            retVal = wfOrgSvc.getCalendarDuration(task, fromDate, toDate);
        }
        this.debugLog("getCalendarDuration", "Duration : " + toDate.getTime() + " - " + fromDate.getTime() + " = " + retVal);
        return retVal;
    }

    public Calendar addCalendarDuration(Task task, Calendar fromDate, Duration duration) {
        String METHOD = "addCalendarDuration";
        this.debugLog("addCalendarDuration", "Adding 'Duration' to 'From Date' for the Task : " + task.getTitle() + " (" + task.getSystemAttributes().getTaskId() + ")" + ", From Date : " + fromDate.getTime() + ", Duration : " + duration);
        if (fromDate == null || duration == null) {
            return null;
        }
        Calendar retVal = null;
        try {
            IBPMContext ctx = BPMInternalOrganizationService.getInternalBPMContext();
            CalendarRule calRul = this.getCalendarRuleToUse(ctx, task);
            if (calRul != null) {
                HolidayRule holRul = this.getHolidayRuleToUse(ctx, calRul);
                CalendarMgr calMgr = new CalendarMgr(calRul, holRul);
                retVal = calMgr.addCalendarDuration(fromDate, duration.getJavaxXMLDatatypeDuration());
            }
        }
        catch (Exception e) {
            this.warningLog("addCalendarDuration", e);
        }
        if (retVal == null) {
            this.debugLog("addCalendarDuration", "Did not get any business calendar associated with the task. Proceeding with default calculation");
            WorkflowInternalOrgSvcImpl wfOrgSvc = new WorkflowInternalOrgSvcImpl();
            retVal = wfOrgSvc.addCalendarDuration(task, fromDate, duration);
        }
        this.debugLog("addCalendarDuration", "Date after adding duration : " + fromDate.getTime() + " + " + duration + " = " + retVal.getTime());
        return retVal;
    }

    public Duration getNextReminderDurationFromAssignedDate(Task task, Calendar now, Calendar assignedDate, Duration duration, int recurrence) {
        String METHOD = "getNextReminderDurationFromAssignedDate";
        this.debugLog("getNextReminderDurationFromAssignedDate", "Calculating next reminder duration for the Task : " + task.getTitle() + " (" + task.getSystemAttributes().getTaskId() + ")" + ", Now : " + now.getTime() + ", assignedDate : " + assignedDate.getTime() + ", duration : " + duration + ", recurrence : " + recurrence);
        Duration retVal = null;
        try {
            IBPMContext ctx = BPMInternalOrganizationService.getInternalBPMContext();
            CalendarRule calRul = this.getCalendarRuleToUse(ctx, task);
            if (calRul != null) {
                HolidayRule holRul = this.getHolidayRuleToUse(ctx, calRul);
                CalendarMgr calMgr = new CalendarMgr(calRul, holRul);
                long longDuration = calMgr.getNextReminderDurationFromAssignedDate(now, assignedDate, duration.getJavaxXMLDatatypeDuration(), recurrence);
                retVal = new Duration(longDuration);
            }
        }
        catch (Exception e) {
            this.warningLog("getNextReminderDurationFromAssignedDate", e);
        }
        if (retVal == null) {
            this.debugLog("getNextReminderDurationFromAssignedDate", "Did not get any business calendar associated with the task. Proceeding with default calculation");
            WorkflowInternalOrgSvcImpl wfOrgSvc = new WorkflowInternalOrgSvcImpl();
            retVal = wfOrgSvc.getNextReminderDurationFromRelativeDate(task, now, assignedDate, duration, recurrence);
        }
        this.debugLog("getNextReminderDurationFromAssignedDate", "Next reminder duration : " + retVal);
        return retVal;
    }

    public Duration getNextReminderDurationFromRelativeDate(Task task, Calendar now, Calendar relativeDate, Duration duration, int recurrence) {
        String METHOD = "getNextReminderDurationFromRelativeDate";
        this.debugLog("getNextReminderDurationFromRelativeDate", "Task : " + task.getTitle() + " (" + task.getSystemAttributes().getTaskId() + ")" + ", Now : " + now.getTime() + ", relativeDate : " + relativeDate.getTime() + ", duration : " + duration + ", recurrence : " + recurrence);
        Duration retVal = null;
        try {
            IBPMContext ctx = BPMInternalOrganizationService.getInternalBPMContext();
            CalendarRule calRul = this.getCalendarRuleToUse(ctx, task);
            if (calRul != null) {
                HolidayRule holRul = this.getHolidayRuleToUse(ctx, calRul);
                CalendarMgr calMgr = new CalendarMgr(calRul, holRul);
                long longDuration = calMgr.getNextReminderDurationFromRelativeDate(now, relativeDate, duration.getJavaxXMLDatatypeDuration(), recurrence);
                retVal = new Duration(longDuration);
            }
        }
        catch (Exception e) {
            this.warningLog("getNextReminderDurationFromRelativeDate", e);
        }
        if (retVal == null) {
            this.debugLog("getNextReminderDurationFromRelativeDate", "Did not get any business calendar associated with the task. Proceeding with default calculation");
            WorkflowInternalOrgSvcImpl wfOrgSvc = new WorkflowInternalOrgSvcImpl();
            retVal = wfOrgSvc.getNextReminderDurationFromRelativeDate(task, now, relativeDate, duration, recurrence);
        }
        this.debugLog("getNextReminderDurationFromRelativeDate", "Next reminder duration : " + retVal);
        return retVal;
    }

    public String getAppRoleToUseForCalendarSearch(Task task) throws BPMIdentityException {
        IdentityType idType;
        String METHOD = "getAppRoleToUseForCalendarSearch";
        String appRoleToUse = null;
        List assignees = task.getSystemAttributes().getAssignees();
        if (assignees != null && assignees.size() == 1 && "application_role".equals((idType = (IdentityType)assignees.get(0)).getType())) {
            appRoleToUse = idType.getId();
            this.debugLog("getAppRoleToUseForCalendarSearch", "The task's assingee list contains just one AppRole : " + appRoleToUse + ". Hence using it.");
            return appRoleToUse;
        }
        String identityContext = task.getIdentityContext();
        BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance((String)identityContext);
        String acquiredByUser = task.getSystemAttributes().getAcquiredBy();
        if (assignees != null && !BPMInternalOrganizationService.isNull(acquiredByUser)) {
            this.debugLog("getAppRoleToUseForCalendarSearch", "The task's assingee list contains multiple users/groups/AppRoles, but the task is acquired by user : " + acquiredByUser + ", Hence trying to find out the AppRole of " + acquiredByUser + " within task's assignee list.");
            BPMUser bpmAcquiredByUser = as.lookupUser(acquiredByUser);
            String applicationContext = task.getApplicationContext();
            for (int i = 0; i < assignees.size(); ++i) {
                IdentityType idType2 = (IdentityType)assignees.get(i);
                if (!"application_role".equals(idType2.getType()) || !bpmAcquiredByUser.isInAppRole(idType2.getId(), applicationContext)) continue;
                appRoleToUse = idType2.getId();
                this.debugLog("getAppRoleToUseForCalendarSearch", "Found that " + acquiredByUser + " belongs to AppRole : " + appRoleToUse + ". Hence using it.");
                return appRoleToUse;
            }
        } else {
            this.debugLog("getAppRoleToUseForCalendarSearch", "The task's assingee list contains multiple users/groups/AppRoles, but not acquired by a user.Hence did not find AppRole to use for searching 'AppRole-Organizational Unit-Calendar' association.");
        }
        return appRoleToUse;
    }

    public String searchAppRoleGrantHirarchyBottomUpForCalendar(IBPMContext ctx, String applicationContext, BPMOrganizationService svc, String orgUnitId, String appRole) throws BPMOrganizationException, BPMIdentityException {
        String METHOD = "searchAppRoleGrantHirarchyBottomUpForCalendar";
        this.debugLog("searchAppRoleGrantHirarchyBottomUpForCalendar", "Searching 'AppRole-Organizational Unit-Calendar' association with (OrgUnit, AppRole) : (" + orgUnitId + ", " + appRole + ")");
        boolean direct = true;
        if (BPMInternalOrganizationService.isNull(orgUnitId) || BPMInternalOrganizationService.isNull(appRole)) {
            return null;
        }
        String calRulId = null;
        calRulId = this.getCalendarRuleIdForRole(ctx, applicationContext, orgUnitId, appRole);
        if (BPMInternalOrganizationService.isNull(calRulId)) {
            BPMAuthorizationService as = ServiceFactory.getAuthorizationServiceInstance();
            BPMAppRole bpmAppRole = as.lookupAppRole(appRole, applicationContext);
            List grantedRoles = bpmAppRole.getAppRoles(direct, applicationContext);
            this.debugLog("searchAppRoleGrantHirarchyBottomUpForCalendar", "Did not find any calendar associated. Hence would be searching the 'AppRole-Organizational Unit-Calendar' association using AppRoles : " + this.debugAppRoleString(grantedRoles) + ". These are the AppRoles to which AppRole : " + appRole + " belongs.");
            if (grantedRoles != null) {
                BPMAppRole role;
                Iterator i$ = grantedRoles.iterator();
                while (i$.hasNext() && BPMInternalOrganizationService.isNull(calRulId = this.searchAppRoleGrantHirarchyBottomUpForCalendar(ctx, applicationContext, svc, orgUnitId, (role = (BPMAppRole)i$.next()).getName()))) {
                }
            }
        }
        this.debugLog("searchAppRoleGrantHirarchyBottomUpForCalendar", "Found 'AppRole-Organizational Unit-Calendar' association (OrgUnit, AppRole, Calendar) : (" + orgUnitId + ", " + appRole + ", " + calRulId + ")");
        return calRulId;
    }

    public String searchOUTreeBottomUpForCalendar(IBPMContext ctx, BPMOrganizationService svc, String orgUnitId) throws BPMOrganizationException {
        String METHOD = "searchOUTreeBottomUpForCalendar";
        OrganizationalUnit ou = null;
        ou = svc.getOrganizationalUnit(ctx, orgUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
        if (ou == null) {
            this.debugLog("searchOUTreeBottomUpForCalendar", "Organizational Unit with ID " + orgUnitId + " not found.");
            return null;
        }
        this.setOrganizationalCalendar(ou);
        String calRulId = null;
        this.debugLog("searchOUTreeBottomUpForCalendar", "Considering Organization Unit : " + ou.getOrganizationalUnitName() + " (" + orgUnitId + ")");
        calRulId = ou.getCalendarRuleId();
        if (BPMInternalOrganizationService.isNull(calRulId)) {
            this.debugLog("searchOUTreeBottomUpForCalendar", "No Calendar found. Hence considering parent");
            String parentOrgUnitId = ou.getParentOrganizationalUnitId();
            if (!BPMInternalOrganizationService.isNull(parentOrgUnitId)) {
                calRulId = this.searchOUTreeBottomUpForCalendar(ctx, svc, parentOrgUnitId);
            } else {
                this.debugLog("searchOUTreeBottomUpForCalendar", "No Calendar was found in Organizational tree");
            }
        } else {
            this.debugLog("searchOUTreeBottomUpForCalendar", "Found Calendar : " + ou.getCalendarRuleName() + " (" + calRulId + ")");
        }
        return calRulId;
    }

    public void setOrganizationalCalendar(OrganizationalUnit ou) throws BPMOrganizationException {
        String METHOD = "setOrganizationalCalendar";
        StringBuffer sqlQuery = new StringBuffer("SELECT BPM_CALENDAR_RULE.ID, BPM_CALENDAR_RULE.NAME, BPM_CALENDAR_RULE.TIME_ZONE_ID from BPM_CALENDAR_RULE, BPM_ORGANIZATIONAL_UNIT where BPM_ORGANIZATIONAL_UNIT.CALENDAR_RULE_ID = BPM_CALENDAR_RULE.ID AND BPM_ORGANIZATIONAL_UNIT.ORGANIZATIONAL_UNIT_ID = '");
        sqlQuery.append(ou.getOrganizationalUnitId());
        sqlQuery.append("'");
        BPMOrganizationPersistency bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
        Vector<Object> childrens = bpmOrganizationPersistency.executeQuery(null, BpmCalendarRule.class, sqlQuery.toString());
        if (childrens != null && !childrens.isEmpty()) {
            CalendarRule calendarRule = (CalendarRule)childrens.get(0);
            ou.setCalendarRuleId(calendarRule.getId());
            ou.setCalendarRuleName(calendarRule.getName());
        }
    }

    public String getCalendarRuleIdForRole(IBPMContext ctx, String applicationContext, String orgUnitId, String appRole) throws BPMOrganizationException {
        String METHOD = "getCalendarRuleIdForRole";
        this.debugLog("getCalendarRuleIdForRole", "Finding Calendar associated with Organizational Unit : " + orgUnitId + " and AppRole : " + appRole);
        String sqlQuery = new StringBuffer("SELECT CALENDAR_RULE_ID from BPM_APP_ROLE_OU_CAL_ASSOC where APPLICATION_ROLE_NAME = '").append(appRole).append("' AND IDENTITY_CONTEXT = '").append(applicationContext).append("' AND ORGANIZATIONAL_UNIT_ID = '").append(orgUnitId).append("'").toString();
        BPMOrganizationPersistency bpmOrganizationPersistency = BPMOrganizationPersistency.getInstance();
        Vector<DatabaseRecord> appRoleOuObjs = bpmOrganizationPersistency.executeSQL(ctx, sqlQuery);
        String calendarId = null;
        if (appRoleOuObjs != null && !appRoleOuObjs.isEmpty()) {
            calendarId = (String)appRoleOuObjs.get(0).get("CALENDAR_RULE_ID");
        }
        this.debugLog("getCalendarRuleIdForRole", "Found Calendar with id : " + calendarId);
        return calendarId;
    }

    public List<String> getOrganizationalUnitForUser(BPMUser user, boolean direct) {
        ArrayList<String> allOrganizationalUnitIdList = new ArrayList<String>();
        try {
            List<OrganizationalUnit> queriedOrganizationalUnits = bpmOrganizationService.getOrganizationalUnitForUser(BPMInternalOrganizationService.getInternalBPMContext(), user, direct);
            if (queriedOrganizationalUnits != null && !queriedOrganizationalUnits.isEmpty()) {
                for (int index = 0; index < queriedOrganizationalUnits.size(); ++index) {
                    OrganizationalUnit queriedOrganizationalUnit = queriedOrganizationalUnits.get(index);
                    allOrganizationalUnitIdList.add(queriedOrganizationalUnit.getOrganizationalUnitId());
                }
            }
        }
        catch (BPMOrganizationException e) {
            e.printStackTrace();
        }
        return allOrganizationalUnitIdList;
    }

    public String searchByOUNameOrHierarchyPath(String inputString, String tasknumber) throws WorkflowException {
        OrganizationalUnit orgUnit;
        try {
            orgUnit = bpmOrganizationService.searchByOUNameOrHierarchyPath(BPMInternalOrganizationService.getInternalBPMContext(), inputString, tasknumber);
        }
        catch (BPMOrganizationException e) {
            WorkflowException wfe = new WorkflowException(40012, (Object[])new String[]{inputString, tasknumber}, (Throwable)e);
            throw wfe;
        }
        if (orgUnit != null) {
            return orgUnit.getOrganizationalUnitId();
        }
        throw new WorkflowException(40013, (Object[])new String[]{inputString});
    }

    public List<IdentityType> getAppRoleEscalationPathValueList(Task task, List<String> roleNames) {
        String METHOD = "getAppRoleEscalationPathValueList";
        this.debugLog("getAppRoleEscalationPathValueList", "Entered getAppRoleEscalationPathValue identityContext = " + task + " roleName = " + roleNames);
        ObjectFactory objFactory = new ObjectFactory();
        ArrayList<Participant> list = new ArrayList<Participant>();
        PrincipleRefType part = null;
        Participant participant = null;
        for (String roleId : roleNames) {
            part = objFactory.createPrincipleRefType();
            part.setName(roleId);
            part.setType(ParticipantTypeEnum.APPROLE);
            part.setRealm(task.getIdentityContext());
            participant = objFactory.createParticipant(part);
            list.add(participant);
        }
        List<Object> propertiesList = new ArrayList();
        IdentityType identityType = null;
        List value = new ArrayList();
        ArrayList<IdentityType> returnValue = new ArrayList<IdentityType>();
        try {
            propertiesList = bpmOrganizationService.getPropertiesOfParticipants(BPMInternalOrganizationService.getInternalBPMContext(), list);
        }
        catch (BPMOrganizationException e) {
            this.warningLog("getAppRoleEscalationPathValueList", (Exception)((Object)e));
            this.debugLog("getAppRoleEscalationPathValueList", "Error while retrieving ESCALATIONPATH " + e.getMessage());
        }
        List partPropertiesList = null;
        for (ParticipantProperties participantProperties : propertiesList) {
            partPropertiesList = participantProperties.getParticipantProperty();
            for (ParticipantProperty participantProperty : partPropertiesList) {
                if (!"ESCALATIONPATH".equalsIgnoreCase(participantProperty.getName())) continue;
                value = participantProperty.getValue();
                for (int i = 0; i < value.size(); ++i) {
                    identityType = BPMServicesUtil.parseIdentityString((String)((String)value.get(i)));
                    if (identityType == null) continue;
                    returnValue.add(identityType);
                }
            }
        }
        this.debugLog("getAppRoleEscalationPathValueList", "Exit identityType = " + returnValue);
        return returnValue;
    }

    public IdentityType getPotentialAssigneeForTask(Task task) {
        String METHOD = "getPotentialAssigneeForTask";
        this.debugLog("getPotentialAssigneeForTask", "Entered getPotentialAssigneeForTask Task = " + task.toString());
        String swimlaneRole = task.getSystemAttributes().getSwimlaneRole();
        String physicalRoleForSwimlaneRole = null;
        try {
            physicalRoleForSwimlaneRole = bpmOrganizationService.getPhysicalRoleForSwimlaneRole(BPMInternalOrganizationService.getInternalBPMContext(), swimlaneRole, task.getSca().getCompositeDN());
        }
        catch (Exception e) {
            this.warningLog("getPotentialAssigneeForTask", e);
            this.debugLog("getPotentialAssigneeForTask", "Error while obtaining physical role for swimlane role " + e.getMessage());
            return null;
        }
        if (physicalRoleForSwimlaneRole == null) {
            return null;
        }
        ObjectFactory objFactory = new ObjectFactory();
        PrincipleRefType part = null;
        Participant participant = null;
        part = objFactory.createPrincipleRefType();
        part.setName(physicalRoleForSwimlaneRole);
        part.setType(ParticipantTypeEnum.APPROLE);
        try {
            if (task.getIdentityContext() != null) {
                part.setRealm(task.getIdentityContext());
            } else {
                part.setRealm(ISConfiguration.getDefaultRealmName());
            }
        }
        catch (BPMConfigException e) {
            this.warningLog("getPotentialAssigneeForTask", (Exception)((Object)e));
            this.debugLog("getPotentialAssigneeForTask", "Error while retrieving Properties on Participant " + e.getMessage());
        }
        participant = objFactory.createParticipant(part);
        ArrayList<Participant> participantList = new ArrayList<Participant>();
        participantList.add(participant);
        List<ParticipantProperties> ppsList = null;
        try {
            ppsList = bpmOrganizationService.getPropertiesOfParticipants(BPMInternalOrganizationService.getInternalBPMContext(), participantList);
        }
        catch (BPMOrganizationException e) {
            this.warningLog("getPotentialAssigneeForTask", (Exception)((Object)e));
            this.debugLog("getPotentialAssigneeForTask", "Error while retrieving Properties on Participant " + e.getMessage());
            return null;
        }
        List partPropertiesList = null;
        for (ParticipantProperties partProps : ppsList) {
            if (!partProps.getParticipant().getName().equalsIgnoreCase(physicalRoleForSwimlaneRole)) continue;
            partPropertiesList = partProps.getParticipantProperty();
            for (ParticipantProperty partProp : partPropertiesList) {
                if (!"POTENTIAL_ASSIGNEE".equalsIgnoreCase(partProp.getName())) continue;
                List value = new ArrayList();
                value = partProp.getValue();
                IdentityType idType = BPMServicesUtil.parseIdentityString((String)((String)value.get(0)));
                return idType;
            }
        }
        return null;
    }

    public String getOrganizationalUnitNameHierarchyForUser(BPMUser user, boolean direct, String parentPath) throws BPMOrganizationException {
        String METHOD = "getOrganizationalUnitNameHierarchyForUser";
        String finalHierarchyPath = null;
        String hierarchyPathID = null;
        boolean isParentPathNotEmpty = parentPath != null && parentPath.trim().length() > 0;
        this.debugLog("getOrganizationalUnitNameHierarchyForUser", "parentPath = " + parentPath + " user = " + user.getName());
        OrganizationalUnit ou = null;
        if (isParentPathNotEmpty) {
            if (parentPath.charAt(parentPath.length() - 1) != '/') {
                parentPath = parentPath.concat("/");
            }
            ou = this.getOUFromOUNamePath(parentPath);
            this.debugLog("getOrganizationalUnitNameHierarchyForUser", "Leaf Org unit got based on parentPath = " + ou.getOrganizationalUnitName() + " id = " + ou.getOrganizationalUnitId());
            if (ou == null) {
                throw new BPMOrganizationException(70706, (Object[])new String[]{parentPath});
            }
            hierarchyPathID = ou.getHierarchyPath();
            this.debugLog("getOrganizationalUnitNameHierarchyForUser", "hierarchyPathID = " + hierarchyPathID);
        }
        List<OrganizationalUnit> queriedOrganizationalUnits = bpmOrganizationService.getOrganizationalUnitForUser(BPMInternalOrganizationService.getInternalBPMContext(), user, direct);
        int counter = 0;
        if (queriedOrganizationalUnits != null && !queriedOrganizationalUnits.isEmpty()) {
            for (int index = 0; index < queriedOrganizationalUnits.size(); ++index) {
                OrganizationalUnit queriedOrganizationalUnit = queriedOrganizationalUnits.get(index);
                String path = queriedOrganizationalUnit.getHierarchyPath();
                String namePath = null;
                if ((queriedOrganizationalUnits.size() != 1 || isParentPathNotEmpty) && (hierarchyPathID == null || hierarchyPathID.trim().length() <= 0 || hierarchyPathID.equals("") || !path.startsWith(hierarchyPathID))) continue;
                this.debugLog("getOrganizationalUnitNameHierarchyForUser", "path = " + path);
                String pathRelativeToParent = this.getRelativePathToParentPath(hierarchyPathID, path);
                this.debugLog("getOrganizationalUnitNameHierarchyForUser", "pathRelativeToParent = " + pathRelativeToParent);
                if (pathRelativeToParent != null && pathRelativeToParent.trim().length() != 0) {
                    namePath = this.getOUNamePathFromOUIdPath(queriedOrganizationalUnit, pathRelativeToParent);
                    this.debugLog("getOrganizationalUnitNameHierarchyForUser", "name path got after converting from id to name  = " + namePath);
                } else if (pathRelativeToParent == null) {
                    namePath = this.getOUNamePathFromOUIdPath(queriedOrganizationalUnit, path);
                } else if (pathRelativeToParent.trim().length() == 0) {
                    namePath = "";
                }
                finalHierarchyPath = namePath != null && namePath.trim().length() > 0 ? (!isParentPathNotEmpty ? namePath : parentPath.concat(namePath)) : parentPath;
                ++counter;
                this.debugLog("getOrganizationalUnitNameHierarchyForUser", "The hierarchy formed = " + finalHierarchyPath);
            }
        }
        this.debugLog("getOrganizationalUnitNameHierarchyForUser", "The final hierarchy formed = " + finalHierarchyPath);
        if (counter == 1) {
            return finalHierarchyPath;
        }
        throw new BPMOrganizationException(70704, (Object[])new String[]{user.getName()});
    }

    public String getParentOrgUnitForChild(String childUnit) throws BPMOrganizationException {
        String METHOD = "getParentOrgUnitForChild";
        OrganizationalUnit ou = null;
        String parentOrgUnit = null;
        if (childUnit == null) {
            return null;
        }
        this.debugLog("getParentOrgUnitForChild", "Getting the organization unit with name " + childUnit);
        ou = bpmOrganizationService.searchByOUNameOrHierarchyPath(BPMInternalOrganizationService.getInternalBPMContext(), childUnit, null);
        parentOrgUnit = this.getOUNamePathFromOUIdPath(ou, ou.getHierarchyPath());
        this.debugLog("getParentOrgUnitForChild", "Getting Parent Organization Unit Absolute Path ");
        parentOrgUnit = parentOrgUnit.replace(childUnit + "/", "");
        this.debugLog("getParentOrgUnitForChild", "Parent Organization Unit [Absolute Path] for Organization Unit " + childUnit + " is " + parentOrgUnit);
        return parentOrgUnit;
    }

    public List<String> getOrgUnitsIdForAppRole(String appRoleName, String identityContext) {
        String METHOD = "getOrgUnitsIdForAppRole";
        ArrayList<String> orgUnitIdList = new ArrayList<String>();
        try {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrgUnitsIdForAppRole", "Begin");
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrgUnitsIdForAppRole", "Parameters:");
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrgUnitsIdForAppRole", "appRoleName:" + appRoleName);
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrgUnitsIdForAppRole", "identityContext:" + identityContext);
            }
            List<OrganizationalUnit> orgUnitList = bpmOrganizationService.getOrganizationalUnitForAppRoleInternal(BPMInternalOrganizationService.getInternalBPMContext(), appRoleName, identityContext);
            for (OrganizationalUnit orgUnit : orgUnitList) {
                orgUnitIdList.add(orgUnit.getOrganizationalUnitId());
            }
        }
        catch (BPMOrganizationException e) {
            e.printStackTrace();
        }
        return orgUnitIdList;
    }

    public List<String> getOrgUnitsIdForGroup(String groupName) {
        String METHOD_NAME = "getOrgUnitsIdForGroup";
        ArrayList<String> orgUnitIdList = new ArrayList<String>();
        try {
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrgUnitsIdForGroup", "Begin");
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrgUnitsIdForGroup", "Parameters:");
                BPMOrganizationUtil.debugLog(CLASS_NAME, "getOrgUnitsIdForGroup", "appRoleName:" + groupName);
            }
            List<OrganizationalUnit> orgUnitList = bpmOrganizationService.getOrganizationalUnitForGroup(BPMInternalOrganizationService.getInternalBPMContext(), groupName);
            orgUnitIdList = new ArrayList();
            for (OrganizationalUnit orgUnit : orgUnitList) {
                orgUnitIdList.add(orgUnit.getOrganizationalUnitId());
            }
        }
        catch (BPMOrganizationException e) {
            e.printStackTrace();
        }
        return orgUnitIdList;
    }

    private static IBPMContext getInternalBPMContext() throws BPMOrganizationException {
        try {
            IBPMContext ctx = (IBPMContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return ctx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw new BPMOrganizationException(orgEx);
            }
            throw new BPMOrganizationException((Exception)pae);
        }
    }

    private static boolean isNull(String str) {
        return str == null || str.trim().equals("");
    }

    private CalendarRule getCalendarRuleToUse(IBPMContext ctx, Task task) throws BPMOrganizationException {
        String METHOD = "getCalendarRuleToUse";
        this.debugLog("getCalendarRuleToUse", "Finding Business Calendar to use.");
        CalendarRule calRul = null;
        String orgUnitId = task.getSystemAttributes().getOrganizationalUnitId();
        String appRoleToUse = null;
        try {
            this.debugLog("getCalendarRuleToUse", "Finding the AppRole to use for searching 'AppRole-Organizational Unit-Calendar' association.");
            appRoleToUse = this.getAppRoleToUseForCalendarSearch(task);
        }
        catch (Exception e) {
            this.warningLog("getCalendarRuleToUse", e);
            this.debugLog("getCalendarRuleToUse", "Could not determine the Approle to use for calendar search. Due to exception :" + e.getMessage());
        }
        String calRulId = null;
        if (!BPMInternalOrganizationService.isNull(appRoleToUse) && !BPMInternalOrganizationService.isNull(orgUnitId)) {
            try {
                this.debugLog("getCalendarRuleToUse", "Searching 'AppRole-Organizational Unit-Calendar' association for Calendar associated with AppRole : " + appRoleToUse + ", and Organizational Unit : " + orgUnitId);
                calRulId = this.searchAppRoleGrantHirarchyBottomUpForCalendar(ctx, task.getApplicationContext(), bpmOrganizationService, orgUnitId, appRoleToUse);
            }
            catch (Exception e) {
                this.warningLog("getCalendarRuleToUse", e);
                this.debugLog("getCalendarRuleToUse", "Could not search AppRole Hirarchy for Calendar association due to exception : " + e.getMessage() + ". \n Continuing with Organizational tree search for Calendar association");
            }
        }
        if (BPMInternalOrganizationService.isNull(calRulId) && !BPMInternalOrganizationService.isNull(orgUnitId)) {
            try {
                this.debugLog("getCalendarRuleToUse", "Searching Organizational tree Hirarchy for Calendar association.");
                calRulId = this.searchOUTreeBottomUpForCalendar(ctx, bpmOrganizationService, orgUnitId);
            }
            catch (BPMOrganizationException boe) {
                this.warningLog("getCalendarRuleToUse", (Exception)((Object)boe));
                this.debugLog("getCalendarRuleToUse", "Could not search Organizational tree for Calendar association due to exception : " + boe.getMessage());
            }
        }
        if (!BPMInternalOrganizationService.isNull(calRulId)) {
            calRul = bpmOrganizationService.getCalendarRule(ctx, calRulId);
        }
        this.debugLog("getCalendarRuleToUse", "OUT : Calendar Rule Id : " + calRulId);
        return calRul;
    }

    private HolidayRule getHolidayRuleToUse(IBPMContext ctx, CalendarRule cal) throws BPMOrganizationException {
        String holRulId = cal.getHolidayRuleId();
        if (holRulId == null || holRulId.trim().equals("")) {
            return null;
        }
        return BPMCalendarHolidayService.getInstance().getHolidayRule(ctx, holRulId);
    }

    private void warningLog(String method, Exception e) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.WARNING)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.WARNING, (String)CLASS_NAME, (String)method, (Throwable)e);
        }
    }

    private void debugLog(String method, String msg) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)method, (String)msg);
        }
    }

    private String debugAppRoleString(List<BPMAppRole> grantedRoles) {
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG)) {
            if (grantedRoles == null) {
                return "None";
            }
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            for (BPMAppRole role : grantedRoles) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(role.getName());
            }
            return buf.toString();
        }
        return "null";
    }

    private OrganizationalUnit getOUFromOUNamePath(String ouPath) throws BPMOrganizationException {
        String[] parentPathArray = null;
        boolean isParentPathNotEmpty = ouPath != null && ouPath.trim().length() > 0;
        String METHOD = "getOUFromOUNamePath";
        this.debugLog("getOUFromOUNamePath", "parentPath = " + ouPath);
        OrganizationalUnit ou = null;
        if (isParentPathNotEmpty) {
            parentPathArray = ouPath.split("/");
            List OUList = bpmOrganizationService.searchOrganizationEntity(BPMInternalOrganizationService.getInternalBPMContext(), OrganizationEntityTypeEnum.ORGANIZATIONAL_UNIT, SearchModeTypeEnum.EQUALS, parentPathArray[0], 0, 0, OrganizationEntitySearchContext.ORGANIZATIONAL_UNIT_ROOT_ORGANIZATIONAL_UNIT);
            if (OUList != null && !OUList.isEmpty()) {
                ou = (OrganizationalUnit)OUList.get(0);
                this.debugLog("getOUFromOUNamePath", "root ou = " + ou.getOrganizationalUnitName() + " root id = " + ou.getOrganizationalUnitId());
                ou = this.getOrgUnitForNamePath(ou, ouPath, 1);
                this.debugLog("getOUFromOUNamePath", "leaf ou = " + ou.getOrganizationalUnitName() + " leaf id = " + ou.getOrganizationalUnitId() + " hierarchyPathID = " + ou.getHierarchyPath());
            }
        }
        return ou;
    }

    private OrganizationalUnit getOrgUnitForNamePath(OrganizationalUnit ou, String ouPath, int hierarchyLevel) throws BPMOrganizationException {
        boolean isParentPathNotEmpty = ouPath != null && ouPath.trim().length() > 0;
        List childOUs = null;
        String[] splits = isParentPathNotEmpty ? ouPath.split("/") : null;
        String METHOD = "getOrgUnitForNamePath";
        this.debugLog("getOrgUnitForNamePath", "hierarchyLevel = " + hierarchyLevel + " ouPath = " + ouPath + "Org Unit name = " + ou.getOrganizationalUnitName());
        if (hierarchyLevel >= splits.length) {
            return ou;
        }
        if (isParentPathNotEmpty && splits != null && splits.length > 0 && (childOUs = (ou = bpmOrganizationService.getOrganizationalUnit(BPMInternalOrganizationService.getInternalBPMContext(), ou.getOrganizationalUnitId(), ChildOrganizationalUnitRetrievalModeTypeEnum.ONLY_FIRST_LEVEL_CHILD)).getChildOrganizationalUnits()) != null && !childOUs.isEmpty()) {
            for (OrganizationalUnit childOU : childOUs) {
                if (!childOU.getOrganizationalUnitName().equalsIgnoreCase(splits[hierarchyLevel])) continue;
                ou = childOU;
                return this.getOrgUnitForNamePath(ou, ouPath, hierarchyLevel + 1);
            }
        }
        return null;
    }

    private String getOUNamePathFromOUIdPath(OrganizationalUnit ou, String path) throws BPMOrganizationException {
        StringBuilder fp = new StringBuilder();
        OrganizationalUnit tempUnit = null;
        String[] splits = path.split("/");
        for (int k = 0; k < splits.length; ++k) {
            if (splits[k].equals(ou.getOrganizationalUnitId())) {
                fp.append(ou.getOrganizationalUnitName()).append("/");
                continue;
            }
            if (splits[k].equals(ou.getParentOrganizationalUnitId())) {
                fp.append(ou.getParentOrganizationalUnitName()).append("/");
                continue;
            }
            tempUnit = bpmOrganizationService.getOrganizationalUnit(BPMInternalOrganizationService.getInternalBPMContext(), splits[k], ChildOrganizationalUnitRetrievalModeTypeEnum.NO_CHILD);
            fp.append(tempUnit.getOrganizationalUnitName()).append("/");
        }
        return fp.toString();
    }

    private String getRelativePathToParentPath(String parentHierarchyPath, String completeHierarchyPath) {
        this.debugLog("getRelativePathToParentPath", "parentHierarchyPath = " + parentHierarchyPath + " completeHierarchyPath = " + completeHierarchyPath);
        if (parentHierarchyPath == null || parentHierarchyPath.trim().length() == 0 || completeHierarchyPath == null || completeHierarchyPath.trim().length() == 0 || parentHierarchyPath.length() > completeHierarchyPath.length()) {
            return null;
        }
        if (parentHierarchyPath.equals(completeHierarchyPath)) {
            return "";
        }
        int lastIndexOfParentPathInCompleteHierarchyPath = completeHierarchyPath.lastIndexOf(parentHierarchyPath);
        return lastIndexOfParentPathInCompleteHierarchyPath != -1 ? completeHierarchyPath.substring(parentHierarchyPath.length()) : null;
    }
}

