/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.impl;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.model.ApplicationContext;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.organization.model.MemberType;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.Permission;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.security.jps.config.ExtendedProperty;
import oracle.security.jps.service.policystore.ApplicationPolicy;
import oracle.security.jps.service.policystore.ApplicationRoleAttributes;
import oracle.security.jps.service.policystore.ApplicationRoleInUseException;
import oracle.security.jps.service.policystore.PolicyObjectAlreadyExistsException;
import oracle.security.jps.service.policystore.PolicyObjectNotFoundException;
import oracle.security.jps.service.policystore.PolicyStoreException;
import oracle.security.jps.service.policystore.info.AppRoleEntry;
import oracle.security.jps.service.policystore.info.InfoFactory;
import oracle.security.jps.service.policystore.info.PermissionEntry;
import oracle.security.jps.service.policystore.info.PrincipalEntry;
import oracle.tip.pc.services.common.ServiceFactory;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMIdentity;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMPrincipal;
import oracle.tip.pc.services.identity.config.BPMIdentityConfigService;
import oracle.tip.pc.services.identity.config.ProviderCfg;
import oracle.tip.pc.services.identity.jps.JpsProvider;

public class AppRoleUtil {
    private static JpsProvider provider = null;
    private static final String BPM_SYSTEM_ROLE_SCOPE = "BPM-SYSTEM-ROLE";
    private static final String CLASS_NAME = "AppRoleUtil";
    private static AppRoleUtil sAppRoleUtil = new AppRoleUtil();

    private AppRoleUtil() {
    }

    public static AppRoleUtil getInstance() {
        return sAppRoleUtil;
    }

    public void createAppRole(ApplicationContext appCtx, String appRoleName, String displayName, String description, boolean isSystemRole) throws BPMIdentityException, PolicyObjectAlreadyExistsException, PolicyStoreException, PrivilegedActionException, Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"createAppRole", (String)("Called with:\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n displayName=" + displayName + "\n description=" + description));
        this.validateApplicationContext(appCtx);
        if (appRoleName == null) {
            throw new BPMOrganizationException(70631, new Object[]{appRoleName});
        }
        final JpsProvider jpsProvider = this.getJpsProvider();
        final String f_appId = jpsProvider.getAppicationIdByName(appCtx.getApplicationType().value());
        final String f_appRoleName = appRoleName;
        final String f_displayName = displayName;
        final String f_description = description;
        final boolean f_isSystemRole = isSystemRole;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ApplicationPolicy ap = jpsProvider.getPolicyStore().getApplicationPolicy(f_appId);
                    ExtendedProperty extProp = new ExtendedProperty();
                    if (f_isSystemRole) {
                        String attribute = ApplicationRoleAttributes.SCOPE.name();
                        ArrayList<String> values = new ArrayList<String>();
                        values.add(AppRoleUtil.BPM_SYSTEM_ROLE_SCOPE);
                        extProp.setProperty(attribute, values);
                    }
                    ap.createAppRole(f_appRoleName, f_displayName, f_description, extProp);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof PolicyObjectAlreadyExistsException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"createAppRole", (String)("\n appRoleName=" + f_appRoleName + " already exists within application context " + f_appId + " in the policy store, cannot create a duplicate entry."));
            } else if (e instanceof PolicyStoreException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"createAppRole", (String)("Policy store exception thrown while creating appRole :" + f_appRoleName));
            } else if (e instanceof BPMIdentityException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"createAppRole", (String)("\n appRoleName=" + f_appRoleName + " Identity Store exception occurred while creating app role."));
            } else {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"createAppRole", (String)("Privileged action exception while creating appRole :" + f_appRoleName));
            }
            throw e;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"createAppRole", (String)"Completed.");
    }

    public void removeAppRole(ApplicationContext appCtx, String appRoleName, boolean force) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeAppRole", (String)("Called with:\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n force=" + force));
        this.validateApplicationContext(appCtx);
        if (appRoleName == null) {
            throw new BPMOrganizationException(70631, new Object[]{appRoleName});
        }
        final JpsProvider jpsProvider = this.getJpsProvider();
        final String f_appId = jpsProvider.getAppicationIdByName(appCtx.getApplicationType().value());
        final String f_appRoleName = appRoleName;
        final boolean f_force = force;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ApplicationPolicy ap = jpsProvider.getPolicyStore().getApplicationPolicy(f_appId);
                    if (AppRoleUtil.this.checkIfSystemRole(ap, f_appRoleName)) {
                        throw new BPMOrganizationException(70699, new Object[]{f_appRoleName});
                    }
                    ap.removeAppRole(f_appRoleName, f_force);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ApplicationRoleInUseException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"removeAppRole", (String)("\n appRoleName=" + f_appRoleName + " is being used in the policy store, cannot delete the appRole. Set force flag to true to delete the appRole and all its references by force."));
                throw new BPMOrganizationException(70643, new Object[]{f_appRoleName, "removeAppRole"}, e);
            }
            if (e instanceof PolicyStoreException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"removeAppRole", (String)("Policy store exception thrown while removing appRole :" + f_appRoleName));
                throw new BPMOrganizationException(70637, new Object[]{f_appRoleName}, e);
            }
            if (e instanceof PolicyObjectNotFoundException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"removeAppRole", (String)("\n Attempted to delete appRole " + f_appRoleName + " which is not found in the policy store."));
                throw new BPMOrganizationException(70645, new Object[]{f_appRoleName}, e);
            }
            if (e instanceof NullPointerException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"removeAppRole", (String)("Null pointer exception thrown while trying to remove the appRole : " + f_appRoleName));
                throw new BPMOrganizationException(70648, new Object[]{"removeAppRole"}, e);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"removeAppRole", (String)("Privileged action exception thrown while removing appRole :" + f_appRoleName));
            throw new BPMOrganizationException(70642, new Object[]{"removeAppRole"}, (Exception)pae);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"removeAppRole", (String)"Completed.");
    }

    public void grantAppRoleToPrincipal(ApplicationContext appCtx, String appRoleName, Participant participant) throws PolicyObjectAlreadyExistsException, ApplicationRoleInUseException, PolicyObjectNotFoundException, PolicyStoreException, NullPointerException, PrivilegedActionException, Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)("Called with:\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n participant=" + participant));
        this.validateApplicationContextForAppRoleGrant(appCtx);
        if (appRoleName == null || participant == null) {
            throw new BPMOrganizationException(70631, new Object[]{appRoleName, participant});
        }
        final JpsProvider jpsProvider = this.getJpsProvider();
        final String f_appId = jpsProvider.getAppicationIdByName(appCtx.getApplicationType().value());
        final String f_appRoleName = appRoleName;
        final ApplicationContext f_appCtx = appCtx;
        final Participant f_participant = participant;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ApplicationPolicy ap = jpsProvider.getPolicyStore().getApplicationPolicy(f_appId);
                    if (f_appId.equals(ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value()) && ((PrincipleRefType)f_participant.getValue()).getType().value().equalsIgnoreCase(ParticipantTypeEnum.APPROLE.value()) && AppRoleUtil.this.checkIfSystemRole(ap, ((PrincipleRefType)f_participant.getValue()).getName())) {
                        throw new BPMOrganizationException(70708, new Object[]{((PrincipleRefType)f_participant.getValue()).getName(), f_appRoleName});
                    }
                    if (AppRoleUtil.this.checkIfSystemRole(ap, f_appRoleName)) {
                        throw new BPMOrganizationException(70700, new Object[]{((PrincipleRefType)f_participant.getValue()).getName(), ((PrincipleRefType)f_participant.getValue()).getType(), f_appRoleName});
                    }
                    BPMPrincipal bpmPrincipal = AppRoleUtil.this.getBPMPrincipal(f_appCtx, f_participant);
                    Principal principal = jpsProvider.getPrincipal(bpmPrincipal);
                    ap.addPrincipalToAppRole(principal, f_appRoleName);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof PolicyObjectAlreadyExistsException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)("\n appRoleName=" + f_appRoleName + " already granted to participant " + ((PrincipleRefType)f_participant.getValue()).getName() + " in the policy store, duplicate grant cannot be made."));
            } else if (e instanceof ApplicationRoleInUseException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)(" ApplicationRoleInUseException occured, appRole " + f_appRoleName + "is in use"));
            } else if (e instanceof PolicyObjectNotFoundException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)(" PolicyObjectNotFoundException occured,  appRole " + f_appRoleName + " or the principal " + ((PrincipleRefType)f_participant.getValue()).getName() + " is not found in the policy store"));
            } else if (e instanceof PolicyStoreException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)(" PolicyStoreException occurred, while granting appRole : " + f_appRoleName + " to " + ((PrincipleRefType)f_participant.getValue()).getName()));
            } else if (e instanceof NullPointerException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)("java.lang.NullPointerException thrown, while granting appRole : " + f_appRoleName + " to " + ((PrincipleRefType)f_participant.getValue()).getName()));
            } else {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)("PrivilegedActionException thrown, while granting appRole : " + f_appRoleName + " to " + ((PrincipleRefType)f_participant.getValue()).getName()));
            }
            throw e;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantAppRoleToPrincipal", (String)"Completed.");
    }

    public void revokeAppRoleFromPrincipal(ApplicationContext appCtx, String appRoleName, Participant participant) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokeAppRoleFromPrincipal", (String)("Called with:\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n participant=" + participant));
        this.validateApplicationContextForAppRoleGrant(appCtx);
        if (appRoleName == null || participant == null) {
            throw new BPMOrganizationException(70631, new Object[]{appRoleName, participant});
        }
        final JpsProvider jpsProvider = this.getJpsProvider();
        final String f_appId = jpsProvider.getAppicationIdByName(appCtx.getApplicationType().value());
        final String f_appRoleName = appRoleName;
        final ApplicationContext f_appCtx = appCtx;
        final Participant f_participant = participant;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ApplicationPolicy ap = jpsProvider.getPolicyStore().getApplicationPolicy(f_appId);
                    BPMPrincipal bpmPrincipal = AppRoleUtil.this.getBPMPrincipal(f_appCtx, f_participant);
                    Principal principal = jpsProvider.getPrincipal(bpmPrincipal);
                    ap.removePrincipalFromAppRole(principal, f_appRoleName);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ApplicationRoleInUseException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"revokeAppRoleFromPrincipal", (String)("\n appRole=" + f_appRoleName + " granted to principal " + ((PrincipleRefType)f_participant.getValue()).getName() + " is being used in the policy store, " + "cannot delete the appRole. Set force flag to true to delete the appRole grant " + "and all its references by force."));
                throw new BPMOrganizationException(70644, new Object[]{f_appRoleName, ((PrincipleRefType)f_participant.getValue()).getName(), "revokeAppRoleFromPrincipal"}, e);
            }
            if (e instanceof PolicyStoreException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"revokeAppRoleFromPrincipal", (String)("Policy store exception while removing appRole :" + f_appRoleName + " grant from principal " + ((PrincipleRefType)f_participant.getValue()).getName()));
                throw new BPMOrganizationException(70639, new Object[]{f_appRoleName, ((PrincipleRefType)f_participant.getValue()).getName()}, e);
            }
            if (e instanceof PolicyObjectNotFoundException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"revokeAppRoleFromPrincipal", (String)("\n appRole=" + f_appRoleName + "grant, granted to the principal " + ((PrincipleRefType)f_participant.getValue()).getName() + " is not found in the policy store."));
                throw new BPMOrganizationException(70645, new Object[]{f_appRoleName, ((PrincipleRefType)f_participant.getValue()).getName()}, e);
            }
            if (e instanceof NullPointerException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"revokeAppRoleFromPrincipal", (String)("Null pointer exception thrown while trying to revoke grant the appRole : " + f_appRoleName + " from principal " + ((PrincipleRefType)f_participant.getValue()).getName()));
                throw new BPMOrganizationException(70648, new Object[]{"revokeAppRoleFromPrincipal"}, e);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"revokeAppRoleFromPrincipal", (String)("Privileged action exception while removing appRole :" + f_appRoleName));
            throw new BPMOrganizationException(70642, new Object[]{"revokeAppRoleFromPrincipal"}, (Exception)pae);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokeAppRoleFromPrincipal", (String)"Completed.");
    }

    public void grantPermissionToAppRole(ApplicationContext appCtx, String appRoleName, Permission perm) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantPermissionToAppRole", (String)("Called with:\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n perm=" + perm));
        this.validateApplicationContext(appCtx);
        if (appRoleName == null || perm == null) {
            throw new BPMOrganizationException(70631, new Object[]{appRoleName, perm});
        }
        final JpsProvider jpsProvider = this.getJpsProvider();
        final String f_appId = jpsProvider.getAppicationIdByName(appCtx.getApplicationType().value());
        final String f_appRoleName = appRoleName;
        ApplicationContext f_appCtx = appCtx;
        final PermissionEntry f_permEntry = InfoFactory.newPermissionEntry((String)perm.getClassName(), (String)perm.getTargetName(), (String)perm.getActions());
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ApplicationPolicy ap = jpsProvider.getPolicyStore().getApplicationPolicy(f_appId);
                    List list = ap.searchAppRoles(f_appRoleName);
                    if (list != null && list.size() != 0) {
                        ArrayList<PrincipalEntry> principalEntryList = new ArrayList<PrincipalEntry>();
                        PrincipalEntry principalEntry = (PrincipalEntry)list.get(0);
                        principalEntryList.add(principalEntry);
                        ArrayList<PermissionEntry> permEntryList = new ArrayList<PermissionEntry>();
                        permEntryList.add(f_permEntry);
                        ap.grant(principalEntryList, null, permEntryList);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof PolicyObjectAlreadyExistsException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"grantPermissionToAppRole", (String)("\n appRole=" + f_appRoleName + " has already been granted the permission " + f_permEntry + " in the policy store, duplicate grant cannot be made."));
                throw new BPMOrganizationException(70635, new Object[]{f_appRoleName, f_permEntry}, e);
            }
            if (e instanceof PolicyStoreException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"grantPermissionToAppRole", (String)("Policy store exception while granting permission " + f_permEntry + " to appRole :" + f_appRoleName));
                throw new BPMOrganizationException(70640, new Object[]{f_permEntry, f_appRoleName}, e);
            }
            if (e instanceof PolicyObjectNotFoundException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"grantPermissionToAppRole", (String)("\n appRole=" + f_appRoleName + " or the permission " + f_permEntry + " is not found in the policy store."));
                throw new BPMOrganizationException(70645, new Object[]{f_appRoleName, f_permEntry}, e);
            }
            if (e instanceof NullPointerException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"grantPermissionToAppRole", (String)("Null pointer exception thrown while trying to grant permission " + f_permEntry + " to the appRole : " + f_appRoleName));
                throw new BPMOrganizationException(70648, new Object[]{"grantPermissionToAppRole"}, e);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"grantPermissionToAppRole", (String)("Privileged action exception while granting permission " + f_permEntry + " to  appRole :" + f_appRoleName));
            throw new BPMOrganizationException(70642, new Object[]{"grantPermissionToAppRole"}, (Exception)pae);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"grantPermissionToAppRole", (String)"Completed.");
    }

    public void revokePermissionFromAppRole(ApplicationContext appCtx, String appRoleName, Permission perm) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokePermissionFromAppRole", (String)("Called with:\n appCtx=" + appCtx + "\n appRoleName=" + appRoleName + "\n perm=" + perm));
        this.validateApplicationContext(appCtx);
        if (appRoleName == null || perm == null) {
            throw new BPMOrganizationException(70631, new Object[]{appRoleName, perm});
        }
        final JpsProvider jpsProvider = this.getJpsProvider();
        final String f_appId = jpsProvider.getAppicationIdByName(appCtx.getApplicationType().value());
        final String f_appRoleName = appRoleName;
        ApplicationContext f_appCtx = appCtx;
        final PermissionEntry f_permEntry = InfoFactory.newPermissionEntry((String)perm.getClassName(), (String)perm.getTargetName(), (String)perm.getActions());
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ApplicationPolicy ap = jpsProvider.getPolicyStore().getApplicationPolicy(f_appId);
                    List list = ap.searchAppRoles(f_appRoleName);
                    if (list != null && list.size() != 0) {
                        ArrayList<PrincipalEntry> principalEntryList = new ArrayList<PrincipalEntry>();
                        PrincipalEntry principalEntry = (PrincipalEntry)list.get(0);
                        principalEntryList.add(principalEntry);
                        ArrayList<PermissionEntry> permEntryList = new ArrayList<PermissionEntry>();
                        permEntryList.add(f_permEntry);
                        ap.revoke(principalEntryList, null, permEntryList);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof PolicyObjectAlreadyExistsException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"revokePermissionFromAppRole", (String)("\n appRoleName=" + f_appRoleName + " has already been granted the permission " + f_permEntry + " in the policy store, duplicate grant cannot be made."));
                throw new BPMOrganizationException(70635, new Object[]{f_appRoleName, f_permEntry}, e);
            }
            if (e instanceof PolicyObjectNotFoundException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"revokePermissionFromAppRole", (String)(" PolicyObjectNotFoundException occured,  appRole " + f_appRoleName + " or permission " + f_permEntry + " is not found in the policy store"));
                throw new BPMOrganizationException(70645, new Object[]{f_appRoleName, f_permEntry}, e);
            }
            if (e instanceof PolicyStoreException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"revokePermissionFromAppRole", (String)(" PolicyStoreException occurred, while revoking appRole : " + f_appRoleName + " permission " + f_permEntry));
                throw new BPMOrganizationException(70641, new Object[]{f_permEntry, f_appRoleName}, e);
            }
            if (e instanceof NullPointerException) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"revokePermissionFromAppRole", (String)("java.lang.NullPointerException thrown, while revoking appRole : " + f_appRoleName + " permission " + f_permEntry));
                throw new BPMOrganizationException(70648, new Object[]{"revokePermissionFromAppRole"}, e);
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"revokePermissionFromAppRole", (String)("PrivilegedActionException thrown, while revoking appRole : " + f_appRoleName + " permission " + f_permEntry));
            throw new BPMOrganizationException(70642, new Object[]{"revokePermissionFromAppRole"}, (Exception)pae);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"revokePermissionFromAppRole", (String)"Completed.");
    }

    public List<BPMAppRole> getAppRoles(String searchPattern, String appId) throws Exception {
        try {
            JpsProvider jpsProvider = this.getJpsProvider();
            List bpmAppRoleList = jpsProvider.searchAppRoles(searchPattern, appId);
            return bpmAppRoleList;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public boolean isMemberSystemRole(String bpmAppRole, String appId) throws Exception {
        return this.checkIfSystemRole(this.getApplicationPolicy(appId), bpmAppRole);
    }

    public List<BPMAppRole> getSystemAppRole(List<BPMAppRole> bpmAppRoleList, String appId) throws Exception {
        ApplicationPolicy ap = this.getApplicationPolicy(appId);
        ArrayList<BPMAppRole> bpmSystemRoleList = new ArrayList<BPMAppRole>();
        for (BPMAppRole appRole : bpmAppRoleList) {
            if (!this.checkIfSystemRole(ap, appRole.getName())) continue;
            bpmSystemRoleList.add(appRole);
        }
        return bpmSystemRoleList;
    }

    public Set<BPMIdentity> getGrantees(BPMAppRole bpmAppRole, boolean direct) throws Exception {
        try {
            JpsProvider jpsProvider = this.getJpsProvider();
            LinkedHashSet roleChain = new LinkedHashSet();
            Set granteesList = jpsProvider.getGrantees(bpmAppRole, direct, roleChain);
            return granteesList;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    public String getDefaultRealmName() {
        try {
            BPMIdentityConfigService service = ServiceFactory.getIdentityConfigServiceInstance();
            String realmName = service.getDefaultRealmName();
            return realmName;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Set<BPMIdentity> getGrantees(String appRoleName, boolean direct) throws Exception {
        try {
            JpsProvider jpsProvider = this.getJpsProvider();
            BPMAppRole appRole = jpsProvider.lookupAppRole(appRoleName, "OracleBPMProcessRolesApp");
            return this.getGrantees(appRole, direct);
        }
        catch (Exception e) {
            return new HashSet<BPMIdentity>();
        }
    }

    public boolean validateParticipant(Participant participant) throws Exception {
        try {
            JpsProvider jpsProvider = this.getJpsProvider();
            if (((PrincipleRefType)participant.getValue()).getType().value().equalsIgnoreCase(ParticipantTypeEnum.USER.value())) {
                jpsProvider.lookupUser(((PrincipleRefType)participant.getValue()).getName());
            } else if (((PrincipleRefType)participant.getValue()).getType().value().equalsIgnoreCase(ParticipantTypeEnum.GROUP.value())) {
                jpsProvider.lookupGroup(((PrincipleRefType)participant.getValue()).getName());
            } else if (((PrincipleRefType)participant.getValue()).getType().value().equalsIgnoreCase(ParticipantTypeEnum.APPROLE.value())) {
                String appName = ((PrincipleRefType)participant.getValue()).getApplicationContext();
                if (appName == null || appName.equals("")) {
                    appName = "OracleBPMProcessRolesApp";
                }
                jpsProvider.lookupAppRole(((PrincipleRefType)participant.getValue()).getName(), appName);
            } else {
                throw new BPMOrganizationException(70632, new Object[]{((PrincipleRefType)participant.getValue()).getName(), ((PrincipleRefType)participant.getValue()).getType()});
            }
            return true;
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"validateParticipant", (String)("Exception occured while lookup of participant " + ((PrincipleRefType)participant.getValue()).getName() + "of type:" + ((PrincipleRefType)participant.getValue()).getType() + "and possible cause of exception is :" + e.getMessage()));
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Throwable)e);
            return false;
        }
    }

    public boolean validateMember(MemberType member) throws Exception {
        try {
            JpsProvider jpsProvider = this.getJpsProvider();
            if (member.getType().value().equalsIgnoreCase(ParticipantTypeEnum.USER.value())) {
                jpsProvider.lookupUser(member.getName());
            } else if (member.getType().value().equalsIgnoreCase(ParticipantTypeEnum.GROUP.value())) {
                jpsProvider.lookupGroup(member.getName());
            } else if (member.getType().value().equalsIgnoreCase(ParticipantTypeEnum.APPROLE.value())) {
                String appName = member.getApplicationContext();
                if (appName == null || appName.equals("")) {
                    appName = "OracleBPMProcessRolesApp";
                }
                jpsProvider.lookupAppRole(member.getName(), appName);
            } else {
                throw new BPMOrganizationException(70632, new Object[]{member.getName(), member.getType()});
            }
            return true;
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ORGANIZATIONS_SERVICE, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"validateMember", (String)("member " + member.getName() + " does not exists in the identity/ policy store"));
            return false;
        }
    }

    private JpsProvider getJpsProvider() throws Exception {
        if (provider != null) {
            return provider;
        }
        BPMIdentityConfigService service = ServiceFactory.getIdentityConfigServiceInstance();
        String realmName = service.getDefaultRealmName();
        ProviderCfg conf = service.getConfiguration(realmName).getProviderCfg("Authorization");
        provider = (JpsProvider)JpsProvider.getInstance((ProviderCfg)conf);
        return provider;
    }

    private BPMPrincipal getBPMPrincipal(ApplicationContext appCtx, Participant participant) throws Exception {
        if (this.validateApplicationContextForAppRoleGrant(appCtx)) {
            JpsProvider jpsProvider = this.getJpsProvider();
            if (((PrincipleRefType)participant.getValue()).getType().value().equalsIgnoreCase(ParticipantTypeEnum.USER.value())) {
                return jpsProvider.getBPMUser(((PrincipleRefType)participant.getValue()).getName());
            }
            if (((PrincipleRefType)participant.getValue()).getType().value().equalsIgnoreCase(ParticipantTypeEnum.GROUP.value())) {
                return jpsProvider.getBPMGroup(((PrincipleRefType)participant.getValue()).getName());
            }
            if (((PrincipleRefType)participant.getValue()).getType().value().equalsIgnoreCase(ParticipantTypeEnum.APPROLE.value())) {
                return jpsProvider.lookupAppRole(((PrincipleRefType)participant.getValue()).getName(), appCtx.getApplicationType().value());
            }
            throw new BPMOrganizationException(70632, new Object[]{((PrincipleRefType)participant.getValue()).getName(), ((PrincipleRefType)participant.getValue()).getType()});
        }
        throw new BPMOrganizationException(70632, new Object[]{((PrincipleRefType)participant.getValue()).getName(), ((PrincipleRefType)participant.getValue()).getType()});
    }

    private boolean validateApplicationContext(ApplicationContext appCtx) throws BPMOrganizationException {
        if (appCtx != null && ("OracleBPMProcessRolesApp".equals(appCtx.getApplicationType().value()) || "OracleBPMComposerRolesApp".equals(appCtx.getApplicationType().value()))) {
            return true;
        }
        throw new BPMOrganizationException(70646, new Object[]{appCtx.getApplicationType().value()});
    }

    private boolean validateApplicationContextForAppRoleGrant(ApplicationContext appCtx) throws BPMOrganizationException {
        if (appCtx != null && ("OracleBPMProcessRolesApp".equals(appCtx.getApplicationType().value()) || "OracleBPMComposerRolesApp".equals(appCtx.getApplicationType().value()) || "soa-infra".equals(appCtx.getApplicationType().value()))) {
            return true;
        }
        throw new BPMOrganizationException(70646, new Object[]{appCtx.getApplicationType().value()});
    }

    private ApplicationPolicy getApplicationPolicy(String appId) throws Exception {
        try {
            final String f_appId = appId;
            ApplicationPolicy f_ap = (ApplicationPolicy)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ApplicationPolicy f_ap = AppRoleUtil.this.getJpsProvider().getPolicyStore().getApplicationPolicy(f_appId);
                    return f_ap;
                }
            });
            return f_ap;
        }
        catch (Exception e) {
            throw new BPMOrganizationException(e);
        }
    }

    private boolean checkIfSystemRole(ApplicationPolicy ap, String appRoleName) throws PolicyStoreException {
        String value;
        List values;
        AppRoleEntry appRoleEntry;
        ExtendedProperty extProperty;
        List approles = ap.searchAppRoles(appRoleName);
        return approles != null & approles.size() != 0 && (extProperty = (appRoleEntry = (AppRoleEntry)approles.get(0)).getExtendedAttributes()) != null && (values = extProperty.getProperty(ApplicationRoleAttributes.SCOPE.name())) != null && values.size() != 0 && (value = (String)values.get(0)).equalsIgnoreCase(BPM_SYSTEM_ROLE_SCOPE);
    }
}

